# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SourceRateLimit(UniversalBaseModel):
    """
    Complete source rate limit schema.
    """

    source_short_name: str = pydantic.Field()
    """
    Source identifier (e.g., 'google_drive', 'notion')
    """

    limit: int = pydantic.Field()
    """
    Maximum requests allowed per window
    """

    window_seconds: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time window in seconds (60=per minute, 86400=per day, etc.)
    """

    id: str
    organization_id: str
    created_at: dt.datetime
    modified_at: dt.datetime

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
