# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SourceRateLimitResponse(UniversalBaseModel):
    """
    Response schema with source metadata merged for UI display.
    """

    source_short_name: str
    rate_limit_level: typing.Optional[str] = pydantic.Field(default=None)
    """
    'org' (organization-wide), 'connection' (per-user), or None (not supported)
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Configured limit, None if not set
    """

    window_seconds: typing.Optional[int] = pydantic.Field(default=None)
    """
    Configured window, None if not set
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    DB record ID, None if not configured
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
