"""Top-level package interface for MalwareClassifier."""

# Re-export primary public API only (no config handling here)
from .MalwareClassifier import MalwareClassifier  # main classifier class
from .Logging import setup_logging, get_logger    # logging helpers

# Version handling via setuptools-scm:
# The file _version.py is auto-generated by setuptools-scm at build/install time.
try:
    from ._version import version as __version__
except Exception:  # pragma: no cover
    # Fallback when running from a plain source tree without a Git tag
    __version__ = "0.0.0"

__all__ = [
    "MalwareClassifier",
    "setup_logging",
    "get_logger",
    "__version__",
]
