# Community & Project Information

This document contains information about NOMOS project development, community participation, and acknowledgements.

## Roadmap

See the [open issues](https://github.com/dowhiledev/nomos/issues) for a list of proposed features and known issues.

- [Top Feature Requests](https://github.com/dowhiledev/nomos/issues?q=label%3Aenhancement+is%3Aopen+sort%3Areactions-%2B1-desc) (Add your votes using the 👍 reaction)
- [Top Bugs](https://github.com/dowhiledev/nomos/issues?q=is%3Aissue+is%3Aopen+label%3Abug+sort%3Areactions-%2B1-desc) (Add your votes using the 👍 reaction)
- [Newest Bugs](https://github.com/dowhiledev/nomos/issues?q=is%3Aopen+is%3Aissue+label%3Abug)

### Upcoming Features

- Enhanced Visual Flow Builder capabilities
- Additional LLM provider integrations
- Advanced monitoring and analytics
- Multi-language SDK support
- Enterprise deployment tools

## Support

If you have any questions or need help with NOMOS:

- [GitHub issues](https://github.com/dowhiledev/nomos/issues/new?assignees=&labels=question&template=04_SUPPORT_QUESTION.md&title=support%3A+) - For bug reports and feature requests
- Join our [community discussions](https://github.com/dowhiledev/nomos/discussions) - For general questions and community interaction
- Check our [documentation](docs/) - Comprehensive guides and examples

### Getting Help

1. **Check the documentation first** - Most questions are answered in our guides
2. **Search existing issues** - Your question might already be answered
3. **Provide context** - Include relevant code, error messages, and environment details
4. **Be respectful** - We're all here to help each other learn and build

## Project Assistance

If you want to say **thank you** or support active development of NOMOS:

- **Add a [GitHub Star](https://github.com/dowhiledev/nomos)** to the project
- **Tweet about NOMOS** and share your experiences
- **Write articles** about the project on [Dev.to](https://dev.to/), [Medium](https://medium.com/), or your personal blog
- **Share examples** of what you've built with NOMOS
- **Contribute code** or documentation improvements
- **Help others** in discussions and issue threads

Together, we can make NOMOS **better**!

### Ways to Contribute

- **Code contributions** - Bug fixes, new features, performance improvements
- **Documentation** - Improve guides, add examples, fix typos
- **Testing** - Report bugs, test new features, improve test coverage
- **Community** - Answer questions, share knowledge, help newcomers
- **Feedback** - Share your use cases, suggest improvements

## Contributing

Contributions are welcome! Please open issues or pull requests on GitHub.

First off, thanks for taking the time to contribute! Contributions are what make the open-source community such an amazing place to learn, inspire, and create. Any contributions you make will benefit everybody else and are **greatly appreciated**.

### Getting Started

1. **Fork the repository** on GitHub
2. **Clone your fork** locally
3. **Create a branch** for your changes
4. **Make your changes** and test them
5. **Submit a pull request** with a clear description

### Development Setup

```bash
# Clone your fork
git clone https://github.com/your-username/nomos.git
cd nomos

# Install development dependencies
pip install -e ".[dev]"

# Run tests
pytest

# Run linting
pre-commit run --all-files
```

### Contribution Guidelines

- **Follow the code style** - We use Black for Python formatting
- **Write tests** for new features and bug fixes
- **Update documentation** when needed
- **Keep commits focused** - One logical change per commit
- **Write clear commit messages** - Explain what and why, not just what

### Pull Request Process

1. **Update documentation** if you're changing functionality
2. **Add tests** for new features
3. **Ensure all tests pass** before submitting
4. **Update the changelog** if applicable
5. **Reference relevant issues** in your PR description

Please read our contribution guidelines (coming soon), and thank you for being involved!

## Authors & Contributors

For a full list of all authors and contributors, see [the contributors page](https://github.com/dowhiledev/nomos/contributors).

### Core Team

- **[chandralegend](https://github.com/chandralegend)** - Creator and lead maintainer

### Special Thanks

We appreciate all contributors who have helped shape NOMOS through code, documentation, testing, and feedback. Every contribution, no matter how small, makes a difference.

## License

This project is licensed under the **MIT License**.

### MIT License

```
Copyright (c) 2024 NOMOS Contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

See [LICENSE](../LICENSE) for more information.

## Acknowledgements

- **Inspired by the open-source LLM community** - The vibrant ecosystem of AI/ML tools and frameworks
- **Built with ❤️** by developers who believe in making AI accessible to everyone
- **Python ecosystem** - Built on the shoulders of giants like FastAPI, Pydantic, and many others
- **LLM providers** - OpenAI, Mistral, Google, and others for making powerful AI accessible
- **Open source community** - For countless libraries, tools, and inspiration

### Technology Stack

NOMOS is built using:

- **Python** - Core language and ecosystem
- **FastAPI** - Web framework for API endpoints
- **Pydantic** - Data validation and settings management
- **Docker** - Containerization and deployment
- **Redis/PostgreSQL** - Session storage options
- **OpenTelemetry** - Observability and tracing
- **TypeScript** - Client SDK development

### Inspiration

NOMOS draws inspiration from:

- **LangChain** - Framework design patterns and ecosystem approach
- **CrewAI** - Multi-agent collaboration concepts
- **Node-RED** - Visual programming interface inspiration
- **Zapier** - No-code workflow automation principles
