//==============================================================================
// BAR Layout Package - Generated Constants for PCILeech BAR Controller
// Generated by PCILeech Firmware Generator
//
// This package contains all the generated constants that replace Jinja2
// placeholders from the original template. These values are computed at
// generation time and provide a clean separation between template logic
// and RTL implementation.
//==============================================================================

`ifndef BAR_LAYOUT_PKG_SVH
`define BAR_LAYOUT_PKG_SVH

package bar_layout_pkg;

    // ========================================================================
    // BAR Configuration Constants
    // ========================================================================
    
    // BAR Aperture and Indexing
    localparam int BAR_APERTURE_SIZE = 65536;       // 64KB default
    localparam int BAR_INDEX = 0;                   // BAR0 default
    localparam int BAR_TYPE = 0;                    // 0=32-bit, 1=64-bit
    localparam bit BAR_PREFETCHABLE = 1'b0;         // Non-prefetchable
    
    // ========================================================================
    // MSI-X Configuration Constants
    // ========================================================================
    
    localparam int NUM_MSIX = 4;                    // Number of MSI-X vectors
    localparam int MSIX_TABLE_BIR = 0;              // Table BAR Index Register
    localparam logic [31:0] MSIX_TABLE_OFFSET = 32'h1000;  // 4KB offset
    localparam int MSIX_PBA_BIR = 0;                // PBA BAR Index Register
    localparam logic [31:0] MSIX_PBA_OFFSET = 32'h2000;    // 8KB offset
    
    // ========================================================================
    // PCILeech Memory Layout Constants
    // ========================================================================
    
    // Device Control Region (256 bytes)
    localparam logic [31:0] DEVICE_CTRL_BASE = 32'h00000000;
    localparam logic [31:0] DEVICE_CTRL_SIZE = 32'h00000100;
    
    // Status Registers (256 bytes)
    localparam logic [31:0] STATUS_REG_BASE = 32'h00000100;
    localparam logic [31:0] STATUS_REG_SIZE = 32'h00000100;
    
    // Data Buffer (512 bytes)
    localparam logic [31:0] DATA_BUFFER_BASE = 32'h00000200;
    localparam logic [31:0] DATA_BUFFER_SIZE = 32'h00000200;
    
    // Custom PIO Region (3KB)
    localparam logic [31:0] CUSTOM_REGION_BASE = 32'h00000400;
    localparam logic [31:0] CUSTOM_REGION_SIZE = 32'h00000C00;
    
    // ========================================================================
    // Device-Specific Timing Constants
    // ========================================================================
    
    localparam int READ_LATENCY = 4;                // Clock cycles
    localparam int WRITE_LATENCY = 2;               // Clock cycles
    localparam int BURST_LENGTH = 16;               // Transfers per burst
    localparam int INTER_BURST_GAP = 8;             // Cycles between bursts
    localparam int TIMEOUT_CYCLES = 1024;           // Timeout threshold
    
    // ========================================================================
    // Device Configuration Constants
    // ========================================================================
    
    // Feature enables
    localparam bit ENABLE_ERROR_INJECTION = 1'b0;      // Disable by default
    localparam bit ENABLE_PERFORMANCE_COUNTERS = 1'b1; // Enable by default
    localparam bit ENABLE_SIMULATION_SUPPORT = 1'b1;   // Enable by default
    
    // Device identification
    localparam logic [31:0] DEVICE_SIGNATURE = 32'hDEADBEEF;
    localparam logic [31:0] FIRMWARE_VERSION = 32'h00010000;  // v1.0.0
    
    // ========================================================================
    // Configuration Space Constants
    // ========================================================================
    
    // PCI Configuration Space values
    localparam logic [15:0] VENDOR_ID = 16'h1234;      // Default vendor ID
    localparam logic [15:0] DEVICE_ID = 16'h5678;      // Default device ID
    localparam logic [15:0] COMMAND_REG = 16'h0000;    // Command register
    localparam logic [15:0] STATUS_REG = 16'h0010;     // Status register
    localparam logic [7:0]  REVISION_ID = 8'h01;       // Revision ID
    localparam logic [23:0] CLASS_CODE = 24'h020000;   // Network controller
    
    // ========================================================================
    // Memory Region Size Calculations
    // ========================================================================
    
    // Calculate memory array sizes (in 32-bit words)
    localparam int DEVICE_CTRL_WORDS = DEVICE_CTRL_SIZE / 4;
    localparam int STATUS_REG_WORDS = STATUS_REG_SIZE / 4;
    localparam int DATA_BUFFER_WORDS = DATA_BUFFER_SIZE / 4;
    localparam int CUSTOM_REGION_WORDS = CUSTOM_REGION_SIZE / 4;
    
    // Address bit widths for indexing
    localparam int DEVICE_CTRL_ADDR_WIDTH = $clog2(DEVICE_CTRL_WORDS);
    localparam int STATUS_REG_ADDR_WIDTH = $clog2(STATUS_REG_WORDS);
    localparam int DATA_BUFFER_ADDR_WIDTH = $clog2(DATA_BUFFER_WORDS);
    localparam int CUSTOM_REGION_ADDR_WIDTH = $clog2(CUSTOM_REGION_WORDS);
    
    // ========================================================================
    // Configuration Structure Definitions
    // ========================================================================
    
    // BAR Configuration Structure
    typedef struct packed {
        logic [31:0] aperture_size;
        logic [2:0]  bar_index;
        logic        bar_type;          // 0=32-bit, 1=64-bit
        logic        prefetchable;
        logic [31:0] base_address;      // Runtime assigned
    } bar_config_t;
    
    // MSI-X Configuration Structure
    typedef struct packed {
        logic [10:0] num_vectors;       // Up to 2048 vectors
        logic [2:0]  table_bir;
        logic [31:0] table_offset;
        logic [2:0]  pba_bir;
        logic [31:0] pba_offset;
        logic        enable;
        logic        function_mask;
    } msix_config_t;
    
    // Timing Configuration Structure
    typedef struct packed {
        logic [15:0] read_latency;
        logic [15:0] write_latency;
        logic [15:0] burst_length;
        logic [15:0] inter_burst_gap;
        logic [15:0] timeout_cycles;
    } timing_config_t;
    
    // Device Configuration Structure
    typedef struct packed {
        logic [31:0] device_signature;
        logic [31:0] firmware_version;
        logic [15:0] vendor_id;
        logic [15:0] device_id;
        logic        enable_error_injection;
        logic        enable_perf_counters;
        logic        enable_simulation;
        logic [4:0]  reserved;
    } device_config_t;
    
    // ========================================================================
    // Default Configuration Constants
    // ========================================================================
    
    // Default BAR configuration
    localparam bar_config_t DEFAULT_BAR_CONFIG = '{
        aperture_size: BAR_APERTURE_SIZE,
        bar_index: BAR_INDEX[2:0],
        bar_type: BAR_TYPE[0],
        prefetchable: BAR_PREFETCHABLE,
        base_address: 32'h00000000
    };
    
    // Default MSI-X configuration
    localparam msix_config_t DEFAULT_MSIX_CONFIG = '{
        num_vectors: NUM_MSIX[10:0],
        table_bir: MSIX_TABLE_BIR[2:0],
        table_offset: MSIX_TABLE_OFFSET,
        pba_bir: MSIX_PBA_BIR[2:0],
        pba_offset: MSIX_PBA_OFFSET,
        enable: 1'b0,
        function_mask: 1'b0
    };
    
    // Default timing configuration
    localparam timing_config_t DEFAULT_TIMING_CONFIG = '{
        read_latency: READ_LATENCY[15:0],
        write_latency: WRITE_LATENCY[15:0],
        burst_length: BURST_LENGTH[15:0],
        inter_burst_gap: INTER_BURST_GAP[15:0],
        timeout_cycles: TIMEOUT_CYCLES[15:0]
    };
    
    // Default device configuration
    localparam device_config_t DEFAULT_DEVICE_CONFIG = '{
        device_signature: DEVICE_SIGNATURE,
        firmware_version: FIRMWARE_VERSION,
        vendor_id: VENDOR_ID,
        device_id: DEVICE_ID,
        enable_error_injection: ENABLE_ERROR_INJECTION,
        enable_perf_counters: ENABLE_PERFORMANCE_COUNTERS,
        enable_simulation: ENABLE_SIMULATION_SUPPORT,
        reserved: 5'b00000
    };
    
    // ========================================================================
    // Utility Functions for Address Decoding
    // ========================================================================
    
    // Check if address is within device control region
    function automatic logic is_device_ctrl_region(logic [31:0] addr);
        return (addr >= DEVICE_CTRL_BASE) && 
               (addr < (DEVICE_CTRL_BASE + DEVICE_CTRL_SIZE));
    endfunction
    
    // Check if address is within status register region
    function automatic logic is_status_reg_region(logic [31:0] addr);
        return (addr >= STATUS_REG_BASE) && 
               (addr < (STATUS_REG_BASE + STATUS_REG_SIZE));
    endfunction
    
    // Check if address is within data buffer region
    function automatic logic is_data_buffer_region(logic [31:0] addr);
        return (addr >= DATA_BUFFER_BASE) && 
               (addr < (DATA_BUFFER_BASE + DATA_BUFFER_SIZE));
    endfunction
    
    // Check if address is within custom PIO region
    function automatic logic is_custom_region(logic [31:0] addr);
        return (addr >= CUSTOM_REGION_BASE) && 
               (addr < (CUSTOM_REGION_BASE + CUSTOM_REGION_SIZE));
    endfunction
    
    // Check if address is within MSI-X table region
    function automatic logic is_msix_table_region(logic [31:0] addr);
        return (addr >= MSIX_TABLE_OFFSET) && 
               (addr < (MSIX_TABLE_OFFSET + NUM_MSIX * 16));
    endfunction
    
    // Check if address is within MSI-X PBA region
    function automatic logic is_msix_pba_region(logic [31:0] addr);
        return (addr >= MSIX_PBA_OFFSET) && 
               (addr < (MSIX_PBA_OFFSET + ((NUM_MSIX + 31) / 32) * 4));
    endfunction
    
    // Calculate region offset
    function automatic logic [31:0] get_region_offset(
        logic [31:0] addr,
        logic [31:0] base_addr
    );
        return addr - base_addr;
    endfunction
    
    // ========================================================================
    // Configuration Space Register Map
    // ========================================================================
    
    // Standard PCI configuration space offsets
    localparam logic [11:0] CFG_VENDOR_DEVICE_ID   = 12'h000;
    localparam logic [11:0] CFG_COMMAND_STATUS      = 12'h004;
    localparam logic [11:0] CFG_CLASS_REVISION      = 12'h008;
    localparam logic [11:0] CFG_BIST_HEADER_LATENCY = 12'h00C;
    localparam logic [11:0] CFG_BAR0                = 12'h010;
    localparam logic [11:0] CFG_BAR1                = 12'h014;
    localparam logic [11:0] CFG_BAR2                = 12'h018;
    localparam logic [11:0] CFG_BAR3                = 12'h01C;
    localparam logic [11:0] CFG_BAR4                = 12'h020;
    localparam logic [11:0] CFG_BAR5                = 12'h024;
    
    // PCILeech-specific configuration registers (extended space)
    localparam logic [11:0] CFG_PCILEECH_CTRL       = 12'h100;
    localparam logic [11:0] CFG_PCILEECH_STATUS     = 12'h104;
    localparam logic [11:0] CFG_ERROR_STATUS        = 12'h108;
    localparam logic [11:0] CFG_PERF_COUNTER_0      = 12'h10C;
    localparam logic [11:0] CFG_PERF_COUNTER_1      = 12'h110;

endpackage

`endif // BAR_LAYOUT_PKG_SVH