# Generated by Django 4.1.7 on 2023-03-28 07:45

import uuid

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                (
                    'module',
                    models.CharField(db_index=True, max_length=254, unique=True),
                ),
                ('label', models.CharField(max_length=254, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Bucket',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                ('label', models.CharField(db_index=True, max_length=254, unique=True)),
                ('question', models.TextField(blank=True, null=True)),
                ('desc', models.TextField(blank=True, null=True)),
                (
                    'type',
                    models.IntegerField(
                        choices=[
                            (1, 'timeseries'),
                            (2, 'histogram'),
                            (3, 'scatterplot'),
                            (4, 'barchart'),
                        ],
                        default=1,
                    ),
                ),
                ('xlabel', models.CharField(blank=True, max_length=254, null=True)),
                ('xformat', models.CharField(blank=True, max_length=254, null=True)),
                ('ylabel', models.CharField(blank=True, max_length=254, null=True)),
                ('yformat', models.CharField(blank=True, max_length=254, null=True)),
                ('title', models.CharField(blank=True, max_length=254, null=True)),
                (
                    'app',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='buckets',
                        to='insights.app',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='ExecutionDelta',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'executed_at',
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                ('uuid', models.UUIDField(default=uuid.uuid4)),
            ],
        ),
        migrations.CreateModel(
            name='Gauge',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                ('label', models.CharField(db_index=True, max_length=254, unique=True)),
                ('question', models.TextField(blank=True, null=True)),
                ('desc', models.TextField(blank=True, null=True)),
                ('value', models.FloatField(default=0.0)),
                (
                    'app',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='gauges',
                        to='insights.app',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='Counter',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created_at',
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                ('label', models.CharField(db_index=True, max_length=254, unique=True)),
                ('question', models.TextField(blank=True, null=True)),
                ('desc', models.TextField(blank=True, null=True)),
                ('value', models.IntegerField(default=0)),
                (
                    'app',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='counters',
                        to='insights.app',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='BucketValue',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'timestamp',
                    models.DateTimeField(blank=True, db_index=True, null=True),
                ),
                ('xvalue', models.FloatField(default=0.0)),
                ('yvalue', models.FloatField(default=0.0)),
                (
                    'category',
                    models.CharField(db_index=True, max_length=254, null=True),
                ),
                (
                    'bucket',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='values',
                        to='insights.bucket',
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name='gauge',
            constraint=models.UniqueConstraint(
                fields=('app', 'label'), name='gauge_unique_app_label'
            ),
        ),
        migrations.AddConstraint(
            model_name='counter',
            constraint=models.UniqueConstraint(
                fields=('app', 'label'), name='counter_unique_app_label'
            ),
        ),
        migrations.AddConstraint(
            model_name='bucketvalue',
            constraint=models.UniqueConstraint(
                fields=('bucket', 'timestamp'),
                name='bucketvalue_unique_bucket_timestamp',
            ),
        ),
        migrations.AddConstraint(
            model_name='bucket',
            constraint=models.UniqueConstraint(
                fields=('app', 'label'), name='bucket_unique_app_label_timestamp'
            ),
        ),
    ]
