# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AudioResult(AbstractModel):
    """Audio moderation output parameter

    """

    def __init__(self):
        r"""
        :param HitFlag: This field is used to return whether the moderated content hit the moderation model. Valid values: 0 (**no**), 1 (**yes**).
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type HitFlag: int
        :param Label: This field is used to return the maliciousness tag in the detection result.<br>Returned values: **Normal**: normal; **Porn**: pornographic; **Abuse**: abusive; **Ad**: advertising; **Custom**: custom type of non-compliant content and other offensive, unsafe, or inappropriate types of content.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Label: str
        :param Suggestion: This field is used to return the operation suggestion. When you get the determination result, the returned value indicates the suggested operation.<br>
Returned values: **Block**, **Review**, **Pass**.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Score: This field is used to return the confidence under the current tag. Value range: 0 (**the lowest confidence**)–100 (**the highest confidence**), where a higher value indicates that the text is more likely to fall into the category of the current returned tag; for example, *Porn 99* indicates that the text is highly likely to be pornographic.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Score: int
        :param Text: This field is used to return the text information generated by recognizing an audio file with ASR. Audio files of up to **5 hours** can be recognized. If this limit is exceeded, an error will be reported by the API.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Text: str
        :param Url: This field is used to return the URL where audio segments are stored, which is valid for 1 day.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Url: str
        :param Duration: This field is used to return the length of an audio file in seconds.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Duration: str
        :param Extra: This field is used to return the additional information (Extra) in the input parameters. If it is not configured, an empty value will be returned by default.<br>Note: the returned information varies by customer or `Biztype`. If you need to configure this field, submit a ticket or contact the aftersales service for assistance.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Extra: str
        :param TextResults: This field is used to return the detailed moderation result of the text generated by recognizing an audio file with ASR. For the specific result, see the detailed description of the `AudioResultDetailLanguageResult` data structure.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TextResults: list of AudioResultDetailTextResult
        :param MoanResults: This field is used to return the detailed moan detection result of an audio file. For the specific result, see the detailed description of the `AudioResultDetailMoanResult` data structure.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type MoanResults: list of AudioResultDetailMoanResult
        :param LanguageResults: This field is used to return the detailed minor language detection result of an audio. For the specific result, see the detailed description of the `AudioResultDetailLanguageResult` data structure.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type LanguageResults: list of AudioResultDetailLanguageResult
        :param SubLabel: This field is used to return a subtag under the current tag (Lable).
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubLabel: str
        :param RecognitionResults: List of recognized category labels
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type RecognitionResults: list of RecognitionResult
        """
        self.HitFlag = None
        self.Label = None
        self.Suggestion = None
        self.Score = None
        self.Text = None
        self.Url = None
        self.Duration = None
        self.Extra = None
        self.TextResults = None
        self.MoanResults = None
        self.LanguageResults = None
        self.SubLabel = None
        self.RecognitionResults = None


    def _deserialize(self, params):
        self.HitFlag = params.get("HitFlag")
        self.Label = params.get("Label")
        self.Suggestion = params.get("Suggestion")
        self.Score = params.get("Score")
        self.Text = params.get("Text")
        self.Url = params.get("Url")
        self.Duration = params.get("Duration")
        self.Extra = params.get("Extra")
        if params.get("TextResults") is not None:
            self.TextResults = []
            for item in params.get("TextResults"):
                obj = AudioResultDetailTextResult()
                obj._deserialize(item)
                self.TextResults.append(obj)
        if params.get("MoanResults") is not None:
            self.MoanResults = []
            for item in params.get("MoanResults"):
                obj = AudioResultDetailMoanResult()
                obj._deserialize(item)
                self.MoanResults.append(obj)
        if params.get("LanguageResults") is not None:
            self.LanguageResults = []
            for item in params.get("LanguageResults"):
                obj = AudioResultDetailLanguageResult()
                obj._deserialize(item)
                self.LanguageResults.append(obj)
        self.SubLabel = params.get("SubLabel")
        if params.get("RecognitionResults") is not None:
            self.RecognitionResults = []
            for item in params.get("RecognitionResults"):
                obj = RecognitionResult()
                obj._deserialize(item)
                self.RecognitionResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioResultDetailLanguageResult(AbstractModel):
    """Audio language detection result

    """

    def __init__(self):
        r"""
        :param Label: Language
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param Score: Score
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        :param StartTime: Start time
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: float
        :param EndTime: End time
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: float
        :param SubLabelCode: Subtag under the current tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubLabelCode: str
        """
        self.Label = None
        self.Score = None
        self.StartTime = None
        self.EndTime = None
        self.SubLabelCode = None


    def _deserialize(self, params):
        self.Label = params.get("Label")
        self.Score = params.get("Score")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.SubLabelCode = params.get("SubLabelCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioResultDetailMoanResult(AbstractModel):
    """Audio moan moderation result

    """

    def __init__(self):
        r"""
        :param Label: This field is used to return the type of the content to be detected. It is fixed at **Moan** here to call the moan detection feature.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Label: str
        :param Score: This field is used to return the confidence of moan detection. Value range: 0 (**the lowest confidence**)–100 (**the highest confidence**), where a higher value indicates that the audio is more likely to fall into the category of moan.
        :type Score: int
        :param StartTime: This field is used to return the start time of the segment of an audio file under the corresponding moan tag in milliseconds.
        :type StartTime: float
        :param EndTime: This field is used to return the end time of the segment of an audio file under the corresponding moan tag in milliseconds.
        :type EndTime: float
        :param SubLabelCode: *This field is in beta test. Stay tuned*
        :type SubLabelCode: str
        :param SubLabel: This field is used to return a subtag under the current tag (Lable).
        :type SubLabel: str
        :param Suggestion: This field returns the suggested action according to the check result. <br>Values: `Block`, `Review`, `Pass`.
        :type Suggestion: str
        """
        self.Label = None
        self.Score = None
        self.StartTime = None
        self.EndTime = None
        self.SubLabelCode = None
        self.SubLabel = None
        self.Suggestion = None


    def _deserialize(self, params):
        self.Label = params.get("Label")
        self.Score = params.get("Score")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        self.SubLabelCode = params.get("SubLabelCode")
        self.SubLabel = params.get("SubLabel")
        self.Suggestion = params.get("Suggestion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioResultDetailTextResult(AbstractModel):
    """ASR-based audio moderation result

    """

    def __init__(self):
        r"""
        :param Label: This field is used to return the maliciousness tag in the detection result.<br>Returned values: **Normal**: normal; **Porn**: pornographic; **Abuse**: abusive; **Ad**: advertising; **Custom**: custom type of non-compliant content and other offensive, unsafe, or inappropriate types of content.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param Keywords: This field is used to return the keyword information hit by the text content recognized with ASR and indicate the specific cause of content non-compliance (such as "Friend me on WeChat"). This parameter may have multiple returned values representing multiple hit keywords. If the returned value is empty, but `Score` is not empty, the maliciousness tag (Label) that corresponds to the recognition result derives from the returned value determined by the semantic model.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Keywords: list of str
        :param LibId: This field is **valid only when `Label` is `Custom` (custom keyword)**. It is used to return the ID of the custom library for easier custom library management and configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LibId: str
        :param LibName: This field is **valid only when `Label` is `Custom` (custom keyword)**. It is used to return the name of the custom library for easier custom library management and configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LibName: str
        :param Score: This field is used to return the confidence under the current tag. Value range: 0 (**the lowest confidence**)–100 (**the highest confidence**), where a higher value indicates that the text is more likely to fall into the category of the current returned tag; for example, *Porn 99* indicates that the text is highly likely to be pornographic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        :param LibType: This field is used to return the dictionary type of a custom keyword. Valid values: **1** (blocklist/allowlist), **2** (custom keyword dictionary). If no custom keyword dictionary is configured, the default value will be 1 (blocklist/allowlist).
Note: This field may return null, indicating that no valid values can be obtained.
        :type LibType: int
        :param Suggestion: This field is used to return the operation suggestion. When you get the determination result, the returned value indicates the suggested operation.<br>
Returned values: **Block**, **Review**, **Pass**.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param SubLabel: This field is used to return a subtag under the current tag (Lable).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubLabel: str
        """
        self.Label = None
        self.Keywords = None
        self.LibId = None
        self.LibName = None
        self.Score = None
        self.LibType = None
        self.Suggestion = None
        self.SubLabel = None


    def _deserialize(self, params):
        self.Label = params.get("Label")
        self.Keywords = params.get("Keywords")
        self.LibId = params.get("LibId")
        self.LibName = params.get("LibName")
        self.Score = params.get("Score")
        self.LibType = params.get("LibType")
        self.Suggestion = params.get("Suggestion")
        self.SubLabel = params.get("SubLabel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSegments(AbstractModel):
    """Information of the audio segment

    """

    def __init__(self):
        r"""
        :param OffsetTime: Capture time.
For VOD files, it indicates the video offset time given in seconds (e.g., 0, 5, 10).
For live files, it indicates a timestamp (e.g., 1594650717).
Note: This field may return null, indicating that no valid values can be obtained.
        :type OffsetTime: str
        :param Result: Result set
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: :class:`tencentcloud.vm.v20210922.models.AudioResult`
        """
        self.OffsetTime = None
        self.Result = None


    def _deserialize(self, params):
        self.OffsetTime = params.get("OffsetTime")
        if params.get("Result") is not None:
            self.Result = AudioResult()
            self.Result._deserialize(params.get("Result"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BucketInfo(AbstractModel):
    """Bucket information
    For more information on Tencent Cloud storage, see https://intl.cloud.tencent.com/document/product/436/44352.?from_cn_redirect=1

    """

    def __init__(self):
        r"""
        :param Bucket: Name of the COS bucket
        :type Bucket: str
        :param Region: Region
        :type Region: str
        :param Object: Object key
        :type Object: str
        """
        self.Bucket = None
        self.Region = None
        self.Object = None


    def _deserialize(self, params):
        self.Bucket = params.get("Bucket")
        self.Region = params.get("Region")
        self.Object = params.get("Object")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelTaskRequest(AbstractModel):
    """CancelTask request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
        :type TaskId: str
        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelTaskResponse(AbstractModel):
    """CancelTask response structure.

    """

    def __init__(self):
        r"""
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class CreateVideoModerationTaskRequest(AbstractModel):
    """CreateVideoModerationTask request structure.

    """

    def __init__(self):
        r"""
        :param BizType: Business type, which is used to define a template policy.
        :type BizType: str
        :param Type: Task type. Values: `VIDEO` (video on demand), `LIVE_VIDEO` (live video).
        :type Type: str
        :param Tasks: Task information. You can create up to 10 tasks at a time.
        :type Tasks: list of TaskInput
        :param Seed: Key of the callback signature. For more details, see the signature documentation.
        :type Seed: str
        :param CallbackUrl: Callback URL that will receive moderation information. After it is configured, the non-compliant audio segments detected in moderation will be sent through this API.
        :type CallbackUrl: str
        :param Priority: Priority, which determines the execution order of your moderation tasks. The default value is 0.
        :type Priority: int
        """
        self.BizType = None
        self.Type = None
        self.Tasks = None
        self.Seed = None
        self.CallbackUrl = None
        self.Priority = None


    def _deserialize(self, params):
        self.BizType = params.get("BizType")
        self.Type = params.get("Type")
        if params.get("Tasks") is not None:
            self.Tasks = []
            for item in params.get("Tasks"):
                obj = TaskInput()
                obj._deserialize(item)
                self.Tasks.append(obj)
        self.Seed = params.get("Seed")
        self.CallbackUrl = params.get("CallbackUrl")
        self.Priority = params.get("Priority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVideoModerationTaskResponse(AbstractModel):
    """CreateVideoModerationTask response structure.

    """

    def __init__(self):
        r"""
        :param Results: Task creation result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Results: list of TaskResult
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Results = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("Results") is not None:
            self.Results = []
            for item in params.get("Results"):
                obj = TaskResult()
                obj._deserialize(item)
                self.Results.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID, which is returned after a task is created
        :type TaskId: str
        :param ShowAllSegments: Whether to show all segments. If it’s not specified, only hit segments are shown.
        :type ShowAllSegments: bool
        """
        self.TaskId = None
        self.ShowAllSegments = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.ShowAllSegments = params.get("ShowAllSegments")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param TaskId: This field is used to return the task ID (in the `Results` parameter) after a video moderation task is created. It is used to identify the moderation task for which to query the details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param DataId: This field is used to return the data ID parameter passed in when the video moderation API is called for easier data identification and management.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataId: str
        :param BizType: This field is used to return the `BizType` parameter passed in when the video moderation API is called for easier data identification and management.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BizType: str
        :param Name: This field is used to return the task name in the `TaskInput` parameter passed in when the video moderation API is called for easier task identification and management.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Status: This field is used to return the task status of the queried content.
<br>Valid values: **FINISH** (task completed), **PENDING** (task pending), **RUNNING** (task in progress), **ERROR** (task error), **CANCELLED** (task canceled).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param Type: This field is used to return the type of video for moderation. Valid values: `VIDEO` (video on demand), `LIVE_VIDEO` (video live streaming). Default value: `VIDEO`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param Suggestion: This field is used to return the operation suggestion for the maliciousness tag. When you get the determination result, the returned value indicates the operation suggested by the system. We recommend you handle different types of violations and suggestions according to your business needs. <br>Returned values: **Block**, **Review**, **Pass**.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Labels: This field is used to return the maliciousness tag in the detection result.<br>Values: `Normal`: normal; `Porn`: pornographic; `Abuse`: abusive; `Ad`: advertising; `Custom`: custom type of non-compliant content and other offensive, unsafe, or inappropriate types of content.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Labels: list of TaskLabel
        :param MediaInfo: This field is used to return the details of the input media file, including encoding/decoding formats and segment length. For details, see the description of the `MediaInfo` data structure.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MediaInfo: :class:`tencentcloud.vm.v20210922.models.MediaInfo`
        :param InputInfo: This field is used to return the media content information of the moderation service, mainly including the input file type and access URL.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InputInfo: :class:`tencentcloud.vm.v20210922.models.InputInfo`
        :param CreatedAt: This field is used to return the creation time of the queried task in ISO 8601 format.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreatedAt: str
        :param UpdatedAt: This field is used to return the last update time of the queried task in ISO 8601 format.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdatedAt: str
        :param TryInSeconds: Specifies how long, in seconds, to retry
Note: This field may return null, indicating that no valid values can be obtained.
        :type TryInSeconds: int
        :param ImageSegments: This field is used to return the moderation result of the frames captured from the video. For the detailed returned content, see the description of the `ImageSegments` data structure.<br>Note: the data is valid for 24 hours. To extend the storage period, set it in the configured COS bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSegments: list of ImageSegments
        :param AudioSegments: This field is used to return the moderation result of the audio in the video. For the detailed returned content, see the description of the `AudioSegments` data structure.<br>Note: the data is valid for 24 hours. To extend the storage period, set it in the configured COS bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioSegments: list of AudioSegments
        :param ErrorType: When the task status is `Error`, the type of the error will be returned. Valid values: **DECODE_ERROR**: decoding failed (the input resource may contain video that cannot be decoded).
**URL_ERROR**: download address verification failed.
**TIMEOUT_ERROR**: processing timed out. When the task status is not `Error`, null will be returned by default.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ErrorType: str
        :param ErrorDescription: If the task status is `Error`, this field will return the error message; otherwise, null will be returned by default.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ErrorDescription: str
        :param Label: If the recognition result is normal, this parameter is returned with the value `Normal`. If malicious content is recognized, the tag with the highest priority in the result of `Labels` is returned.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param AudioText: This field is used to return the recognized text content of an audio file. **Up to the first 1,000 characters** can be recognized.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioText: str
        :param Asrs: The text content recognized from the audio 
Note: This field may return null, indicating that no valid values can be obtained.
        :type Asrs: list of RcbAsr
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.TaskId = None
        self.DataId = None
        self.BizType = None
        self.Name = None
        self.Status = None
        self.Type = None
        self.Suggestion = None
        self.Labels = None
        self.MediaInfo = None
        self.InputInfo = None
        self.CreatedAt = None
        self.UpdatedAt = None
        self.TryInSeconds = None
        self.ImageSegments = None
        self.AudioSegments = None
        self.ErrorType = None
        self.ErrorDescription = None
        self.Label = None
        self.AudioText = None
        self.Asrs = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.DataId = params.get("DataId")
        self.BizType = params.get("BizType")
        self.Name = params.get("Name")
        self.Status = params.get("Status")
        self.Type = params.get("Type")
        self.Suggestion = params.get("Suggestion")
        if params.get("Labels") is not None:
            self.Labels = []
            for item in params.get("Labels"):
                obj = TaskLabel()
                obj._deserialize(item)
                self.Labels.append(obj)
        if params.get("MediaInfo") is not None:
            self.MediaInfo = MediaInfo()
            self.MediaInfo._deserialize(params.get("MediaInfo"))
        if params.get("InputInfo") is not None:
            self.InputInfo = InputInfo()
            self.InputInfo._deserialize(params.get("InputInfo"))
        self.CreatedAt = params.get("CreatedAt")
        self.UpdatedAt = params.get("UpdatedAt")
        self.TryInSeconds = params.get("TryInSeconds")
        if params.get("ImageSegments") is not None:
            self.ImageSegments = []
            for item in params.get("ImageSegments"):
                obj = ImageSegments()
                obj._deserialize(item)
                self.ImageSegments.append(obj)
        if params.get("AudioSegments") is not None:
            self.AudioSegments = []
            for item in params.get("AudioSegments"):
                obj = AudioSegments()
                obj._deserialize(item)
                self.AudioSegments.append(obj)
        self.ErrorType = params.get("ErrorType")
        self.ErrorDescription = params.get("ErrorDescription")
        self.Label = params.get("Label")
        self.AudioText = params.get("AudioText")
        if params.get("Asrs") is not None:
            self.Asrs = []
            for item in params.get("Asrs"):
                obj = RcbAsr()
                obj._deserialize(item)
                self.Asrs.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    """DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param Limit: This parameter indicates the number of tasks to be displayed on each page of the task list. **Default value: 10**.
        :type Limit: int
        :param Filter: This parameter indicates the input parameter of the task filter. You can filter tasks by business type, file type, processing suggestion, and task status. For the specific parameter content, see the detailed description of the `TaskFilter` data structure.
        :type Filter: :class:`tencentcloud.vm.v20210922.models.TaskFilter`
        :param PageToken: This parameter indicates the `Token` information used during pagination. It is automatically generated by the system and will be passed to the next generated page for easy and fast pagination. When you turn to the last page, this field will be empty.
        :type PageToken: str
        :param StartTime: This parameter indicates the start time of the task list in ISO 8601 timestamp format. **Default value: 3 days ago**. If this parameter is passed in, tasks between this time point and `EndTime` will be filtered out.<br>Note: this parameter is used together with `Filter` to filter tasks in no particular order.
        :type StartTime: str
        :param EndTime: This parameter indicates the end time of the task list in ISO 8601 timestamp format. **Default value: empty**. If this parameter is passed in, tasks between `StartTime` and this time point will be filtered out.<br>Note: this parameter is used together with `Filter` to filter tasks in no particular order.
        :type EndTime: str
        """
        self.Limit = None
        self.Filter = None
        self.PageToken = None
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.Limit = params.get("Limit")
        if params.get("Filter") is not None:
            self.Filter = TaskFilter()
            self.Filter._deserialize(params.get("Filter"))
        self.PageToken = params.get("PageToken")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    """DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param Total: This field is used to return the total number of queried tasks in the format of `int` string.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: str
        :param Data: This field is used to return the detailed data of the tasks on the current page. For the specific output content, see the detailed description of the `TaskData` data structure.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of TaskData
        :param PageToken: This field is used to return the `Token` information used during pagination. It is automatically generated by the system and will be passed to the next generated page for easy and fast pagination. When you turn to the last page, this field will be empty.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PageToken: str
        :param RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self.Total = None
        self.Data = None
        self.PageToken = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Total = params.get("Total")
        if params.get("Data") is not None:
            self.Data = []
            for item in params.get("Data"):
                obj = TaskData()
                obj._deserialize(item)
                self.Data.append(obj)
        self.PageToken = params.get("PageToken")
        self.RequestId = params.get("RequestId")


class ImageResult(AbstractModel):
    """Result details

    """

    def __init__(self):
        r"""
        :param HitFlag: Whether the video content is hit
`0`: No
`1`: Yes
Note: This field may return null, indicating that no valid values can be obtained.
        :type HitFlag: int
        :param Label: Hit tag
`Porn`: Pornographic
`Sexy`: Sexy
`Polity`: Political
`Illegal`: Illegal
`Abuse`: Abusive
`Terror`: Violence and terrorism
`Ad`: Advertising
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param Suggestion: Suggestion. Values:
`Pass`: You’re suggested to allow the video to pass.
`Review`: You’re suggested to take a manual review.
`Block`: You’re suggested to block the non-compliant video.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Score: Score
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        :param Results: Captured images
Note: This field may return null, indicating that no valid values can be obtained.
        :type Results: list of ImageResultResult
        :param Url: Image URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type Url: str
        :param Extra: Additional field
Note: This field may return null, indicating that no valid values can be obtained.
        :type Extra: str
        """
        self.HitFlag = None
        self.Label = None
        self.Suggestion = None
        self.Score = None
        self.Results = None
        self.Url = None
        self.Extra = None


    def _deserialize(self, params):
        self.HitFlag = params.get("HitFlag")
        self.Label = params.get("Label")
        self.Suggestion = params.get("Suggestion")
        self.Score = params.get("Score")
        if params.get("Results") is not None:
            self.Results = []
            for item in params.get("Results"):
                obj = ImageResultResult()
                obj._deserialize(item)
                self.Results.append(obj)
        self.Url = params.get("Url")
        self.Extra = params.get("Extra")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageResultResult(AbstractModel):
    """Sub-result of the image output result

    """

    def __init__(self):
        r"""
        :param Scene: Scenario
`Porn`: Pornographic
`Sexy`: Sexy
`Polity`: Political
`Illegal`: Illegal
`Abuse`: Abusive
`Terror`: Violence and terrorism
`Ad`: Advertising
Note: This field may return null, indicating that no valid values can be obtained.
        :type Scene: str
        :param HitFlag: Whether the video content is hit
`0`: No
`1`: Yes
Note: This field may return null, indicating that no valid values can be obtained.
        :type HitFlag: int
        :param Suggestion: Suggestion. Values:
`Pass`: You’re suggested to allow the video to pass.
`Review`: You’re suggested to take a manual review.
`Block`: You’re suggested to block the non-compliant video.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Label: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param SubLabel: Subtag under the current tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubLabel: str
        :param Score: Score
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        :param Names: If the hit video contains political content, the list of politicians will be returned; otherwise a null value is returned.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Names: list of str
        :param Text: OCR-recognized text in the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Text: str
        :param Details: Other details
Note: This field may return null, indicating that no valid values can be obtained.
        :type Details: list of ImageResultsResultDetail
        """
        self.Scene = None
        self.HitFlag = None
        self.Suggestion = None
        self.Label = None
        self.SubLabel = None
        self.Score = None
        self.Names = None
        self.Text = None
        self.Details = None


    def _deserialize(self, params):
        self.Scene = params.get("Scene")
        self.HitFlag = params.get("HitFlag")
        self.Suggestion = params.get("Suggestion")
        self.Label = params.get("Label")
        self.SubLabel = params.get("SubLabel")
        self.Score = params.get("Score")
        self.Names = params.get("Names")
        self.Text = params.get("Text")
        if params.get("Details") is not None:
            self.Details = []
            for item in params.get("Details"):
                obj = ImageResultsResultDetail()
                obj._deserialize(item)
                self.Details.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageResultsResultDetail(AbstractModel):
    """Image recognition result in the specific scenario

    """

    def __init__(self):
        r"""
        :param Name: Task name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Text: OCR-recognized text
Note: This field may return null, indicating that no valid values can be obtained.
        :type Text: str
        :param Location: Location information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: :class:`tencentcloud.vm.v20210922.models.ImageResultsResultDetailLocation`
        :param Label: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param LibId: Library ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type LibId: str
        :param LibName: Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type LibName: str
        :param Keywords: Hit keyword
Note: This field may return null, indicating that no valid values can be obtained.
        :type Keywords: list of str
        :param Suggestion: Suggestion
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Score: Score
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        :param SubLabelCode: Subtag under the current tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubLabelCode: str
        """
        self.Name = None
        self.Text = None
        self.Location = None
        self.Label = None
        self.LibId = None
        self.LibName = None
        self.Keywords = None
        self.Suggestion = None
        self.Score = None
        self.SubLabelCode = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Text = params.get("Text")
        if params.get("Location") is not None:
            self.Location = ImageResultsResultDetailLocation()
            self.Location._deserialize(params.get("Location"))
        self.Label = params.get("Label")
        self.LibId = params.get("LibId")
        self.LibName = params.get("LibName")
        self.Keywords = params.get("Keywords")
        self.Suggestion = params.get("Suggestion")
        self.Score = params.get("Score")
        self.SubLabelCode = params.get("SubLabelCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageResultsResultDetailLocation(AbstractModel):
    """Position information of image details

    """

    def __init__(self):
        r"""
        :param X: X-coordinate
Note: This field may return null, indicating that no valid values can be obtained.
        :type X: float
        :param Y: Y-coordinate
Note: This field may return null, indicating that no valid values can be obtained.
        :type Y: float
        :param Width: Width
Note: This field may return null, indicating that no valid values can be obtained.
        :type Width: int
        :param Height: Height
Note: This field may return null, indicating that no valid values can be obtained.
        :type Height: int
        :param Rotate: Rotation angle
Note: This field may return null, indicating that no valid values can be obtained.
        :type Rotate: float
        """
        self.X = None
        self.Y = None
        self.Width = None
        self.Height = None
        self.Rotate = None


    def _deserialize(self, params):
        self.X = params.get("X")
        self.Y = params.get("Y")
        self.Width = params.get("Width")
        self.Height = params.get("Height")
        self.Rotate = params.get("Rotate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSegments(AbstractModel):
    """Image segment information

    """

    def __init__(self):
        r"""
        :param OffsetTime: Capture time.
For VOD files, it indicates the video offset time given in seconds (e.g., 0, 5, 10).
For live files, it indicates a timestamp (e.g., 1594650717).
        :type OffsetTime: str
        :param Result: Image capture result
        :type Result: :class:`tencentcloud.vm.v20210922.models.ImageResult`
        """
        self.OffsetTime = None
        self.Result = None


    def _deserialize(self, params):
        self.OffsetTime = params.get("OffsetTime")
        if params.get("Result") is not None:
            self.Result = ImageResult()
            self.Result._deserialize(params.get("Result"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InputInfo(AbstractModel):
    """Input information details

    """

    def __init__(self):
        r"""
        :param Type: Type. Values: `URL`, `COS`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param Url: URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type Url: str
        :param BucketInfo: Bucket information. When `Type = COS`, this field is required.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BucketInfo: str
        """
        self.Type = None
        self.Url = None
        self.BucketInfo = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.Url = params.get("Url")
        self.BucketInfo = params.get("BucketInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaInfo(AbstractModel):
    """Media type

    """

    def __init__(self):
        r"""
        :param Codecs: Encoding format
        :type Codecs: str
        :param Duration: Segment duration during stream detection
Note: this field may return null, indicating that no valid values can be obtained.
        :type Duration: int
        :param Width: Width, in pixels
        :type Width: int
        :param Height: Height, in pixels
        :type Height: int
        :param Thumbnail: Cover
        :type Thumbnail: str
        """
        self.Codecs = None
        self.Duration = None
        self.Width = None
        self.Height = None
        self.Thumbnail = None


    def _deserialize(self, params):
        self.Codecs = params.get("Codecs")
        self.Duration = params.get("Duration")
        self.Width = params.get("Width")
        self.Height = params.get("Height")
        self.Thumbnail = params.get("Thumbnail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RcbAsr(AbstractModel):
    """Audit ASR text information of the segment

    """

    def __init__(self):
        r"""
        :param Text: This field is used to return the recognized text content of an audio file. **Up to the first 1,000 characters** can be recognized.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Text: str
        :param CreatedAt: This field is used to return the creation time of the queried task in ISO 8601 format.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreatedAt: str
        """
        self.Text = None
        self.CreatedAt = None


    def _deserialize(self, params):
        self.Text = params.get("Text")
        self.CreatedAt = params.get("CreatedAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecognitionResult(AbstractModel):
    """Information of the category label

    """

    def __init__(self):
        r"""
        :param Label: Values: `Teenager`, `Gender`
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Label: str
        :param Tags: List of recognized category labels
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        """
        self.Label = None
        self.Tags = None


    def _deserialize(self, params):
        self.Label = params.get("Label")
        if params.get("Tags") is not None:
            self.Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self.Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StorageInfo(AbstractModel):
    """Data storage information

    """

    def __init__(self):
        r"""
        :param Type: Type. Values:
`URL`: Resource link
`COS`: Tencent Cloud COS
        :type Type: str
        :param Url: Resource link
        :type Url: str
        :param BucketInfo: Tencent Cloud bucket information
        :type BucketInfo: :class:`tencentcloud.vm.v20210922.models.BucketInfo`
        """
        self.Type = None
        self.Url = None
        self.BucketInfo = None


    def _deserialize(self, params):
        self.Type = params.get("Type")
        self.Url = params.get("Url")
        if params.get("BucketInfo") is not None:
            self.BucketInfo = BucketInfo()
            self.BucketInfo._deserialize(params.get("BucketInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Tag(AbstractModel):
    """Tag of the audio slice

    """

    def __init__(self):
        r"""
        :param Name: The value of this parameter varies by `Label`.
When `Label` is `Teenager`, `Name` can be `Teenager`. 
When `Label` is `Gender`, `Name` can be `Male` and `Female`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Name: str
        :param Score: Confidence score. Value: 1 to 100. 
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Score: int
        :param StartTime: Start time for the recognition (ms)
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type StartTime: float
        :param EndTime: End time for the recognition (ms)
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type EndTime: float
        """
        self.Name = None
        self.Score = None
        self.StartTime = None
        self.EndTime = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Score = params.get("Score")
        self.StartTime = params.get("StartTime")
        self.EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskData(AbstractModel):
    """Task data

    """

    def __init__(self):
        r"""
        :param TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param DataId: Data ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataId: str
        :param BizType: Service type
Note: This field may return null, indicating that no valid values can be obtained.
        :type BizType: str
        :param Name: Task name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param Status: Task status. Values: `PENDING`, `RUNNING`, `ERROR`, `FINISH`, and `CANCELLED`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param Type: Task type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param Suggestion: Suggestion
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Labels: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Labels: list of TaskLabel
        :param MediaInfo: Media information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MediaInfo: :class:`tencentcloud.vm.v20210922.models.MediaInfo`
        :param InputInfo: Input information
Note: This field may return null, indicating that no valid values can be obtained.
        :type InputInfo: :class:`tencentcloud.vm.v20210922.models.InputInfo`
        :param CreatedAt: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreatedAt: str
        :param UpdatedAt: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdatedAt: str
        """
        self.TaskId = None
        self.DataId = None
        self.BizType = None
        self.Name = None
        self.Status = None
        self.Type = None
        self.Suggestion = None
        self.Labels = None
        self.MediaInfo = None
        self.InputInfo = None
        self.CreatedAt = None
        self.UpdatedAt = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.DataId = params.get("DataId")
        self.BizType = params.get("BizType")
        self.Name = params.get("Name")
        self.Status = params.get("Status")
        self.Type = params.get("Type")
        self.Suggestion = params.get("Suggestion")
        if params.get("Labels") is not None:
            self.Labels = []
            for item in params.get("Labels"):
                obj = TaskLabel()
                obj._deserialize(item)
                self.Labels.append(obj)
        if params.get("MediaInfo") is not None:
            self.MediaInfo = MediaInfo()
            self.MediaInfo._deserialize(params.get("MediaInfo"))
        if params.get("InputInfo") is not None:
            self.InputInfo = InputInfo()
            self.InputInfo._deserialize(params.get("InputInfo"))
        self.CreatedAt = params.get("CreatedAt")
        self.UpdatedAt = params.get("UpdatedAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskFilter(AbstractModel):
    """Cos TaskFilter

    """

    def __init__(self):
        r"""
        :param BizType: Task type
        :type BizType: str
        :param Type: Task type. Values: `VIDEO`, `AUDIO`, `LIVE_VIDEO`, and `LIVE_AUDIO`.
        :type Type: str
        :param Suggestion: Suggestion. Values: `Pass`, `Review`, and `Block`.
        :type Suggestion: str
        :param TaskStatus: Task status. Values: `PENDING`, `RUNNING`, `ERROR`, `FINISH`, and `CANCELLED`.
        :type TaskStatus: str
        """
        self.BizType = None
        self.Type = None
        self.Suggestion = None
        self.TaskStatus = None


    def _deserialize(self, params):
        self.BizType = params.get("BizType")
        self.Type = params.get("Type")
        self.Suggestion = params.get("Suggestion")
        self.TaskStatus = params.get("TaskStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskInput(AbstractModel):
    """Audio/Video task structure

    """

    def __init__(self):
        r"""
        :param DataId: Data ID
        :type DataId: str
        :param Name: Task name
        :type Name: str
        :param Input: Task input
        :type Input: :class:`tencentcloud.vm.v20210922.models.StorageInfo`
        """
        self.DataId = None
        self.Name = None
        self.Input = None


    def _deserialize(self, params):
        self.DataId = params.get("DataId")
        self.Name = params.get("Name")
        if params.get("Input") is not None:
            self.Input = StorageInfo()
            self.Input._deserialize(params.get("Input"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskLabel(AbstractModel):
    """Task output tag

    """

    def __init__(self):
        r"""
        :param Label: Hit tag
`Porn`: Pornographic
`Sexy`: Sexy
`Polity`: Political
`Illegal`: Illegal
`Abuse`: Abusive
`Terror`: Violence and terrorism
`Ad`: Advertising
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param Suggestion: Suggestion. Values:
`Pass`: You’re suggested to allow the video to pass.
`Review`: You’re suggested to take a manual review.
`Block`: You’re suggested to block the non-compliant video.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param Score: Score. Value range: 0-100.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        """
        self.Label = None
        self.Suggestion = None
        self.Score = None


    def _deserialize(self, params):
        self.Label = params.get("Label")
        self.Suggestion = params.get("Suggestion")
        self.Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskResult(AbstractModel):
    """The result returned during task creation

    """

    def __init__(self):
        r"""
        :param DataId: Data ID passed when you request the data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataId: str
        :param TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param Code: Error code. If `OK` is returned, it indicates the task is created successfully. You can see common error codes for more details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Code: str
        :param Message: Error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        """
        self.DataId = None
        self.TaskId = None
        self.Code = None
        self.Message = None


    def _deserialize(self, params):
        self.DataId = params.get("DataId")
        self.TaskId = params.get("TaskId")
        self.Code = params.get("Code")
        self.Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        