# Contributing to MontePy

Welcome, and thank you for considering contributing to MontePy! We look forward
to welcoming new members to the community and will do our best to help you get
up to speed.

## Code of Conduct

Participants in the MontePy project are expected to follow and uphold the [Code
of Conduct](CODE_OF_CONDUCT.md). Please report any unacceptable behavior to mgale@montepy.org.

## Resources

- [GitHub Repository](https://github.com/idaholab/montepy)
- [Documentation](https://www.montepy.org/)
- [Developer's Guide](https://www.montepy.org/developing.html)

## How to Report Bugs

MontePy is hosted on GitHub and all bugs are reported and tracked through the
[Issues](https://github.com/idaholab/MontePy/issues) listed on GitHub.

## How to Suggest Enhancements

If you have suggestions for new features, feel free to suggest one as a new issue.
Keep in mind that MontePy has a small development team,
and in some cases MontePy might not be the right home for the feature. 
Please review the package philosophy to see if the feature would be a good fit. 

## How to Submit Changes

All changes to MontePy happen through pull requests. For a full overview of the
process, see the developer's guide section on [MontePy's documentation](https://www.montepy.org/developing.html)

## Code Style

Before you run off to make changes to the code, please review the [design 
philosophy](https://www.montepy.org/developing.html#design-philosophy),
and make sure to also use [black](https://black.readthedocs.io/en/stable/index.html).
