# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_ice20201109 import models as ice20201109_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._signature_algorithm = 'v2'
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'ap-northeast-1': 'ice.aliyuncs.com',
            'ap-northeast-2-pop': 'ice.aliyuncs.com',
            'ap-south-1': 'ice.aliyuncs.com',
            'ap-southeast-1': 'ice.aliyuncs.com',
            'ap-southeast-2': 'ice.aliyuncs.com',
            'ap-southeast-3': 'ice.aliyuncs.com',
            'ap-southeast-5': 'ice.aliyuncs.com',
            'cn-beijing': 'ice.aliyuncs.com',
            'cn-beijing-finance-1': 'ice.aliyuncs.com',
            'cn-beijing-finance-pop': 'ice.aliyuncs.com',
            'cn-beijing-gov-1': 'ice.aliyuncs.com',
            'cn-beijing-nu16-b01': 'ice.aliyuncs.com',
            'cn-chengdu': 'ice.aliyuncs.com',
            'cn-edge-1': 'ice.aliyuncs.com',
            'cn-fujian': 'ice.aliyuncs.com',
            'cn-haidian-cm12-c01': 'ice.aliyuncs.com',
            'cn-hangzhou': 'ice.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'ice.aliyuncs.com',
            'cn-hangzhou-finance': 'ice.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'ice.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'ice.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'ice.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'ice.aliyuncs.com',
            'cn-hangzhou-test-306': 'ice.aliyuncs.com',
            'cn-hongkong': 'ice.aliyuncs.com',
            'cn-hongkong-finance-pop': 'ice.aliyuncs.com',
            'cn-huhehaote': 'ice.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'ice.aliyuncs.com',
            'cn-north-2-gov-1': 'ice.aliyuncs.com',
            'cn-qingdao': 'ice.aliyuncs.com',
            'cn-qingdao-nebula': 'ice.aliyuncs.com',
            'cn-shanghai-et15-b01': 'ice.aliyuncs.com',
            'cn-shanghai-et2-b01': 'ice.aliyuncs.com',
            'cn-shanghai-finance-1': 'ice.aliyuncs.com',
            'cn-shanghai-inner': 'ice.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'ice.aliyuncs.com',
            'cn-shenzhen': 'ice.aliyuncs.com',
            'cn-shenzhen-finance-1': 'ice.aliyuncs.com',
            'cn-shenzhen-inner': 'ice.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'ice.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'ice.aliyuncs.com',
            'cn-wuhan': 'ice.aliyuncs.com',
            'cn-wulanchabu': 'ice.aliyuncs.com',
            'cn-yushanfang': 'ice.aliyuncs.com',
            'cn-zhangbei': 'ice.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'ice.aliyuncs.com',
            'cn-zhangjiakou': 'ice.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'ice.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'ice.aliyuncs.com',
            'eu-central-1': 'ice.aliyuncs.com',
            'eu-west-1': 'ice.aliyuncs.com',
            'eu-west-1-oxs': 'ice.aliyuncs.com',
            'me-east-1': 'ice.aliyuncs.com',
            'rus-west-1-pop': 'ice.aliyuncs.com',
            'us-east-1': 'ice.aliyuncs.com',
            'us-west-1': 'ice.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('ice', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_ad_insertion_with_options(
        self,
        request: ice20201109_models.AddAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddAdInsertionResponse:
        """
        @summary Adds an ad insertion configuration.
        
        @param request: AddAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAdInsertionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.ad_marker_passthrough):
            body['AdMarkerPassthrough'] = request.ad_marker_passthrough
        if not UtilClient.is_unset(request.ads_url):
            body['AdsUrl'] = request.ads_url
        if not UtilClient.is_unset(request.cdn_ad_segment_url_prefix):
            body['CdnAdSegmentUrlPrefix'] = request.cdn_ad_segment_url_prefix
        if not UtilClient.is_unset(request.cdn_content_segment_url_prefix):
            body['CdnContentSegmentUrlPrefix'] = request.cdn_content_segment_url_prefix
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.config_aliases):
            body['ConfigAliases'] = request.config_aliases
        if not UtilClient.is_unset(request.content_url_prefix):
            body['ContentUrlPrefix'] = request.content_url_prefix
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.personalization_threshold):
            body['PersonalizationThreshold'] = request.personalization_threshold
        if not UtilClient.is_unset(request.slate_ad_url):
            body['SlateAdUrl'] = request.slate_ad_url
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddAdInsertionResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_ad_insertion_with_options_async(
        self,
        request: ice20201109_models.AddAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddAdInsertionResponse:
        """
        @summary Adds an ad insertion configuration.
        
        @param request: AddAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAdInsertionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.ad_marker_passthrough):
            body['AdMarkerPassthrough'] = request.ad_marker_passthrough
        if not UtilClient.is_unset(request.ads_url):
            body['AdsUrl'] = request.ads_url
        if not UtilClient.is_unset(request.cdn_ad_segment_url_prefix):
            body['CdnAdSegmentUrlPrefix'] = request.cdn_ad_segment_url_prefix
        if not UtilClient.is_unset(request.cdn_content_segment_url_prefix):
            body['CdnContentSegmentUrlPrefix'] = request.cdn_content_segment_url_prefix
        if not UtilClient.is_unset(request.client_token):
            body['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.config_aliases):
            body['ConfigAliases'] = request.config_aliases
        if not UtilClient.is_unset(request.content_url_prefix):
            body['ContentUrlPrefix'] = request.content_url_prefix
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.personalization_threshold):
            body['PersonalizationThreshold'] = request.personalization_threshold
        if not UtilClient.is_unset(request.slate_ad_url):
            body['SlateAdUrl'] = request.slate_ad_url
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddAdInsertionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_ad_insertion(
        self,
        request: ice20201109_models.AddAdInsertionRequest,
    ) -> ice20201109_models.AddAdInsertionResponse:
        """
        @summary Adds an ad insertion configuration.
        
        @param request: AddAdInsertionRequest
        @return: AddAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_ad_insertion_with_options(request, runtime)

    async def add_ad_insertion_async(
        self,
        request: ice20201109_models.AddAdInsertionRequest,
    ) -> ice20201109_models.AddAdInsertionResponse:
        """
        @summary Adds an ad insertion configuration.
        
        @param request: AddAdInsertionRequest
        @return: AddAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_ad_insertion_with_options_async(request, runtime)

    def add_category_with_options(
        self,
        request: ice20201109_models.AddCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddCategoryResponse:
        """
        @summary Creates a category.
        
        @description You can create at most three levels of categories. Each category level can contain a maximum of 100 subcategories.
        
        @param request: AddCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_name):
            query['CateName'] = request.cate_name
        if not UtilClient.is_unset(request.parent_id):
            query['ParentId'] = request.parent_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCategory',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddCategoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_category_with_options_async(
        self,
        request: ice20201109_models.AddCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddCategoryResponse:
        """
        @summary Creates a category.
        
        @description You can create at most three levels of categories. Each category level can contain a maximum of 100 subcategories.
        
        @param request: AddCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_name):
            query['CateName'] = request.cate_name
        if not UtilClient.is_unset(request.parent_id):
            query['ParentId'] = request.parent_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCategory',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddCategoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_category(
        self,
        request: ice20201109_models.AddCategoryRequest,
    ) -> ice20201109_models.AddCategoryResponse:
        """
        @summary Creates a category.
        
        @description You can create at most three levels of categories. Each category level can contain a maximum of 100 subcategories.
        
        @param request: AddCategoryRequest
        @return: AddCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_category_with_options(request, runtime)

    async def add_category_async(
        self,
        request: ice20201109_models.AddCategoryRequest,
    ) -> ice20201109_models.AddCategoryResponse:
        """
        @summary Creates a category.
        
        @description You can create at most three levels of categories. Each category level can contain a maximum of 100 subcategories.
        
        @param request: AddCategoryRequest
        @return: AddCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_category_with_options_async(request, runtime)

    def add_editing_project_materials_with_options(
        self,
        request: ice20201109_models.AddEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddEditingProjectMaterialsResponse:
        """
        @summary Adds one or more materials to an online editing project.
        
        @param request: AddEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.material_maps):
            query['MaterialMaps'] = request.material_maps
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddEditingProjectMaterialsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_editing_project_materials_with_options_async(
        self,
        request: ice20201109_models.AddEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddEditingProjectMaterialsResponse:
        """
        @summary Adds one or more materials to an online editing project.
        
        @param request: AddEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.material_maps):
            query['MaterialMaps'] = request.material_maps
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddEditingProjectMaterialsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_editing_project_materials(
        self,
        request: ice20201109_models.AddEditingProjectMaterialsRequest,
    ) -> ice20201109_models.AddEditingProjectMaterialsResponse:
        """
        @summary Adds one or more materials to an online editing project.
        
        @param request: AddEditingProjectMaterialsRequest
        @return: AddEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_editing_project_materials_with_options(request, runtime)

    async def add_editing_project_materials_async(
        self,
        request: ice20201109_models.AddEditingProjectMaterialsRequest,
    ) -> ice20201109_models.AddEditingProjectMaterialsResponse:
        """
        @summary Adds one or more materials to an online editing project.
        
        @param request: AddEditingProjectMaterialsRequest
        @return: AddEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_editing_project_materials_with_options_async(request, runtime)

    def add_favorite_public_media_with_options(
        self,
        request: ice20201109_models.AddFavoritePublicMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddFavoritePublicMediaResponse:
        """
        @summary 收藏公共媒资
        
        @param request: AddFavoritePublicMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFavoritePublicMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFavoritePublicMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddFavoritePublicMediaResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_favorite_public_media_with_options_async(
        self,
        request: ice20201109_models.AddFavoritePublicMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddFavoritePublicMediaResponse:
        """
        @summary 收藏公共媒资
        
        @param request: AddFavoritePublicMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddFavoritePublicMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddFavoritePublicMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddFavoritePublicMediaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_favorite_public_media(
        self,
        request: ice20201109_models.AddFavoritePublicMediaRequest,
    ) -> ice20201109_models.AddFavoritePublicMediaResponse:
        """
        @summary 收藏公共媒资
        
        @param request: AddFavoritePublicMediaRequest
        @return: AddFavoritePublicMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_favorite_public_media_with_options(request, runtime)

    async def add_favorite_public_media_async(
        self,
        request: ice20201109_models.AddFavoritePublicMediaRequest,
    ) -> ice20201109_models.AddFavoritePublicMediaResponse:
        """
        @summary 收藏公共媒资
        
        @param request: AddFavoritePublicMediaRequest
        @return: AddFavoritePublicMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_favorite_public_media_with_options_async(request, runtime)

    def add_media_connect_flow_input_with_options(
        self,
        request: ice20201109_models.AddMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaConnectFlowInputResponse:
        """
        @summary Creates a source for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have only one source.
        ### [](#)Source type
        RTMP-PUSH: An input that you can push to the returned URL over the RTMP protocol.
        RTMP-PULL: An input that the MediaConnect flow pulls from the specified server over the RTMP protocol.
        SRT-Listener: An input that you can push to the returned URL over the SRT protocol.
        SRT-Caller: An input that the MediaConnect flow pulls from the specified server over the SRT protocol.
        Flow: An input that uses the output of another upstream flow. You must specify an upstream flow and its output. The output type of the upstream flow must be SRT-Listener or RTMP-PULL. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidrs):
            query['Cidrs'] = request.cidrs
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.input_from_url):
            query['InputFromUrl'] = request.input_from_url
        if not UtilClient.is_unset(request.input_name):
            query['InputName'] = request.input_name
        if not UtilClient.is_unset(request.input_protocol):
            query['InputProtocol'] = request.input_protocol
        if not UtilClient.is_unset(request.max_bitrate):
            query['MaxBitrate'] = request.max_bitrate
        if not UtilClient.is_unset(request.pair_flow_id):
            query['PairFlowId'] = request.pair_flow_id
        if not UtilClient.is_unset(request.pair_output_name):
            query['PairOutputName'] = request.pair_output_name
        if not UtilClient.is_unset(request.srt_latency):
            query['SrtLatency'] = request.srt_latency
        if not UtilClient.is_unset(request.srt_passphrase):
            query['SrtPassphrase'] = request.srt_passphrase
        if not UtilClient.is_unset(request.srt_pbkey_len):
            query['SrtPbkeyLen'] = request.srt_pbkey_len
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaConnectFlowInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_media_connect_flow_input_with_options_async(
        self,
        request: ice20201109_models.AddMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaConnectFlowInputResponse:
        """
        @summary Creates a source for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have only one source.
        ### [](#)Source type
        RTMP-PUSH: An input that you can push to the returned URL over the RTMP protocol.
        RTMP-PULL: An input that the MediaConnect flow pulls from the specified server over the RTMP protocol.
        SRT-Listener: An input that you can push to the returned URL over the SRT protocol.
        SRT-Caller: An input that the MediaConnect flow pulls from the specified server over the SRT protocol.
        Flow: An input that uses the output of another upstream flow. You must specify an upstream flow and its output. The output type of the upstream flow must be SRT-Listener or RTMP-PULL. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidrs):
            query['Cidrs'] = request.cidrs
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.input_from_url):
            query['InputFromUrl'] = request.input_from_url
        if not UtilClient.is_unset(request.input_name):
            query['InputName'] = request.input_name
        if not UtilClient.is_unset(request.input_protocol):
            query['InputProtocol'] = request.input_protocol
        if not UtilClient.is_unset(request.max_bitrate):
            query['MaxBitrate'] = request.max_bitrate
        if not UtilClient.is_unset(request.pair_flow_id):
            query['PairFlowId'] = request.pair_flow_id
        if not UtilClient.is_unset(request.pair_output_name):
            query['PairOutputName'] = request.pair_output_name
        if not UtilClient.is_unset(request.srt_latency):
            query['SrtLatency'] = request.srt_latency
        if not UtilClient.is_unset(request.srt_passphrase):
            query['SrtPassphrase'] = request.srt_passphrase
        if not UtilClient.is_unset(request.srt_pbkey_len):
            query['SrtPbkeyLen'] = request.srt_pbkey_len
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaConnectFlowInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_media_connect_flow_input(
        self,
        request: ice20201109_models.AddMediaConnectFlowInputRequest,
    ) -> ice20201109_models.AddMediaConnectFlowInputResponse:
        """
        @summary Creates a source for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have only one source.
        ### [](#)Source type
        RTMP-PUSH: An input that you can push to the returned URL over the RTMP protocol.
        RTMP-PULL: An input that the MediaConnect flow pulls from the specified server over the RTMP protocol.
        SRT-Listener: An input that you can push to the returned URL over the SRT protocol.
        SRT-Caller: An input that the MediaConnect flow pulls from the specified server over the SRT protocol.
        Flow: An input that uses the output of another upstream flow. You must specify an upstream flow and its output. The output type of the upstream flow must be SRT-Listener or RTMP-PULL. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowInputRequest
        @return: AddMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_media_connect_flow_input_with_options(request, runtime)

    async def add_media_connect_flow_input_async(
        self,
        request: ice20201109_models.AddMediaConnectFlowInputRequest,
    ) -> ice20201109_models.AddMediaConnectFlowInputResponse:
        """
        @summary Creates a source for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have only one source.
        ### [](#)Source type
        RTMP-PUSH: An input that you can push to the returned URL over the RTMP protocol.
        RTMP-PULL: An input that the MediaConnect flow pulls from the specified server over the RTMP protocol.
        SRT-Listener: An input that you can push to the returned URL over the SRT protocol.
        SRT-Caller: An input that the MediaConnect flow pulls from the specified server over the SRT protocol.
        Flow: An input that uses the output of another upstream flow. You must specify an upstream flow and its output. The output type of the upstream flow must be SRT-Listener or RTMP-PULL. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowInputRequest
        @return: AddMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_media_connect_flow_input_with_options_async(request, runtime)

    def add_media_connect_flow_output_with_options(
        self,
        request: ice20201109_models.AddMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaConnectFlowOutputResponse:
        """
        @summary Creates an output for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have a maximum of four outputs.
        The output names in the same flow cannot be duplicated.
        You can set an upper limit on the number of concurrent viewers for each output. If this limit is exceeded, any new playback requests will fail. Each output supports up to five streams.
        ### [](#)Output types
        RTMP-PUSH: An output that the MediaConnect flow pushes to the server you specified over the RTMP protocol.
        RTMP-PULL: An output that you can pull using the returned streaming URL over the RTMP protocol.
        SRT-Caller: An output that the MediaConnect flow pushes to the server you specified over the SRT protocol.
        SRT-Listener: An output that you can pull using the returned streaming URL over the SRT protocol.
        Flow: An output that is pushed to the source URL of another MediaConnect flow. The source type of the destination flow must be SRT-Listener or RTMP-PUSH. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidrs):
            query['Cidrs'] = request.cidrs
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        if not UtilClient.is_unset(request.output_protocol):
            query['OutputProtocol'] = request.output_protocol
        if not UtilClient.is_unset(request.output_to_url):
            query['OutputToUrl'] = request.output_to_url
        if not UtilClient.is_unset(request.pair_flow_id):
            query['PairFlowId'] = request.pair_flow_id
        if not UtilClient.is_unset(request.pair_input_name):
            query['PairInputName'] = request.pair_input_name
        if not UtilClient.is_unset(request.player_limit):
            query['PlayerLimit'] = request.player_limit
        if not UtilClient.is_unset(request.srt_latency):
            query['SrtLatency'] = request.srt_latency
        if not UtilClient.is_unset(request.srt_passphrase):
            query['SrtPassphrase'] = request.srt_passphrase
        if not UtilClient.is_unset(request.srt_pbkey_len):
            query['SrtPbkeyLen'] = request.srt_pbkey_len
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaConnectFlowOutputResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_media_connect_flow_output_with_options_async(
        self,
        request: ice20201109_models.AddMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaConnectFlowOutputResponse:
        """
        @summary Creates an output for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have a maximum of four outputs.
        The output names in the same flow cannot be duplicated.
        You can set an upper limit on the number of concurrent viewers for each output. If this limit is exceeded, any new playback requests will fail. Each output supports up to five streams.
        ### [](#)Output types
        RTMP-PUSH: An output that the MediaConnect flow pushes to the server you specified over the RTMP protocol.
        RTMP-PULL: An output that you can pull using the returned streaming URL over the RTMP protocol.
        SRT-Caller: An output that the MediaConnect flow pushes to the server you specified over the SRT protocol.
        SRT-Listener: An output that you can pull using the returned streaming URL over the SRT protocol.
        Flow: An output that is pushed to the source URL of another MediaConnect flow. The source type of the destination flow must be SRT-Listener or RTMP-PUSH. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidrs):
            query['Cidrs'] = request.cidrs
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        if not UtilClient.is_unset(request.output_protocol):
            query['OutputProtocol'] = request.output_protocol
        if not UtilClient.is_unset(request.output_to_url):
            query['OutputToUrl'] = request.output_to_url
        if not UtilClient.is_unset(request.pair_flow_id):
            query['PairFlowId'] = request.pair_flow_id
        if not UtilClient.is_unset(request.pair_input_name):
            query['PairInputName'] = request.pair_input_name
        if not UtilClient.is_unset(request.player_limit):
            query['PlayerLimit'] = request.player_limit
        if not UtilClient.is_unset(request.srt_latency):
            query['SrtLatency'] = request.srt_latency
        if not UtilClient.is_unset(request.srt_passphrase):
            query['SrtPassphrase'] = request.srt_passphrase
        if not UtilClient.is_unset(request.srt_pbkey_len):
            query['SrtPbkeyLen'] = request.srt_pbkey_len
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaConnectFlowOutputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_media_connect_flow_output(
        self,
        request: ice20201109_models.AddMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.AddMediaConnectFlowOutputResponse:
        """
        @summary Creates an output for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have a maximum of four outputs.
        The output names in the same flow cannot be duplicated.
        You can set an upper limit on the number of concurrent viewers for each output. If this limit is exceeded, any new playback requests will fail. Each output supports up to five streams.
        ### [](#)Output types
        RTMP-PUSH: An output that the MediaConnect flow pushes to the server you specified over the RTMP protocol.
        RTMP-PULL: An output that you can pull using the returned streaming URL over the RTMP protocol.
        SRT-Caller: An output that the MediaConnect flow pushes to the server you specified over the SRT protocol.
        SRT-Listener: An output that you can pull using the returned streaming URL over the SRT protocol.
        Flow: An output that is pushed to the source URL of another MediaConnect flow. The source type of the destination flow must be SRT-Listener or RTMP-PUSH. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowOutputRequest
        @return: AddMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_media_connect_flow_output_with_options(request, runtime)

    async def add_media_connect_flow_output_async(
        self,
        request: ice20201109_models.AddMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.AddMediaConnectFlowOutputResponse:
        """
        @summary Creates an output for a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        A flow can have a maximum of four outputs.
        The output names in the same flow cannot be duplicated.
        You can set an upper limit on the number of concurrent viewers for each output. If this limit is exceeded, any new playback requests will fail. Each output supports up to five streams.
        ### [](#)Output types
        RTMP-PUSH: An output that the MediaConnect flow pushes to the server you specified over the RTMP protocol.
        RTMP-PULL: An output that you can pull using the returned streaming URL over the RTMP protocol.
        SRT-Caller: An output that the MediaConnect flow pushes to the server you specified over the SRT protocol.
        SRT-Listener: An output that you can pull using the returned streaming URL over the SRT protocol.
        Flow: An output that is pushed to the source URL of another MediaConnect flow. The source type of the destination flow must be SRT-Listener or RTMP-PUSH. By default, a dedicated line is used when flows are cascaded. This allows for cross-region distribution among multiple flows.
        
        @param request: AddMediaConnectFlowOutputRequest
        @return: AddMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_media_connect_flow_output_with_options_async(request, runtime)

    def add_media_marks_with_options(
        self,
        request: ice20201109_models.AddMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaMarksResponse:
        """
        @summary Adds marks for a media asset.
        
        @param request: AddMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_marks):
            query['MediaMarks'] = request.media_marks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaMarksResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_media_marks_with_options_async(
        self,
        request: ice20201109_models.AddMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddMediaMarksResponse:
        """
        @summary Adds marks for a media asset.
        
        @param request: AddMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_marks):
            query['MediaMarks'] = request.media_marks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddMediaMarksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_media_marks(
        self,
        request: ice20201109_models.AddMediaMarksRequest,
    ) -> ice20201109_models.AddMediaMarksResponse:
        """
        @summary Adds marks for a media asset.
        
        @param request: AddMediaMarksRequest
        @return: AddMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_media_marks_with_options(request, runtime)

    async def add_media_marks_async(
        self,
        request: ice20201109_models.AddMediaMarksRequest,
    ) -> ice20201109_models.AddMediaMarksResponse:
        """
        @summary Adds marks for a media asset.
        
        @param request: AddMediaMarksRequest
        @return: AddMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_media_marks_with_options_async(request, runtime)

    def add_template_with_options(
        self,
        request: ice20201109_models.AddTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddTemplateResponse:
        """
        @summary Creates a template.
        
        @description    For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        After an advanced template is created, it enters the Processing state. In this case, the template is unavailable. The template can be used only when it is in the Available state. The time required for template processing varies based on the size of the template file. Generally, it ranges from 10 seconds to 5 minutes.
        
        @param request: AddTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cover_url):
            query['CoverUrl'] = request.cover_url
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.preview_media):
            query['PreviewMedia'] = request.preview_media
        if not UtilClient.is_unset(request.related_mediaids):
            query['RelatedMediaids'] = request.related_mediaids
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        body = {}
        if not UtilClient.is_unset(request.config):
            body['Config'] = request.config
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_template_with_options_async(
        self,
        request: ice20201109_models.AddTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AddTemplateResponse:
        """
        @summary Creates a template.
        
        @description    For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        After an advanced template is created, it enters the Processing state. In this case, the template is unavailable. The template can be used only when it is in the Available state. The time required for template processing varies based on the size of the template file. Generally, it ranges from 10 seconds to 5 minutes.
        
        @param request: AddTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cover_url):
            query['CoverUrl'] = request.cover_url
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.preview_media):
            query['PreviewMedia'] = request.preview_media
        if not UtilClient.is_unset(request.related_mediaids):
            query['RelatedMediaids'] = request.related_mediaids
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        body = {}
        if not UtilClient.is_unset(request.config):
            body['Config'] = request.config
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AddTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_template(
        self,
        request: ice20201109_models.AddTemplateRequest,
    ) -> ice20201109_models.AddTemplateResponse:
        """
        @summary Creates a template.
        
        @description    For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        After an advanced template is created, it enters the Processing state. In this case, the template is unavailable. The template can be used only when it is in the Available state. The time required for template processing varies based on the size of the template file. Generally, it ranges from 10 seconds to 5 minutes.
        
        @param request: AddTemplateRequest
        @return: AddTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_template_with_options(request, runtime)

    async def add_template_async(
        self,
        request: ice20201109_models.AddTemplateRequest,
    ) -> ice20201109_models.AddTemplateResponse:
        """
        @summary Creates a template.
        
        @description    For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        After an advanced template is created, it enters the Processing state. In this case, the template is unavailable. The template can be used only when it is in the Available state. The time required for template processing varies based on the size of the template file. Generally, it ranges from 10 seconds to 5 minutes.
        
        @param request: AddTemplateRequest
        @return: AddTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_template_with_options_async(request, runtime)

    def alter_search_index_with_options(
        self,
        request: ice20201109_models.AlterSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AlterSearchIndexResponse:
        """
        @summary Modifies search index information including index status and configurations.
        
        @param request: AlterSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AlterSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_status):
            query['IndexStatus'] = request.index_status
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AlterSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AlterSearchIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def alter_search_index_with_options_async(
        self,
        request: ice20201109_models.AlterSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.AlterSearchIndexResponse:
        """
        @summary Modifies search index information including index status and configurations.
        
        @param request: AlterSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AlterSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_status):
            query['IndexStatus'] = request.index_status
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AlterSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.AlterSearchIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def alter_search_index(
        self,
        request: ice20201109_models.AlterSearchIndexRequest,
    ) -> ice20201109_models.AlterSearchIndexResponse:
        """
        @summary Modifies search index information including index status and configurations.
        
        @param request: AlterSearchIndexRequest
        @return: AlterSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.alter_search_index_with_options(request, runtime)

    async def alter_search_index_async(
        self,
        request: ice20201109_models.AlterSearchIndexRequest,
    ) -> ice20201109_models.AlterSearchIndexResponse:
        """
        @summary Modifies search index information including index status and configurations.
        
        @param request: AlterSearchIndexRequest
        @return: AlterSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.alter_search_index_with_options_async(request, runtime)

    def batch_create_vod_packaging_asset_with_options(
        self,
        tmp_req: ice20201109_models.BatchCreateVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.BatchCreateVodPackagingAssetResponse:
        """
        @summary Ingests multiple assets for VOD packaging.
        
        @param tmp_req: BatchCreateVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCreateVodPackagingAssetResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.BatchCreateVodPackagingAssetShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.assets):
            request.assets_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.assets, 'Assets', 'json')
        query = {}
        if not UtilClient.is_unset(request.assets_shrink):
            query['Assets'] = request.assets_shrink
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCreateVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.BatchCreateVodPackagingAssetResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_create_vod_packaging_asset_with_options_async(
        self,
        tmp_req: ice20201109_models.BatchCreateVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.BatchCreateVodPackagingAssetResponse:
        """
        @summary Ingests multiple assets for VOD packaging.
        
        @param tmp_req: BatchCreateVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCreateVodPackagingAssetResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.BatchCreateVodPackagingAssetShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.assets):
            request.assets_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.assets, 'Assets', 'json')
        query = {}
        if not UtilClient.is_unset(request.assets_shrink):
            query['Assets'] = request.assets_shrink
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCreateVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.BatchCreateVodPackagingAssetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_create_vod_packaging_asset(
        self,
        request: ice20201109_models.BatchCreateVodPackagingAssetRequest,
    ) -> ice20201109_models.BatchCreateVodPackagingAssetResponse:
        """
        @summary Ingests multiple assets for VOD packaging.
        
        @param request: BatchCreateVodPackagingAssetRequest
        @return: BatchCreateVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_create_vod_packaging_asset_with_options(request, runtime)

    async def batch_create_vod_packaging_asset_async(
        self,
        request: ice20201109_models.BatchCreateVodPackagingAssetRequest,
    ) -> ice20201109_models.BatchCreateVodPackagingAssetResponse:
        """
        @summary Ingests multiple assets for VOD packaging.
        
        @param request: BatchCreateVodPackagingAssetRequest
        @return: BatchCreateVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_create_vod_packaging_asset_with_options_async(request, runtime)

    def batch_get_media_infos_with_options(
        self,
        request: ice20201109_models.BatchGetMediaInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.BatchGetMediaInfosResponse:
        """
        @summary Queries the information about multiple media assets at a time based on media asset IDs.
        
        @param request: BatchGetMediaInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchGetMediaInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.addition_type):
            query['AdditionType'] = request.addition_type
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchGetMediaInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.BatchGetMediaInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_get_media_infos_with_options_async(
        self,
        request: ice20201109_models.BatchGetMediaInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.BatchGetMediaInfosResponse:
        """
        @summary Queries the information about multiple media assets at a time based on media asset IDs.
        
        @param request: BatchGetMediaInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchGetMediaInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.addition_type):
            query['AdditionType'] = request.addition_type
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchGetMediaInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.BatchGetMediaInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_get_media_infos(
        self,
        request: ice20201109_models.BatchGetMediaInfosRequest,
    ) -> ice20201109_models.BatchGetMediaInfosResponse:
        """
        @summary Queries the information about multiple media assets at a time based on media asset IDs.
        
        @param request: BatchGetMediaInfosRequest
        @return: BatchGetMediaInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_get_media_infos_with_options(request, runtime)

    async def batch_get_media_infos_async(
        self,
        request: ice20201109_models.BatchGetMediaInfosRequest,
    ) -> ice20201109_models.BatchGetMediaInfosResponse:
        """
        @summary Queries the information about multiple media assets at a time based on media asset IDs.
        
        @param request: BatchGetMediaInfosRequest
        @return: BatchGetMediaInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_get_media_infos_with_options_async(request, runtime)

    def cancel_dnajob_with_options(
        self,
        request: ice20201109_models.CancelDNAJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelDNAJobResponse:
        """
        @summary Cancels a media fingerprint analysis job.
        
        @description    You can cancel a media fingerprint analysis job only if the job is in the Queuing state.
        We recommend that you call the **UpdatePipeline** operation to set the status of the ApsaraVideo Media Processing (MPS) queue to Paused before you cancel a job. This suspends job scheduling in the MPS queue. After the job is canceled, you must set the status of the MPS queue back to Active so that the other jobs in the MPS queue can be scheduled.
        
        @param request: CancelDNAJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelDNAJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelDNAJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelDNAJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_dnajob_with_options_async(
        self,
        request: ice20201109_models.CancelDNAJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelDNAJobResponse:
        """
        @summary Cancels a media fingerprint analysis job.
        
        @description    You can cancel a media fingerprint analysis job only if the job is in the Queuing state.
        We recommend that you call the **UpdatePipeline** operation to set the status of the ApsaraVideo Media Processing (MPS) queue to Paused before you cancel a job. This suspends job scheduling in the MPS queue. After the job is canceled, you must set the status of the MPS queue back to Active so that the other jobs in the MPS queue can be scheduled.
        
        @param request: CancelDNAJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelDNAJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelDNAJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelDNAJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_dnajob(
        self,
        request: ice20201109_models.CancelDNAJobRequest,
    ) -> ice20201109_models.CancelDNAJobResponse:
        """
        @summary Cancels a media fingerprint analysis job.
        
        @description    You can cancel a media fingerprint analysis job only if the job is in the Queuing state.
        We recommend that you call the **UpdatePipeline** operation to set the status of the ApsaraVideo Media Processing (MPS) queue to Paused before you cancel a job. This suspends job scheduling in the MPS queue. After the job is canceled, you must set the status of the MPS queue back to Active so that the other jobs in the MPS queue can be scheduled.
        
        @param request: CancelDNAJobRequest
        @return: CancelDNAJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_dnajob_with_options(request, runtime)

    async def cancel_dnajob_async(
        self,
        request: ice20201109_models.CancelDNAJobRequest,
    ) -> ice20201109_models.CancelDNAJobResponse:
        """
        @summary Cancels a media fingerprint analysis job.
        
        @description    You can cancel a media fingerprint analysis job only if the job is in the Queuing state.
        We recommend that you call the **UpdatePipeline** operation to set the status of the ApsaraVideo Media Processing (MPS) queue to Paused before you cancel a job. This suspends job scheduling in the MPS queue. After the job is canceled, you must set the status of the MPS queue back to Active so that the other jobs in the MPS queue can be scheduled.
        
        @param request: CancelDNAJobRequest
        @return: CancelDNAJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_dnajob_with_options_async(request, runtime)

    def cancel_favorite_public_media_with_options(
        self,
        request: ice20201109_models.CancelFavoritePublicMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelFavoritePublicMediaResponse:
        """
        @summary 取消收藏公共媒资
        
        @param request: CancelFavoritePublicMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelFavoritePublicMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelFavoritePublicMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelFavoritePublicMediaResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_favorite_public_media_with_options_async(
        self,
        request: ice20201109_models.CancelFavoritePublicMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelFavoritePublicMediaResponse:
        """
        @summary 取消收藏公共媒资
        
        @param request: CancelFavoritePublicMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelFavoritePublicMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelFavoritePublicMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelFavoritePublicMediaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_favorite_public_media(
        self,
        request: ice20201109_models.CancelFavoritePublicMediaRequest,
    ) -> ice20201109_models.CancelFavoritePublicMediaResponse:
        """
        @summary 取消收藏公共媒资
        
        @param request: CancelFavoritePublicMediaRequest
        @return: CancelFavoritePublicMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_favorite_public_media_with_options(request, runtime)

    async def cancel_favorite_public_media_async(
        self,
        request: ice20201109_models.CancelFavoritePublicMediaRequest,
    ) -> ice20201109_models.CancelFavoritePublicMediaResponse:
        """
        @summary 取消收藏公共媒资
        
        @param request: CancelFavoritePublicMediaRequest
        @return: CancelFavoritePublicMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_favorite_public_media_with_options_async(request, runtime)

    def cancel_iproduction_job_with_options(
        self,
        request: ice20201109_models.CancelIProductionJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelIProductionJobResponse:
        """
        @summary 取消智能生产任务
        
        @param request: CancelIProductionJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelIProductionJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelIProductionJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelIProductionJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_iproduction_job_with_options_async(
        self,
        request: ice20201109_models.CancelIProductionJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CancelIProductionJobResponse:
        """
        @summary 取消智能生产任务
        
        @param request: CancelIProductionJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelIProductionJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelIProductionJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CancelIProductionJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_iproduction_job(
        self,
        request: ice20201109_models.CancelIProductionJobRequest,
    ) -> ice20201109_models.CancelIProductionJobResponse:
        """
        @summary 取消智能生产任务
        
        @param request: CancelIProductionJobRequest
        @return: CancelIProductionJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_iproduction_job_with_options(request, runtime)

    async def cancel_iproduction_job_async(
        self,
        request: ice20201109_models.CancelIProductionJobRequest,
    ) -> ice20201109_models.CancelIProductionJobResponse:
        """
        @summary 取消智能生产任务
        
        @param request: CancelIProductionJobRequest
        @return: CancelIProductionJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_iproduction_job_with_options_async(request, runtime)

    def clear_aiagent_voiceprint_with_options(
        self,
        request: ice20201109_models.ClearAIAgentVoiceprintRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ClearAIAgentVoiceprintResponse:
        """
        @summary 清除声纹ID对应的声纹
        
        @param request: ClearAIAgentVoiceprintRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClearAIAgentVoiceprintResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.voiceprint_id):
            query['VoiceprintId'] = request.voiceprint_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ClearAIAgentVoiceprint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ClearAIAgentVoiceprintResponse(),
            self.call_api(params, req, runtime)
        )

    async def clear_aiagent_voiceprint_with_options_async(
        self,
        request: ice20201109_models.ClearAIAgentVoiceprintRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ClearAIAgentVoiceprintResponse:
        """
        @summary 清除声纹ID对应的声纹
        
        @param request: ClearAIAgentVoiceprintRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClearAIAgentVoiceprintResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.voiceprint_id):
            query['VoiceprintId'] = request.voiceprint_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ClearAIAgentVoiceprint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ClearAIAgentVoiceprintResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clear_aiagent_voiceprint(
        self,
        request: ice20201109_models.ClearAIAgentVoiceprintRequest,
    ) -> ice20201109_models.ClearAIAgentVoiceprintResponse:
        """
        @summary 清除声纹ID对应的声纹
        
        @param request: ClearAIAgentVoiceprintRequest
        @return: ClearAIAgentVoiceprintResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clear_aiagent_voiceprint_with_options(request, runtime)

    async def clear_aiagent_voiceprint_async(
        self,
        request: ice20201109_models.ClearAIAgentVoiceprintRequest,
    ) -> ice20201109_models.ClearAIAgentVoiceprintResponse:
        """
        @summary 清除声纹ID对应的声纹
        
        @param request: ClearAIAgentVoiceprintRequest
        @return: ClearAIAgentVoiceprintResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clear_aiagent_voiceprint_with_options_async(request, runtime)

    def close_media_connect_flow_failover_with_options(
        self,
        request: ice20201109_models.CloseMediaConnectFlowFailoverRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CloseMediaConnectFlowFailoverResponse:
        """
        @summary 关闭MediaConnect实例的双流灾备功能
        
        @param request: CloseMediaConnectFlowFailoverRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseMediaConnectFlowFailoverResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseMediaConnectFlowFailover',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CloseMediaConnectFlowFailoverResponse(),
            self.call_api(params, req, runtime)
        )

    async def close_media_connect_flow_failover_with_options_async(
        self,
        request: ice20201109_models.CloseMediaConnectFlowFailoverRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CloseMediaConnectFlowFailoverResponse:
        """
        @summary 关闭MediaConnect实例的双流灾备功能
        
        @param request: CloseMediaConnectFlowFailoverRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseMediaConnectFlowFailoverResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseMediaConnectFlowFailover',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CloseMediaConnectFlowFailoverResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def close_media_connect_flow_failover(
        self,
        request: ice20201109_models.CloseMediaConnectFlowFailoverRequest,
    ) -> ice20201109_models.CloseMediaConnectFlowFailoverResponse:
        """
        @summary 关闭MediaConnect实例的双流灾备功能
        
        @param request: CloseMediaConnectFlowFailoverRequest
        @return: CloseMediaConnectFlowFailoverResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.close_media_connect_flow_failover_with_options(request, runtime)

    async def close_media_connect_flow_failover_async(
        self,
        request: ice20201109_models.CloseMediaConnectFlowFailoverRequest,
    ) -> ice20201109_models.CloseMediaConnectFlowFailoverResponse:
        """
        @summary 关闭MediaConnect实例的双流灾备功能
        
        @param request: CloseMediaConnectFlowFailoverRequest
        @return: CloseMediaConnectFlowFailoverResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.close_media_connect_flow_failover_with_options_async(request, runtime)

    def create_audit_with_options(
        self,
        request: ice20201109_models.CreateAuditRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateAuditResponse:
        """
        @summary Submits manual review results for media assets.
        
        @param request: CreateAuditRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAuditResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audit_content):
            query['AuditContent'] = request.audit_content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAudit',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateAuditResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_audit_with_options_async(
        self,
        request: ice20201109_models.CreateAuditRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateAuditResponse:
        """
        @summary Submits manual review results for media assets.
        
        @param request: CreateAuditRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAuditResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audit_content):
            query['AuditContent'] = request.audit_content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAudit',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateAuditResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_audit(
        self,
        request: ice20201109_models.CreateAuditRequest,
    ) -> ice20201109_models.CreateAuditResponse:
        """
        @summary Submits manual review results for media assets.
        
        @param request: CreateAuditRequest
        @return: CreateAuditResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_audit_with_options(request, runtime)

    async def create_audit_async(
        self,
        request: ice20201109_models.CreateAuditRequest,
    ) -> ice20201109_models.CreateAuditResponse:
        """
        @summary Submits manual review results for media assets.
        
        @param request: CreateAuditRequest
        @return: CreateAuditResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_audit_with_options_async(request, runtime)

    def create_avatar_training_job_with_options(
        self,
        request: ice20201109_models.CreateAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateAvatarTrainingJobResponse:
        """
        @summary Creates a digital human training job. You can configure the basic information of the digital human and the materials required for the training. Note: This operation is used to initialize the training job. It does not submit the training job. To submit the training job, call the SubmitAvatarTrainingJob operation.
        
        @param request: CreateAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_description):
            query['AvatarDescription'] = request.avatar_description
        if not UtilClient.is_unset(request.avatar_name):
            query['AvatarName'] = request.avatar_name
        if not UtilClient.is_unset(request.avatar_type):
            query['AvatarType'] = request.avatar_type
        if not UtilClient.is_unset(request.portrait):
            query['Portrait'] = request.portrait
        if not UtilClient.is_unset(request.thumbnail):
            query['Thumbnail'] = request.thumbnail
        if not UtilClient.is_unset(request.transparent):
            query['Transparent'] = request.transparent
        if not UtilClient.is_unset(request.video):
            query['Video'] = request.video
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateAvatarTrainingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_avatar_training_job_with_options_async(
        self,
        request: ice20201109_models.CreateAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateAvatarTrainingJobResponse:
        """
        @summary Creates a digital human training job. You can configure the basic information of the digital human and the materials required for the training. Note: This operation is used to initialize the training job. It does not submit the training job. To submit the training job, call the SubmitAvatarTrainingJob operation.
        
        @param request: CreateAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_description):
            query['AvatarDescription'] = request.avatar_description
        if not UtilClient.is_unset(request.avatar_name):
            query['AvatarName'] = request.avatar_name
        if not UtilClient.is_unset(request.avatar_type):
            query['AvatarType'] = request.avatar_type
        if not UtilClient.is_unset(request.portrait):
            query['Portrait'] = request.portrait
        if not UtilClient.is_unset(request.thumbnail):
            query['Thumbnail'] = request.thumbnail
        if not UtilClient.is_unset(request.transparent):
            query['Transparent'] = request.transparent
        if not UtilClient.is_unset(request.video):
            query['Video'] = request.video
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateAvatarTrainingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_avatar_training_job(
        self,
        request: ice20201109_models.CreateAvatarTrainingJobRequest,
    ) -> ice20201109_models.CreateAvatarTrainingJobResponse:
        """
        @summary Creates a digital human training job. You can configure the basic information of the digital human and the materials required for the training. Note: This operation is used to initialize the training job. It does not submit the training job. To submit the training job, call the SubmitAvatarTrainingJob operation.
        
        @param request: CreateAvatarTrainingJobRequest
        @return: CreateAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_avatar_training_job_with_options(request, runtime)

    async def create_avatar_training_job_async(
        self,
        request: ice20201109_models.CreateAvatarTrainingJobRequest,
    ) -> ice20201109_models.CreateAvatarTrainingJobResponse:
        """
        @summary Creates a digital human training job. You can configure the basic information of the digital human and the materials required for the training. Note: This operation is used to initialize the training job. It does not submit the training job. To submit the training job, call the SubmitAvatarTrainingJob operation.
        
        @param request: CreateAvatarTrainingJobRequest
        @return: CreateAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_avatar_training_job_with_options_async(request, runtime)

    def create_channel_with_options(
        self,
        request: ice20201109_models.CreateChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateChannelResponse:
        """
        @summary Creates a channel in MediaWeaver.
        
        @param request: CreateChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_policy):
            query['AccessPolicy'] = request.access_policy
        if not UtilClient.is_unset(request.access_token):
            query['AccessToken'] = request.access_token
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.channel_tier):
            query['ChannelTier'] = request.channel_tier
        if not UtilClient.is_unset(request.filler_source_location_name):
            query['FillerSourceLocationName'] = request.filler_source_location_name
        if not UtilClient.is_unset(request.filler_source_name):
            query['FillerSourceName'] = request.filler_source_name
        if not UtilClient.is_unset(request.out_put_config_list):
            query['OutPutConfigList'] = request.out_put_config_list
        if not UtilClient.is_unset(request.playback_mode):
            query['PlaybackMode'] = request.playback_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_channel_with_options_async(
        self,
        request: ice20201109_models.CreateChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateChannelResponse:
        """
        @summary Creates a channel in MediaWeaver.
        
        @param request: CreateChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_policy):
            query['AccessPolicy'] = request.access_policy
        if not UtilClient.is_unset(request.access_token):
            query['AccessToken'] = request.access_token
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.channel_tier):
            query['ChannelTier'] = request.channel_tier
        if not UtilClient.is_unset(request.filler_source_location_name):
            query['FillerSourceLocationName'] = request.filler_source_location_name
        if not UtilClient.is_unset(request.filler_source_name):
            query['FillerSourceName'] = request.filler_source_name
        if not UtilClient.is_unset(request.out_put_config_list):
            query['OutPutConfigList'] = request.out_put_config_list
        if not UtilClient.is_unset(request.playback_mode):
            query['PlaybackMode'] = request.playback_mode
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_channel(
        self,
        request: ice20201109_models.CreateChannelRequest,
    ) -> ice20201109_models.CreateChannelResponse:
        """
        @summary Creates a channel in MediaWeaver.
        
        @param request: CreateChannelRequest
        @return: CreateChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_channel_with_options(request, runtime)

    async def create_channel_async(
        self,
        request: ice20201109_models.CreateChannelRequest,
    ) -> ice20201109_models.CreateChannelResponse:
        """
        @summary Creates a channel in MediaWeaver.
        
        @param request: CreateChannelRequest
        @return: CreateChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_channel_with_options_async(request, runtime)

    def create_custom_template_with_options(
        self,
        request: ice20201109_models.CreateCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom template.
        
        @param request: CreateCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_config):
            query['TemplateConfig'] = request.template_config
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateCustomTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_custom_template_with_options_async(
        self,
        request: ice20201109_models.CreateCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom template.
        
        @param request: CreateCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_config):
            query['TemplateConfig'] = request.template_config
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateCustomTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_custom_template(
        self,
        request: ice20201109_models.CreateCustomTemplateRequest,
    ) -> ice20201109_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom template.
        
        @param request: CreateCustomTemplateRequest
        @return: CreateCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_custom_template_with_options(request, runtime)

    async def create_custom_template_async(
        self,
        request: ice20201109_models.CreateCustomTemplateRequest,
    ) -> ice20201109_models.CreateCustomTemplateResponse:
        """
        @summary Creates a custom template.
        
        @param request: CreateCustomTemplateRequest
        @return: CreateCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_custom_template_with_options_async(request, runtime)

    def create_customized_voice_job_with_options(
        self,
        request: ice20201109_models.CreateCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateCustomizedVoiceJobResponse:
        """
        @summary Creates a human voice cloning job. You can configure the basic information of the human voice cloning job.
        
        @param request: CreateCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gender):
            query['Gender'] = request.gender
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        if not UtilClient.is_unset(request.voice_desc):
            query['VoiceDesc'] = request.voice_desc
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        if not UtilClient.is_unset(request.voice_name):
            query['VoiceName'] = request.voice_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateCustomizedVoiceJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_customized_voice_job_with_options_async(
        self,
        request: ice20201109_models.CreateCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateCustomizedVoiceJobResponse:
        """
        @summary Creates a human voice cloning job. You can configure the basic information of the human voice cloning job.
        
        @param request: CreateCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gender):
            query['Gender'] = request.gender
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        if not UtilClient.is_unset(request.voice_desc):
            query['VoiceDesc'] = request.voice_desc
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        if not UtilClient.is_unset(request.voice_name):
            query['VoiceName'] = request.voice_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateCustomizedVoiceJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_customized_voice_job(
        self,
        request: ice20201109_models.CreateCustomizedVoiceJobRequest,
    ) -> ice20201109_models.CreateCustomizedVoiceJobResponse:
        """
        @summary Creates a human voice cloning job. You can configure the basic information of the human voice cloning job.
        
        @param request: CreateCustomizedVoiceJobRequest
        @return: CreateCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_customized_voice_job_with_options(request, runtime)

    async def create_customized_voice_job_async(
        self,
        request: ice20201109_models.CreateCustomizedVoiceJobRequest,
    ) -> ice20201109_models.CreateCustomizedVoiceJobResponse:
        """
        @summary Creates a human voice cloning job. You can configure the basic information of the human voice cloning job.
        
        @param request: CreateCustomizedVoiceJobRequest
        @return: CreateCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_customized_voice_job_with_options_async(request, runtime)

    def create_dnadbwith_options(
        self,
        request: ice20201109_models.CreateDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateDNADBResponse:
        """
        @summary Creates media fingerprint libraries.
        
        @description    You can create up to five media fingerprint libraries within an account. To increase the quota, submit a ticket. You can call the DeleteDNADB operation to delete the fingerprint libraries that you no longer need.
        
        @param request: CreateDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.model):
            query['Model'] = request.model
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateDNADBResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dnadbwith_options_async(
        self,
        request: ice20201109_models.CreateDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateDNADBResponse:
        """
        @summary Creates media fingerprint libraries.
        
        @description    You can create up to five media fingerprint libraries within an account. To increase the quota, submit a ticket. You can call the DeleteDNADB operation to delete the fingerprint libraries that you no longer need.
        
        @param request: CreateDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.model):
            query['Model'] = request.model
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateDNADBResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dnadb(
        self,
        request: ice20201109_models.CreateDNADBRequest,
    ) -> ice20201109_models.CreateDNADBResponse:
        """
        @summary Creates media fingerprint libraries.
        
        @description    You can create up to five media fingerprint libraries within an account. To increase the quota, submit a ticket. You can call the DeleteDNADB operation to delete the fingerprint libraries that you no longer need.
        
        @param request: CreateDNADBRequest
        @return: CreateDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dnadbwith_options(request, runtime)

    async def create_dnadb_async(
        self,
        request: ice20201109_models.CreateDNADBRequest,
    ) -> ice20201109_models.CreateDNADBResponse:
        """
        @summary Creates media fingerprint libraries.
        
        @description    You can create up to five media fingerprint libraries within an account. To increase the quota, submit a ticket. You can call the DeleteDNADB operation to delete the fingerprint libraries that you no longer need.
        
        @param request: CreateDNADBRequest
        @return: CreateDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dnadbwith_options_async(request, runtime)

    def create_editing_project_with_options(
        self,
        request: ice20201109_models.CreateEditingProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateEditingProjectResponse:
        """
        @summary Creates an online editing project. You can specify configurations such as the title, description, timeline, and thumbnail for the project.
        
        @param request: CreateEditingProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEditingProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_config):
            query['BusinessConfig'] = request.business_config
        if not UtilClient.is_unset(request.clips_param):
            query['ClipsParam'] = request.clips_param
        if not UtilClient.is_unset(request.cover_url):
            query['CoverURL'] = request.cover_url
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.material_maps):
            query['MaterialMaps'] = request.material_maps
        if not UtilClient.is_unset(request.project_type):
            query['ProjectType'] = request.project_type
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.title):
            query['Title'] = request.title
        body = {}
        if not UtilClient.is_unset(request.timeline):
            body['Timeline'] = request.timeline
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateEditingProject',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateEditingProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_editing_project_with_options_async(
        self,
        request: ice20201109_models.CreateEditingProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateEditingProjectResponse:
        """
        @summary Creates an online editing project. You can specify configurations such as the title, description, timeline, and thumbnail for the project.
        
        @param request: CreateEditingProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEditingProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_config):
            query['BusinessConfig'] = request.business_config
        if not UtilClient.is_unset(request.clips_param):
            query['ClipsParam'] = request.clips_param
        if not UtilClient.is_unset(request.cover_url):
            query['CoverURL'] = request.cover_url
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.material_maps):
            query['MaterialMaps'] = request.material_maps
        if not UtilClient.is_unset(request.project_type):
            query['ProjectType'] = request.project_type
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        if not UtilClient.is_unset(request.title):
            query['Title'] = request.title
        body = {}
        if not UtilClient.is_unset(request.timeline):
            body['Timeline'] = request.timeline
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateEditingProject',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateEditingProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_editing_project(
        self,
        request: ice20201109_models.CreateEditingProjectRequest,
    ) -> ice20201109_models.CreateEditingProjectResponse:
        """
        @summary Creates an online editing project. You can specify configurations such as the title, description, timeline, and thumbnail for the project.
        
        @param request: CreateEditingProjectRequest
        @return: CreateEditingProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_editing_project_with_options(request, runtime)

    async def create_editing_project_async(
        self,
        request: ice20201109_models.CreateEditingProjectRequest,
    ) -> ice20201109_models.CreateEditingProjectResponse:
        """
        @summary Creates an online editing project. You can specify configurations such as the title, description, timeline, and thumbnail for the project.
        
        @param request: CreateEditingProjectRequest
        @return: CreateEditingProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_editing_project_with_options_async(request, runtime)

    def create_hotword_library_with_options(
        self,
        tmp_req: ice20201109_models.CreateHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateHotwordLibraryResponse:
        """
        @summary 创建热词库
        
        @param tmp_req: CreateHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHotwordLibraryResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateHotwordLibraryShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.hotwords):
            request.hotwords_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hotwords, 'Hotwords', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.hotwords_shrink):
            query['Hotwords'] = request.hotwords_shrink
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.usage_scenario):
            query['UsageScenario'] = request.usage_scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateHotwordLibraryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_hotword_library_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateHotwordLibraryResponse:
        """
        @summary 创建热词库
        
        @param tmp_req: CreateHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHotwordLibraryResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateHotwordLibraryShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.hotwords):
            request.hotwords_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.hotwords, 'Hotwords', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.hotwords_shrink):
            query['Hotwords'] = request.hotwords_shrink
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.usage_scenario):
            query['UsageScenario'] = request.usage_scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateHotwordLibraryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_hotword_library(
        self,
        request: ice20201109_models.CreateHotwordLibraryRequest,
    ) -> ice20201109_models.CreateHotwordLibraryResponse:
        """
        @summary 创建热词库
        
        @param request: CreateHotwordLibraryRequest
        @return: CreateHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_hotword_library_with_options(request, runtime)

    async def create_hotword_library_async(
        self,
        request: ice20201109_models.CreateHotwordLibraryRequest,
    ) -> ice20201109_models.CreateHotwordLibraryResponse:
        """
        @summary 创建热词库
        
        @param request: CreateHotwordLibraryRequest
        @return: CreateHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_hotword_library_with_options_async(request, runtime)

    def create_live_package_channel_with_options(
        self,
        request: ice20201109_models.CreateLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageChannelResponse:
        """
        @summary Creates a live package channel.
        
        @description ## [](#)Usage notes
        After you call this operation to create a live package channel, the system will automatically generate the ingest endpoint URL, and username and password required for authentication.
        ### [](#)Precautions
        Channel group names and channel names can contain only letters, digits, underscores (_), and hyphens (-).
        Only `HLS` is supported.
        The segment duration must be from 1 to 30 seconds.
        The number of M3U8 segments must be from 2 to 100.
        If the request succeeds, the system will return the details of the newly created channel, including the channel name, creation time, modification time, and ingest endpoint details.
        
        @param request: CreateLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        body = {}
        if not UtilClient.is_unset(request.channel_name):
            body['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.protocol):
            body['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.segment_count):
            body['SegmentCount'] = request.segment_count
        if not UtilClient.is_unset(request.segment_duration):
            body['SegmentDuration'] = request.segment_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_package_channel_with_options_async(
        self,
        request: ice20201109_models.CreateLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageChannelResponse:
        """
        @summary Creates a live package channel.
        
        @description ## [](#)Usage notes
        After you call this operation to create a live package channel, the system will automatically generate the ingest endpoint URL, and username and password required for authentication.
        ### [](#)Precautions
        Channel group names and channel names can contain only letters, digits, underscores (_), and hyphens (-).
        Only `HLS` is supported.
        The segment duration must be from 1 to 30 seconds.
        The number of M3U8 segments must be from 2 to 100.
        If the request succeeds, the system will return the details of the newly created channel, including the channel name, creation time, modification time, and ingest endpoint details.
        
        @param request: CreateLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        body = {}
        if not UtilClient.is_unset(request.channel_name):
            body['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.protocol):
            body['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.segment_count):
            body['SegmentCount'] = request.segment_count
        if not UtilClient.is_unset(request.segment_duration):
            body['SegmentDuration'] = request.segment_duration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_package_channel(
        self,
        request: ice20201109_models.CreateLivePackageChannelRequest,
    ) -> ice20201109_models.CreateLivePackageChannelResponse:
        """
        @summary Creates a live package channel.
        
        @description ## [](#)Usage notes
        After you call this operation to create a live package channel, the system will automatically generate the ingest endpoint URL, and username and password required for authentication.
        ### [](#)Precautions
        Channel group names and channel names can contain only letters, digits, underscores (_), and hyphens (-).
        Only `HLS` is supported.
        The segment duration must be from 1 to 30 seconds.
        The number of M3U8 segments must be from 2 to 100.
        If the request succeeds, the system will return the details of the newly created channel, including the channel name, creation time, modification time, and ingest endpoint details.
        
        @param request: CreateLivePackageChannelRequest
        @return: CreateLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_package_channel_with_options(request, runtime)

    async def create_live_package_channel_async(
        self,
        request: ice20201109_models.CreateLivePackageChannelRequest,
    ) -> ice20201109_models.CreateLivePackageChannelResponse:
        """
        @summary Creates a live package channel.
        
        @description ## [](#)Usage notes
        After you call this operation to create a live package channel, the system will automatically generate the ingest endpoint URL, and username and password required for authentication.
        ### [](#)Precautions
        Channel group names and channel names can contain only letters, digits, underscores (_), and hyphens (-).
        Only `HLS` is supported.
        The segment duration must be from 1 to 30 seconds.
        The number of M3U8 segments must be from 2 to 100.
        If the request succeeds, the system will return the details of the newly created channel, including the channel name, creation time, modification time, and ingest endpoint details.
        
        @param request: CreateLivePackageChannelRequest
        @return: CreateLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_package_channel_with_options_async(request, runtime)

    def create_live_package_channel_group_with_options(
        self,
        request: ice20201109_models.CreateLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageChannelGroupResponse:
        """
        @summary Creates a live package channel group with a custom name and description.
        
        @description After you create a channel group, the assigned origin domain is returned.
        
        @param request: CreateLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        body = {}
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageChannelGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_package_channel_group_with_options_async(
        self,
        request: ice20201109_models.CreateLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageChannelGroupResponse:
        """
        @summary Creates a live package channel group with a custom name and description.
        
        @description After you create a channel group, the assigned origin domain is returned.
        
        @param request: CreateLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        body = {}
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageChannelGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_package_channel_group(
        self,
        request: ice20201109_models.CreateLivePackageChannelGroupRequest,
    ) -> ice20201109_models.CreateLivePackageChannelGroupResponse:
        """
        @summary Creates a live package channel group with a custom name and description.
        
        @description After you create a channel group, the assigned origin domain is returned.
        
        @param request: CreateLivePackageChannelGroupRequest
        @return: CreateLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_package_channel_group_with_options(request, runtime)

    async def create_live_package_channel_group_async(
        self,
        request: ice20201109_models.CreateLivePackageChannelGroupRequest,
    ) -> ice20201109_models.CreateLivePackageChannelGroupResponse:
        """
        @summary Creates a live package channel group with a custom name and description.
        
        @description After you create a channel group, the assigned origin domain is returned.
        
        @param request: CreateLivePackageChannelGroupRequest
        @return: CreateLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_package_channel_group_with_options_async(request, runtime)

    def create_live_package_origin_endpoint_with_options(
        self,
        tmp_req: ice20201109_models.CreateLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageOriginEndpointResponse:
        """
        @summary Creates an origin endpoint for a live package channel to deliver live streams in HLS format.
        
        @description ## [](#)Usage notes
        This API operation is mainly used to configure origin settings, security policies including the IP address blacklist and whitelist and authorization code, and time shifting settings for channels. Before you create an origin endpoint, you must create a live package channel group and channel. After you create the endpoint, the endpoint URL and other configuration details are returned.
        
        @param tmp_req: CreateLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLivePackageOriginEndpointShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.live_packaging_config):
            request.live_packaging_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.live_packaging_config, 'LivePackagingConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        body = {}
        if not UtilClient.is_unset(request.authorization_code):
            body['AuthorizationCode'] = request.authorization_code
        if not UtilClient.is_unset(request.channel_name):
            body['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.endpoint_name):
            body['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.ip_blacklist):
            body['IpBlacklist'] = request.ip_blacklist
        if not UtilClient.is_unset(request.ip_whitelist):
            body['IpWhitelist'] = request.ip_whitelist
        if not UtilClient.is_unset(request.live_packaging_config_shrink):
            body['LivePackagingConfig'] = request.live_packaging_config_shrink
        if not UtilClient.is_unset(request.manifest_name):
            body['ManifestName'] = request.manifest_name
        if not UtilClient.is_unset(request.protocol):
            body['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.timeshift_vision):
            body['TimeshiftVision'] = request.timeshift_vision
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageOriginEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_package_origin_endpoint_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLivePackageOriginEndpointResponse:
        """
        @summary Creates an origin endpoint for a live package channel to deliver live streams in HLS format.
        
        @description ## [](#)Usage notes
        This API operation is mainly used to configure origin settings, security policies including the IP address blacklist and whitelist and authorization code, and time shifting settings for channels. Before you create an origin endpoint, you must create a live package channel group and channel. After you create the endpoint, the endpoint URL and other configuration details are returned.
        
        @param tmp_req: CreateLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLivePackageOriginEndpointShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.live_packaging_config):
            request.live_packaging_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.live_packaging_config, 'LivePackagingConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        body = {}
        if not UtilClient.is_unset(request.authorization_code):
            body['AuthorizationCode'] = request.authorization_code
        if not UtilClient.is_unset(request.channel_name):
            body['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.description):
            body['Description'] = request.description
        if not UtilClient.is_unset(request.endpoint_name):
            body['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            body['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.ip_blacklist):
            body['IpBlacklist'] = request.ip_blacklist
        if not UtilClient.is_unset(request.ip_whitelist):
            body['IpWhitelist'] = request.ip_whitelist
        if not UtilClient.is_unset(request.live_packaging_config_shrink):
            body['LivePackagingConfig'] = request.live_packaging_config_shrink
        if not UtilClient.is_unset(request.manifest_name):
            body['ManifestName'] = request.manifest_name
        if not UtilClient.is_unset(request.protocol):
            body['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.timeshift_vision):
            body['TimeshiftVision'] = request.timeshift_vision
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLivePackageOriginEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_package_origin_endpoint(
        self,
        request: ice20201109_models.CreateLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.CreateLivePackageOriginEndpointResponse:
        """
        @summary Creates an origin endpoint for a live package channel to deliver live streams in HLS format.
        
        @description ## [](#)Usage notes
        This API operation is mainly used to configure origin settings, security policies including the IP address blacklist and whitelist and authorization code, and time shifting settings for channels. Before you create an origin endpoint, you must create a live package channel group and channel. After you create the endpoint, the endpoint URL and other configuration details are returned.
        
        @param request: CreateLivePackageOriginEndpointRequest
        @return: CreateLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_package_origin_endpoint_with_options(request, runtime)

    async def create_live_package_origin_endpoint_async(
        self,
        request: ice20201109_models.CreateLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.CreateLivePackageOriginEndpointResponse:
        """
        @summary Creates an origin endpoint for a live package channel to deliver live streams in HLS format.
        
        @description ## [](#)Usage notes
        This API operation is mainly used to configure origin settings, security policies including the IP address blacklist and whitelist and authorization code, and time shifting settings for channels. Before you create an origin endpoint, you must create a live package channel group and channel. After you create the endpoint, the endpoint URL and other configuration details are returned.
        
        @param request: CreateLivePackageOriginEndpointRequest
        @return: CreateLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_package_origin_endpoint_with_options_async(request, runtime)

    def create_live_record_template_with_options(
        self,
        tmp_req: ice20201109_models.CreateLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveRecordTemplateResponse:
        """
        @summary Creates a live stream recording template to submit live stream recording jobs.
        
        @description You must specify a recording template for live stream recording. You can configure information such as the format and duration of a recording in a recording template. The recording format can be M3U8, MP4, or FLV.
        
        @param tmp_req: CreateLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveRecordTemplateResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLiveRecordTemplateShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.record_format):
            request.record_format_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.record_format, 'RecordFormat', 'json')
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.record_format_shrink):
            body['RecordFormat'] = request.record_format_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveRecordTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_record_template_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveRecordTemplateResponse:
        """
        @summary Creates a live stream recording template to submit live stream recording jobs.
        
        @description You must specify a recording template for live stream recording. You can configure information such as the format and duration of a recording in a recording template. The recording format can be M3U8, MP4, or FLV.
        
        @param tmp_req: CreateLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveRecordTemplateResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLiveRecordTemplateShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.record_format):
            request.record_format_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.record_format, 'RecordFormat', 'json')
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.record_format_shrink):
            body['RecordFormat'] = request.record_format_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveRecordTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_record_template(
        self,
        request: ice20201109_models.CreateLiveRecordTemplateRequest,
    ) -> ice20201109_models.CreateLiveRecordTemplateResponse:
        """
        @summary Creates a live stream recording template to submit live stream recording jobs.
        
        @description You must specify a recording template for live stream recording. You can configure information such as the format and duration of a recording in a recording template. The recording format can be M3U8, MP4, or FLV.
        
        @param request: CreateLiveRecordTemplateRequest
        @return: CreateLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_record_template_with_options(request, runtime)

    async def create_live_record_template_async(
        self,
        request: ice20201109_models.CreateLiveRecordTemplateRequest,
    ) -> ice20201109_models.CreateLiveRecordTemplateResponse:
        """
        @summary Creates a live stream recording template to submit live stream recording jobs.
        
        @description You must specify a recording template for live stream recording. You can configure information such as the format and duration of a recording in a recording template. The recording format can be M3U8, MP4, or FLV.
        
        @param request: CreateLiveRecordTemplateRequest
        @return: CreateLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_record_template_with_options_async(request, runtime)

    def create_live_snapshot_template_with_options(
        self,
        request: ice20201109_models.CreateLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveSnapshotTemplateResponse:
        """
        @summary Create a live stream snapshot template to facilitate the creation of snapshot jobs.
        
        @param request: CreateLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.overwrite_format):
            body['OverwriteFormat'] = request.overwrite_format
        if not UtilClient.is_unset(request.sequence_format):
            body['SequenceFormat'] = request.sequence_format
        if not UtilClient.is_unset(request.template_name):
            body['TemplateName'] = request.template_name
        if not UtilClient.is_unset(request.time_interval):
            body['TimeInterval'] = request.time_interval
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveSnapshotTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_snapshot_template_with_options_async(
        self,
        request: ice20201109_models.CreateLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveSnapshotTemplateResponse:
        """
        @summary Create a live stream snapshot template to facilitate the creation of snapshot jobs.
        
        @param request: CreateLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.overwrite_format):
            body['OverwriteFormat'] = request.overwrite_format
        if not UtilClient.is_unset(request.sequence_format):
            body['SequenceFormat'] = request.sequence_format
        if not UtilClient.is_unset(request.template_name):
            body['TemplateName'] = request.template_name
        if not UtilClient.is_unset(request.time_interval):
            body['TimeInterval'] = request.time_interval
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveSnapshotTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_snapshot_template(
        self,
        request: ice20201109_models.CreateLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.CreateLiveSnapshotTemplateResponse:
        """
        @summary Create a live stream snapshot template to facilitate the creation of snapshot jobs.
        
        @param request: CreateLiveSnapshotTemplateRequest
        @return: CreateLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_snapshot_template_with_options(request, runtime)

    async def create_live_snapshot_template_async(
        self,
        request: ice20201109_models.CreateLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.CreateLiveSnapshotTemplateResponse:
        """
        @summary Create a live stream snapshot template to facilitate the creation of snapshot jobs.
        
        @param request: CreateLiveSnapshotTemplateRequest
        @return: CreateLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_snapshot_template_with_options_async(request, runtime)

    def create_live_transcode_template_with_options(
        self,
        tmp_req: ice20201109_models.CreateLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveTranscodeTemplateResponse:
        """
        @summary Creates a live stream transcoding template to submit live stream transcoding jobs.
        
        @param tmp_req: CreateLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLiveTranscodeTemplateShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.template_config):
            request.template_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.template_config, 'TemplateConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.template_config_shrink):
            query['TemplateConfig'] = request.template_config_shrink
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveTranscodeTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_live_transcode_template_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateLiveTranscodeTemplateResponse:
        """
        @summary Creates a live stream transcoding template to submit live stream transcoding jobs.
        
        @param tmp_req: CreateLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateLiveTranscodeTemplateShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.template_config):
            request.template_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.template_config, 'TemplateConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.template_config_shrink):
            query['TemplateConfig'] = request.template_config_shrink
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateLiveTranscodeTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_live_transcode_template(
        self,
        request: ice20201109_models.CreateLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.CreateLiveTranscodeTemplateResponse:
        """
        @summary Creates a live stream transcoding template to submit live stream transcoding jobs.
        
        @param request: CreateLiveTranscodeTemplateRequest
        @return: CreateLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_live_transcode_template_with_options(request, runtime)

    async def create_live_transcode_template_async(
        self,
        request: ice20201109_models.CreateLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.CreateLiveTranscodeTemplateResponse:
        """
        @summary Creates a live stream transcoding template to submit live stream transcoding jobs.
        
        @param request: CreateLiveTranscodeTemplateRequest
        @return: CreateLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_live_transcode_template_with_options_async(request, runtime)

    def create_media_connect_flow_with_options(
        self,
        request: ice20201109_models.CreateMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaConnectFlowResponse:
        """
        @summary Creates a MediaConnect flow.
        
        @description    The flow names cannot be duplicated in the same region.
        Take note of the returned flow ID. You may reference it in other API operations.
        
        @param request: CreateMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_name):
            query['FlowName'] = request.flow_name
        if not UtilClient.is_unset(request.flow_region):
            query['FlowRegion'] = request.flow_region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaConnectFlowResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_media_connect_flow_with_options_async(
        self,
        request: ice20201109_models.CreateMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaConnectFlowResponse:
        """
        @summary Creates a MediaConnect flow.
        
        @description    The flow names cannot be duplicated in the same region.
        Take note of the returned flow ID. You may reference it in other API operations.
        
        @param request: CreateMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_name):
            query['FlowName'] = request.flow_name
        if not UtilClient.is_unset(request.flow_region):
            query['FlowRegion'] = request.flow_region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaConnectFlowResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_media_connect_flow(
        self,
        request: ice20201109_models.CreateMediaConnectFlowRequest,
    ) -> ice20201109_models.CreateMediaConnectFlowResponse:
        """
        @summary Creates a MediaConnect flow.
        
        @description    The flow names cannot be duplicated in the same region.
        Take note of the returned flow ID. You may reference it in other API operations.
        
        @param request: CreateMediaConnectFlowRequest
        @return: CreateMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_media_connect_flow_with_options(request, runtime)

    async def create_media_connect_flow_async(
        self,
        request: ice20201109_models.CreateMediaConnectFlowRequest,
    ) -> ice20201109_models.CreateMediaConnectFlowResponse:
        """
        @summary Creates a MediaConnect flow.
        
        @description    The flow names cannot be duplicated in the same region.
        Take note of the returned flow ID. You may reference it in other API operations.
        
        @param request: CreateMediaConnectFlowRequest
        @return: CreateMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_media_connect_flow_with_options_async(request, runtime)

    def create_media_live_channel_with_options(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveChannelResponse:
        """
        @summary Creates a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveChannelResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveChannelShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.audio_settings):
            request.audio_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.audio_settings, 'AudioSettings', 'json')
        if not UtilClient.is_unset(tmp_req.input_attachments):
            request.input_attachments_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input_attachments, 'InputAttachments', 'json')
        if not UtilClient.is_unset(tmp_req.output_groups):
            request.output_groups_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.output_groups, 'OutputGroups', 'json')
        if not UtilClient.is_unset(tmp_req.video_settings):
            request.video_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.video_settings, 'VideoSettings', 'json')
        body = {}
        if not UtilClient.is_unset(request.audio_settings_shrink):
            body['AudioSettings'] = request.audio_settings_shrink
        if not UtilClient.is_unset(request.input_attachments_shrink):
            body['InputAttachments'] = request.input_attachments_shrink
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.output_groups_shrink):
            body['OutputGroups'] = request.output_groups_shrink
        if not UtilClient.is_unset(request.video_settings_shrink):
            body['VideoSettings'] = request.video_settings_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_media_live_channel_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveChannelResponse:
        """
        @summary Creates a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveChannelResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveChannelShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.audio_settings):
            request.audio_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.audio_settings, 'AudioSettings', 'json')
        if not UtilClient.is_unset(tmp_req.input_attachments):
            request.input_attachments_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input_attachments, 'InputAttachments', 'json')
        if not UtilClient.is_unset(tmp_req.output_groups):
            request.output_groups_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.output_groups, 'OutputGroups', 'json')
        if not UtilClient.is_unset(tmp_req.video_settings):
            request.video_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.video_settings, 'VideoSettings', 'json')
        body = {}
        if not UtilClient.is_unset(request.audio_settings_shrink):
            body['AudioSettings'] = request.audio_settings_shrink
        if not UtilClient.is_unset(request.input_attachments_shrink):
            body['InputAttachments'] = request.input_attachments_shrink
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.output_groups_shrink):
            body['OutputGroups'] = request.output_groups_shrink
        if not UtilClient.is_unset(request.video_settings_shrink):
            body['VideoSettings'] = request.video_settings_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_media_live_channel(
        self,
        request: ice20201109_models.CreateMediaLiveChannelRequest,
    ) -> ice20201109_models.CreateMediaLiveChannelResponse:
        """
        @summary Creates a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveChannelRequest
        @return: CreateMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_media_live_channel_with_options(request, runtime)

    async def create_media_live_channel_async(
        self,
        request: ice20201109_models.CreateMediaLiveChannelRequest,
    ) -> ice20201109_models.CreateMediaLiveChannelResponse:
        """
        @summary Creates a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveChannelRequest
        @return: CreateMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_media_live_channel_with_options_async(request, runtime)

    def create_media_live_input_with_options(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveInputResponse:
        """
        @summary Creates a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveInputResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveInputShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.input_settings):
            request.input_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input_settings, 'InputSettings', 'json')
        if not UtilClient.is_unset(tmp_req.security_group_ids):
            request.security_group_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.security_group_ids, 'SecurityGroupIds', 'json')
        body = {}
        if not UtilClient.is_unset(request.input_settings_shrink):
            body['InputSettings'] = request.input_settings_shrink
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.security_group_ids_shrink):
            body['SecurityGroupIds'] = request.security_group_ids_shrink
        if not UtilClient.is_unset(request.type):
            body['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_media_live_input_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveInputResponse:
        """
        @summary Creates a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveInputResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveInputShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.input_settings):
            request.input_settings_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input_settings, 'InputSettings', 'json')
        if not UtilClient.is_unset(tmp_req.security_group_ids):
            request.security_group_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.security_group_ids, 'SecurityGroupIds', 'json')
        body = {}
        if not UtilClient.is_unset(request.input_settings_shrink):
            body['InputSettings'] = request.input_settings_shrink
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.security_group_ids_shrink):
            body['SecurityGroupIds'] = request.security_group_ids_shrink
        if not UtilClient.is_unset(request.type):
            body['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_media_live_input(
        self,
        request: ice20201109_models.CreateMediaLiveInputRequest,
    ) -> ice20201109_models.CreateMediaLiveInputResponse:
        """
        @summary Creates a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveInputRequest
        @return: CreateMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_media_live_input_with_options(request, runtime)

    async def create_media_live_input_async(
        self,
        request: ice20201109_models.CreateMediaLiveInputRequest,
    ) -> ice20201109_models.CreateMediaLiveInputResponse:
        """
        @summary Creates a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveInputRequest
        @return: CreateMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_media_live_input_with_options_async(request, runtime)

    def create_media_live_input_security_group_with_options(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveInputSecurityGroupResponse:
        """
        @summary Creates a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveInputSecurityGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.whitelist_rules):
            request.whitelist_rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.whitelist_rules, 'WhitelistRules', 'json')
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.whitelist_rules_shrink):
            body['WhitelistRules'] = request.whitelist_rules_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveInputSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_media_live_input_security_group_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateMediaLiveInputSecurityGroupResponse:
        """
        @summary Creates a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param tmp_req: CreateMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateMediaLiveInputSecurityGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.whitelist_rules):
            request.whitelist_rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.whitelist_rules, 'WhitelistRules', 'json')
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        if not UtilClient.is_unset(request.whitelist_rules_shrink):
            body['WhitelistRules'] = request.whitelist_rules_shrink
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateMediaLiveInputSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_media_live_input_security_group(
        self,
        request: ice20201109_models.CreateMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.CreateMediaLiveInputSecurityGroupResponse:
        """
        @summary Creates a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveInputSecurityGroupRequest
        @return: CreateMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_media_live_input_security_group_with_options(request, runtime)

    async def create_media_live_input_security_group_async(
        self,
        request: ice20201109_models.CreateMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.CreateMediaLiveInputSecurityGroupResponse:
        """
        @summary Creates a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: CreateMediaLiveInputSecurityGroupRequest
        @return: CreateMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_media_live_input_security_group_with_options_async(request, runtime)

    def create_pipeline_with_options(
        self,
        request: ice20201109_models.CreatePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreatePipelineResponse:
        """
        @summary Creates an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: CreatePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.speed):
            query['Speed'] = request.speed
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreatePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_pipeline_with_options_async(
        self,
        request: ice20201109_models.CreatePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreatePipelineResponse:
        """
        @summary Creates an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: CreatePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.speed):
            query['Speed'] = request.speed
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreatePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_pipeline(
        self,
        request: ice20201109_models.CreatePipelineRequest,
    ) -> ice20201109_models.CreatePipelineResponse:
        """
        @summary Creates an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: CreatePipelineRequest
        @return: CreatePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_pipeline_with_options(request, runtime)

    async def create_pipeline_async(
        self,
        request: ice20201109_models.CreatePipelineRequest,
    ) -> ice20201109_models.CreatePipelineResponse:
        """
        @summary Creates an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: CreatePipelineRequest
        @return: CreatePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_pipeline_with_options_async(request, runtime)

    def create_program_with_options(
        self,
        request: ice20201109_models.CreateProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateProgramResponse:
        """
        @summary Creates a program in a MediaWeaver channel.
        
        @param request: CreateProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_breaks):
            query['AdBreaks'] = request.ad_breaks
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.clip_range):
            query['ClipRange'] = request.clip_range
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.transition):
            query['Transition'] = request.transition
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_program_with_options_async(
        self,
        request: ice20201109_models.CreateProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateProgramResponse:
        """
        @summary Creates a program in a MediaWeaver channel.
        
        @param request: CreateProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ad_breaks):
            query['AdBreaks'] = request.ad_breaks
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.clip_range):
            query['ClipRange'] = request.clip_range
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.transition):
            query['Transition'] = request.transition
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_program(
        self,
        request: ice20201109_models.CreateProgramRequest,
    ) -> ice20201109_models.CreateProgramResponse:
        """
        @summary Creates a program in a MediaWeaver channel.
        
        @param request: CreateProgramRequest
        @return: CreateProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_program_with_options(request, runtime)

    async def create_program_async(
        self,
        request: ice20201109_models.CreateProgramRequest,
    ) -> ice20201109_models.CreateProgramResponse:
        """
        @summary Creates a program in a MediaWeaver channel.
        
        @param request: CreateProgramRequest
        @return: CreateProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_program_with_options_async(request, runtime)

    def create_recognition_entity_with_options(
        self,
        request: ice20201109_models.CreateRecognitionEntityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionEntityResponse:
        """
        @summary 创建自定义实体
        
        @param request: CreateRecognitionEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionEntityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_info):
            query['EntityInfo'] = request.entity_info
        if not UtilClient.is_unset(request.entity_name):
            query['EntityName'] = request.entity_name
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionEntity',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionEntityResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_recognition_entity_with_options_async(
        self,
        request: ice20201109_models.CreateRecognitionEntityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionEntityResponse:
        """
        @summary 创建自定义实体
        
        @param request: CreateRecognitionEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionEntityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_info):
            query['EntityInfo'] = request.entity_info
        if not UtilClient.is_unset(request.entity_name):
            query['EntityName'] = request.entity_name
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionEntity',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionEntityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_recognition_entity(
        self,
        request: ice20201109_models.CreateRecognitionEntityRequest,
    ) -> ice20201109_models.CreateRecognitionEntityResponse:
        """
        @summary 创建自定义实体
        
        @param request: CreateRecognitionEntityRequest
        @return: CreateRecognitionEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_recognition_entity_with_options(request, runtime)

    async def create_recognition_entity_async(
        self,
        request: ice20201109_models.CreateRecognitionEntityRequest,
    ) -> ice20201109_models.CreateRecognitionEntityResponse:
        """
        @summary 创建自定义实体
        
        @param request: CreateRecognitionEntityRequest
        @return: CreateRecognitionEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_recognition_entity_with_options_async(request, runtime)

    def create_recognition_lib_with_options(
        self,
        request: ice20201109_models.CreateRecognitionLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionLibResponse:
        """
        @summary 创建自定义库。
        
        @param request: CreateRecognitionLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_description):
            query['LibDescription'] = request.lib_description
        if not UtilClient.is_unset(request.lib_name):
            query['LibName'] = request.lib_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_recognition_lib_with_options_async(
        self,
        request: ice20201109_models.CreateRecognitionLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionLibResponse:
        """
        @summary 创建自定义库。
        
        @param request: CreateRecognitionLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_description):
            query['LibDescription'] = request.lib_description
        if not UtilClient.is_unset(request.lib_name):
            query['LibName'] = request.lib_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_recognition_lib(
        self,
        request: ice20201109_models.CreateRecognitionLibRequest,
    ) -> ice20201109_models.CreateRecognitionLibResponse:
        """
        @summary 创建自定义库。
        
        @param request: CreateRecognitionLibRequest
        @return: CreateRecognitionLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_recognition_lib_with_options(request, runtime)

    async def create_recognition_lib_async(
        self,
        request: ice20201109_models.CreateRecognitionLibRequest,
    ) -> ice20201109_models.CreateRecognitionLibResponse:
        """
        @summary 创建自定义库。
        
        @param request: CreateRecognitionLibRequest
        @return: CreateRecognitionLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_recognition_lib_with_options_async(request, runtime)

    def create_recognition_sample_with_options(
        self,
        request: ice20201109_models.CreateRecognitionSampleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionSampleResponse:
        """
        @summary 注册自定义实体照片
        
        @param request: CreateRecognitionSampleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionSampleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.label_prompt):
            query['LabelPrompt'] = request.label_prompt
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionSample',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionSampleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_recognition_sample_with_options_async(
        self,
        request: ice20201109_models.CreateRecognitionSampleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateRecognitionSampleResponse:
        """
        @summary 注册自定义实体照片
        
        @param request: CreateRecognitionSampleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRecognitionSampleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.label_prompt):
            query['LabelPrompt'] = request.label_prompt
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRecognitionSample',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateRecognitionSampleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_recognition_sample(
        self,
        request: ice20201109_models.CreateRecognitionSampleRequest,
    ) -> ice20201109_models.CreateRecognitionSampleResponse:
        """
        @summary 注册自定义实体照片
        
        @param request: CreateRecognitionSampleRequest
        @return: CreateRecognitionSampleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_recognition_sample_with_options(request, runtime)

    async def create_recognition_sample_async(
        self,
        request: ice20201109_models.CreateRecognitionSampleRequest,
    ) -> ice20201109_models.CreateRecognitionSampleResponse:
        """
        @summary 注册自定义实体照片
        
        @param request: CreateRecognitionSampleRequest
        @return: CreateRecognitionSampleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_recognition_sample_with_options_async(request, runtime)

    def create_search_index_with_options(
        self,
        request: ice20201109_models.CreateSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSearchIndexResponse:
        """
        @summary 创建搜索索引
        
        @description The large visual model feature is still in the public preview phase. You can use this feature for free for 1,000 hours of videos.
        
        @param request: CreateSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_status):
            query['IndexStatus'] = request.index_status
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSearchIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_search_index_with_options_async(
        self,
        request: ice20201109_models.CreateSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSearchIndexResponse:
        """
        @summary 创建搜索索引
        
        @description The large visual model feature is still in the public preview phase. You can use this feature for free for 1,000 hours of videos.
        
        @param request: CreateSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_config):
            query['IndexConfig'] = request.index_config
        if not UtilClient.is_unset(request.index_status):
            query['IndexStatus'] = request.index_status
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSearchIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_search_index(
        self,
        request: ice20201109_models.CreateSearchIndexRequest,
    ) -> ice20201109_models.CreateSearchIndexResponse:
        """
        @summary 创建搜索索引
        
        @description The large visual model feature is still in the public preview phase. You can use this feature for free for 1,000 hours of videos.
        
        @param request: CreateSearchIndexRequest
        @return: CreateSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_search_index_with_options(request, runtime)

    async def create_search_index_async(
        self,
        request: ice20201109_models.CreateSearchIndexRequest,
    ) -> ice20201109_models.CreateSearchIndexResponse:
        """
        @summary 创建搜索索引
        
        @description The large visual model feature is still in the public preview phase. You can use this feature for free for 1,000 hours of videos.
        
        @param request: CreateSearchIndexRequest
        @return: CreateSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_search_index_with_options_async(request, runtime)

    def create_search_lib_with_options(
        self,
        request: ice20201109_models.CreateSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSearchLibResponse:
        """
        @summary Creates a search library to store media assets.
        
        @param request: CreateSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSearchLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_search_lib_with_options_async(
        self,
        request: ice20201109_models.CreateSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSearchLibResponse:
        """
        @summary Creates a search library to store media assets.
        
        @param request: CreateSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSearchLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_search_lib(
        self,
        request: ice20201109_models.CreateSearchLibRequest,
    ) -> ice20201109_models.CreateSearchLibResponse:
        """
        @summary Creates a search library to store media assets.
        
        @param request: CreateSearchLibRequest
        @return: CreateSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_search_lib_with_options(request, runtime)

    async def create_search_lib_async(
        self,
        request: ice20201109_models.CreateSearchLibRequest,
    ) -> ice20201109_models.CreateSearchLibResponse:
        """
        @summary Creates a search library to store media assets.
        
        @param request: CreateSearchLibRequest
        @return: CreateSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_search_lib_with_options_async(request, runtime)

    def create_source_with_options(
        self,
        request: ice20201109_models.CreateSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSourceResponse:
        """
        @summary Creates a source in MediaWeaver.
        
        @param request: CreateSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.http_package_configurations):
            query['HttpPackageConfigurations'] = request.http_package_configurations
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_source_with_options_async(
        self,
        request: ice20201109_models.CreateSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSourceResponse:
        """
        @summary Creates a source in MediaWeaver.
        
        @param request: CreateSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.http_package_configurations):
            query['HttpPackageConfigurations'] = request.http_package_configurations
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_source(
        self,
        request: ice20201109_models.CreateSourceRequest,
    ) -> ice20201109_models.CreateSourceResponse:
        """
        @summary Creates a source in MediaWeaver.
        
        @param request: CreateSourceRequest
        @return: CreateSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_source_with_options(request, runtime)

    async def create_source_async(
        self,
        request: ice20201109_models.CreateSourceRequest,
    ) -> ice20201109_models.CreateSourceResponse:
        """
        @summary Creates a source in MediaWeaver.
        
        @param request: CreateSourceRequest
        @return: CreateSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_source_with_options_async(request, runtime)

    def create_source_location_with_options(
        self,
        request: ice20201109_models.CreateSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSourceLocationResponse:
        """
        @summary Creates a source location.
        
        @param request: CreateSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_url):
            query['BaseUrl'] = request.base_url
        if not UtilClient.is_unset(request.enable_segment_delivery):
            query['EnableSegmentDelivery'] = request.enable_segment_delivery
        if not UtilClient.is_unset(request.segment_delivery_url):
            query['SegmentDeliveryUrl'] = request.segment_delivery_url
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSourceLocationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_source_location_with_options_async(
        self,
        request: ice20201109_models.CreateSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateSourceLocationResponse:
        """
        @summary Creates a source location.
        
        @param request: CreateSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_url):
            query['BaseUrl'] = request.base_url
        if not UtilClient.is_unset(request.enable_segment_delivery):
            query['EnableSegmentDelivery'] = request.enable_segment_delivery
        if not UtilClient.is_unset(request.segment_delivery_url):
            query['SegmentDeliveryUrl'] = request.segment_delivery_url
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateSourceLocationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_source_location(
        self,
        request: ice20201109_models.CreateSourceLocationRequest,
    ) -> ice20201109_models.CreateSourceLocationResponse:
        """
        @summary Creates a source location.
        
        @param request: CreateSourceLocationRequest
        @return: CreateSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_source_location_with_options(request, runtime)

    async def create_source_location_async(
        self,
        request: ice20201109_models.CreateSourceLocationRequest,
    ) -> ice20201109_models.CreateSourceLocationResponse:
        """
        @summary Creates a source location.
        
        @param request: CreateSourceLocationRequest
        @return: CreateSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_source_location_with_options_async(request, runtime)

    def create_upload_media_with_options(
        self,
        request: ice20201109_models.CreateUploadMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateUploadMediaResponse:
        """
        @summary Obtains the upload URL and credential of a media asset and creates information about the media asset.
        
        @description    You can call this operation to obtain the upload URLs and credentials of audio and video files. You can also call this operation to obtain the upload URLs and credentials of images and auxiliary media assets.
        Obtaining an upload URL and credential is essential for Intelligent Media Services (IMS) and is required in each upload operation.
        If the video upload credential expires, you can call the RefreshUploadMedia operation to obtain a new upload credential. The default validity period of a video upload credential is 3,000 seconds.
        After you upload a media asset, you can configure a callback to receive upload event notifications or call the GetMediaInfo operation to determine whether the media asset is uploaded based on the returned status.
        The MediaId parameter returned by this operation can be used for media asset lifecycle management or media processing.
        You can call this operation to upload media assets only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media asset to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaInfo](https://help.aliyun.com/document_detail/441152.html) operation to register the file in the OSS bucket with the media asset library.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUploadMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.file_info):
            query['FileInfo'] = request.file_info
        if not UtilClient.is_unset(request.media_meta_data):
            query['MediaMetaData'] = request.media_meta_data
        if not UtilClient.is_unset(request.post_process_config):
            query['PostProcessConfig'] = request.post_process_config
        if not UtilClient.is_unset(request.upload_target_config):
            query['UploadTargetConfig'] = request.upload_target_config
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUploadMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateUploadMediaResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_upload_media_with_options_async(
        self,
        request: ice20201109_models.CreateUploadMediaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateUploadMediaResponse:
        """
        @summary Obtains the upload URL and credential of a media asset and creates information about the media asset.
        
        @description    You can call this operation to obtain the upload URLs and credentials of audio and video files. You can also call this operation to obtain the upload URLs and credentials of images and auxiliary media assets.
        Obtaining an upload URL and credential is essential for Intelligent Media Services (IMS) and is required in each upload operation.
        If the video upload credential expires, you can call the RefreshUploadMedia operation to obtain a new upload credential. The default validity period of a video upload credential is 3,000 seconds.
        After you upload a media asset, you can configure a callback to receive upload event notifications or call the GetMediaInfo operation to determine whether the media asset is uploaded based on the returned status.
        The MediaId parameter returned by this operation can be used for media asset lifecycle management or media processing.
        You can call this operation to upload media assets only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media asset to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaInfo](https://help.aliyun.com/document_detail/441152.html) operation to register the file in the OSS bucket with the media asset library.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadMediaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUploadMediaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.file_info):
            query['FileInfo'] = request.file_info
        if not UtilClient.is_unset(request.media_meta_data):
            query['MediaMetaData'] = request.media_meta_data
        if not UtilClient.is_unset(request.post_process_config):
            query['PostProcessConfig'] = request.post_process_config
        if not UtilClient.is_unset(request.upload_target_config):
            query['UploadTargetConfig'] = request.upload_target_config
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUploadMedia',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateUploadMediaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_upload_media(
        self,
        request: ice20201109_models.CreateUploadMediaRequest,
    ) -> ice20201109_models.CreateUploadMediaResponse:
        """
        @summary Obtains the upload URL and credential of a media asset and creates information about the media asset.
        
        @description    You can call this operation to obtain the upload URLs and credentials of audio and video files. You can also call this operation to obtain the upload URLs and credentials of images and auxiliary media assets.
        Obtaining an upload URL and credential is essential for Intelligent Media Services (IMS) and is required in each upload operation.
        If the video upload credential expires, you can call the RefreshUploadMedia operation to obtain a new upload credential. The default validity period of a video upload credential is 3,000 seconds.
        After you upload a media asset, you can configure a callback to receive upload event notifications or call the GetMediaInfo operation to determine whether the media asset is uploaded based on the returned status.
        The MediaId parameter returned by this operation can be used for media asset lifecycle management or media processing.
        You can call this operation to upload media assets only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media asset to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaInfo](https://help.aliyun.com/document_detail/441152.html) operation to register the file in the OSS bucket with the media asset library.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadMediaRequest
        @return: CreateUploadMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_upload_media_with_options(request, runtime)

    async def create_upload_media_async(
        self,
        request: ice20201109_models.CreateUploadMediaRequest,
    ) -> ice20201109_models.CreateUploadMediaResponse:
        """
        @summary Obtains the upload URL and credential of a media asset and creates information about the media asset.
        
        @description    You can call this operation to obtain the upload URLs and credentials of audio and video files. You can also call this operation to obtain the upload URLs and credentials of images and auxiliary media assets.
        Obtaining an upload URL and credential is essential for Intelligent Media Services (IMS) and is required in each upload operation.
        If the video upload credential expires, you can call the RefreshUploadMedia operation to obtain a new upload credential. The default validity period of a video upload credential is 3,000 seconds.
        After you upload a media asset, you can configure a callback to receive upload event notifications or call the GetMediaInfo operation to determine whether the media asset is uploaded based on the returned status.
        The MediaId parameter returned by this operation can be used for media asset lifecycle management or media processing.
        You can call this operation to upload media assets only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media asset to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaInfo](https://help.aliyun.com/document_detail/441152.html) operation to register the file in the OSS bucket with the media asset library.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadMediaRequest
        @return: CreateUploadMediaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_upload_media_with_options_async(request, runtime)

    def create_upload_stream_with_options(
        self,
        request: ice20201109_models.CreateUploadStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateUploadStreamResponse:
        """
        @summary Obtains the upload URL and credential of a media stream.
        
        @description    You can call this operation to upload only a local media stream. After the media stream is uploaded, it is associated with the specified media asset ID.
        You can call this operation to upload media streams only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media stream to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaStream](https://help.aliyun.com/document_detail/440765.html) operation to associate the media stream with the specified media asset ID.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUploadStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.definition):
            query['Definition'] = request.definition
        if not UtilClient.is_unset(request.file_extension):
            query['FileExtension'] = request.file_extension
        if not UtilClient.is_unset(request.hdrtype):
            query['HDRType'] = request.hdrtype
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUploadStream',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateUploadStreamResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_upload_stream_with_options_async(
        self,
        request: ice20201109_models.CreateUploadStreamRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateUploadStreamResponse:
        """
        @summary Obtains the upload URL and credential of a media stream.
        
        @description    You can call this operation to upload only a local media stream. After the media stream is uploaded, it is associated with the specified media asset ID.
        You can call this operation to upload media streams only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media stream to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaStream](https://help.aliyun.com/document_detail/440765.html) operation to associate the media stream with the specified media asset ID.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadStreamRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUploadStreamResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.definition):
            query['Definition'] = request.definition
        if not UtilClient.is_unset(request.file_extension):
            query['FileExtension'] = request.file_extension
        if not UtilClient.is_unset(request.hdrtype):
            query['HDRType'] = request.hdrtype
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUploadStream',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateUploadStreamResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_upload_stream(
        self,
        request: ice20201109_models.CreateUploadStreamRequest,
    ) -> ice20201109_models.CreateUploadStreamResponse:
        """
        @summary Obtains the upload URL and credential of a media stream.
        
        @description    You can call this operation to upload only a local media stream. After the media stream is uploaded, it is associated with the specified media asset ID.
        You can call this operation to upload media streams only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media stream to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaStream](https://help.aliyun.com/document_detail/440765.html) operation to associate the media stream with the specified media asset ID.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadStreamRequest
        @return: CreateUploadStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_upload_stream_with_options(request, runtime)

    async def create_upload_stream_async(
        self,
        request: ice20201109_models.CreateUploadStreamRequest,
    ) -> ice20201109_models.CreateUploadStreamResponse:
        """
        @summary Obtains the upload URL and credential of a media stream.
        
        @description    You can call this operation to upload only a local media stream. After the media stream is uploaded, it is associated with the specified media asset ID.
        You can call this operation to upload media streams only to ApsaraVideo VOD, but not to your own Object Storage Service (OSS) buckets. To upload a media stream to your own OSS bucket, you can upload the file to your OSS bucket by using [OSS SDK](https://help.aliyun.com/document_detail/32006.html), and then call the [RegisterMediaStream](https://help.aliyun.com/document_detail/440765.html) operation to associate the media stream with the specified media asset ID.
        This operation is available only in the China (Shanghai), China (Beijing), and China (Shenzhen) regions.
        
        @param request: CreateUploadStreamRequest
        @return: CreateUploadStreamResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_upload_stream_with_options_async(request, runtime)

    def create_vod_packaging_asset_with_options(
        self,
        tmp_req: ice20201109_models.CreateVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingAssetResponse:
        """
        @summary Ingests an asset for VOD packaging.
        
        @param tmp_req: CreateVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingAssetResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateVodPackagingAssetShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.input):
            request.input_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input, 'Input', 'json')
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        if not UtilClient.is_unset(request.content_id):
            query['ContentId'] = request.content_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.input_shrink):
            query['Input'] = request.input_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingAssetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vod_packaging_asset_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingAssetResponse:
        """
        @summary Ingests an asset for VOD packaging.
        
        @param tmp_req: CreateVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingAssetResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateVodPackagingAssetShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.input):
            request.input_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.input, 'Input', 'json')
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        if not UtilClient.is_unset(request.content_id):
            query['ContentId'] = request.content_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.input_shrink):
            query['Input'] = request.input_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingAssetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vod_packaging_asset(
        self,
        request: ice20201109_models.CreateVodPackagingAssetRequest,
    ) -> ice20201109_models.CreateVodPackagingAssetResponse:
        """
        @summary Ingests an asset for VOD packaging.
        
        @param request: CreateVodPackagingAssetRequest
        @return: CreateVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vod_packaging_asset_with_options(request, runtime)

    async def create_vod_packaging_asset_async(
        self,
        request: ice20201109_models.CreateVodPackagingAssetRequest,
    ) -> ice20201109_models.CreateVodPackagingAssetResponse:
        """
        @summary Ingests an asset for VOD packaging.
        
        @param request: CreateVodPackagingAssetRequest
        @return: CreateVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vod_packaging_asset_with_options_async(request, runtime)

    def create_vod_packaging_configuration_with_options(
        self,
        tmp_req: ice20201109_models.CreateVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingConfigurationResponse:
        """
        @summary Creates a packaging configuration.
        
        @param tmp_req: CreateVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateVodPackagingConfigurationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.package_config):
            request.package_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.package_config, 'PackageConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.package_config_shrink):
            query['PackageConfig'] = request.package_config_shrink
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vod_packaging_configuration_with_options_async(
        self,
        tmp_req: ice20201109_models.CreateVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingConfigurationResponse:
        """
        @summary Creates a packaging configuration.
        
        @param tmp_req: CreateVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.CreateVodPackagingConfigurationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.package_config):
            request.package_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.package_config, 'PackageConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.package_config_shrink):
            query['PackageConfig'] = request.package_config_shrink
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vod_packaging_configuration(
        self,
        request: ice20201109_models.CreateVodPackagingConfigurationRequest,
    ) -> ice20201109_models.CreateVodPackagingConfigurationResponse:
        """
        @summary Creates a packaging configuration.
        
        @param request: CreateVodPackagingConfigurationRequest
        @return: CreateVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vod_packaging_configuration_with_options(request, runtime)

    async def create_vod_packaging_configuration_async(
        self,
        request: ice20201109_models.CreateVodPackagingConfigurationRequest,
    ) -> ice20201109_models.CreateVodPackagingConfigurationResponse:
        """
        @summary Creates a packaging configuration.
        
        @param request: CreateVodPackagingConfigurationRequest
        @return: CreateVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vod_packaging_configuration_with_options_async(request, runtime)

    def create_vod_packaging_group_with_options(
        self,
        request: ice20201109_models.CreateVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingGroupResponse:
        """
        @summary Creates a packaging group.
        
        @param request: CreateVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vod_packaging_group_with_options_async(
        self,
        request: ice20201109_models.CreateVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.CreateVodPackagingGroupResponse:
        """
        @summary Creates a packaging group.
        
        @param request: CreateVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.CreateVodPackagingGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vod_packaging_group(
        self,
        request: ice20201109_models.CreateVodPackagingGroupRequest,
    ) -> ice20201109_models.CreateVodPackagingGroupResponse:
        """
        @summary Creates a packaging group.
        
        @param request: CreateVodPackagingGroupRequest
        @return: CreateVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vod_packaging_group_with_options(request, runtime)

    async def create_vod_packaging_group_async(
        self,
        request: ice20201109_models.CreateVodPackagingGroupRequest,
    ) -> ice20201109_models.CreateVodPackagingGroupResponse:
        """
        @summary Creates a packaging group.
        
        @param request: CreateVodPackagingGroupRequest
        @return: CreateVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vod_packaging_group_with_options_async(request, runtime)

    def decrypt_kmsdata_key_with_options(
        self,
        request: ice20201109_models.DecryptKMSDataKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DecryptKMSDataKeyResponse:
        """
        @summary Decrypts the ciphertext specified by CiphertextBlob in the Key Management Service (KMS) data key.
        
        @param request: DecryptKMSDataKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DecryptKMSDataKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ciphertext_blob):
            query['CiphertextBlob'] = request.ciphertext_blob
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DecryptKMSDataKey',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DecryptKMSDataKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def decrypt_kmsdata_key_with_options_async(
        self,
        request: ice20201109_models.DecryptKMSDataKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DecryptKMSDataKeyResponse:
        """
        @summary Decrypts the ciphertext specified by CiphertextBlob in the Key Management Service (KMS) data key.
        
        @param request: DecryptKMSDataKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DecryptKMSDataKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ciphertext_blob):
            query['CiphertextBlob'] = request.ciphertext_blob
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DecryptKMSDataKey',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DecryptKMSDataKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def decrypt_kmsdata_key(
        self,
        request: ice20201109_models.DecryptKMSDataKeyRequest,
    ) -> ice20201109_models.DecryptKMSDataKeyResponse:
        """
        @summary Decrypts the ciphertext specified by CiphertextBlob in the Key Management Service (KMS) data key.
        
        @param request: DecryptKMSDataKeyRequest
        @return: DecryptKMSDataKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.decrypt_kmsdata_key_with_options(request, runtime)

    async def decrypt_kmsdata_key_async(
        self,
        request: ice20201109_models.DecryptKMSDataKeyRequest,
    ) -> ice20201109_models.DecryptKMSDataKeyResponse:
        """
        @summary Decrypts the ciphertext specified by CiphertextBlob in the Key Management Service (KMS) data key.
        
        @param request: DecryptKMSDataKeyRequest
        @return: DecryptKMSDataKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.decrypt_kmsdata_key_with_options_async(request, runtime)

    def delete_aiagent_dialogue_with_options(
        self,
        request: ice20201109_models.DeleteAIAgentDialogueRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAIAgentDialogueResponse:
        """
        @summary 删除智能体的对话历史记录。
        
        @param request: DeleteAIAgentDialogueRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAIAgentDialogueResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dialogue_id):
            query['DialogueId'] = request.dialogue_id
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAIAgentDialogue',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAIAgentDialogueResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_aiagent_dialogue_with_options_async(
        self,
        request: ice20201109_models.DeleteAIAgentDialogueRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAIAgentDialogueResponse:
        """
        @summary 删除智能体的对话历史记录。
        
        @param request: DeleteAIAgentDialogueRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAIAgentDialogueResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dialogue_id):
            query['DialogueId'] = request.dialogue_id
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAIAgentDialogue',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAIAgentDialogueResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_aiagent_dialogue(
        self,
        request: ice20201109_models.DeleteAIAgentDialogueRequest,
    ) -> ice20201109_models.DeleteAIAgentDialogueResponse:
        """
        @summary 删除智能体的对话历史记录。
        
        @param request: DeleteAIAgentDialogueRequest
        @return: DeleteAIAgentDialogueResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_aiagent_dialogue_with_options(request, runtime)

    async def delete_aiagent_dialogue_async(
        self,
        request: ice20201109_models.DeleteAIAgentDialogueRequest,
    ) -> ice20201109_models.DeleteAIAgentDialogueResponse:
        """
        @summary 删除智能体的对话历史记录。
        
        @param request: DeleteAIAgentDialogueRequest
        @return: DeleteAIAgentDialogueResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_aiagent_dialogue_with_options_async(request, runtime)

    def delete_ad_insertion_with_options(
        self,
        request: ice20201109_models.DeleteAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAdInsertionResponse:
        """
        @summary Deletes an ad insertion configuration.
        
        @param request: DeleteAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAdInsertionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAdInsertionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ad_insertion_with_options_async(
        self,
        request: ice20201109_models.DeleteAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAdInsertionResponse:
        """
        @summary Deletes an ad insertion configuration.
        
        @param request: DeleteAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAdInsertionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.name):
            body['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAdInsertionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ad_insertion(
        self,
        request: ice20201109_models.DeleteAdInsertionRequest,
    ) -> ice20201109_models.DeleteAdInsertionResponse:
        """
        @summary Deletes an ad insertion configuration.
        
        @param request: DeleteAdInsertionRequest
        @return: DeleteAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ad_insertion_with_options(request, runtime)

    async def delete_ad_insertion_async(
        self,
        request: ice20201109_models.DeleteAdInsertionRequest,
    ) -> ice20201109_models.DeleteAdInsertionResponse:
        """
        @summary Deletes an ad insertion configuration.
        
        @param request: DeleteAdInsertionRequest
        @return: DeleteAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ad_insertion_with_options_async(request, runtime)

    def delete_avatar_training_job_with_options(
        self,
        request: ice20201109_models.DeleteAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAvatarTrainingJobResponse:
        """
        @summary Deletes a digital human training job that is in the Init or Fail state.
        
        @param request: DeleteAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAvatarTrainingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_avatar_training_job_with_options_async(
        self,
        request: ice20201109_models.DeleteAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteAvatarTrainingJobResponse:
        """
        @summary Deletes a digital human training job that is in the Init or Fail state.
        
        @param request: DeleteAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteAvatarTrainingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_avatar_training_job(
        self,
        request: ice20201109_models.DeleteAvatarTrainingJobRequest,
    ) -> ice20201109_models.DeleteAvatarTrainingJobResponse:
        """
        @summary Deletes a digital human training job that is in the Init or Fail state.
        
        @param request: DeleteAvatarTrainingJobRequest
        @return: DeleteAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_avatar_training_job_with_options(request, runtime)

    async def delete_avatar_training_job_async(
        self,
        request: ice20201109_models.DeleteAvatarTrainingJobRequest,
    ) -> ice20201109_models.DeleteAvatarTrainingJobResponse:
        """
        @summary Deletes a digital human training job that is in the Init or Fail state.
        
        @param request: DeleteAvatarTrainingJobRequest
        @return: DeleteAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_avatar_training_job_with_options_async(request, runtime)

    def delete_category_with_options(
        self,
        request: ice20201109_models.DeleteCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCategoryResponse:
        """
        @summary Deletes a media asset category.
        
        @description This operation also deletes the subcategories, including the level-2 and level-3 categories, of the category.
        
        @param request: DeleteCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCategory',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCategoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_category_with_options_async(
        self,
        request: ice20201109_models.DeleteCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCategoryResponse:
        """
        @summary Deletes a media asset category.
        
        @description This operation also deletes the subcategories, including the level-2 and level-3 categories, of the category.
        
        @param request: DeleteCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCategory',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCategoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_category(
        self,
        request: ice20201109_models.DeleteCategoryRequest,
    ) -> ice20201109_models.DeleteCategoryResponse:
        """
        @summary Deletes a media asset category.
        
        @description This operation also deletes the subcategories, including the level-2 and level-3 categories, of the category.
        
        @param request: DeleteCategoryRequest
        @return: DeleteCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_category_with_options(request, runtime)

    async def delete_category_async(
        self,
        request: ice20201109_models.DeleteCategoryRequest,
    ) -> ice20201109_models.DeleteCategoryResponse:
        """
        @summary Deletes a media asset category.
        
        @description This operation also deletes the subcategories, including the level-2 and level-3 categories, of the category.
        
        @param request: DeleteCategoryRequest
        @return: DeleteCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_category_with_options_async(request, runtime)

    def delete_channel_with_options(
        self,
        request: ice20201109_models.DeleteChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteChannelResponse:
        """
        @summary Deletes a channel in MediaWeaver.
        
        @param request: DeleteChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_channel_with_options_async(
        self,
        request: ice20201109_models.DeleteChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteChannelResponse:
        """
        @summary Deletes a channel in MediaWeaver.
        
        @param request: DeleteChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_channel(
        self,
        request: ice20201109_models.DeleteChannelRequest,
    ) -> ice20201109_models.DeleteChannelResponse:
        """
        @summary Deletes a channel in MediaWeaver.
        
        @param request: DeleteChannelRequest
        @return: DeleteChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_channel_with_options(request, runtime)

    async def delete_channel_async(
        self,
        request: ice20201109_models.DeleteChannelRequest,
    ) -> ice20201109_models.DeleteChannelResponse:
        """
        @summary Deletes a channel in MediaWeaver.
        
        @param request: DeleteChannelRequest
        @return: DeleteChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_channel_with_options_async(request, runtime)

    def delete_custom_template_with_options(
        self,
        request: ice20201109_models.DeleteCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom template.
        
        @param request: DeleteCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCustomTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_custom_template_with_options_async(
        self,
        request: ice20201109_models.DeleteCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom template.
        
        @param request: DeleteCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCustomTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_custom_template(
        self,
        request: ice20201109_models.DeleteCustomTemplateRequest,
    ) -> ice20201109_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom template.
        
        @param request: DeleteCustomTemplateRequest
        @return: DeleteCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_custom_template_with_options(request, runtime)

    async def delete_custom_template_async(
        self,
        request: ice20201109_models.DeleteCustomTemplateRequest,
    ) -> ice20201109_models.DeleteCustomTemplateResponse:
        """
        @summary Deletes a custom template.
        
        @param request: DeleteCustomTemplateRequest
        @return: DeleteCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_custom_template_with_options_async(request, runtime)

    def delete_customized_voice_job_with_options(
        self,
        request: ice20201109_models.DeleteCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCustomizedVoiceJobResponse:
        """
        @summary Deletes a human voice cloning job that is not in the Training or Success state.
        
        @param request: DeleteCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCustomizedVoiceJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customized_voice_job_with_options_async(
        self,
        request: ice20201109_models.DeleteCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteCustomizedVoiceJobResponse:
        """
        @summary Deletes a human voice cloning job that is not in the Training or Success state.
        
        @param request: DeleteCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteCustomizedVoiceJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customized_voice_job(
        self,
        request: ice20201109_models.DeleteCustomizedVoiceJobRequest,
    ) -> ice20201109_models.DeleteCustomizedVoiceJobResponse:
        """
        @summary Deletes a human voice cloning job that is not in the Training or Success state.
        
        @param request: DeleteCustomizedVoiceJobRequest
        @return: DeleteCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_customized_voice_job_with_options(request, runtime)

    async def delete_customized_voice_job_async(
        self,
        request: ice20201109_models.DeleteCustomizedVoiceJobRequest,
    ) -> ice20201109_models.DeleteCustomizedVoiceJobResponse:
        """
        @summary Deletes a human voice cloning job that is not in the Training or Success state.
        
        @param request: DeleteCustomizedVoiceJobRequest
        @return: DeleteCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_customized_voice_job_with_options_async(request, runtime)

    def delete_dnadbwith_options(
        self,
        request: ice20201109_models.DeleteDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteDNADBResponse:
        """
        @summary Deletes a media fingerprint library.
        
        @param request: DeleteDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteDNADBResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dnadbwith_options_async(
        self,
        request: ice20201109_models.DeleteDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteDNADBResponse:
        """
        @summary Deletes a media fingerprint library.
        
        @param request: DeleteDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteDNADBResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dnadb(
        self,
        request: ice20201109_models.DeleteDNADBRequest,
    ) -> ice20201109_models.DeleteDNADBResponse:
        """
        @summary Deletes a media fingerprint library.
        
        @param request: DeleteDNADBRequest
        @return: DeleteDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dnadbwith_options(request, runtime)

    async def delete_dnadb_async(
        self,
        request: ice20201109_models.DeleteDNADBRequest,
    ) -> ice20201109_models.DeleteDNADBResponse:
        """
        @summary Deletes a media fingerprint library.
        
        @param request: DeleteDNADBRequest
        @return: DeleteDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dnadbwith_options_async(request, runtime)

    def delete_dnafiles_with_options(
        self,
        request: ice20201109_models.DeleteDNAFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteDNAFilesResponse:
        """
        @summary Deletes files from a media fingerprint library.
        
        @param request: DeleteDNAFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDNAFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_keys):
            query['PrimaryKeys'] = request.primary_keys
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDNAFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteDNAFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dnafiles_with_options_async(
        self,
        request: ice20201109_models.DeleteDNAFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteDNAFilesResponse:
        """
        @summary Deletes files from a media fingerprint library.
        
        @param request: DeleteDNAFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDNAFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_keys):
            query['PrimaryKeys'] = request.primary_keys
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDNAFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteDNAFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dnafiles(
        self,
        request: ice20201109_models.DeleteDNAFilesRequest,
    ) -> ice20201109_models.DeleteDNAFilesResponse:
        """
        @summary Deletes files from a media fingerprint library.
        
        @param request: DeleteDNAFilesRequest
        @return: DeleteDNAFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dnafiles_with_options(request, runtime)

    async def delete_dnafiles_async(
        self,
        request: ice20201109_models.DeleteDNAFilesRequest,
    ) -> ice20201109_models.DeleteDNAFilesResponse:
        """
        @summary Deletes files from a media fingerprint library.
        
        @param request: DeleteDNAFilesRequest
        @return: DeleteDNAFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dnafiles_with_options_async(request, runtime)

    def delete_editing_project_materials_with_options(
        self,
        request: ice20201109_models.DeleteEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteEditingProjectMaterialsResponse:
        """
        @summary Deletes one or more materials from an online editing project.
        
        @param request: DeleteEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.material_ids):
            query['MaterialIds'] = request.material_ids
        if not UtilClient.is_unset(request.material_type):
            query['MaterialType'] = request.material_type
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteEditingProjectMaterialsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_editing_project_materials_with_options_async(
        self,
        request: ice20201109_models.DeleteEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteEditingProjectMaterialsResponse:
        """
        @summary Deletes one or more materials from an online editing project.
        
        @param request: DeleteEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.material_ids):
            query['MaterialIds'] = request.material_ids
        if not UtilClient.is_unset(request.material_type):
            query['MaterialType'] = request.material_type
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteEditingProjectMaterialsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_editing_project_materials(
        self,
        request: ice20201109_models.DeleteEditingProjectMaterialsRequest,
    ) -> ice20201109_models.DeleteEditingProjectMaterialsResponse:
        """
        @summary Deletes one or more materials from an online editing project.
        
        @param request: DeleteEditingProjectMaterialsRequest
        @return: DeleteEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_editing_project_materials_with_options(request, runtime)

    async def delete_editing_project_materials_async(
        self,
        request: ice20201109_models.DeleteEditingProjectMaterialsRequest,
    ) -> ice20201109_models.DeleteEditingProjectMaterialsResponse:
        """
        @summary Deletes one or more materials from an online editing project.
        
        @param request: DeleteEditingProjectMaterialsRequest
        @return: DeleteEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_editing_project_materials_with_options_async(request, runtime)

    def delete_editing_projects_with_options(
        self,
        request: ice20201109_models.DeleteEditingProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteEditingProjectsResponse:
        """
        @summary Deletes one or more online editing project.
        
        @param request: DeleteEditingProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEditingProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_ids):
            query['ProjectIds'] = request.project_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEditingProjects',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteEditingProjectsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_editing_projects_with_options_async(
        self,
        request: ice20201109_models.DeleteEditingProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteEditingProjectsResponse:
        """
        @summary Deletes one or more online editing project.
        
        @param request: DeleteEditingProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEditingProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_ids):
            query['ProjectIds'] = request.project_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEditingProjects',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteEditingProjectsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_editing_projects(
        self,
        request: ice20201109_models.DeleteEditingProjectsRequest,
    ) -> ice20201109_models.DeleteEditingProjectsResponse:
        """
        @summary Deletes one or more online editing project.
        
        @param request: DeleteEditingProjectsRequest
        @return: DeleteEditingProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_editing_projects_with_options(request, runtime)

    async def delete_editing_projects_async(
        self,
        request: ice20201109_models.DeleteEditingProjectsRequest,
    ) -> ice20201109_models.DeleteEditingProjectsResponse:
        """
        @summary Deletes one or more online editing project.
        
        @param request: DeleteEditingProjectsRequest
        @return: DeleteEditingProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_editing_projects_with_options_async(request, runtime)

    def delete_hotword_library_with_options(
        self,
        request: ice20201109_models.DeleteHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteHotwordLibraryResponse:
        """
        @summary 删除热词词库
        
        @param request: DeleteHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHotwordLibraryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hotword_library_id):
            query['HotwordLibraryId'] = request.hotword_library_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteHotwordLibraryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hotword_library_with_options_async(
        self,
        request: ice20201109_models.DeleteHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteHotwordLibraryResponse:
        """
        @summary 删除热词词库
        
        @param request: DeleteHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHotwordLibraryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hotword_library_id):
            query['HotwordLibraryId'] = request.hotword_library_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteHotwordLibraryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hotword_library(
        self,
        request: ice20201109_models.DeleteHotwordLibraryRequest,
    ) -> ice20201109_models.DeleteHotwordLibraryResponse:
        """
        @summary 删除热词词库
        
        @param request: DeleteHotwordLibraryRequest
        @return: DeleteHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_hotword_library_with_options(request, runtime)

    async def delete_hotword_library_async(
        self,
        request: ice20201109_models.DeleteHotwordLibraryRequest,
    ) -> ice20201109_models.DeleteHotwordLibraryResponse:
        """
        @summary 删除热词词库
        
        @param request: DeleteHotwordLibraryRequest
        @return: DeleteHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_hotword_library_with_options_async(request, runtime)

    def delete_live_package_channel_with_options(
        self,
        request: ice20201109_models.DeleteLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageChannelResponse:
        """
        @summary Deletes a live package channel by GroupName and ChannelName.
        
        @description ## [](#)Usage notes
        You need to provide GroupName and ChannelName as parameters to specify exactly which channel to delete. Before you delete a channel, you must delete the origin endpoints associated with the channel.
        
        @param request: DeleteLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_package_channel_with_options_async(
        self,
        request: ice20201109_models.DeleteLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageChannelResponse:
        """
        @summary Deletes a live package channel by GroupName and ChannelName.
        
        @description ## [](#)Usage notes
        You need to provide GroupName and ChannelName as parameters to specify exactly which channel to delete. Before you delete a channel, you must delete the origin endpoints associated with the channel.
        
        @param request: DeleteLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_package_channel(
        self,
        request: ice20201109_models.DeleteLivePackageChannelRequest,
    ) -> ice20201109_models.DeleteLivePackageChannelResponse:
        """
        @summary Deletes a live package channel by GroupName and ChannelName.
        
        @description ## [](#)Usage notes
        You need to provide GroupName and ChannelName as parameters to specify exactly which channel to delete. Before you delete a channel, you must delete the origin endpoints associated with the channel.
        
        @param request: DeleteLivePackageChannelRequest
        @return: DeleteLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_package_channel_with_options(request, runtime)

    async def delete_live_package_channel_async(
        self,
        request: ice20201109_models.DeleteLivePackageChannelRequest,
    ) -> ice20201109_models.DeleteLivePackageChannelResponse:
        """
        @summary Deletes a live package channel by GroupName and ChannelName.
        
        @description ## [](#)Usage notes
        You need to provide GroupName and ChannelName as parameters to specify exactly which channel to delete. Before you delete a channel, you must delete the origin endpoints associated with the channel.
        
        @param request: DeleteLivePackageChannelRequest
        @return: DeleteLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_package_channel_with_options_async(request, runtime)

    def delete_live_package_channel_group_with_options(
        self,
        request: ice20201109_models.DeleteLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageChannelGroupResponse:
        """
        @summary Deletes a live package channel group by name.
        
        @description ## [](#)Usage notes
        Make sure that no channels are included in the channel group before you delete it.
        
        @param request: DeleteLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageChannelGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_package_channel_group_with_options_async(
        self,
        request: ice20201109_models.DeleteLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageChannelGroupResponse:
        """
        @summary Deletes a live package channel group by name.
        
        @description ## [](#)Usage notes
        Make sure that no channels are included in the channel group before you delete it.
        
        @param request: DeleteLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageChannelGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_package_channel_group(
        self,
        request: ice20201109_models.DeleteLivePackageChannelGroupRequest,
    ) -> ice20201109_models.DeleteLivePackageChannelGroupResponse:
        """
        @summary Deletes a live package channel group by name.
        
        @description ## [](#)Usage notes
        Make sure that no channels are included in the channel group before you delete it.
        
        @param request: DeleteLivePackageChannelGroupRequest
        @return: DeleteLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_package_channel_group_with_options(request, runtime)

    async def delete_live_package_channel_group_async(
        self,
        request: ice20201109_models.DeleteLivePackageChannelGroupRequest,
    ) -> ice20201109_models.DeleteLivePackageChannelGroupResponse:
        """
        @summary Deletes a live package channel group by name.
        
        @description ## [](#)Usage notes
        Make sure that no channels are included in the channel group before you delete it.
        
        @param request: DeleteLivePackageChannelGroupRequest
        @return: DeleteLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_package_channel_group_with_options_async(request, runtime)

    def delete_live_package_origin_endpoint_with_options(
        self,
        request: ice20201109_models.DeleteLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageOriginEndpointResponse:
        """
        @summary Deletes an origin endpoint associated with a live package channel.
        
        @description ## [](#)Usage notes
        This API operation is used to delete an origin endpoint associated with a live package channel by specifying `GroupName`, `ChannelName`, and `EndpointName`. This operation will permanently delete the relevant configurations. Exercise caution when you perform this operation.
        
        @param request: DeleteLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageOriginEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_package_origin_endpoint_with_options_async(
        self,
        request: ice20201109_models.DeleteLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLivePackageOriginEndpointResponse:
        """
        @summary Deletes an origin endpoint associated with a live package channel.
        
        @description ## [](#)Usage notes
        This API operation is used to delete an origin endpoint associated with a live package channel by specifying `GroupName`, `ChannelName`, and `EndpointName`. This operation will permanently delete the relevant configurations. Exercise caution when you perform this operation.
        
        @param request: DeleteLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLivePackageOriginEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_package_origin_endpoint(
        self,
        request: ice20201109_models.DeleteLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.DeleteLivePackageOriginEndpointResponse:
        """
        @summary Deletes an origin endpoint associated with a live package channel.
        
        @description ## [](#)Usage notes
        This API operation is used to delete an origin endpoint associated with a live package channel by specifying `GroupName`, `ChannelName`, and `EndpointName`. This operation will permanently delete the relevant configurations. Exercise caution when you perform this operation.
        
        @param request: DeleteLivePackageOriginEndpointRequest
        @return: DeleteLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_package_origin_endpoint_with_options(request, runtime)

    async def delete_live_package_origin_endpoint_async(
        self,
        request: ice20201109_models.DeleteLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.DeleteLivePackageOriginEndpointResponse:
        """
        @summary Deletes an origin endpoint associated with a live package channel.
        
        @description ## [](#)Usage notes
        This API operation is used to delete an origin endpoint associated with a live package channel by specifying `GroupName`, `ChannelName`, and `EndpointName`. This operation will permanently delete the relevant configurations. Exercise caution when you perform this operation.
        
        @param request: DeleteLivePackageOriginEndpointRequest
        @return: DeleteLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_package_origin_endpoint_with_options_async(request, runtime)

    def delete_live_record_files_with_options(
        self,
        request: ice20201109_models.DeleteLiveRecordFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveRecordFilesResponse:
        """
        @summary Deletes live stream recording files. You can choose to delete only the recording files or delete both the recording files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveRecordFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.record_ids):
            query['RecordIds'] = request.record_ids
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveRecordFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_record_files_with_options_async(
        self,
        request: ice20201109_models.DeleteLiveRecordFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveRecordFilesResponse:
        """
        @summary Deletes live stream recording files. You can choose to delete only the recording files or delete both the recording files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveRecordFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.record_ids):
            query['RecordIds'] = request.record_ids
        if not UtilClient.is_unset(request.remove_file):
            query['RemoveFile'] = request.remove_file
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveRecordFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_record_files(
        self,
        request: ice20201109_models.DeleteLiveRecordFilesRequest,
    ) -> ice20201109_models.DeleteLiveRecordFilesResponse:
        """
        @summary Deletes live stream recording files. You can choose to delete only the recording files or delete both the recording files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveRecordFilesRequest
        @return: DeleteLiveRecordFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_record_files_with_options(request, runtime)

    async def delete_live_record_files_async(
        self,
        request: ice20201109_models.DeleteLiveRecordFilesRequest,
    ) -> ice20201109_models.DeleteLiveRecordFilesResponse:
        """
        @summary Deletes live stream recording files. You can choose to delete only the recording files or delete both the recording files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveRecordFilesRequest
        @return: DeleteLiveRecordFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_record_files_with_options_async(request, runtime)

    def delete_live_record_template_with_options(
        self,
        request: ice20201109_models.DeleteLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveRecordTemplateResponse:
        """
        @summary Deletes a live stream recording template without affecting existing jobs.
        
        @param request: DeleteLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveRecordTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_record_template_with_options_async(
        self,
        request: ice20201109_models.DeleteLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveRecordTemplateResponse:
        """
        @summary Deletes a live stream recording template without affecting existing jobs.
        
        @param request: DeleteLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveRecordTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveRecordTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_record_template(
        self,
        request: ice20201109_models.DeleteLiveRecordTemplateRequest,
    ) -> ice20201109_models.DeleteLiveRecordTemplateResponse:
        """
        @summary Deletes a live stream recording template without affecting existing jobs.
        
        @param request: DeleteLiveRecordTemplateRequest
        @return: DeleteLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_record_template_with_options(request, runtime)

    async def delete_live_record_template_async(
        self,
        request: ice20201109_models.DeleteLiveRecordTemplateRequest,
    ) -> ice20201109_models.DeleteLiveRecordTemplateResponse:
        """
        @summary Deletes a live stream recording template without affecting existing jobs.
        
        @param request: DeleteLiveRecordTemplateRequest
        @return: DeleteLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_record_template_with_options_async(request, runtime)

    def delete_live_snapshot_files_with_options(
        self,
        tmp_req: ice20201109_models.DeleteLiveSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveSnapshotFilesResponse:
        """
        @summary Deletes live stream snapshot files. You can choose to delete only the snapshot files or delete both the snapshot files and the original Object Storage Service (OSS) files.
        
        @param tmp_req: DeleteLiveSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotFilesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.DeleteLiveSnapshotFilesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.create_timestamp_list):
            request.create_timestamp_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.create_timestamp_list, 'CreateTimestampList', 'json')
        query = {}
        if not UtilClient.is_unset(request.create_timestamp_list_shrink):
            query['CreateTimestampList'] = request.create_timestamp_list_shrink
        if not UtilClient.is_unset(request.delete_original_file):
            query['DeleteOriginalFile'] = request.delete_original_file
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveSnapshotFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_snapshot_files_with_options_async(
        self,
        tmp_req: ice20201109_models.DeleteLiveSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveSnapshotFilesResponse:
        """
        @summary Deletes live stream snapshot files. You can choose to delete only the snapshot files or delete both the snapshot files and the original Object Storage Service (OSS) files.
        
        @param tmp_req: DeleteLiveSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotFilesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.DeleteLiveSnapshotFilesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.create_timestamp_list):
            request.create_timestamp_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.create_timestamp_list, 'CreateTimestampList', 'json')
        query = {}
        if not UtilClient.is_unset(request.create_timestamp_list_shrink):
            query['CreateTimestampList'] = request.create_timestamp_list_shrink
        if not UtilClient.is_unset(request.delete_original_file):
            query['DeleteOriginalFile'] = request.delete_original_file
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveSnapshotFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_snapshot_files(
        self,
        request: ice20201109_models.DeleteLiveSnapshotFilesRequest,
    ) -> ice20201109_models.DeleteLiveSnapshotFilesResponse:
        """
        @summary Deletes live stream snapshot files. You can choose to delete only the snapshot files or delete both the snapshot files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveSnapshotFilesRequest
        @return: DeleteLiveSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_snapshot_files_with_options(request, runtime)

    async def delete_live_snapshot_files_async(
        self,
        request: ice20201109_models.DeleteLiveSnapshotFilesRequest,
    ) -> ice20201109_models.DeleteLiveSnapshotFilesResponse:
        """
        @summary Deletes live stream snapshot files. You can choose to delete only the snapshot files or delete both the snapshot files and the original Object Storage Service (OSS) files.
        
        @param request: DeleteLiveSnapshotFilesRequest
        @return: DeleteLiveSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_snapshot_files_with_options_async(request, runtime)

    def delete_live_snapshot_template_with_options(
        self,
        request: ice20201109_models.DeleteLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveSnapshotTemplateResponse:
        """
        @summary Deletes a live stream snapshot template.
        
        @param request: DeleteLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.template_id):
            body['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveSnapshotTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_snapshot_template_with_options_async(
        self,
        request: ice20201109_models.DeleteLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveSnapshotTemplateResponse:
        """
        @summary Deletes a live stream snapshot template.
        
        @param request: DeleteLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.template_id):
            body['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveSnapshotTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_snapshot_template(
        self,
        request: ice20201109_models.DeleteLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.DeleteLiveSnapshotTemplateResponse:
        """
        @summary Deletes a live stream snapshot template.
        
        @param request: DeleteLiveSnapshotTemplateRequest
        @return: DeleteLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_snapshot_template_with_options(request, runtime)

    async def delete_live_snapshot_template_async(
        self,
        request: ice20201109_models.DeleteLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.DeleteLiveSnapshotTemplateResponse:
        """
        @summary Deletes a live stream snapshot template.
        
        @param request: DeleteLiveSnapshotTemplateRequest
        @return: DeleteLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_snapshot_template_with_options_async(request, runtime)

    def delete_live_transcode_job_with_options(
        self,
        request: ice20201109_models.DeleteLiveTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveTranscodeJobResponse:
        """
        @summary 删除指定转码任务
        
        @param request: DeleteLiveTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveTranscodeJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_transcode_job_with_options_async(
        self,
        request: ice20201109_models.DeleteLiveTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveTranscodeJobResponse:
        """
        @summary 删除指定转码任务
        
        @param request: DeleteLiveTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveTranscodeJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_transcode_job(
        self,
        request: ice20201109_models.DeleteLiveTranscodeJobRequest,
    ) -> ice20201109_models.DeleteLiveTranscodeJobResponse:
        """
        @summary 删除指定转码任务
        
        @param request: DeleteLiveTranscodeJobRequest
        @return: DeleteLiveTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_transcode_job_with_options(request, runtime)

    async def delete_live_transcode_job_async(
        self,
        request: ice20201109_models.DeleteLiveTranscodeJobRequest,
    ) -> ice20201109_models.DeleteLiveTranscodeJobResponse:
        """
        @summary 删除指定转码任务
        
        @param request: DeleteLiveTranscodeJobRequest
        @return: DeleteLiveTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_transcode_job_with_options_async(request, runtime)

    def delete_live_transcode_template_with_options(
        self,
        request: ice20201109_models.DeleteLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveTranscodeTemplateResponse:
        """
        @summary Deletes a live stream transcoding template.
        
        @param request: DeleteLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveTranscodeTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_live_transcode_template_with_options_async(
        self,
        request: ice20201109_models.DeleteLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteLiveTranscodeTemplateResponse:
        """
        @summary Deletes a live stream transcoding template.
        
        @param request: DeleteLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteLiveTranscodeTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_live_transcode_template(
        self,
        request: ice20201109_models.DeleteLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.DeleteLiveTranscodeTemplateResponse:
        """
        @summary Deletes a live stream transcoding template.
        
        @param request: DeleteLiveTranscodeTemplateRequest
        @return: DeleteLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_live_transcode_template_with_options(request, runtime)

    async def delete_live_transcode_template_async(
        self,
        request: ice20201109_models.DeleteLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.DeleteLiveTranscodeTemplateResponse:
        """
        @summary Deletes a live stream transcoding template.
        
        @param request: DeleteLiveTranscodeTemplateRequest
        @return: DeleteLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_live_transcode_template_with_options_async(request, runtime)

    def delete_media_connect_flow_with_options(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowResponse:
        """
        @summary Deletes a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is deleted, its source and outputs are also deleted.
        When a flow is in the online state, it cannot be deleted.
        
        @param request: DeleteMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_connect_flow_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowResponse:
        """
        @summary Deletes a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is deleted, its source and outputs are also deleted.
        When a flow is in the online state, it cannot be deleted.
        
        @param request: DeleteMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_connect_flow(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowResponse:
        """
        @summary Deletes a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is deleted, its source and outputs are also deleted.
        When a flow is in the online state, it cannot be deleted.
        
        @param request: DeleteMediaConnectFlowRequest
        @return: DeleteMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_connect_flow_with_options(request, runtime)

    async def delete_media_connect_flow_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowResponse:
        """
        @summary Deletes a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is deleted, its source and outputs are also deleted.
        When a flow is in the online state, it cannot be deleted.
        
        @param request: DeleteMediaConnectFlowRequest
        @return: DeleteMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_connect_flow_with_options_async(request, runtime)

    def delete_media_connect_flow_input_with_options(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowInputResponse:
        """
        @summary Deletes the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its source cannot be deleted.
        You can delete the source only after all outputs of the flow have been deleted.
        
        @param request: DeleteMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.input_name):
            query['InputName'] = request.input_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_connect_flow_input_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowInputResponse:
        """
        @summary Deletes the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its source cannot be deleted.
        You can delete the source only after all outputs of the flow have been deleted.
        
        @param request: DeleteMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.input_name):
            query['InputName'] = request.input_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_connect_flow_input(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowInputRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowInputResponse:
        """
        @summary Deletes the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its source cannot be deleted.
        You can delete the source only after all outputs of the flow have been deleted.
        
        @param request: DeleteMediaConnectFlowInputRequest
        @return: DeleteMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_connect_flow_input_with_options(request, runtime)

    async def delete_media_connect_flow_input_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowInputRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowInputResponse:
        """
        @summary Deletes the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its source cannot be deleted.
        You can delete the source only after all outputs of the flow have been deleted.
        
        @param request: DeleteMediaConnectFlowInputRequest
        @return: DeleteMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_connect_flow_input_with_options_async(request, runtime)

    def delete_media_connect_flow_output_with_options(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowOutputResponse:
        """
        @summary Deletes an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its outputs cannot be deleted.
        
        @param request: DeleteMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowOutputResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_connect_flow_output_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaConnectFlowOutputResponse:
        """
        @summary Deletes an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its outputs cannot be deleted.
        
        @param request: DeleteMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaConnectFlowOutputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_connect_flow_output(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowOutputResponse:
        """
        @summary Deletes an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its outputs cannot be deleted.
        
        @param request: DeleteMediaConnectFlowOutputRequest
        @return: DeleteMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_connect_flow_output_with_options(request, runtime)

    async def delete_media_connect_flow_output_async(
        self,
        request: ice20201109_models.DeleteMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.DeleteMediaConnectFlowOutputResponse:
        """
        @summary Deletes an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        When a flow is in the online state, its outputs cannot be deleted.
        
        @param request: DeleteMediaConnectFlowOutputRequest
        @return: DeleteMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_connect_flow_output_with_options_async(request, runtime)

    def delete_media_from_search_lib_with_options(
        self,
        request: ice20201109_models.DeleteMediaFromSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaFromSearchLibResponse:
        """
        @summary Deletes a specific media asset from a search library.
        
        @param request: DeleteMediaFromSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaFromSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.msg_body):
            query['MsgBody'] = request.msg_body
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaFromSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaFromSearchLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_from_search_lib_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaFromSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaFromSearchLibResponse:
        """
        @summary Deletes a specific media asset from a search library.
        
        @param request: DeleteMediaFromSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaFromSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.msg_body):
            query['MsgBody'] = request.msg_body
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaFromSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaFromSearchLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_from_search_lib(
        self,
        request: ice20201109_models.DeleteMediaFromSearchLibRequest,
    ) -> ice20201109_models.DeleteMediaFromSearchLibResponse:
        """
        @summary Deletes a specific media asset from a search library.
        
        @param request: DeleteMediaFromSearchLibRequest
        @return: DeleteMediaFromSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_from_search_lib_with_options(request, runtime)

    async def delete_media_from_search_lib_async(
        self,
        request: ice20201109_models.DeleteMediaFromSearchLibRequest,
    ) -> ice20201109_models.DeleteMediaFromSearchLibResponse:
        """
        @summary Deletes a specific media asset from a search library.
        
        @param request: DeleteMediaFromSearchLibRequest
        @return: DeleteMediaFromSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_from_search_lib_with_options_async(request, runtime)

    def delete_media_infos_with_options(
        self,
        request: ice20201109_models.DeleteMediaInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaInfosResponse:
        """
        @summary Deletes multiple media assets at a time. You can delete at most 20 media assets at a time. If MediaIds is specified, it is preferentially used. If MediaIds is empty, InputURLs must be specified.
        
        @param request: DeleteMediaInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_physical_files):
            query['DeletePhysicalFiles'] = request.delete_physical_files
        if not UtilClient.is_unset(request.input_urls):
            query['InputURLs'] = request.input_urls
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_infos_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaInfosResponse:
        """
        @summary Deletes multiple media assets at a time. You can delete at most 20 media assets at a time. If MediaIds is specified, it is preferentially used. If MediaIds is empty, InputURLs must be specified.
        
        @param request: DeleteMediaInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_physical_files):
            query['DeletePhysicalFiles'] = request.delete_physical_files
        if not UtilClient.is_unset(request.input_urls):
            query['InputURLs'] = request.input_urls
        if not UtilClient.is_unset(request.media_ids):
            query['MediaIds'] = request.media_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_infos(
        self,
        request: ice20201109_models.DeleteMediaInfosRequest,
    ) -> ice20201109_models.DeleteMediaInfosResponse:
        """
        @summary Deletes multiple media assets at a time. You can delete at most 20 media assets at a time. If MediaIds is specified, it is preferentially used. If MediaIds is empty, InputURLs must be specified.
        
        @param request: DeleteMediaInfosRequest
        @return: DeleteMediaInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_infos_with_options(request, runtime)

    async def delete_media_infos_async(
        self,
        request: ice20201109_models.DeleteMediaInfosRequest,
    ) -> ice20201109_models.DeleteMediaInfosResponse:
        """
        @summary Deletes multiple media assets at a time. You can delete at most 20 media assets at a time. If MediaIds is specified, it is preferentially used. If MediaIds is empty, InputURLs must be specified.
        
        @param request: DeleteMediaInfosRequest
        @return: DeleteMediaInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_infos_with_options_async(request, runtime)

    def delete_media_live_channel_with_options(
        self,
        request: ice20201109_models.DeleteMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveChannelResponse:
        """
        @summary Deletes a MediaLive channel.
        
        @description   You can only delete a channel that is not running.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveChannelResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel_id):
            body['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_live_channel_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveChannelResponse:
        """
        @summary Deletes a MediaLive channel.
        
        @description   You can only delete a channel that is not running.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveChannelResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel_id):
            body['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_live_channel(
        self,
        request: ice20201109_models.DeleteMediaLiveChannelRequest,
    ) -> ice20201109_models.DeleteMediaLiveChannelResponse:
        """
        @summary Deletes a MediaLive channel.
        
        @description   You can only delete a channel that is not running.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveChannelRequest
        @return: DeleteMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_live_channel_with_options(request, runtime)

    async def delete_media_live_channel_async(
        self,
        request: ice20201109_models.DeleteMediaLiveChannelRequest,
    ) -> ice20201109_models.DeleteMediaLiveChannelResponse:
        """
        @summary Deletes a MediaLive channel.
        
        @description   You can only delete a channel that is not running.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveChannelRequest
        @return: DeleteMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_live_channel_with_options_async(request, runtime)

    def delete_media_live_input_with_options(
        self,
        request: ice20201109_models.DeleteMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveInputResponse:
        """
        @summary Deletes a MediaLive input.
        
        @description    You can delete an input only when it is not associated with a MediaLive channel.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveInputResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.input_id):
            body['InputId'] = request.input_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_live_input_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveInputResponse:
        """
        @summary Deletes a MediaLive input.
        
        @description    You can delete an input only when it is not associated with a MediaLive channel.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveInputResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.input_id):
            body['InputId'] = request.input_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_live_input(
        self,
        request: ice20201109_models.DeleteMediaLiveInputRequest,
    ) -> ice20201109_models.DeleteMediaLiveInputResponse:
        """
        @summary Deletes a MediaLive input.
        
        @description    You can delete an input only when it is not associated with a MediaLive channel.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputRequest
        @return: DeleteMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_live_input_with_options(request, runtime)

    async def delete_media_live_input_async(
        self,
        request: ice20201109_models.DeleteMediaLiveInputRequest,
    ) -> ice20201109_models.DeleteMediaLiveInputResponse:
        """
        @summary Deletes a MediaLive input.
        
        @description    You can delete an input only when it is not associated with a MediaLive channel.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputRequest
        @return: DeleteMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_live_input_with_options_async(request, runtime)

    def delete_media_live_input_security_group_with_options(
        self,
        request: ice20201109_models.DeleteMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse:
        """
        @summary Deletes a security group in MediaLive.
        
        @description    You can only delete a security group not associated with an input.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.security_group_id):
            body['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_live_input_security_group_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse:
        """
        @summary Deletes a security group in MediaLive.
        
        @description    You can only delete a security group not associated with an input.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.security_group_id):
            body['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_live_input_security_group(
        self,
        request: ice20201109_models.DeleteMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse:
        """
        @summary Deletes a security group in MediaLive.
        
        @description    You can only delete a security group not associated with an input.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputSecurityGroupRequest
        @return: DeleteMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_live_input_security_group_with_options(request, runtime)

    async def delete_media_live_input_security_group_async(
        self,
        request: ice20201109_models.DeleteMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.DeleteMediaLiveInputSecurityGroupResponse:
        """
        @summary Deletes a security group in MediaLive.
        
        @description    You can only delete a security group not associated with an input.
        ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: DeleteMediaLiveInputSecurityGroupRequest
        @return: DeleteMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_live_input_security_group_with_options_async(request, runtime)

    def delete_media_marks_with_options(
        self,
        request: ice20201109_models.DeleteMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaMarksResponse:
        """
        @summary Deletes the marks of a media asset.
        
        @param request: DeleteMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaMarksResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_media_marks_with_options_async(
        self,
        request: ice20201109_models.DeleteMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteMediaMarksResponse:
        """
        @summary Deletes the marks of a media asset.
        
        @param request: DeleteMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteMediaMarksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_media_marks(
        self,
        request: ice20201109_models.DeleteMediaMarksRequest,
    ) -> ice20201109_models.DeleteMediaMarksResponse:
        """
        @summary Deletes the marks of a media asset.
        
        @param request: DeleteMediaMarksRequest
        @return: DeleteMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_media_marks_with_options(request, runtime)

    async def delete_media_marks_async(
        self,
        request: ice20201109_models.DeleteMediaMarksRequest,
    ) -> ice20201109_models.DeleteMediaMarksResponse:
        """
        @summary Deletes the marks of a media asset.
        
        @param request: DeleteMediaMarksRequest
        @return: DeleteMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_media_marks_with_options_async(request, runtime)

    def delete_pipeline_with_options(
        self,
        request: ice20201109_models.DeletePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeletePipelineResponse:
        """
        @summary Deletes an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: DeletePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pipeline_id):
            query['PipelineId'] = request.pipeline_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeletePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_pipeline_with_options_async(
        self,
        request: ice20201109_models.DeletePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeletePipelineResponse:
        """
        @summary Deletes an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: DeletePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pipeline_id):
            query['PipelineId'] = request.pipeline_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeletePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_pipeline(
        self,
        request: ice20201109_models.DeletePipelineRequest,
    ) -> ice20201109_models.DeletePipelineResponse:
        """
        @summary Deletes an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: DeletePipelineRequest
        @return: DeletePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_pipeline_with_options(request, runtime)

    async def delete_pipeline_async(
        self,
        request: ice20201109_models.DeletePipelineRequest,
    ) -> ice20201109_models.DeletePipelineResponse:
        """
        @summary Deletes an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: DeletePipelineRequest
        @return: DeletePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_pipeline_with_options_async(request, runtime)

    def delete_play_info_with_options(
        self,
        request: ice20201109_models.DeletePlayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeletePlayInfoResponse:
        """
        @summary Deletes media streams such as video streams and audio streams.
        
        @description You can call this operation to delete multiple media streams at a time.
        
        @param request: DeletePlayInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlayInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_physical_files):
            query['DeletePhysicalFiles'] = request.delete_physical_files
        if not UtilClient.is_unset(request.file_urls):
            query['FileURLs'] = request.file_urls
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlayInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeletePlayInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_play_info_with_options_async(
        self,
        request: ice20201109_models.DeletePlayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeletePlayInfoResponse:
        """
        @summary Deletes media streams such as video streams and audio streams.
        
        @description You can call this operation to delete multiple media streams at a time.
        
        @param request: DeletePlayInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePlayInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_physical_files):
            query['DeletePhysicalFiles'] = request.delete_physical_files
        if not UtilClient.is_unset(request.file_urls):
            query['FileURLs'] = request.file_urls
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePlayInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeletePlayInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_play_info(
        self,
        request: ice20201109_models.DeletePlayInfoRequest,
    ) -> ice20201109_models.DeletePlayInfoResponse:
        """
        @summary Deletes media streams such as video streams and audio streams.
        
        @description You can call this operation to delete multiple media streams at a time.
        
        @param request: DeletePlayInfoRequest
        @return: DeletePlayInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_play_info_with_options(request, runtime)

    async def delete_play_info_async(
        self,
        request: ice20201109_models.DeletePlayInfoRequest,
    ) -> ice20201109_models.DeletePlayInfoResponse:
        """
        @summary Deletes media streams such as video streams and audio streams.
        
        @description You can call this operation to delete multiple media streams at a time.
        
        @param request: DeletePlayInfoRequest
        @return: DeletePlayInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_play_info_with_options_async(request, runtime)

    def delete_program_with_options(
        self,
        request: ice20201109_models.DeleteProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteProgramResponse:
        """
        @summary Deletes a program from a channel.
        
        @param request: DeleteProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_program_with_options_async(
        self,
        request: ice20201109_models.DeleteProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteProgramResponse:
        """
        @summary Deletes a program from a channel.
        
        @param request: DeleteProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_program(
        self,
        request: ice20201109_models.DeleteProgramRequest,
    ) -> ice20201109_models.DeleteProgramResponse:
        """
        @summary Deletes a program from a channel.
        
        @param request: DeleteProgramRequest
        @return: DeleteProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_program_with_options(request, runtime)

    async def delete_program_async(
        self,
        request: ice20201109_models.DeleteProgramRequest,
    ) -> ice20201109_models.DeleteProgramResponse:
        """
        @summary Deletes a program from a channel.
        
        @param request: DeleteProgramRequest
        @return: DeleteProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_program_with_options_async(request, runtime)

    def delete_recognition_entity_with_options(
        self,
        request: ice20201109_models.DeleteRecognitionEntityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionEntityResponse:
        """
        @summary 删除自定义库实体
        
        @param request: DeleteRecognitionEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionEntityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionEntity',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionEntityResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_recognition_entity_with_options_async(
        self,
        request: ice20201109_models.DeleteRecognitionEntityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionEntityResponse:
        """
        @summary 删除自定义库实体
        
        @param request: DeleteRecognitionEntityRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionEntityResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionEntity',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionEntityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_recognition_entity(
        self,
        request: ice20201109_models.DeleteRecognitionEntityRequest,
    ) -> ice20201109_models.DeleteRecognitionEntityResponse:
        """
        @summary 删除自定义库实体
        
        @param request: DeleteRecognitionEntityRequest
        @return: DeleteRecognitionEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_recognition_entity_with_options(request, runtime)

    async def delete_recognition_entity_async(
        self,
        request: ice20201109_models.DeleteRecognitionEntityRequest,
    ) -> ice20201109_models.DeleteRecognitionEntityResponse:
        """
        @summary 删除自定义库实体
        
        @param request: DeleteRecognitionEntityRequest
        @return: DeleteRecognitionEntityResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_recognition_entity_with_options_async(request, runtime)

    def delete_recognition_lib_with_options(
        self,
        request: ice20201109_models.DeleteRecognitionLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionLibResponse:
        """
        @summary 删除自定义库
        
        @param request: DeleteRecognitionLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_recognition_lib_with_options_async(
        self,
        request: ice20201109_models.DeleteRecognitionLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionLibResponse:
        """
        @summary 删除自定义库
        
        @param request: DeleteRecognitionLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_recognition_lib(
        self,
        request: ice20201109_models.DeleteRecognitionLibRequest,
    ) -> ice20201109_models.DeleteRecognitionLibResponse:
        """
        @summary 删除自定义库
        
        @param request: DeleteRecognitionLibRequest
        @return: DeleteRecognitionLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_recognition_lib_with_options(request, runtime)

    async def delete_recognition_lib_async(
        self,
        request: ice20201109_models.DeleteRecognitionLibRequest,
    ) -> ice20201109_models.DeleteRecognitionLibResponse:
        """
        @summary 删除自定义库
        
        @param request: DeleteRecognitionLibRequest
        @return: DeleteRecognitionLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_recognition_lib_with_options_async(request, runtime)

    def delete_recognition_sample_with_options(
        self,
        request: ice20201109_models.DeleteRecognitionSampleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionSampleResponse:
        """
        @summary 删除自定义实体照片
        
        @param request: DeleteRecognitionSampleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionSampleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.sample_id):
            query['SampleId'] = request.sample_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionSample',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionSampleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_recognition_sample_with_options_async(
        self,
        request: ice20201109_models.DeleteRecognitionSampleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteRecognitionSampleResponse:
        """
        @summary 删除自定义实体照片
        
        @param request: DeleteRecognitionSampleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRecognitionSampleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.sample_id):
            query['SampleId'] = request.sample_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRecognitionSample',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteRecognitionSampleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_recognition_sample(
        self,
        request: ice20201109_models.DeleteRecognitionSampleRequest,
    ) -> ice20201109_models.DeleteRecognitionSampleResponse:
        """
        @summary 删除自定义实体照片
        
        @param request: DeleteRecognitionSampleRequest
        @return: DeleteRecognitionSampleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_recognition_sample_with_options(request, runtime)

    async def delete_recognition_sample_async(
        self,
        request: ice20201109_models.DeleteRecognitionSampleRequest,
    ) -> ice20201109_models.DeleteRecognitionSampleResponse:
        """
        @summary 删除自定义实体照片
        
        @param request: DeleteRecognitionSampleRequest
        @return: DeleteRecognitionSampleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_recognition_sample_with_options_async(request, runtime)

    def delete_smart_job_with_options(
        self,
        request: ice20201109_models.DeleteSmartJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSmartJobResponse:
        """
        @summary Deletes intelligent jobs based on job IDs.
        
        @param request: DeleteSmartJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSmartJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSmartJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSmartJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_smart_job_with_options_async(
        self,
        request: ice20201109_models.DeleteSmartJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSmartJobResponse:
        """
        @summary Deletes intelligent jobs based on job IDs.
        
        @param request: DeleteSmartJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSmartJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSmartJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSmartJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_smart_job(
        self,
        request: ice20201109_models.DeleteSmartJobRequest,
    ) -> ice20201109_models.DeleteSmartJobResponse:
        """
        @summary Deletes intelligent jobs based on job IDs.
        
        @param request: DeleteSmartJobRequest
        @return: DeleteSmartJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_smart_job_with_options(request, runtime)

    async def delete_smart_job_async(
        self,
        request: ice20201109_models.DeleteSmartJobRequest,
    ) -> ice20201109_models.DeleteSmartJobResponse:
        """
        @summary Deletes intelligent jobs based on job IDs.
        
        @param request: DeleteSmartJobRequest
        @return: DeleteSmartJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_smart_job_with_options_async(request, runtime)

    def delete_source_with_options(
        self,
        request: ice20201109_models.DeleteSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSourceResponse:
        """
        @summary Deletes a source from MediaWeaver.
        
        @param request: DeleteSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.soft_delete):
            query['SoftDelete'] = request.soft_delete
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_source_with_options_async(
        self,
        request: ice20201109_models.DeleteSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSourceResponse:
        """
        @summary Deletes a source from MediaWeaver.
        
        @param request: DeleteSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.soft_delete):
            query['SoftDelete'] = request.soft_delete
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_source(
        self,
        request: ice20201109_models.DeleteSourceRequest,
    ) -> ice20201109_models.DeleteSourceResponse:
        """
        @summary Deletes a source from MediaWeaver.
        
        @param request: DeleteSourceRequest
        @return: DeleteSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_source_with_options(request, runtime)

    async def delete_source_async(
        self,
        request: ice20201109_models.DeleteSourceRequest,
    ) -> ice20201109_models.DeleteSourceResponse:
        """
        @summary Deletes a source from MediaWeaver.
        
        @param request: DeleteSourceRequest
        @return: DeleteSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_source_with_options_async(request, runtime)

    def delete_source_location_with_options(
        self,
        request: ice20201109_models.DeleteSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSourceLocationResponse:
        """
        @summary Deletes a source location.
        
        @param request: DeleteSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.soft_delete):
            query['SoftDelete'] = request.soft_delete
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSourceLocationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_source_location_with_options_async(
        self,
        request: ice20201109_models.DeleteSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteSourceLocationResponse:
        """
        @summary Deletes a source location.
        
        @param request: DeleteSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.soft_delete):
            query['SoftDelete'] = request.soft_delete
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteSourceLocationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_source_location(
        self,
        request: ice20201109_models.DeleteSourceLocationRequest,
    ) -> ice20201109_models.DeleteSourceLocationResponse:
        """
        @summary Deletes a source location.
        
        @param request: DeleteSourceLocationRequest
        @return: DeleteSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_source_location_with_options(request, runtime)

    async def delete_source_location_async(
        self,
        request: ice20201109_models.DeleteSourceLocationRequest,
    ) -> ice20201109_models.DeleteSourceLocationResponse:
        """
        @summary Deletes a source location.
        
        @param request: DeleteSourceLocationRequest
        @return: DeleteSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_source_location_with_options_async(request, runtime)

    def delete_template_with_options(
        self,
        request: ice20201109_models.DeleteTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteTemplateResponse:
        """
        @summary Deletes templates.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: DeleteTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_template_with_options_async(
        self,
        request: ice20201109_models.DeleteTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteTemplateResponse:
        """
        @summary Deletes templates.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: DeleteTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_template(
        self,
        request: ice20201109_models.DeleteTemplateRequest,
    ) -> ice20201109_models.DeleteTemplateResponse:
        """
        @summary Deletes templates.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: DeleteTemplateRequest
        @return: DeleteTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_template_with_options(request, runtime)

    async def delete_template_async(
        self,
        request: ice20201109_models.DeleteTemplateRequest,
    ) -> ice20201109_models.DeleteTemplateResponse:
        """
        @summary Deletes templates.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: DeleteTemplateRequest
        @return: DeleteTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_template_with_options_async(request, runtime)

    def delete_vod_packaging_asset_with_options(
        self,
        request: ice20201109_models.DeleteVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingAssetResponse:
        """
        @summary Deletes a VOD packaging asset.
        
        @param request: DeleteVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingAssetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vod_packaging_asset_with_options_async(
        self,
        request: ice20201109_models.DeleteVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingAssetResponse:
        """
        @summary Deletes a VOD packaging asset.
        
        @param request: DeleteVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingAssetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vod_packaging_asset(
        self,
        request: ice20201109_models.DeleteVodPackagingAssetRequest,
    ) -> ice20201109_models.DeleteVodPackagingAssetResponse:
        """
        @summary Deletes a VOD packaging asset.
        
        @param request: DeleteVodPackagingAssetRequest
        @return: DeleteVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vod_packaging_asset_with_options(request, runtime)

    async def delete_vod_packaging_asset_async(
        self,
        request: ice20201109_models.DeleteVodPackagingAssetRequest,
    ) -> ice20201109_models.DeleteVodPackagingAssetResponse:
        """
        @summary Deletes a VOD packaging asset.
        
        @param request: DeleteVodPackagingAssetRequest
        @return: DeleteVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vod_packaging_asset_with_options_async(request, runtime)

    def delete_vod_packaging_configuration_with_options(
        self,
        request: ice20201109_models.DeleteVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingConfigurationResponse:
        """
        @summary Deletes a packaging configuration.
        
        @param request: DeleteVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vod_packaging_configuration_with_options_async(
        self,
        request: ice20201109_models.DeleteVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingConfigurationResponse:
        """
        @summary Deletes a packaging configuration.
        
        @param request: DeleteVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vod_packaging_configuration(
        self,
        request: ice20201109_models.DeleteVodPackagingConfigurationRequest,
    ) -> ice20201109_models.DeleteVodPackagingConfigurationResponse:
        """
        @summary Deletes a packaging configuration.
        
        @param request: DeleteVodPackagingConfigurationRequest
        @return: DeleteVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vod_packaging_configuration_with_options(request, runtime)

    async def delete_vod_packaging_configuration_async(
        self,
        request: ice20201109_models.DeleteVodPackagingConfigurationRequest,
    ) -> ice20201109_models.DeleteVodPackagingConfigurationResponse:
        """
        @summary Deletes a packaging configuration.
        
        @param request: DeleteVodPackagingConfigurationRequest
        @return: DeleteVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vod_packaging_configuration_with_options_async(request, runtime)

    def delete_vod_packaging_group_with_options(
        self,
        request: ice20201109_models.DeleteVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingGroupResponse:
        """
        @summary Deletes a packaging group.
        
        @param request: DeleteVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vod_packaging_group_with_options_async(
        self,
        request: ice20201109_models.DeleteVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DeleteVodPackagingGroupResponse:
        """
        @summary Deletes a packaging group.
        
        @param request: DeleteVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DeleteVodPackagingGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vod_packaging_group(
        self,
        request: ice20201109_models.DeleteVodPackagingGroupRequest,
    ) -> ice20201109_models.DeleteVodPackagingGroupResponse:
        """
        @summary Deletes a packaging group.
        
        @param request: DeleteVodPackagingGroupRequest
        @return: DeleteVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vod_packaging_group_with_options(request, runtime)

    async def delete_vod_packaging_group_async(
        self,
        request: ice20201109_models.DeleteVodPackagingGroupRequest,
    ) -> ice20201109_models.DeleteVodPackagingGroupResponse:
        """
        @summary Deletes a packaging group.
        
        @param request: DeleteVodPackagingGroupRequest
        @return: DeleteVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vod_packaging_group_with_options_async(request, runtime)

    def describe_aiagent_instance_with_options(
        self,
        request: ice20201109_models.DescribeAIAgentInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeAIAgentInstanceResponse:
        """
        @summary Queries the information about an AI agent.
        
        @description ## [](#)Request description
        **Feature**: You can call this operation to query the information about an AI agent.
        **Scenario**: If you need to monitor or analyze the performance of an AI agent in a call or debug the agent configurations, you can call this operation to obtain required data.
        
        @param request: DescribeAIAgentInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIAgentInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIAgentInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeAIAgentInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aiagent_instance_with_options_async(
        self,
        request: ice20201109_models.DescribeAIAgentInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeAIAgentInstanceResponse:
        """
        @summary Queries the information about an AI agent.
        
        @description ## [](#)Request description
        **Feature**: You can call this operation to query the information about an AI agent.
        **Scenario**: If you need to monitor or analyze the performance of an AI agent in a call or debug the agent configurations, you can call this operation to obtain required data.
        
        @param request: DescribeAIAgentInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAIAgentInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAIAgentInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeAIAgentInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aiagent_instance(
        self,
        request: ice20201109_models.DescribeAIAgentInstanceRequest,
    ) -> ice20201109_models.DescribeAIAgentInstanceResponse:
        """
        @summary Queries the information about an AI agent.
        
        @description ## [](#)Request description
        **Feature**: You can call this operation to query the information about an AI agent.
        **Scenario**: If you need to monitor or analyze the performance of an AI agent in a call or debug the agent configurations, you can call this operation to obtain required data.
        
        @param request: DescribeAIAgentInstanceRequest
        @return: DescribeAIAgentInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aiagent_instance_with_options(request, runtime)

    async def describe_aiagent_instance_async(
        self,
        request: ice20201109_models.DescribeAIAgentInstanceRequest,
    ) -> ice20201109_models.DescribeAIAgentInstanceResponse:
        """
        @summary Queries the information about an AI agent.
        
        @description ## [](#)Request description
        **Feature**: You can call this operation to query the information about an AI agent.
        **Scenario**: If you need to monitor or analyze the performance of an AI agent in a call or debug the agent configurations, you can call this operation to obtain required data.
        
        @param request: DescribeAIAgentInstanceRequest
        @return: DescribeAIAgentInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aiagent_instance_with_options_async(request, runtime)

    def describe_meter_ims_edit_usage_with_options(
        self,
        request: ice20201109_models.DescribeMeterImsEditUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsEditUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) editing. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsEditUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsEditUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsEditUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsEditUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meter_ims_edit_usage_with_options_async(
        self,
        request: ice20201109_models.DescribeMeterImsEditUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsEditUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) editing. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsEditUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsEditUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsEditUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsEditUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meter_ims_edit_usage(
        self,
        request: ice20201109_models.DescribeMeterImsEditUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsEditUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) editing. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsEditUsageRequest
        @return: DescribeMeterImsEditUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meter_ims_edit_usage_with_options(request, runtime)

    async def describe_meter_ims_edit_usage_async(
        self,
        request: ice20201109_models.DescribeMeterImsEditUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsEditUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) editing. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsEditUsageRequest
        @return: DescribeMeterImsEditUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meter_ims_edit_usage_with_options_async(request, runtime)

    def describe_meter_ims_media_convert_uhdusage_with_options(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUHDUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on ultra high definition (UHD) transcoding of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUHDUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMediaConvertUHDUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMediaConvertUHDUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meter_ims_media_convert_uhdusage_with_options_async(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUHDUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on ultra high definition (UHD) transcoding of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUHDUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMediaConvertUHDUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMediaConvertUHDUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meter_ims_media_convert_uhdusage(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUHDUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on ultra high definition (UHD) transcoding of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUHDUsageRequest
        @return: DescribeMeterImsMediaConvertUHDUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meter_ims_media_convert_uhdusage_with_options(request, runtime)

    async def describe_meter_ims_media_convert_uhdusage_async(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUHDUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUHDUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on ultra high definition (UHD) transcoding of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUHDUsageRequest
        @return: DescribeMeterImsMediaConvertUHDUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meter_ims_media_convert_uhdusage_with_options_async(request, runtime)

    def describe_meter_ims_media_convert_usage_with_options(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) transcoding. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMediaConvertUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMediaConvertUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMediaConvertUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meter_ims_media_convert_usage_with_options_async(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) transcoding. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMediaConvertUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMediaConvertUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMediaConvertUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meter_ims_media_convert_usage(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) transcoding. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUsageRequest
        @return: DescribeMeterImsMediaConvertUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meter_ims_media_convert_usage_with_options(request, runtime)

    async def describe_meter_ims_media_convert_usage_async(
        self,
        request: ice20201109_models.DescribeMeterImsMediaConvertUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMediaConvertUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on video-on-demand (VOD) transcoding. The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMediaConvertUsageRequest
        @return: DescribeMeterImsMediaConvertUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meter_ims_media_convert_usage_with_options_async(request, runtime)

    def describe_meter_ims_mps_ai_usage_with_options(
        self,
        request: ice20201109_models.DescribeMeterImsMpsAiUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMpsAiUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on AI processing of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMpsAiUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMpsAiUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMpsAiUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMpsAiUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meter_ims_mps_ai_usage_with_options_async(
        self,
        request: ice20201109_models.DescribeMeterImsMpsAiUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsMpsAiUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on AI processing of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMpsAiUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsMpsAiUsageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsMpsAiUsage',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsMpsAiUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meter_ims_mps_ai_usage(
        self,
        request: ice20201109_models.DescribeMeterImsMpsAiUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMpsAiUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on AI processing of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMpsAiUsageRequest
        @return: DescribeMeterImsMpsAiUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meter_ims_mps_ai_usage_with_options(request, runtime)

    async def describe_meter_ims_mps_ai_usage_async(
        self,
        request: ice20201109_models.DescribeMeterImsMpsAiUsageRequest,
    ) -> ice20201109_models.DescribeMeterImsMpsAiUsageResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS) on AI processing of ApsaraVideo Media Processing (MPS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsMpsAiUsageRequest
        @return: DescribeMeterImsMpsAiUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meter_ims_mps_ai_usage_with_options_async(request, runtime)

    def describe_meter_ims_summary_with_options(
        self,
        request: ice20201109_models.DescribeMeterImsSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsSummaryResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsSummary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_meter_ims_summary_with_options_async(
        self,
        request: ice20201109_models.DescribeMeterImsSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeMeterImsSummaryResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeterImsSummaryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeterImsSummary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeMeterImsSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_meter_ims_summary(
        self,
        request: ice20201109_models.DescribeMeterImsSummaryRequest,
    ) -> ice20201109_models.DescribeMeterImsSummaryResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsSummaryRequest
        @return: DescribeMeterImsSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_meter_ims_summary_with_options(request, runtime)

    async def describe_meter_ims_summary_async(
        self,
        request: ice20201109_models.DescribeMeterImsSummaryRequest,
    ) -> ice20201109_models.DescribeMeterImsSummaryResponse:
        """
        @summary Queries the usage statistics of Intelligent Media Services (IMS). The maximum query range is 31 days. You can query data within the last 90 days.
        
        @param request: DescribeMeterImsSummaryRequest
        @return: DescribeMeterImsSummaryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_meter_ims_summary_with_options_async(request, runtime)

    def describe_notify_config_with_options(
        self,
        request: ice20201109_models.DescribeNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeNotifyConfigResponse:
        """
        @summary Queries the event callback configurations of an AI agent.
        
        @description You can call this operation to query the detailed callback configurations of an AI agent.
        
        @param request: DescribeNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNotifyConfig',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeNotifyConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_notify_config_with_options_async(
        self,
        request: ice20201109_models.DescribeNotifyConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeNotifyConfigResponse:
        """
        @summary Queries the event callback configurations of an AI agent.
        
        @description You can call this operation to query the detailed callback configurations of an AI agent.
        
        @param request: DescribeNotifyConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNotifyConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNotifyConfig',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeNotifyConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_notify_config(
        self,
        request: ice20201109_models.DescribeNotifyConfigRequest,
    ) -> ice20201109_models.DescribeNotifyConfigResponse:
        """
        @summary Queries the event callback configurations of an AI agent.
        
        @description You can call this operation to query the detailed callback configurations of an AI agent.
        
        @param request: DescribeNotifyConfigRequest
        @return: DescribeNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_notify_config_with_options(request, runtime)

    async def describe_notify_config_async(
        self,
        request: ice20201109_models.DescribeNotifyConfigRequest,
    ) -> ice20201109_models.DescribeNotifyConfigResponse:
        """
        @summary Queries the event callback configurations of an AI agent.
        
        @description You can call this operation to query the detailed callback configurations of an AI agent.
        
        @param request: DescribeNotifyConfigRequest
        @return: DescribeNotifyConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_notify_config_with_options_async(request, runtime)

    def describe_play_list_with_options(
        self,
        request: ice20201109_models.DescribePlayListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribePlayListResponse:
        """
        @param request: DescribePlayListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePlayListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.begin_ts):
            query['BeginTs'] = request.begin_ts
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.order_name):
            query['OrderName'] = request.order_name
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.play_type):
            query['PlayType'] = request.play_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.trace_id):
            query['TraceId'] = request.trace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePlayList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribePlayListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_play_list_with_options_async(
        self,
        request: ice20201109_models.DescribePlayListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribePlayListResponse:
        """
        @param request: DescribePlayListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePlayListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.begin_ts):
            query['BeginTs'] = request.begin_ts
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.order_name):
            query['OrderName'] = request.order_name
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.play_type):
            query['PlayType'] = request.play_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.trace_id):
            query['TraceId'] = request.trace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePlayList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribePlayListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_play_list(
        self,
        request: ice20201109_models.DescribePlayListRequest,
    ) -> ice20201109_models.DescribePlayListResponse:
        """
        @param request: DescribePlayListRequest
        @return: DescribePlayListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_play_list_with_options(request, runtime)

    async def describe_play_list_async(
        self,
        request: ice20201109_models.DescribePlayListRequest,
    ) -> ice20201109_models.DescribePlayListResponse:
        """
        @param request: DescribePlayListRequest
        @return: DescribePlayListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_play_list_with_options_async(request, runtime)

    def describe_rtc_robot_instance_with_options(
        self,
        request: ice20201109_models.DescribeRtcRobotInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeRtcRobotInstanceResponse:
        """
        @summary 查询实例
        
        @param request: DescribeRtcRobotInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRtcRobotInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRtcRobotInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeRtcRobotInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_rtc_robot_instance_with_options_async(
        self,
        request: ice20201109_models.DescribeRtcRobotInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DescribeRtcRobotInstanceResponse:
        """
        @summary 查询实例
        
        @param request: DescribeRtcRobotInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRtcRobotInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRtcRobotInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DescribeRtcRobotInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_rtc_robot_instance(
        self,
        request: ice20201109_models.DescribeRtcRobotInstanceRequest,
    ) -> ice20201109_models.DescribeRtcRobotInstanceResponse:
        """
        @summary 查询实例
        
        @param request: DescribeRtcRobotInstanceRequest
        @return: DescribeRtcRobotInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_rtc_robot_instance_with_options(request, runtime)

    async def describe_rtc_robot_instance_async(
        self,
        request: ice20201109_models.DescribeRtcRobotInstanceRequest,
    ) -> ice20201109_models.DescribeRtcRobotInstanceResponse:
        """
        @summary 查询实例
        
        @param request: DescribeRtcRobotInstanceRequest
        @return: DescribeRtcRobotInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_rtc_robot_instance_with_options_async(request, runtime)

    def detect_audio_for_customized_voice_job_with_options(
        self,
        request: ice20201109_models.DetectAudioForCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DetectAudioForCustomizedVoiceJobResponse:
        """
        @summary Checks whether the reading of users has issues, such as noticeable pronunciation errors or background noise. After the audio is checked on the cloud, the qualified audio is temporarily stored on the cloud for subsequent training. Do not skip this step.
        
        @param request: DetectAudioForCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetectAudioForCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audio_record_id):
            query['AudioRecordId'] = request.audio_record_id
        if not UtilClient.is_unset(request.record_url):
            query['RecordUrl'] = request.record_url
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetectAudioForCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DetectAudioForCustomizedVoiceJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def detect_audio_for_customized_voice_job_with_options_async(
        self,
        request: ice20201109_models.DetectAudioForCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DetectAudioForCustomizedVoiceJobResponse:
        """
        @summary Checks whether the reading of users has issues, such as noticeable pronunciation errors or background noise. After the audio is checked on the cloud, the qualified audio is temporarily stored on the cloud for subsequent training. Do not skip this step.
        
        @param request: DetectAudioForCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetectAudioForCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.audio_record_id):
            query['AudioRecordId'] = request.audio_record_id
        if not UtilClient.is_unset(request.record_url):
            query['RecordUrl'] = request.record_url
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetectAudioForCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DetectAudioForCustomizedVoiceJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detect_audio_for_customized_voice_job(
        self,
        request: ice20201109_models.DetectAudioForCustomizedVoiceJobRequest,
    ) -> ice20201109_models.DetectAudioForCustomizedVoiceJobResponse:
        """
        @summary Checks whether the reading of users has issues, such as noticeable pronunciation errors or background noise. After the audio is checked on the cloud, the qualified audio is temporarily stored on the cloud for subsequent training. Do not skip this step.
        
        @param request: DetectAudioForCustomizedVoiceJobRequest
        @return: DetectAudioForCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detect_audio_for_customized_voice_job_with_options(request, runtime)

    async def detect_audio_for_customized_voice_job_async(
        self,
        request: ice20201109_models.DetectAudioForCustomizedVoiceJobRequest,
    ) -> ice20201109_models.DetectAudioForCustomizedVoiceJobResponse:
        """
        @summary Checks whether the reading of users has issues, such as noticeable pronunciation errors or background noise. After the audio is checked on the cloud, the qualified audio is temporarily stored on the cloud for subsequent training. Do not skip this step.
        
        @param request: DetectAudioForCustomizedVoiceJobRequest
        @return: DetectAudioForCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detect_audio_for_customized_voice_job_with_options_async(request, runtime)

    def drop_search_index_with_options(
        self,
        request: ice20201109_models.DropSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DropSearchIndexResponse:
        """
        @summary Deletes a search index. After you delete a search index, the existing index data is cleared and index-based analysis, storage, and query are not supported for subsequent media assets.
        
        @param request: DropSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DropSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DropSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DropSearchIndexResponse(),
            self.call_api(params, req, runtime)
        )

    async def drop_search_index_with_options_async(
        self,
        request: ice20201109_models.DropSearchIndexRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DropSearchIndexResponse:
        """
        @summary Deletes a search index. After you delete a search index, the existing index data is cleared and index-based analysis, storage, and query are not supported for subsequent media assets.
        
        @param request: DropSearchIndexRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DropSearchIndexResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.index_type):
            query['IndexType'] = request.index_type
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DropSearchIndex',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DropSearchIndexResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def drop_search_index(
        self,
        request: ice20201109_models.DropSearchIndexRequest,
    ) -> ice20201109_models.DropSearchIndexResponse:
        """
        @summary Deletes a search index. After you delete a search index, the existing index data is cleared and index-based analysis, storage, and query are not supported for subsequent media assets.
        
        @param request: DropSearchIndexRequest
        @return: DropSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.drop_search_index_with_options(request, runtime)

    async def drop_search_index_async(
        self,
        request: ice20201109_models.DropSearchIndexRequest,
    ) -> ice20201109_models.DropSearchIndexResponse:
        """
        @summary Deletes a search index. After you delete a search index, the existing index data is cleared and index-based analysis, storage, and query are not supported for subsequent media assets.
        
        @param request: DropSearchIndexRequest
        @return: DropSearchIndexResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.drop_search_index_with_options_async(request, runtime)

    def drop_search_lib_with_options(
        self,
        request: ice20201109_models.DropSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DropSearchLibResponse:
        """
        @summary Deletes a search library and all media assets in the library.
        
        @param request: DropSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DropSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DropSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DropSearchLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def drop_search_lib_with_options_async(
        self,
        request: ice20201109_models.DropSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.DropSearchLibResponse:
        """
        @summary Deletes a search library and all media assets in the library.
        
        @param request: DropSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DropSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DropSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.DropSearchLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def drop_search_lib(
        self,
        request: ice20201109_models.DropSearchLibRequest,
    ) -> ice20201109_models.DropSearchLibResponse:
        """
        @summary Deletes a search library and all media assets in the library.
        
        @param request: DropSearchLibRequest
        @return: DropSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.drop_search_lib_with_options(request, runtime)

    async def drop_search_lib_async(
        self,
        request: ice20201109_models.DropSearchLibRequest,
    ) -> ice20201109_models.DropSearchLibResponse:
        """
        @summary Deletes a search library and all media assets in the library.
        
        @param request: DropSearchLibRequest
        @return: DropSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.drop_search_lib_with_options_async(request, runtime)

    def forbid_media_connect_flow_output_with_options(
        self,
        request: ice20201109_models.ForbidMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ForbidMediaConnectFlowOutputResponse:
        """
        @summary 禁用某个MediaConnect实例的某个输出
        
        @param request: ForbidMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ForbidMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ForbidMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ForbidMediaConnectFlowOutputResponse(),
            self.call_api(params, req, runtime)
        )

    async def forbid_media_connect_flow_output_with_options_async(
        self,
        request: ice20201109_models.ForbidMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ForbidMediaConnectFlowOutputResponse:
        """
        @summary 禁用某个MediaConnect实例的某个输出
        
        @param request: ForbidMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ForbidMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ForbidMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ForbidMediaConnectFlowOutputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def forbid_media_connect_flow_output(
        self,
        request: ice20201109_models.ForbidMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.ForbidMediaConnectFlowOutputResponse:
        """
        @summary 禁用某个MediaConnect实例的某个输出
        
        @param request: ForbidMediaConnectFlowOutputRequest
        @return: ForbidMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.forbid_media_connect_flow_output_with_options(request, runtime)

    async def forbid_media_connect_flow_output_async(
        self,
        request: ice20201109_models.ForbidMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.ForbidMediaConnectFlowOutputResponse:
        """
        @summary 禁用某个MediaConnect实例的某个输出
        
        @param request: ForbidMediaConnectFlowOutputRequest
        @return: ForbidMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.forbid_media_connect_flow_output_with_options_async(request, runtime)

    def forward_aiagent_call_with_options(
        self,
        request: ice20201109_models.ForwardAIAgentCallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ForwardAIAgentCallResponse:
        """
        @summary 转呼通话到目标电话
        
        @param request: ForwardAIAgentCallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ForwardAIAgentCallResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.called_number):
            query['CalledNumber'] = request.called_number
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ForwardAIAgentCall',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ForwardAIAgentCallResponse(),
            self.call_api(params, req, runtime)
        )

    async def forward_aiagent_call_with_options_async(
        self,
        request: ice20201109_models.ForwardAIAgentCallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ForwardAIAgentCallResponse:
        """
        @summary 转呼通话到目标电话
        
        @param request: ForwardAIAgentCallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ForwardAIAgentCallResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.called_number):
            query['CalledNumber'] = request.called_number
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ForwardAIAgentCall',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ForwardAIAgentCallResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def forward_aiagent_call(
        self,
        request: ice20201109_models.ForwardAIAgentCallRequest,
    ) -> ice20201109_models.ForwardAIAgentCallResponse:
        """
        @summary 转呼通话到目标电话
        
        @param request: ForwardAIAgentCallRequest
        @return: ForwardAIAgentCallResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.forward_aiagent_call_with_options(request, runtime)

    async def forward_aiagent_call_async(
        self,
        request: ice20201109_models.ForwardAIAgentCallRequest,
    ) -> ice20201109_models.ForwardAIAgentCallResponse:
        """
        @summary 转呼通话到目标电话
        
        @param request: ForwardAIAgentCallRequest
        @return: ForwardAIAgentCallResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.forward_aiagent_call_with_options_async(request, runtime)

    def generate_aiagent_call_with_options(
        self,
        tmp_req: ice20201109_models.GenerateAIAgentCallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateAIAgentCallResponse:
        """
        @summary Creates an AI agent. This operation returns the channel in which the AI agent resides, the username of the AI agent in the channel, and the token that you can use to join the channel.
        
        @description ## [](#)Request description
        You can call this operation to create an AI agent based on the provided ID. You can join the channel based on the returned information and talk to the agent.
        *Note:** Make sure that the provided AI agent ID is valid and configure optional parameters based on your business requirements.
        
        @param tmp_req: GenerateAIAgentCallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateAIAgentCallResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.GenerateAIAgentCallShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.agent_config):
            request.agent_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.agent_config, 'AgentConfig', 'json')
        if not UtilClient.is_unset(tmp_req.chat_sync_config):
            request.chat_sync_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.chat_sync_config, 'ChatSyncConfig', 'json')
        if not UtilClient.is_unset(tmp_req.template_config):
            request.template_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.template_config, 'TemplateConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.agent_config_shrink):
            query['AgentConfig'] = request.agent_config_shrink
        if not UtilClient.is_unset(request.chat_sync_config_shrink):
            query['ChatSyncConfig'] = request.chat_sync_config_shrink
        if not UtilClient.is_unset(request.expire):
            query['Expire'] = request.expire
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.template_config_shrink):
            query['TemplateConfig'] = request.template_config_shrink
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GenerateAIAgentCall',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateAIAgentCallResponse(),
            self.call_api(params, req, runtime)
        )

    async def generate_aiagent_call_with_options_async(
        self,
        tmp_req: ice20201109_models.GenerateAIAgentCallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateAIAgentCallResponse:
        """
        @summary Creates an AI agent. This operation returns the channel in which the AI agent resides, the username of the AI agent in the channel, and the token that you can use to join the channel.
        
        @description ## [](#)Request description
        You can call this operation to create an AI agent based on the provided ID. You can join the channel based on the returned information and talk to the agent.
        *Note:** Make sure that the provided AI agent ID is valid and configure optional parameters based on your business requirements.
        
        @param tmp_req: GenerateAIAgentCallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateAIAgentCallResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ice20201109_models.GenerateAIAgentCallShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.agent_config):
            request.agent_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.agent_config, 'AgentConfig', 'json')
        if not UtilClient.is_unset(tmp_req.chat_sync_config):
            request.chat_sync_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.chat_sync_config, 'ChatSyncConfig', 'json')
        if not UtilClient.is_unset(tmp_req.template_config):
            request.template_config_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.template_config, 'TemplateConfig', 'json')
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.agent_config_shrink):
            query['AgentConfig'] = request.agent_config_shrink
        if not UtilClient.is_unset(request.chat_sync_config_shrink):
            query['ChatSyncConfig'] = request.chat_sync_config_shrink
        if not UtilClient.is_unset(request.expire):
            query['Expire'] = request.expire
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.template_config_shrink):
            query['TemplateConfig'] = request.template_config_shrink
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GenerateAIAgentCall',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateAIAgentCallResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def generate_aiagent_call(
        self,
        request: ice20201109_models.GenerateAIAgentCallRequest,
    ) -> ice20201109_models.GenerateAIAgentCallResponse:
        """
        @summary Creates an AI agent. This operation returns the channel in which the AI agent resides, the username of the AI agent in the channel, and the token that you can use to join the channel.
        
        @description ## [](#)Request description
        You can call this operation to create an AI agent based on the provided ID. You can join the channel based on the returned information and talk to the agent.
        *Note:** Make sure that the provided AI agent ID is valid and configure optional parameters based on your business requirements.
        
        @param request: GenerateAIAgentCallRequest
        @return: GenerateAIAgentCallResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.generate_aiagent_call_with_options(request, runtime)

    async def generate_aiagent_call_async(
        self,
        request: ice20201109_models.GenerateAIAgentCallRequest,
    ) -> ice20201109_models.GenerateAIAgentCallResponse:
        """
        @summary Creates an AI agent. This operation returns the channel in which the AI agent resides, the username of the AI agent in the channel, and the token that you can use to join the channel.
        
        @description ## [](#)Request description
        You can call this operation to create an AI agent based on the provided ID. You can join the channel based on the returned information and talk to the agent.
        *Note:** Make sure that the provided AI agent ID is valid and configure optional parameters based on your business requirements.
        
        @param request: GenerateAIAgentCallRequest
        @return: GenerateAIAgentCallResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.generate_aiagent_call_with_options_async(request, runtime)

    def generate_kmsdata_key_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateKMSDataKeyResponse:
        """
        @summary Generates a random Key Management Service (KMS) data key used for HTTP Live Streaming (HLS) encryption and transcoding of videos.
        
        @param request: GenerateKMSDataKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateKMSDataKeyResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GenerateKMSDataKey',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateKMSDataKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def generate_kmsdata_key_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateKMSDataKeyResponse:
        """
        @summary Generates a random Key Management Service (KMS) data key used for HTTP Live Streaming (HLS) encryption and transcoding of videos.
        
        @param request: GenerateKMSDataKeyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateKMSDataKeyResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GenerateKMSDataKey',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateKMSDataKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def generate_kmsdata_key(self) -> ice20201109_models.GenerateKMSDataKeyResponse:
        """
        @summary Generates a random Key Management Service (KMS) data key used for HTTP Live Streaming (HLS) encryption and transcoding of videos.
        
        @return: GenerateKMSDataKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.generate_kmsdata_key_with_options(runtime)

    async def generate_kmsdata_key_async(self) -> ice20201109_models.GenerateKMSDataKeyResponse:
        """
        @summary Generates a random Key Management Service (KMS) data key used for HTTP Live Streaming (HLS) encryption and transcoding of videos.
        
        @return: GenerateKMSDataKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.generate_kmsdata_key_with_options_async(runtime)

    def generate_message_chat_token_with_options(
        self,
        request: ice20201109_models.GenerateMessageChatTokenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateMessageChatTokenResponse:
        """
        @summary 生成直播互动消息所需的token
        
        @param request: GenerateMessageChatTokenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateMessageChatTokenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.expire):
            query['Expire'] = request.expire
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GenerateMessageChatToken',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateMessageChatTokenResponse(),
            self.call_api(params, req, runtime)
        )

    async def generate_message_chat_token_with_options_async(
        self,
        request: ice20201109_models.GenerateMessageChatTokenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GenerateMessageChatTokenResponse:
        """
        @summary 生成直播互动消息所需的token
        
        @param request: GenerateMessageChatTokenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GenerateMessageChatTokenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.expire):
            query['Expire'] = request.expire
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.user_id):
            query['UserId'] = request.user_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GenerateMessageChatToken',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GenerateMessageChatTokenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def generate_message_chat_token(
        self,
        request: ice20201109_models.GenerateMessageChatTokenRequest,
    ) -> ice20201109_models.GenerateMessageChatTokenResponse:
        """
        @summary 生成直播互动消息所需的token
        
        @param request: GenerateMessageChatTokenRequest
        @return: GenerateMessageChatTokenResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.generate_message_chat_token_with_options(request, runtime)

    async def generate_message_chat_token_async(
        self,
        request: ice20201109_models.GenerateMessageChatTokenRequest,
    ) -> ice20201109_models.GenerateMessageChatTokenResponse:
        """
        @summary 生成直播互动消息所需的token
        
        @param request: GenerateMessageChatTokenRequest
        @return: GenerateMessageChatTokenResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.generate_message_chat_token_with_options_async(request, runtime)

    def get_ad_insertion_with_options(
        self,
        request: ice20201109_models.GetAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAdInsertionResponse:
        """
        @summary Obtains details of an ad insertion configuration.
        
        @param request: GetAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAdInsertionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAdInsertionResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_ad_insertion_with_options_async(
        self,
        request: ice20201109_models.GetAdInsertionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAdInsertionResponse:
        """
        @summary Obtains details of an ad insertion configuration.
        
        @param request: GetAdInsertionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAdInsertionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAdInsertion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAdInsertionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_ad_insertion(
        self,
        request: ice20201109_models.GetAdInsertionRequest,
    ) -> ice20201109_models.GetAdInsertionResponse:
        """
        @summary Obtains details of an ad insertion configuration.
        
        @param request: GetAdInsertionRequest
        @return: GetAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_ad_insertion_with_options(request, runtime)

    async def get_ad_insertion_async(
        self,
        request: ice20201109_models.GetAdInsertionRequest,
    ) -> ice20201109_models.GetAdInsertionResponse:
        """
        @summary Obtains details of an ad insertion configuration.
        
        @param request: GetAdInsertionRequest
        @return: GetAdInsertionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_ad_insertion_with_options_async(request, runtime)

    def get_avatar_with_options(
        self,
        request: ice20201109_models.GetAvatarRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAvatarResponse:
        """
        @summary Queries the information about a trained digital human.
        
        @param request: GetAvatarRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAvatarResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_id):
            query['AvatarId'] = request.avatar_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAvatar',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAvatarResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_avatar_with_options_async(
        self,
        request: ice20201109_models.GetAvatarRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAvatarResponse:
        """
        @summary Queries the information about a trained digital human.
        
        @param request: GetAvatarRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAvatarResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_id):
            query['AvatarId'] = request.avatar_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAvatar',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAvatarResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_avatar(
        self,
        request: ice20201109_models.GetAvatarRequest,
    ) -> ice20201109_models.GetAvatarResponse:
        """
        @summary Queries the information about a trained digital human.
        
        @param request: GetAvatarRequest
        @return: GetAvatarResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_avatar_with_options(request, runtime)

    async def get_avatar_async(
        self,
        request: ice20201109_models.GetAvatarRequest,
    ) -> ice20201109_models.GetAvatarResponse:
        """
        @summary Queries the information about a trained digital human.
        
        @param request: GetAvatarRequest
        @return: GetAvatarResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_avatar_with_options_async(request, runtime)

    def get_avatar_training_job_with_options(
        self,
        request: ice20201109_models.GetAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAvatarTrainingJobResponse:
        """
        @summary Queries the information about a digital human training job.
        
        @param request: GetAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAvatarTrainingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_avatar_training_job_with_options_async(
        self,
        request: ice20201109_models.GetAvatarTrainingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetAvatarTrainingJobResponse:
        """
        @summary Queries the information about a digital human training job.
        
        @param request: GetAvatarTrainingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAvatarTrainingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAvatarTrainingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetAvatarTrainingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_avatar_training_job(
        self,
        request: ice20201109_models.GetAvatarTrainingJobRequest,
    ) -> ice20201109_models.GetAvatarTrainingJobResponse:
        """
        @summary Queries the information about a digital human training job.
        
        @param request: GetAvatarTrainingJobRequest
        @return: GetAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_avatar_training_job_with_options(request, runtime)

    async def get_avatar_training_job_async(
        self,
        request: ice20201109_models.GetAvatarTrainingJobRequest,
    ) -> ice20201109_models.GetAvatarTrainingJobResponse:
        """
        @summary Queries the information about a digital human training job.
        
        @param request: GetAvatarTrainingJobRequest
        @return: GetAvatarTrainingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_avatar_training_job_with_options_async(request, runtime)

    def get_batch_media_producing_job_with_options(
        self,
        request: ice20201109_models.GetBatchMediaProducingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetBatchMediaProducingJobResponse:
        """
        @summary Queries the information about a quick video production job, including the input parameters, job state, and the IDs and URLs of the output media assets. You can call this operation to query only quick video production jobs created within the past year.
        
        @param request: GetBatchMediaProducingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBatchMediaProducingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBatchMediaProducingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetBatchMediaProducingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_batch_media_producing_job_with_options_async(
        self,
        request: ice20201109_models.GetBatchMediaProducingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetBatchMediaProducingJobResponse:
        """
        @summary Queries the information about a quick video production job, including the input parameters, job state, and the IDs and URLs of the output media assets. You can call this operation to query only quick video production jobs created within the past year.
        
        @param request: GetBatchMediaProducingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBatchMediaProducingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBatchMediaProducingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetBatchMediaProducingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_batch_media_producing_job(
        self,
        request: ice20201109_models.GetBatchMediaProducingJobRequest,
    ) -> ice20201109_models.GetBatchMediaProducingJobResponse:
        """
        @summary Queries the information about a quick video production job, including the input parameters, job state, and the IDs and URLs of the output media assets. You can call this operation to query only quick video production jobs created within the past year.
        
        @param request: GetBatchMediaProducingJobRequest
        @return: GetBatchMediaProducingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_batch_media_producing_job_with_options(request, runtime)

    async def get_batch_media_producing_job_async(
        self,
        request: ice20201109_models.GetBatchMediaProducingJobRequest,
    ) -> ice20201109_models.GetBatchMediaProducingJobResponse:
        """
        @summary Queries the information about a quick video production job, including the input parameters, job state, and the IDs and URLs of the output media assets. You can call this operation to query only quick video production jobs created within the past year.
        
        @param request: GetBatchMediaProducingJobRequest
        @return: GetBatchMediaProducingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_batch_media_producing_job_with_options_async(request, runtime)

    def get_categories_with_options(
        self,
        request: ice20201109_models.GetCategoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCategoriesResponse:
        """
        @summary Queries the information about a category and its subcategories.
        
        @description You can call this operation to query the information about a category and its subcategories based on the category ID and category type.
        
        @param request: GetCategoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCategoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCategories',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCategoriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_categories_with_options_async(
        self,
        request: ice20201109_models.GetCategoriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCategoriesResponse:
        """
        @summary Queries the information about a category and its subcategories.
        
        @description You can call this operation to query the information about a category and its subcategories based on the category ID and category type.
        
        @param request: GetCategoriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCategoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCategories',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCategoriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_categories(
        self,
        request: ice20201109_models.GetCategoriesRequest,
    ) -> ice20201109_models.GetCategoriesResponse:
        """
        @summary Queries the information about a category and its subcategories.
        
        @description You can call this operation to query the information about a category and its subcategories based on the category ID and category type.
        
        @param request: GetCategoriesRequest
        @return: GetCategoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_categories_with_options(request, runtime)

    async def get_categories_async(
        self,
        request: ice20201109_models.GetCategoriesRequest,
    ) -> ice20201109_models.GetCategoriesResponse:
        """
        @summary Queries the information about a category and its subcategories.
        
        @description You can call this operation to query the information about a category and its subcategories based on the category ID and category type.
        
        @param request: GetCategoriesRequest
        @return: GetCategoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_categories_with_options_async(request, runtime)

    def get_channel_with_options(
        self,
        request: ice20201109_models.GetChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetChannelResponse:
        """
        @summary Queries information about a channel in MediaWeaver.
        
        @param request: GetChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_channel_with_options_async(
        self,
        request: ice20201109_models.GetChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetChannelResponse:
        """
        @summary Queries information about a channel in MediaWeaver.
        
        @param request: GetChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_channel(
        self,
        request: ice20201109_models.GetChannelRequest,
    ) -> ice20201109_models.GetChannelResponse:
        """
        @summary Queries information about a channel in MediaWeaver.
        
        @param request: GetChannelRequest
        @return: GetChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_channel_with_options(request, runtime)

    async def get_channel_async(
        self,
        request: ice20201109_models.GetChannelRequest,
    ) -> ice20201109_models.GetChannelResponse:
        """
        @summary Queries information about a channel in MediaWeaver.
        
        @param request: GetChannelRequest
        @return: GetChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_channel_with_options_async(request, runtime)

    def get_content_analyze_config_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetContentAnalyzeConfigResponse:
        """
        @summary 获取内容分析搜索配置
        
        @param request: GetContentAnalyzeConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetContentAnalyzeConfigResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetContentAnalyzeConfig',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetContentAnalyzeConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_content_analyze_config_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetContentAnalyzeConfigResponse:
        """
        @summary 获取内容分析搜索配置
        
        @param request: GetContentAnalyzeConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetContentAnalyzeConfigResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetContentAnalyzeConfig',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetContentAnalyzeConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_content_analyze_config(self) -> ice20201109_models.GetContentAnalyzeConfigResponse:
        """
        @summary 获取内容分析搜索配置
        
        @return: GetContentAnalyzeConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_content_analyze_config_with_options(runtime)

    async def get_content_analyze_config_async(self) -> ice20201109_models.GetContentAnalyzeConfigResponse:
        """
        @summary 获取内容分析搜索配置
        
        @return: GetContentAnalyzeConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_content_analyze_config_with_options_async(runtime)

    def get_custom_template_with_options(
        self,
        request: ice20201109_models.GetCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomTemplateResponse:
        """
        @summary Queries the information about a custom template.
        
        @description You can call this operation to query the information about a template with the ID specified by the TemplateId parameter. You can also query the information about the default template. If TemplateId is specified, other parameters are ignored and the template whose ID is specified is queried. If TemplateId is not specified, the default template is queried based on other parameters. In this case, Type is required.
        Template types:
        1.  1: transcoding template.
        2.  2: snapshot template.
        3.  3: animated image template.
        4.  4\\. image watermark template.
        5.  5: text watermark template.
        6.  6: subtitle template.
        7.  7: AI-assisted content moderation template.
        8.  8: AI-assisted intelligent thumbnail template.
        9.  9: AI-assisted intelligent erasure template.
        Subtypes of transcoding templates:
        1.  1 (Normal): regular template.
        2.  2 (AudioTranscode): audio transcoding template.
        3.  3 (Remux): container format conversion template.
        4.  4 (NarrowBandV1): Narrowband HD 1.0 template.
        5.  5 (NarrowBandV2): Narrowband HD 2.0 template.
        Subtypes of snapshot templates:
        1.  1 (Normal): regular template.
        2.  2 (Sprite): sprite template.
        3.  3 (WebVtt): WebVTT template.
        Subtypes of AI-assisted content moderation templates:
        1.  1 (Video): video moderation template.
        2.  2 (Audio): audio moderation template.
        3.  3 (Image): image moderation template.
        Subtypes of AI-assisted intelligent erasure templates:
        1.  1 (VideoDelogo): logo erasure template.
        2.  2 (VideoDetext): subtitle erasure template.
        
        @param request: GetCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_custom_template_with_options_async(
        self,
        request: ice20201109_models.GetCustomTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomTemplateResponse:
        """
        @summary Queries the information about a custom template.
        
        @description You can call this operation to query the information about a template with the ID specified by the TemplateId parameter. You can also query the information about the default template. If TemplateId is specified, other parameters are ignored and the template whose ID is specified is queried. If TemplateId is not specified, the default template is queried based on other parameters. In this case, Type is required.
        Template types:
        1.  1: transcoding template.
        2.  2: snapshot template.
        3.  3: animated image template.
        4.  4\\. image watermark template.
        5.  5: text watermark template.
        6.  6: subtitle template.
        7.  7: AI-assisted content moderation template.
        8.  8: AI-assisted intelligent thumbnail template.
        9.  9: AI-assisted intelligent erasure template.
        Subtypes of transcoding templates:
        1.  1 (Normal): regular template.
        2.  2 (AudioTranscode): audio transcoding template.
        3.  3 (Remux): container format conversion template.
        4.  4 (NarrowBandV1): Narrowband HD 1.0 template.
        5.  5 (NarrowBandV2): Narrowband HD 2.0 template.
        Subtypes of snapshot templates:
        1.  1 (Normal): regular template.
        2.  2 (Sprite): sprite template.
        3.  3 (WebVtt): WebVTT template.
        Subtypes of AI-assisted content moderation templates:
        1.  1 (Video): video moderation template.
        2.  2 (Audio): audio moderation template.
        3.  3 (Image): image moderation template.
        Subtypes of AI-assisted intelligent erasure templates:
        1.  1 (VideoDelogo): logo erasure template.
        2.  2 (VideoDetext): subtitle erasure template.
        
        @param request: GetCustomTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_custom_template(
        self,
        request: ice20201109_models.GetCustomTemplateRequest,
    ) -> ice20201109_models.GetCustomTemplateResponse:
        """
        @summary Queries the information about a custom template.
        
        @description You can call this operation to query the information about a template with the ID specified by the TemplateId parameter. You can also query the information about the default template. If TemplateId is specified, other parameters are ignored and the template whose ID is specified is queried. If TemplateId is not specified, the default template is queried based on other parameters. In this case, Type is required.
        Template types:
        1.  1: transcoding template.
        2.  2: snapshot template.
        3.  3: animated image template.
        4.  4\\. image watermark template.
        5.  5: text watermark template.
        6.  6: subtitle template.
        7.  7: AI-assisted content moderation template.
        8.  8: AI-assisted intelligent thumbnail template.
        9.  9: AI-assisted intelligent erasure template.
        Subtypes of transcoding templates:
        1.  1 (Normal): regular template.
        2.  2 (AudioTranscode): audio transcoding template.
        3.  3 (Remux): container format conversion template.
        4.  4 (NarrowBandV1): Narrowband HD 1.0 template.
        5.  5 (NarrowBandV2): Narrowband HD 2.0 template.
        Subtypes of snapshot templates:
        1.  1 (Normal): regular template.
        2.  2 (Sprite): sprite template.
        3.  3 (WebVtt): WebVTT template.
        Subtypes of AI-assisted content moderation templates:
        1.  1 (Video): video moderation template.
        2.  2 (Audio): audio moderation template.
        3.  3 (Image): image moderation template.
        Subtypes of AI-assisted intelligent erasure templates:
        1.  1 (VideoDelogo): logo erasure template.
        2.  2 (VideoDetext): subtitle erasure template.
        
        @param request: GetCustomTemplateRequest
        @return: GetCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_custom_template_with_options(request, runtime)

    async def get_custom_template_async(
        self,
        request: ice20201109_models.GetCustomTemplateRequest,
    ) -> ice20201109_models.GetCustomTemplateResponse:
        """
        @summary Queries the information about a custom template.
        
        @description You can call this operation to query the information about a template with the ID specified by the TemplateId parameter. You can also query the information about the default template. If TemplateId is specified, other parameters are ignored and the template whose ID is specified is queried. If TemplateId is not specified, the default template is queried based on other parameters. In this case, Type is required.
        Template types:
        1.  1: transcoding template.
        2.  2: snapshot template.
        3.  3: animated image template.
        4.  4\\. image watermark template.
        5.  5: text watermark template.
        6.  6: subtitle template.
        7.  7: AI-assisted content moderation template.
        8.  8: AI-assisted intelligent thumbnail template.
        9.  9: AI-assisted intelligent erasure template.
        Subtypes of transcoding templates:
        1.  1 (Normal): regular template.
        2.  2 (AudioTranscode): audio transcoding template.
        3.  3 (Remux): container format conversion template.
        4.  4 (NarrowBandV1): Narrowband HD 1.0 template.
        5.  5 (NarrowBandV2): Narrowband HD 2.0 template.
        Subtypes of snapshot templates:
        1.  1 (Normal): regular template.
        2.  2 (Sprite): sprite template.
        3.  3 (WebVtt): WebVTT template.
        Subtypes of AI-assisted content moderation templates:
        1.  1 (Video): video moderation template.
        2.  2 (Audio): audio moderation template.
        3.  3 (Image): image moderation template.
        Subtypes of AI-assisted intelligent erasure templates:
        1.  1 (VideoDelogo): logo erasure template.
        2.  2 (VideoDetext): subtitle erasure template.
        
        @param request: GetCustomTemplateRequest
        @return: GetCustomTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_custom_template_with_options_async(request, runtime)

    def get_customized_voice_with_options(
        self,
        request: ice20201109_models.GetCustomizedVoiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomizedVoiceResponse:
        """
        @summary Queries the information about a personalized human voice.
        
        @param request: GetCustomizedVoiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomizedVoiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomizedVoice',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomizedVoiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_customized_voice_with_options_async(
        self,
        request: ice20201109_models.GetCustomizedVoiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomizedVoiceResponse:
        """
        @summary Queries the information about a personalized human voice.
        
        @param request: GetCustomizedVoiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomizedVoiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.voice_id):
            query['VoiceId'] = request.voice_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomizedVoice',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomizedVoiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_customized_voice(
        self,
        request: ice20201109_models.GetCustomizedVoiceRequest,
    ) -> ice20201109_models.GetCustomizedVoiceResponse:
        """
        @summary Queries the information about a personalized human voice.
        
        @param request: GetCustomizedVoiceRequest
        @return: GetCustomizedVoiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_customized_voice_with_options(request, runtime)

    async def get_customized_voice_async(
        self,
        request: ice20201109_models.GetCustomizedVoiceRequest,
    ) -> ice20201109_models.GetCustomizedVoiceResponse:
        """
        @summary Queries the information about a personalized human voice.
        
        @param request: GetCustomizedVoiceRequest
        @return: GetCustomizedVoiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_customized_voice_with_options_async(request, runtime)

    def get_customized_voice_job_with_options(
        self,
        request: ice20201109_models.GetCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomizedVoiceJobResponse:
        """
        @summary Queries the information about a human voice cloning job.
        
        @param request: GetCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomizedVoiceJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_customized_voice_job_with_options_async(
        self,
        request: ice20201109_models.GetCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetCustomizedVoiceJobResponse:
        """
        @summary Queries the information about a human voice cloning job.
        
        @param request: GetCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetCustomizedVoiceJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_customized_voice_job(
        self,
        request: ice20201109_models.GetCustomizedVoiceJobRequest,
    ) -> ice20201109_models.GetCustomizedVoiceJobResponse:
        """
        @summary Queries the information about a human voice cloning job.
        
        @param request: GetCustomizedVoiceJobRequest
        @return: GetCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_customized_voice_job_with_options(request, runtime)

    async def get_customized_voice_job_async(
        self,
        request: ice20201109_models.GetCustomizedVoiceJobRequest,
    ) -> ice20201109_models.GetCustomizedVoiceJobResponse:
        """
        @summary Queries the information about a human voice cloning job.
        
        @param request: GetCustomizedVoiceJobRequest
        @return: GetCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_customized_voice_job_with_options_async(request, runtime)

    def get_default_storage_location_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDefaultStorageLocationResponse:
        """
        @summary 获取用户默认存储地址
        
        @param request: GetDefaultStorageLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDefaultStorageLocationResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetDefaultStorageLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDefaultStorageLocationResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_default_storage_location_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDefaultStorageLocationResponse:
        """
        @summary 获取用户默认存储地址
        
        @param request: GetDefaultStorageLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDefaultStorageLocationResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetDefaultStorageLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDefaultStorageLocationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_default_storage_location(self) -> ice20201109_models.GetDefaultStorageLocationResponse:
        """
        @summary 获取用户默认存储地址
        
        @return: GetDefaultStorageLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_default_storage_location_with_options(runtime)

    async def get_default_storage_location_async(self) -> ice20201109_models.GetDefaultStorageLocationResponse:
        """
        @summary 获取用户默认存储地址
        
        @return: GetDefaultStorageLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_default_storage_location_with_options_async(runtime)

    def get_demonstration_for_customized_voice_job_with_options(
        self,
        request: ice20201109_models.GetDemonstrationForCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse:
        """
        @summary Queries the text to be read and sample audio for training a personalized human voice.
        
        @param request: GetDemonstrationForCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDemonstrationForCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDemonstrationForCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_demonstration_for_customized_voice_job_with_options_async(
        self,
        request: ice20201109_models.GetDemonstrationForCustomizedVoiceJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse:
        """
        @summary Queries the text to be read and sample audio for training a personalized human voice.
        
        @param request: GetDemonstrationForCustomizedVoiceJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDemonstrationForCustomizedVoiceJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDemonstrationForCustomizedVoiceJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_demonstration_for_customized_voice_job(
        self,
        request: ice20201109_models.GetDemonstrationForCustomizedVoiceJobRequest,
    ) -> ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse:
        """
        @summary Queries the text to be read and sample audio for training a personalized human voice.
        
        @param request: GetDemonstrationForCustomizedVoiceJobRequest
        @return: GetDemonstrationForCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_demonstration_for_customized_voice_job_with_options(request, runtime)

    async def get_demonstration_for_customized_voice_job_async(
        self,
        request: ice20201109_models.GetDemonstrationForCustomizedVoiceJobRequest,
    ) -> ice20201109_models.GetDemonstrationForCustomizedVoiceJobResponse:
        """
        @summary Queries the text to be read and sample audio for training a personalized human voice.
        
        @param request: GetDemonstrationForCustomizedVoiceJobRequest
        @return: GetDemonstrationForCustomizedVoiceJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_demonstration_for_customized_voice_job_with_options_async(request, runtime)

    def get_dynamic_image_job_with_options(
        self,
        request: ice20201109_models.GetDynamicImageJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDynamicImageJobResponse:
        """
        @summary Queries the information about an image animation job.
        
        @param request: GetDynamicImageJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDynamicImageJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDynamicImageJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDynamicImageJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_dynamic_image_job_with_options_async(
        self,
        request: ice20201109_models.GetDynamicImageJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetDynamicImageJobResponse:
        """
        @summary Queries the information about an image animation job.
        
        @param request: GetDynamicImageJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetDynamicImageJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDynamicImageJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetDynamicImageJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_dynamic_image_job(
        self,
        request: ice20201109_models.GetDynamicImageJobRequest,
    ) -> ice20201109_models.GetDynamicImageJobResponse:
        """
        @summary Queries the information about an image animation job.
        
        @param request: GetDynamicImageJobRequest
        @return: GetDynamicImageJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_dynamic_image_job_with_options(request, runtime)

    async def get_dynamic_image_job_async(
        self,
        request: ice20201109_models.GetDynamicImageJobRequest,
    ) -> ice20201109_models.GetDynamicImageJobResponse:
        """
        @summary Queries the information about an image animation job.
        
        @param request: GetDynamicImageJobRequest
        @return: GetDynamicImageJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_dynamic_image_job_with_options_async(request, runtime)

    def get_editing_project_with_options(
        self,
        request: ice20201109_models.GetEditingProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEditingProjectResponse:
        """
        @summary Queries the information about an online editing project.
        
        @param request: GetEditingProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEditingProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.request_source):
            query['RequestSource'] = request.request_source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEditingProject',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEditingProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_editing_project_with_options_async(
        self,
        request: ice20201109_models.GetEditingProjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEditingProjectResponse:
        """
        @summary Queries the information about an online editing project.
        
        @param request: GetEditingProjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEditingProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.request_source):
            query['RequestSource'] = request.request_source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEditingProject',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEditingProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_editing_project(
        self,
        request: ice20201109_models.GetEditingProjectRequest,
    ) -> ice20201109_models.GetEditingProjectResponse:
        """
        @summary Queries the information about an online editing project.
        
        @param request: GetEditingProjectRequest
        @return: GetEditingProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_editing_project_with_options(request, runtime)

    async def get_editing_project_async(
        self,
        request: ice20201109_models.GetEditingProjectRequest,
    ) -> ice20201109_models.GetEditingProjectResponse:
        """
        @summary Queries the information about an online editing project.
        
        @param request: GetEditingProjectRequest
        @return: GetEditingProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_editing_project_with_options_async(request, runtime)

    def get_editing_project_materials_with_options(
        self,
        request: ice20201109_models.GetEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEditingProjectMaterialsResponse:
        """
        @summary Queries all materials associated with an online editing project.
        
        @param request: GetEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEditingProjectMaterialsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_editing_project_materials_with_options_async(
        self,
        request: ice20201109_models.GetEditingProjectMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEditingProjectMaterialsResponse:
        """
        @summary Queries all materials associated with an online editing project.
        
        @param request: GetEditingProjectMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEditingProjectMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEditingProjectMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEditingProjectMaterialsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_editing_project_materials(
        self,
        request: ice20201109_models.GetEditingProjectMaterialsRequest,
    ) -> ice20201109_models.GetEditingProjectMaterialsResponse:
        """
        @summary Queries all materials associated with an online editing project.
        
        @param request: GetEditingProjectMaterialsRequest
        @return: GetEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_editing_project_materials_with_options(request, runtime)

    async def get_editing_project_materials_async(
        self,
        request: ice20201109_models.GetEditingProjectMaterialsRequest,
    ) -> ice20201109_models.GetEditingProjectMaterialsResponse:
        """
        @summary Queries all materials associated with an online editing project.
        
        @param request: GetEditingProjectMaterialsRequest
        @return: GetEditingProjectMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_editing_project_materials_with_options_async(request, runtime)

    def get_event_callback_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEventCallbackResponse:
        """
        @summary Queries event callback configurations.
        
        @param request: GetEventCallbackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEventCallbackResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetEventCallback',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEventCallbackResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_event_callback_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetEventCallbackResponse:
        """
        @summary Queries event callback configurations.
        
        @param request: GetEventCallbackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEventCallbackResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetEventCallback',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetEventCallbackResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_event_callback(self) -> ice20201109_models.GetEventCallbackResponse:
        """
        @summary Queries event callback configurations.
        
        @return: GetEventCallbackResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_event_callback_with_options(runtime)

    async def get_event_callback_async(self) -> ice20201109_models.GetEventCallbackResponse:
        """
        @summary Queries event callback configurations.
        
        @return: GetEventCallbackResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_event_callback_with_options_async(runtime)

    def get_hotword_library_with_options(
        self,
        request: ice20201109_models.GetHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetHotwordLibraryResponse:
        """
        @summary 查询热词词库
        
        @param request: GetHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetHotwordLibraryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hotword_library_id):
            query['HotwordLibraryId'] = request.hotword_library_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetHotwordLibraryResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_hotword_library_with_options_async(
        self,
        request: ice20201109_models.GetHotwordLibraryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetHotwordLibraryResponse:
        """
        @summary 查询热词词库
        
        @param request: GetHotwordLibraryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetHotwordLibraryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hotword_library_id):
            query['HotwordLibraryId'] = request.hotword_library_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetHotwordLibrary',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetHotwordLibraryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_hotword_library(
        self,
        request: ice20201109_models.GetHotwordLibraryRequest,
    ) -> ice20201109_models.GetHotwordLibraryResponse:
        """
        @summary 查询热词词库
        
        @param request: GetHotwordLibraryRequest
        @return: GetHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_hotword_library_with_options(request, runtime)

    async def get_hotword_library_async(
        self,
        request: ice20201109_models.GetHotwordLibraryRequest,
    ) -> ice20201109_models.GetHotwordLibraryResponse:
        """
        @summary 查询热词词库
        
        @param request: GetHotwordLibraryRequest
        @return: GetHotwordLibraryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_hotword_library_with_options_async(request, runtime)

    def get_live_editing_index_file_with_options(
        self,
        request: ice20201109_models.GetLiveEditingIndexFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveEditingIndexFileResponse:
        """
        @summary Queries the index file of a live stream. The index file is used to preview an editing project in the console.
        
        @param request: GetLiveEditingIndexFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveEditingIndexFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveEditingIndexFile',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveEditingIndexFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_editing_index_file_with_options_async(
        self,
        request: ice20201109_models.GetLiveEditingIndexFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveEditingIndexFileResponse:
        """
        @summary Queries the index file of a live stream. The index file is used to preview an editing project in the console.
        
        @param request: GetLiveEditingIndexFileRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveEditingIndexFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.stream_name):
            query['StreamName'] = request.stream_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveEditingIndexFile',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveEditingIndexFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_editing_index_file(
        self,
        request: ice20201109_models.GetLiveEditingIndexFileRequest,
    ) -> ice20201109_models.GetLiveEditingIndexFileResponse:
        """
        @summary Queries the index file of a live stream. The index file is used to preview an editing project in the console.
        
        @param request: GetLiveEditingIndexFileRequest
        @return: GetLiveEditingIndexFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_editing_index_file_with_options(request, runtime)

    async def get_live_editing_index_file_async(
        self,
        request: ice20201109_models.GetLiveEditingIndexFileRequest,
    ) -> ice20201109_models.GetLiveEditingIndexFileResponse:
        """
        @summary Queries the index file of a live stream. The index file is used to preview an editing project in the console.
        
        @param request: GetLiveEditingIndexFileRequest
        @return: GetLiveEditingIndexFileResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_editing_index_file_with_options_async(request, runtime)

    def get_live_editing_job_with_options(
        self,
        request: ice20201109_models.GetLiveEditingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveEditingJobResponse:
        """
        @summary Queries the information about a live editing job. The requested information includes the state, timeline, and template of the job, the ID and URL of the output file, and the configurations of the job. You can call this operation to query only live editing jobs created within the past year.
        
        @param request: GetLiveEditingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveEditingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveEditingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveEditingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_editing_job_with_options_async(
        self,
        request: ice20201109_models.GetLiveEditingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveEditingJobResponse:
        """
        @summary Queries the information about a live editing job. The requested information includes the state, timeline, and template of the job, the ID and URL of the output file, and the configurations of the job. You can call this operation to query only live editing jobs created within the past year.
        
        @param request: GetLiveEditingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveEditingJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveEditingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveEditingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_editing_job(
        self,
        request: ice20201109_models.GetLiveEditingJobRequest,
    ) -> ice20201109_models.GetLiveEditingJobResponse:
        """
        @summary Queries the information about a live editing job. The requested information includes the state, timeline, and template of the job, the ID and URL of the output file, and the configurations of the job. You can call this operation to query only live editing jobs created within the past year.
        
        @param request: GetLiveEditingJobRequest
        @return: GetLiveEditingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_editing_job_with_options(request, runtime)

    async def get_live_editing_job_async(
        self,
        request: ice20201109_models.GetLiveEditingJobRequest,
    ) -> ice20201109_models.GetLiveEditingJobResponse:
        """
        @summary Queries the information about a live editing job. The requested information includes the state, timeline, and template of the job, the ID and URL of the output file, and the configurations of the job. You can call this operation to query only live editing jobs created within the past year.
        
        @param request: GetLiveEditingJobRequest
        @return: GetLiveEditingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_editing_job_with_options_async(request, runtime)

    def get_live_package_channel_with_options(
        self,
        request: ice20201109_models.GetLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageChannelResponse:
        """
        @summary Queries the details of a live package channel.
        
        @description ## [](#)Usage notes
        This API operation allows you to query the details of a live package channel, including the creation time, description, ingest endpoint, protocol, number of segments, and segment duration.
        
        @param request: GetLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_package_channel_with_options_async(
        self,
        request: ice20201109_models.GetLivePackageChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageChannelResponse:
        """
        @summary Queries the details of a live package channel.
        
        @description ## [](#)Usage notes
        This API operation allows you to query the details of a live package channel, including the creation time, description, ingest endpoint, protocol, number of segments, and segment duration.
        
        @param request: GetLivePackageChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageChannelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_package_channel(
        self,
        request: ice20201109_models.GetLivePackageChannelRequest,
    ) -> ice20201109_models.GetLivePackageChannelResponse:
        """
        @summary Queries the details of a live package channel.
        
        @description ## [](#)Usage notes
        This API operation allows you to query the details of a live package channel, including the creation time, description, ingest endpoint, protocol, number of segments, and segment duration.
        
        @param request: GetLivePackageChannelRequest
        @return: GetLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_package_channel_with_options(request, runtime)

    async def get_live_package_channel_async(
        self,
        request: ice20201109_models.GetLivePackageChannelRequest,
    ) -> ice20201109_models.GetLivePackageChannelResponse:
        """
        @summary Queries the details of a live package channel.
        
        @description ## [](#)Usage notes
        This API operation allows you to query the details of a live package channel, including the creation time, description, ingest endpoint, protocol, number of segments, and segment duration.
        
        @param request: GetLivePackageChannelRequest
        @return: GetLivePackageChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_package_channel_with_options_async(request, runtime)

    def get_live_package_channel_group_with_options(
        self,
        request: ice20201109_models.GetLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageChannelGroupResponse:
        """
        @summary Queries the details of a live package channel group by name.
        
        @description ## [](#)Usage notes
        You can call this API operation to query the details of a specific channel group, including its name, description, origin domain, and creation and last modification timestamps.
        
        @param request: GetLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageChannelGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_package_channel_group_with_options_async(
        self,
        request: ice20201109_models.GetLivePackageChannelGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageChannelGroupResponse:
        """
        @summary Queries the details of a live package channel group by name.
        
        @description ## [](#)Usage notes
        You can call this API operation to query the details of a specific channel group, including its name, description, origin domain, and creation and last modification timestamps.
        
        @param request: GetLivePackageChannelGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageChannelGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageChannelGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageChannelGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_package_channel_group(
        self,
        request: ice20201109_models.GetLivePackageChannelGroupRequest,
    ) -> ice20201109_models.GetLivePackageChannelGroupResponse:
        """
        @summary Queries the details of a live package channel group by name.
        
        @description ## [](#)Usage notes
        You can call this API operation to query the details of a specific channel group, including its name, description, origin domain, and creation and last modification timestamps.
        
        @param request: GetLivePackageChannelGroupRequest
        @return: GetLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_package_channel_group_with_options(request, runtime)

    async def get_live_package_channel_group_async(
        self,
        request: ice20201109_models.GetLivePackageChannelGroupRequest,
    ) -> ice20201109_models.GetLivePackageChannelGroupResponse:
        """
        @summary Queries the details of a live package channel group by name.
        
        @description ## [](#)Usage notes
        You can call this API operation to query the details of a specific channel group, including its name, description, origin domain, and creation and last modification timestamps.
        
        @param request: GetLivePackageChannelGroupRequest
        @return: GetLivePackageChannelGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_package_channel_group_with_options_async(request, runtime)

    def get_live_package_origin_endpoint_with_options(
        self,
        request: ice20201109_models.GetLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageOriginEndpointResponse:
        """
        @summary Queries origin endpoints associated with a live package channel.
        
        @description ## [](#)Usage notes
        
        @param request: GetLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageOriginEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_package_origin_endpoint_with_options_async(
        self,
        request: ice20201109_models.GetLivePackageOriginEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLivePackageOriginEndpointResponse:
        """
        @summary Queries origin endpoints associated with a live package channel.
        
        @description ## [](#)Usage notes
        
        @param request: GetLivePackageOriginEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLivePackageOriginEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLivePackageOriginEndpoint',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLivePackageOriginEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_package_origin_endpoint(
        self,
        request: ice20201109_models.GetLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.GetLivePackageOriginEndpointResponse:
        """
        @summary Queries origin endpoints associated with a live package channel.
        
        @description ## [](#)Usage notes
        
        @param request: GetLivePackageOriginEndpointRequest
        @return: GetLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_package_origin_endpoint_with_options(request, runtime)

    async def get_live_package_origin_endpoint_async(
        self,
        request: ice20201109_models.GetLivePackageOriginEndpointRequest,
    ) -> ice20201109_models.GetLivePackageOriginEndpointResponse:
        """
        @summary Queries origin endpoints associated with a live package channel.
        
        @description ## [](#)Usage notes
        
        @param request: GetLivePackageOriginEndpointRequest
        @return: GetLivePackageOriginEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_package_origin_endpoint_with_options_async(request, runtime)

    def get_live_record_job_with_options(
        self,
        request: ice20201109_models.GetLiveRecordJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveRecordJobResponse:
        """
        @summary Queries the information about a live stream recording job.
        
        @param request: GetLiveRecordJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveRecordJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveRecordJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveRecordJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_record_job_with_options_async(
        self,
        request: ice20201109_models.GetLiveRecordJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveRecordJobResponse:
        """
        @summary Queries the information about a live stream recording job.
        
        @param request: GetLiveRecordJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveRecordJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveRecordJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveRecordJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_record_job(
        self,
        request: ice20201109_models.GetLiveRecordJobRequest,
    ) -> ice20201109_models.GetLiveRecordJobResponse:
        """
        @summary Queries the information about a live stream recording job.
        
        @param request: GetLiveRecordJobRequest
        @return: GetLiveRecordJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_record_job_with_options(request, runtime)

    async def get_live_record_job_async(
        self,
        request: ice20201109_models.GetLiveRecordJobRequest,
    ) -> ice20201109_models.GetLiveRecordJobResponse:
        """
        @summary Queries the information about a live stream recording job.
        
        @param request: GetLiveRecordJobRequest
        @return: GetLiveRecordJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_record_job_with_options_async(request, runtime)

    def get_live_record_template_with_options(
        self,
        request: ice20201109_models.GetLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveRecordTemplateResponse:
        """
        @summary Queries the information about a live stream recording template or a snapshot of the template.
        
        @param request: GetLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveRecordTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveRecordTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_record_template_with_options_async(
        self,
        request: ice20201109_models.GetLiveRecordTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveRecordTemplateResponse:
        """
        @summary Queries the information about a live stream recording template or a snapshot of the template.
        
        @param request: GetLiveRecordTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveRecordTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveRecordTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveRecordTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_record_template(
        self,
        request: ice20201109_models.GetLiveRecordTemplateRequest,
    ) -> ice20201109_models.GetLiveRecordTemplateResponse:
        """
        @summary Queries the information about a live stream recording template or a snapshot of the template.
        
        @param request: GetLiveRecordTemplateRequest
        @return: GetLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_record_template_with_options(request, runtime)

    async def get_live_record_template_async(
        self,
        request: ice20201109_models.GetLiveRecordTemplateRequest,
    ) -> ice20201109_models.GetLiveRecordTemplateResponse:
        """
        @summary Queries the information about a live stream recording template or a snapshot of the template.
        
        @param request: GetLiveRecordTemplateRequest
        @return: GetLiveRecordTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_record_template_with_options_async(request, runtime)

    def get_live_snapshot_job_with_options(
        self,
        request: ice20201109_models.GetLiveSnapshotJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveSnapshotJobResponse:
        """
        @summary Queries the information a live stream snapshot job.
        
        @param request: GetLiveSnapshotJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveSnapshotJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveSnapshotJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveSnapshotJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_snapshot_job_with_options_async(
        self,
        request: ice20201109_models.GetLiveSnapshotJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveSnapshotJobResponse:
        """
        @summary Queries the information a live stream snapshot job.
        
        @param request: GetLiveSnapshotJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveSnapshotJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveSnapshotJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveSnapshotJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_snapshot_job(
        self,
        request: ice20201109_models.GetLiveSnapshotJobRequest,
    ) -> ice20201109_models.GetLiveSnapshotJobResponse:
        """
        @summary Queries the information a live stream snapshot job.
        
        @param request: GetLiveSnapshotJobRequest
        @return: GetLiveSnapshotJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_snapshot_job_with_options(request, runtime)

    async def get_live_snapshot_job_async(
        self,
        request: ice20201109_models.GetLiveSnapshotJobRequest,
    ) -> ice20201109_models.GetLiveSnapshotJobResponse:
        """
        @summary Queries the information a live stream snapshot job.
        
        @param request: GetLiveSnapshotJobRequest
        @return: GetLiveSnapshotJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_snapshot_job_with_options_async(request, runtime)

    def get_live_snapshot_template_with_options(
        self,
        request: ice20201109_models.GetLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveSnapshotTemplateResponse:
        """
        @summary Queries the information about a live stream snapshot template.
        
        @param request: GetLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveSnapshotTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_snapshot_template_with_options_async(
        self,
        request: ice20201109_models.GetLiveSnapshotTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveSnapshotTemplateResponse:
        """
        @summary Queries the information about a live stream snapshot template.
        
        @param request: GetLiveSnapshotTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveSnapshotTemplateResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveSnapshotTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveSnapshotTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_snapshot_template(
        self,
        request: ice20201109_models.GetLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.GetLiveSnapshotTemplateResponse:
        """
        @summary Queries the information about a live stream snapshot template.
        
        @param request: GetLiveSnapshotTemplateRequest
        @return: GetLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_snapshot_template_with_options(request, runtime)

    async def get_live_snapshot_template_async(
        self,
        request: ice20201109_models.GetLiveSnapshotTemplateRequest,
    ) -> ice20201109_models.GetLiveSnapshotTemplateResponse:
        """
        @summary Queries the information about a live stream snapshot template.
        
        @param request: GetLiveSnapshotTemplateRequest
        @return: GetLiveSnapshotTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_snapshot_template_with_options_async(request, runtime)

    def get_live_transcode_job_with_options(
        self,
        request: ice20201109_models.GetLiveTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveTranscodeJobResponse:
        """
        @summary Queries the information about a live stream transcoding job.
        
        @param request: GetLiveTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveTranscodeJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_transcode_job_with_options_async(
        self,
        request: ice20201109_models.GetLiveTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveTranscodeJobResponse:
        """
        @summary Queries the information about a live stream transcoding job.
        
        @param request: GetLiveTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveTranscodeJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_transcode_job(
        self,
        request: ice20201109_models.GetLiveTranscodeJobRequest,
    ) -> ice20201109_models.GetLiveTranscodeJobResponse:
        """
        @summary Queries the information about a live stream transcoding job.
        
        @param request: GetLiveTranscodeJobRequest
        @return: GetLiveTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_transcode_job_with_options(request, runtime)

    async def get_live_transcode_job_async(
        self,
        request: ice20201109_models.GetLiveTranscodeJobRequest,
    ) -> ice20201109_models.GetLiveTranscodeJobResponse:
        """
        @summary Queries the information about a live stream transcoding job.
        
        @param request: GetLiveTranscodeJobRequest
        @return: GetLiveTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_transcode_job_with_options_async(request, runtime)

    def get_live_transcode_template_with_options(
        self,
        request: ice20201109_models.GetLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveTranscodeTemplateResponse:
        """
        @summary Queries the information a live stream transcoding template.
        
        @param request: GetLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveTranscodeTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_live_transcode_template_with_options_async(
        self,
        request: ice20201109_models.GetLiveTranscodeTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetLiveTranscodeTemplateResponse:
        """
        @summary Queries the information a live stream transcoding template.
        
        @param request: GetLiveTranscodeTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLiveTranscodeTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLiveTranscodeTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetLiveTranscodeTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_live_transcode_template(
        self,
        request: ice20201109_models.GetLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.GetLiveTranscodeTemplateResponse:
        """
        @summary Queries the information a live stream transcoding template.
        
        @param request: GetLiveTranscodeTemplateRequest
        @return: GetLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_live_transcode_template_with_options(request, runtime)

    async def get_live_transcode_template_async(
        self,
        request: ice20201109_models.GetLiveTranscodeTemplateRequest,
    ) -> ice20201109_models.GetLiveTranscodeTemplateResponse:
        """
        @summary Queries the information a live stream transcoding template.
        
        @param request: GetLiveTranscodeTemplateRequest
        @return: GetLiveTranscodeTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_live_transcode_template_with_options_async(request, runtime)

    def get_media_connect_available_region_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectAvailableRegionResponse:
        """
        @summary 获取MediaConnect可用的区域
        
        @param request: GetMediaConnectAvailableRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectAvailableRegionResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetMediaConnectAvailableRegion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectAvailableRegionResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_connect_available_region_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectAvailableRegionResponse:
        """
        @summary 获取MediaConnect可用的区域
        
        @param request: GetMediaConnectAvailableRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectAvailableRegionResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='GetMediaConnectAvailableRegion',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectAvailableRegionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_connect_available_region(self) -> ice20201109_models.GetMediaConnectAvailableRegionResponse:
        """
        @summary 获取MediaConnect可用的区域
        
        @return: GetMediaConnectAvailableRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_connect_available_region_with_options(runtime)

    async def get_media_connect_available_region_async(self) -> ice20201109_models.GetMediaConnectAvailableRegionResponse:
        """
        @summary 获取MediaConnect可用的区域
        
        @return: GetMediaConnectAvailableRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_connect_available_region_with_options_async(runtime)

    def get_media_connect_flow_with_options(
        self,
        request: ice20201109_models.GetMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowResponse:
        """
        @summary Obtains information about a specific MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        The returned StartTime is valid only when the flow is in the online state.
        
        @param request: GetMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_connect_flow_with_options_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowResponse:
        """
        @summary Obtains information about a specific MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        The returned StartTime is valid only when the flow is in the online state.
        
        @param request: GetMediaConnectFlowRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlow',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_connect_flow(
        self,
        request: ice20201109_models.GetMediaConnectFlowRequest,
    ) -> ice20201109_models.GetMediaConnectFlowResponse:
        """
        @summary Obtains information about a specific MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        The returned StartTime is valid only when the flow is in the online state.
        
        @param request: GetMediaConnectFlowRequest
        @return: GetMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_connect_flow_with_options(request, runtime)

    async def get_media_connect_flow_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowRequest,
    ) -> ice20201109_models.GetMediaConnectFlowResponse:
        """
        @summary Obtains information about a specific MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        The returned StartTime is valid only when the flow is in the online state.
        
        @param request: GetMediaConnectFlowRequest
        @return: GetMediaConnectFlowResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_connect_flow_with_options_async(request, runtime)

    def get_media_connect_flow_all_output_name_with_options(
        self,
        request: ice20201109_models.GetMediaConnectFlowAllOutputNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowAllOutputNameResponse:
        """
        @summary 获取某个MediaConnect实例下的所有output的名字
        
        @param request: GetMediaConnectFlowAllOutputNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowAllOutputNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowAllOutputName',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowAllOutputNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_connect_flow_all_output_name_with_options_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowAllOutputNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowAllOutputNameResponse:
        """
        @summary 获取某个MediaConnect实例下的所有output的名字
        
        @param request: GetMediaConnectFlowAllOutputNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowAllOutputNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowAllOutputName',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowAllOutputNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_connect_flow_all_output_name(
        self,
        request: ice20201109_models.GetMediaConnectFlowAllOutputNameRequest,
    ) -> ice20201109_models.GetMediaConnectFlowAllOutputNameResponse:
        """
        @summary 获取某个MediaConnect实例下的所有output的名字
        
        @param request: GetMediaConnectFlowAllOutputNameRequest
        @return: GetMediaConnectFlowAllOutputNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_connect_flow_all_output_name_with_options(request, runtime)

    async def get_media_connect_flow_all_output_name_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowAllOutputNameRequest,
    ) -> ice20201109_models.GetMediaConnectFlowAllOutputNameResponse:
        """
        @summary 获取某个MediaConnect实例下的所有output的名字
        
        @param request: GetMediaConnectFlowAllOutputNameRequest
        @return: GetMediaConnectFlowAllOutputNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_connect_flow_all_output_name_with_options_async(request, runtime)

    def get_media_connect_flow_input_with_options(
        self,
        request: ice20201109_models.GetMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowInputResponse:
        """
        @summary Obtains information about the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_connect_flow_input_with_options_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowInputResponse:
        """
        @summary Obtains information about the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowInputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_connect_flow_input(
        self,
        request: ice20201109_models.GetMediaConnectFlowInputRequest,
    ) -> ice20201109_models.GetMediaConnectFlowInputResponse:
        """
        @summary Obtains information about the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowInputRequest
        @return: GetMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_connect_flow_input_with_options(request, runtime)

    async def get_media_connect_flow_input_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowInputRequest,
    ) -> ice20201109_models.GetMediaConnectFlowInputResponse:
        """
        @summary Obtains information about the source of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowInputRequest
        @return: GetMediaConnectFlowInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_connect_flow_input_with_options_async(request, runtime)

    def get_media_connect_flow_output_with_options(
        self,
        request: ice20201109_models.GetMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowOutputResponse:
        """
        @summary Obtains information about an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowOutputResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_connect_flow_output_with_options_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowOutputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConnectFlowOutputResponse:
        """
        @summary Obtains information about an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowOutputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConnectFlowOutputResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_id):
            query['FlowId'] = request.flow_id
        if not UtilClient.is_unset(request.output_name):
            query['OutputName'] = request.output_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConnectFlowOutput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConnectFlowOutputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_connect_flow_output(
        self,
        request: ice20201109_models.GetMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.GetMediaConnectFlowOutputResponse:
        """
        @summary Obtains information about an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowOutputRequest
        @return: GetMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_connect_flow_output_with_options(request, runtime)

    async def get_media_connect_flow_output_async(
        self,
        request: ice20201109_models.GetMediaConnectFlowOutputRequest,
    ) -> ice20201109_models.GetMediaConnectFlowOutputResponse:
        """
        @summary Obtains information about an output of a MediaConnect flow.
        
        @description    When the specified flow ID is not available, an error code is returned.
        
        @param request: GetMediaConnectFlowOutputRequest
        @return: GetMediaConnectFlowOutputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_connect_flow_output_with_options_async(request, runtime)

    def get_media_convert_job_with_options(
        self,
        request: ice20201109_models.GetMediaConvertJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConvertJobResponse:
        """
        @summary Obtains the details of a transcoding task.
        
        @param request: GetMediaConvertJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConvertJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConvertJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConvertJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_convert_job_with_options_async(
        self,
        request: ice20201109_models.GetMediaConvertJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaConvertJobResponse:
        """
        @summary Obtains the details of a transcoding task.
        
        @param request: GetMediaConvertJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaConvertJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaConvertJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaConvertJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_convert_job(
        self,
        request: ice20201109_models.GetMediaConvertJobRequest,
    ) -> ice20201109_models.GetMediaConvertJobResponse:
        """
        @summary Obtains the details of a transcoding task.
        
        @param request: GetMediaConvertJobRequest
        @return: GetMediaConvertJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_convert_job_with_options(request, runtime)

    async def get_media_convert_job_async(
        self,
        request: ice20201109_models.GetMediaConvertJobRequest,
    ) -> ice20201109_models.GetMediaConvertJobResponse:
        """
        @summary Obtains the details of a transcoding task.
        
        @param request: GetMediaConvertJobRequest
        @return: GetMediaConvertJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_convert_job_with_options_async(request, runtime)

    def get_media_info_with_options(
        self,
        request: ice20201109_models.GetMediaInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaInfoResponse:
        """
        @summary Queries information about a media asset based on the ID of the media asset in Intelligent Media Services (IMS) or the input URL of the media asset.
        
        @description If the MediaId parameter is specified, the MediaId parameter is preferentially used for the query. If the MediaId parameter is left empty, the InputURL parameter must be specified.
        
        @param request: GetMediaInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.input_url):
            query['InputURL'] = request.input_url
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.output_type):
            query['OutputType'] = request.output_type
        if not UtilClient.is_unset(request.return_detailed_info):
            query['ReturnDetailedInfo'] = request.return_detailed_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_info_with_options_async(
        self,
        request: ice20201109_models.GetMediaInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaInfoResponse:
        """
        @summary Queries information about a media asset based on the ID of the media asset in Intelligent Media Services (IMS) or the input URL of the media asset.
        
        @description If the MediaId parameter is specified, the MediaId parameter is preferentially used for the query. If the MediaId parameter is left empty, the InputURL parameter must be specified.
        
        @param request: GetMediaInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.input_url):
            query['InputURL'] = request.input_url
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.output_type):
            query['OutputType'] = request.output_type
        if not UtilClient.is_unset(request.return_detailed_info):
            query['ReturnDetailedInfo'] = request.return_detailed_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_info(
        self,
        request: ice20201109_models.GetMediaInfoRequest,
    ) -> ice20201109_models.GetMediaInfoResponse:
        """
        @summary Queries information about a media asset based on the ID of the media asset in Intelligent Media Services (IMS) or the input URL of the media asset.
        
        @description If the MediaId parameter is specified, the MediaId parameter is preferentially used for the query. If the MediaId parameter is left empty, the InputURL parameter must be specified.
        
        @param request: GetMediaInfoRequest
        @return: GetMediaInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_info_with_options(request, runtime)

    async def get_media_info_async(
        self,
        request: ice20201109_models.GetMediaInfoRequest,
    ) -> ice20201109_models.GetMediaInfoResponse:
        """
        @summary Queries information about a media asset based on the ID of the media asset in Intelligent Media Services (IMS) or the input URL of the media asset.
        
        @description If the MediaId parameter is specified, the MediaId parameter is preferentially used for the query. If the MediaId parameter is left empty, the InputURL parameter must be specified.
        
        @param request: GetMediaInfoRequest
        @return: GetMediaInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_info_with_options_async(request, runtime)

    def get_media_info_job_with_options(
        self,
        request: ice20201109_models.GetMediaInfoJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaInfoJobResponse:
        """
        @summary Queries the information about a media information analysis job.
        
        @param request: GetMediaInfoJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaInfoJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaInfoJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaInfoJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_info_job_with_options_async(
        self,
        request: ice20201109_models.GetMediaInfoJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaInfoJobResponse:
        """
        @summary Queries the information about a media information analysis job.
        
        @param request: GetMediaInfoJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaInfoJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaInfoJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaInfoJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_info_job(
        self,
        request: ice20201109_models.GetMediaInfoJobRequest,
    ) -> ice20201109_models.GetMediaInfoJobResponse:
        """
        @summary Queries the information about a media information analysis job.
        
        @param request: GetMediaInfoJobRequest
        @return: GetMediaInfoJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_info_job_with_options(request, runtime)

    async def get_media_info_job_async(
        self,
        request: ice20201109_models.GetMediaInfoJobRequest,
    ) -> ice20201109_models.GetMediaInfoJobResponse:
        """
        @summary Queries the information about a media information analysis job.
        
        @param request: GetMediaInfoJobRequest
        @return: GetMediaInfoJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_info_job_with_options_async(request, runtime)

    def get_media_live_channel_with_options(
        self,
        request: ice20201109_models.GetMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveChannelResponse:
        """
        @summary Queries a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveChannelResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel_id):
            body['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveChannelResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_live_channel_with_options_async(
        self,
        request: ice20201109_models.GetMediaLiveChannelRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveChannelResponse:
        """
        @summary Queries a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveChannelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveChannelResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.channel_id):
            body['ChannelId'] = request.channel_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveChannel',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveChannelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_live_channel(
        self,
        request: ice20201109_models.GetMediaLiveChannelRequest,
    ) -> ice20201109_models.GetMediaLiveChannelResponse:
        """
        @summary Queries a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveChannelRequest
        @return: GetMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_live_channel_with_options(request, runtime)

    async def get_media_live_channel_async(
        self,
        request: ice20201109_models.GetMediaLiveChannelRequest,
    ) -> ice20201109_models.GetMediaLiveChannelResponse:
        """
        @summary Queries a MediaLive channel.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveChannelRequest
        @return: GetMediaLiveChannelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_live_channel_with_options_async(request, runtime)

    def get_media_live_input_with_options(
        self,
        request: ice20201109_models.GetMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveInputResponse:
        """
        @summary Queries the details of a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveInputResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.input_id):
            body['InputId'] = request.input_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveInputResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_live_input_with_options_async(
        self,
        request: ice20201109_models.GetMediaLiveInputRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveInputResponse:
        """
        @summary Queries the details of a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveInputResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.input_id):
            body['InputId'] = request.input_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveInput',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveInputResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_live_input(
        self,
        request: ice20201109_models.GetMediaLiveInputRequest,
    ) -> ice20201109_models.GetMediaLiveInputResponse:
        """
        @summary Queries the details of a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputRequest
        @return: GetMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_live_input_with_options(request, runtime)

    async def get_media_live_input_async(
        self,
        request: ice20201109_models.GetMediaLiveInputRequest,
    ) -> ice20201109_models.GetMediaLiveInputResponse:
        """
        @summary Queries the details of a MediaLive input.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputRequest
        @return: GetMediaLiveInputResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_live_input_with_options_async(request, runtime)

    def get_media_live_input_security_group_with_options(
        self,
        request: ice20201109_models.GetMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveInputSecurityGroupResponse:
        """
        @summary Queries the details of a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.security_group_id):
            body['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveInputSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_live_input_security_group_with_options_async(
        self,
        request: ice20201109_models.GetMediaLiveInputSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaLiveInputSecurityGroupResponse:
        """
        @summary Queries the details of a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaLiveInputSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.security_group_id):
            body['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetMediaLiveInputSecurityGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaLiveInputSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_live_input_security_group(
        self,
        request: ice20201109_models.GetMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.GetMediaLiveInputSecurityGroupResponse:
        """
        @summary Queries the details of a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputSecurityGroupRequest
        @return: GetMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_live_input_security_group_with_options(request, runtime)

    async def get_media_live_input_security_group_async(
        self,
        request: ice20201109_models.GetMediaLiveInputSecurityGroupRequest,
    ) -> ice20201109_models.GetMediaLiveInputSecurityGroupResponse:
        """
        @summary Queries the details of a security group in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: GetMediaLiveInputSecurityGroupRequest
        @return: GetMediaLiveInputSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_live_input_security_group_with_options_async(request, runtime)

    def get_media_marks_with_options(
        self,
        request: ice20201109_models.GetMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaMarksResponse:
        """
        @summary Queries the information about marks based on mark IDs.
        
        @param request: GetMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaMarksResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_marks_with_options_async(
        self,
        request: ice20201109_models.GetMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaMarksResponse:
        """
        @summary Queries the information about marks based on mark IDs.
        
        @param request: GetMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaMarksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_marks(
        self,
        request: ice20201109_models.GetMediaMarksRequest,
    ) -> ice20201109_models.GetMediaMarksResponse:
        """
        @summary Queries the information about marks based on mark IDs.
        
        @param request: GetMediaMarksRequest
        @return: GetMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_marks_with_options(request, runtime)

    async def get_media_marks_async(
        self,
        request: ice20201109_models.GetMediaMarksRequest,
    ) -> ice20201109_models.GetMediaMarksResponse:
        """
        @summary Queries the information about marks based on mark IDs.
        
        @param request: GetMediaMarksRequest
        @return: GetMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_marks_with_options_async(request, runtime)

    def get_media_producing_job_with_options(
        self,
        request: ice20201109_models.GetMediaProducingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaProducingJobResponse:
        """
        @summary Queries the information about a media editing and production job. The requested information includes the state, timeline, template, and data of the job. You can call this operation to query only media editing and production jobs created within the past year.
        
        @param request: GetMediaProducingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaProducingJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaProducingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaProducingJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_media_producing_job_with_options_async(
        self,
        request: ice20201109_models.GetMediaProducingJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetMediaProducingJobResponse:
        """
        @summary Queries the information about a media editing and production job. The requested information includes the state, timeline, template, and data of the job. You can call this operation to query only media editing and production jobs created within the past year.
        
        @param request: GetMediaProducingJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMediaProducingJobResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMediaProducingJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetMediaProducingJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_media_producing_job(
        self,
        request: ice20201109_models.GetMediaProducingJobRequest,
    ) -> ice20201109_models.GetMediaProducingJobResponse:
        """
        @summary Queries the information about a media editing and production job. The requested information includes the state, timeline, template, and data of the job. You can call this operation to query only media editing and production jobs created within the past year.
        
        @param request: GetMediaProducingJobRequest
        @return: GetMediaProducingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_media_producing_job_with_options(request, runtime)

    async def get_media_producing_job_async(
        self,
        request: ice20201109_models.GetMediaProducingJobRequest,
    ) -> ice20201109_models.GetMediaProducingJobResponse:
        """
        @summary Queries the information about a media editing and production job. The requested information includes the state, timeline, template, and data of the job. You can call this operation to query only media editing and production jobs created within the past year.
        
        @param request: GetMediaProducingJobRequest
        @return: GetMediaProducingJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_media_producing_job_with_options_async(request, runtime)

    def get_package_job_with_options(
        self,
        request: ice20201109_models.GetPackageJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPackageJobResponse:
        """
        @summary Queries the information about a packaging job.
        
        @param request: GetPackageJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPackageJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPackageJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPackageJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_package_job_with_options_async(
        self,
        request: ice20201109_models.GetPackageJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPackageJobResponse:
        """
        @summary Queries the information about a packaging job.
        
        @param request: GetPackageJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPackageJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPackageJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPackageJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_package_job(
        self,
        request: ice20201109_models.GetPackageJobRequest,
    ) -> ice20201109_models.GetPackageJobResponse:
        """
        @summary Queries the information about a packaging job.
        
        @param request: GetPackageJobRequest
        @return: GetPackageJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_package_job_with_options(request, runtime)

    async def get_package_job_async(
        self,
        request: ice20201109_models.GetPackageJobRequest,
    ) -> ice20201109_models.GetPackageJobResponse:
        """
        @summary Queries the information about a packaging job.
        
        @param request: GetPackageJobRequest
        @return: GetPackageJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_package_job_with_options_async(request, runtime)

    def get_pipeline_with_options(
        self,
        request: ice20201109_models.GetPipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPipelineResponse:
        """
        @summary Queries the information about an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: GetPipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pipeline_id):
            query['PipelineId'] = request.pipeline_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_with_options_async(
        self,
        request: ice20201109_models.GetPipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPipelineResponse:
        """
        @summary Queries the information about an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: GetPipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.pipeline_id):
            query['PipelineId'] = request.pipeline_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipeline',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline(
        self,
        request: ice20201109_models.GetPipelineRequest,
    ) -> ice20201109_models.GetPipelineResponse:
        """
        @summary Queries the information about an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: GetPipelineRequest
        @return: GetPipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_pipeline_with_options(request, runtime)

    async def get_pipeline_async(
        self,
        request: ice20201109_models.GetPipelineRequest,
    ) -> ice20201109_models.GetPipelineResponse:
        """
        @summary Queries the information about an ApsaraVideo Media Processing (MPS) queue.
        
        @param request: GetPipelineRequest
        @return: GetPipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_pipeline_with_options_async(request, runtime)

    def get_play_info_with_options(
        self,
        request: ice20201109_models.GetPlayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPlayInfoResponse:
        """
        @summary Queries the playback URL of a video or audio file based on its ID.
        
        @description You use the ID of a video or audio file to query the playback URL of the file. Then, you can use the playback URL to play the audio or video in ApsaraVideo Player SDK (for URL-based playback) or a third-party player.
        
        @param request: GetPlayInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPlayInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.input_url):
            query['InputURL'] = request.input_url
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPlayInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPlayInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_play_info_with_options_async(
        self,
        request: ice20201109_models.GetPlayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPlayInfoResponse:
        """
        @summary Queries the playback URL of a video or audio file based on its ID.
        
        @description You use the ID of a video or audio file to query the playback URL of the file. Then, you can use the playback URL to play the audio or video in ApsaraVideo Player SDK (for URL-based playback) or a third-party player.
        
        @param request: GetPlayInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPlayInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.input_url):
            query['InputURL'] = request.input_url
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPlayInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPlayInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_play_info(
        self,
        request: ice20201109_models.GetPlayInfoRequest,
    ) -> ice20201109_models.GetPlayInfoResponse:
        """
        @summary Queries the playback URL of a video or audio file based on its ID.
        
        @description You use the ID of a video or audio file to query the playback URL of the file. Then, you can use the playback URL to play the audio or video in ApsaraVideo Player SDK (for URL-based playback) or a third-party player.
        
        @param request: GetPlayInfoRequest
        @return: GetPlayInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_play_info_with_options(request, runtime)

    async def get_play_info_async(
        self,
        request: ice20201109_models.GetPlayInfoRequest,
    ) -> ice20201109_models.GetPlayInfoResponse:
        """
        @summary Queries the playback URL of a video or audio file based on its ID.
        
        @description You use the ID of a video or audio file to query the playback URL of the file. Then, you can use the playback URL to play the audio or video in ApsaraVideo Player SDK (for URL-based playback) or a third-party player.
        
        @param request: GetPlayInfoRequest
        @return: GetPlayInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_play_info_with_options_async(request, runtime)

    def get_program_with_options(
        self,
        request: ice20201109_models.GetProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetProgramResponse:
        """
        @summary Queries a program.
        
        @param request: GetProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetProgramResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_program_with_options_async(
        self,
        request: ice20201109_models.GetProgramRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetProgramResponse:
        """
        @summary Queries a program.
        
        @param request: GetProgramRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProgramResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProgram',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetProgramResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_program(
        self,
        request: ice20201109_models.GetProgramRequest,
    ) -> ice20201109_models.GetProgramResponse:
        """
        @summary Queries a program.
        
        @param request: GetProgramRequest
        @return: GetProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_program_with_options(request, runtime)

    async def get_program_async(
        self,
        request: ice20201109_models.GetProgramRequest,
    ) -> ice20201109_models.GetProgramResponse:
        """
        @summary Queries a program.
        
        @param request: GetProgramRequest
        @return: GetProgramResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_program_with_options_async(request, runtime)

    def get_project_export_job_with_options(
        self,
        request: ice20201109_models.GetProjectExportJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetProjectExportJobResponse:
        """
        @summary 查询工程导出任务
        
        @param request: GetProjectExportJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectExportJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProjectExportJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetProjectExportJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_project_export_job_with_options_async(
        self,
        request: ice20201109_models.GetProjectExportJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetProjectExportJobResponse:
        """
        @summary 查询工程导出任务
        
        @param request: GetProjectExportJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectExportJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProjectExportJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetProjectExportJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_project_export_job(
        self,
        request: ice20201109_models.GetProjectExportJobRequest,
    ) -> ice20201109_models.GetProjectExportJobResponse:
        """
        @summary 查询工程导出任务
        
        @param request: GetProjectExportJobRequest
        @return: GetProjectExportJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_project_export_job_with_options(request, runtime)

    async def get_project_export_job_async(
        self,
        request: ice20201109_models.GetProjectExportJobRequest,
    ) -> ice20201109_models.GetProjectExportJobResponse:
        """
        @summary 查询工程导出任务
        
        @param request: GetProjectExportJobRequest
        @return: GetProjectExportJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_project_export_job_with_options_async(request, runtime)

    def get_public_media_info_with_options(
        self,
        request: ice20201109_models.GetPublicMediaInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPublicMediaInfoResponse:
        """
        @summary 获取公共媒资内容信息
        
        @param request: GetPublicMediaInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPublicMediaInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPublicMediaInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPublicMediaInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_public_media_info_with_options_async(
        self,
        request: ice20201109_models.GetPublicMediaInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetPublicMediaInfoResponse:
        """
        @summary 获取公共媒资内容信息
        
        @param request: GetPublicMediaInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPublicMediaInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPublicMediaInfo',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetPublicMediaInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_public_media_info(
        self,
        request: ice20201109_models.GetPublicMediaInfoRequest,
    ) -> ice20201109_models.GetPublicMediaInfoResponse:
        """
        @summary 获取公共媒资内容信息
        
        @param request: GetPublicMediaInfoRequest
        @return: GetPublicMediaInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_public_media_info_with_options(request, runtime)

    async def get_public_media_info_async(
        self,
        request: ice20201109_models.GetPublicMediaInfoRequest,
    ) -> ice20201109_models.GetPublicMediaInfoResponse:
        """
        @summary 获取公共媒资内容信息
        
        @param request: GetPublicMediaInfoRequest
        @return: GetPublicMediaInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_public_media_info_with_options_async(request, runtime)

    def get_smart_handle_job_with_options(
        self,
        request: ice20201109_models.GetSmartHandleJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSmartHandleJobResponse:
        """
        @summary Queries the information about an intelligent job and the execution results of the job based the job ID. You can call this operation to query only intelligent jobs created within the past year.
        
        @param request: GetSmartHandleJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSmartHandleJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSmartHandleJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSmartHandleJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_smart_handle_job_with_options_async(
        self,
        request: ice20201109_models.GetSmartHandleJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSmartHandleJobResponse:
        """
        @summary Queries the information about an intelligent job and the execution results of the job based the job ID. You can call this operation to query only intelligent jobs created within the past year.
        
        @param request: GetSmartHandleJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSmartHandleJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSmartHandleJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSmartHandleJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_smart_handle_job(
        self,
        request: ice20201109_models.GetSmartHandleJobRequest,
    ) -> ice20201109_models.GetSmartHandleJobResponse:
        """
        @summary Queries the information about an intelligent job and the execution results of the job based the job ID. You can call this operation to query only intelligent jobs created within the past year.
        
        @param request: GetSmartHandleJobRequest
        @return: GetSmartHandleJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_smart_handle_job_with_options(request, runtime)

    async def get_smart_handle_job_async(
        self,
        request: ice20201109_models.GetSmartHandleJobRequest,
    ) -> ice20201109_models.GetSmartHandleJobResponse:
        """
        @summary Queries the information about an intelligent job and the execution results of the job based the job ID. You can call this operation to query only intelligent jobs created within the past year.
        
        @param request: GetSmartHandleJobRequest
        @return: GetSmartHandleJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_smart_handle_job_with_options_async(request, runtime)

    def get_snapshot_job_with_options(
        self,
        request: ice20201109_models.GetSnapshotJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSnapshotJobResponse:
        """
        @summary Queries the information about a snapshot job.
        
        @param request: GetSnapshotJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSnapshotJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSnapshotJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSnapshotJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_snapshot_job_with_options_async(
        self,
        request: ice20201109_models.GetSnapshotJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSnapshotJobResponse:
        """
        @summary Queries the information about a snapshot job.
        
        @param request: GetSnapshotJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSnapshotJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSnapshotJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSnapshotJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_snapshot_job(
        self,
        request: ice20201109_models.GetSnapshotJobRequest,
    ) -> ice20201109_models.GetSnapshotJobResponse:
        """
        @summary Queries the information about a snapshot job.
        
        @param request: GetSnapshotJobRequest
        @return: GetSnapshotJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_snapshot_job_with_options(request, runtime)

    async def get_snapshot_job_async(
        self,
        request: ice20201109_models.GetSnapshotJobRequest,
    ) -> ice20201109_models.GetSnapshotJobResponse:
        """
        @summary Queries the information about a snapshot job.
        
        @param request: GetSnapshotJobRequest
        @return: GetSnapshotJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_snapshot_job_with_options_async(request, runtime)

    def get_snapshot_urls_with_options(
        self,
        request: ice20201109_models.GetSnapshotUrlsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSnapshotUrlsResponse:
        """
        @summary Queries the accessible URLs of the output images of a snapshot job.
        
        @param request: GetSnapshotUrlsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSnapshotUrlsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSnapshotUrls',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSnapshotUrlsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_snapshot_urls_with_options_async(
        self,
        request: ice20201109_models.GetSnapshotUrlsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSnapshotUrlsResponse:
        """
        @summary Queries the accessible URLs of the output images of a snapshot job.
        
        @param request: GetSnapshotUrlsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSnapshotUrlsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSnapshotUrls',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSnapshotUrlsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_snapshot_urls(
        self,
        request: ice20201109_models.GetSnapshotUrlsRequest,
    ) -> ice20201109_models.GetSnapshotUrlsResponse:
        """
        @summary Queries the accessible URLs of the output images of a snapshot job.
        
        @param request: GetSnapshotUrlsRequest
        @return: GetSnapshotUrlsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_snapshot_urls_with_options(request, runtime)

    async def get_snapshot_urls_async(
        self,
        request: ice20201109_models.GetSnapshotUrlsRequest,
    ) -> ice20201109_models.GetSnapshotUrlsResponse:
        """
        @summary Queries the accessible URLs of the output images of a snapshot job.
        
        @param request: GetSnapshotUrlsRequest
        @return: GetSnapshotUrlsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_snapshot_urls_with_options_async(request, runtime)

    def get_source_with_options(
        self,
        request: ice20201109_models.GetSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSourceResponse:
        """
        @summary Queries a source in MediaWeaver.
        
        @param request: GetSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_source_with_options_async(
        self,
        request: ice20201109_models.GetSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSourceResponse:
        """
        @summary Queries a source in MediaWeaver.
        
        @param request: GetSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        if not UtilClient.is_unset(request.source_name):
            query['SourceName'] = request.source_name
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSource',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_source(
        self,
        request: ice20201109_models.GetSourceRequest,
    ) -> ice20201109_models.GetSourceResponse:
        """
        @summary Queries a source in MediaWeaver.
        
        @param request: GetSourceRequest
        @return: GetSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_source_with_options(request, runtime)

    async def get_source_async(
        self,
        request: ice20201109_models.GetSourceRequest,
    ) -> ice20201109_models.GetSourceResponse:
        """
        @summary Queries a source in MediaWeaver.
        
        @param request: GetSourceRequest
        @return: GetSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_source_with_options_async(request, runtime)

    def get_source_location_with_options(
        self,
        request: ice20201109_models.GetSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSourceLocationResponse:
        """
        @summary Queries a source location.
        
        @param request: GetSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSourceLocationResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_source_location_with_options_async(
        self,
        request: ice20201109_models.GetSourceLocationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSourceLocationResponse:
        """
        @summary Queries a source location.
        
        @param request: GetSourceLocationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSourceLocationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_location_name):
            query['SourceLocationName'] = request.source_location_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSourceLocation',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSourceLocationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_source_location(
        self,
        request: ice20201109_models.GetSourceLocationRequest,
    ) -> ice20201109_models.GetSourceLocationResponse:
        """
        @summary Queries a source location.
        
        @param request: GetSourceLocationRequest
        @return: GetSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_source_location_with_options(request, runtime)

    async def get_source_location_async(
        self,
        request: ice20201109_models.GetSourceLocationRequest,
    ) -> ice20201109_models.GetSourceLocationResponse:
        """
        @summary Queries a source location.
        
        @param request: GetSourceLocationRequest
        @return: GetSourceLocationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_source_location_with_options_async(request, runtime)

    def get_storage_list_with_options(
        self,
        request: ice20201109_models.GetStorageListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetStorageListResponse:
        """
        @summary 获取存储地址列表
        
        @param request: GetStorageListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetStorageListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetStorageList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetStorageListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_storage_list_with_options_async(
        self,
        request: ice20201109_models.GetStorageListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetStorageListResponse:
        """
        @summary 获取存储地址列表
        
        @param request: GetStorageListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetStorageListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.storage_type):
            query['StorageType'] = request.storage_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetStorageList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetStorageListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_storage_list(
        self,
        request: ice20201109_models.GetStorageListRequest,
    ) -> ice20201109_models.GetStorageListResponse:
        """
        @summary 获取存储地址列表
        
        @param request: GetStorageListRequest
        @return: GetStorageListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_storage_list_with_options(request, runtime)

    async def get_storage_list_async(
        self,
        request: ice20201109_models.GetStorageListRequest,
    ) -> ice20201109_models.GetStorageListResponse:
        """
        @summary 获取存储地址列表
        
        @param request: GetStorageListRequest
        @return: GetStorageListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_storage_list_with_options_async(request, runtime)

    def get_system_template_with_options(
        self,
        request: ice20201109_models.GetSystemTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSystemTemplateResponse:
        """
        @summary Queries the information about a system template.
        
        @param request: GetSystemTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSystemTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSystemTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSystemTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_system_template_with_options_async(
        self,
        request: ice20201109_models.GetSystemTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetSystemTemplateResponse:
        """
        @summary Queries the information about a system template.
        
        @param request: GetSystemTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSystemTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSystemTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetSystemTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_system_template(
        self,
        request: ice20201109_models.GetSystemTemplateRequest,
    ) -> ice20201109_models.GetSystemTemplateResponse:
        """
        @summary Queries the information about a system template.
        
        @param request: GetSystemTemplateRequest
        @return: GetSystemTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_system_template_with_options(request, runtime)

    async def get_system_template_async(
        self,
        request: ice20201109_models.GetSystemTemplateRequest,
    ) -> ice20201109_models.GetSystemTemplateResponse:
        """
        @summary Queries the information about a system template.
        
        @param request: GetSystemTemplateRequest
        @return: GetSystemTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_system_template_with_options_async(request, runtime)

    def get_template_with_options(
        self,
        request: ice20201109_models.GetTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateResponse:
        """
        @summary Queries the information about a template based on the template ID. You can call this operation to query the information about an advanced template if the template is in the Available state.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: GetTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.related_mediaid_flag):
            query['RelatedMediaidFlag'] = request.related_mediaid_flag
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_template_with_options_async(
        self,
        request: ice20201109_models.GetTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateResponse:
        """
        @summary Queries the information about a template based on the template ID. You can call this operation to query the information about an advanced template if the template is in the Available state.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: GetTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.related_mediaid_flag):
            query['RelatedMediaidFlag'] = request.related_mediaid_flag
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplate',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_template(
        self,
        request: ice20201109_models.GetTemplateRequest,
    ) -> ice20201109_models.GetTemplateResponse:
        """
        @summary Queries the information about a template based on the template ID. You can call this operation to query the information about an advanced template if the template is in the Available state.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: GetTemplateRequest
        @return: GetTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_template_with_options(request, runtime)

    async def get_template_async(
        self,
        request: ice20201109_models.GetTemplateRequest,
    ) -> ice20201109_models.GetTemplateResponse:
        """
        @summary Queries the information about a template based on the template ID. You can call this operation to query the information about an advanced template if the template is in the Available state.
        
        @description A template is an encapsulation of the timeline of a media editing and production job. You can define a common timeline as a template. When you have the same requirements, you need to only specify key parameters and materials to produce videos.
        For more information about how to use a regular template, see [Create and use a regular template](https://help.aliyun.com/document_detail/445399.html).
        For more information about how to use an advanced template, see [Create and use advanced templates](https://help.aliyun.com/document_detail/445389.html).
        
        @param request: GetTemplateRequest
        @return: GetTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_template_with_options_async(request, runtime)

    def get_template_materials_with_options(
        self,
        request: ice20201109_models.GetTemplateMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateMaterialsResponse:
        """
        @summary Queries the URLs of materials associated with an advanced template for use by the advanced template editor. The URLs expire in 30 minutes. FileList is an array of materials that you want to query. If you do not specify this parameter, the URLs of all materials are returned. A maximum of 400 URLs can be returned.
        
        @param request: GetTemplateMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_list):
            query['FileList'] = request.file_list
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplateMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateMaterialsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_template_materials_with_options_async(
        self,
        request: ice20201109_models.GetTemplateMaterialsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateMaterialsResponse:
        """
        @summary Queries the URLs of materials associated with an advanced template for use by the advanced template editor. The URLs expire in 30 minutes. FileList is an array of materials that you want to query. If you do not specify this parameter, the URLs of all materials are returned. A maximum of 400 URLs can be returned.
        
        @param request: GetTemplateMaterialsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateMaterialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_list):
            query['FileList'] = request.file_list
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplateMaterials',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateMaterialsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_template_materials(
        self,
        request: ice20201109_models.GetTemplateMaterialsRequest,
    ) -> ice20201109_models.GetTemplateMaterialsResponse:
        """
        @summary Queries the URLs of materials associated with an advanced template for use by the advanced template editor. The URLs expire in 30 minutes. FileList is an array of materials that you want to query. If you do not specify this parameter, the URLs of all materials are returned. A maximum of 400 URLs can be returned.
        
        @param request: GetTemplateMaterialsRequest
        @return: GetTemplateMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_template_materials_with_options(request, runtime)

    async def get_template_materials_async(
        self,
        request: ice20201109_models.GetTemplateMaterialsRequest,
    ) -> ice20201109_models.GetTemplateMaterialsResponse:
        """
        @summary Queries the URLs of materials associated with an advanced template for use by the advanced template editor. The URLs expire in 30 minutes. FileList is an array of materials that you want to query. If you do not specify this parameter, the URLs of all materials are returned. A maximum of 400 URLs can be returned.
        
        @param request: GetTemplateMaterialsRequest
        @return: GetTemplateMaterialsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_template_materials_with_options_async(request, runtime)

    def get_template_params_with_options(
        self,
        request: ice20201109_models.GetTemplateParamsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateParamsResponse:
        """
        @summary Queries the parameters for replaceable materials in a template, including the parameter names, default values, and material thumbnails. Only advanced templates are supported.
        
        @param request: GetTemplateParamsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateParamsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplateParams',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateParamsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_template_params_with_options_async(
        self,
        request: ice20201109_models.GetTemplateParamsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTemplateParamsResponse:
        """
        @summary Queries the parameters for replaceable materials in a template, including the parameter names, default values, and material thumbnails. Only advanced templates are supported.
        
        @param request: GetTemplateParamsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTemplateParamsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTemplateParams',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTemplateParamsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_template_params(
        self,
        request: ice20201109_models.GetTemplateParamsRequest,
    ) -> ice20201109_models.GetTemplateParamsResponse:
        """
        @summary Queries the parameters for replaceable materials in a template, including the parameter names, default values, and material thumbnails. Only advanced templates are supported.
        
        @param request: GetTemplateParamsRequest
        @return: GetTemplateParamsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_template_params_with_options(request, runtime)

    async def get_template_params_async(
        self,
        request: ice20201109_models.GetTemplateParamsRequest,
    ) -> ice20201109_models.GetTemplateParamsResponse:
        """
        @summary Queries the parameters for replaceable materials in a template, including the parameter names, default values, and material thumbnails. Only advanced templates are supported.
        
        @param request: GetTemplateParamsRequest
        @return: GetTemplateParamsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_template_params_with_options_async(request, runtime)

    def get_transcode_job_with_options(
        self,
        request: ice20201109_models.GetTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTranscodeJobResponse:
        """
        @summary Queries the information about a transcoding job.
        
        @param request: GetTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.parent_job_id):
            query['ParentJobId'] = request.parent_job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTranscodeJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_transcode_job_with_options_async(
        self,
        request: ice20201109_models.GetTranscodeJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetTranscodeJobResponse:
        """
        @summary Queries the information about a transcoding job.
        
        @param request: GetTranscodeJobRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTranscodeJobResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.parent_job_id):
            query['ParentJobId'] = request.parent_job_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTranscodeJob',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetTranscodeJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_transcode_job(
        self,
        request: ice20201109_models.GetTranscodeJobRequest,
    ) -> ice20201109_models.GetTranscodeJobResponse:
        """
        @summary Queries the information about a transcoding job.
        
        @param request: GetTranscodeJobRequest
        @return: GetTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_transcode_job_with_options(request, runtime)

    async def get_transcode_job_async(
        self,
        request: ice20201109_models.GetTranscodeJobRequest,
    ) -> ice20201109_models.GetTranscodeJobResponse:
        """
        @summary Queries the information about a transcoding job.
        
        @param request: GetTranscodeJobRequest
        @return: GetTranscodeJobResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_transcode_job_with_options_async(request, runtime)

    def get_url_upload_infos_with_options(
        self,
        request: ice20201109_models.GetUrlUploadInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetUrlUploadInfosResponse:
        """
        @summary Queries the information about URL-based upload jobs.
        
        @description You can call this operation to query the information, including the upload status, user data, creation time, and completion time, about URL-based upload jobs based on the returned job IDs or the URLs used during the upload.
        If an upload job fails, you can view the error code and error message. If an upload job is successful, you can obtain the video ID.
        
        @param request: GetUrlUploadInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUrlUploadInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_ids):
            query['JobIds'] = request.job_ids
        if not UtilClient.is_unset(request.upload_urls):
            query['UploadURLs'] = request.upload_urls
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetUrlUploadInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetUrlUploadInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_url_upload_infos_with_options_async(
        self,
        request: ice20201109_models.GetUrlUploadInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetUrlUploadInfosResponse:
        """
        @summary Queries the information about URL-based upload jobs.
        
        @description You can call this operation to query the information, including the upload status, user data, creation time, and completion time, about URL-based upload jobs based on the returned job IDs or the URLs used during the upload.
        If an upload job fails, you can view the error code and error message. If an upload job is successful, you can obtain the video ID.
        
        @param request: GetUrlUploadInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUrlUploadInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_ids):
            query['JobIds'] = request.job_ids
        if not UtilClient.is_unset(request.upload_urls):
            query['UploadURLs'] = request.upload_urls
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetUrlUploadInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetUrlUploadInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_url_upload_infos(
        self,
        request: ice20201109_models.GetUrlUploadInfosRequest,
    ) -> ice20201109_models.GetUrlUploadInfosResponse:
        """
        @summary Queries the information about URL-based upload jobs.
        
        @description You can call this operation to query the information, including the upload status, user data, creation time, and completion time, about URL-based upload jobs based on the returned job IDs or the URLs used during the upload.
        If an upload job fails, you can view the error code and error message. If an upload job is successful, you can obtain the video ID.
        
        @param request: GetUrlUploadInfosRequest
        @return: GetUrlUploadInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_url_upload_infos_with_options(request, runtime)

    async def get_url_upload_infos_async(
        self,
        request: ice20201109_models.GetUrlUploadInfosRequest,
    ) -> ice20201109_models.GetUrlUploadInfosResponse:
        """
        @summary Queries the information about URL-based upload jobs.
        
        @description You can call this operation to query the information, including the upload status, user data, creation time, and completion time, about URL-based upload jobs based on the returned job IDs or the URLs used during the upload.
        If an upload job fails, you can view the error code and error message. If an upload job is successful, you can obtain the video ID.
        
        @param request: GetUrlUploadInfosRequest
        @return: GetUrlUploadInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_url_upload_infos_with_options_async(request, runtime)

    def get_video_list_with_options(
        self,
        request: ice20201109_models.GetVideoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVideoListResponse:
        """
        @summary Queries information about video and audio files.
        
        @description You can call this operation to query information about up to the first 5,000 audio and video files based on the filter condition, such as the status or category ID of the file. We recommend that you set the StartTime and EndTime parameters to narrow down the time range and perform multiple queries to obtain data.
        
        @param request: GetVideoListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVideoListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVideoList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVideoListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_video_list_with_options_async(
        self,
        request: ice20201109_models.GetVideoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVideoListResponse:
        """
        @summary Queries information about video and audio files.
        
        @description You can call this operation to query information about up to the first 5,000 audio and video files based on the filter condition, such as the status or category ID of the file. We recommend that you set the StartTime and EndTime parameters to narrow down the time range and perform multiple queries to obtain data.
        
        @param request: GetVideoListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVideoListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cate_id):
            query['CateId'] = request.cate_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVideoList',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVideoListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_video_list(
        self,
        request: ice20201109_models.GetVideoListRequest,
    ) -> ice20201109_models.GetVideoListResponse:
        """
        @summary Queries information about video and audio files.
        
        @description You can call this operation to query information about up to the first 5,000 audio and video files based on the filter condition, such as the status or category ID of the file. We recommend that you set the StartTime and EndTime parameters to narrow down the time range and perform multiple queries to obtain data.
        
        @param request: GetVideoListRequest
        @return: GetVideoListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_video_list_with_options(request, runtime)

    async def get_video_list_async(
        self,
        request: ice20201109_models.GetVideoListRequest,
    ) -> ice20201109_models.GetVideoListResponse:
        """
        @summary Queries information about video and audio files.
        
        @description You can call this operation to query information about up to the first 5,000 audio and video files based on the filter condition, such as the status or category ID of the file. We recommend that you set the StartTime and EndTime parameters to narrow down the time range and perform multiple queries to obtain data.
        
        @param request: GetVideoListRequest
        @return: GetVideoListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_video_list_with_options_async(request, runtime)

    def get_vod_packaging_asset_with_options(
        self,
        request: ice20201109_models.GetVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingAssetResponse:
        """
        @summary Queries a VOD packaging asset.
        
        @param request: GetVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingAssetResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_vod_packaging_asset_with_options_async(
        self,
        request: ice20201109_models.GetVodPackagingAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingAssetResponse:
        """
        @summary Queries a VOD packaging asset.
        
        @param request: GetVodPackagingAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_name):
            query['AssetName'] = request.asset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingAsset',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingAssetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_vod_packaging_asset(
        self,
        request: ice20201109_models.GetVodPackagingAssetRequest,
    ) -> ice20201109_models.GetVodPackagingAssetResponse:
        """
        @summary Queries a VOD packaging asset.
        
        @param request: GetVodPackagingAssetRequest
        @return: GetVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_vod_packaging_asset_with_options(request, runtime)

    async def get_vod_packaging_asset_async(
        self,
        request: ice20201109_models.GetVodPackagingAssetRequest,
    ) -> ice20201109_models.GetVodPackagingAssetResponse:
        """
        @summary Queries a VOD packaging asset.
        
        @param request: GetVodPackagingAssetRequest
        @return: GetVodPackagingAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_vod_packaging_asset_with_options_async(request, runtime)

    def get_vod_packaging_configuration_with_options(
        self,
        request: ice20201109_models.GetVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingConfigurationResponse:
        """
        @summary Queries a packaging configuration.
        
        @param request: GetVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_vod_packaging_configuration_with_options_async(
        self,
        request: ice20201109_models.GetVodPackagingConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingConfigurationResponse:
        """
        @summary Queries a packaging configuration.
        
        @param request: GetVodPackagingConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_name):
            query['ConfigurationName'] = request.configuration_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingConfiguration',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_vod_packaging_configuration(
        self,
        request: ice20201109_models.GetVodPackagingConfigurationRequest,
    ) -> ice20201109_models.GetVodPackagingConfigurationResponse:
        """
        @summary Queries a packaging configuration.
        
        @param request: GetVodPackagingConfigurationRequest
        @return: GetVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_vod_packaging_configuration_with_options(request, runtime)

    async def get_vod_packaging_configuration_async(
        self,
        request: ice20201109_models.GetVodPackagingConfigurationRequest,
    ) -> ice20201109_models.GetVodPackagingConfigurationResponse:
        """
        @summary Queries a packaging configuration.
        
        @param request: GetVodPackagingConfigurationRequest
        @return: GetVodPackagingConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_vod_packaging_configuration_with_options_async(request, runtime)

    def get_vod_packaging_group_with_options(
        self,
        request: ice20201109_models.GetVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingGroupResponse:
        """
        @summary Queries a packaging group.
        
        @param request: GetVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_vod_packaging_group_with_options_async(
        self,
        request: ice20201109_models.GetVodPackagingGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetVodPackagingGroupResponse:
        """
        @summary Queries a packaging group.
        
        @param request: GetVodPackagingGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVodPackagingGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetVodPackagingGroup',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetVodPackagingGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_vod_packaging_group(
        self,
        request: ice20201109_models.GetVodPackagingGroupRequest,
    ) -> ice20201109_models.GetVodPackagingGroupResponse:
        """
        @summary Queries a packaging group.
        
        @param request: GetVodPackagingGroupRequest
        @return: GetVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_vod_packaging_group_with_options(request, runtime)

    async def get_vod_packaging_group_async(
        self,
        request: ice20201109_models.GetVodPackagingGroupRequest,
    ) -> ice20201109_models.GetVodPackagingGroupResponse:
        """
        @summary Queries a packaging group.
        
        @param request: GetVodPackagingGroupRequest
        @return: GetVodPackagingGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_vod_packaging_group_with_options_async(request, runtime)

    def get_workflow_task_with_options(
        self,
        request: ice20201109_models.GetWorkflowTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetWorkflowTaskResponse:
        """
        @summary Queries the information about a workflow task by task ID, including the workflow ID and the status and result of the task. You can query only the workflow task data of the last year.
        
        @param request: GetWorkflowTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkflowTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkflowTask',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetWorkflowTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workflow_task_with_options_async(
        self,
        request: ice20201109_models.GetWorkflowTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.GetWorkflowTaskResponse:
        """
        @summary Queries the information about a workflow task by task ID, including the workflow ID and the status and result of the task. You can query only the workflow task data of the last year.
        
        @param request: GetWorkflowTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkflowTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkflowTask',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.GetWorkflowTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workflow_task(
        self,
        request: ice20201109_models.GetWorkflowTaskRequest,
    ) -> ice20201109_models.GetWorkflowTaskResponse:
        """
        @summary Queries the information about a workflow task by task ID, including the workflow ID and the status and result of the task. You can query only the workflow task data of the last year.
        
        @param request: GetWorkflowTaskRequest
        @return: GetWorkflowTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_workflow_task_with_options(request, runtime)

    async def get_workflow_task_async(
        self,
        request: ice20201109_models.GetWorkflowTaskRequest,
    ) -> ice20201109_models.GetWorkflowTaskResponse:
        """
        @summary Queries the information about a workflow task by task ID, including the workflow ID and the status and result of the task. You can query only the workflow task data of the last year.
        
        @param request: GetWorkflowTaskRequest
        @return: GetWorkflowTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_workflow_task_with_options_async(request, runtime)

    def insert_media_to_search_lib_with_options(
        self,
        request: ice20201109_models.InsertMediaToSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.InsertMediaToSearchLibResponse:
        """
        @summary Adds a media asset in a search library. Before you call this operation, you must create a search library.
        
        @param request: InsertMediaToSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InsertMediaToSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.images_input):
            query['ImagesInput'] = request.images_input
        if not UtilClient.is_unset(request.input):
            query['Input'] = request.input
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.msg_body):
            query['MsgBody'] = request.msg_body
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InsertMediaToSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.InsertMediaToSearchLibResponse(),
            self.call_api(params, req, runtime)
        )

    async def insert_media_to_search_lib_with_options_async(
        self,
        request: ice20201109_models.InsertMediaToSearchLibRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.InsertMediaToSearchLibResponse:
        """
        @summary Adds a media asset in a search library. Before you call this operation, you must create a search library.
        
        @param request: InsertMediaToSearchLibRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InsertMediaToSearchLibResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.images_input):
            query['ImagesInput'] = request.images_input
        if not UtilClient.is_unset(request.input):
            query['Input'] = request.input
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.msg_body):
            query['MsgBody'] = request.msg_body
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.search_lib_name):
            query['SearchLibName'] = request.search_lib_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InsertMediaToSearchLib',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.InsertMediaToSearchLibResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def insert_media_to_search_lib(
        self,
        request: ice20201109_models.InsertMediaToSearchLibRequest,
    ) -> ice20201109_models.InsertMediaToSearchLibResponse:
        """
        @summary Adds a media asset in a search library. Before you call this operation, you must create a search library.
        
        @param request: InsertMediaToSearchLibRequest
        @return: InsertMediaToSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.insert_media_to_search_lib_with_options(request, runtime)

    async def insert_media_to_search_lib_async(
        self,
        request: ice20201109_models.InsertMediaToSearchLibRequest,
    ) -> ice20201109_models.InsertMediaToSearchLibResponse:
        """
        @summary Adds a media asset in a search library. Before you call this operation, you must create a search library.
        
        @param request: InsertMediaToSearchLibRequest
        @return: InsertMediaToSearchLibResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.insert_media_to_search_lib_with_options_async(request, runtime)

    def list_aiagent_dialogues_with_options(
        self,
        request: ice20201109_models.ListAIAgentDialoguesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentDialoguesResponse:
        """
        @summary 列出智能体的对话历史记录。
        
        @param request: ListAIAgentDialoguesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentDialoguesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.round_limit):
            query['RoundLimit'] = request.round_limit
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentDialogues',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentDialoguesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_aiagent_dialogues_with_options_async(
        self,
        request: ice20201109_models.ListAIAgentDialoguesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentDialoguesResponse:
        """
        @summary 列出智能体的对话历史记录。
        
        @param request: ListAIAgentDialoguesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentDialoguesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.round_limit):
            query['RoundLimit'] = request.round_limit
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentDialogues',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentDialoguesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_aiagent_dialogues(
        self,
        request: ice20201109_models.ListAIAgentDialoguesRequest,
    ) -> ice20201109_models.ListAIAgentDialoguesResponse:
        """
        @summary 列出智能体的对话历史记录。
        
        @param request: ListAIAgentDialoguesRequest
        @return: ListAIAgentDialoguesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_aiagent_dialogues_with_options(request, runtime)

    async def list_aiagent_dialogues_async(
        self,
        request: ice20201109_models.ListAIAgentDialoguesRequest,
    ) -> ice20201109_models.ListAIAgentDialoguesResponse:
        """
        @summary 列出智能体的对话历史记录。
        
        @param request: ListAIAgentDialoguesRequest
        @return: ListAIAgentDialoguesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_aiagent_dialogues_with_options_async(request, runtime)

    def list_aiagent_instance_with_options(
        self,
        request: ice20201109_models.ListAIAgentInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentInstanceResponse:
        """
        @summary Queries a list of AI agents.
        
        @description ## [](#)Request description
        You can call this operation to query a list of AI agents based on the `AIAgentId`. The optional parameters include `StartTime`, `EndTime`, `PageSize`, and `PageNumber`. The returned result includes the status, runtime configurations, template configurations, custom information, and the URL of call log file for each AI agent.
        *Note**:
        The default value of `PageSize` is 10, and the default value of `PageNumber` is 1.
        
        @param request: ListAIAgentInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_aiagent_instance_with_options_async(
        self,
        request: ice20201109_models.ListAIAgentInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentInstanceResponse:
        """
        @summary Queries a list of AI agents.
        
        @description ## [](#)Request description
        You can call this operation to query a list of AI agents based on the `AIAgentId`. The optional parameters include `StartTime`, `EndTime`, `PageSize`, and `PageNumber`. The returned result includes the status, runtime configurations, template configurations, custom information, and the URL of call log file for each AI agent.
        *Note**:
        The default value of `PageSize` is 10, and the default value of `PageNumber` is 1.
        
        @param request: ListAIAgentInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aiagent_id):
            query['AIAgentId'] = request.aiagent_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentInstance',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_aiagent_instance(
        self,
        request: ice20201109_models.ListAIAgentInstanceRequest,
    ) -> ice20201109_models.ListAIAgentInstanceResponse:
        """
        @summary Queries a list of AI agents.
        
        @description ## [](#)Request description
        You can call this operation to query a list of AI agents based on the `AIAgentId`. The optional parameters include `StartTime`, `EndTime`, `PageSize`, and `PageNumber`. The returned result includes the status, runtime configurations, template configurations, custom information, and the URL of call log file for each AI agent.
        *Note**:
        The default value of `PageSize` is 10, and the default value of `PageNumber` is 1.
        
        @param request: ListAIAgentInstanceRequest
        @return: ListAIAgentInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_aiagent_instance_with_options(request, runtime)

    async def list_aiagent_instance_async(
        self,
        request: ice20201109_models.ListAIAgentInstanceRequest,
    ) -> ice20201109_models.ListAIAgentInstanceResponse:
        """
        @summary Queries a list of AI agents.
        
        @description ## [](#)Request description
        You can call this operation to query a list of AI agents based on the `AIAgentId`. The optional parameters include `StartTime`, `EndTime`, `PageSize`, and `PageNumber`. The returned result includes the status, runtime configurations, template configurations, custom information, and the URL of call log file for each AI agent.
        *Note**:
        The default value of `PageSize` is 10, and the default value of `PageNumber` is 1.
        
        @param request: ListAIAgentInstanceRequest
        @return: ListAIAgentInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_aiagent_instance_with_options_async(request, runtime)

    def list_aiagent_phone_number_with_options(
        self,
        request: ice20201109_models.ListAIAgentPhoneNumberRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentPhoneNumberResponse:
        """
        @summary 罗列用户电话资源接口
        
        @param request: ListAIAgentPhoneNumberRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentPhoneNumberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.number):
            query['Number'] = request.number
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentPhoneNumber',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentPhoneNumberResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_aiagent_phone_number_with_options_async(
        self,
        request: ice20201109_models.ListAIAgentPhoneNumberRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentPhoneNumberResponse:
        """
        @summary 罗列用户电话资源接口
        
        @param request: ListAIAgentPhoneNumberRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentPhoneNumberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.number):
            query['Number'] = request.number
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentPhoneNumber',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentPhoneNumberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_aiagent_phone_number(
        self,
        request: ice20201109_models.ListAIAgentPhoneNumberRequest,
    ) -> ice20201109_models.ListAIAgentPhoneNumberResponse:
        """
        @summary 罗列用户电话资源接口
        
        @param request: ListAIAgentPhoneNumberRequest
        @return: ListAIAgentPhoneNumberResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_aiagent_phone_number_with_options(request, runtime)

    async def list_aiagent_phone_number_async(
        self,
        request: ice20201109_models.ListAIAgentPhoneNumberRequest,
    ) -> ice20201109_models.ListAIAgentPhoneNumberResponse:
        """
        @summary 罗列用户电话资源接口
        
        @param request: ListAIAgentPhoneNumberRequest
        @return: ListAIAgentPhoneNumberResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_aiagent_phone_number_with_options_async(request, runtime)

    def list_aiagent_voiceprints_with_options(
        self,
        request: ice20201109_models.ListAIAgentVoiceprintsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentVoiceprintsResponse:
        """
        @summary 更新回调配置
        
        @param request: ListAIAgentVoiceprintsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentVoiceprintsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.voiceprint_id):
            query['VoiceprintId'] = request.voiceprint_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentVoiceprints',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentVoiceprintsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_aiagent_voiceprints_with_options_async(
        self,
        request: ice20201109_models.ListAIAgentVoiceprintsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAIAgentVoiceprintsResponse:
        """
        @summary 更新回调配置
        
        @param request: ListAIAgentVoiceprintsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAIAgentVoiceprintsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.voiceprint_id):
            query['VoiceprintId'] = request.voiceprint_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAIAgentVoiceprints',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAIAgentVoiceprintsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_aiagent_voiceprints(
        self,
        request: ice20201109_models.ListAIAgentVoiceprintsRequest,
    ) -> ice20201109_models.ListAIAgentVoiceprintsResponse:
        """
        @summary 更新回调配置
        
        @param request: ListAIAgentVoiceprintsRequest
        @return: ListAIAgentVoiceprintsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_aiagent_voiceprints_with_options(request, runtime)

    async def list_aiagent_voiceprints_async(
        self,
        request: ice20201109_models.ListAIAgentVoiceprintsRequest,
    ) -> ice20201109_models.ListAIAgentVoiceprintsResponse:
        """
        @summary 更新回调配置
        
        @param request: ListAIAgentVoiceprintsRequest
        @return: ListAIAgentVoiceprintsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_aiagent_voiceprints_with_options_async(request, runtime)

    def list_ad_insertions_with_options(
        self,
        request: ice20201109_models.ListAdInsertionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAdInsertionsResponse:
        """
        @summary Obtains ad insertion configurations.
        
        @param request: ListAdInsertionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAdInsertionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAdInsertions',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAdInsertionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ad_insertions_with_options_async(
        self,
        request: ice20201109_models.ListAdInsertionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAdInsertionsResponse:
        """
        @summary Obtains ad insertion configurations.
        
        @param request: ListAdInsertionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAdInsertionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAdInsertions',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAdInsertionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ad_insertions(
        self,
        request: ice20201109_models.ListAdInsertionsRequest,
    ) -> ice20201109_models.ListAdInsertionsResponse:
        """
        @summary Obtains ad insertion configurations.
        
        @param request: ListAdInsertionsRequest
        @return: ListAdInsertionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_ad_insertions_with_options(request, runtime)

    async def list_ad_insertions_async(
        self,
        request: ice20201109_models.ListAdInsertionsRequest,
    ) -> ice20201109_models.ListAdInsertionsResponse:
        """
        @summary Obtains ad insertion configurations.
        
        @param request: ListAdInsertionsRequest
        @return: ListAdInsertionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_ad_insertions_with_options_async(request, runtime)

    def list_alerts_with_options(
        self,
        request: ice20201109_models.ListAlertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAlertsResponse:
        """
        @summary Lists alerts received in MediaWeaver.
        
        @param request: ListAlertsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAlertsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.gmt_end):
            query['GmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            query['GmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_arn):
            query['ResourceArn'] = request.resource_arn
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAlerts',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAlertsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_alerts_with_options_async(
        self,
        request: ice20201109_models.ListAlertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAlertsResponse:
        """
        @summary Lists alerts received in MediaWeaver.
        
        @param request: ListAlertsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAlertsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.gmt_end):
            query['GmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            query['GmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_arn):
            query['ResourceArn'] = request.resource_arn
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAlerts',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAlertsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_alerts(
        self,
        request: ice20201109_models.ListAlertsRequest,
    ) -> ice20201109_models.ListAlertsResponse:
        """
        @summary Lists alerts received in MediaWeaver.
        
        @param request: ListAlertsRequest
        @return: ListAlertsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_alerts_with_options(request, runtime)

    async def list_alerts_async(
        self,
        request: ice20201109_models.ListAlertsRequest,
    ) -> ice20201109_models.ListAlertsResponse:
        """
        @summary Lists alerts received in MediaWeaver.
        
        @param request: ListAlertsRequest
        @return: ListAlertsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_alerts_with_options_async(request, runtime)

    def list_all_public_media_tags_with_options(
        self,
        request: ice20201109_models.ListAllPublicMediaTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAllPublicMediaTagsResponse:
        """
        @summary Queries a list of tags of media assets in the public media library.
        
        @param request: ListAllPublicMediaTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAllPublicMediaTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAllPublicMediaTags',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAllPublicMediaTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_all_public_media_tags_with_options_async(
        self,
        request: ice20201109_models.ListAllPublicMediaTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAllPublicMediaTagsResponse:
        """
        @summary Queries a list of tags of media assets in the public media library.
        
        @param request: ListAllPublicMediaTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAllPublicMediaTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAllPublicMediaTags',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAllPublicMediaTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_all_public_media_tags(
        self,
        request: ice20201109_models.ListAllPublicMediaTagsRequest,
    ) -> ice20201109_models.ListAllPublicMediaTagsResponse:
        """
        @summary Queries a list of tags of media assets in the public media library.
        
        @param request: ListAllPublicMediaTagsRequest
        @return: ListAllPublicMediaTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_all_public_media_tags_with_options(request, runtime)

    async def list_all_public_media_tags_async(
        self,
        request: ice20201109_models.ListAllPublicMediaTagsRequest,
    ) -> ice20201109_models.ListAllPublicMediaTagsResponse:
        """
        @summary Queries a list of tags of media assets in the public media library.
        
        @param request: ListAllPublicMediaTagsRequest
        @return: ListAllPublicMediaTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_all_public_media_tags_with_options_async(request, runtime)

    def list_avatar_training_jobs_with_options(
        self,
        request: ice20201109_models.ListAvatarTrainingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAvatarTrainingJobsResponse:
        """
        @summary Queries a list of digital human training jobs.
        
        @param request: ListAvatarTrainingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAvatarTrainingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAvatarTrainingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAvatarTrainingJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_avatar_training_jobs_with_options_async(
        self,
        request: ice20201109_models.ListAvatarTrainingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAvatarTrainingJobsResponse:
        """
        @summary Queries a list of digital human training jobs.
        
        @param request: ListAvatarTrainingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAvatarTrainingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAvatarTrainingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAvatarTrainingJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_avatar_training_jobs(
        self,
        request: ice20201109_models.ListAvatarTrainingJobsRequest,
    ) -> ice20201109_models.ListAvatarTrainingJobsResponse:
        """
        @summary Queries a list of digital human training jobs.
        
        @param request: ListAvatarTrainingJobsRequest
        @return: ListAvatarTrainingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_avatar_training_jobs_with_options(request, runtime)

    async def list_avatar_training_jobs_async(
        self,
        request: ice20201109_models.ListAvatarTrainingJobsRequest,
    ) -> ice20201109_models.ListAvatarTrainingJobsResponse:
        """
        @summary Queries a list of digital human training jobs.
        
        @param request: ListAvatarTrainingJobsRequest
        @return: ListAvatarTrainingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_avatar_training_jobs_with_options_async(request, runtime)

    def list_avatars_with_options(
        self,
        request: ice20201109_models.ListAvatarsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAvatarsResponse:
        """
        @summary Queries a list of trained digital humans.
        
        @param request: ListAvatarsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAvatarsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_type):
            query['AvatarType'] = request.avatar_type
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAvatars',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAvatarsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_avatars_with_options_async(
        self,
        request: ice20201109_models.ListAvatarsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListAvatarsResponse:
        """
        @summary Queries a list of trained digital humans.
        
        @param request: ListAvatarsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAvatarsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.avatar_type):
            query['AvatarType'] = request.avatar_type
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAvatars',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListAvatarsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_avatars(
        self,
        request: ice20201109_models.ListAvatarsRequest,
    ) -> ice20201109_models.ListAvatarsResponse:
        """
        @summary Queries a list of trained digital humans.
        
        @param request: ListAvatarsRequest
        @return: ListAvatarsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_avatars_with_options(request, runtime)

    async def list_avatars_async(
        self,
        request: ice20201109_models.ListAvatarsRequest,
    ) -> ice20201109_models.ListAvatarsResponse:
        """
        @summary Queries a list of trained digital humans.
        
        @param request: ListAvatarsRequest
        @return: ListAvatarsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_avatars_with_options_async(request, runtime)

    def list_batch_media_producing_jobs_with_options(
        self,
        request: ice20201109_models.ListBatchMediaProducingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListBatchMediaProducingJobsResponse:
        """
        @summary Queries a list of quick video production jobs based on conditions such as the job type and state.
        
        @param request: ListBatchMediaProducingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBatchMediaProducingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.job_type):
            query['JobType'] = request.job_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBatchMediaProducingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListBatchMediaProducingJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_batch_media_producing_jobs_with_options_async(
        self,
        request: ice20201109_models.ListBatchMediaProducingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListBatchMediaProducingJobsResponse:
        """
        @summary Queries a list of quick video production jobs based on conditions such as the job type and state.
        
        @param request: ListBatchMediaProducingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBatchMediaProducingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.job_type):
            query['JobType'] = request.job_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBatchMediaProducingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListBatchMediaProducingJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_batch_media_producing_jobs(
        self,
        request: ice20201109_models.ListBatchMediaProducingJobsRequest,
    ) -> ice20201109_models.ListBatchMediaProducingJobsResponse:
        """
        @summary Queries a list of quick video production jobs based on conditions such as the job type and state.
        
        @param request: ListBatchMediaProducingJobsRequest
        @return: ListBatchMediaProducingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_batch_media_producing_jobs_with_options(request, runtime)

    async def list_batch_media_producing_jobs_async(
        self,
        request: ice20201109_models.ListBatchMediaProducingJobsRequest,
    ) -> ice20201109_models.ListBatchMediaProducingJobsResponse:
        """
        @summary Queries a list of quick video production jobs based on conditions such as the job type and state.
        
        @param request: ListBatchMediaProducingJobsRequest
        @return: ListBatchMediaProducingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_batch_media_producing_jobs_with_options_async(request, runtime)

    def list_channel_alerts_with_options(
        self,
        request: ice20201109_models.ListChannelAlertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListChannelAlertsResponse:
        """
        @summary Lists alerts for resources in a MediaWeaver channel.
        
        @param request: ListChannelAlertsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChannelAlertsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.gmt_end):
            query['GmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            query['GmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_arn):
            query['ResourceArn'] = request.resource_arn
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChannelAlerts',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListChannelAlertsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_channel_alerts_with_options_async(
        self,
        request: ice20201109_models.ListChannelAlertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListChannelAlertsResponse:
        """
        @summary Lists alerts for resources in a MediaWeaver channel.
        
        @param request: ListChannelAlertsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChannelAlertsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.gmt_end):
            query['GmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            query['GmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_arn):
            query['ResourceArn'] = request.resource_arn
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChannelAlerts',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListChannelAlertsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_channel_alerts(
        self,
        request: ice20201109_models.ListChannelAlertsRequest,
    ) -> ice20201109_models.ListChannelAlertsResponse:
        """
        @summary Lists alerts for resources in a MediaWeaver channel.
        
        @param request: ListChannelAlertsRequest
        @return: ListChannelAlertsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_channel_alerts_with_options(request, runtime)

    async def list_channel_alerts_async(
        self,
        request: ice20201109_models.ListChannelAlertsRequest,
    ) -> ice20201109_models.ListChannelAlertsResponse:
        """
        @summary Lists alerts for resources in a MediaWeaver channel.
        
        @param request: ListChannelAlertsRequest
        @return: ListChannelAlertsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_channel_alerts_with_options_async(request, runtime)

    def list_channels_with_options(
        self,
        request: ice20201109_models.ListChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListChannelsResponse:
        """
        @summary Lists MediaWeaver channels.
        
        @param request: ListChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.channel_tier):
            query['ChannelTier'] = request.channel_tier
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.playback_mode):
            query['PlaybackMode'] = request.playback_mode
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        if not UtilClient.is_unset(request.state):
            query['State'] = request.state
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListChannelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_channels_with_options_async(
        self,
        request: ice20201109_models.ListChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListChannelsResponse:
        """
        @summary Lists MediaWeaver channels.
        
        @param request: ListChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.channel_tier):
            query['ChannelTier'] = request.channel_tier
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.playback_mode):
            query['PlaybackMode'] = request.playback_mode
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.sort_by_modified_time):
            query['SortByModifiedTime'] = request.sort_by_modified_time
        if not UtilClient.is_unset(request.state):
            query['State'] = request.state
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListChannelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_channels(
        self,
        request: ice20201109_models.ListChannelsRequest,
    ) -> ice20201109_models.ListChannelsResponse:
        """
        @summary Lists MediaWeaver channels.
        
        @param request: ListChannelsRequest
        @return: ListChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_channels_with_options(request, runtime)

    async def list_channels_async(
        self,
        request: ice20201109_models.ListChannelsRequest,
    ) -> ice20201109_models.ListChannelsResponse:
        """
        @summary Lists MediaWeaver channels.
        
        @param request: ListChannelsRequest
        @return: ListChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_channels_with_options_async(request, runtime)

    def list_custom_templates_with_options(
        self,
        request: ice20201109_models.ListCustomTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomTemplatesResponse:
        """
        @summary Queries a list of custom templates.
        
        @param request: ListCustomTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_custom_templates_with_options_async(
        self,
        request: ice20201109_models.ListCustomTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomTemplatesResponse:
        """
        @summary Queries a list of custom templates.
        
        @param request: ListCustomTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.subtype):
            query['Subtype'] = request.subtype
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_custom_templates(
        self,
        request: ice20201109_models.ListCustomTemplatesRequest,
    ) -> ice20201109_models.ListCustomTemplatesResponse:
        """
        @summary Queries a list of custom templates.
        
        @param request: ListCustomTemplatesRequest
        @return: ListCustomTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_custom_templates_with_options(request, runtime)

    async def list_custom_templates_async(
        self,
        request: ice20201109_models.ListCustomTemplatesRequest,
    ) -> ice20201109_models.ListCustomTemplatesResponse:
        """
        @summary Queries a list of custom templates.
        
        @param request: ListCustomTemplatesRequest
        @return: ListCustomTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_custom_templates_with_options_async(request, runtime)

    def list_customized_voice_jobs_with_options(
        self,
        request: ice20201109_models.ListCustomizedVoiceJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomizedVoiceJobsResponse:
        """
        @summary Queries a list of human voice cloning jobs.
        
        @param request: ListCustomizedVoiceJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomizedVoiceJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomizedVoiceJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomizedVoiceJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_customized_voice_jobs_with_options_async(
        self,
        request: ice20201109_models.ListCustomizedVoiceJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomizedVoiceJobsResponse:
        """
        @summary Queries a list of human voice cloning jobs.
        
        @param request: ListCustomizedVoiceJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomizedVoiceJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomizedVoiceJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomizedVoiceJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_customized_voice_jobs(
        self,
        request: ice20201109_models.ListCustomizedVoiceJobsRequest,
    ) -> ice20201109_models.ListCustomizedVoiceJobsResponse:
        """
        @summary Queries a list of human voice cloning jobs.
        
        @param request: ListCustomizedVoiceJobsRequest
        @return: ListCustomizedVoiceJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_customized_voice_jobs_with_options(request, runtime)

    async def list_customized_voice_jobs_async(
        self,
        request: ice20201109_models.ListCustomizedVoiceJobsRequest,
    ) -> ice20201109_models.ListCustomizedVoiceJobsResponse:
        """
        @summary Queries a list of human voice cloning jobs.
        
        @param request: ListCustomizedVoiceJobsRequest
        @return: ListCustomizedVoiceJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_customized_voice_jobs_with_options_async(request, runtime)

    def list_customized_voices_with_options(
        self,
        request: ice20201109_models.ListCustomizedVoicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomizedVoicesResponse:
        """
        @summary Queries a list of personalized human voices.
        
        @param request: ListCustomizedVoicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomizedVoicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomizedVoices',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomizedVoicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_customized_voices_with_options_async(
        self,
        request: ice20201109_models.ListCustomizedVoicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListCustomizedVoicesResponse:
        """
        @summary Queries a list of personalized human voices.
        
        @param request: ListCustomizedVoicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCustomizedVoicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCustomizedVoices',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListCustomizedVoicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_customized_voices(
        self,
        request: ice20201109_models.ListCustomizedVoicesRequest,
    ) -> ice20201109_models.ListCustomizedVoicesResponse:
        """
        @summary Queries a list of personalized human voices.
        
        @param request: ListCustomizedVoicesRequest
        @return: ListCustomizedVoicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_customized_voices_with_options(request, runtime)

    async def list_customized_voices_async(
        self,
        request: ice20201109_models.ListCustomizedVoicesRequest,
    ) -> ice20201109_models.ListCustomizedVoicesResponse:
        """
        @summary Queries a list of personalized human voices.
        
        @param request: ListCustomizedVoicesRequest
        @return: ListCustomizedVoicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_customized_voices_with_options_async(request, runtime)

    def list_dnadbwith_options(
        self,
        request: ice20201109_models.ListDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDNADBResponse:
        """
        @summary Queries a list of media fingerprint libraries.
        
        @param request: ListDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbids):
            query['DBIds'] = request.dbids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDNADBResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_dnadbwith_options_async(
        self,
        request: ice20201109_models.ListDNADBRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDNADBResponse:
        """
        @summary Queries a list of media fingerprint libraries.
        
        @param request: ListDNADBRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDNADBResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbids):
            query['DBIds'] = request.dbids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDNADB',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDNADBResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_dnadb(
        self,
        request: ice20201109_models.ListDNADBRequest,
    ) -> ice20201109_models.ListDNADBResponse:
        """
        @summary Queries a list of media fingerprint libraries.
        
        @param request: ListDNADBRequest
        @return: ListDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_dnadbwith_options(request, runtime)

    async def list_dnadb_async(
        self,
        request: ice20201109_models.ListDNADBRequest,
    ) -> ice20201109_models.ListDNADBResponse:
        """
        @summary Queries a list of media fingerprint libraries.
        
        @param request: ListDNADBRequest
        @return: ListDNADBResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_dnadbwith_options_async(request, runtime)

    def list_dnafiles_with_options(
        self,
        request: ice20201109_models.ListDNAFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDNAFilesResponse:
        """
        @summary Queries a list of files in a media fingerprint library.
        
        @description You can call this operation to query files in a media fingerprint library based on the library ID. The queried results can be paginated.
        
        @param request: ListDNAFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDNAFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDNAFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDNAFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_dnafiles_with_options_async(
        self,
        request: ice20201109_models.ListDNAFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDNAFilesResponse:
        """
        @summary Queries a list of files in a media fingerprint library.
        
        @description You can call this operation to query files in a media fingerprint library based on the library ID. The queried results can be paginated.
        
        @param request: ListDNAFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDNAFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dbid):
            query['DBId'] = request.dbid
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDNAFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDNAFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_dnafiles(
        self,
        request: ice20201109_models.ListDNAFilesRequest,
    ) -> ice20201109_models.ListDNAFilesResponse:
        """
        @summary Queries a list of files in a media fingerprint library.
        
        @description You can call this operation to query files in a media fingerprint library based on the library ID. The queried results can be paginated.
        
        @param request: ListDNAFilesRequest
        @return: ListDNAFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_dnafiles_with_options(request, runtime)

    async def list_dnafiles_async(
        self,
        request: ice20201109_models.ListDNAFilesRequest,
    ) -> ice20201109_models.ListDNAFilesResponse:
        """
        @summary Queries a list of files in a media fingerprint library.
        
        @description You can call this operation to query files in a media fingerprint library based on the library ID. The queried results can be paginated.
        
        @param request: ListDNAFilesRequest
        @return: ListDNAFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_dnafiles_with_options_async(request, runtime)

    def list_dynamic_image_jobs_with_options(
        self,
        request: ice20201109_models.ListDynamicImageJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDynamicImageJobsResponse:
        """
        @summary Queries a list of image animation jobs.
        
        @param request: ListDynamicImageJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDynamicImageJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDynamicImageJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDynamicImageJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_dynamic_image_jobs_with_options_async(
        self,
        request: ice20201109_models.ListDynamicImageJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListDynamicImageJobsResponse:
        """
        @summary Queries a list of image animation jobs.
        
        @param request: ListDynamicImageJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListDynamicImageJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListDynamicImageJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListDynamicImageJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_dynamic_image_jobs(
        self,
        request: ice20201109_models.ListDynamicImageJobsRequest,
    ) -> ice20201109_models.ListDynamicImageJobsResponse:
        """
        @summary Queries a list of image animation jobs.
        
        @param request: ListDynamicImageJobsRequest
        @return: ListDynamicImageJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_dynamic_image_jobs_with_options(request, runtime)

    async def list_dynamic_image_jobs_async(
        self,
        request: ice20201109_models.ListDynamicImageJobsRequest,
    ) -> ice20201109_models.ListDynamicImageJobsResponse:
        """
        @summary Queries a list of image animation jobs.
        
        @param request: ListDynamicImageJobsRequest
        @return: ListDynamicImageJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_dynamic_image_jobs_with_options_async(request, runtime)

    def list_editing_projects_with_options(
        self,
        request: ice20201109_models.ListEditingProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListEditingProjectsResponse:
        """
        @summary Queries a list of projects that meet the specified conditions. You can filter projects by project creation time.
        
        @param request: ListEditingProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEditingProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_source):
            query['CreateSource'] = request.create_source
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.project_type):
            query['ProjectType'] = request.project_type
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEditingProjects',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListEditingProjectsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_editing_projects_with_options_async(
        self,
        request: ice20201109_models.ListEditingProjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListEditingProjectsResponse:
        """
        @summary Queries a list of projects that meet the specified conditions. You can filter projects by project creation time.
        
        @param request: ListEditingProjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEditingProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_source):
            query['CreateSource'] = request.create_source
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.project_type):
            query['ProjectType'] = request.project_type
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.template_type):
            query['TemplateType'] = request.template_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEditingProjects',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListEditingProjectsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_editing_projects(
        self,
        request: ice20201109_models.ListEditingProjectsRequest,
    ) -> ice20201109_models.ListEditingProjectsResponse:
        """
        @summary Queries a list of projects that meet the specified conditions. You can filter projects by project creation time.
        
        @param request: ListEditingProjectsRequest
        @return: ListEditingProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_editing_projects_with_options(request, runtime)

    async def list_editing_projects_async(
        self,
        request: ice20201109_models.ListEditingProjectsRequest,
    ) -> ice20201109_models.ListEditingProjectsResponse:
        """
        @summary Queries a list of projects that meet the specified conditions. You can filter projects by project creation time.
        
        @param request: ListEditingProjectsRequest
        @return: ListEditingProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_editing_projects_with_options_async(request, runtime)

    def list_hotword_libraries_with_options(
        self,
        request: ice20201109_models.ListHotwordLibrariesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListHotwordLibrariesResponse:
        """
        @summary 查询所有热词库的列表
        
        @param request: ListHotwordLibrariesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListHotwordLibrariesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.usage_scenario):
            query['UsageScenario'] = request.usage_scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListHotwordLibraries',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListHotwordLibrariesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_hotword_libraries_with_options_async(
        self,
        request: ice20201109_models.ListHotwordLibrariesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListHotwordLibrariesResponse:
        """
        @summary 查询所有热词库的列表
        
        @param request: ListHotwordLibrariesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListHotwordLibrariesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.usage_scenario):
            query['UsageScenario'] = request.usage_scenario
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListHotwordLibraries',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListHotwordLibrariesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_hotword_libraries(
        self,
        request: ice20201109_models.ListHotwordLibrariesRequest,
    ) -> ice20201109_models.ListHotwordLibrariesResponse:
        """
        @summary 查询所有热词库的列表
        
        @param request: ListHotwordLibrariesRequest
        @return: ListHotwordLibrariesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_hotword_libraries_with_options(request, runtime)

    async def list_hotword_libraries_async(
        self,
        request: ice20201109_models.ListHotwordLibrariesRequest,
    ) -> ice20201109_models.ListHotwordLibrariesResponse:
        """
        @summary 查询所有热词库的列表
        
        @param request: ListHotwordLibrariesRequest
        @return: ListHotwordLibrariesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_hotword_libraries_with_options_async(request, runtime)

    def list_live_package_channel_groups_with_options(
        self,
        request: ice20201109_models.ListLivePackageChannelGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageChannelGroupsResponse:
        """
        @summary Queries live package channel groups by page. Fuzzy search by name or description and sorting are supported.
        
        @description ## [](#)Usage notes
        
        @param request: ListLivePackageChannelGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageChannelGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageChannelGroups',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageChannelGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_package_channel_groups_with_options_async(
        self,
        request: ice20201109_models.ListLivePackageChannelGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageChannelGroupsResponse:
        """
        @summary Queries live package channel groups by page. Fuzzy search by name or description and sorting are supported.
        
        @description ## [](#)Usage notes
        
        @param request: ListLivePackageChannelGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageChannelGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageChannelGroups',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageChannelGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_package_channel_groups(
        self,
        request: ice20201109_models.ListLivePackageChannelGroupsRequest,
    ) -> ice20201109_models.ListLivePackageChannelGroupsResponse:
        """
        @summary Queries live package channel groups by page. Fuzzy search by name or description and sorting are supported.
        
        @description ## [](#)Usage notes
        
        @param request: ListLivePackageChannelGroupsRequest
        @return: ListLivePackageChannelGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_package_channel_groups_with_options(request, runtime)

    async def list_live_package_channel_groups_async(
        self,
        request: ice20201109_models.ListLivePackageChannelGroupsRequest,
    ) -> ice20201109_models.ListLivePackageChannelGroupsResponse:
        """
        @summary Queries live package channel groups by page. Fuzzy search by name or description and sorting are supported.
        
        @description ## [](#)Usage notes
        
        @param request: ListLivePackageChannelGroupsRequest
        @return: ListLivePackageChannelGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_package_channel_groups_with_options_async(request, runtime)

    def list_live_package_channels_with_options(
        self,
        request: ice20201109_models.ListLivePackageChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageChannelsResponse:
        """
        @summary Queries live package channels by channel group and keyword. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query live package channels by *GroupName** and **Keyword**. Keyword is optional. You can sort the channels by creation time in ascending or descending order and paginate the results. This facilitates the management of channels and retrieval of channel information.
        **GroupName** is required to specify the channel group to which the channel belongs.
        **Keyword** supports fuzzy match of channel names or descriptions, which helps quickly filter desired channels.
        **PageNo** and **PageSize** can help control the paging of returned results to facilitate batch processing of data.
        **SortBy** allows you to customize how the results are sorted. By default, the results are sorted in descending order.
        *RequestId** in the response is used for subsequent troubleshooting. **TotalCount** indicates the total number of channels that meet the conditions.
        
        @param request: ListLivePackageChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageChannelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_package_channels_with_options_async(
        self,
        request: ice20201109_models.ListLivePackageChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageChannelsResponse:
        """
        @summary Queries live package channels by channel group and keyword. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query live package channels by *GroupName** and **Keyword**. Keyword is optional. You can sort the channels by creation time in ascending or descending order and paginate the results. This facilitates the management of channels and retrieval of channel information.
        **GroupName** is required to specify the channel group to which the channel belongs.
        **Keyword** supports fuzzy match of channel names or descriptions, which helps quickly filter desired channels.
        **PageNo** and **PageSize** can help control the paging of returned results to facilitate batch processing of data.
        **SortBy** allows you to customize how the results are sorted. By default, the results are sorted in descending order.
        *RequestId** in the response is used for subsequent troubleshooting. **TotalCount** indicates the total number of channels that meet the conditions.
        
        @param request: ListLivePackageChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageChannelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageChannelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_package_channels(
        self,
        request: ice20201109_models.ListLivePackageChannelsRequest,
    ) -> ice20201109_models.ListLivePackageChannelsResponse:
        """
        @summary Queries live package channels by channel group and keyword. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query live package channels by *GroupName** and **Keyword**. Keyword is optional. You can sort the channels by creation time in ascending or descending order and paginate the results. This facilitates the management of channels and retrieval of channel information.
        **GroupName** is required to specify the channel group to which the channel belongs.
        **Keyword** supports fuzzy match of channel names or descriptions, which helps quickly filter desired channels.
        **PageNo** and **PageSize** can help control the paging of returned results to facilitate batch processing of data.
        **SortBy** allows you to customize how the results are sorted. By default, the results are sorted in descending order.
        *RequestId** in the response is used for subsequent troubleshooting. **TotalCount** indicates the total number of channels that meet the conditions.
        
        @param request: ListLivePackageChannelsRequest
        @return: ListLivePackageChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_package_channels_with_options(request, runtime)

    async def list_live_package_channels_async(
        self,
        request: ice20201109_models.ListLivePackageChannelsRequest,
    ) -> ice20201109_models.ListLivePackageChannelsResponse:
        """
        @summary Queries live package channels by channel group and keyword. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query live package channels by *GroupName** and **Keyword**. Keyword is optional. You can sort the channels by creation time in ascending or descending order and paginate the results. This facilitates the management of channels and retrieval of channel information.
        **GroupName** is required to specify the channel group to which the channel belongs.
        **Keyword** supports fuzzy match of channel names or descriptions, which helps quickly filter desired channels.
        **PageNo** and **PageSize** can help control the paging of returned results to facilitate batch processing of data.
        **SortBy** allows you to customize how the results are sorted. By default, the results are sorted in descending order.
        *RequestId** in the response is used for subsequent troubleshooting. **TotalCount** indicates the total number of channels that meet the conditions.
        
        @param request: ListLivePackageChannelsRequest
        @return: ListLivePackageChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_package_channels_with_options_async(request, runtime)

    def list_live_package_origin_endpoints_with_options(
        self,
        request: ice20201109_models.ListLivePackageOriginEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageOriginEndpointsResponse:
        """
        @summary Queries origin endpoints by channel group and channel name. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query origin endpoints associated with a live package channel. The results include detailed configurations about the origin endpoints, such as access URL, protocol, and security policies. Paging and sorting by creation time are supported.
        
        @param request: ListLivePackageOriginEndpointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageOriginEndpointsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageOriginEndpoints',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageOriginEndpointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_package_origin_endpoints_with_options_async(
        self,
        request: ice20201109_models.ListLivePackageOriginEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLivePackageOriginEndpointsResponse:
        """
        @summary Queries origin endpoints by channel group and channel name. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query origin endpoints associated with a live package channel. The results include detailed configurations about the origin endpoints, such as access URL, protocol, and security policies. Paging and sorting by creation time are supported.
        
        @param request: ListLivePackageOriginEndpointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLivePackageOriginEndpointsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLivePackageOriginEndpoints',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLivePackageOriginEndpointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_package_origin_endpoints(
        self,
        request: ice20201109_models.ListLivePackageOriginEndpointsRequest,
    ) -> ice20201109_models.ListLivePackageOriginEndpointsResponse:
        """
        @summary Queries origin endpoints by channel group and channel name. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query origin endpoints associated with a live package channel. The results include detailed configurations about the origin endpoints, such as access URL, protocol, and security policies. Paging and sorting by creation time are supported.
        
        @param request: ListLivePackageOriginEndpointsRequest
        @return: ListLivePackageOriginEndpointsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_package_origin_endpoints_with_options(request, runtime)

    async def list_live_package_origin_endpoints_async(
        self,
        request: ice20201109_models.ListLivePackageOriginEndpointsRequest,
    ) -> ice20201109_models.ListLivePackageOriginEndpointsResponse:
        """
        @summary Queries origin endpoints by channel group and channel name. Paging and sorting are supported.
        
        @description ## [](#)Usage notes
        This API operation allows you to query origin endpoints associated with a live package channel. The results include detailed configurations about the origin endpoints, such as access URL, protocol, and security policies. Paging and sorting by creation time are supported.
        
        @param request: ListLivePackageOriginEndpointsRequest
        @return: ListLivePackageOriginEndpointsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_package_origin_endpoints_with_options_async(request, runtime)

    def list_live_record_files_with_options(
        self,
        request: ice20201109_models.ListLiveRecordFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordFilesResponse:
        """
        @summary Queries all recording index files in the specified period of time.
        
        @param request: ListLiveRecordFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordFilesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_record_files_with_options_async(
        self,
        request: ice20201109_models.ListLiveRecordFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordFilesResponse:
        """
        @summary Queries all recording index files in the specified period of time.
        
        @param request: ListLiveRecordFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordFilesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_record_files(
        self,
        request: ice20201109_models.ListLiveRecordFilesRequest,
    ) -> ice20201109_models.ListLiveRecordFilesResponse:
        """
        @summary Queries all recording index files in the specified period of time.
        
        @param request: ListLiveRecordFilesRequest
        @return: ListLiveRecordFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_record_files_with_options(request, runtime)

    async def list_live_record_files_async(
        self,
        request: ice20201109_models.ListLiveRecordFilesRequest,
    ) -> ice20201109_models.ListLiveRecordFilesResponse:
        """
        @summary Queries all recording index files in the specified period of time.
        
        @param request: ListLiveRecordFilesRequest
        @return: ListLiveRecordFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_record_files_with_options_async(request, runtime)

    def list_live_record_jobs_with_options(
        self,
        request: ice20201109_models.ListLiveRecordJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordJobsResponse:
        """
        @summary Queries a list of live stream recording jobs by page.
        
        @param request: ListLiveRecordJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordJobsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_record_jobs_with_options_async(
        self,
        request: ice20201109_models.ListLiveRecordJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordJobsResponse:
        """
        @summary Queries a list of live stream recording jobs by page.
        
        @param request: ListLiveRecordJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordJobsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_record_jobs(
        self,
        request: ice20201109_models.ListLiveRecordJobsRequest,
    ) -> ice20201109_models.ListLiveRecordJobsResponse:
        """
        @summary Queries a list of live stream recording jobs by page.
        
        @param request: ListLiveRecordJobsRequest
        @return: ListLiveRecordJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_record_jobs_with_options(request, runtime)

    async def list_live_record_jobs_async(
        self,
        request: ice20201109_models.ListLiveRecordJobsRequest,
    ) -> ice20201109_models.ListLiveRecordJobsResponse:
        """
        @summary Queries a list of live stream recording jobs by page.
        
        @param request: ListLiveRecordJobsRequest
        @return: ListLiveRecordJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_record_jobs_with_options_async(request, runtime)

    def list_live_record_templates_with_options(
        self,
        request: ice20201109_models.ListLiveRecordTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordTemplatesResponse:
        """
        @summary Queries a list of live stream recording templates.
        
        @param request: ListLiveRecordTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_record_templates_with_options_async(
        self,
        request: ice20201109_models.ListLiveRecordTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveRecordTemplatesResponse:
        """
        @summary Queries a list of live stream recording templates.
        
        @param request: ListLiveRecordTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveRecordTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveRecordTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveRecordTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_record_templates(
        self,
        request: ice20201109_models.ListLiveRecordTemplatesRequest,
    ) -> ice20201109_models.ListLiveRecordTemplatesResponse:
        """
        @summary Queries a list of live stream recording templates.
        
        @param request: ListLiveRecordTemplatesRequest
        @return: ListLiveRecordTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_record_templates_with_options(request, runtime)

    async def list_live_record_templates_async(
        self,
        request: ice20201109_models.ListLiveRecordTemplatesRequest,
    ) -> ice20201109_models.ListLiveRecordTemplatesResponse:
        """
        @summary Queries a list of live stream recording templates.
        
        @param request: ListLiveRecordTemplatesRequest
        @return: ListLiveRecordTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_record_templates_with_options_async(request, runtime)

    def list_live_snapshot_files_with_options(
        self,
        request: ice20201109_models.ListLiveSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotFilesResponse:
        """
        @summary Queries a list of live stream snapshot files by page.
        
        @param request: ListLiveSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotFilesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_snapshot_files_with_options_async(
        self,
        request: ice20201109_models.ListLiveSnapshotFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotFilesResponse:
        """
        @summary Queries a list of live stream snapshot files by page.
        
        @param request: ListLiveSnapshotFilesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotFilesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotFiles',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_snapshot_files(
        self,
        request: ice20201109_models.ListLiveSnapshotFilesRequest,
    ) -> ice20201109_models.ListLiveSnapshotFilesResponse:
        """
        @summary Queries a list of live stream snapshot files by page.
        
        @param request: ListLiveSnapshotFilesRequest
        @return: ListLiveSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_snapshot_files_with_options(request, runtime)

    async def list_live_snapshot_files_async(
        self,
        request: ice20201109_models.ListLiveSnapshotFilesRequest,
    ) -> ice20201109_models.ListLiveSnapshotFilesResponse:
        """
        @summary Queries a list of live stream snapshot files by page.
        
        @param request: ListLiveSnapshotFilesRequest
        @return: ListLiveSnapshotFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_snapshot_files_with_options_async(request, runtime)

    def list_live_snapshot_jobs_with_options(
        self,
        request: ice20201109_models.ListLiveSnapshotJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotJobsResponse:
        """
        @summary Queries a list of live stream snapshot jobs by page.
        
        @param request: ListLiveSnapshotJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotJobsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_snapshot_jobs_with_options_async(
        self,
        request: ice20201109_models.ListLiveSnapshotJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotJobsResponse:
        """
        @summary Queries a list of live stream snapshot jobs by page.
        
        @param request: ListLiveSnapshotJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotJobsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_snapshot_jobs(
        self,
        request: ice20201109_models.ListLiveSnapshotJobsRequest,
    ) -> ice20201109_models.ListLiveSnapshotJobsResponse:
        """
        @summary Queries a list of live stream snapshot jobs by page.
        
        @param request: ListLiveSnapshotJobsRequest
        @return: ListLiveSnapshotJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_snapshot_jobs_with_options(request, runtime)

    async def list_live_snapshot_jobs_async(
        self,
        request: ice20201109_models.ListLiveSnapshotJobsRequest,
    ) -> ice20201109_models.ListLiveSnapshotJobsResponse:
        """
        @summary Queries a list of live stream snapshot jobs by page.
        
        @param request: ListLiveSnapshotJobsRequest
        @return: ListLiveSnapshotJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_snapshot_jobs_with_options_async(request, runtime)

    def list_live_snapshot_templates_with_options(
        self,
        request: ice20201109_models.ListLiveSnapshotTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotTemplatesResponse:
        """
        @summary Queries a list of live stream snapshot templates by page.
        
        @param request: ListLiveSnapshotTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_snapshot_templates_with_options_async(
        self,
        request: ice20201109_models.ListLiveSnapshotTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveSnapshotTemplatesResponse:
        """
        @summary Queries a list of live stream snapshot templates by page.
        
        @param request: ListLiveSnapshotTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveSnapshotTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveSnapshotTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveSnapshotTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_snapshot_templates(
        self,
        request: ice20201109_models.ListLiveSnapshotTemplatesRequest,
    ) -> ice20201109_models.ListLiveSnapshotTemplatesResponse:
        """
        @summary Queries a list of live stream snapshot templates by page.
        
        @param request: ListLiveSnapshotTemplatesRequest
        @return: ListLiveSnapshotTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_snapshot_templates_with_options(request, runtime)

    async def list_live_snapshot_templates_async(
        self,
        request: ice20201109_models.ListLiveSnapshotTemplatesRequest,
    ) -> ice20201109_models.ListLiveSnapshotTemplatesResponse:
        """
        @summary Queries a list of live stream snapshot templates by page.
        
        @param request: ListLiveSnapshotTemplatesRequest
        @return: ListLiveSnapshotTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_snapshot_templates_with_options_async(request, runtime)

    def list_live_transcode_jobs_with_options(
        self,
        request: ice20201109_models.ListLiveTranscodeJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveTranscodeJobsResponse:
        """
        @summary Queries a list of live stream transcoding jobs.
        
        @param request: ListLiveTranscodeJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveTranscodeJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_word):
            query['KeyWord'] = request.key_word
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_mode):
            query['StartMode'] = request.start_mode
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveTranscodeJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveTranscodeJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_transcode_jobs_with_options_async(
        self,
        request: ice20201109_models.ListLiveTranscodeJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveTranscodeJobsResponse:
        """
        @summary Queries a list of live stream transcoding jobs.
        
        @param request: ListLiveTranscodeJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveTranscodeJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_word):
            query['KeyWord'] = request.key_word
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_mode):
            query['StartMode'] = request.start_mode
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveTranscodeJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveTranscodeJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_transcode_jobs(
        self,
        request: ice20201109_models.ListLiveTranscodeJobsRequest,
    ) -> ice20201109_models.ListLiveTranscodeJobsResponse:
        """
        @summary Queries a list of live stream transcoding jobs.
        
        @param request: ListLiveTranscodeJobsRequest
        @return: ListLiveTranscodeJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_transcode_jobs_with_options(request, runtime)

    async def list_live_transcode_jobs_async(
        self,
        request: ice20201109_models.ListLiveTranscodeJobsRequest,
    ) -> ice20201109_models.ListLiveTranscodeJobsResponse:
        """
        @summary Queries a list of live stream transcoding jobs.
        
        @param request: ListLiveTranscodeJobsRequest
        @return: ListLiveTranscodeJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_transcode_jobs_with_options_async(request, runtime)

    def list_live_transcode_templates_with_options(
        self,
        request: ice20201109_models.ListLiveTranscodeTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveTranscodeTemplatesResponse:
        """
        @summary Queries a list of live stream transcoding templates.
        
        @param request: ListLiveTranscodeTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveTranscodeTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.key_word):
            query['KeyWord'] = request.key_word
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.video_codec):
            query['VideoCodec'] = request.video_codec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveTranscodeTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveTranscodeTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_live_transcode_templates_with_options_async(
        self,
        request: ice20201109_models.ListLiveTranscodeTemplatesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListLiveTranscodeTemplatesResponse:
        """
        @summary Queries a list of live stream transcoding templates.
        
        @param request: ListLiveTranscodeTemplatesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListLiveTranscodeTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.key_word):
            query['KeyWord'] = request.key_word
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.video_codec):
            query['VideoCodec'] = request.video_codec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListLiveTranscodeTemplates',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListLiveTranscodeTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_live_transcode_templates(
        self,
        request: ice20201109_models.ListLiveTranscodeTemplatesRequest,
    ) -> ice20201109_models.ListLiveTranscodeTemplatesResponse:
        """
        @summary Queries a list of live stream transcoding templates.
        
        @param request: ListLiveTranscodeTemplatesRequest
        @return: ListLiveTranscodeTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_live_transcode_templates_with_options(request, runtime)

    async def list_live_transcode_templates_async(
        self,
        request: ice20201109_models.ListLiveTranscodeTemplatesRequest,
    ) -> ice20201109_models.ListLiveTranscodeTemplatesResponse:
        """
        @summary Queries a list of live stream transcoding templates.
        
        @param request: ListLiveTranscodeTemplatesRequest
        @return: ListLiveTranscodeTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_live_transcode_templates_with_options_async(request, runtime)

    def list_media_basic_infos_with_options(
        self,
        request: ice20201109_models.ListMediaBasicInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaBasicInfosResponse:
        """
        @summary Queries the basic information of all media assets that meet the specified conditions.
        
        @description If includeFileBasicInfo is set to true, the basic information, such as the duration and file size, of the source file is also returned. At most the first 100 entries that meet the specified conditions are returned. All media assets must exactly match all non-empty fields. The fields that support exact match include MediaType, Source, BusinessType, Category, and Status. If all information cannot be returned at a time, you can use NextToken to initiate a request to retrieve a new page of results.
        
        @param request: ListMediaBasicInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaBasicInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.include_file_basic_info):
            query['IncludeFileBasicInfo'] = request.include_file_basic_info
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaBasicInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaBasicInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_basic_infos_with_options_async(
        self,
        request: ice20201109_models.ListMediaBasicInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaBasicInfosResponse:
        """
        @summary Queries the basic information of all media assets that meet the specified conditions.
        
        @description If includeFileBasicInfo is set to true, the basic information, such as the duration and file size, of the source file is also returned. At most the first 100 entries that meet the specified conditions are returned. All media assets must exactly match all non-empty fields. The fields that support exact match include MediaType, Source, BusinessType, Category, and Status. If all information cannot be returned at a time, you can use NextToken to initiate a request to retrieve a new page of results.
        
        @param request: ListMediaBasicInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaBasicInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_timeout):
            query['AuthTimeout'] = request.auth_timeout
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.include_file_basic_info):
            query['IncludeFileBasicInfo'] = request.include_file_basic_info
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_type):
            query['MediaType'] = request.media_type
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaBasicInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaBasicInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_basic_infos(
        self,
        request: ice20201109_models.ListMediaBasicInfosRequest,
    ) -> ice20201109_models.ListMediaBasicInfosResponse:
        """
        @summary Queries the basic information of all media assets that meet the specified conditions.
        
        @description If includeFileBasicInfo is set to true, the basic information, such as the duration and file size, of the source file is also returned. At most the first 100 entries that meet the specified conditions are returned. All media assets must exactly match all non-empty fields. The fields that support exact match include MediaType, Source, BusinessType, Category, and Status. If all information cannot be returned at a time, you can use NextToken to initiate a request to retrieve a new page of results.
        
        @param request: ListMediaBasicInfosRequest
        @return: ListMediaBasicInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_basic_infos_with_options(request, runtime)

    async def list_media_basic_infos_async(
        self,
        request: ice20201109_models.ListMediaBasicInfosRequest,
    ) -> ice20201109_models.ListMediaBasicInfosResponse:
        """
        @summary Queries the basic information of all media assets that meet the specified conditions.
        
        @description If includeFileBasicInfo is set to true, the basic information, such as the duration and file size, of the source file is also returned. At most the first 100 entries that meet the specified conditions are returned. All media assets must exactly match all non-empty fields. The fields that support exact match include MediaType, Source, BusinessType, Category, and Status. If all information cannot be returned at a time, you can use NextToken to initiate a request to retrieve a new page of results.
        
        @param request: ListMediaBasicInfosRequest
        @return: ListMediaBasicInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_basic_infos_with_options_async(request, runtime)

    def list_media_convert_jobs_with_options(
        self,
        request: ice20201109_models.ListMediaConvertJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaConvertJobsResponse:
        """
        @summary 查询 MediaConvertJob 列表
        
        @param request: ListMediaConvertJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaConvertJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaConvertJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaConvertJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_convert_jobs_with_options_async(
        self,
        request: ice20201109_models.ListMediaConvertJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaConvertJobsResponse:
        """
        @summary 查询 MediaConvertJob 列表
        
        @param request: ListMediaConvertJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaConvertJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaConvertJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaConvertJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_convert_jobs(
        self,
        request: ice20201109_models.ListMediaConvertJobsRequest,
    ) -> ice20201109_models.ListMediaConvertJobsResponse:
        """
        @summary 查询 MediaConvertJob 列表
        
        @param request: ListMediaConvertJobsRequest
        @return: ListMediaConvertJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_convert_jobs_with_options(request, runtime)

    async def list_media_convert_jobs_async(
        self,
        request: ice20201109_models.ListMediaConvertJobsRequest,
    ) -> ice20201109_models.ListMediaConvertJobsResponse:
        """
        @summary 查询 MediaConvertJob 列表
        
        @param request: ListMediaConvertJobsRequest
        @return: ListMediaConvertJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_convert_jobs_with_options_async(request, runtime)

    def list_media_info_jobs_with_options(
        self,
        request: ice20201109_models.ListMediaInfoJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaInfoJobsResponse:
        """
        @summary Queries a list of media information analysis jobs.
        
        @param request: ListMediaInfoJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaInfoJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaInfoJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaInfoJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_info_jobs_with_options_async(
        self,
        request: ice20201109_models.ListMediaInfoJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaInfoJobsResponse:
        """
        @summary Queries a list of media information analysis jobs.
        
        @param request: ListMediaInfoJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaInfoJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaInfoJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaInfoJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_info_jobs(
        self,
        request: ice20201109_models.ListMediaInfoJobsRequest,
    ) -> ice20201109_models.ListMediaInfoJobsResponse:
        """
        @summary Queries a list of media information analysis jobs.
        
        @param request: ListMediaInfoJobsRequest
        @return: ListMediaInfoJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_info_jobs_with_options(request, runtime)

    async def list_media_info_jobs_async(
        self,
        request: ice20201109_models.ListMediaInfoJobsRequest,
    ) -> ice20201109_models.ListMediaInfoJobsResponse:
        """
        @summary Queries a list of media information analysis jobs.
        
        @param request: ListMediaInfoJobsRequest
        @return: ListMediaInfoJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_info_jobs_with_options_async(request, runtime)

    def list_media_live_channels_with_options(
        self,
        request: ice20201109_models.ListMediaLiveChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveChannelsResponse:
        """
        @summary Queries MediaLive channels.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveChannelsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        if not UtilClient.is_unset(request.states):
            body['States'] = request.states
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveChannelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_live_channels_with_options_async(
        self,
        request: ice20201109_models.ListMediaLiveChannelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveChannelsResponse:
        """
        @summary Queries MediaLive channels.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveChannelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveChannelsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        if not UtilClient.is_unset(request.states):
            body['States'] = request.states
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveChannels',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveChannelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_live_channels(
        self,
        request: ice20201109_models.ListMediaLiveChannelsRequest,
    ) -> ice20201109_models.ListMediaLiveChannelsResponse:
        """
        @summary Queries MediaLive channels.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveChannelsRequest
        @return: ListMediaLiveChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_live_channels_with_options(request, runtime)

    async def list_media_live_channels_async(
        self,
        request: ice20201109_models.ListMediaLiveChannelsRequest,
    ) -> ice20201109_models.ListMediaLiveChannelsResponse:
        """
        @summary Queries MediaLive channels.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveChannelsRequest
        @return: ListMediaLiveChannelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_live_channels_with_options_async(request, runtime)

    def list_media_live_input_security_groups_with_options(
        self,
        request: ice20201109_models.ListMediaLiveInputSecurityGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveInputSecurityGroupsResponse:
        """
        @summary Queries the security groups in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputSecurityGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveInputSecurityGroupsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveInputSecurityGroups',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveInputSecurityGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_live_input_security_groups_with_options_async(
        self,
        request: ice20201109_models.ListMediaLiveInputSecurityGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveInputSecurityGroupsResponse:
        """
        @summary Queries the security groups in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputSecurityGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveInputSecurityGroupsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveInputSecurityGroups',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveInputSecurityGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_live_input_security_groups(
        self,
        request: ice20201109_models.ListMediaLiveInputSecurityGroupsRequest,
    ) -> ice20201109_models.ListMediaLiveInputSecurityGroupsResponse:
        """
        @summary Queries the security groups in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputSecurityGroupsRequest
        @return: ListMediaLiveInputSecurityGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_live_input_security_groups_with_options(request, runtime)

    async def list_media_live_input_security_groups_async(
        self,
        request: ice20201109_models.ListMediaLiveInputSecurityGroupsRequest,
    ) -> ice20201109_models.ListMediaLiveInputSecurityGroupsResponse:
        """
        @summary Queries the security groups in MediaLive.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputSecurityGroupsRequest
        @return: ListMediaLiveInputSecurityGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_live_input_security_groups_with_options_async(request, runtime)

    def list_media_live_inputs_with_options(
        self,
        request: ice20201109_models.ListMediaLiveInputsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveInputsResponse:
        """
        @summary Queries MediaLive inputs.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveInputsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        if not UtilClient.is_unset(request.types):
            body['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveInputs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveInputsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_live_inputs_with_options_async(
        self,
        request: ice20201109_models.ListMediaLiveInputsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaLiveInputsResponse:
        """
        @summary Queries MediaLive inputs.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaLiveInputsResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.max_results):
            body['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.skip):
            body['Skip'] = request.skip
        if not UtilClient.is_unset(request.sort_order):
            body['SortOrder'] = request.sort_order
        if not UtilClient.is_unset(request.types):
            body['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMediaLiveInputs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaLiveInputsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_live_inputs(
        self,
        request: ice20201109_models.ListMediaLiveInputsRequest,
    ) -> ice20201109_models.ListMediaLiveInputsResponse:
        """
        @summary Queries MediaLive inputs.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputsRequest
        @return: ListMediaLiveInputsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_live_inputs_with_options(request, runtime)

    async def list_media_live_inputs_async(
        self,
        request: ice20201109_models.ListMediaLiveInputsRequest,
    ) -> ice20201109_models.ListMediaLiveInputsResponse:
        """
        @summary Queries MediaLive inputs.
        
        @description ## QPS limit
        This operation can be called up to 50 times per second for each Alibaba Cloud account. Requests that exceed this limit are dropped and you may experience service interruptions. We recommend that you take note of this limit when you call this operation.
        
        @param request: ListMediaLiveInputsRequest
        @return: ListMediaLiveInputsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_live_inputs_with_options_async(request, runtime)

    def list_media_marks_with_options(
        self,
        request: ice20201109_models.ListMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaMarksResponse:
        """
        @summary Queries a list of marks of a media asset.
        
        @param request: ListMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaMarksResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_marks_with_options_async(
        self,
        request: ice20201109_models.ListMediaMarksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaMarksResponse:
        """
        @summary Queries a list of marks of a media asset.
        
        @param request: ListMediaMarksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaMarksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.media_id):
            query['MediaId'] = request.media_id
        if not UtilClient.is_unset(request.media_mark_ids):
            query['MediaMarkIds'] = request.media_mark_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaMarks',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaMarksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_marks(
        self,
        request: ice20201109_models.ListMediaMarksRequest,
    ) -> ice20201109_models.ListMediaMarksResponse:
        """
        @summary Queries a list of marks of a media asset.
        
        @param request: ListMediaMarksRequest
        @return: ListMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_marks_with_options(request, runtime)

    async def list_media_marks_async(
        self,
        request: ice20201109_models.ListMediaMarksRequest,
    ) -> ice20201109_models.ListMediaMarksResponse:
        """
        @summary Queries a list of marks of a media asset.
        
        @param request: ListMediaMarksRequest
        @return: ListMediaMarksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_marks_with_options_async(request, runtime)

    def list_media_producing_jobs_with_options(
        self,
        request: ice20201109_models.ListMediaProducingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaProducingJobsResponse:
        """
        @summary Queries a list of media editing and production jobs that meet the specified conditions. You can query the jobs based on the job state and type.
        
        @param request: ListMediaProducingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaProducingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.job_type):
            query['JobType'] = request.job_type
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.master_job_id):
            query['MasterJobId'] = request.master_job_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaProducingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaProducingJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_media_producing_jobs_with_options_async(
        self,
        request: ice20201109_models.ListMediaProducingJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListMediaProducingJobsResponse:
        """
        @summary Queries a list of media editing and production jobs that meet the specified conditions. You can query the jobs based on the job state and type.
        
        @param request: ListMediaProducingJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMediaProducingJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.job_type):
            query['JobType'] = request.job_type
        if not UtilClient.is_unset(request.keyword):
            query['Keyword'] = request.keyword
        if not UtilClient.is_unset(request.master_job_id):
            query['MasterJobId'] = request.master_job_id
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.project_id):
            query['ProjectId'] = request.project_id
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMediaProducingJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListMediaProducingJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_media_producing_jobs(
        self,
        request: ice20201109_models.ListMediaProducingJobsRequest,
    ) -> ice20201109_models.ListMediaProducingJobsResponse:
        """
        @summary Queries a list of media editing and production jobs that meet the specified conditions. You can query the jobs based on the job state and type.
        
        @param request: ListMediaProducingJobsRequest
        @return: ListMediaProducingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_media_producing_jobs_with_options(request, runtime)

    async def list_media_producing_jobs_async(
        self,
        request: ice20201109_models.ListMediaProducingJobsRequest,
    ) -> ice20201109_models.ListMediaProducingJobsResponse:
        """
        @summary Queries a list of media editing and production jobs that meet the specified conditions. You can query the jobs based on the job state and type.
        
        @param request: ListMediaProducingJobsRequest
        @return: ListMediaProducingJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_media_producing_jobs_with_options_async(request, runtime)

    def list_package_jobs_with_options(
        self,
        request: ice20201109_models.ListPackageJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPackageJobsResponse:
        """
        @summary Queries a list of packaging jobs.
        
        @param request: ListPackageJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPackageJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPackageJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPackageJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_package_jobs_with_options_async(
        self,
        request: ice20201109_models.ListPackageJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPackageJobsResponse:
        """
        @summary Queries a list of packaging jobs.
        
        @param request: ListPackageJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPackageJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_of_create_time):
            query['EndOfCreateTime'] = request.end_of_create_time
        if not UtilClient.is_unset(request.job_id):
            query['JobId'] = request.job_id
        if not UtilClient.is_unset(request.next_page_token):
            query['NextPageToken'] = request.next_page_token
        if not UtilClient.is_unset(request.order_by):
            query['OrderBy'] = request.order_by
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_of_create_time):
            query['StartOfCreateTime'] = request.start_of_create_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPackageJobs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPackageJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_package_jobs(
        self,
        request: ice20201109_models.ListPackageJobsRequest,
    ) -> ice20201109_models.ListPackageJobsResponse:
        """
        @summary Queries a list of packaging jobs.
        
        @param request: ListPackageJobsRequest
        @return: ListPackageJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_package_jobs_with_options(request, runtime)

    async def list_package_jobs_async(
        self,
        request: ice20201109_models.ListPackageJobsRequest,
    ) -> ice20201109_models.ListPackageJobsResponse:
        """
        @summary Queries a list of packaging jobs.
        
        @param request: ListPackageJobsRequest
        @return: ListPackageJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_package_jobs_with_options_async(request, runtime)

    def list_pipelines_with_options(
        self,
        request: ice20201109_models.ListPipelinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPipelinesResponse:
        """
        @summary Queries a list of ApsaraVideo Media Processing (MPS) queues.
        
        @param request: ListPipelinesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.speed):
            query['Speed'] = request.speed
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelines',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPipelinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipelines_with_options_async(
        self,
        request: ice20201109_models.ListPipelinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPipelinesResponse:
        """
        @summary Queries a list of ApsaraVideo Media Processing (MPS) queues.
        
        @param request: ListPipelinesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.speed):
            query['Speed'] = request.speed
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelines',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPipelinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipelines(
        self,
        request: ice20201109_models.ListPipelinesRequest,
    ) -> ice20201109_models.ListPipelinesResponse:
        """
        @summary Queries a list of ApsaraVideo Media Processing (MPS) queues.
        
        @param request: ListPipelinesRequest
        @return: ListPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_pipelines_with_options(request, runtime)

    async def list_pipelines_async(
        self,
        request: ice20201109_models.ListPipelinesRequest,
    ) -> ice20201109_models.ListPipelinesResponse:
        """
        @summary Queries a list of ApsaraVideo Media Processing (MPS) queues.
        
        @param request: ListPipelinesRequest
        @return: ListPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_pipelines_with_options_async(request, runtime)

    def list_programs_with_options(
        self,
        request: ice20201109_models.ListProgramsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListProgramsResponse:
        """
        @summary Lists programs.
        
        @param request: ListProgramsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProgramsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPrograms',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListProgramsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_programs_with_options_async(
        self,
        request: ice20201109_models.ListProgramsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListProgramsResponse:
        """
        @summary Lists programs.
        
        @param request: ListProgramsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProgramsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.channel_name):
            query['ChannelName'] = request.channel_name
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.program_name):
            query['ProgramName'] = request.program_name
        if not UtilClient.is_unset(request.sort_by):
            query['SortBy'] = request.sort_by
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPrograms',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListProgramsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_programs(
        self,
        request: ice20201109_models.ListProgramsRequest,
    ) -> ice20201109_models.ListProgramsResponse:
        """
        @summary Lists programs.
        
        @param request: ListProgramsRequest
        @return: ListProgramsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_programs_with_options(request, runtime)

    async def list_programs_async(
        self,
        request: ice20201109_models.ListProgramsRequest,
    ) -> ice20201109_models.ListProgramsResponse:
        """
        @summary Lists programs.
        
        @param request: ListProgramsRequest
        @return: ListProgramsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_programs_with_options_async(request, runtime)

    def list_public_media_basic_infos_with_options(
        self,
        request: ice20201109_models.ListPublicMediaBasicInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPublicMediaBasicInfosResponse:
        """
        @summary Queries a list of media assets in the public media library that meet the specified conditions. A maximum of 100 media assets can be returned.
        
        @param request: ListPublicMediaBasicInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPublicMediaBasicInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.include_file_basic_info):
            query['IncludeFileBasicInfo'] = request.include_file_basic_info
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.media_tag_id):
            query['MediaTagId'] = request.media_tag_id
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPublicMediaBasicInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPublicMediaBasicInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_public_media_basic_infos_with_options_async(
        self,
        request: ice20201109_models.ListPublicMediaBasicInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListPublicMediaBasicInfosResponse:
        """
        @summary Queries a list of media assets in the public media library that meet the specified conditions. A maximum of 100 media assets can be returned.
        
        @param request: ListPublicMediaBasicInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPublicMediaBasicInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.include_file_basic_info):
            query['IncludeFileBasicInfo'] = request.include_file_basic_info
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.media_tag_id):
            query['MediaTagId'] = request.media_tag_id
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPublicMediaBasicInfos',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='Anonymous',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListPublicMediaBasicInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_public_media_basic_infos(
        self,
        request: ice20201109_models.ListPublicMediaBasicInfosRequest,
    ) -> ice20201109_models.ListPublicMediaBasicInfosResponse:
        """
        @summary Queries a list of media assets in the public media library that meet the specified conditions. A maximum of 100 media assets can be returned.
        
        @param request: ListPublicMediaBasicInfosRequest
        @return: ListPublicMediaBasicInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_public_media_basic_infos_with_options(request, runtime)

    async def list_public_media_basic_infos_async(
        self,
        request: ice20201109_models.ListPublicMediaBasicInfosRequest,
    ) -> ice20201109_models.ListPublicMediaBasicInfosResponse:
        """
        @summary Queries a list of media assets in the public media library that meet the specified conditions. A maximum of 100 media assets can be returned.
        
        @param request: ListPublicMediaBasicInfosRequest
        @return: ListPublicMediaBasicInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_public_media_basic_infos_with_options_async(request, runtime)

    def list_recognition_entities_with_options(
        self,
        request: ice20201109_models.ListRecognitionEntitiesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionEntitiesResponse:
        """
        @summary 获取自定义库下实体列表
        
        @param request: ListRecognitionEntitiesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRecognitionEntitiesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRecognitionEntities',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListRecognitionEntitiesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_recognition_entities_with_options_async(
        self,
        request: ice20201109_models.ListRecognitionEntitiesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionEntitiesResponse:
        """
        @summary 获取自定义库下实体列表
        
        @param request: ListRecognitionEntitiesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRecognitionEntitiesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRecognitionEntities',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListRecognitionEntitiesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_recognition_entities(
        self,
        request: ice20201109_models.ListRecognitionEntitiesRequest,
    ) -> ice20201109_models.ListRecognitionEntitiesResponse:
        """
        @summary 获取自定义库下实体列表
        
        @param request: ListRecognitionEntitiesRequest
        @return: ListRecognitionEntitiesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_recognition_entities_with_options(request, runtime)

    async def list_recognition_entities_async(
        self,
        request: ice20201109_models.ListRecognitionEntitiesRequest,
    ) -> ice20201109_models.ListRecognitionEntitiesResponse:
        """
        @summary 获取自定义库下实体列表
        
        @param request: ListRecognitionEntitiesRequest
        @return: ListRecognitionEntitiesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_recognition_entities_with_options_async(request, runtime)

    def list_recognition_libs_with_options(
        self,
        request: ice20201109_models.ListRecognitionLibsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionLibsResponse:
        """
        @summary 获取自定义库列表
        
        @param request: ListRecognitionLibsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRecognitionLibsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRecognitionLibs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListRecognitionLibsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_recognition_libs_with_options_async(
        self,
        request: ice20201109_models.ListRecognitionLibsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionLibsResponse:
        """
        @summary 获取自定义库列表
        
        @param request: ListRecognitionLibsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRecognitionLibsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRecognitionLibs',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListRecognitionLibsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_recognition_libs(
        self,
        request: ice20201109_models.ListRecognitionLibsRequest,
    ) -> ice20201109_models.ListRecognitionLibsResponse:
        """
        @summary 获取自定义库列表
        
        @param request: ListRecognitionLibsRequest
        @return: ListRecognitionLibsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_recognition_libs_with_options(request, runtime)

    async def list_recognition_libs_async(
        self,
        request: ice20201109_models.ListRecognitionLibsRequest,
    ) -> ice20201109_models.ListRecognitionLibsResponse:
        """
        @summary 获取自定义库列表
        
        @param request: ListRecognitionLibsRequest
        @return: ListRecognitionLibsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_recognition_libs_with_options_async(request, runtime)

    def list_recognition_samples_with_options(
        self,
        request: ice20201109_models.ListRecognitionSamplesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionSamplesResponse:
        """
        @summary 获取自定义库实体的图片列表
        
        @param request: ListRecognitionSamplesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRecognitionSamplesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.algorithm):
            query['Algorithm'] = request.algorithm
        if not UtilClient.is_unset(request.entity_id):
            query['EntityId'] = request.entity_id
        if not UtilClient.is_unset(request.lib_id):
            query['LibId'] = request.lib_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRecognitionSamples',
            version='2020-11-09',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ice20201109_models.ListRecognitionSamplesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_recognition_samples_with_options_async(
        self,
        request: ice20201109_models.ListRecognitionSamplesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ice20201109_models.ListRecognitionSamplesResponse:
        """
        