# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Any, Dict


class AIAgentConfigAsrConfig(TeaModel):
    def __init__(
        self,
        asr_hot_words: List[str] = None,
        asr_language_id: str = None,
        asr_max_silence: int = None,
        custom_params: str = None,
        vad_duration: int = None,
        vad_level: int = None,
    ):
        self.asr_hot_words = asr_hot_words
        self.asr_language_id = asr_language_id
        self.asr_max_silence = asr_max_silence
        self.custom_params = custom_params
        self.vad_duration = vad_duration
        self.vad_level = vad_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_hot_words is not None:
            result['AsrHotWords'] = self.asr_hot_words
        if self.asr_language_id is not None:
            result['AsrLanguageId'] = self.asr_language_id
        if self.asr_max_silence is not None:
            result['AsrMaxSilence'] = self.asr_max_silence
        if self.custom_params is not None:
            result['CustomParams'] = self.custom_params
        if self.vad_duration is not None:
            result['VadDuration'] = self.vad_duration
        if self.vad_level is not None:
            result['VadLevel'] = self.vad_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrHotWords') is not None:
            self.asr_hot_words = m.get('AsrHotWords')
        if m.get('AsrLanguageId') is not None:
            self.asr_language_id = m.get('AsrLanguageId')
        if m.get('AsrMaxSilence') is not None:
            self.asr_max_silence = m.get('AsrMaxSilence')
        if m.get('CustomParams') is not None:
            self.custom_params = m.get('CustomParams')
        if m.get('VadDuration') is not None:
            self.vad_duration = m.get('VadDuration')
        if m.get('VadLevel') is not None:
            self.vad_level = m.get('VadLevel')
        return self


class AIAgentConfigAvatarConfig(TeaModel):
    def __init__(
        self,
        avatar_id: str = None,
    ):
        self.avatar_id = avatar_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_id is not None:
            result['AvatarId'] = self.avatar_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarId') is not None:
            self.avatar_id = m.get('AvatarId')
        return self


class AIAgentConfigInterruptConfig(TeaModel):
    def __init__(
        self,
        enable_voice_interrupt: bool = None,
        interrupt_words: List[str] = None,
    ):
        self.enable_voice_interrupt = enable_voice_interrupt
        self.interrupt_words = interrupt_words

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.interrupt_words is not None:
            result['InterruptWords'] = self.interrupt_words
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('InterruptWords') is not None:
            self.interrupt_words = m.get('InterruptWords')
        return self


class AIAgentConfigLlmConfigFunctionMap(TeaModel):
    def __init__(
        self,
        function: str = None,
        match_function: str = None,
    ):
        self.function = function
        self.match_function = match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.match_function is not None:
            result['MatchFunction'] = self.match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('MatchFunction') is not None:
            self.match_function = m.get('MatchFunction')
        return self


class AIAgentConfigLlmConfigLlmHistory(TeaModel):
    def __init__(
        self,
        content: str = None,
        role: str = None,
    ):
        self.content = content
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AIAgentConfigLlmConfig(TeaModel):
    def __init__(
        self,
        bailian_app_params: str = None,
        function_map: List[AIAgentConfigLlmConfigFunctionMap] = None,
        llm_complete_reply: bool = None,
        llm_history: List[AIAgentConfigLlmConfigLlmHistory] = None,
        llm_history_limit: int = None,
        llm_system_prompt: str = None,
        open_aiextra_query: str = None,
        output_max_delay: int = None,
        output_min_length: int = None,
    ):
        self.bailian_app_params = bailian_app_params
        self.function_map = function_map
        self.llm_complete_reply = llm_complete_reply
        self.llm_history = llm_history
        self.llm_history_limit = llm_history_limit
        self.llm_system_prompt = llm_system_prompt
        self.open_aiextra_query = open_aiextra_query
        self.output_max_delay = output_max_delay
        self.output_min_length = output_min_length

    def validate(self):
        if self.function_map:
            for k in self.function_map:
                if k:
                    k.validate()
        if self.llm_history:
            for k in self.llm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bailian_app_params is not None:
            result['BailianAppParams'] = self.bailian_app_params
        result['FunctionMap'] = []
        if self.function_map is not None:
            for k in self.function_map:
                result['FunctionMap'].append(k.to_map() if k else None)
        if self.llm_complete_reply is not None:
            result['LlmCompleteReply'] = self.llm_complete_reply
        result['LlmHistory'] = []
        if self.llm_history is not None:
            for k in self.llm_history:
                result['LlmHistory'].append(k.to_map() if k else None)
        if self.llm_history_limit is not None:
            result['LlmHistoryLimit'] = self.llm_history_limit
        if self.llm_system_prompt is not None:
            result['LlmSystemPrompt'] = self.llm_system_prompt
        if self.open_aiextra_query is not None:
            result['OpenAIExtraQuery'] = self.open_aiextra_query
        if self.output_max_delay is not None:
            result['OutputMaxDelay'] = self.output_max_delay
        if self.output_min_length is not None:
            result['OutputMinLength'] = self.output_min_length
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BailianAppParams') is not None:
            self.bailian_app_params = m.get('BailianAppParams')
        self.function_map = []
        if m.get('FunctionMap') is not None:
            for k in m.get('FunctionMap'):
                temp_model = AIAgentConfigLlmConfigFunctionMap()
                self.function_map.append(temp_model.from_map(k))
        if m.get('LlmCompleteReply') is not None:
            self.llm_complete_reply = m.get('LlmCompleteReply')
        self.llm_history = []
        if m.get('LlmHistory') is not None:
            for k in m.get('LlmHistory'):
                temp_model = AIAgentConfigLlmConfigLlmHistory()
                self.llm_history.append(temp_model.from_map(k))
        if m.get('LlmHistoryLimit') is not None:
            self.llm_history_limit = m.get('LlmHistoryLimit')
        if m.get('LlmSystemPrompt') is not None:
            self.llm_system_prompt = m.get('LlmSystemPrompt')
        if m.get('OpenAIExtraQuery') is not None:
            self.open_aiextra_query = m.get('OpenAIExtraQuery')
        if m.get('OutputMaxDelay') is not None:
            self.output_max_delay = m.get('OutputMaxDelay')
        if m.get('OutputMinLength') is not None:
            self.output_min_length = m.get('OutputMinLength')
        return self


class AIAgentConfigTtsConfigPronunciationRules(TeaModel):
    def __init__(
        self,
        pronunciation: str = None,
        type: str = None,
        word: str = None,
    ):
        self.pronunciation = pronunciation
        self.type = type
        self.word = word

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pronunciation is not None:
            result['Pronunciation'] = self.pronunciation
        if self.type is not None:
            result['Type'] = self.type
        if self.word is not None:
            result['Word'] = self.word
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pronunciation') is not None:
            self.pronunciation = m.get('Pronunciation')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Word') is not None:
            self.word = m.get('Word')
        return self


class AIAgentConfigTtsConfig(TeaModel):
    def __init__(
        self,
        emotion: str = None,
        language_id: str = None,
        model_id: str = None,
        pronunciation_rules: List[AIAgentConfigTtsConfigPronunciationRules] = None,
        speech_rate: float = None,
        voice_id: str = None,
        voice_id_list: List[str] = None,
    ):
        self.emotion = emotion
        self.language_id = language_id
        self.model_id = model_id
        self.pronunciation_rules = pronunciation_rules
        self.speech_rate = speech_rate
        self.voice_id = voice_id
        self.voice_id_list = voice_id_list

    def validate(self):
        if self.pronunciation_rules:
            for k in self.pronunciation_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.emotion is not None:
            result['Emotion'] = self.emotion
        if self.language_id is not None:
            result['LanguageId'] = self.language_id
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        result['PronunciationRules'] = []
        if self.pronunciation_rules is not None:
            for k in self.pronunciation_rules:
                result['PronunciationRules'].append(k.to_map() if k else None)
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_id_list is not None:
            result['VoiceIdList'] = self.voice_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Emotion') is not None:
            self.emotion = m.get('Emotion')
        if m.get('LanguageId') is not None:
            self.language_id = m.get('LanguageId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        self.pronunciation_rules = []
        if m.get('PronunciationRules') is not None:
            for k in m.get('PronunciationRules'):
                temp_model = AIAgentConfigTtsConfigPronunciationRules()
                self.pronunciation_rules.append(temp_model.from_map(k))
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceIdList') is not None:
            self.voice_id_list = m.get('VoiceIdList')
        return self


class AIAgentConfigTurnDetectionConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
        semantic_wait_duration: int = None,
        turn_end_words: List[str] = None,
    ):
        self.mode = mode
        self.semantic_wait_duration = semantic_wait_duration
        self.turn_end_words = turn_end_words

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.semantic_wait_duration is not None:
            result['SemanticWaitDuration'] = self.semantic_wait_duration
        if self.turn_end_words is not None:
            result['TurnEndWords'] = self.turn_end_words
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('SemanticWaitDuration') is not None:
            self.semantic_wait_duration = m.get('SemanticWaitDuration')
        if m.get('TurnEndWords') is not None:
            self.turn_end_words = m.get('TurnEndWords')
        return self


class AIAgentConfigVcrConfigEquipment(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
    ):
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class AIAgentConfigVcrConfigHeadMotion(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
    ):
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class AIAgentConfigVcrConfigInvalidFrameMotion(TeaModel):
    def __init__(
        self,
        callback_delay: int = None,
        enabled: bool = None,
    ):
        self.callback_delay = callback_delay
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_delay is not None:
            result['CallbackDelay'] = self.callback_delay
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackDelay') is not None:
            self.callback_delay = m.get('CallbackDelay')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class AIAgentConfigVcrConfigPeopleCount(TeaModel):
    def __init__(
        self,
        enabled: bool = None,
    ):
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class AIAgentConfigVcrConfigStillFrameMotion(TeaModel):
    def __init__(
        self,
        callback_delay: int = None,
        enabled: bool = None,
    ):
        self.callback_delay = callback_delay
        self.enabled = enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_delay is not None:
            result['CallbackDelay'] = self.callback_delay
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackDelay') is not None:
            self.callback_delay = m.get('CallbackDelay')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        return self


class AIAgentConfigVcrConfig(TeaModel):
    def __init__(
        self,
        equipment: AIAgentConfigVcrConfigEquipment = None,
        head_motion: AIAgentConfigVcrConfigHeadMotion = None,
        invalid_frame_motion: AIAgentConfigVcrConfigInvalidFrameMotion = None,
        people_count: AIAgentConfigVcrConfigPeopleCount = None,
        still_frame_motion: AIAgentConfigVcrConfigStillFrameMotion = None,
    ):
        self.equipment = equipment
        self.head_motion = head_motion
        self.invalid_frame_motion = invalid_frame_motion
        self.people_count = people_count
        self.still_frame_motion = still_frame_motion

    def validate(self):
        if self.equipment:
            self.equipment.validate()
        if self.head_motion:
            self.head_motion.validate()
        if self.invalid_frame_motion:
            self.invalid_frame_motion.validate()
        if self.people_count:
            self.people_count.validate()
        if self.still_frame_motion:
            self.still_frame_motion.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.equipment is not None:
            result['Equipment'] = self.equipment.to_map()
        if self.head_motion is not None:
            result['HeadMotion'] = self.head_motion.to_map()
        if self.invalid_frame_motion is not None:
            result['InvalidFrameMotion'] = self.invalid_frame_motion.to_map()
        if self.people_count is not None:
            result['PeopleCount'] = self.people_count.to_map()
        if self.still_frame_motion is not None:
            result['StillFrameMotion'] = self.still_frame_motion.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Equipment') is not None:
            temp_model = AIAgentConfigVcrConfigEquipment()
            self.equipment = temp_model.from_map(m['Equipment'])
        if m.get('HeadMotion') is not None:
            temp_model = AIAgentConfigVcrConfigHeadMotion()
            self.head_motion = temp_model.from_map(m['HeadMotion'])
        if m.get('InvalidFrameMotion') is not None:
            temp_model = AIAgentConfigVcrConfigInvalidFrameMotion()
            self.invalid_frame_motion = temp_model.from_map(m['InvalidFrameMotion'])
        if m.get('PeopleCount') is not None:
            temp_model = AIAgentConfigVcrConfigPeopleCount()
            self.people_count = temp_model.from_map(m['PeopleCount'])
        if m.get('StillFrameMotion') is not None:
            temp_model = AIAgentConfigVcrConfigStillFrameMotion()
            self.still_frame_motion = temp_model.from_map(m['StillFrameMotion'])
        return self


class AIAgentConfigVoiceprintConfig(TeaModel):
    def __init__(
        self,
        use_voiceprint: bool = None,
        voiceprint_id: str = None,
    ):
        self.use_voiceprint = use_voiceprint
        self.voiceprint_id = voiceprint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.use_voiceprint is not None:
            result['UseVoiceprint'] = self.use_voiceprint
        if self.voiceprint_id is not None:
            result['VoiceprintId'] = self.voiceprint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UseVoiceprint') is not None:
            self.use_voiceprint = m.get('UseVoiceprint')
        if m.get('VoiceprintId') is not None:
            self.voiceprint_id = m.get('VoiceprintId')
        return self


class AIAgentConfig(TeaModel):
    def __init__(
        self,
        asr_config: AIAgentConfigAsrConfig = None,
        avatar_config: AIAgentConfigAvatarConfig = None,
        avatar_url: str = None,
        avatar_url_type: str = None,
        enable_intelligent_segment: bool = None,
        enable_push_to_talk: bool = None,
        experimental_config: str = None,
        graceful_shutdown: bool = None,
        greeting: str = None,
        interrupt_config: AIAgentConfigInterruptConfig = None,
        llm_config: AIAgentConfigLlmConfig = None,
        max_idle_time: int = None,
        tts_config: AIAgentConfigTtsConfig = None,
        turn_detection_config: AIAgentConfigTurnDetectionConfig = None,
        user_offline_timeout: int = None,
        user_online_timeout: int = None,
        vcr_config: AIAgentConfigVcrConfig = None,
        voiceprint_config: AIAgentConfigVoiceprintConfig = None,
        volume: int = None,
        wake_up_query: str = None,
        workflow_override_params: str = None,
    ):
        self.asr_config = asr_config
        self.avatar_config = avatar_config
        self.avatar_url = avatar_url
        self.avatar_url_type = avatar_url_type
        self.enable_intelligent_segment = enable_intelligent_segment
        self.enable_push_to_talk = enable_push_to_talk
        self.experimental_config = experimental_config
        self.graceful_shutdown = graceful_shutdown
        self.greeting = greeting
        self.interrupt_config = interrupt_config
        self.llm_config = llm_config
        self.max_idle_time = max_idle_time
        self.tts_config = tts_config
        self.turn_detection_config = turn_detection_config
        self.user_offline_timeout = user_offline_timeout
        self.user_online_timeout = user_online_timeout
        self.vcr_config = vcr_config
        self.voiceprint_config = voiceprint_config
        self.volume = volume
        self.wake_up_query = wake_up_query
        self.workflow_override_params = workflow_override_params

    def validate(self):
        if self.asr_config:
            self.asr_config.validate()
        if self.avatar_config:
            self.avatar_config.validate()
        if self.interrupt_config:
            self.interrupt_config.validate()
        if self.llm_config:
            self.llm_config.validate()
        if self.tts_config:
            self.tts_config.validate()
        if self.turn_detection_config:
            self.turn_detection_config.validate()
        if self.vcr_config:
            self.vcr_config.validate()
        if self.voiceprint_config:
            self.voiceprint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_config is not None:
            result['AsrConfig'] = self.asr_config.to_map()
        if self.avatar_config is not None:
            result['AvatarConfig'] = self.avatar_config.to_map()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.avatar_url_type is not None:
            result['AvatarUrlType'] = self.avatar_url_type
        if self.enable_intelligent_segment is not None:
            result['EnableIntelligentSegment'] = self.enable_intelligent_segment
        if self.enable_push_to_talk is not None:
            result['EnablePushToTalk'] = self.enable_push_to_talk
        if self.experimental_config is not None:
            result['ExperimentalConfig'] = self.experimental_config
        if self.graceful_shutdown is not None:
            result['GracefulShutdown'] = self.graceful_shutdown
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.interrupt_config is not None:
            result['InterruptConfig'] = self.interrupt_config.to_map()
        if self.llm_config is not None:
            result['LlmConfig'] = self.llm_config.to_map()
        if self.max_idle_time is not None:
            result['MaxIdleTime'] = self.max_idle_time
        if self.tts_config is not None:
            result['TtsConfig'] = self.tts_config.to_map()
        if self.turn_detection_config is not None:
            result['TurnDetectionConfig'] = self.turn_detection_config.to_map()
        if self.user_offline_timeout is not None:
            result['UserOfflineTimeout'] = self.user_offline_timeout
        if self.user_online_timeout is not None:
            result['UserOnlineTimeout'] = self.user_online_timeout
        if self.vcr_config is not None:
            result['VcrConfig'] = self.vcr_config.to_map()
        if self.voiceprint_config is not None:
            result['VoiceprintConfig'] = self.voiceprint_config.to_map()
        if self.volume is not None:
            result['Volume'] = self.volume
        if self.wake_up_query is not None:
            result['WakeUpQuery'] = self.wake_up_query
        if self.workflow_override_params is not None:
            result['WorkflowOverrideParams'] = self.workflow_override_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrConfig') is not None:
            temp_model = AIAgentConfigAsrConfig()
            self.asr_config = temp_model.from_map(m['AsrConfig'])
        if m.get('AvatarConfig') is not None:
            temp_model = AIAgentConfigAvatarConfig()
            self.avatar_config = temp_model.from_map(m['AvatarConfig'])
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('AvatarUrlType') is not None:
            self.avatar_url_type = m.get('AvatarUrlType')
        if m.get('EnableIntelligentSegment') is not None:
            self.enable_intelligent_segment = m.get('EnableIntelligentSegment')
        if m.get('EnablePushToTalk') is not None:
            self.enable_push_to_talk = m.get('EnablePushToTalk')
        if m.get('ExperimentalConfig') is not None:
            self.experimental_config = m.get('ExperimentalConfig')
        if m.get('GracefulShutdown') is not None:
            self.graceful_shutdown = m.get('GracefulShutdown')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('InterruptConfig') is not None:
            temp_model = AIAgentConfigInterruptConfig()
            self.interrupt_config = temp_model.from_map(m['InterruptConfig'])
        if m.get('LlmConfig') is not None:
            temp_model = AIAgentConfigLlmConfig()
            self.llm_config = temp_model.from_map(m['LlmConfig'])
        if m.get('MaxIdleTime') is not None:
            self.max_idle_time = m.get('MaxIdleTime')
        if m.get('TtsConfig') is not None:
            temp_model = AIAgentConfigTtsConfig()
            self.tts_config = temp_model.from_map(m['TtsConfig'])
        if m.get('TurnDetectionConfig') is not None:
            temp_model = AIAgentConfigTurnDetectionConfig()
            self.turn_detection_config = temp_model.from_map(m['TurnDetectionConfig'])
        if m.get('UserOfflineTimeout') is not None:
            self.user_offline_timeout = m.get('UserOfflineTimeout')
        if m.get('UserOnlineTimeout') is not None:
            self.user_online_timeout = m.get('UserOnlineTimeout')
        if m.get('VcrConfig') is not None:
            temp_model = AIAgentConfigVcrConfig()
            self.vcr_config = temp_model.from_map(m['VcrConfig'])
        if m.get('VoiceprintConfig') is not None:
            temp_model = AIAgentConfigVoiceprintConfig()
            self.voiceprint_config = temp_model.from_map(m['VoiceprintConfig'])
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        if m.get('WakeUpQuery') is not None:
            self.wake_up_query = m.get('WakeUpQuery')
        if m.get('WorkflowOverrideParams') is not None:
            self.workflow_override_params = m.get('WorkflowOverrideParams')
        return self


class AIAgentOutboundCallConfigAsrConfig(TeaModel):
    def __init__(
        self,
        asr_hot_words: List[str] = None,
        asr_language_id: str = None,
        asr_max_silence: int = None,
        custom_params: str = None,
        vad_duration: int = None,
        vad_level: int = None,
    ):
        self.asr_hot_words = asr_hot_words
        self.asr_language_id = asr_language_id
        self.asr_max_silence = asr_max_silence
        self.custom_params = custom_params
        self.vad_duration = vad_duration
        self.vad_level = vad_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_hot_words is not None:
            result['AsrHotWords'] = self.asr_hot_words
        if self.asr_language_id is not None:
            result['AsrLanguageId'] = self.asr_language_id
        if self.asr_max_silence is not None:
            result['AsrMaxSilence'] = self.asr_max_silence
        if self.custom_params is not None:
            result['CustomParams'] = self.custom_params
        if self.vad_duration is not None:
            result['VadDuration'] = self.vad_duration
        if self.vad_level is not None:
            result['VadLevel'] = self.vad_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrHotWords') is not None:
            self.asr_hot_words = m.get('AsrHotWords')
        if m.get('AsrLanguageId') is not None:
            self.asr_language_id = m.get('AsrLanguageId')
        if m.get('AsrMaxSilence') is not None:
            self.asr_max_silence = m.get('AsrMaxSilence')
        if m.get('CustomParams') is not None:
            self.custom_params = m.get('CustomParams')
        if m.get('VadDuration') is not None:
            self.vad_duration = m.get('VadDuration')
        if m.get('VadLevel') is not None:
            self.vad_level = m.get('VadLevel')
        return self


class AIAgentOutboundCallConfigInterruptConfig(TeaModel):
    def __init__(
        self,
        enable_voice_interrupt: bool = None,
        interrupt_words: List[str] = None,
    ):
        self.enable_voice_interrupt = enable_voice_interrupt
        self.interrupt_words = interrupt_words

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.interrupt_words is not None:
            result['InterruptWords'] = self.interrupt_words
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('InterruptWords') is not None:
            self.interrupt_words = m.get('InterruptWords')
        return self


class AIAgentOutboundCallConfigLlmConfigFunctionMap(TeaModel):
    def __init__(
        self,
        function: str = None,
        match_function: str = None,
    ):
        self.function = function
        self.match_function = match_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.match_function is not None:
            result['MatchFunction'] = self.match_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('MatchFunction') is not None:
            self.match_function = m.get('MatchFunction')
        return self


class AIAgentOutboundCallConfigLlmConfigLlmHistory(TeaModel):
    def __init__(
        self,
        content: str = None,
        role: str = None,
    ):
        self.content = content
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AIAgentOutboundCallConfigLlmConfig(TeaModel):
    def __init__(
        self,
        bailian_app_params: str = None,
        function_map: List[AIAgentOutboundCallConfigLlmConfigFunctionMap] = None,
        llm_complete_reply: bool = None,
        llm_history: List[AIAgentOutboundCallConfigLlmConfigLlmHistory] = None,
        llm_history_limit: int = None,
        llm_system_prompt: str = None,
        open_aiextra_query: str = None,
        output_max_delay: str = None,
        output_min_length: int = None,
    ):
        self.bailian_app_params = bailian_app_params
        self.function_map = function_map
        self.llm_complete_reply = llm_complete_reply
        self.llm_history = llm_history
        self.llm_history_limit = llm_history_limit
        self.llm_system_prompt = llm_system_prompt
        self.open_aiextra_query = open_aiextra_query
        self.output_max_delay = output_max_delay
        self.output_min_length = output_min_length

    def validate(self):
        if self.function_map:
            for k in self.function_map:
                if k:
                    k.validate()
        if self.llm_history:
            for k in self.llm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bailian_app_params is not None:
            result['BailianAppParams'] = self.bailian_app_params
        result['FunctionMap'] = []
        if self.function_map is not None:
            for k in self.function_map:
                result['FunctionMap'].append(k.to_map() if k else None)
        if self.llm_complete_reply is not None:
            result['LlmCompleteReply'] = self.llm_complete_reply
        result['LlmHistory'] = []
        if self.llm_history is not None:
            for k in self.llm_history:
                result['LlmHistory'].append(k.to_map() if k else None)
        if self.llm_history_limit is not None:
            result['LlmHistoryLimit'] = self.llm_history_limit
        if self.llm_system_prompt is not None:
            result['LlmSystemPrompt'] = self.llm_system_prompt
        if self.open_aiextra_query is not None:
            result['OpenAIExtraQuery'] = self.open_aiextra_query
        if self.output_max_delay is not None:
            result['OutputMaxDelay'] = self.output_max_delay
        if self.output_min_length is not None:
            result['OutputMinLength'] = self.output_min_length
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BailianAppParams') is not None:
            self.bailian_app_params = m.get('BailianAppParams')
        self.function_map = []
        if m.get('FunctionMap') is not None:
            for k in m.get('FunctionMap'):
                temp_model = AIAgentOutboundCallConfigLlmConfigFunctionMap()
                self.function_map.append(temp_model.from_map(k))
        if m.get('LlmCompleteReply') is not None:
            self.llm_complete_reply = m.get('LlmCompleteReply')
        self.llm_history = []
        if m.get('LlmHistory') is not None:
            for k in m.get('LlmHistory'):
                temp_model = AIAgentOutboundCallConfigLlmConfigLlmHistory()
                self.llm_history.append(temp_model.from_map(k))
        if m.get('LlmHistoryLimit') is not None:
            self.llm_history_limit = m.get('LlmHistoryLimit')
        if m.get('LlmSystemPrompt') is not None:
            self.llm_system_prompt = m.get('LlmSystemPrompt')
        if m.get('OpenAIExtraQuery') is not None:
            self.open_aiextra_query = m.get('OpenAIExtraQuery')
        if m.get('OutputMaxDelay') is not None:
            self.output_max_delay = m.get('OutputMaxDelay')
        if m.get('OutputMinLength') is not None:
            self.output_min_length = m.get('OutputMinLength')
        return self


class AIAgentOutboundCallConfigTtsConfigPronunciationRules(TeaModel):
    def __init__(
        self,
        pronunciation: str = None,
        type: str = None,
        word: str = None,
    ):
        self.pronunciation = pronunciation
        self.type = type
        self.word = word

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pronunciation is not None:
            result['Pronunciation'] = self.pronunciation
        if self.type is not None:
            result['Type'] = self.type
        if self.word is not None:
            result['Word'] = self.word
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pronunciation') is not None:
            self.pronunciation = m.get('Pronunciation')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Word') is not None:
            self.word = m.get('Word')
        return self


class AIAgentOutboundCallConfigTtsConfig(TeaModel):
    def __init__(
        self,
        emotion: str = None,
        language_id: str = None,
        model_id: str = None,
        pronunciation_rules: List[AIAgentOutboundCallConfigTtsConfigPronunciationRules] = None,
        speech_rate: float = None,
        voice_id: str = None,
        voice_id_list: List[str] = None,
    ):
        self.emotion = emotion
        self.language_id = language_id
        self.model_id = model_id
        self.pronunciation_rules = pronunciation_rules
        self.speech_rate = speech_rate
        self.voice_id = voice_id
        self.voice_id_list = voice_id_list

    def validate(self):
        if self.pronunciation_rules:
            for k in self.pronunciation_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.emotion is not None:
            result['Emotion'] = self.emotion
        if self.language_id is not None:
            result['LanguageId'] = self.language_id
        if self.model_id is not None:
            result['ModelId'] = self.model_id
        result['PronunciationRules'] = []
        if self.pronunciation_rules is not None:
            for k in self.pronunciation_rules:
                result['PronunciationRules'].append(k.to_map() if k else None)
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_id_list is not None:
            result['VoiceIdList'] = self.voice_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Emotion') is not None:
            self.emotion = m.get('Emotion')
        if m.get('LanguageId') is not None:
            self.language_id = m.get('LanguageId')
        if m.get('ModelId') is not None:
            self.model_id = m.get('ModelId')
        self.pronunciation_rules = []
        if m.get('PronunciationRules') is not None:
            for k in m.get('PronunciationRules'):
                temp_model = AIAgentOutboundCallConfigTtsConfigPronunciationRules()
                self.pronunciation_rules.append(temp_model.from_map(k))
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceIdList') is not None:
            self.voice_id_list = m.get('VoiceIdList')
        return self


class AIAgentOutboundCallConfigTurnDetectionConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
        semantic_wait_duration: int = None,
        turn_end_words: List[str] = None,
    ):
        self.mode = mode
        self.semantic_wait_duration = semantic_wait_duration
        self.turn_end_words = turn_end_words

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.semantic_wait_duration is not None:
            result['SemanticWaitDuration'] = self.semantic_wait_duration
        if self.turn_end_words is not None:
            result['TurnEndWords'] = self.turn_end_words
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('SemanticWaitDuration') is not None:
            self.semantic_wait_duration = m.get('SemanticWaitDuration')
        if m.get('TurnEndWords') is not None:
            self.turn_end_words = m.get('TurnEndWords')
        return self


class AIAgentOutboundCallConfig(TeaModel):
    def __init__(
        self,
        asr_config: AIAgentOutboundCallConfigAsrConfig = None,
        enable_intelligent_segment: bool = None,
        greeting: str = None,
        greeting_delay: int = None,
        interrupt_config: AIAgentOutboundCallConfigInterruptConfig = None,
        llm_config: AIAgentOutboundCallConfigLlmConfig = None,
        tts_config: AIAgentOutboundCallConfigTtsConfig = None,
        turn_detection_config: AIAgentOutboundCallConfigTurnDetectionConfig = None,
    ):
        self.asr_config = asr_config
        self.enable_intelligent_segment = enable_intelligent_segment
        self.greeting = greeting
        self.greeting_delay = greeting_delay
        self.interrupt_config = interrupt_config
        self.llm_config = llm_config
        self.tts_config = tts_config
        self.turn_detection_config = turn_detection_config

    def validate(self):
        if self.asr_config:
            self.asr_config.validate()
        if self.interrupt_config:
            self.interrupt_config.validate()
        if self.llm_config:
            self.llm_config.validate()
        if self.tts_config:
            self.tts_config.validate()
        if self.turn_detection_config:
            self.turn_detection_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_config is not None:
            result['AsrConfig'] = self.asr_config.to_map()
        if self.enable_intelligent_segment is not None:
            result['EnableIntelligentSegment'] = self.enable_intelligent_segment
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.greeting_delay is not None:
            result['GreetingDelay'] = self.greeting_delay
        if self.interrupt_config is not None:
            result['InterruptConfig'] = self.interrupt_config.to_map()
        if self.llm_config is not None:
            result['LlmConfig'] = self.llm_config.to_map()
        if self.tts_config is not None:
            result['TtsConfig'] = self.tts_config.to_map()
        if self.turn_detection_config is not None:
            result['TurnDetectionConfig'] = self.turn_detection_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrConfig') is not None:
            temp_model = AIAgentOutboundCallConfigAsrConfig()
            self.asr_config = temp_model.from_map(m['AsrConfig'])
        if m.get('EnableIntelligentSegment') is not None:
            self.enable_intelligent_segment = m.get('EnableIntelligentSegment')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('GreetingDelay') is not None:
            self.greeting_delay = m.get('GreetingDelay')
        if m.get('InterruptConfig') is not None:
            temp_model = AIAgentOutboundCallConfigInterruptConfig()
            self.interrupt_config = temp_model.from_map(m['InterruptConfig'])
        if m.get('LlmConfig') is not None:
            temp_model = AIAgentOutboundCallConfigLlmConfig()
            self.llm_config = temp_model.from_map(m['LlmConfig'])
        if m.get('TtsConfig') is not None:
            temp_model = AIAgentOutboundCallConfigTtsConfig()
            self.tts_config = temp_model.from_map(m['TtsConfig'])
        if m.get('TurnDetectionConfig') is not None:
            temp_model = AIAgentOutboundCallConfigTurnDetectionConfig()
            self.turn_detection_config = temp_model.from_map(m['TurnDetectionConfig'])
        return self


class AIAgentRuntimeConfigAvatarChat3D(TeaModel):
    def __init__(
        self,
        agent_user_id: str = None,
        auth_token: str = None,
        channel_id: str = None,
    ):
        self.agent_user_id = agent_user_id
        self.auth_token = auth_token
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_user_id is not None:
            result['AgentUserId'] = self.agent_user_id
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentUserId') is not None:
            self.agent_user_id = m.get('AgentUserId')
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class AIAgentRuntimeConfigVisionChat(TeaModel):
    def __init__(
        self,
        agent_user_id: str = None,
        auth_token: str = None,
        channel_id: str = None,
    ):
        self.agent_user_id = agent_user_id
        self.auth_token = auth_token
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_user_id is not None:
            result['AgentUserId'] = self.agent_user_id
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentUserId') is not None:
            self.agent_user_id = m.get('AgentUserId')
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class AIAgentRuntimeConfigVoiceChat(TeaModel):
    def __init__(
        self,
        agent_user_id: str = None,
        auth_token: str = None,
        channel_id: str = None,
    ):
        self.agent_user_id = agent_user_id
        self.auth_token = auth_token
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_user_id is not None:
            result['AgentUserId'] = self.agent_user_id
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentUserId') is not None:
            self.agent_user_id = m.get('AgentUserId')
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class AIAgentRuntimeConfig(TeaModel):
    def __init__(
        self,
        agent_user_id: str = None,
        auth_token: str = None,
        avatar_chat_3d: AIAgentRuntimeConfigAvatarChat3D = None,
        channel_id: str = None,
        vision_chat: AIAgentRuntimeConfigVisionChat = None,
        voice_chat: AIAgentRuntimeConfigVoiceChat = None,
    ):
        self.agent_user_id = agent_user_id
        self.auth_token = auth_token
        self.avatar_chat_3d = avatar_chat_3d
        self.channel_id = channel_id
        self.vision_chat = vision_chat
        self.voice_chat = voice_chat

    def validate(self):
        if self.avatar_chat_3d:
            self.avatar_chat_3d.validate()
        if self.vision_chat:
            self.vision_chat.validate()
        if self.voice_chat:
            self.voice_chat.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_user_id is not None:
            result['AgentUserId'] = self.agent_user_id
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.avatar_chat_3d is not None:
            result['AvatarChat3D'] = self.avatar_chat_3d.to_map()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.vision_chat is not None:
            result['VisionChat'] = self.vision_chat.to_map()
        if self.voice_chat is not None:
            result['VoiceChat'] = self.voice_chat.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentUserId') is not None:
            self.agent_user_id = m.get('AgentUserId')
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('AvatarChat3D') is not None:
            temp_model = AIAgentRuntimeConfigAvatarChat3D()
            self.avatar_chat_3d = temp_model.from_map(m['AvatarChat3D'])
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('VisionChat') is not None:
            temp_model = AIAgentRuntimeConfigVisionChat()
            self.vision_chat = temp_model.from_map(m['VisionChat'])
        if m.get('VoiceChat') is not None:
            temp_model = AIAgentRuntimeConfigVoiceChat()
            self.voice_chat = temp_model.from_map(m['VoiceChat'])
        return self


class AIAgentTemplateConfigAvatarChat3DLlmHistory(TeaModel):
    def __init__(
        self,
        content: str = None,
        role: str = None,
    ):
        self.content = content
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AIAgentTemplateConfigAvatarChat3D(TeaModel):
    def __init__(
        self,
        asr_hot_words: List[str] = None,
        asr_language_id: str = None,
        asr_max_silence: int = None,
        avatar_id: str = None,
        bailian_app_params: str = None,
        char_break: bool = None,
        enable_intelligent_segment: bool = None,
        enable_push_to_talk: bool = None,
        enable_voice_interrupt: bool = None,
        graceful_shutdown: bool = None,
        greeting: str = None,
        interrupt_words: List[str] = None,
        llm_history: List[AIAgentTemplateConfigAvatarChat3DLlmHistory] = None,
        llm_history_limit: int = None,
        llm_system_prompt: str = None,
        max_idle_time: int = None,
        use_voiceprint: bool = None,
        user_offline_timeout: int = None,
        user_online_timeout: int = None,
        vad_level: int = None,
        voice_id: str = None,
        voice_id_list: List[str] = None,
        voiceprint_id: str = None,
        volume: int = None,
        wake_up_query: str = None,
        workflow_override_params: str = None,
    ):
        self.asr_hot_words = asr_hot_words
        self.asr_language_id = asr_language_id
        self.asr_max_silence = asr_max_silence
        self.avatar_id = avatar_id
        self.bailian_app_params = bailian_app_params
        self.char_break = char_break
        self.enable_intelligent_segment = enable_intelligent_segment
        self.enable_push_to_talk = enable_push_to_talk
        self.enable_voice_interrupt = enable_voice_interrupt
        self.graceful_shutdown = graceful_shutdown
        self.greeting = greeting
        self.interrupt_words = interrupt_words
        self.llm_history = llm_history
        self.llm_history_limit = llm_history_limit
        self.llm_system_prompt = llm_system_prompt
        self.max_idle_time = max_idle_time
        self.use_voiceprint = use_voiceprint
        self.user_offline_timeout = user_offline_timeout
        self.user_online_timeout = user_online_timeout
        self.vad_level = vad_level
        self.voice_id = voice_id
        self.voice_id_list = voice_id_list
        self.voiceprint_id = voiceprint_id
        self.volume = volume
        self.wake_up_query = wake_up_query
        self.workflow_override_params = workflow_override_params

    def validate(self):
        if self.llm_history:
            for k in self.llm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_hot_words is not None:
            result['AsrHotWords'] = self.asr_hot_words
        if self.asr_language_id is not None:
            result['AsrLanguageId'] = self.asr_language_id
        if self.asr_max_silence is not None:
            result['AsrMaxSilence'] = self.asr_max_silence
        if self.avatar_id is not None:
            result['AvatarId'] = self.avatar_id
        if self.bailian_app_params is not None:
            result['BailianAppParams'] = self.bailian_app_params
        if self.char_break is not None:
            result['CharBreak'] = self.char_break
        if self.enable_intelligent_segment is not None:
            result['EnableIntelligentSegment'] = self.enable_intelligent_segment
        if self.enable_push_to_talk is not None:
            result['EnablePushToTalk'] = self.enable_push_to_talk
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.graceful_shutdown is not None:
            result['GracefulShutdown'] = self.graceful_shutdown
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.interrupt_words is not None:
            result['InterruptWords'] = self.interrupt_words
        result['LlmHistory'] = []
        if self.llm_history is not None:
            for k in self.llm_history:
                result['LlmHistory'].append(k.to_map() if k else None)
        if self.llm_history_limit is not None:
            result['LlmHistoryLimit'] = self.llm_history_limit
        if self.llm_system_prompt is not None:
            result['LlmSystemPrompt'] = self.llm_system_prompt
        if self.max_idle_time is not None:
            result['MaxIdleTime'] = self.max_idle_time
        if self.use_voiceprint is not None:
            result['UseVoiceprint'] = self.use_voiceprint
        if self.user_offline_timeout is not None:
            result['UserOfflineTimeout'] = self.user_offline_timeout
        if self.user_online_timeout is not None:
            result['UserOnlineTimeout'] = self.user_online_timeout
        if self.vad_level is not None:
            result['VadLevel'] = self.vad_level
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_id_list is not None:
            result['VoiceIdList'] = self.voice_id_list
        if self.voiceprint_id is not None:
            result['VoiceprintId'] = self.voiceprint_id
        if self.volume is not None:
            result['Volume'] = self.volume
        if self.wake_up_query is not None:
            result['WakeUpQuery'] = self.wake_up_query
        if self.workflow_override_params is not None:
            result['WorkflowOverrideParams'] = self.workflow_override_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrHotWords') is not None:
            self.asr_hot_words = m.get('AsrHotWords')
        if m.get('AsrLanguageId') is not None:
            self.asr_language_id = m.get('AsrLanguageId')
        if m.get('AsrMaxSilence') is not None:
            self.asr_max_silence = m.get('AsrMaxSilence')
        if m.get('AvatarId') is not None:
            self.avatar_id = m.get('AvatarId')
        if m.get('BailianAppParams') is not None:
            self.bailian_app_params = m.get('BailianAppParams')
        if m.get('CharBreak') is not None:
            self.char_break = m.get('CharBreak')
        if m.get('EnableIntelligentSegment') is not None:
            self.enable_intelligent_segment = m.get('EnableIntelligentSegment')
        if m.get('EnablePushToTalk') is not None:
            self.enable_push_to_talk = m.get('EnablePushToTalk')
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('GracefulShutdown') is not None:
            self.graceful_shutdown = m.get('GracefulShutdown')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('InterruptWords') is not None:
            self.interrupt_words = m.get('InterruptWords')
        self.llm_history = []
        if m.get('LlmHistory') is not None:
            for k in m.get('LlmHistory'):
                temp_model = AIAgentTemplateConfigAvatarChat3DLlmHistory()
                self.llm_history.append(temp_model.from_map(k))
        if m.get('LlmHistoryLimit') is not None:
            self.llm_history_limit = m.get('LlmHistoryLimit')
        if m.get('LlmSystemPrompt') is not None:
            self.llm_system_prompt = m.get('LlmSystemPrompt')
        if m.get('MaxIdleTime') is not None:
            self.max_idle_time = m.get('MaxIdleTime')
        if m.get('UseVoiceprint') is not None:
            self.use_voiceprint = m.get('UseVoiceprint')
        if m.get('UserOfflineTimeout') is not None:
            self.user_offline_timeout = m.get('UserOfflineTimeout')
        if m.get('UserOnlineTimeout') is not None:
            self.user_online_timeout = m.get('UserOnlineTimeout')
        if m.get('VadLevel') is not None:
            self.vad_level = m.get('VadLevel')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceIdList') is not None:
            self.voice_id_list = m.get('VoiceIdList')
        if m.get('VoiceprintId') is not None:
            self.voiceprint_id = m.get('VoiceprintId')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        if m.get('WakeUpQuery') is not None:
            self.wake_up_query = m.get('WakeUpQuery')
        if m.get('WorkflowOverrideParams') is not None:
            self.workflow_override_params = m.get('WorkflowOverrideParams')
        return self


class AIAgentTemplateConfigVisionChatLlmHistory(TeaModel):
    def __init__(
        self,
        content: str = None,
        role: str = None,
    ):
        self.content = content
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AIAgentTemplateConfigVisionChat(TeaModel):
    def __init__(
        self,
        asr_hot_words: List[str] = None,
        asr_language_id: str = None,
        asr_max_silence: int = None,
        bailian_app_params: str = None,
        char_break: bool = None,
        enable_intelligent_segment: bool = None,
        enable_push_to_talk: bool = None,
        enable_voice_interrupt: bool = None,
        graceful_shutdown: bool = None,
        greeting: str = None,
        interrupt_words: List[str] = None,
        llm_history: List[AIAgentTemplateConfigVisionChatLlmHistory] = None,
        llm_history_limit: int = None,
        llm_system_prompt: str = None,
        max_idle_time: int = None,
        use_voiceprint: bool = None,
        user_offline_timeout: int = None,
        user_online_timeout: int = None,
        vad_level: int = None,
        voice_id: str = None,
        voice_id_list: List[str] = None,
        voiceprint_id: str = None,
        volume: int = None,
        wake_up_query: str = None,
        workflow_override_params: str = None,
    ):
        self.asr_hot_words = asr_hot_words
        self.asr_language_id = asr_language_id
        self.asr_max_silence = asr_max_silence
        self.bailian_app_params = bailian_app_params
        self.char_break = char_break
        self.enable_intelligent_segment = enable_intelligent_segment
        self.enable_push_to_talk = enable_push_to_talk
        self.enable_voice_interrupt = enable_voice_interrupt
        self.graceful_shutdown = graceful_shutdown
        self.greeting = greeting
        self.interrupt_words = interrupt_words
        self.llm_history = llm_history
        self.llm_history_limit = llm_history_limit
        self.llm_system_prompt = llm_system_prompt
        self.max_idle_time = max_idle_time
        self.use_voiceprint = use_voiceprint
        self.user_offline_timeout = user_offline_timeout
        self.user_online_timeout = user_online_timeout
        self.vad_level = vad_level
        self.voice_id = voice_id
        self.voice_id_list = voice_id_list
        self.voiceprint_id = voiceprint_id
        self.volume = volume
        self.wake_up_query = wake_up_query
        self.workflow_override_params = workflow_override_params

    def validate(self):
        if self.llm_history:
            for k in self.llm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_hot_words is not None:
            result['AsrHotWords'] = self.asr_hot_words
        if self.asr_language_id is not None:
            result['AsrLanguageId'] = self.asr_language_id
        if self.asr_max_silence is not None:
            result['AsrMaxSilence'] = self.asr_max_silence
        if self.bailian_app_params is not None:
            result['BailianAppParams'] = self.bailian_app_params
        if self.char_break is not None:
            result['CharBreak'] = self.char_break
        if self.enable_intelligent_segment is not None:
            result['EnableIntelligentSegment'] = self.enable_intelligent_segment
        if self.enable_push_to_talk is not None:
            result['EnablePushToTalk'] = self.enable_push_to_talk
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.graceful_shutdown is not None:
            result['GracefulShutdown'] = self.graceful_shutdown
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.interrupt_words is not None:
            result['InterruptWords'] = self.interrupt_words
        result['LlmHistory'] = []
        if self.llm_history is not None:
            for k in self.llm_history:
                result['LlmHistory'].append(k.to_map() if k else None)
        if self.llm_history_limit is not None:
            result['LlmHistoryLimit'] = self.llm_history_limit
        if self.llm_system_prompt is not None:
            result['LlmSystemPrompt'] = self.llm_system_prompt
        if self.max_idle_time is not None:
            result['MaxIdleTime'] = self.max_idle_time
        if self.use_voiceprint is not None:
            result['UseVoiceprint'] = self.use_voiceprint
        if self.user_offline_timeout is not None:
            result['UserOfflineTimeout'] = self.user_offline_timeout
        if self.user_online_timeout is not None:
            result['UserOnlineTimeout'] = self.user_online_timeout
        if self.vad_level is not None:
            result['VadLevel'] = self.vad_level
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_id_list is not None:
            result['VoiceIdList'] = self.voice_id_list
        if self.voiceprint_id is not None:
            result['VoiceprintId'] = self.voiceprint_id
        if self.volume is not None:
            result['Volume'] = self.volume
        if self.wake_up_query is not None:
            result['WakeUpQuery'] = self.wake_up_query
        if self.workflow_override_params is not None:
            result['WorkflowOverrideParams'] = self.workflow_override_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrHotWords') is not None:
            self.asr_hot_words = m.get('AsrHotWords')
        if m.get('AsrLanguageId') is not None:
            self.asr_language_id = m.get('AsrLanguageId')
        if m.get('AsrMaxSilence') is not None:
            self.asr_max_silence = m.get('AsrMaxSilence')
        if m.get('BailianAppParams') is not None:
            self.bailian_app_params = m.get('BailianAppParams')
        if m.get('CharBreak') is not None:
            self.char_break = m.get('CharBreak')
        if m.get('EnableIntelligentSegment') is not None:
            self.enable_intelligent_segment = m.get('EnableIntelligentSegment')
        if m.get('EnablePushToTalk') is not None:
            self.enable_push_to_talk = m.get('EnablePushToTalk')
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('GracefulShutdown') is not None:
            self.graceful_shutdown = m.get('GracefulShutdown')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('InterruptWords') is not None:
            self.interrupt_words = m.get('InterruptWords')
        self.llm_history = []
        if m.get('LlmHistory') is not None:
            for k in m.get('LlmHistory'):
                temp_model = AIAgentTemplateConfigVisionChatLlmHistory()
                self.llm_history.append(temp_model.from_map(k))
        if m.get('LlmHistoryLimit') is not None:
            self.llm_history_limit = m.get('LlmHistoryLimit')
        if m.get('LlmSystemPrompt') is not None:
            self.llm_system_prompt = m.get('LlmSystemPrompt')
        if m.get('MaxIdleTime') is not None:
            self.max_idle_time = m.get('MaxIdleTime')
        if m.get('UseVoiceprint') is not None:
            self.use_voiceprint = m.get('UseVoiceprint')
        if m.get('UserOfflineTimeout') is not None:
            self.user_offline_timeout = m.get('UserOfflineTimeout')
        if m.get('UserOnlineTimeout') is not None:
            self.user_online_timeout = m.get('UserOnlineTimeout')
        if m.get('VadLevel') is not None:
            self.vad_level = m.get('VadLevel')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceIdList') is not None:
            self.voice_id_list = m.get('VoiceIdList')
        if m.get('VoiceprintId') is not None:
            self.voiceprint_id = m.get('VoiceprintId')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        if m.get('WakeUpQuery') is not None:
            self.wake_up_query = m.get('WakeUpQuery')
        if m.get('WorkflowOverrideParams') is not None:
            self.workflow_override_params = m.get('WorkflowOverrideParams')
        return self


class AIAgentTemplateConfigVoiceChatLlmHistory(TeaModel):
    def __init__(
        self,
        content: str = None,
        role: str = None,
    ):
        self.content = content
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class AIAgentTemplateConfigVoiceChat(TeaModel):
    def __init__(
        self,
        asr_hot_words: List[str] = None,
        asr_language_id: str = None,
        asr_max_silence: int = None,
        avatar_url: str = None,
        avatar_url_type: str = None,
        bailian_app_params: str = None,
        char_break: bool = None,
        enable_intelligent_segment: bool = None,
        enable_push_to_talk: bool = None,
        enable_voice_interrupt: bool = None,
        graceful_shutdown: bool = None,
        greeting: str = None,
        interrupt_words: List[str] = None,
        llm_history: List[AIAgentTemplateConfigVoiceChatLlmHistory] = None,
        llm_history_limit: int = None,
        llm_system_prompt: str = None,
        max_idle_time: int = None,
        use_voiceprint: bool = None,
        user_offline_timeout: int = None,
        user_online_timeout: int = None,
        vad_level: int = None,
        voice_id: str = None,
        voice_id_list: List[str] = None,
        voiceprint_id: str = None,
        volume: int = None,
        wake_up_query: str = None,
        workflow_override_params: str = None,
    ):
        self.asr_hot_words = asr_hot_words
        self.asr_language_id = asr_language_id
        self.asr_max_silence = asr_max_silence
        self.avatar_url = avatar_url
        self.avatar_url_type = avatar_url_type
        self.bailian_app_params = bailian_app_params
        self.char_break = char_break
        self.enable_intelligent_segment = enable_intelligent_segment
        self.enable_push_to_talk = enable_push_to_talk
        self.enable_voice_interrupt = enable_voice_interrupt
        self.graceful_shutdown = graceful_shutdown
        self.greeting = greeting
        self.interrupt_words = interrupt_words
        self.llm_history = llm_history
        self.llm_history_limit = llm_history_limit
        self.llm_system_prompt = llm_system_prompt
        self.max_idle_time = max_idle_time
        self.use_voiceprint = use_voiceprint
        self.user_offline_timeout = user_offline_timeout
        self.user_online_timeout = user_online_timeout
        self.vad_level = vad_level
        self.voice_id = voice_id
        self.voice_id_list = voice_id_list
        self.voiceprint_id = voiceprint_id
        self.volume = volume
        self.wake_up_query = wake_up_query
        self.workflow_override_params = workflow_override_params

    def validate(self):
        if self.llm_history:
            for k in self.llm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asr_hot_words is not None:
            result['AsrHotWords'] = self.asr_hot_words
        if self.asr_language_id is not None:
            result['AsrLanguageId'] = self.asr_language_id
        if self.asr_max_silence is not None:
            result['AsrMaxSilence'] = self.asr_max_silence
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.avatar_url_type is not None:
            result['AvatarUrlType'] = self.avatar_url_type
        if self.bailian_app_params is not None:
            result['BailianAppParams'] = self.bailian_app_params
        if self.char_break is not None:
            result['CharBreak'] = self.char_break
        if self.enable_intelligent_segment is not None:
            result['EnableIntelligentSegment'] = self.enable_intelligent_segment
        if self.enable_push_to_talk is not None:
            result['EnablePushToTalk'] = self.enable_push_to_talk
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.graceful_shutdown is not None:
            result['GracefulShutdown'] = self.graceful_shutdown
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.interrupt_words is not None:
            result['InterruptWords'] = self.interrupt_words
        result['LlmHistory'] = []
        if self.llm_history is not None:
            for k in self.llm_history:
                result['LlmHistory'].append(k.to_map() if k else None)
        if self.llm_history_limit is not None:
            result['LlmHistoryLimit'] = self.llm_history_limit
        if self.llm_system_prompt is not None:
            result['LlmSystemPrompt'] = self.llm_system_prompt
        if self.max_idle_time is not None:
            result['MaxIdleTime'] = self.max_idle_time
        if self.use_voiceprint is not None:
            result['UseVoiceprint'] = self.use_voiceprint
        if self.user_offline_timeout is not None:
            result['UserOfflineTimeout'] = self.user_offline_timeout
        if self.user_online_timeout is not None:
            result['UserOnlineTimeout'] = self.user_online_timeout
        if self.vad_level is not None:
            result['VadLevel'] = self.vad_level
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_id_list is not None:
            result['VoiceIdList'] = self.voice_id_list
        if self.voiceprint_id is not None:
            result['VoiceprintId'] = self.voiceprint_id
        if self.volume is not None:
            result['Volume'] = self.volume
        if self.wake_up_query is not None:
            result['WakeUpQuery'] = self.wake_up_query
        if self.workflow_override_params is not None:
            result['WorkflowOverrideParams'] = self.workflow_override_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsrHotWords') is not None:
            self.asr_hot_words = m.get('AsrHotWords')
        if m.get('AsrLanguageId') is not None:
            self.asr_language_id = m.get('AsrLanguageId')
        if m.get('AsrMaxSilence') is not None:
            self.asr_max_silence = m.get('AsrMaxSilence')
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('AvatarUrlType') is not None:
            self.avatar_url_type = m.get('AvatarUrlType')
        if m.get('BailianAppParams') is not None:
            self.bailian_app_params = m.get('BailianAppParams')
        if m.get('CharBreak') is not None:
            self.char_break = m.get('CharBreak')
        if m.get('EnableIntelligentSegment') is not None:
            self.enable_intelligent_segment = m.get('EnableIntelligentSegment')
        if m.get('EnablePushToTalk') is not None:
            self.enable_push_to_talk = m.get('EnablePushToTalk')
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('GracefulShutdown') is not None:
            self.graceful_shutdown = m.get('GracefulShutdown')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('InterruptWords') is not None:
            self.interrupt_words = m.get('InterruptWords')
        self.llm_history = []
        if m.get('LlmHistory') is not None:
            for k in m.get('LlmHistory'):
                temp_model = AIAgentTemplateConfigVoiceChatLlmHistory()
                self.llm_history.append(temp_model.from_map(k))
        if m.get('LlmHistoryLimit') is not None:
            self.llm_history_limit = m.get('LlmHistoryLimit')
        if m.get('LlmSystemPrompt') is not None:
            self.llm_system_prompt = m.get('LlmSystemPrompt')
        if m.get('MaxIdleTime') is not None:
            self.max_idle_time = m.get('MaxIdleTime')
        if m.get('UseVoiceprint') is not None:
            self.use_voiceprint = m.get('UseVoiceprint')
        if m.get('UserOfflineTimeout') is not None:
            self.user_offline_timeout = m.get('UserOfflineTimeout')
        if m.get('UserOnlineTimeout') is not None:
            self.user_online_timeout = m.get('UserOnlineTimeout')
        if m.get('VadLevel') is not None:
            self.vad_level = m.get('VadLevel')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceIdList') is not None:
            self.voice_id_list = m.get('VoiceIdList')
        if m.get('VoiceprintId') is not None:
            self.voiceprint_id = m.get('VoiceprintId')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        if m.get('WakeUpQuery') is not None:
            self.wake_up_query = m.get('WakeUpQuery')
        if m.get('WorkflowOverrideParams') is not None:
            self.workflow_override_params = m.get('WorkflowOverrideParams')
        return self


class AIAgentTemplateConfig(TeaModel):
    def __init__(
        self,
        avatar_chat_3d: AIAgentTemplateConfigAvatarChat3D = None,
        vision_chat: AIAgentTemplateConfigVisionChat = None,
        voice_chat: AIAgentTemplateConfigVoiceChat = None,
    ):
        self.avatar_chat_3d = avatar_chat_3d
        self.vision_chat = vision_chat
        self.voice_chat = voice_chat

    def validate(self):
        if self.avatar_chat_3d:
            self.avatar_chat_3d.validate()
        if self.vision_chat:
            self.vision_chat.validate()
        if self.voice_chat:
            self.voice_chat.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_chat_3d is not None:
            result['AvatarChat3D'] = self.avatar_chat_3d.to_map()
        if self.vision_chat is not None:
            result['VisionChat'] = self.vision_chat.to_map()
        if self.voice_chat is not None:
            result['VoiceChat'] = self.voice_chat.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarChat3D') is not None:
            temp_model = AIAgentTemplateConfigAvatarChat3D()
            self.avatar_chat_3d = temp_model.from_map(m['AvatarChat3D'])
        if m.get('VisionChat') is not None:
            temp_model = AIAgentTemplateConfigVisionChat()
            self.vision_chat = temp_model.from_map(m['VisionChat'])
        if m.get('VoiceChat') is not None:
            temp_model = AIAgentTemplateConfigVoiceChat()
            self.voice_chat = temp_model.from_map(m['VoiceChat'])
        return self


class AppInfoDTOPlatforms(TeaModel):
    def __init__(
        self,
        item_id: str = None,
        license_item_ids: List[str] = None,
        pkg_name: str = None,
        pkg_signature: str = None,
        platform_type: int = None,
        type: int = None,
    ):
        self.item_id = item_id
        self.license_item_ids = license_item_ids
        self.pkg_name = pkg_name
        self.pkg_signature = pkg_signature
        self.platform_type = platform_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.license_item_ids is not None:
            result['LicenseItemIds'] = self.license_item_ids
        if self.pkg_name is not None:
            result['PkgName'] = self.pkg_name
        if self.pkg_signature is not None:
            result['PkgSignature'] = self.pkg_signature
        if self.platform_type is not None:
            result['PlatformType'] = self.platform_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('LicenseItemIds') is not None:
            self.license_item_ids = m.get('LicenseItemIds')
        if m.get('PkgName') is not None:
            self.pkg_name = m.get('PkgName')
        if m.get('PkgSignature') is not None:
            self.pkg_signature = m.get('PkgSignature')
        if m.get('PlatformType') is not None:
            self.platform_type = m.get('PlatformType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AppInfoDTO(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        app_type: int = None,
        creation_time: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        item_id: str = None,
        modification_time: str = None,
        platforms: List[AppInfoDTOPlatforms] = None,
        user_id: int = None,
    ):
        self.app_name = app_name
        self.app_type = app_type
        self.creation_time = creation_time
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.item_id = item_id
        self.modification_time = modification_time
        self.platforms = platforms
        self.user_id = user_id

    def validate(self):
        if self.platforms:
            for k in self.platforms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        result['Platforms'] = []
        if self.platforms is not None:
            for k in self.platforms:
                result['Platforms'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        self.platforms = []
        if m.get('Platforms') is not None:
            for k in m.get('Platforms'):
                temp_model = AppInfoDTOPlatforms()
                self.platforms.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ChannelOutPutConfigList(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        format: str = None,
        manifest_name: str = None,
        manifest_settings: str = None,
        playback_url: str = None,
        source_group_name: str = None,
    ):
        self.channel_name = channel_name
        self.format = format
        self.manifest_name = manifest_name
        self.manifest_settings = manifest_settings
        self.playback_url = playback_url
        self.source_group_name = source_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.format is not None:
            result['Format'] = self.format
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.manifest_settings is not None:
            result['ManifestSettings'] = self.manifest_settings
        if self.playback_url is not None:
            result['PlaybackUrl'] = self.playback_url
        if self.source_group_name is not None:
            result['SourceGroupName'] = self.source_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('ManifestSettings') is not None:
            self.manifest_settings = m.get('ManifestSettings')
        if m.get('PlaybackUrl') is not None:
            self.playback_url = m.get('PlaybackUrl')
        if m.get('SourceGroupName') is not None:
            self.source_group_name = m.get('SourceGroupName')
        return self


class Channel(TeaModel):
    def __init__(
        self,
        access_policy: bool = None,
        access_token: str = None,
        arn: str = None,
        channel_name: str = None,
        channel_tier: str = None,
        filler_source_location_name: str = None,
        filler_source_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        out_put_config_list: List[ChannelOutPutConfigList] = None,
        playback_mode: str = None,
        state: int = None,
    ):
        self.access_policy = access_policy
        self.access_token = access_token
        self.arn = arn
        self.channel_name = channel_name
        self.channel_tier = channel_tier
        self.filler_source_location_name = filler_source_location_name
        self.filler_source_name = filler_source_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.out_put_config_list = out_put_config_list
        self.playback_mode = playback_mode
        self.state = state

    def validate(self):
        if self.out_put_config_list:
            for k in self.out_put_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_policy is not None:
            result['AccessPolicy'] = self.access_policy
        if self.access_token is not None:
            result['AccessToken'] = self.access_token
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_tier is not None:
            result['ChannelTier'] = self.channel_tier
        if self.filler_source_location_name is not None:
            result['FillerSourceLocationName'] = self.filler_source_location_name
        if self.filler_source_name is not None:
            result['FillerSourceName'] = self.filler_source_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['OutPutConfigList'] = []
        if self.out_put_config_list is not None:
            for k in self.out_put_config_list:
                result['OutPutConfigList'].append(k.to_map() if k else None)
        if self.playback_mode is not None:
            result['PlaybackMode'] = self.playback_mode
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPolicy') is not None:
            self.access_policy = m.get('AccessPolicy')
        if m.get('AccessToken') is not None:
            self.access_token = m.get('AccessToken')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelTier') is not None:
            self.channel_tier = m.get('ChannelTier')
        if m.get('FillerSourceLocationName') is not None:
            self.filler_source_location_name = m.get('FillerSourceLocationName')
        if m.get('FillerSourceName') is not None:
            self.filler_source_name = m.get('FillerSourceName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.out_put_config_list = []
        if m.get('OutPutConfigList') is not None:
            for k in m.get('OutPutConfigList'):
                temp_model = ChannelOutPutConfigList()
                self.out_put_config_list.append(temp_model.from_map(k))
        if m.get('PlaybackMode') is not None:
            self.playback_mode = m.get('PlaybackMode')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ChannelAssemblyChannelOutPutConfigList(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        format: str = None,
        manifest_name: str = None,
        manifest_settings: str = None,
        playback_url: str = None,
        source_group_name: str = None,
    ):
        self.channel_name = channel_name
        self.format = format
        self.manifest_name = manifest_name
        self.manifest_settings = manifest_settings
        self.playback_url = playback_url
        self.source_group_name = source_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.format is not None:
            result['Format'] = self.format
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.manifest_settings is not None:
            result['ManifestSettings'] = self.manifest_settings
        if self.playback_url is not None:
            result['PlaybackUrl'] = self.playback_url
        if self.source_group_name is not None:
            result['SourceGroupName'] = self.source_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('ManifestSettings') is not None:
            self.manifest_settings = m.get('ManifestSettings')
        if m.get('PlaybackUrl') is not None:
            self.playback_url = m.get('PlaybackUrl')
        if m.get('SourceGroupName') is not None:
            self.source_group_name = m.get('SourceGroupName')
        return self


class ChannelAssemblyChannel(TeaModel):
    def __init__(
        self,
        access_policy: bool = None,
        access_token: str = None,
        arn: str = None,
        channel_name: str = None,
        channel_tier: str = None,
        filler_source_location_name: str = None,
        filler_source_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        out_put_config_list: List[ChannelAssemblyChannelOutPutConfigList] = None,
        playback_mode: str = None,
        state: int = None,
    ):
        self.access_policy = access_policy
        self.access_token = access_token
        self.arn = arn
        self.channel_name = channel_name
        self.channel_tier = channel_tier
        self.filler_source_location_name = filler_source_location_name
        self.filler_source_name = filler_source_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.out_put_config_list = out_put_config_list
        self.playback_mode = playback_mode
        self.state = state

    def validate(self):
        if self.out_put_config_list:
            for k in self.out_put_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_policy is not None:
            result['AccessPolicy'] = self.access_policy
        if self.access_token is not None:
            result['AccessToken'] = self.access_token
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_tier is not None:
            result['ChannelTier'] = self.channel_tier
        if self.filler_source_location_name is not None:
            result['FillerSourceLocationName'] = self.filler_source_location_name
        if self.filler_source_name is not None:
            result['FillerSourceName'] = self.filler_source_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['OutPutConfigList'] = []
        if self.out_put_config_list is not None:
            for k in self.out_put_config_list:
                result['OutPutConfigList'].append(k.to_map() if k else None)
        if self.playback_mode is not None:
            result['PlaybackMode'] = self.playback_mode
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPolicy') is not None:
            self.access_policy = m.get('AccessPolicy')
        if m.get('AccessToken') is not None:
            self.access_token = m.get('AccessToken')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelTier') is not None:
            self.channel_tier = m.get('ChannelTier')
        if m.get('FillerSourceLocationName') is not None:
            self.filler_source_location_name = m.get('FillerSourceLocationName')
        if m.get('FillerSourceName') is not None:
            self.filler_source_name = m.get('FillerSourceName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.out_put_config_list = []
        if m.get('OutPutConfigList') is not None:
            for k in m.get('OutPutConfigList'):
                temp_model = ChannelAssemblyChannelOutPutConfigList()
                self.out_put_config_list.append(temp_model.from_map(k))
        if m.get('PlaybackMode') is not None:
            self.playback_mode = m.get('PlaybackMode')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ChannelAssemblyProgramAdBreaks(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        message_type: str = None,
        offset_millis: int = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        splice_insert_settings: str = None,
        time_signal_settings: str = None,
    ):
        self.channel_name = channel_name
        self.message_type = message_type
        self.offset_millis = offset_millis
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.splice_insert_settings = splice_insert_settings
        self.time_signal_settings = time_signal_settings

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        if self.offset_millis is not None:
            result['OffsetMillis'] = self.offset_millis
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.splice_insert_settings is not None:
            result['SpliceInsertSettings'] = self.splice_insert_settings
        if self.time_signal_settings is not None:
            result['TimeSignalSettings'] = self.time_signal_settings
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        if m.get('OffsetMillis') is not None:
            self.offset_millis = m.get('OffsetMillis')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SpliceInsertSettings') is not None:
            self.splice_insert_settings = m.get('SpliceInsertSettings')
        if m.get('TimeSignalSettings') is not None:
            self.time_signal_settings = m.get('TimeSignalSettings')
        return self


class ChannelAssemblyProgram(TeaModel):
    def __init__(
        self,
        ad_breaks: List[ChannelAssemblyProgramAdBreaks] = None,
        arn: str = None,
        channel_name: str = None,
        clip_range: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
        transition: str = None,
    ):
        self.ad_breaks = ad_breaks
        self.arn = arn
        self.channel_name = channel_name
        self.clip_range = clip_range
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type
        self.transition = transition

    def validate(self):
        if self.ad_breaks:
            for k in self.ad_breaks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdBreaks'] = []
        if self.ad_breaks is not None:
            for k in self.ad_breaks:
                result['AdBreaks'].append(k.to_map() if k else None)
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.clip_range is not None:
            result['ClipRange'] = self.clip_range
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.transition is not None:
            result['Transition'] = self.transition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_breaks = []
        if m.get('AdBreaks') is not None:
            for k in m.get('AdBreaks'):
                temp_model = ChannelAssemblyProgramAdBreaks()
                self.ad_breaks.append(temp_model.from_map(k))
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClipRange') is not None:
            self.clip_range = m.get('ClipRange')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        return self


class ChannelAssemblyScheduleDataAdBreaks(TeaModel):
    def __init__(
        self,
        message_type: str = None,
        offset_millis: str = None,
        source_location_name: str = None,
        source_name: str = None,
        splice_insert_settings: str = None,
        time_signal_settings: str = None,
    ):
        self.message_type = message_type
        self.offset_millis = offset_millis
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.splice_insert_settings = splice_insert_settings
        self.time_signal_settings = time_signal_settings

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        if self.offset_millis is not None:
            result['OffsetMillis'] = self.offset_millis
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.splice_insert_settings is not None:
            result['SpliceInsertSettings'] = self.splice_insert_settings
        if self.time_signal_settings is not None:
            result['TimeSignalSettings'] = self.time_signal_settings
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        if m.get('OffsetMillis') is not None:
            self.offset_millis = m.get('OffsetMillis')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SpliceInsertSettings') is not None:
            self.splice_insert_settings = m.get('SpliceInsertSettings')
        if m.get('TimeSignalSettings') is not None:
            self.time_signal_settings = m.get('TimeSignalSettings')
        return self


class ChannelAssemblyScheduleData(TeaModel):
    def __init__(
        self,
        ad_breaks: List[ChannelAssemblyScheduleDataAdBreaks] = None,
        approximate_duration_seconds: int = None,
        approximate_start_time: str = None,
        entry_type: str = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
    ):
        self.ad_breaks = ad_breaks
        self.approximate_duration_seconds = approximate_duration_seconds
        self.approximate_start_time = approximate_start_time
        self.entry_type = entry_type
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type

    def validate(self):
        if self.ad_breaks:
            for k in self.ad_breaks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdBreaks'] = []
        if self.ad_breaks is not None:
            for k in self.ad_breaks:
                result['AdBreaks'].append(k.to_map() if k else None)
        if self.approximate_duration_seconds is not None:
            result['ApproximateDurationSeconds'] = self.approximate_duration_seconds
        if self.approximate_start_time is not None:
            result['ApproximateStartTime'] = self.approximate_start_time
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_breaks = []
        if m.get('AdBreaks') is not None:
            for k in m.get('AdBreaks'):
                temp_model = ChannelAssemblyScheduleDataAdBreaks()
                self.ad_breaks.append(temp_model.from_map(k))
        if m.get('ApproximateDurationSeconds') is not None:
            self.approximate_duration_seconds = m.get('ApproximateDurationSeconds')
        if m.get('ApproximateStartTime') is not None:
            self.approximate_start_time = m.get('ApproximateStartTime')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ChannelAssemblySource(TeaModel):
    def __init__(
        self,
        arn: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        http_package_configurations: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
        state: int = None,
    ):
        self.arn = arn
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.http_package_configurations = http_package_configurations
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.http_package_configurations is not None:
            result['HttpPackageConfigurations'] = self.http_package_configurations
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HttpPackageConfigurations') is not None:
            self.http_package_configurations = m.get('HttpPackageConfigurations')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ChannelAssemblySourceLocation(TeaModel):
    def __init__(
        self,
        arn: str = None,
        base_url: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        segment_delivery_configurations: str = None,
        source_location_name: str = None,
        state: int = None,
    ):
        self.arn = arn
        self.base_url = base_url
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.segment_delivery_configurations = segment_delivery_configurations
        self.source_location_name = source_location_name
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.base_url is not None:
            result['BaseUrl'] = self.base_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.segment_delivery_configurations is not None:
            result['SegmentDeliveryConfigurations'] = self.segment_delivery_configurations
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('BaseUrl') is not None:
            self.base_url = m.get('BaseUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('SegmentDeliveryConfigurations') is not None:
            self.segment_delivery_configurations = m.get('SegmentDeliveryConfigurations')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class TranspositionResult(TeaModel):
    def __init__(
        self,
        target_language: str = None,
        translated_text: str = None,
    ):
        self.target_language = target_language
        self.translated_text = translated_text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_language is not None:
            result['TargetLanguage'] = self.target_language
        if self.translated_text is not None:
            result['TranslatedText'] = self.translated_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetLanguage') is not None:
            self.target_language = m.get('TargetLanguage')
        if m.get('TranslatedText') is not None:
            self.translated_text = m.get('TranslatedText')
        return self


class Hotword(TeaModel):
    def __init__(
        self,
        language: str = None,
        text: str = None,
        transposition_result_list: List[TranspositionResult] = None,
        weight: int = None,
    ):
        self.language = language
        self.text = text
        self.transposition_result_list = transposition_result_list
        self.weight = weight

    def validate(self):
        if self.transposition_result_list:
            for k in self.transposition_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language is not None:
            result['Language'] = self.language
        if self.text is not None:
            result['Text'] = self.text
        result['TranspositionResultList'] = []
        if self.transposition_result_list is not None:
            for k in self.transposition_result_list:
                result['TranspositionResultList'].append(k.to_map() if k else None)
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        self.transposition_result_list = []
        if m.get('TranspositionResultList') is not None:
            for k in m.get('TranspositionResultList'):
                temp_model = TranspositionResult()
                self.transposition_result_list.append(temp_model.from_map(k))
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class LicenseInstanceAppDTOLicenseConfigs(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        feature_ids: str = None,
        is_trial: bool = None,
        sdk_id: int = None,
        sdk_name: str = None,
        subscription: str = None,
        subscription_imp: str = None,
        subscription_pkg: str = None,
    ):
        self.business_type = business_type
        self.feature_ids = feature_ids
        self.is_trial = is_trial
        self.sdk_id = sdk_id
        self.sdk_name = sdk_name
        self.subscription = subscription
        self.subscription_imp = subscription_imp
        self.subscription_pkg = subscription_pkg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.feature_ids is not None:
            result['FeatureIds'] = self.feature_ids
        if self.is_trial is not None:
            result['IsTrial'] = self.is_trial
        if self.sdk_id is not None:
            result['SdkId'] = self.sdk_id
        if self.sdk_name is not None:
            result['SdkName'] = self.sdk_name
        if self.subscription is not None:
            result['Subscription'] = self.subscription
        if self.subscription_imp is not None:
            result['SubscriptionImp'] = self.subscription_imp
        if self.subscription_pkg is not None:
            result['SubscriptionPkg'] = self.subscription_pkg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('FeatureIds') is not None:
            self.feature_ids = m.get('FeatureIds')
        if m.get('IsTrial') is not None:
            self.is_trial = m.get('IsTrial')
        if m.get('SdkId') is not None:
            self.sdk_id = m.get('SdkId')
        if m.get('SdkName') is not None:
            self.sdk_name = m.get('SdkName')
        if m.get('Subscription') is not None:
            self.subscription = m.get('Subscription')
        if m.get('SubscriptionImp') is not None:
            self.subscription_imp = m.get('SubscriptionImp')
        if m.get('SubscriptionPkg') is not None:
            self.subscription_pkg = m.get('SubscriptionPkg')
        return self


class LicenseInstanceAppDTO(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        begin_on: str = None,
        contract_no: str = None,
        creation_time: str = None,
        expired_on: str = None,
        instance_id: str = None,
        item_id: str = None,
        license_configs: List[LicenseInstanceAppDTOLicenseConfigs] = None,
        modification_time: str = None,
        status: str = None,
        user_id: int = None,
    ):
        self.app_id = app_id
        self.begin_on = begin_on
        self.contract_no = contract_no
        self.creation_time = creation_time
        self.expired_on = expired_on
        self.instance_id = instance_id
        self.item_id = item_id
        self.license_configs = license_configs
        self.modification_time = modification_time
        self.status = status
        self.user_id = user_id

    def validate(self):
        if self.license_configs:
            for k in self.license_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.begin_on is not None:
            result['BeginOn'] = self.begin_on
        if self.contract_no is not None:
            result['ContractNo'] = self.contract_no
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.expired_on is not None:
            result['ExpiredOn'] = self.expired_on
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        result['LicenseConfigs'] = []
        if self.license_configs is not None:
            for k in self.license_configs:
                result['LicenseConfigs'].append(k.to_map() if k else None)
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('BeginOn') is not None:
            self.begin_on = m.get('BeginOn')
        if m.get('ContractNo') is not None:
            self.contract_no = m.get('ContractNo')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ExpiredOn') is not None:
            self.expired_on = m.get('ExpiredOn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        self.license_configs = []
        if m.get('LicenseConfigs') is not None:
            for k in m.get('LicenseConfigs'):
                temp_model = LicenseInstanceAppDTOLicenseConfigs()
                self.license_configs.append(temp_model.from_map(k))
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class LiveManifestConfig(TeaModel):
    def __init__(
        self,
        ad_markers: str = None,
        date_time_interval: int = None,
        manifest_duration: int = None,
        max_video_bitrate: int = None,
        min_buffer_time: int = None,
        min_update_period: int = None,
        min_video_bitrate: int = None,
        presentation_delay: int = None,
        segment_count: int = None,
        segment_template_format: str = None,
        stream_order: str = None,
    ):
        self.ad_markers = ad_markers
        self.date_time_interval = date_time_interval
        self.manifest_duration = manifest_duration
        self.max_video_bitrate = max_video_bitrate
        self.min_buffer_time = min_buffer_time
        self.min_update_period = min_update_period
        self.min_video_bitrate = min_video_bitrate
        self.presentation_delay = presentation_delay
        self.segment_count = segment_count
        self.segment_template_format = segment_template_format
        self.stream_order = stream_order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_markers is not None:
            result['AdMarkers'] = self.ad_markers
        if self.date_time_interval is not None:
            result['DateTimeInterval'] = self.date_time_interval
        if self.manifest_duration is not None:
            result['ManifestDuration'] = self.manifest_duration
        if self.max_video_bitrate is not None:
            result['MaxVideoBitrate'] = self.max_video_bitrate
        if self.min_buffer_time is not None:
            result['MinBufferTime'] = self.min_buffer_time
        if self.min_update_period is not None:
            result['MinUpdatePeriod'] = self.min_update_period
        if self.min_video_bitrate is not None:
            result['MinVideoBitrate'] = self.min_video_bitrate
        if self.presentation_delay is not None:
            result['PresentationDelay'] = self.presentation_delay
        if self.segment_count is not None:
            result['SegmentCount'] = self.segment_count
        if self.segment_template_format is not None:
            result['SegmentTemplateFormat'] = self.segment_template_format
        if self.stream_order is not None:
            result['StreamOrder'] = self.stream_order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdMarkers') is not None:
            self.ad_markers = m.get('AdMarkers')
        if m.get('DateTimeInterval') is not None:
            self.date_time_interval = m.get('DateTimeInterval')
        if m.get('ManifestDuration') is not None:
            self.manifest_duration = m.get('ManifestDuration')
        if m.get('MaxVideoBitrate') is not None:
            self.max_video_bitrate = m.get('MaxVideoBitrate')
        if m.get('MinBufferTime') is not None:
            self.min_buffer_time = m.get('MinBufferTime')
        if m.get('MinUpdatePeriod') is not None:
            self.min_update_period = m.get('MinUpdatePeriod')
        if m.get('MinVideoBitrate') is not None:
            self.min_video_bitrate = m.get('MinVideoBitrate')
        if m.get('PresentationDelay') is not None:
            self.presentation_delay = m.get('PresentationDelay')
        if m.get('SegmentCount') is not None:
            self.segment_count = m.get('SegmentCount')
        if m.get('SegmentTemplateFormat') is not None:
            self.segment_template_format = m.get('SegmentTemplateFormat')
        if m.get('StreamOrder') is not None:
            self.stream_order = m.get('StreamOrder')
        return self


class LivePackagingConfigDrmConfig(TeaModel):
    def __init__(
        self,
        content_id: str = None,
        encryption_method: str = None,
        iv: str = None,
        rotate_period: int = None,
        system_ids: List[str] = None,
        url: str = None,
    ):
        self.content_id = content_id
        self.encryption_method = encryption_method
        self.iv = iv
        self.rotate_period = rotate_period
        self.system_ids = system_ids
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_id is not None:
            result['ContentId'] = self.content_id
        if self.encryption_method is not None:
            result['EncryptionMethod'] = self.encryption_method
        if self.iv is not None:
            result['IV'] = self.iv
        if self.rotate_period is not None:
            result['RotatePeriod'] = self.rotate_period
        if self.system_ids is not None:
            result['SystemIds'] = self.system_ids
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentId') is not None:
            self.content_id = m.get('ContentId')
        if m.get('EncryptionMethod') is not None:
            self.encryption_method = m.get('EncryptionMethod')
        if m.get('IV') is not None:
            self.iv = m.get('IV')
        if m.get('RotatePeriod') is not None:
            self.rotate_period = m.get('RotatePeriod')
        if m.get('SystemIds') is not None:
            self.system_ids = m.get('SystemIds')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class LivePackagingConfig(TeaModel):
    def __init__(
        self,
        drm_config: LivePackagingConfigDrmConfig = None,
        live_manifest_configs: List[LiveManifestConfig] = None,
        segment_duration: int = None,
        use_audio_rendition_groups: bool = None,
    ):
        self.drm_config = drm_config
        self.live_manifest_configs = live_manifest_configs
        self.segment_duration = segment_duration
        self.use_audio_rendition_groups = use_audio_rendition_groups

    def validate(self):
        if self.drm_config:
            self.drm_config.validate()
        if self.live_manifest_configs:
            for k in self.live_manifest_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drm_config is not None:
            result['DrmConfig'] = self.drm_config.to_map()
        result['LiveManifestConfigs'] = []
        if self.live_manifest_configs is not None:
            for k in self.live_manifest_configs:
                result['LiveManifestConfigs'].append(k.to_map() if k else None)
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        if self.use_audio_rendition_groups is not None:
            result['UseAudioRenditionGroups'] = self.use_audio_rendition_groups
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DrmConfig') is not None:
            temp_model = LivePackagingConfigDrmConfig()
            self.drm_config = temp_model.from_map(m['DrmConfig'])
        self.live_manifest_configs = []
        if m.get('LiveManifestConfigs') is not None:
            for k in m.get('LiveManifestConfigs'):
                temp_model = LiveManifestConfig()
                self.live_manifest_configs.append(temp_model.from_map(k))
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        if m.get('UseAudioRenditionGroups') is not None:
            self.use_audio_rendition_groups = m.get('UseAudioRenditionGroups')
        return self


class MediaConvertAudio(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        channels: int = None,
        codec: str = None,
        profile: str = None,
        remove: bool = None,
        samplerate: str = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.remove = remove
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class MediaObject(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
        url: str = None,
    ):
        self.media = media
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class MediaConvertInput(TeaModel):
    def __init__(
        self,
        input_file: MediaObject = None,
        name: str = None,
    ):
        self.input_file = input_file
        self.name = name

    def validate(self):
        if self.input_file:
            self.input_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file.to_map()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            temp_model = MediaObject()
            self.input_file = temp_model.from_map(m['InputFile'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class MediaConvertOutputGroupConfig(TeaModel):
    def __init__(
        self,
        manifest_name: str = None,
        output_file_base: MediaObject = None,
        type: str = None,
    ):
        self.manifest_name = manifest_name
        self.output_file_base = output_file_base
        self.type = type

    def validate(self):
        if self.output_file_base:
            self.output_file_base.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.output_file_base is not None:
            result['OutputFileBase'] = self.output_file_base.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('OutputFileBase') is not None:
            temp_model = MediaObject()
            self.output_file_base = temp_model.from_map(m['OutputFileBase'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class MediaConvertOutputGroupOutput(TeaModel):
    def __init__(
        self,
        features: str = None,
        name: str = None,
        output_file_name: str = None,
        override_params: str = None,
        priority: int = None,
        template_id: str = None,
    ):
        self.features = features
        self.name = name
        self.output_file_name = output_file_name
        self.override_params = override_params
        self.priority = priority
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.features is not None:
            result['Features'] = self.features
        if self.name is not None:
            result['Name'] = self.name
        if self.output_file_name is not None:
            result['OutputFileName'] = self.output_file_name
        if self.override_params is not None:
            result['OverrideParams'] = self.override_params
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Features') is not None:
            self.features = m.get('Features')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputFileName') is not None:
            self.output_file_name = m.get('OutputFileName')
        if m.get('OverrideParams') is not None:
            self.override_params = m.get('OverrideParams')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class MediaConvertOutputGroup(TeaModel):
    def __init__(
        self,
        group_config: MediaConvertOutputGroupConfig = None,
        name: str = None,
        outputs: List[MediaConvertOutputGroupOutput] = None,
    ):
        self.group_config = group_config
        self.name = name
        self.outputs = outputs

    def validate(self):
        if self.group_config:
            self.group_config.validate()
        if self.outputs:
            for k in self.outputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_config is not None:
            result['GroupConfig'] = self.group_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        result['Outputs'] = []
        if self.outputs is not None:
            for k in self.outputs:
                result['Outputs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupConfig') is not None:
            temp_model = MediaConvertOutputGroupConfig()
            self.group_config = temp_model.from_map(m['GroupConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.outputs = []
        if m.get('Outputs') is not None:
            for k in m.get('Outputs'):
                temp_model = MediaConvertOutputGroupOutput()
                self.outputs.append(temp_model.from_map(k))
        return self


class MediaConvertOutput(TeaModel):
    def __init__(
        self,
        features: str = None,
        name: str = None,
        output_file: MediaObject = None,
        override_params: str = None,
        priority: int = None,
        template_id: str = None,
    ):
        self.features = features
        self.name = name
        self.output_file = output_file
        self.override_params = override_params
        self.priority = priority
        self.template_id = template_id

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.features is not None:
            result['Features'] = self.features
        if self.name is not None:
            result['Name'] = self.name
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.override_params is not None:
            result['OverrideParams'] = self.override_params
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Features') is not None:
            self.features = m.get('Features')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputFile') is not None:
            temp_model = MediaObject()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('OverrideParams') is not None:
            self.override_params = m.get('OverrideParams')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class MediaConvertJobConfig(TeaModel):
    def __init__(
        self,
        inputs: List[MediaConvertInput] = None,
        job_name: str = None,
        output_groups: List[MediaConvertOutputGroup] = None,
        outputs: List[MediaConvertOutput] = None,
    ):
        self.inputs = inputs
        self.job_name = job_name
        self.output_groups = output_groups
        self.outputs = outputs

    def validate(self):
        if self.inputs:
            for k in self.inputs:
                if k:
                    k.validate()
        if self.output_groups:
            for k in self.output_groups:
                if k:
                    k.validate()
        if self.outputs:
            for k in self.outputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inputs'] = []
        if self.inputs is not None:
            for k in self.inputs:
                result['Inputs'].append(k.to_map() if k else None)
        if self.job_name is not None:
            result['JobName'] = self.job_name
        result['OutputGroups'] = []
        if self.output_groups is not None:
            for k in self.output_groups:
                result['OutputGroups'].append(k.to_map() if k else None)
        result['Outputs'] = []
        if self.outputs is not None:
            for k in self.outputs:
                result['Outputs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inputs = []
        if m.get('Inputs') is not None:
            for k in m.get('Inputs'):
                temp_model = MediaConvertInput()
                self.inputs.append(temp_model.from_map(k))
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        self.output_groups = []
        if m.get('OutputGroups') is not None:
            for k in m.get('OutputGroups'):
                temp_model = MediaConvertOutputGroup()
                self.output_groups.append(temp_model.from_map(k))
        self.outputs = []
        if m.get('Outputs') is not None:
            for k in m.get('Outputs'):
                temp_model = MediaConvertOutput()
                self.outputs.append(temp_model.from_map(k))
        return self


class MediaConvertOutputDetailResultOutputFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
        url: str = None,
    ):
        self.media = media
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class MediaConvertOutputDetailFileMetaAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        self.bitrate = bitrate
        self.channel_layout = channel_layout
        self.channels = channels
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.duration = duration
        self.index = index
        self.lang = lang
        self.sample_fmt = sample_fmt
        self.sample_rate = sample_rate
        self.start_time = start_time
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class MediaConvertOutputDetailFileMetaFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        media_id: str = None,
        region: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.duration = duration
        self.file_name = file_name
        self.file_size = file_size
        self.file_status = file_status
        self.file_type = file_type
        self.file_url = file_url
        self.format_name = format_name
        self.height = height
        self.media_id = media_id
        self.region = region
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class MediaConvertOutputDetailFileMetaVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bit_rate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        time_base: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bit_rate = bit_rate
        self.codec_long_name = codec_long_name
        self.codec_name = codec_name
        self.codec_tag = codec_tag
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        self.dar = dar
        self.duration = duration
        self.fps = fps
        self.has_bframes = has_bframes
        self.height = height
        self.index = index
        self.lang = lang
        self.level = level
        self.num_frames = num_frames
        self.pix_fmt = pix_fmt
        self.profile = profile
        self.rotate = rotate
        self.sar = sar
        self.start_time = start_time
        self.time_base = time_base
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class MediaConvertOutputDetailFileMeta(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[MediaConvertOutputDetailFileMetaAudioStreamInfoList] = None,
        file_basic_info: MediaConvertOutputDetailFileMetaFileBasicInfo = None,
        video_stream_info_list: List[MediaConvertOutputDetailFileMetaVideoStreamInfoList] = None,
    ):
        self.audio_stream_info_list = audio_stream_info_list
        self.file_basic_info = file_basic_info
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = MediaConvertOutputDetailFileMetaAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = MediaConvertOutputDetailFileMetaFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = MediaConvertOutputDetailFileMetaVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class MediaConvertOutputDetailResult(TeaModel):
    def __init__(
        self,
        out_file_meta: MediaConvertOutputDetailFileMeta = None,
        output_file: MediaConvertOutputDetailResultOutputFile = None,
    ):
        self.out_file_meta = out_file_meta
        self.output_file = output_file

    def validate(self):
        if self.out_file_meta:
            self.out_file_meta.validate()
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.out_file_meta is not None:
            result['OutFileMeta'] = self.out_file_meta.to_map()
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutFileMeta') is not None:
            temp_model = MediaConvertOutputDetailFileMeta()
            self.out_file_meta = temp_model.from_map(m['OutFileMeta'])
        if m.get('OutputFile') is not None:
            temp_model = MediaConvertOutputDetailResultOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        return self


class MediaConvertOutputDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_time: str = None,
        finish_time: str = None,
        message: str = None,
        name: str = None,
        result: MediaConvertOutputDetailResult = None,
        status: str = None,
        task_id: str = None,
    ):
        self.code = code
        self.create_time = create_time
        self.finish_time = finish_time
        self.message = message
        self.name = name
        self.result = result
        self.status = status
        self.task_id = task_id

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Result') is not None:
            temp_model = MediaConvertOutputDetailResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class MediaConvertOutputGroupDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_time: str = None,
        finish_time: str = None,
        message: str = None,
        name: str = None,
        outputs: List[MediaConvertOutputDetail] = None,
        status: str = None,
        task_id: str = None,
    ):
        self.code = code
        self.create_time = create_time
        self.finish_time = finish_time
        self.message = message
        self.name = name
        self.outputs = outputs
        self.status = status
        self.task_id = task_id

    def validate(self):
        if self.outputs:
            for k in self.outputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        result['Outputs'] = []
        if self.outputs is not None:
            for k in self.outputs:
                result['Outputs'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.outputs = []
        if m.get('Outputs') is not None:
            for k in m.get('Outputs'):
                temp_model = MediaConvertOutputDetail()
                self.outputs.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class MediaConvertJob(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        code: str = None,
        config: MediaConvertJobConfig = None,
        create_time: str = None,
        finish_time: str = None,
        job_id: str = None,
        message: str = None,
        output_details: List[MediaConvertOutputDetail] = None,
        output_group_details: List[MediaConvertOutputGroupDetail] = None,
        percent: int = None,
        pipeline_id: str = None,
        request_id: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.client_token = client_token
        self.code = code
        self.config = config
        self.create_time = create_time
        self.finish_time = finish_time
        self.job_id = job_id
        self.message = message
        self.output_details = output_details
        self.output_group_details = output_group_details
        self.percent = percent
        self.pipeline_id = pipeline_id
        self.request_id = request_id
        self.state = state
        self.user_data = user_data

    def validate(self):
        if self.config:
            self.config.validate()
        if self.output_details:
            for k in self.output_details:
                if k:
                    k.validate()
        if self.output_group_details:
            for k in self.output_group_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.code is not None:
            result['Code'] = self.code
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        result['OutputDetails'] = []
        if self.output_details is not None:
            for k in self.output_details:
                result['OutputDetails'].append(k.to_map() if k else None)
        result['OutputGroupDetails'] = []
        if self.output_group_details is not None:
            for k in self.output_group_details:
                result['OutputGroupDetails'].append(k.to_map() if k else None)
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Config') is not None:
            temp_model = MediaConvertJobConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.output_details = []
        if m.get('OutputDetails') is not None:
            for k in m.get('OutputDetails'):
                temp_model = MediaConvertOutputDetail()
                self.output_details.append(temp_model.from_map(k))
        self.output_group_details = []
        if m.get('OutputGroupDetails') is not None:
            for k in m.get('OutputGroupDetails'):
                temp_model = MediaConvertOutputGroupDetail()
                self.output_group_details.append(temp_model.from_map(k))
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class MediaConvertJobWithoutDetailConfig(TeaModel):
    def __init__(
        self,
        inputs: List[MediaConvertInput] = None,
        job_name: str = None,
        output_groups: List[MediaConvertOutputGroup] = None,
        outputs: List[MediaConvertOutput] = None,
    ):
        self.inputs = inputs
        self.job_name = job_name
        self.output_groups = output_groups
        self.outputs = outputs

    def validate(self):
        if self.inputs:
            for k in self.inputs:
                if k:
                    k.validate()
        if self.output_groups:
            for k in self.output_groups:
                if k:
                    k.validate()
        if self.outputs:
            for k in self.outputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Inputs'] = []
        if self.inputs is not None:
            for k in self.inputs:
                result['Inputs'].append(k.to_map() if k else None)
        if self.job_name is not None:
            result['JobName'] = self.job_name
        result['OutputGroups'] = []
        if self.output_groups is not None:
            for k in self.output_groups:
                result['OutputGroups'].append(k.to_map() if k else None)
        result['Outputs'] = []
        if self.outputs is not None:
            for k in self.outputs:
                result['Outputs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inputs = []
        if m.get('Inputs') is not None:
            for k in m.get('Inputs'):
                temp_model = MediaConvertInput()
                self.inputs.append(temp_model.from_map(k))
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        self.output_groups = []
        if m.get('OutputGroups') is not None:
            for k in m.get('OutputGroups'):
                temp_model = MediaConvertOutputGroup()
                self.output_groups.append(temp_model.from_map(k))
        self.outputs = []
        if m.get('Outputs') is not None:
            for k in m.get('Outputs'):
                temp_model = MediaConvertOutput()
                self.outputs.append(temp_model.from_map(k))
        return self


class MediaConvertJobWithoutDetail(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        code: str = None,
        config: MediaConvertJobWithoutDetailConfig = None,
        create_time: str = None,
        finish_time: str = None,
        job_id: str = None,
        message: str = None,
        pipeline_id: str = None,
        request_id: str = None,
        state: str = None,
        user_data: str = None,
    ):
        self.client_token = client_token
        self.code = code
        self.config = config
        self.create_time = create_time
        self.finish_time = finish_time
        self.job_id = job_id
        self.message = message
        self.pipeline_id = pipeline_id
        self.request_id = request_id
        self.state = state
        self.user_data = user_data

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.code is not None:
            result['Code'] = self.code
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Config') is not None:
            temp_model = MediaConvertJobWithoutDetailConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class MediaConvertSegment(TeaModel):
    def __init__(
        self,
        duration: int = None,
        force_seg_time: str = None,
    ):
        self.duration = duration
        self.force_seg_time = force_seg_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class MediaConvertMuxConfig(TeaModel):
    def __init__(
        self,
        segment: MediaConvertSegment = None,
    ):
        self.segment = segment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = MediaConvertSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class MediaConvertTransConfig(TeaModel):
    def __init__(
        self,
        adj_dar_method: str = None,
        is_check_audio_bitrate: bool = None,
        is_check_audio_bitrate_fail: bool = None,
        is_check_reso: bool = None,
        is_check_reso_fail: bool = None,
        is_check_video_bitrate: bool = None,
        is_check_video_bitrate_fail: bool = None,
        trans_mode: str = None,
    ):
        self.adj_dar_method = adj_dar_method
        self.is_check_audio_bitrate = is_check_audio_bitrate
        self.is_check_audio_bitrate_fail = is_check_audio_bitrate_fail
        self.is_check_reso = is_check_reso
        self.is_check_reso_fail = is_check_reso_fail
        self.is_check_video_bitrate = is_check_video_bitrate
        self.is_check_video_bitrate_fail = is_check_video_bitrate_fail
        self.trans_mode = trans_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adj_dar_method is not None:
            result['AdjDarMethod'] = self.adj_dar_method
        if self.is_check_audio_bitrate is not None:
            result['IsCheckAudioBitrate'] = self.is_check_audio_bitrate
        if self.is_check_audio_bitrate_fail is not None:
            result['IsCheckAudioBitrateFail'] = self.is_check_audio_bitrate_fail
        if self.is_check_reso is not None:
            result['IsCheckReso'] = self.is_check_reso
        if self.is_check_reso_fail is not None:
            result['IsCheckResoFail'] = self.is_check_reso_fail
        if self.is_check_video_bitrate is not None:
            result['IsCheckVideoBitrate'] = self.is_check_video_bitrate
        if self.is_check_video_bitrate_fail is not None:
            result['IsCheckVideoBitrateFail'] = self.is_check_video_bitrate_fail
        if self.trans_mode is not None:
            result['TransMode'] = self.trans_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjDarMethod') is not None:
            self.adj_dar_method = m.get('AdjDarMethod')
        if m.get('IsCheckAudioBitrate') is not None:
            self.is_check_audio_bitrate = m.get('IsCheckAudioBitrate')
        if m.get('IsCheckAudioBitrateFail') is not None:
            self.is_check_audio_bitrate_fail = m.get('IsCheckAudioBitrateFail')
        if m.get('IsCheckReso') is not None:
            self.is_check_reso = m.get('IsCheckReso')
        if m.get('IsCheckResoFail') is not None:
            self.is_check_reso_fail = m.get('IsCheckResoFail')
        if m.get('IsCheckVideoBitrate') is not None:
            self.is_check_video_bitrate = m.get('IsCheckVideoBitrate')
        if m.get('IsCheckVideoBitrateFail') is not None:
            self.is_check_video_bitrate_fail = m.get('IsCheckVideoBitrateFail')
        if m.get('TransMode') is not None:
            self.trans_mode = m.get('TransMode')
        return self


class MediaConvertVideo(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        bufsize: int = None,
        codec: str = None,
        crf: Any = None,
        crop: str = None,
        fps: Any = None,
        gop: Any = None,
        height: int = None,
        long_short_mode: bool = None,
        max_fps: Any = None,
        maxrate: int = None,
        pad: str = None,
        profile: str = None,
        qscale: int = None,
        remove: bool = None,
        scan_mode: str = None,
        width: int = None,
    ):
        self.bitrate = bitrate
        self.bufsize = bufsize
        self.codec = codec
        self.crf = crf
        self.crop = crop
        self.fps = fps
        self.gop = gop
        self.height = height
        self.long_short_mode = long_short_mode
        self.max_fps = max_fps
        self.maxrate = maxrate
        self.pad = pad
        self.profile = profile
        self.qscale = qscale
        self.remove = remove
        self.scan_mode = scan_mode
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.max_fps is not None:
            result['MaxFps'] = self.max_fps
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.qscale is not None:
            result['Qscale'] = self.qscale
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('MaxFps') is not None:
            self.max_fps = m.get('MaxFps')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Qscale') is not None:
            self.qscale = m.get('Qscale')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class MediaConvertVolume(TeaModel):
    def __init__(
        self,
        integrated_loudness_target: int = None,
        level: int = None,
        loudness_range_target: int = None,
        method: str = None,
        true_peak: int = None,
    ):
        self.integrated_loudness_target = integrated_loudness_target
        self.level = level
        self.loudness_range_target = loudness_range_target
        self.method = method
        self.true_peak = true_peak

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.level is not None:
            result['Level'] = self.level
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class ProgramAdBreaks(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        message_type: str = None,
        offset_millis: int = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        splice_insert_settings: str = None,
        time_signal_settings: str = None,
    ):
        self.channel_name = channel_name
        self.message_type = message_type
        self.offset_millis = offset_millis
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.splice_insert_settings = splice_insert_settings
        self.time_signal_settings = time_signal_settings

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        if self.offset_millis is not None:
            result['OffsetMillis'] = self.offset_millis
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.splice_insert_settings is not None:
            result['SpliceInsertSettings'] = self.splice_insert_settings
        if self.time_signal_settings is not None:
            result['TimeSignalSettings'] = self.time_signal_settings
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        if m.get('OffsetMillis') is not None:
            self.offset_millis = m.get('OffsetMillis')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SpliceInsertSettings') is not None:
            self.splice_insert_settings = m.get('SpliceInsertSettings')
        if m.get('TimeSignalSettings') is not None:
            self.time_signal_settings = m.get('TimeSignalSettings')
        return self


class Program(TeaModel):
    def __init__(
        self,
        ad_breaks: List[ProgramAdBreaks] = None,
        arn: str = None,
        channel_name: str = None,
        clip_range: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
        transition: str = None,
    ):
        self.ad_breaks = ad_breaks
        self.arn = arn
        self.channel_name = channel_name
        self.clip_range = clip_range
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type
        self.transition = transition

    def validate(self):
        if self.ad_breaks:
            for k in self.ad_breaks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdBreaks'] = []
        if self.ad_breaks is not None:
            for k in self.ad_breaks:
                result['AdBreaks'].append(k.to_map() if k else None)
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.clip_range is not None:
            result['ClipRange'] = self.clip_range
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.transition is not None:
            result['Transition'] = self.transition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_breaks = []
        if m.get('AdBreaks') is not None:
            for k in m.get('AdBreaks'):
                temp_model = ProgramAdBreaks()
                self.ad_breaks.append(temp_model.from_map(k))
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClipRange') is not None:
            self.clip_range = m.get('ClipRange')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        return self


class ScheduleDataAdBreaks(TeaModel):
    def __init__(
        self,
        message_type: str = None,
        offset_millis: str = None,
        source_location_name: str = None,
        source_name: str = None,
        splice_insert_settings: str = None,
        time_signal_settings: str = None,
    ):
        self.message_type = message_type
        self.offset_millis = offset_millis
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.splice_insert_settings = splice_insert_settings
        self.time_signal_settings = time_signal_settings

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        if self.offset_millis is not None:
            result['OffsetMillis'] = self.offset_millis
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.splice_insert_settings is not None:
            result['SpliceInsertSettings'] = self.splice_insert_settings
        if self.time_signal_settings is not None:
            result['TimeSignalSettings'] = self.time_signal_settings
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        if m.get('OffsetMillis') is not None:
            self.offset_millis = m.get('OffsetMillis')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SpliceInsertSettings') is not None:
            self.splice_insert_settings = m.get('SpliceInsertSettings')
        if m.get('TimeSignalSettings') is not None:
            self.time_signal_settings = m.get('TimeSignalSettings')
        return self


class ScheduleData(TeaModel):
    def __init__(
        self,
        ad_breaks: List[ScheduleDataAdBreaks] = None,
        approximate_duration_seconds: int = None,
        approximate_start_time: str = None,
        entry_type: str = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
    ):
        self.ad_breaks = ad_breaks
        self.approximate_duration_seconds = approximate_duration_seconds
        self.approximate_start_time = approximate_start_time
        self.entry_type = entry_type
        self.program_name = program_name
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type

    def validate(self):
        if self.ad_breaks:
            for k in self.ad_breaks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AdBreaks'] = []
        if self.ad_breaks is not None:
            for k in self.ad_breaks:
                result['AdBreaks'].append(k.to_map() if k else None)
        if self.approximate_duration_seconds is not None:
            result['ApproximateDurationSeconds'] = self.approximate_duration_seconds
        if self.approximate_start_time is not None:
            result['ApproximateStartTime'] = self.approximate_start_time
        if self.entry_type is not None:
            result['EntryType'] = self.entry_type
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ad_breaks = []
        if m.get('AdBreaks') is not None:
            for k in m.get('AdBreaks'):
                temp_model = ScheduleDataAdBreaks()
                self.ad_breaks.append(temp_model.from_map(k))
        if m.get('ApproximateDurationSeconds') is not None:
            self.approximate_duration_seconds = m.get('ApproximateDurationSeconds')
        if m.get('ApproximateStartTime') is not None:
            self.approximate_start_time = m.get('ApproximateStartTime')
        if m.get('EntryType') is not None:
            self.entry_type = m.get('EntryType')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class Source(TeaModel):
    def __init__(
        self,
        arn: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        http_package_configurations: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
        state: int = None,
    ):
        self.arn = arn
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.http_package_configurations = http_package_configurations
        self.source_location_name = source_location_name
        self.source_name = source_name
        self.source_type = source_type
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.http_package_configurations is not None:
            result['HttpPackageConfigurations'] = self.http_package_configurations
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HttpPackageConfigurations') is not None:
            self.http_package_configurations = m.get('HttpPackageConfigurations')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class SourceLocation(TeaModel):
    def __init__(
        self,
        arn: str = None,
        base_url: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        segment_delivery_configurations: str = None,
        source_location_name: str = None,
        state: int = None,
    ):
        self.arn = arn
        self.base_url = base_url
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.segment_delivery_configurations = segment_delivery_configurations
        self.source_location_name = source_location_name
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.base_url is not None:
            result['BaseUrl'] = self.base_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.segment_delivery_configurations is not None:
            result['SegmentDeliveryConfigurations'] = self.segment_delivery_configurations
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('BaseUrl') is not None:
            self.base_url = m.get('BaseUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('SegmentDeliveryConfigurations') is not None:
            self.segment_delivery_configurations = m.get('SegmentDeliveryConfigurations')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class VodPackagingAssetInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class VodPackagingAsset(TeaModel):
    def __init__(
        self,
        asset_name: str = None,
        content_id: str = None,
        create_time: str = None,
        group_name: str = None,
        input: VodPackagingAssetInput = None,
    ):
        self.asset_name = asset_name
        self.content_id = content_id
        self.create_time = create_time
        self.group_name = group_name
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_name is not None:
            result['AssetName'] = self.asset_name
        if self.content_id is not None:
            result['ContentId'] = self.content_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetName') is not None:
            self.asset_name = m.get('AssetName')
        if m.get('ContentId') is not None:
            self.content_id = m.get('ContentId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Input') is not None:
            temp_model = VodPackagingAssetInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class VodPackagingConfigDrmProvider(TeaModel):
    def __init__(
        self,
        encryption_method: str = None,
        iv: str = None,
        system_ids: List[str] = None,
        url: str = None,
    ):
        self.encryption_method = encryption_method
        self.iv = iv
        self.system_ids = system_ids
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.encryption_method is not None:
            result['EncryptionMethod'] = self.encryption_method
        if self.iv is not None:
            result['IV'] = self.iv
        if self.system_ids is not None:
            result['SystemIds'] = self.system_ids
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EncryptionMethod') is not None:
            self.encryption_method = m.get('EncryptionMethod')
        if m.get('IV') is not None:
            self.iv = m.get('IV')
        if m.get('SystemIds') is not None:
            self.system_ids = m.get('SystemIds')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class VodPackagingConfigStreamSelection(TeaModel):
    def __init__(
        self,
        max_video_bits_per_second: int = None,
        min_video_bits_per_second: int = None,
        stream_order: str = None,
    ):
        self.max_video_bits_per_second = max_video_bits_per_second
        self.min_video_bits_per_second = min_video_bits_per_second
        self.stream_order = stream_order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_video_bits_per_second is not None:
            result['MaxVideoBitsPerSecond'] = self.max_video_bits_per_second
        if self.min_video_bits_per_second is not None:
            result['MinVideoBitsPerSecond'] = self.min_video_bits_per_second
        if self.stream_order is not None:
            result['StreamOrder'] = self.stream_order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxVideoBitsPerSecond') is not None:
            self.max_video_bits_per_second = m.get('MaxVideoBitsPerSecond')
        if m.get('MinVideoBitsPerSecond') is not None:
            self.min_video_bits_per_second = m.get('MinVideoBitsPerSecond')
        if m.get('StreamOrder') is not None:
            self.stream_order = m.get('StreamOrder')
        return self


class VodPackagingConfig(TeaModel):
    def __init__(
        self,
        drm_provider: VodPackagingConfigDrmProvider = None,
        manifest_name: str = None,
        segment_duration: int = None,
        stream_selection: VodPackagingConfigStreamSelection = None,
    ):
        self.drm_provider = drm_provider
        self.manifest_name = manifest_name
        self.segment_duration = segment_duration
        self.stream_selection = stream_selection

    def validate(self):
        if self.drm_provider:
            self.drm_provider.validate()
        if self.stream_selection:
            self.stream_selection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drm_provider is not None:
            result['DrmProvider'] = self.drm_provider.to_map()
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        if self.stream_selection is not None:
            result['StreamSelection'] = self.stream_selection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DrmProvider') is not None:
            temp_model = VodPackagingConfigDrmProvider()
            self.drm_provider = temp_model.from_map(m['DrmProvider'])
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        if m.get('StreamSelection') is not None:
            temp_model = VodPackagingConfigStreamSelection()
            self.stream_selection = temp_model.from_map(m['StreamSelection'])
        return self


class VodPackagingConfiguration(TeaModel):
    def __init__(
        self,
        configuration_name: str = None,
        create_time: str = None,
        description: str = None,
        group_name: str = None,
        package_config: VodPackagingConfig = None,
        protocol: str = None,
    ):
        self.configuration_name = configuration_name
        self.create_time = create_time
        self.description = description
        self.group_name = group_name
        self.package_config = package_config
        self.protocol = protocol

    def validate(self):
        if self.package_config:
            self.package_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_name is not None:
            result['ConfigurationName'] = self.configuration_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.package_config is not None:
            result['PackageConfig'] = self.package_config.to_map()
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationName') is not None:
            self.configuration_name = m.get('ConfigurationName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('PackageConfig') is not None:
            temp_model = VodPackagingConfig()
            self.package_config = temp_model.from_map(m['PackageConfig'])
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class VodPackagingGroup(TeaModel):
    def __init__(
        self,
        approximate_asset_count: int = None,
        configuration_count: int = None,
        create_time: str = None,
        description: str = None,
        domain_name: str = None,
        group_name: str = None,
    ):
        self.approximate_asset_count = approximate_asset_count
        self.configuration_count = configuration_count
        self.create_time = create_time
        self.description = description
        self.domain_name = domain_name
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approximate_asset_count is not None:
            result['ApproximateAssetCount'] = self.approximate_asset_count
        if self.configuration_count is not None:
            result['ConfigurationCount'] = self.configuration_count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproximateAssetCount') is not None:
            self.approximate_asset_count = m.get('ApproximateAssetCount')
        if m.get('ConfigurationCount') is not None:
            self.configuration_count = m.get('ConfigurationCount')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class AddAdInsertionRequest(TeaModel):
    def __init__(
        self,
        ad_marker_passthrough: str = None,
        ads_url: str = None,
        cdn_ad_segment_url_prefix: str = None,
        cdn_content_segment_url_prefix: str = None,
        client_token: str = None,
        config_aliases: str = None,
        content_url_prefix: str = None,
        name: str = None,
        personalization_threshold: int = None,
        slate_ad_url: str = None,
    ):
        # Specifies whether to enable ad marker passthrough. Default value: OFF.
        # 
        # Valid values:
        # 
        # *   OFF: Disable.
        # *   ON: Enable.
        self.ad_marker_passthrough = ad_marker_passthrough
        # The request URL of the ad decision server (ADS). HTTP and HTTPS are supported. The maximum length is 2,048 characters.
        # 
        # This parameter is required.
        self.ads_url = ads_url
        # The CDN prefix for ad segments. HTTP and HTTPS are supported. The maximum length is 512 characters.
        self.cdn_ad_segment_url_prefix = cdn_ad_segment_url_prefix
        # The CDN prefix for content segments. HTTP and HTTPS are supported. The maximum length is 512 characters.
        self.cdn_content_segment_url_prefix = cdn_content_segment_url_prefix
        # The idempotency key that is used to avoid repeated submission. The value can be up to 200 characters in length.
        self.client_token = client_token
        # A JSON string that specifies the player parameter variables and aliases. You can add up to 20 player_params.{name} entries. The name field can be up to 150 characters in length. Each player parameter can include up to 50 key-value pairs. A key can be up to 150 characters long, and a value can be up to 500 characters. Example: { "player_params.{name}": { "{key}": "{value}" } }
        self.config_aliases = config_aliases
        # The URL prefix for the source content. HTTP and HTTPS are supported. The maximum length is 512 characters.
        # 
        # This parameter is required.
        self.content_url_prefix = content_url_prefix
        # The name of the configuration. The name must be unique and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        # 
        # This parameter is required.
        self.name = name
        # Specifies the maximum duration of underfilled time allowed in an ad break. Unit: seconds. Default value: 8 seconds.
        self.personalization_threshold = personalization_threshold
        # The HTTP or HTTPS URL of the slate ad. Only MP4 format is supported. The maximum length is 2,048 characters.
        self.slate_ad_url = slate_ad_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_marker_passthrough is not None:
            result['AdMarkerPassthrough'] = self.ad_marker_passthrough
        if self.ads_url is not None:
            result['AdsUrl'] = self.ads_url
        if self.cdn_ad_segment_url_prefix is not None:
            result['CdnAdSegmentUrlPrefix'] = self.cdn_ad_segment_url_prefix
        if self.cdn_content_segment_url_prefix is not None:
            result['CdnContentSegmentUrlPrefix'] = self.cdn_content_segment_url_prefix
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_aliases is not None:
            result['ConfigAliases'] = self.config_aliases
        if self.content_url_prefix is not None:
            result['ContentUrlPrefix'] = self.content_url_prefix
        if self.name is not None:
            result['Name'] = self.name
        if self.personalization_threshold is not None:
            result['PersonalizationThreshold'] = self.personalization_threshold
        if self.slate_ad_url is not None:
            result['SlateAdUrl'] = self.slate_ad_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdMarkerPassthrough') is not None:
            self.ad_marker_passthrough = m.get('AdMarkerPassthrough')
        if m.get('AdsUrl') is not None:
            self.ads_url = m.get('AdsUrl')
        if m.get('CdnAdSegmentUrlPrefix') is not None:
            self.cdn_ad_segment_url_prefix = m.get('CdnAdSegmentUrlPrefix')
        if m.get('CdnContentSegmentUrlPrefix') is not None:
            self.cdn_content_segment_url_prefix = m.get('CdnContentSegmentUrlPrefix')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigAliases') is not None:
            self.config_aliases = m.get('ConfigAliases')
        if m.get('ContentUrlPrefix') is not None:
            self.content_url_prefix = m.get('ContentUrlPrefix')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonalizationThreshold') is not None:
            self.personalization_threshold = m.get('PersonalizationThreshold')
        if m.get('SlateAdUrl') is not None:
            self.slate_ad_url = m.get('SlateAdUrl')
        return self


class AddAdInsertionResponseBodyConfigCdnConfig(TeaModel):
    def __init__(
        self,
        ad_segment_url_prefix: str = None,
        content_segment_url_prefix: str = None,
    ):
        # The CDN prefix for ad segments.
        self.ad_segment_url_prefix = ad_segment_url_prefix
        # The CDN prefix for content segments.
        self.content_segment_url_prefix = content_segment_url_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_segment_url_prefix is not None:
            result['AdSegmentUrlPrefix'] = self.ad_segment_url_prefix
        if self.content_segment_url_prefix is not None:
            result['ContentSegmentUrlPrefix'] = self.content_segment_url_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdSegmentUrlPrefix') is not None:
            self.ad_segment_url_prefix = m.get('AdSegmentUrlPrefix')
        if m.get('ContentSegmentUrlPrefix') is not None:
            self.content_segment_url_prefix = m.get('ContentSegmentUrlPrefix')
        return self


class AddAdInsertionResponseBodyConfigManifestEndpointConfig(TeaModel):
    def __init__(
        self,
        dash_prefix: str = None,
        hls_prefix: str = None,
    ):
        # DASH清单播放端点前缀
        self.dash_prefix = dash_prefix
        # The prefix of the playback endpoint for HLS manifests.
        self.hls_prefix = hls_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dash_prefix is not None:
            result['DashPrefix'] = self.dash_prefix
        if self.hls_prefix is not None:
            result['HlsPrefix'] = self.hls_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DashPrefix') is not None:
            self.dash_prefix = m.get('DashPrefix')
        if m.get('HlsPrefix') is not None:
            self.hls_prefix = m.get('HlsPrefix')
        return self


class AddAdInsertionResponseBodyConfig(TeaModel):
    def __init__(
        self,
        ad_marker_passthrough: str = None,
        ads_url: str = None,
        cdn_config: AddAdInsertionResponseBodyConfigCdnConfig = None,
        config_aliases: str = None,
        content_url_prefix: str = None,
        create_time: str = None,
        last_modified: str = None,
        manifest_endpoint_config: AddAdInsertionResponseBodyConfigManifestEndpointConfig = None,
        name: str = None,
        personalization_threshold: int = None,
        slate_ad_url: str = None,
    ):
        # Indicates whether ad marker passthrough is enabled.
        self.ad_marker_passthrough = ad_marker_passthrough
        # The request URL of ADS.
        self.ads_url = ads_url
        # The CDN configurations.
        self.cdn_config = cdn_config
        # The player parameter variables and aliases.
        self.config_aliases = config_aliases
        # The URL prefix for the source content.
        self.content_url_prefix = content_url_prefix
        # The time when the configuration was created.
        self.create_time = create_time
        # The time when the configuration was last modified.
        self.last_modified = last_modified
        # The playback endpoint configuration.
        self.manifest_endpoint_config = manifest_endpoint_config
        # The name of the ad insertion configuration.
        self.name = name
        # The personalization threshold.
        self.personalization_threshold = personalization_threshold
        # The URL of the slate ad.
        self.slate_ad_url = slate_ad_url

    def validate(self):
        if self.cdn_config:
            self.cdn_config.validate()
        if self.manifest_endpoint_config:
            self.manifest_endpoint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_marker_passthrough is not None:
            result['AdMarkerPassthrough'] = self.ad_marker_passthrough
        if self.ads_url is not None:
            result['AdsUrl'] = self.ads_url
        if self.cdn_config is not None:
            result['CdnConfig'] = self.cdn_config.to_map()
        if self.config_aliases is not None:
            result['ConfigAliases'] = self.config_aliases
        if self.content_url_prefix is not None:
            result['ContentUrlPrefix'] = self.content_url_prefix
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.manifest_endpoint_config is not None:
            result['ManifestEndpointConfig'] = self.manifest_endpoint_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.personalization_threshold is not None:
            result['PersonalizationThreshold'] = self.personalization_threshold
        if self.slate_ad_url is not None:
            result['SlateAdUrl'] = self.slate_ad_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdMarkerPassthrough') is not None:
            self.ad_marker_passthrough = m.get('AdMarkerPassthrough')
        if m.get('AdsUrl') is not None:
            self.ads_url = m.get('AdsUrl')
        if m.get('CdnConfig') is not None:
            temp_model = AddAdInsertionResponseBodyConfigCdnConfig()
            self.cdn_config = temp_model.from_map(m['CdnConfig'])
        if m.get('ConfigAliases') is not None:
            self.config_aliases = m.get('ConfigAliases')
        if m.get('ContentUrlPrefix') is not None:
            self.content_url_prefix = m.get('ContentUrlPrefix')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('ManifestEndpointConfig') is not None:
            temp_model = AddAdInsertionResponseBodyConfigManifestEndpointConfig()
            self.manifest_endpoint_config = temp_model.from_map(m['ManifestEndpointConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonalizationThreshold') is not None:
            self.personalization_threshold = m.get('PersonalizationThreshold')
        if m.get('SlateAdUrl') is not None:
            self.slate_ad_url = m.get('SlateAdUrl')
        return self


class AddAdInsertionResponseBody(TeaModel):
    def __init__(
        self,
        config: AddAdInsertionResponseBodyConfig = None,
        request_id: str = None,
    ):
        # The ad insertion configuration.
        self.config = config
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = AddAdInsertionResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAdInsertionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAdInsertionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAdInsertionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_name: str = None,
        parent_id: int = None,
        type: str = None,
    ):
        # The category name.
        # 
        # *   The value can be up to 64 bytes in length.
        # *   The value must be encoded in UTF-8.
        # 
        # This parameter is required.
        self.cate_name = cate_name
        # The ID of the parent category.
        self.parent_id = parent_id
        # The type of the category. Valid values:
        # 
        # *   default: audio, video, and image files. This is the default value.
        # *   material: short video materials.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBodyCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        type: str = None,
    ):
        # The ID of the created category.
        self.cate_id = cate_id
        # The category name.
        self.cate_name = cate_name
        # The level of the category. A value of **0** indicates a level-1 category, a value of **1** indicates a level-2 category, and a value of **2** indicates a level-3 category.
        self.level = level
        # The ID of the parent category. By default, if ParentId is left empty or less than 1, -1 is returned, which indicates that the created category is the root directory.
        self.parent_id = parent_id
        # The type of the category. Valid values:
        # 
        # *   **default**: audio, video, and image files. This is the default value.
        # *   **material**: short video materials.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBody(TeaModel):
    def __init__(
        self,
        category: AddCategoryResponseBodyCategory = None,
        request_id: str = None,
    ):
        # The information about the category.
        self.category = category
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.category:
            self.category.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = AddCategoryResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        material_maps: str = None,
        project_id: str = None,
    ):
        # The material ID. Separate multiple material IDs with commas (,). Each type supports up to 10 material IDs. The following material types are supported:
        # 
        # *   video
        # *   audio
        # *   image
        # *   liveStream
        # *   editingProject
        # 
        # This parameter is required.
        self.material_maps = material_maps
        # The ID of the online editing project.
        # 
        # This parameter is required.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class AddEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        live_url: str = None,
        stream_name: str = None,
    ):
        # The application name of the live stream.
        self.app_name = app_name
        # The domain name of the live stream.
        self.domain_name = domain_name
        # The URL of the live stream.
        self.live_url = live_url
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # The bitrate.
        self.bitrate = bitrate
        # The duration.
        self.duration = duration
        # The file name.
        self.file_name = file_name
        # The file size. Unit: bytes.
        self.file_size = file_size
        # The file status.
        # 
        # \\-Uploading
        # 
        # \\-Normal
        # 
        # \\-UploadFail
        # 
        # \\-Disable
        # 
        # \\-Deleted
        self.file_status = file_status
        # The file type.
        self.file_type = file_type
        # The Object Storage Service (OSS) URL of the file.
        self.file_url = file_url
        # The container format.
        self.format_name = format_name
        # The height.
        self.height = height
        # The region in which the file resides.
        self.region = region
        # The width.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # The basic information of the file, including the duration and size.
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # The business type of the media asset.
        self.business_type = business_type
        # The category of the media asset.
        self.category = category
        # The thumbnail URL of the media asset.
        self.cover_url = cover_url
        # The time when the media asset was created.
        self.create_time = create_time
        # The time when the media asset was deleted.
        self.deleted_time = deleted_time
        # The description of the media asset.
        self.description = description
        # The URL of the media asset in another service.
        self.input_url = input_url
        # The ID of the media asset.
        self.media_id = media_id
        # The tags of the media asset.
        self.media_tags = media_tags
        # The type of the media asset.
        self.media_type = media_type
        # The time when the media asset was last modified.
        self.modified_time = modified_time
        # The snapshots of the media asset.
        self.snapshots = snapshots
        # The source of the media asset.
        self.source = source
        # The sprite of the media asset.
        self.sprite_images = sprite_images
        # The status of the media asset. Valid values:
        # 
        # \\- Init
        # 
        # \\- Preparing
        # 
        # \\- PrepareFail
        # 
        # \\- Normal
        self.status = status
        # The title of the media asset.
        self.title = title
        # The transcoding status of the media asset.
        self.transcode_status = transcode_status
        # The user data.
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # The basic information of the media assets.
        self.media_basic_info = media_basic_info
        # The ID of the media asset.
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class AddEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        live_materials: List[AddEditingProjectMaterialsResponseBodyLiveMaterials] = None,
        media_infos: List[AddEditingProjectMaterialsResponseBodyMediaInfos] = None,
        project_id: str = None,
        project_materials: List[str] = None,
        request_id: str = None,
    ):
        # The materials associated with the live stream.
        self.live_materials = live_materials
        # The media assets that meet the specified conditions.
        self.media_infos = media_infos
        # The ID of the online editing project.
        self.project_id = project_id
        # The materials associated with the editing project. A live stream editing project will be associated with a regular editing project after the live streaming ends.
        self.project_materials = project_materials
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = AddEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddFavoritePublicMediaRequest(TeaModel):
    def __init__(
        self,
        media_ids: str = None,
    ):
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class AddFavoritePublicMediaResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        self.ignored_list = ignored_list
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddFavoritePublicMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddFavoritePublicMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaConnectFlowInputRequest(TeaModel):
    def __init__(
        self,
        cidrs: str = None,
        flow_id: str = None,
        input_from_url: str = None,
        input_name: str = None,
        input_protocol: str = None,
        max_bitrate: int = None,
        pair_flow_id: str = None,
        pair_output_name: str = None,
        srt_latency: int = None,
        srt_passphrase: str = None,
        srt_pbkey_len: str = None,
    ):
        # The IP address whitelist in CIDR format. Separate multiple CIDR blocks with commas (,).
        self.cidrs = cidrs
        # The flow ID.
        # 
        # This parameter is required.
        self.flow_id = flow_id
        # The source URL. This parameter is required when the source type is RTMP-PULL or SRT-Listener.
        self.input_from_url = input_from_url
        # The source name.
        # 
        # This parameter is required.
        self.input_name = input_name
        # The source type.
        # 
        # Valid values:
        # 
        # *   RTMP-PUSH
        # *   SRT-Caller
        # *   RTMP-PULL
        # *   SRT-Listener
        # *   Flow
        # 
        # This parameter is required.
        self.input_protocol = input_protocol
        # The maximum bitrate. Unit: bit/s.
        self.max_bitrate = max_bitrate
        # The ID of the source flow. This parameter is required when the source type is Flow.
        self.pair_flow_id = pair_flow_id
        # The output of the source flow. This parameter is required when the source type is Flow.
        self.pair_output_name = pair_output_name
        # The latency for the SRT stream. This parameter is required the source type is SRT-Listener or SRT-Caller.
        self.srt_latency = srt_latency
        # The SRT key. This parameter is required when the source type is SRT-Listener or SRT-Caller.
        self.srt_passphrase = srt_passphrase
        # The encryption key length. This parameter is required when the source type is SRT-Listener or SRT-Caller.
        # 
        # Valid values:
        # 
        # *   0
        # *   16
        # *   24
        # *   32
        self.srt_pbkey_len = srt_pbkey_len

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidrs is not None:
            result['Cidrs'] = self.cidrs
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.input_from_url is not None:
            result['InputFromUrl'] = self.input_from_url
        if self.input_name is not None:
            result['InputName'] = self.input_name
        if self.input_protocol is not None:
            result['InputProtocol'] = self.input_protocol
        if self.max_bitrate is not None:
            result['MaxBitrate'] = self.max_bitrate
        if self.pair_flow_id is not None:
            result['PairFlowId'] = self.pair_flow_id
        if self.pair_output_name is not None:
            result['PairOutputName'] = self.pair_output_name
        if self.srt_latency is not None:
            result['SrtLatency'] = self.srt_latency
        if self.srt_passphrase is not None:
            result['SrtPassphrase'] = self.srt_passphrase
        if self.srt_pbkey_len is not None:
            result['SrtPbkeyLen'] = self.srt_pbkey_len
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cidrs') is not None:
            self.cidrs = m.get('Cidrs')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('InputFromUrl') is not None:
            self.input_from_url = m.get('InputFromUrl')
        if m.get('InputName') is not None:
            self.input_name = m.get('InputName')
        if m.get('InputProtocol') is not None:
            self.input_protocol = m.get('InputProtocol')
        if m.get('MaxBitrate') is not None:
            self.max_bitrate = m.get('MaxBitrate')
        if m.get('PairFlowId') is not None:
            self.pair_flow_id = m.get('PairFlowId')
        if m.get('PairOutputName') is not None:
            self.pair_output_name = m.get('PairOutputName')
        if m.get('SrtLatency') is not None:
            self.srt_latency = m.get('SrtLatency')
        if m.get('SrtPassphrase') is not None:
            self.srt_passphrase = m.get('SrtPassphrase')
        if m.get('SrtPbkeyLen') is not None:
            self.srt_pbkey_len = m.get('SrtPbkeyLen')
        return self


class AddMediaConnectFlowInputResponseBodyContent(TeaModel):
    def __init__(
        self,
        input_url: str = None,
    ):
        # The source URL.
        self.input_url = input_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        return self


class AddMediaConnectFlowInputResponseBody(TeaModel):
    def __init__(
        self,
        content: AddMediaConnectFlowInputResponseBodyContent = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The call description.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of 0 indicates the call is successful.
        self.ret_code = ret_code

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = AddMediaConnectFlowInputResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class AddMediaConnectFlowInputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMediaConnectFlowInputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaConnectFlowInputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaConnectFlowOutputRequest(TeaModel):
    def __init__(
        self,
        cidrs: str = None,
        flow_id: str = None,
        output_name: str = None,
        output_protocol: str = None,
        output_to_url: str = None,
        pair_flow_id: str = None,
        pair_input_name: str = None,
        player_limit: int = None,
        srt_latency: int = None,
        srt_passphrase: str = None,
        srt_pbkey_len: str = None,
    ):
        # The IP address whitelist in CIDR format. Separate multiple CIDR blocks with commas (,).
        self.cidrs = cidrs
        # The flow ID.
        # 
        # This parameter is required.
        self.flow_id = flow_id
        # The output name.
        # 
        # This parameter is required.
        self.output_name = output_name
        # The output type.
        # 
        # Valid values:
        # 
        # *   RTMP-PUSH
        # *   SRT-Caller
        # *   RTMP-PULL
        # *   SRT-Listener
        # *   Flow
        # 
        # This parameter is required.
        self.output_protocol = output_protocol
        # The output URL. This parameter is required when OutputProtocol is set to RTMP-PUSH or SRT-Caller.
        self.output_to_url = output_to_url
        # The ID of the destination flow. This parameter is required when OutputProtocol is set to Flow.
        self.pair_flow_id = pair_flow_id
        # The source name of the destination flow. This parameter is required when OutputProtocol is set to Flow.
        self.pair_input_name = pair_input_name
        # The maximum number of viewers.
        self.player_limit = player_limit
        # The latency for the SRT stream. This parameter is required when the source type is SRT-Listener or SRT-Caller.
        self.srt_latency = srt_latency
        # The SRT key. This parameter is required when the source type is SRT-Listener or SRT-Caller.
        self.srt_passphrase = srt_passphrase
        # The encryption key length. This parameter is required when the source type is SRT-Listener or SRT-Caller.
        self.srt_pbkey_len = srt_pbkey_len

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidrs is not None:
            result['Cidrs'] = self.cidrs
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.output_name is not None:
            result['OutputName'] = self.output_name
        if self.output_protocol is not None:
            result['OutputProtocol'] = self.output_protocol
        if self.output_to_url is not None:
            result['OutputToUrl'] = self.output_to_url
        if self.pair_flow_id is not None:
            result['PairFlowId'] = self.pair_flow_id
        if self.pair_input_name is not None:
            result['PairInputName'] = self.pair_input_name
        if self.player_limit is not None:
            result['PlayerLimit'] = self.player_limit
        if self.srt_latency is not None:
            result['SrtLatency'] = self.srt_latency
        if self.srt_passphrase is not None:
            result['SrtPassphrase'] = self.srt_passphrase
        if self.srt_pbkey_len is not None:
            result['SrtPbkeyLen'] = self.srt_pbkey_len
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cidrs') is not None:
            self.cidrs = m.get('Cidrs')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('OutputName') is not None:
            self.output_name = m.get('OutputName')
        if m.get('OutputProtocol') is not None:
            self.output_protocol = m.get('OutputProtocol')
        if m.get('OutputToUrl') is not None:
            self.output_to_url = m.get('OutputToUrl')
        if m.get('PairFlowId') is not None:
            self.pair_flow_id = m.get('PairFlowId')
        if m.get('PairInputName') is not None:
            self.pair_input_name = m.get('PairInputName')
        if m.get('PlayerLimit') is not None:
            self.player_limit = m.get('PlayerLimit')
        if m.get('SrtLatency') is not None:
            self.srt_latency = m.get('SrtLatency')
        if m.get('SrtPassphrase') is not None:
            self.srt_passphrase = m.get('SrtPassphrase')
        if m.get('SrtPbkeyLen') is not None:
            self.srt_pbkey_len = m.get('SrtPbkeyLen')
        return self


class AddMediaConnectFlowOutputResponseBodyContent(TeaModel):
    def __init__(
        self,
        output_url: str = None,
    ):
        # The output URL.
        self.output_url = output_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        return self


class AddMediaConnectFlowOutputResponseBody(TeaModel):
    def __init__(
        self,
        content: AddMediaConnectFlowOutputResponseBodyContent = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The call description.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of 0 indicates that the call is successful.
        self.ret_code = ret_code

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = AddMediaConnectFlowOutputResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class AddMediaConnectFlowOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMediaConnectFlowOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaConnectFlowOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMediaMarksRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        media_marks: str = None,
    ):
        # The ID of the media asset.
        # 
        # This parameter is required.
        self.media_id = media_id
        # The mark information. The value must be a JSONArray.
        # 
        # This parameter is required.
        self.media_marks = media_marks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_marks is not None:
            result['MediaMarks'] = self.media_marks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaMarks') is not None:
            self.media_marks = m.get('MediaMarks')
        return self


class AddMediaMarksResponseBody(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        media_mark_ids: str = None,
        request_id: str = None,
    ):
        # The ID of the media asset.
        self.media_id = media_id
        # The IDs of the marks that are added.
        self.media_mark_ids = media_mark_ids
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_mark_ids is not None:
            result['MediaMarkIds'] = self.media_mark_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaMarkIds') is not None:
            self.media_mark_ids = m.get('MediaMarkIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMediaMarksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMediaMarksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMediaMarksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTemplateRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        cover_url: str = None,
        name: str = None,
        preview_media: str = None,
        related_mediaids: str = None,
        source: str = None,
        status: str = None,
        type: str = None,
    ):
        self.config = config
        # The URL of the template thumbnail.
        self.cover_url = cover_url
        # The name of the custom template.
        self.name = name
        # The ID of the template preview video.
        self.preview_media = preview_media
        # The IDs of the materials associated with the template for use by the regular template editor.
        self.related_mediaids = related_mediaids
        # The source from which the template is created. Valid values:
        # 
        # *   OpenAPI
        # *   AliyunConsole
        # *   WebSDK
        # 
        # <!---->
        self.source = source
        # The template state. Valid values:
        # 
        # *   Available: The template is available.
        # *   Created: The template is created but not ready for use.
        # *   Uploading: The video is being uploaded.
        # *   Processing: The advanced template is being processed.
        # *   UploadFailed: Failed to upload the video.
        # *   ProcessFailed: Failed to process the advanced template.
        # 
        # <!---->
        self.status = status
        # The template type. Valid values:
        # 
        # *   Timeline: a regular template created based on the timeline of a video editing project, in which multiple materials are arranged in sequence across multiple layers. It can be used to convert text and images into videos, create photo albums, add opening and closing parts, and apply the default watermark.
        # *   VETemplate: an advanced template created using effects of Adobe After Effects (AE). It can be used to produce complex animations and advanced media effects.
        # 
        # <!---->
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.related_mediaids is not None:
            result['RelatedMediaids'] = self.related_mediaids
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('RelatedMediaids') is not None:
            self.related_mediaids = m.get('RelatedMediaids')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        config: str = None,
        cover_url: str = None,
        create_source: str = None,
        modified_source: str = None,
        name: str = None,
        preview_media: str = None,
        status: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # The template configurations.
        self.config = config
        # The URL of the template thumbnail.
        self.cover_url = cover_url
        # The source from which the template was created.
        # 
        # Valid values:
        # 
        # *   AliyunConsole
        # *   WebSDK
        # *   OpenAPI
        self.create_source = create_source
        # The source from which the template was modified.
        # 
        # Valid values:
        # 
        # *   AliyunConsole
        # *   WebSDK
        # *   OpenAPI
        self.modified_source = modified_source
        # The template name.
        self.name = name
        # The ID of the preview video.
        self.preview_media = preview_media
        # The template state.
        # 
        # Valid values:
        # 
        # *   UploadFailed: Failed to upload the video.
        # *   ProcessFailed: Failed to process the advanced template.
        # *   Available: The template is available.
        # *   Uploading: The video is being uploaded.
        # *   Created: The template is created but not ready for use.
        # *   Processing: The advanced template is being processed.
        self.status = status
        # The template ID.
        self.template_id = template_id
        # The template type.
        # 
        # Valid values:
        # 
        # *   Timeline: regular template.
        # *   VETemplate: advanced template.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: AddTemplateResponseBodyTemplate = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The template information.
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AlterSearchIndexRequest(TeaModel):
    def __init__(
        self,
        index_config: str = None,
        index_status: str = None,
        index_type: str = None,
        search_lib_name: str = None,
    ):
        # The configurations of the index.
        # 
        # >  You must specify either IndexStatus or IndexConfig.
        self.index_config = index_config
        # The state of the index. Valid values:
        # 
        # *   active (default): the index is enabled.
        # *   Deactive: the index is not enabled.
        # 
        # >  You must specify either IndexStatus or IndexConfig.
        self.index_status = index_status
        # The category of the index. Valid values:
        # 
        # *   mm: large visual model.
        # *   face: face recognition.
        # *   aiLabel: smart tagging.
        # 
        # This parameter is required.
        self.index_type = index_type
        # The name of the search library.
        # 
        # *   If you leave this parameter empty, the search index is created in the default search library of Intelligent Media Service (IMS). Default value: ims-default-search-lib.
        # *   To query information about an existing search library, call the [QuerySearchLib](https://help.aliyun.com/document_detail/2584455.html) API operation.
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_config is not None:
            result['IndexConfig'] = self.index_config
        if self.index_status is not None:
            result['IndexStatus'] = self.index_status
        if self.index_type is not None:
            result['IndexType'] = self.index_type
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IndexConfig') is not None:
            self.index_config = m.get('IndexConfig')
        if m.get('IndexStatus') is not None:
            self.index_status = m.get('IndexStatus')
        if m.get('IndexType') is not None:
            self.index_type = m.get('IndexType')
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class AlterSearchIndexResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AlterSearchIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AlterSearchIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AlterSearchIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateVodPackagingAssetRequestAssetsInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # The URL of the media file. You can only specify a M3U8 file stored in Object Storage Service (OSS).
        self.media = media
        # The input type. Only OSS is supported.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BatchCreateVodPackagingAssetRequestAssets(TeaModel):
    def __init__(
        self,
        asset_name: str = None,
        content_id: str = None,
        input: BatchCreateVodPackagingAssetRequestAssetsInput = None,
    ):
        # The name of the asset. The name must be unique and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.asset_name = asset_name
        # The content ID in the digital rights management (DRM) system. The maximum length is 256 characters. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.content_id = content_id
        # The asset input configurations.
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_name is not None:
            result['AssetName'] = self.asset_name
        if self.content_id is not None:
            result['ContentId'] = self.content_id
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetName') is not None:
            self.asset_name = m.get('AssetName')
        if m.get('ContentId') is not None:
            self.content_id = m.get('ContentId')
        if m.get('Input') is not None:
            temp_model = BatchCreateVodPackagingAssetRequestAssetsInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class BatchCreateVodPackagingAssetRequest(TeaModel):
    def __init__(
        self,
        assets: List[BatchCreateVodPackagingAssetRequestAssets] = None,
        group_name: str = None,
    ):
        # The assets that you want to ingest.
        self.assets = assets
        # The name of the packaging group.
        self.group_name = group_name

    def validate(self):
        if self.assets:
            for k in self.assets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Assets'] = []
        if self.assets is not None:
            for k in self.assets:
                result['Assets'].append(k.to_map() if k else None)
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.assets = []
        if m.get('Assets') is not None:
            for k in m.get('Assets'):
                temp_model = BatchCreateVodPackagingAssetRequestAssets()
                self.assets.append(temp_model.from_map(k))
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class BatchCreateVodPackagingAssetShrinkRequest(TeaModel):
    def __init__(
        self,
        assets_shrink: str = None,
        group_name: str = None,
    ):
        # The assets that you want to ingest.
        self.assets_shrink = assets_shrink
        # The name of the packaging group.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_shrink is not None:
            result['Assets'] = self.assets_shrink
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Assets') is not None:
            self.assets_shrink = m.get('Assets')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class BatchCreateVodPackagingAssetResponseBodyResultList(TeaModel):
    def __init__(
        self,
        asset: VodPackagingAsset = None,
        code: str = None,
        message: str = None,
    ):
        # The information about the ingested asset.
        self.asset = asset
        # The error code for failed ingestion.
        self.code = code
        # The error message for failed ingestion.
        self.message = message

    def validate(self):
        if self.asset:
            self.asset.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset is not None:
            result['Asset'] = self.asset.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asset') is not None:
            temp_model = VodPackagingAsset()
            self.asset = temp_model.from_map(m['Asset'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class BatchCreateVodPackagingAssetResponseBody(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        request_id: str = None,
        result_list: List[BatchCreateVodPackagingAssetResponseBodyResultList] = None,
    ):
        # The name of the packaging group.
        self.group_name = group_name
        # The ID of the request.
        self.request_id = request_id
        # The results of asset ingestion.
        self.result_list = result_list

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = BatchCreateVodPackagingAssetResponseBodyResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class BatchCreateVodPackagingAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateVodPackagingAssetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateVodPackagingAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetMediaInfosRequest(TeaModel):
    def __init__(
        self,
        addition_type: str = None,
        auth_timeout: int = None,
        media_ids: str = None,
    ):
        # The additional information that you want to query about the media assets. By default, only BasicInfo is returned. The following additional information can be queried:
        # 
        # \\- FileInfo
        # 
        # \\- DynamicMetaData
        self.addition_type = addition_type
        self.auth_timeout = auth_timeout
        # The IDs of the media assets that you want to query. Separate the IDs with commas (,).
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addition_type is not None:
            result['AdditionType'] = self.addition_type
        if self.auth_timeout is not None:
            result['AuthTimeout'] = self.auth_timeout
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdditionType') is not None:
            self.addition_type = m.get('AdditionType')
        if m.get('AuthTimeout') is not None:
            self.auth_timeout = m.get('AuthTimeout')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # The bitrate.
        self.bitrate = bitrate
        # The duration.
        self.duration = duration
        # The file name.
        self.file_name = file_name
        # The file size. Unit: bytes.
        self.file_size = file_size
        # The file status.
        self.file_status = file_status
        # The file type.
        self.file_type = file_type
        # The Object Storage Service (OSS) URL of the file.
        self.file_url = file_url
        # The container format.
        self.format_name = format_name
        # The height.
        self.height = height
        # The region in which the file resides.
        self.region = region
        # The width.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # The basic information of the file, including the duration and size.
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        biz: str = None,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        self.biz = biz
        # The business type of the media asset.
        self.business_type = business_type
        # The category of the media asset.
        self.category = category
        # The thumbnail URL of the media asset.
        self.cover_url = cover_url
        # The time when the media asset was created.
        self.create_time = create_time
        # The time when the media asset was deleted.
        self.deleted_time = deleted_time
        # The description of the media asset.
        self.description = description
        # The URL of the media asset in another service.
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # The tags of the media asset.
        self.media_tags = media_tags
        # The type of the media asset. Valid values:
        # 
        # \\- image
        # 
        # \\- video
        # 
        # \\- audio
        # 
        # \\- text
        self.media_type = media_type
        # The time when the media asset was last modified.
        self.modified_time = modified_time
        # The snapshots of the media asset.
        self.snapshots = snapshots
        # The source of the media asset. Valid values:
        # 
        # \\- oss
        # 
        # \\- vod
        self.source = source
        # The sprite.
        self.sprite_images = sprite_images
        # The status of the media asset.
        self.status = status
        # The title of the media asset.
        self.title = title
        # The transcoding status of the media asset.
        self.transcode_status = transcode_status
        # The user data.
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class BatchGetMediaInfosResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[BatchGetMediaInfosResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # The basic information of the media asset.
        self.media_basic_info = media_basic_info
        # The ID of the media asset.
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class BatchGetMediaInfosResponseBody(TeaModel):
    def __init__(
        self,
        media_infos: List[BatchGetMediaInfosResponseBodyMediaInfos] = None,
        request_id: str = None,
    ):
        # The queried media assets.
        self.media_infos = media_infos
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchGetMediaInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchGetMediaInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelDNAJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The ID of the media fingerprint analysis job that you want to cancel.
        # 
        # This parameter is required.
        self.job_id = job_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelDNAJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        request_id: str = None,
    ):
        # The job ID.
        self.job_id = job_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelDNAJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelDNAJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelDNAJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelFavoritePublicMediaRequest(TeaModel):
    def __init__(
        self,
        media_ids: str = None,
    ):
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class CancelFavoritePublicMediaResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        self.ignored_list = ignored_list
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelFavoritePublicMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelFavoritePublicMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelIProductionJobRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        job_id: str = None,
    ):
        self.client_token = client_token
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelIProductionJobResponseBodyAccessDeniedDetail(TeaModel):
    def __init__(
        self,
        auth_action: str = None,
        auth_principal_display_name: str = None,
        auth_principal_owner_id: str = None,
        auth_principal_type: str = None,
        encoded_diagnostic_message: str = None,
        no_permission_type: str = None,
        policy_type: str = None,
    ):
        self.auth_action = auth_action
        self.auth_principal_display_name = auth_principal_display_name
        self.auth_principal_owner_id = auth_principal_owner_id
        self.auth_principal_type = auth_principal_type
        self.encoded_diagnostic_message = encoded_diagnostic_message
        self.no_permission_type = no_permission_type
        self.policy_type = policy_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_action is not None:
            result['AuthAction'] = self.auth_action
        if self.auth_principal_display_name is not None:
            result['AuthPrincipalDisplayName'] = self.auth_principal_display_name
        if self.auth_principal_owner_id is not None:
            result['AuthPrincipalOwnerId'] = self.auth_principal_owner_id
        if self.auth_principal_type is not None:
            result['AuthPrincipalType'] = self.auth_principal_type
        if self.encoded_diagnostic_message is not None:
            result['EncodedDiagnosticMessage'] = self.encoded_diagnostic_message
        if self.no_permission_type is not None:
            result['NoPermissionType'] = self.no_permission_type
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthAction') is not None:
            self.auth_action = m.get('AuthAction')
        if m.get('AuthPrincipalDisplayName') is not None:
            self.auth_principal_display_name = m.get('AuthPrincipalDisplayName')
        if m.get('AuthPrincipalOwnerId') is not None:
            self.auth_principal_owner_id = m.get('AuthPrincipalOwnerId')
        if m.get('AuthPrincipalType') is not None:
            self.auth_principal_type = m.get('AuthPrincipalType')
        if m.get('EncodedDiagnosticMessage') is not None:
            self.encoded_diagnostic_message = m.get('EncodedDiagnosticMessage')
        if m.get('NoPermissionType') is not None:
            self.no_permission_type = m.get('NoPermissionType')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        return self


class CancelIProductionJobResponseBody(TeaModel):
    def __init__(
        self,
        access_denied_detail: CancelIProductionJobResponseBodyAccessDeniedDetail = None,
        message: str = None,
        request_id: str = None,
    ):
        self.access_denied_detail = access_denied_detail
        self.message = message
        self.request_id = request_id

    def validate(self):
        if self.access_denied_detail:
            self.access_denied_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_denied_detail is not None:
            result['AccessDeniedDetail'] = self.access_denied_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessDeniedDetail') is not None:
            temp_model = CancelIProductionJobResponseBodyAccessDeniedDetail()
            self.access_denied_detail = temp_model.from_map(m['AccessDeniedDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelIProductionJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelIProductionJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelIProductionJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearAIAgentVoiceprintRequest(TeaModel):
    def __init__(
        self,
        voiceprint_id: str = None,
    ):
        self.voiceprint_id = voiceprint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.voiceprint_id is not None:
            result['VoiceprintId'] = self.voiceprint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VoiceprintId') is not None:
            self.voiceprint_id = m.get('VoiceprintId')
        return self


class ClearAIAgentVoiceprintResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClearAIAgentVoiceprintResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClearAIAgentVoiceprintResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearAIAgentVoiceprintResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseMediaConnectFlowFailoverRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class CloseMediaConnectFlowFailoverResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        self.content = content
        self.description = description
        self.request_id = request_id
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class CloseMediaConnectFlowFailoverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CloseMediaConnectFlowFailoverResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseMediaConnectFlowFailoverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAuditRequest(TeaModel):
    def __init__(
        self,
        audit_content: str = None,
    ):
        # The review results. You can specify the results for a maximum of 20 videos at a time. The value must be converted to a string. For more information about the parameters in AuditContent, see the "AuditContent" section of this topic.
        # 
        # This parameter is required.
        self.audit_content = audit_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit_content is not None:
            result['AuditContent'] = self.audit_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuditContent') is not None:
            self.audit_content = m.get('AuditContent')
        return self


class CreateAuditResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAuditResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAuditResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAvatarTrainingJobRequest(TeaModel):
    def __init__(
        self,
        avatar_description: str = None,
        avatar_name: str = None,
        avatar_type: str = None,
        portrait: str = None,
        thumbnail: str = None,
        transparent: bool = None,
        video: str = None,
    ):
        # *   The description of the digital human.
        # *   The description can be up to 1,000 characters in length.
        self.avatar_description = avatar_description
        # *   The name of the digital human.
        # *   The name can be up to seven characters in length.
        # 
        # This parameter is required.
        self.avatar_name = avatar_name
        # The type of the digital human.
        self.avatar_type = avatar_type
        # *   The media asset ID of the portrait image.
        # *   The value must be 32 characters in length.
        self.portrait = portrait
        # *   The thumbnail URL.
        # *   After the digital human is trained, the thumbnail is uploaded to this URL.
        # *   The URL must be a valid public Object Storage Service (OSS) URL.
        # *   The URL can be up to 512 characters in length.
        self.thumbnail = thumbnail
        # *   Specifies whether the training video supports alpha channels.
        # 
        #     **\
        # 
        #     **Note**: Make sure that the current settings are consistent with those of the submitted training video. Otherwise, the digital human may malfunction.
        self.transparent = transparent
        # *   The ID of the video used for training.
        # *   The value must be 32 characters in length.
        # *   Supported formats: MP4, MOV, and WebM.
        # *   The duration of the video must be 5 to 15 minutes.
        # *   The resolution of the video must be 1920×1080 or 1080×1920.
        self.video = video

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_description is not None:
            result['AvatarDescription'] = self.avatar_description
        if self.avatar_name is not None:
            result['AvatarName'] = self.avatar_name
        if self.avatar_type is not None:
            result['AvatarType'] = self.avatar_type
        if self.portrait is not None:
            result['Portrait'] = self.portrait
        if self.thumbnail is not None:
            result['Thumbnail'] = self.thumbnail
        if self.transparent is not None:
            result['Transparent'] = self.transparent
        if self.video is not None:
            result['Video'] = self.video
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarDescription') is not None:
            self.avatar_description = m.get('AvatarDescription')
        if m.get('AvatarName') is not None:
            self.avatar_name = m.get('AvatarName')
        if m.get('AvatarType') is not None:
            self.avatar_type = m.get('AvatarType')
        if m.get('Portrait') is not None:
            self.portrait = m.get('Portrait')
        if m.get('Thumbnail') is not None:
            self.thumbnail = m.get('Thumbnail')
        if m.get('Transparent') is not None:
            self.transparent = m.get('Transparent')
        if m.get('Video') is not None:
            self.video = m.get('Video')
        return self


class CreateAvatarTrainingJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the digital human training job.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateAvatarTrainingJobResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateAvatarTrainingJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateAvatarTrainingJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAvatarTrainingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAvatarTrainingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAvatarTrainingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateChannelRequest(TeaModel):
    def __init__(
        self,
        access_policy: bool = None,
        access_token: str = None,
        channel_name: str = None,
        channel_tier: str = None,
        filler_source_location_name: str = None,
        filler_source_name: str = None,
        out_put_config_list: str = None,
        playback_mode: str = None,
    ):
        # Specifies whether to enable access control.
        self.access_policy = access_policy
        # The token for accessing the channel.
        self.access_token = access_token
        # The name of the channel.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The tier of the channel. Valid values: basic and standard.
        # 
        # This parameter is required.
        self.channel_tier = channel_tier
        # The source location of the filler slate.
        self.filler_source_location_name = filler_source_location_name
        # The name of the filler slate.
        self.filler_source_name = filler_source_name
        # The channel output configurations.
        # 
        # This parameter is required.
        self.out_put_config_list = out_put_config_list
        # The playback mode. Valid values: loop and linear.
        # 
        # This parameter is required.
        self.playback_mode = playback_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_policy is not None:
            result['AccessPolicy'] = self.access_policy
        if self.access_token is not None:
            result['AccessToken'] = self.access_token
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_tier is not None:
            result['ChannelTier'] = self.channel_tier
        if self.filler_source_location_name is not None:
            result['FillerSourceLocationName'] = self.filler_source_location_name
        if self.filler_source_name is not None:
            result['FillerSourceName'] = self.filler_source_name
        if self.out_put_config_list is not None:
            result['OutPutConfigList'] = self.out_put_config_list
        if self.playback_mode is not None:
            result['PlaybackMode'] = self.playback_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPolicy') is not None:
            self.access_policy = m.get('AccessPolicy')
        if m.get('AccessToken') is not None:
            self.access_token = m.get('AccessToken')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelTier') is not None:
            self.channel_tier = m.get('ChannelTier')
        if m.get('FillerSourceLocationName') is not None:
            self.filler_source_location_name = m.get('FillerSourceLocationName')
        if m.get('FillerSourceName') is not None:
            self.filler_source_name = m.get('FillerSourceName')
        if m.get('OutPutConfigList') is not None:
            self.out_put_config_list = m.get('OutPutConfigList')
        if m.get('PlaybackMode') is not None:
            self.playback_mode = m.get('PlaybackMode')
        return self


class CreateChannelResponseBody(TeaModel):
    def __init__(
        self,
        channel: ChannelAssemblyChannel = None,
        request_id: str = None,
    ):
        # The channel information.
        self.channel = channel
        # **Request ID**\
        self.request_id = request_id

    def validate(self):
        if self.channel:
            self.channel.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            temp_model = ChannelAssemblyChannel()
            self.channel = temp_model.from_map(m['Channel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        subtype: int = None,
        template_config: str = None,
        type: int = None,
    ):
        # The template name.
        # 
        # This parameter is required.
        self.name = name
        # The template subtype.
        # 
        # Valid values for transcoding templates:
        # 
        # *   1 (Normal): regular template.
        # *   2 (AudioTranscode): audio transcoding template.
        # *   3 (Remux): container format conversion template.
        # *   4 (NarrowBandV1): Narrowband HD 1.0 template.
        # *   5 (NarrowBandV2): Narrowband HD 2.0 template.
        # 
        # Valid values for snapshot templates:
        # 
        # *   1 (Normal): regular template.
        # *   2 (Sprite): sprite template.
        # *   3 (WebVtt): WebVTT template.
        # 
        # Valid values for AI-assisted content moderation templates:
        # 
        # *   1 (Video): video moderation template.
        # *   2 (Audio): audio moderation template.
        # *   3 (Image): image moderation template.
        # 
        # Valid values for AI-assisted intelligent erasure templates.
        # 
        # *   1 (VideoDelogo): logo erasure template.
        # *   2 (VideoDetext): subtitle erasure template.
        self.subtype = subtype
        # The template configurations. For more information, see [Template parameters](https://help.aliyun.com/document_detail/448291.html).
        # 
        # This parameter is required.
        self.template_config = template_config
        # The template type. Valid values:
        # 
        # *   1: transcoding template.
        # *   2: snapshot template.
        # *   3: animated image template.
        # *   4\\. image watermark template.
        # *   5: text watermark template.
        # *   6: subtitle template.
        # *   7: AI-assisted content moderation template.
        # *   8: AI-assisted intelligent thumbnail template.
        # *   9: AI-assisted intelligent erasure template.
        # *   10: AI-assisted media fingerprint analysis template.
        # *   11: AI-assisted smart tagging template.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        is_default: bool = None,
        modified_time: str = None,
        status: str = None,
        subtype: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # The time when the template was created.
        self.create_time = create_time
        # Indicates whether the template is the default template.
        self.is_default = is_default
        # The time when the template was last modified.
        self.modified_time = modified_time
        # The template state.
        self.status = status
        # The subtype name of the template.
        self.subtype = subtype
        # The template configurations.
        self.template_config = template_config
        # The template ID.
        self.template_id = template_id
        # The template name.
        self.template_name = template_name
        # The type ID of the template.
        self.type = type
        # The type name of the template.
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class CreateCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        custom_template: CreateCustomTemplateResponseBodyCustomTemplate = None,
        request_id: str = None,
    ):
        # The template information.
        self.custom_template = custom_template
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = CreateCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomizedVoiceJobRequest(TeaModel):
    def __init__(
        self,
        gender: str = None,
        scenario: str = None,
        voice_desc: str = None,
        voice_id: str = None,
        voice_name: str = None,
    ):
        # The gender. Valid values:
        # 
        # *   female
        # *   male
        # 
        # This parameter is required.
        self.gender = gender
        # The scenario. Valid values:
        # 
        # *   story
        # *   interaction
        # *   navigation
        # 
        # This parameter is required.
        self.scenario = scenario
        # The voice description.
        # 
        # *   The description can be up to 256 characters in length.
        self.voice_desc = voice_desc
        # The voice ID. It can be the English name or Chinese Pinyin of the voice.
        # 
        # *   The value must be a unique ID that is not used by other custom voices.
        # *   The ID can be up to 32 characters in length.
        # *   Only letters and digits are supported.
        # 
        # This parameter is required.
        self.voice_id = voice_id
        # The voice name.
        # 
        # *   The name can be up to 32 characters in length.
        self.voice_name = voice_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.voice_desc is not None:
            result['VoiceDesc'] = self.voice_desc
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_name is not None:
            result['VoiceName'] = self.voice_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('VoiceDesc') is not None:
            self.voice_desc = m.get('VoiceDesc')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceName') is not None:
            self.voice_name = m.get('VoiceName')
        return self


class CreateCustomizedVoiceJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        voice_id: str = None,
    ):
        # The ID of the human voice cloning job.
        self.job_id = job_id
        # The voice ID.
        self.voice_id = voice_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        return self


class CreateCustomizedVoiceJobResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateCustomizedVoiceJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateCustomizedVoiceJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCustomizedVoiceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomizedVoiceJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomizedVoiceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDNADBRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        model: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The description of the media fingerprint library.
        self.description = description
        # The model of the media fingerprint library. Valid values:
        # 
        # *   **Video**\
        # *   **Audio**\
        # *   **Image**\
        # *   **Text** (supported only in the China (Shanghai) region)
        self.model = model
        # The name of the media fingerprint library.
        # 
        # This parameter is required.
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.model is not None:
            result['Model'] = self.model
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDNADBResponseBodyDBInfo(TeaModel):
    def __init__(
        self,
        dbid: str = None,
        description: str = None,
        model: str = None,
        name: str = None,
        status: str = None,
    ):
        # The ID of the media fingerprint library. We recommend that you save this ID for subsequent calls of other operations.
        self.dbid = dbid
        # The description of the media fingerprint library.
        self.description = description
        # The model of the media fingerprint library.
        self.model = model
        # The name of the media fingerprint library.
        self.name = name
        # The state of the media fingerprint library. After a media fingerprint library is created, it enters the offline state. After the media fingerprint library is processed at the backend, it enters the active state.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbid is not None:
            result['DBId'] = self.dbid
        if self.description is not None:
            result['Description'] = self.description
        if self.model is not None:
            result['Model'] = self.model
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBId') is not None:
            self.dbid = m.get('DBId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDNADBResponseBody(TeaModel):
    def __init__(
        self,
        dbinfo: CreateDNADBResponseBodyDBInfo = None,
        request_id: str = None,
    ):
        # The details of the media fingerprint library.
        self.dbinfo = dbinfo
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.dbinfo:
            self.dbinfo.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinfo is not None:
            result['DBInfo'] = self.dbinfo.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInfo') is not None:
            temp_model = CreateDNADBResponseBodyDBInfo()
            self.dbinfo = temp_model.from_map(m['DBInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDNADBResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDNADBResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDNADBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEditingProjectRequest(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        clips_param: str = None,
        cover_url: str = None,
        description: str = None,
        material_maps: str = None,
        project_type: str = None,
        template_id: str = None,
        template_type: str = None,
        timeline: str = None,
        title: str = None,
    ):
        # The business configuration of the project. This parameter can be ignored for general editing projects.
        # 
        # For a live stream editing project, observe the following rules: OutputMediaConfig.StorageLocation is required. OutputMediaConfig.Path is optional. If you do not specify this option, the live streaming clips are stored in the root directory by default.
        # 
        # Valid values of OutputMediaTarget include vod-media and oss-object. If you do not specify OutputMediaTarget, the default value oss-object is used.
        # 
        # If you set OutputMediaTarget to vod-media, the setting of OutputMediaConfig.Path does not take effect.
        self.business_config = business_config
        # The material parameter corresponding to the template, in the JSON format. If TemplateId is specified, ClipsParam must also be specified. For more information<props="china">, see [Create and use a regular template](https://help.aliyun.com/document_detail/328557.html) and [Create and use an advanced template](https://help.aliyun.com/document_detail/291418.html).
        self.clips_param = clips_param
        # The thumbnail URL of the online editing project.
        self.cover_url = cover_url
        # The description of the online editing project.
        self.description = description
        # The material associated with the project. Separate multiple material IDs with commas (,). Each type supports up to 10 material IDs.
        self.material_maps = material_maps
        # The type of the editing project. Valid values: EditingProject and LiveEditingProject. A value of EditingProject indicates a regular editing project, and a value of LiveEditingProject indicates a live stream editing project.
        self.project_type = project_type
        # The template ID. This parameter is used to quickly build a timeline with ease. Note: Only one of Timeline and TemplateId can be specified. If TemplateId is specified, ClipsParam must also be specified.
        self.template_id = template_id
        # The template type. This parameter is required if you create a template-based online editing project. Default value: Timeline. Valid values:
        # 
        # *   Timeline: a regular template.
        # *   VETemplate: an advanced template.
        self.template_type = template_type
        self.timeline = timeline
        # The title of the online editing project.
        # 
        # This parameter is required.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBodyProject(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        business_status: str = None,
        clips_param: str = None,
        cover_url: str = None,
        create_source: str = None,
        create_time: str = None,
        description: str = None,
        duration: float = None,
        modified_source: str = None,
        modified_time: str = None,
        project_id: str = None,
        project_type: str = None,
        status: int = None,
        status_name: str = None,
        template_id: str = None,
        template_type: str = None,
        timeline: str = None,
        title: str = None,
    ):
        # The business configuration of the project. This parameter can be ignored for general editing projects.
        self.business_config = business_config
        # The business status of the project. This parameter can be ignored for general editing projects. Valid values:
        # 
        # *   Reserving
        # *   ReservationCanceled
        # *   BroadCasting
        # *   LoadingFailed
        # *   LiveFinished
        self.business_status = business_status
        # The template material parameters.
        self.clips_param = clips_param
        # The thumbnail URL of the online editing project.
        self.cover_url = cover_url
        # The method for creating the online editing project. Valid values:
        # 
        # \\- OpenAPI
        # 
        # \\- AliyunConsole
        # 
        # \\- WebSDK
        # 
        # \\- LiveEditingOpenAPI
        # 
        # \\- LiveEditingConsole
        self.create_source = create_source
        # The time when the online editing project was created.
        self.create_time = create_time
        # The description of the online editing project.
        self.description = description
        # The duration of the online editing project.
        self.duration = duration
        # The method for editing the online editing project. Valid values:
        # 
        # \\- OpenAPI
        # 
        # \\- AliyunConsole
        # 
        # \\- WebSDK
        # 
        # \\- LiveEditingOpenAPI
        # 
        # \\- LiveEditingConsole
        self.modified_source = modified_source
        # The time when the online editing project was last edited.
        self.modified_time = modified_time
        # The ID of the online editing project.
        self.project_id = project_id
        # The type of the editing project. Default value: EditingProject. Valid values:
        # 
        # \\- EditingProject: a regular editing project.
        # 
        # \\- LiveEditingProject: a live stream editing project.
        self.project_type = project_type
        # The status of the online editing project.
        # 
        # Valid values:
        # 
        # \\- 1: Draft
        # 
        # \\- 2: Editing
        # 
        # \\- 3: Producing
        # 
        # \\- 4: Produced
        # 
        # \\- 5: ProduceFailed
        # 
        # \\- 7: Deleted
        self.status = status
        # The status of the online editing project. For more information, see the status list.
        self.status_name = status_name
        # The template ID.
        self.template_id = template_id
        # The template type of the online editing project. Valid values:
        # 
        # \\- Timeline
        # 
        # \\- VETemplate
        self.template_type = template_type
        # The timeline of the online editing project, in the JSON format.<props="china">For more information about objects in a timeline, see [Timeline configurations](https://help.aliyun.com/document_detail/198823.htm?spm=a2c4g.11186623.2.9.90dc653dF67srN#topic-2024662).  If you leave this parameter empty, an empty timeline is created and the duration of the online editing project is zero.
        self.timeline = timeline
        # The title of the online editing project.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.status_name is not None:
            result['StatusName'] = self.status_name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusName') is not None:
            self.status_name = m.get('StatusName')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBody(TeaModel):
    def __init__(
        self,
        project: CreateEditingProjectResponseBodyProject = None,
        request_id: str = None,
    ):
        # The information about the online editing project.
        self.project = project
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = CreateEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEditingProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEditingProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHotwordLibraryRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        hotwords: List[Hotword] = None,
        name: str = None,
        usage_scenario: str = None,
    ):
        self.description = description
        # This parameter is required.
        self.hotwords = hotwords
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.usage_scenario = usage_scenario

    def validate(self):
        if self.hotwords:
            for k in self.hotwords:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        result['Hotwords'] = []
        if self.hotwords is not None:
            for k in self.hotwords:
                result['Hotwords'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.usage_scenario is not None:
            result['UsageScenario'] = self.usage_scenario
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.hotwords = []
        if m.get('Hotwords') is not None:
            for k in m.get('Hotwords'):
                temp_model = Hotword()
                self.hotwords.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UsageScenario') is not None:
            self.usage_scenario = m.get('UsageScenario')
        return self


class CreateHotwordLibraryShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        hotwords_shrink: str = None,
        name: str = None,
        usage_scenario: str = None,
    ):
        self.description = description
        # This parameter is required.
        self.hotwords_shrink = hotwords_shrink
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.usage_scenario = usage_scenario

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.hotwords_shrink is not None:
            result['Hotwords'] = self.hotwords_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.usage_scenario is not None:
            result['UsageScenario'] = self.usage_scenario
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Hotwords') is not None:
            self.hotwords_shrink = m.get('Hotwords')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UsageScenario') is not None:
            self.usage_scenario = m.get('UsageScenario')
        return self


class CreateHotwordLibraryResponseBody(TeaModel):
    def __init__(
        self,
        hotword_library_id: str = None,
        request_id: str = None,
    ):
        self.hotword_library_id = hotword_library_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotword_library_id is not None:
            result['HotwordLibraryId'] = self.hotword_library_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HotwordLibraryId') is not None:
            self.hotword_library_id = m.get('HotwordLibraryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHotwordLibraryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHotwordLibraryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHotwordLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLivePackageChannelRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        client_token: str = None,
        description: str = None,
        group_name: str = None,
        protocol: str = None,
        segment_count: int = None,
        segment_duration: int = None,
    ):
        # The channel name. It can contain letters, digits, hyphens (-), and underscores (_). The name must be 1 to 200 characters in length. Format: [A-Za-z0-9_-]+\
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The client token that is used to ensure the idempotence of the request.
        self.client_token = client_token
        # The channel description. It can be up to 1,000 characters in length.
        self.description = description
        # The channel group name. It can contain letters, digits, hyphens (-), and underscores (_). The name must be 1 to 200 characters in length. Format: [A-Za-z0-9_-]+\
        # 
        # This parameter is required.
        self.group_name = group_name
        # The ingest protocol. Only HLS is supported.
        # 
        # This parameter is required.
        self.protocol = protocol
        # The number of M3U8 segments. Valid values: 2 to 100.
        # 
        # This parameter is required.
        self.segment_count = segment_count
        # The segment duration. Valid values: 1 to 30.
        # 
        # This parameter is required.
        self.segment_duration = segment_duration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.segment_count is not None:
            result['SegmentCount'] = self.segment_count
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SegmentCount') is not None:
            self.segment_count = m.get('SegmentCount')
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        return self


class CreateLivePackageChannelResponseBodyLivePackageChannelIngestEndpoints(TeaModel):
    def __init__(
        self,
        id: str = None,
        password: str = None,
        url: str = None,
        username: str = None,
    ):
        # The ingest endpoint ID.
        self.id = id
        # The password.
        self.password = password
        # The ingest endpoint URL.
        self.url = url
        # The username.
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.password is not None:
            result['Password'] = self.password
        if self.url is not None:
            result['Url'] = self.url
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class CreateLivePackageChannelResponseBodyLivePackageChannel(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        create_time: str = None,
        description: str = None,
        group_name: str = None,
        ingest_endpoints: List[CreateLivePackageChannelResponseBodyLivePackageChannelIngestEndpoints] = None,
        last_modified: str = None,
        protocol: str = None,
        segment_count: int = None,
        segment_duration: int = None,
    ):
        # The channel name.
        self.channel_name = channel_name
        # The time when the channel was created. It is in the yyyy-MM-ddTHH:mm:ssZ format and displayed in UTC.
        self.create_time = create_time
        # The channel description.
        self.description = description
        # The channel group name.
        self.group_name = group_name
        # The ingest endpoints.
        self.ingest_endpoints = ingest_endpoints
        # The time when the channel was last modified. It is in the yyyy-MM-ddTHH:mm:ssZ format and displayed in UTC.
        self.last_modified = last_modified
        # The ingest protocol. Only HLS is supported.
        self.protocol = protocol
        # The number of M3U8 segments.
        self.segment_count = segment_count
        # The segment duration.
        self.segment_duration = segment_duration

    def validate(self):
        if self.ingest_endpoints:
            for k in self.ingest_endpoints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        result['IngestEndpoints'] = []
        if self.ingest_endpoints is not None:
            for k in self.ingest_endpoints:
                result['IngestEndpoints'].append(k.to_map() if k else None)
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.segment_count is not None:
            result['SegmentCount'] = self.segment_count
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        self.ingest_endpoints = []
        if m.get('IngestEndpoints') is not None:
            for k in m.get('IngestEndpoints'):
                temp_model = CreateLivePackageChannelResponseBodyLivePackageChannelIngestEndpoints()
                self.ingest_endpoints.append(temp_model.from_map(k))
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SegmentCount') is not None:
            self.segment_count = m.get('SegmentCount')
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        return self


class CreateLivePackageChannelResponseBody(TeaModel):
    def __init__(
        self,
        live_package_channel: CreateLivePackageChannelResponseBodyLivePackageChannel = None,
        request_id: str = None,
    ):
        # The information about the live package channel.
        self.live_package_channel = live_package_channel
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_package_channel:
            self.live_package_channel.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_package_channel is not None:
            result['LivePackageChannel'] = self.live_package_channel.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LivePackageChannel') is not None:
            temp_model = CreateLivePackageChannelResponseBodyLivePackageChannel()
            self.live_package_channel = temp_model.from_map(m['LivePackageChannel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLivePackageChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLivePackageChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLivePackageChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLivePackageChannelGroupRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        description: str = None,
        group_name: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        self.client_token = client_token
        # The channel group description. It can be up to 1,000 characters in length.
        self.description = description
        # The channel group name. It can contain letters, digits, hyphens (-), and underscores (_). The name must be 1 to 200 characters in length. Format: [A-Za-z0-9_-]+\
        # 
        # This parameter is required.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateLivePackageChannelGroupResponseBodyLivePackageChannelGroup(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        group_name: str = None,
        last_modified: str = None,
        origin_domain: str = None,
    ):
        # The time when the channel group was created. It is in the yyyy-MM-ddTHH:mm:ssZ format and displayed in UTC.
        self.create_time = create_time
        # The channel group description.
        self.description = description
        # The channel group name.
        self.group_name = group_name
        # The time when the channel group was last modified. It is in the yyyy-MM-ddTHH:mm:ssZ format and displayed in UTC.
        self.last_modified = last_modified
        # The origin domain.
        self.origin_domain = origin_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.origin_domain is not None:
            result['OriginDomain'] = self.origin_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('OriginDomain') is not None:
            self.origin_domain = m.get('OriginDomain')
        return self


class CreateLivePackageChannelGroupResponseBody(TeaModel):
    def __init__(
        self,
        live_package_channel_group: CreateLivePackageChannelGroupResponseBodyLivePackageChannelGroup = None,
        request_id: str = None,
    ):
        # The information about the channel group.
        self.live_package_channel_group = live_package_channel_group
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_package_channel_group:
            self.live_package_channel_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_package_channel_group is not None:
            result['LivePackageChannelGroup'] = self.live_package_channel_group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LivePackageChannelGroup') is not None:
            temp_model = CreateLivePackageChannelGroupResponseBodyLivePackageChannelGroup()
            self.live_package_channel_group = temp_model.from_map(m['LivePackageChannelGroup'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLivePackageChannelGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLivePackageChannelGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLivePackageChannelGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLivePackageOriginEndpointRequest(TeaModel):
    def __init__(
        self,
        authorization_code: str = None,
        channel_name: str = None,
        client_token: str = None,
        description: str = None,
        endpoint_name: str = None,
        group_name: str = None,
        ip_blacklist: str = None,
        ip_whitelist: str = None,
        live_packaging_config: LivePackagingConfig = None,
        manifest_name: str = None,
        protocol: str = None,
        timeshift_vision: int = None,
    ):
        # The authorization code. It can be up to 200 characters in length. You must configure AuthorizationCode, IpWhitelist, or both. Format: [A-Za-z0-9-_.]+\
        self.authorization_code = authorization_code
        # The channel name.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The client token that is used to ensure the idempotence of the request.
        self.client_token = client_token
        # The endpoint description.
        self.description = description
        # The origin endpoint name. It can contain letters, digits, hyphens (-), and underscores (_). The name must be 1 to 200 characters in length. Format: [A-Za-z0-9_-]+\
        # 
        # This parameter is required.
        self.endpoint_name = endpoint_name
        # The channel group name.
        # 
        # This parameter is required.
        self.group_name = group_name
        # The IP address blacklist. It supports subnet masks. 0.0.0.0/0 is not allowed. It can be up to 1,000 characters in length. Separate multiple IP addresses with commas (,).
        self.ip_blacklist = ip_blacklist
        # The IP address whitelist. It supports subnet masks. 0.0.0.0/0 is not allowed. It can be up to 1,000 characters in length. Separate multiple IP addresses with commas (,). You must configure AuthorizationCode, IpWhitelist, or both.
        self.ip_whitelist = ip_whitelist
        self.live_packaging_config = live_packaging_config
        # The playlist name. Default value: manifest.
        self.manifest_name = manifest_name
        # The distribution protocol.
        # 
        # This parameter is required.
        self.protocol = protocol
        # The number of days that time-shifted content is available. Maximum value: 30. Default value: 0, which indicates that time shifting is not supported.
        self.timeshift_vision = timeshift_vision

    def validate(self):
        if self.live_packaging_config:
            self.live_packaging_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_code is not None:
            result['AuthorizationCode'] = self.authorization_code
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.endpoint_name is not None:
            result['EndpointName'] = self.endpoint_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.ip_blacklist is not None:
            result['IpBlacklist'] = self.ip_blacklist
        if self.ip_whitelist is not None:
            result['IpWhitelist'] = self.ip_whitelist
        if self.live_packaging_config is not None:
            result['LivePackagingConfig'] = self.live_packaging_config.to_map()
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.timeshift_vision is not None:
            result['TimeshiftVision'] = self.timeshift_vision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationCode') is not None:
            self.authorization_code = m.get('AuthorizationCode')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndpointName') is not None:
            self.endpoint_name = m.get('EndpointName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IpBlacklist') is not None:
            self.ip_blacklist = m.get('IpBlacklist')
        if m.get('IpWhitelist') is not None:
            self.ip_whitelist = m.get('IpWhitelist')
        if m.get('LivePackagingConfig') is not None:
            temp_model = LivePackagingConfig()
            self.live_packaging_config = temp_model.from_map(m['LivePackagingConfig'])
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TimeshiftVision') is not None:
            self.timeshift_vision = m.get('TimeshiftVision')
        return self


class CreateLivePackageOriginEndpointShrinkRequest(TeaModel):
    def __init__(
        self,
        authorization_code: str = None,
        channel_name: str = None,
        client_token: str = None,
        description: str = None,
        endpoint_name: str = None,
        group_name: str = None,
        ip_blacklist: str = None,
        ip_whitelist: str = None,
        live_packaging_config_shrink: str = None,
        manifest_name: str = None,
        protocol: str = None,
        timeshift_vision: int = None,
    ):
        # The authorization code. It can be up to 200 characters in length. You must configure AuthorizationCode, IpWhitelist, or both. Format: [A-Za-z0-9-_.]+\
        self.authorization_code = authorization_code
        # The channel name.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The client token that is used to ensure the idempotence of the request.
        self.client_token = client_token
        # The endpoint description.
        self.description = description
        # The origin endpoint name. It can contain letters, digits, hyphens (-), and underscores (_). The name must be 1 to 200 characters in length. Format: [A-Za-z0-9_-]+\
        # 
        # This parameter is required.
        self.endpoint_name = endpoint_name
        # The channel group name.
        # 
        # This parameter is required.
        self.group_name = group_name
        # The IP address blacklist. It supports subnet masks. 0.0.0.0/0 is not allowed. It can be up to 1,000 characters in length. Separate multiple IP addresses with commas (,).
        self.ip_blacklist = ip_blacklist
        # The IP address whitelist. It supports subnet masks. 0.0.0.0/0 is not allowed. It can be up to 1,000 characters in length. Separate multiple IP addresses with commas (,). You must configure AuthorizationCode, IpWhitelist, or both.
        self.ip_whitelist = ip_whitelist
        self.live_packaging_config_shrink = live_packaging_config_shrink
        # The playlist name. Default value: manifest.
        self.manifest_name = manifest_name
        # The distribution protocol.
        # 
        # This parameter is required.
        self.protocol = protocol
        # The number of days that time-shifted content is available. Maximum value: 30. Default value: 0, which indicates that time shifting is not supported.
        self.timeshift_vision = timeshift_vision

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_code is not None:
            result['AuthorizationCode'] = self.authorization_code
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.endpoint_name is not None:
            result['EndpointName'] = self.endpoint_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.ip_blacklist is not None:
            result['IpBlacklist'] = self.ip_blacklist
        if self.ip_whitelist is not None:
            result['IpWhitelist'] = self.ip_whitelist
        if self.live_packaging_config_shrink is not None:
            result['LivePackagingConfig'] = self.live_packaging_config_shrink
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.timeshift_vision is not None:
            result['TimeshiftVision'] = self.timeshift_vision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationCode') is not None:
            self.authorization_code = m.get('AuthorizationCode')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndpointName') is not None:
            self.endpoint_name = m.get('EndpointName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IpBlacklist') is not None:
            self.ip_blacklist = m.get('IpBlacklist')
        if m.get('IpWhitelist') is not None:
            self.ip_whitelist = m.get('IpWhitelist')
        if m.get('LivePackagingConfig') is not None:
            self.live_packaging_config_shrink = m.get('LivePackagingConfig')
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TimeshiftVision') is not None:
            self.timeshift_vision = m.get('TimeshiftVision')
        return self


class CreateLivePackageOriginEndpointResponseBodyLivePackageOriginEndpoint(TeaModel):
    def __init__(
        self,
        authorization_code: str = None,
        channel_name: str = None,
        create_time: str = None,
        description: str = None,
        endpoint_name: str = None,
        endpoint_url: str = None,
        group_name: str = None,
        ip_blacklist: str = None,
        ip_whitelist: str = None,
        last_modified: str = None,
        live_packaging_config: LivePackagingConfig = None,
        manifest_name: str = None,
        protocol: str = None,
        timeshift_vision: int = None,
    ):
        # The authorization code.
        self.authorization_code = authorization_code
        # The channel name.
        self.channel_name = channel_name
        # The time when the endpoint was created.
        self.create_time = create_time
        # The endpoint description.
        self.description = description
        # The endpoint name.
        self.endpoint_name = endpoint_name
        # The endpoint URL.
        self.endpoint_url = endpoint_url
        # The channel group name.
        self.group_name = group_name
        # The IP address blacklist.
        self.ip_blacklist = ip_blacklist
        # The IP address whitelist.
        self.ip_whitelist = ip_whitelist
        # The time when the endpoint was last modified.
        self.last_modified = last_modified
        self.live_packaging_config = live_packaging_config
        # The playlist name.
        self.manifest_name = manifest_name
        # The protocol. Only HLS is supported.
        self.protocol = protocol
        # The number of days that time-shifted content is available. Maximum value: 30.
        self.timeshift_vision = timeshift_vision

    def validate(self):
        if self.live_packaging_config:
            self.live_packaging_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_code is not None:
            result['AuthorizationCode'] = self.authorization_code
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.endpoint_name is not None:
            result['EndpointName'] = self.endpoint_name
        if self.endpoint_url is not None:
            result['EndpointUrl'] = self.endpoint_url
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.ip_blacklist is not None:
            result['IpBlacklist'] = self.ip_blacklist
        if self.ip_whitelist is not None:
            result['IpWhitelist'] = self.ip_whitelist
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.live_packaging_config is not None:
            result['LivePackagingConfig'] = self.live_packaging_config.to_map()
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.timeshift_vision is not None:
            result['TimeshiftVision'] = self.timeshift_vision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationCode') is not None:
            self.authorization_code = m.get('AuthorizationCode')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndpointName') is not None:
            self.endpoint_name = m.get('EndpointName')
        if m.get('EndpointUrl') is not None:
            self.endpoint_url = m.get('EndpointUrl')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IpBlacklist') is not None:
            self.ip_blacklist = m.get('IpBlacklist')
        if m.get('IpWhitelist') is not None:
            self.ip_whitelist = m.get('IpWhitelist')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('LivePackagingConfig') is not None:
            temp_model = LivePackagingConfig()
            self.live_packaging_config = temp_model.from_map(m['LivePackagingConfig'])
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TimeshiftVision') is not None:
            self.timeshift_vision = m.get('TimeshiftVision')
        return self


class CreateLivePackageOriginEndpointResponseBody(TeaModel):
    def __init__(
        self,
        live_package_origin_endpoint: CreateLivePackageOriginEndpointResponseBodyLivePackageOriginEndpoint = None,
        request_id: str = None,
    ):
        # The information about the origin endpoint.
        self.live_package_origin_endpoint = live_package_origin_endpoint
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_package_origin_endpoint:
            self.live_package_origin_endpoint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_package_origin_endpoint is not None:
            result['LivePackageOriginEndpoint'] = self.live_package_origin_endpoint.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LivePackageOriginEndpoint') is not None:
            temp_model = CreateLivePackageOriginEndpointResponseBodyLivePackageOriginEndpoint()
            self.live_package_origin_endpoint = temp_model.from_map(m['LivePackageOriginEndpoint'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLivePackageOriginEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLivePackageOriginEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLivePackageOriginEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRecordTemplateRequestRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        format: str = None,
        oss_object_prefix: str = None,
        slice_duration: int = None,
        slice_oss_object_prefix: str = None,
    ):
        # The duration of the recording cycle. Unit: seconds. If you do not specify this parameter, the default value 6 hours is used.
        # 
        # > 
        # 
        # *   If a live stream is interrupted during a recording cycle but is resumed within 3 minutes, the stream is recorded in the same recording before and after the interruption.
        # 
        # *   If a live stream is interrupted for more than 3 minutes, a new recording is generated. To change the default stream interruption time, submit a ticket.
        self.cycle_duration = cycle_duration
        # The format.
        # 
        # >  If you set this parameter to m3u8, you must also specify the SliceOssObjectPrefix and SliceDuration parameters.
        # 
        # This parameter is required.
        self.format = format
        # The name of the recording file that is stored in Object Storage Service (OSS).
        # 
        # *   The name must be less than 256 bytes in length and can contain the {JobId}, {Sequence}, {StartTime}, {EndTime}, {EscapedStartTime}, and {EscapedEndTime} variables.
        # *   The name must contain the {StartTime} and {EndTime} variables or the {EscapedStartTime} and {EscapedEndTime} variables.
        self.oss_object_prefix = oss_object_prefix
        # The duration of a single segment. Unit: seconds.
        # 
        # >  This parameter takes effect only if you set Format to m3u8.
        # 
        # If you do not specify this parameter, the default value 30 seconds is used. Valid values: 5 to 30.
        self.slice_duration = slice_duration
        # The name of the TS segment.
        # 
        # >  This parameter is required only if you set Format to m3u8.
        # 
        # *   By default, the duration of a segment is 30 seconds. The segment name must be less than 256 bytes in length and can contain the {JobId}, {UnixTimestamp}, and {Sequence} variables.
        # *   The segment name must contain the {UnixTimestamp} and {Sequence} variables.
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class CreateLiveRecordTemplateRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        record_format: List[CreateLiveRecordTemplateRequestRecordFormat] = None,
    ):
        # The name of the template.
        # 
        # This parameter is required.
        self.name = name
        # The list of recording formats.
        # 
        # This parameter is required.
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = CreateLiveRecordTemplateRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class CreateLiveRecordTemplateShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        record_format_shrink: str = None,
    ):
        # The name of the template.
        # 
        # This parameter is required.
        self.name = name
        # The list of recording formats.
        # 
        # This parameter is required.
        self.record_format_shrink = record_format_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record_format_shrink is not None:
            result['RecordFormat'] = self.record_format_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordFormat') is not None:
            self.record_format_shrink = m.get('RecordFormat')
        return self


class CreateLiveRecordTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The template ID.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveRecordTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveRecordTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveSnapshotTemplateRequest(TeaModel):
    def __init__(
        self,
        overwrite_format: str = None,
        sequence_format: str = None,
        template_name: str = None,
        time_interval: int = None,
    ):
        # The naming format of the snapshot captured in overwrite mode.
        # 
        # *   The value cannot start with a forward slash (/). Only the suffix .jpg is supported.
        # *   It cannot exceed 255 characters in length.
        # *   The {JobId} placeholder is supported. It specifies the ID of the snapshot job.
        # *   Placeholders such as {UnixTimestamp}, {Sequence}, and {Date} are not allowed.
        # *   You must specify at least one of the OverwriteFormat and SequenceFormat parameters.
        self.overwrite_format = overwrite_format
        # The naming format of the snapshot captured in time series mode.
        # 
        # *   The value cannot start with a forward slash (/). Only the suffix .jpg is supported.
        # *   It cannot exceed 255 characters in length.
        # *   The {JobId}, {Date}, {UnixTimestamp}, and {Sequence} placeholders are supported. {JobId} specifies the ID of the snapshot job. {Date} specifies the date on which the snapshot is captured. {UnixTimestamp} specifies the timestamp of the snapshot. {Sequence} specifies the sequence number of the snapshot. You must specify at least one of the {UnixTimestamp} and {Sequence} placeholders.
        # *   You must specify at least one of the OverwriteFormat and SequenceFormat parameters.
        self.sequence_format = sequence_format
        # The name of the template.
        # 
        # *   It cannot exceed 128 characters in length.
        # 
        # This parameter is required.
        self.template_name = template_name
        # The interval between two adjacent snapshots. Unit: seconds.
        # 
        # *   Valid values: [5,3600].
        # 
        # This parameter is required.
        self.time_interval = time_interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_format is not None:
            result['OverwriteFormat'] = self.overwrite_format
        if self.sequence_format is not None:
            result['SequenceFormat'] = self.sequence_format
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteFormat') is not None:
            self.overwrite_format = m.get('OverwriteFormat')
        if m.get('SequenceFormat') is not None:
            self.sequence_format = m.get('SequenceFormat')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class CreateLiveSnapshotTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The template ID.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveSnapshotTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveSnapshotTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveSnapshotTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        samplerate: str = None,
    ):
        # The bitrate of the output audio. Unit: Kbit/s. Valid values: 1 to 1000.
        self.bitrate = bitrate
        # The number of sound channels. Valid values: 1: mono 2: binaural
        self.channels = channels
        # The audio codec. Valid values:
        # 
        # *   AAC
        # *   MP3
        self.codec = codec
        # The audio codec profile. Valid values when the Codec parameter is set to AAC:
        # 
        # *   aac_low
        # *   aac_he
        # *   aac_he_v2
        # *   aac_ld
        self.profile = profile
        # The audio sampling rate. Valid values: 22050 to 96000.
        # 
        # Note: If you set AudioProfile to aac_ld, the audio sampling rate cannot exceed 44,100.
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        codec: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        profile: str = None,
        width: str = None,
    ):
        # The bitrate of the output video. Unit: Kbit/s. Valid values: 1 to 6000.
        self.bitrate = bitrate
        # The encoding type. Valid values:
        # 
        # *   H.264
        # *   H.265
        self.codec = codec
        # The frame rate of the output video. Unit: frames per second (FPS). Valid values: 1 to 60.
        self.fps = fps
        # The group of pictures (GOP) of the output video. Unit: frame. Valid values: 1 to 3000.
        self.gop = gop
        # The height of the output video. Valid values: Height ≥ 128 max (Height,Width) ≤ 2560 min (Height,Width) ≤ 1440
        # 
        # Note: The resolution of the output video that is transcoded by using the H.265 Narrowband HD transcoding template cannot exceed 1280 × 720 pixels.
        self.height = height
        # The encoding profile. The profile determines how a video is encoded. In most cases, a greater value indicates better image quality and higher resource consumption. Valid values: 1: baseline. This value is suitable for mobile devices. 2: main. This value is suitable for standard-definition devices. 3: high. This value is suitable for high-definition devices.
        self.profile = profile
        # The width of the output video. Valid values: Width ≥ 128 max (Height,Width) ≤ 2560 min (Height,Width) ≤ 1440
        # 
        # Note: The resolution of the output video that is transcoded by using the H.265 Narrowband HD transcoding template cannot exceed 1280 × 720 pixels.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfig(TeaModel):
    def __init__(
        self,
        audio_params: CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams = None,
        video_params: CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams = None,
    ):
        # The audio parameters.
        self.audio_params = audio_params
        # The video parameters.
        self.video_params = video_params

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class CreateLiveTranscodeTemplateRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        template_config: CreateLiveTranscodeTemplateRequestTemplateConfig = None,
        type: str = None,
    ):
        # The name of the template.
        # 
        # This parameter is required.
        self.name = name
        # The configuration of the template.
        self.template_config = template_config
        # The type of the template. Valid values:
        # 
        # *   normal
        # *   narrow-band
        # *   audio-only
        # *   origin
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateLiveTranscodeTemplateShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        template_config_shrink: str = None,
        type: str = None,
    ):
        # The name of the template.
        # 
        # This parameter is required.
        self.name = name
        # The configuration of the template.
        self.template_config_shrink = template_config_shrink
        # The type of the template. Valid values:
        # 
        # *   normal
        # *   narrow-band
        # *   audio-only
        # *   origin
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config_shrink is not None:
            result['TemplateConfig'] = self.template_config_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            self.template_config_shrink = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the template.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveTranscodeTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveTranscodeTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMediaConnectFlowRequest(TeaModel):
    def __init__(
        self,
        flow_name: str = None,
        flow_region: str = None,
    ):
        # The flow name.
        # 
        # This parameter is required.
        self.flow_name = flow_name
        # The region in which the flow resides.
        # 
        # This parameter is required.
        self.flow_region = flow_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.flow_region is not None:
            result['FlowRegion'] = self.flow_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('FlowRegion') is not None:
            self.flow_region = m.get('FlowRegion')
        return self


class CreateMediaConnectFlowResponseBodyContent(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        # The flow ID.
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class CreateMediaConnectFlowResponseBody(TeaModel):
    def __init__(
        self,
        content: CreateMediaConnectFlowResponseBodyContent = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The returned message.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of 0 indicates the call is successful.
        self.ret_code = ret_code

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = CreateMediaConnectFlowResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class CreateMediaConnectFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMediaConnectFlowResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMediaConnectFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMediaLiveChannelRequestAudioSettingsAudioCodecSetting(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        profile: str = None,
        sample_rate: int = None,
    ):
        # The audio bitrate. Unit: bit/s. Valid values: 8000 to 1000000. The value must be divisible by 1000.
        self.bitrate = bitrate
        # The audio codec profile. When AudioCodec is set to aac, AAC-LOW and AAC-MAIN are supported. When AudioCodec is set to libfdk_aac, AAC-LOW, AAC-HE, and AAC-HEV2 are supported.
        self.profile = profile
        # The audio sample rate. Unit: Hz. Valid values: 22050, 32000, 44100, 48000, and 96000.
        self.sample_rate = sample_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        return self


class CreateMediaLiveChannelRequestAudioSettings(TeaModel):
    def __init__(
        self,
        audio_codec: str = None,
        audio_codec_setting: CreateMediaLiveChannelRequestAudioSettingsAudioCodecSetting = None,
        audio_selector_name: str = None,
        language_code: str = None,
        language_name: str = None,
        name: str = None,
    ):
        # The audio codec. If it is not specified, the source specification is used. Valid values: aac and libfdk_aac.
        self.audio_codec = audio_codec
        # The audio encoding settings.
        self.audio_codec_setting = audio_codec_setting
        # The name of the audio selector.
        self.audio_selector_name = audio_selector_name
        # Enter a three-letter ISO 639-2 language code. If the audio track selected by the audio selector has a language code, the language code specified in the audio selector is used. If the selected audio track does not have a language code, or if the audio selector cannot find a track that matches its criteria, this language code is used.
        self.language_code = language_code
        # The tag that identifies the language of the RTMP input. It can be referenced by the output. The maximum length is 32 characters. Supported characters:
        # 
        # *   Unicode letters
        # *   Digits (0-9)
        # *   Underscore (_)
        # *   Hyphen (-)
        # *   Space (a space cannot be at the beginning or end)
        self.language_name = language_name
        # The name of the audio settings. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        if self.audio_codec_setting:
            self.audio_codec_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_codec_setting is not None:
            result['AudioCodecSetting'] = self.audio_codec_setting.to_map()
        if self.audio_selector_name is not None:
            result['AudioSelectorName'] = self.audio_selector_name
        if self.language_code is not None:
            result['LanguageCode'] = self.language_code
        if self.language_name is not None:
            result['LanguageName'] = self.language_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioCodecSetting') is not None:
            temp_model = CreateMediaLiveChannelRequestAudioSettingsAudioCodecSetting()
            self.audio_codec_setting = temp_model.from_map(m['AudioCodecSetting'])
        if m.get('AudioSelectorName') is not None:
            self.audio_selector_name = m.get('AudioSelectorName')
        if m.get('LanguageCode') is not None:
            self.language_code = m.get('LanguageCode')
        if m.get('LanguageName') is not None:
            self.language_name = m.get('LanguageName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioLanguageSelection(TeaModel):
    def __init__(
        self,
        language_code: str = None,
    ):
        # Enter a three-letter ISO 639-2 language code from within an audio source.
        # 
        # This parameter is required.
        self.language_code = language_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.language_code is not None:
            result['LanguageCode'] = self.language_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LanguageCode') is not None:
            self.language_code = m.get('LanguageCode')
        return self


class CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioPidSelection(TeaModel):
    def __init__(
        self,
        pid: int = None,
    ):
        # Enter a specific PID from within a source.
        # 
        # This parameter is required.
        self.pid = pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pid is not None:
            result['Pid'] = self.pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        return self


class CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioTrackSelection(TeaModel):
    def __init__(
        self,
        track_id: int = None,
    ):
        # Specify one or more audio tracks from within a source using Track ID.
        # 
        # This parameter is required.
        self.track_id = track_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.track_id is not None:
            result['TrackId'] = self.track_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TrackId') is not None:
            self.track_id = m.get('TrackId')
        return self


class CreateMediaLiveChannelRequestInputAttachmentsAudioSelectors(TeaModel):
    def __init__(
        self,
        audio_language_selection: CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioLanguageSelection = None,
        audio_pid_selection: CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioPidSelection = None,
        audio_track_selection: List[CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioTrackSelection] = None,
        name: str = None,
    ):
        # The audio language selection.
        self.audio_language_selection = audio_language_selection
        # The audio PID selection.
        self.audio_pid_selection = audio_pid_selection
        # The audio track selection.
        self.audio_track_selection = audio_track_selection
        # The name of the audio selector. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        if self.audio_language_selection:
            self.audio_language_selection.validate()
        if self.audio_pid_selection:
            self.audio_pid_selection.validate()
        if self.audio_track_selection:
            for k in self.audio_track_selection:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_language_selection is not None:
            result['AudioLanguageSelection'] = self.audio_language_selection.to_map()
        if self.audio_pid_selection is not None:
            result['AudioPidSelection'] = self.audio_pid_selection.to_map()
        result['AudioTrackSelection'] = []
        if self.audio_track_selection is not None:
            for k in self.audio_track_selection:
                result['AudioTrackSelection'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioLanguageSelection') is not None:
            temp_model = CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioLanguageSelection()
            self.audio_language_selection = temp_model.from_map(m['AudioLanguageSelection'])
        if m.get('AudioPidSelection') is not None:
            temp_model = CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioPidSelection()
            self.audio_pid_selection = temp_model.from_map(m['AudioPidSelection'])
        self.audio_track_selection = []
        if m.get('AudioTrackSelection') is not None:
            for k in m.get('AudioTrackSelection'):
                temp_model = CreateMediaLiveChannelRequestInputAttachmentsAudioSelectorsAudioTrackSelection()
                self.audio_track_selection.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateMediaLiveChannelRequestInputAttachments(TeaModel):
    def __init__(
        self,
        audio_selectors: List[CreateMediaLiveChannelRequestInputAttachmentsAudioSelectors] = None,
        input_id: str = None,
        language_name: str = None,
    ):
        # The audio selectors.
        self.audio_selectors = audio_selectors
        # The ID of the associated input.
        # 
        # This parameter is required.
        self.input_id = input_id
        # The tag that identifies the language of the RTMP input. It can be referenced by the output. The maximum length is 32 characters. Supported characters:
        # 
        # *   Unicode letters
        # *   Digits (0-9)
        # *   Underscore (_)
        # *   Hyphen (-)
        # *   Space (a space cannot be at the beginning or end)
        self.language_name = language_name

    def validate(self):
        if self.audio_selectors:
            for k in self.audio_selectors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioSelectors'] = []
        if self.audio_selectors is not None:
            for k in self.audio_selectors:
                result['AudioSelectors'].append(k.to_map() if k else None)
        if self.input_id is not None:
            result['InputId'] = self.input_id
        if self.language_name is not None:
            result['LanguageName'] = self.language_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_selectors = []
        if m.get('AudioSelectors') is not None:
            for k in m.get('AudioSelectors'):
                temp_model = CreateMediaLiveChannelRequestInputAttachmentsAudioSelectors()
                self.audio_selectors.append(temp_model.from_map(k))
        if m.get('InputId') is not None:
            self.input_id = m.get('InputId')
        if m.get('LanguageName') is not None:
            self.language_name = m.get('LanguageName')
        return self


class CreateMediaLiveChannelRequestOutputGroupsMediaPackageGroupSetting(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        group_name: str = None,
    ):
        # ChannelName in MediaPackage.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # GroupName in MediaPackage.
        # 
        # This parameter is required.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateMediaLiveChannelRequestOutputGroupsOutputsMediaPackageOutputSetting(TeaModel):
    def __init__(
        self,
        audio_group_id: str = None,
        name_modifier: str = None,
    ):
        # The manifest audio group ID. To associate several audio tracks into one group, assign the same audio group ID. Viewers can select a track as needed. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 40 characters in length.
        self.audio_group_id = audio_group_id
        # The manifest name modifier. The child manifests include this modifier in their M3U8 file names. Letters, digits, hyphens (-), and underscores (_) are supported. The maximum length is 40 characters.
        self.name_modifier = name_modifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_group_id is not None:
            result['AudioGroupId'] = self.audio_group_id
        if self.name_modifier is not None:
            result['NameModifier'] = self.name_modifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioGroupId') is not None:
            self.audio_group_id = m.get('AudioGroupId')
        if m.get('NameModifier') is not None:
            self.name_modifier = m.get('NameModifier')
        return self


class CreateMediaLiveChannelRequestOutputGroupsOutputs(TeaModel):
    def __init__(
        self,
        audio_setting_names: List[str] = None,
        media_package_output_setting: CreateMediaLiveChannelRequestOutputGroupsOutputsMediaPackageOutputSetting = None,
        media_type: int = None,
        name: str = None,
        video_setting_name: str = None,
    ):
        # The referenced AudioSettings.
        self.audio_setting_names = audio_setting_names
        # The settings of the output delivered to MediaPackage.
        self.media_package_output_setting = media_package_output_setting
        # The media type of the output. Valid values:
        # 
        # *   0: Audio and Video.
        # *   1: Audio. If you set the value to 1, you cannot reference VideoSettings.
        # *   2: Video. If you set the value to 2, you cannot reference AudioSettings.
        self.media_type = media_type
        # The name of the output. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The name of the referenced VideoSettings.
        self.video_setting_name = video_setting_name

    def validate(self):
        if self.media_package_output_setting:
            self.media_package_output_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_setting_names is not None:
            result['AudioSettingNames'] = self.audio_setting_names
        if self.media_package_output_setting is not None:
            result['MediaPackageOutputSetting'] = self.media_package_output_setting.to_map()
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.name is not None:
            result['Name'] = self.name
        if self.video_setting_name is not None:
            result['VideoSettingName'] = self.video_setting_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioSettingNames') is not None:
            self.audio_setting_names = m.get('AudioSettingNames')
        if m.get('MediaPackageOutputSetting') is not None:
            temp_model = CreateMediaLiveChannelRequestOutputGroupsOutputsMediaPackageOutputSetting()
            self.media_package_output_setting = temp_model.from_map(m['MediaPackageOutputSetting'])
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VideoSettingName') is not None:
            self.video_setting_name = m.get('VideoSettingName')
        return self


class CreateMediaLiveChannelRequestOutputGroups(TeaModel):
    def __init__(
        self,
        media_package_group_setting: CreateMediaLiveChannelRequestOutputGroupsMediaPackageGroupSetting = None,
        name: str = None,
        outputs: List[CreateMediaLiveChannelRequestOutputGroupsOutputs] = None,
        type: str = None,
    ):
        # The MediaPackage destination.
        self.media_package_group_setting = media_package_group_setting
        # The name of the output group. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The outputs in the output group.
        # 
        # This parameter is required.
        self.outputs = outputs
        # The output group type. Only MediaPackage is supported.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.media_package_group_setting:
            self.media_package_group_setting.validate()
        if self.outputs:
            for k in self.outputs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_package_group_setting is not None:
            result['MediaPackageGroupSetting'] = self.media_package_group_setting.to_map()
        if self.name is not None:
            result['Name'] = self.name
        result['Outputs'] = []
        if self.outputs is not None:
            for k in self.outputs:
                result['Outputs'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaPackageGroupSetting') is not None:
            temp_model = CreateMediaLiveChannelRequestOutputGroupsMediaPackageGroupSetting()
            self.media_package_group_setting = temp_model.from_map(m['MediaPackageGroupSetting'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.outputs = []
        if m.get('Outputs') is not None:
            for k in m.get('Outputs'):
                temp_model = CreateMediaLiveChannelRequestOutputGroupsOutputs()
                self.outputs.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingCodecDetail(TeaModel):
    def __init__(
        self,
        level: str = None,
        profile: str = None,
    ):
        # The video encoding level. It is not supported yet.
        self.level = level
        # The H.264 profile. Valid values: BASELINE, HIGH, and MAIN. Default value: MAIN. The parameter takes effect only when the codec is H.264.
        self.profile = profile

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.profile is not None:
            result['Profile'] = self.profile
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        return self


class CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingFramerate(TeaModel):
    def __init__(
        self,
        framerate_control: str = None,
        framerate_denominator: int = None,
        framerate_numerator: int = None,
    ):
        # The frame rate mode. Valid values: SPECIFIED (fixed frame rate) and FROM_SOURCE (use source specification).
        self.framerate_control = framerate_control
        # The denominator of the fixed frame rate. The parameter is required when FramerateControl is set to SPECIFIED. Valid values: 1 to 60. The numerator must be divisible by the denominator.
        self.framerate_denominator = framerate_denominator
        # The numerator of the fixed frame rate. The parameter is required when FramerateControl is set to SPECIFIED. Valid values: 1 to 60. The numerator must be divisible by the denominator.
        self.framerate_numerator = framerate_numerator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.framerate_control is not None:
            result['FramerateControl'] = self.framerate_control
        if self.framerate_denominator is not None:
            result['FramerateDenominator'] = self.framerate_denominator
        if self.framerate_numerator is not None:
            result['FramerateNumerator'] = self.framerate_numerator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FramerateControl') is not None:
            self.framerate_control = m.get('FramerateControl')
        if m.get('FramerateDenominator') is not None:
            self.framerate_denominator = m.get('FramerateDenominator')
        if m.get('FramerateNumerator') is not None:
            self.framerate_numerator = m.get('FramerateNumerator')
        return self


class CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingGop(TeaModel):
    def __init__(
        self,
        bframes_num: int = None,
        gop_size: int = None,
        gop_size_units: str = None,
    ):
        # The number of B frames. Valid values: 1 to 3.
        self.bframes_num = bframes_num
        # The GOP size. When GopSizeUnits is set to SECONDS, the value range is from 1 to 20. When GopSizeUnits is set to FRAMES, the value range is from 1 to 3000.
        self.gop_size = gop_size
        # The GOP size unit. Valid values: FRAMES and SECONDS.
        self.gop_size_units = gop_size_units

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bframes_num is not None:
            result['BframesNum'] = self.bframes_num
        if self.gop_size is not None:
            result['GopSize'] = self.gop_size
        if self.gop_size_units is not None:
            result['GopSizeUnits'] = self.gop_size_units
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BframesNum') is not None:
            self.bframes_num = m.get('BframesNum')
        if m.get('GopSize') is not None:
            self.gop_size = m.get('GopSize')
        if m.get('GopSizeUnits') is not None:
            self.gop_size_units = m.get('GopSizeUnits')
        return self


class CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingRate(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        buffer_size: int = None,
        max_bitrate: int = None,
        rate_control_mode: str = None,
    ):
        # The video bitrate. Unit: bit/s. If you set it to 0 or leave it empty, the source specification is used. Valid values: 50000 to 6000000. The value must be divisible by 1000.
        self.bitrate = bitrate
        # The video buffer size. Unit: bit/s. Valid values: 100000 to 6000000. The value must be divisible by 1000.
        self.buffer_size = buffer_size
        # The maximum bitrate. Unit: bit/s. Valid values: 100000 to 6000000. The value must be divisible by 1000.
        self.max_bitrate = max_bitrate
        # The bitrate control mode. Valid values: CBR, ABR, and VBR.
        self.rate_control_mode = rate_control_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.buffer_size is not None:
            result['BufferSize'] = self.buffer_size
        if self.max_bitrate is not None:
            result['MaxBitrate'] = self.max_bitrate
        if self.rate_control_mode is not None:
            result['RateControlMode'] = self.rate_control_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('BufferSize') is not None:
            self.buffer_size = m.get('BufferSize')
        if m.get('MaxBitrate') is not None:
            self.max_bitrate = m.get('MaxBitrate')
        if m.get('RateControlMode') is not None:
            self.rate_control_mode = m.get('RateControlMode')
        return self


class CreateMediaLiveChannelRequestVideoSettingsVideoCodecSetting(TeaModel):
    def __init__(
        self,
        codec_detail: CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingCodecDetail = None,
        framerate: CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingFramerate = None,
        gop: CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingGop = None,
        rate: CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingRate = None,
    ):
        # The video encoding settings.
        self.codec_detail = codec_detail
        # The frame rate. If it is not specified, the source specification is used.
        self.framerate = framerate
        # The GOP setting. If it is not specified, the source specification is used.
        self.gop = gop
        # The video encoding rate. If it is not specified, the source specification is used.
        self.rate = rate

    def validate(self):
        if self.codec_detail:
            self.codec_detail.validate()
        if self.framerate:
            self.framerate.validate()
        if self.gop:
            self.gop.validate()
        if self.rate:
            self.rate.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_detail is not None:
            result['CodecDetail'] = self.codec_detail.to_map()
        if self.framerate is not None:
            result['Framerate'] = self.framerate.to_map()
        if self.gop is not None:
            result['Gop'] = self.gop.to_map()
        if self.rate is not None:
            result['Rate'] = self.rate.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodecDetail') is not None:
            temp_model = CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingCodecDetail()
            self.codec_detail = temp_model.from_map(m['CodecDetail'])
        if m.get('Framerate') is not None:
            temp_model = CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingFramerate()
            self.framerate = temp_model.from_map(m['Framerate'])
        if m.get('Gop') is not None:
            temp_model = CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingGop()
            self.gop = temp_model.from_map(m['Gop'])
        if m.get('Rate') is not None:
            temp_model = CreateMediaLiveChannelRequestVideoSettingsVideoCodecSettingRate()
            self.rate = temp_model.from_map(m['Rate'])
        return self


class CreateMediaLiveChannelRequestVideoSettings(TeaModel):
    def __init__(
        self,
        height: int = None,
        name: str = None,
        video_codec: str = None,
        video_codec_setting: CreateMediaLiveChannelRequestVideoSettingsVideoCodecSetting = None,
        video_codec_type: str = None,
        width: int = None,
    ):
        # The height of the output. If you set it to 0 or leave it empty, the height automatically adapts to the specified width to maintain the original aspect ratio.
        # 
        # Valid values:
        # 
        # *   For regular transcoding, the larger dimension cannot exceed 3840 px, and the smaller one cannot exceed 2160 px.
        # *   For Narrowband HD™ transcoding, the larger dimension cannot exceed 1920 px, and the smaller one cannot exceed 1080 px.
        self.height = height
        # The name of the video settings. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The video codec. Valid values: H264 and H265.
        self.video_codec = video_codec
        # The video encoding settings.
        self.video_codec_setting = video_codec_setting
        # The video transcoding method. Valid values:
        # 
        # *   NORMAL: regular transcoding
        # *   NBHD: Narrowband HD™ transcoding
        # 
        # If not specified, regular transcoding is used by default.
        self.video_codec_type = video_codec_type
        # The width of the output. If you set it to 0 or leave it empty, the width automatically adapts to the specified height to maintain the original aspect ratio.
        # 
        # Valid values:
        # 
        # *   For regular transcoding, the larger dimension cannot exceed 3840 px, and the smaller one cannot exceed 2160 px.
        # *   For Narrowband HD™ transcoding, the larger dimension cannot exceed 1920 px, and the smaller one cannot exceed 1080 px.
        self.width = width

    def validate(self):
        if self.video_codec_setting:
            self.video_codec_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height is not None:
            result['Height'] = self.height
        if self.name is not None:
            result['Name'] = self.name
        if self.video_codec is not None:
            result['VideoCodec'] = self.video_codec
        if self.video_codec_setting is not None:
            result['VideoCodecSetting'] = self.video_codec_setting.to_map()
        if self.video_codec_type is not None:
            result['VideoCodecType'] = self.video_codec_type
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VideoCodec') is not None:
            self.video_codec = m.get('VideoCodec')
        if m.get('VideoCodecSetting') is not None:
            temp_model = CreateMediaLiveChannelRequestVideoSettingsVideoCodecSetting()
            self.video_codec_setting = temp_model.from_map(m['VideoCodecSetting'])
        if m.get('VideoCodecType') is not None:
            self.video_codec_type = m.get('VideoCodecType')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateMediaLiveChannelRequest(TeaModel):
    def __init__(
        self,
        audio_settings: List[CreateMediaLiveChannelRequestAudioSettings] = None,
        input_attachments: List[CreateMediaLiveChannelRequestInputAttachments] = None,
        name: str = None,
        output_groups: List[CreateMediaLiveChannelRequestOutputGroups] = None,
        video_settings: List[CreateMediaLiveChannelRequestVideoSettings] = None,
    ):
        # The audio settings.
        self.audio_settings = audio_settings
        # The associated inputs.
        # 
        # This parameter is required.
        self.input_attachments = input_attachments
        # The name of the channel. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The output groups.
        # 
        # This parameter is required.
        self.output_groups = output_groups
        # The video settings.
        self.video_settings = video_settings

    def validate(self):
        if self.audio_settings:
            for k in self.audio_settings:
                if k:
                    k.validate()
        if self.input_attachments:
            for k in self.input_attachments:
                if k:
                    k.validate()
        if self.output_groups:
            for k in self.output_groups:
                if k:
                    k.validate()
        if self.video_settings:
            for k in self.video_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioSettings'] = []
        if self.audio_settings is not None:
            for k in self.audio_settings:
                result['AudioSettings'].append(k.to_map() if k else None)
        result['InputAttachments'] = []
        if self.input_attachments is not None:
            for k in self.input_attachments:
                result['InputAttachments'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        result['OutputGroups'] = []
        if self.output_groups is not None:
            for k in self.output_groups:
                result['OutputGroups'].append(k.to_map() if k else None)
        result['VideoSettings'] = []
        if self.video_settings is not None:
            for k in self.video_settings:
                result['VideoSettings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_settings = []
        if m.get('AudioSettings') is not None:
            for k in m.get('AudioSettings'):
                temp_model = CreateMediaLiveChannelRequestAudioSettings()
                self.audio_settings.append(temp_model.from_map(k))
        self.input_attachments = []
        if m.get('InputAttachments') is not None:
            for k in m.get('InputAttachments'):
                temp_model = CreateMediaLiveChannelRequestInputAttachments()
                self.input_attachments.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.output_groups = []
        if m.get('OutputGroups') is not None:
            for k in m.get('OutputGroups'):
                temp_model = CreateMediaLiveChannelRequestOutputGroups()
                self.output_groups.append(temp_model.from_map(k))
        self.video_settings = []
        if m.get('VideoSettings') is not None:
            for k in m.get('VideoSettings'):
                temp_model = CreateMediaLiveChannelRequestVideoSettings()
                self.video_settings.append(temp_model.from_map(k))
        return self


class CreateMediaLiveChannelShrinkRequest(TeaModel):
    def __init__(
        self,
        audio_settings_shrink: str = None,
        input_attachments_shrink: str = None,
        name: str = None,
        output_groups_shrink: str = None,
        video_settings_shrink: str = None,
    ):
        # The audio settings.
        self.audio_settings_shrink = audio_settings_shrink
        # The associated inputs.
        # 
        # This parameter is required.
        self.input_attachments_shrink = input_attachments_shrink
        # The name of the channel. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The output groups.
        # 
        # This parameter is required.
        self.output_groups_shrink = output_groups_shrink
        # The video settings.
        self.video_settings_shrink = video_settings_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_settings_shrink is not None:
            result['AudioSettings'] = self.audio_settings_shrink
        if self.input_attachments_shrink is not None:
            result['InputAttachments'] = self.input_attachments_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.output_groups_shrink is not None:
            result['OutputGroups'] = self.output_groups_shrink
        if self.video_settings_shrink is not None:
            result['VideoSettings'] = self.video_settings_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioSettings') is not None:
            self.audio_settings_shrink = m.get('AudioSettings')
        if m.get('InputAttachments') is not None:
            self.input_attachments_shrink = m.get('InputAttachments')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputGroups') is not None:
            self.output_groups_shrink = m.get('OutputGroups')
        if m.get('VideoSettings') is not None:
            self.video_settings_shrink = m.get('VideoSettings')
        return self


class CreateMediaLiveChannelResponseBody(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the channel.
        self.channel_id = channel_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMediaLiveChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMediaLiveChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMediaLiveChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMediaLiveInputRequestInputSettings(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        flow_output_name: str = None,
        source_url: str = None,
        srt_latency: int = None,
        srt_max_bitrate: int = None,
        srt_passphrase: str = None,
        srt_pb_key_len: int = None,
        stream_name: str = None,
    ):
        # The ID of the flow from MediaConnect. This parameter is required when Type is set to MEDIA_CONNECT.
        self.flow_id = flow_id
        # The output name of the MediaConnect flow. This parameter is required when Type is set to MEDIA_CONNECT.
        self.flow_output_name = flow_output_name
        # The source URL from which the stream is pulled. This parameter is required for PULL inputs.
        self.source_url = source_url
        self.srt_latency = srt_latency
        self.srt_max_bitrate = srt_max_bitrate
        self.srt_passphrase = srt_passphrase
        self.srt_pb_key_len = srt_pb_key_len
        # The name of the pushed stream. This parameter is required for PUSH inputs. It can be up to 255 characters in length.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_output_name is not None:
            result['FlowOutputName'] = self.flow_output_name
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.srt_latency is not None:
            result['SrtLatency'] = self.srt_latency
        if self.srt_max_bitrate is not None:
            result['SrtMaxBitrate'] = self.srt_max_bitrate
        if self.srt_passphrase is not None:
            result['SrtPassphrase'] = self.srt_passphrase
        if self.srt_pb_key_len is not None:
            result['SrtPbKeyLen'] = self.srt_pb_key_len
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowOutputName') is not None:
            self.flow_output_name = m.get('FlowOutputName')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('SrtLatency') is not None:
            self.srt_latency = m.get('SrtLatency')
        if m.get('SrtMaxBitrate') is not None:
            self.srt_max_bitrate = m.get('SrtMaxBitrate')
        if m.get('SrtPassphrase') is not None:
            self.srt_passphrase = m.get('SrtPassphrase')
        if m.get('SrtPbKeyLen') is not None:
            self.srt_pb_key_len = m.get('SrtPbKeyLen')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class CreateMediaLiveInputRequest(TeaModel):
    def __init__(
        self,
        input_settings: List[CreateMediaLiveInputRequestInputSettings] = None,
        name: str = None,
        security_group_ids: List[str] = None,
        type: str = None,
    ):
        # The input settings. An input can have up to two sources: primary and backup sources.
        # 
        # This parameter is required.
        self.input_settings = input_settings
        # The name of the input. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The IDs of the security groups to be associated with the input. This parameter is required for PUSH inputs.
        self.security_group_ids = security_group_ids
        # The input type. Valid values: RTMP_PUSH, RTMP_PULL, SRT_PUSH, SRT_PULL, and MEDIA_CONNECT.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.input_settings:
            for k in self.input_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InputSettings'] = []
        if self.input_settings is not None:
            for k in self.input_settings:
                result['InputSettings'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.input_settings = []
        if m.get('InputSettings') is not None:
            for k in m.get('InputSettings'):
                temp_model = CreateMediaLiveInputRequestInputSettings()
                self.input_settings.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateMediaLiveInputShrinkRequest(TeaModel):
    def __init__(
        self,
        input_settings_shrink: str = None,
        name: str = None,
        security_group_ids_shrink: str = None,
        type: str = None,
    ):
        # The input settings. An input can have up to two sources: primary and backup sources.
        # 
        # This parameter is required.
        self.input_settings_shrink = input_settings_shrink
        # The name of the input. Letters, digits, hyphens (-), and underscores (_) are supported. It can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The IDs of the security groups to be associated with the input. This parameter is required for PUSH inputs.
        self.security_group_ids_shrink = security_group_ids_shrink
        # The input type. Valid values: RTMP_PUSH, RTMP_PULL, SRT_PUSH, SRT_PULL, and MEDIA_CONNECT.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_settings_shrink is not None:
            result['InputSettings'] = self.input_settings_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.security_group_ids_shrink is not None:
            result['SecurityGroupIds'] = self.security_group_ids_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputSettings') is not None:
            self.input_settings_shrink = m.get('InputSettings')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids_shrink = m.get('SecurityGroupIds')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateMediaLiveInputResponseBody(TeaModel):
    def __init__(
        self,
        input_id: str = None,
        request_id: str = None,
    ):
        # The ID of the input.
        self.input_id = input_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_id is not None:
            result['InputId'] = self.input_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputId') is not None:
            self.input_id = m.get('InputId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMediaLiveInputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMediaLiveInputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMediaLiveInputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMediaLiveInputSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        whitelist_rules: List[str] = None,
    ):
        # The name of the security group. Letters, digits, hyphens (-), and underscores (_) are supported. The maximum length is 64 characters.
        # 
        # This parameter is required.
        self.name = name
        # The security group rules.
        # 
        # This parameter is required.
        self.whitelist_rules = whitelist_rules

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.whitelist_rules is not None:
            result['WhitelistRules'] = self.whitelist_rules
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('WhitelistRules') is not None:
            self.whitelist_rules = m.get('WhitelistRules')
        return self


class CreateMediaLiveInputSecurityGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        whitelist_rules_shrink: str = None,
    ):
        # The name of the security group. Letters, digits, hyphens (-), and underscores (_) are supported. The maximum length is 64 characters.
        # 
        # This parameter is required.
        self.name = name
        # The security group rules.
        # 
        # This parameter is required.
        self.whitelist_rules_shrink = whitelist_rules_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.whitelist_rules_shrink is not None:
            result['WhitelistRules'] = self.whitelist_rules_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('WhitelistRules') is not None:
            self.whitelist_rules_shrink = m.get('WhitelistRules')
        return self


class CreateMediaLiveInputSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_group_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the security group.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class CreateMediaLiveInputSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMediaLiveInputSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMediaLiveInputSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        priority: int = None,
        speed: str = None,
    ):
        # The name of the MPS queue.
        # 
        # This parameter is required.
        self.name = name
        # The priority. Default value: 6. Valid values: 1 to 10. A greater value specifies a higher priority.
        self.priority = priority
        # The type of the MPS queue. Valid values:
        # 
        # 1.  Standard: standard MPS queue.
        # 2.  Boost: MPS queue with transcoding speed boosted.
        # 3.  NarrowBandHDV2: MPS queue that supports Narrowband HD 2.0.
        # 
        # This parameter is required.
        self.speed = speed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        return self


class CreatePipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modified_time: str = None,
        name: str = None,
        pipeline_id: str = None,
        priority: int = None,
        speed: str = None,
        status: str = None,
    ):
        # The time when the template was created.
        self.create_time = create_time
        # The time when the template was last modified.
        self.modified_time = modified_time
        # The name of the MPS queue.
        self.name = name
        # The ID of the MPS queue.
        self.pipeline_id = pipeline_id
        # The priority of the MPS queue.
        self.priority = priority
        # The type of the MPS queue.
        # 
        # Valid values:
        # 
        # *   Boost: MPS queue with transcoding speed boosted.
        # *   Standard: standard MPS queue.
        # *   NarrowBandHDV2: MPS queue that supports Narrowband HD 2.0.
        self.speed = speed
        # The state of the MPS queue.
        # 
        # Valid values:
        # 
        # *   Active
        # *   Paused
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreatePipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: CreatePipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        # The information about the MPS queue.
        self.pipeline = pipeline
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = CreatePipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProgramRequest(TeaModel):
    def __init__(
        self,
        ad_breaks: str = None,
        channel_name: str = None,
        clip_range: str = None,
        program_name: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
        transition: str = None,
    ):
        # The information about ad breaks.
        self.ad_breaks = ad_breaks
        # The name of the channel.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # Extracts a clip from the source.
        self.clip_range = clip_range
        # The name of the program.
        # 
        # This parameter is required.
        self.program_name = program_name
        # The source location.
        # 
        # This parameter is required.
        self.source_location_name = source_location_name
        # The name of the source.
        # 
        # This parameter is required.
        self.source_name = source_name
        # The source type of the program.
        # 
        # This parameter is required.
        self.source_type = source_type
        # The program transition method.
        # 
        # This parameter is required.
        self.transition = transition

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_breaks is not None:
            result['AdBreaks'] = self.ad_breaks
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.clip_range is not None:
            result['ClipRange'] = self.clip_range
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.transition is not None:
            result['Transition'] = self.transition
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdBreaks') is not None:
            self.ad_breaks = m.get('AdBreaks')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ClipRange') is not None:
            self.clip_range = m.get('ClipRange')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        return self


class CreateProgramResponseBody(TeaModel):
    def __init__(
        self,
        program: ChannelAssemblyProgram = None,
        request_id: str = None,
    ):
        # The information about the program.
        self.program = program
        # **Request ID**\
        self.request_id = request_id

    def validate(self):
        if self.program:
            self.program.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program is not None:
            result['Program'] = self.program.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Program') is not None:
            temp_model = ChannelAssemblyProgram()
            self.program = temp_model.from_map(m['Program'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProgramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRecognitionEntityRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        entity_info: str = None,
        entity_name: str = None,
        lib_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        self.entity_info = entity_info
        # This parameter is required.
        self.entity_name = entity_name
        # This parameter is required.
        self.lib_id = lib_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.entity_info is not None:
            result['EntityInfo'] = self.entity_info
        if self.entity_name is not None:
            result['EntityName'] = self.entity_name
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('EntityInfo') is not None:
            self.entity_info = m.get('EntityInfo')
        if m.get('EntityName') is not None:
            self.entity_name = m.get('EntityName')
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateRecognitionEntityResponseBody(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        request_id: str = None,
    ):
        self.entity_id = entity_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRecognitionEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRecognitionEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRecognitionEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRecognitionLibRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        lib_description: str = None,
        lib_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        self.lib_description = lib_description
        # This parameter is required.
        self.lib_name = lib_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.lib_description is not None:
            result['LibDescription'] = self.lib_description
        if self.lib_name is not None:
            result['LibName'] = self.lib_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('LibDescription') is not None:
            self.lib_description = m.get('LibDescription')
        if m.get('LibName') is not None:
            self.lib_name = m.get('LibName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateRecognitionLibResponseBody(TeaModel):
    def __init__(
        self,
        lib_id: str = None,
        request_id: str = None,
    ):
        self.lib_id = lib_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRecognitionLibResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRecognitionLibResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRecognitionLibResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRecognitionSampleRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        entity_id: str = None,
        image_url: str = None,
        label_prompt: str = None,
        lib_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        # This parameter is required.
        self.entity_id = entity_id
        self.image_url = image_url
        self.label_prompt = label_prompt
        # This parameter is required.
        self.lib_id = lib_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.label_prompt is not None:
            result['LabelPrompt'] = self.label_prompt
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('LabelPrompt') is not None:
            self.label_prompt = m.get('LabelPrompt')
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateRecognitionSampleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sample_id: str = None,
    ):
        self.request_id = request_id
        self.sample_id = sample_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sample_id is not None:
            result['SampleId'] = self.sample_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SampleId') is not None:
            self.sample_id = m.get('SampleId')
        return self


class CreateRecognitionSampleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRecognitionSampleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRecognitionSampleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSearchIndexRequest(TeaModel):
    def __init__(
        self,
        index_config: str = None,
        index_status: str = None,
        index_type: str = None,
        search_lib_name: str = None,
    ):
        self.index_config = index_config
        self.index_status = index_status
        # The category of the index. Valid values:
        # 
        # *   mm: large visual model. You can use this model to describe complex visual features and identify and search for specific actions, movements, and events in videos, such as when athletes score a goal or get injured.
        # 
        # >  This feature is in the public preview phase. You can use this feature for free for 1,000 hours of videos.
        # 
        # *   face: face recognition. You can use the face recognition technology to describe face characteristics and automatically mark or search for faces in videos.
        # *   aiLabel: smart tagging. The smart tagging category is used to describe content such as subtitles and audio in videos. You can use the speech recognition technology to automatically extract, mark, and search for subtitles and dialog content from videos. This helps you quickly locate the video content that is related to specific topics or keywords.
        # 
        # This parameter is required.
        self.index_type = index_type
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_config is not None:
            result['IndexConfig'] = self.index_config
        if self.index_status is not None:
            result['IndexStatus'] = self.index_status
        if self.index_type is not None:
            result['IndexType'] = self.index_type
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IndexConfig') is not None:
            self.index_config = m.get('IndexConfig')
        if m.get('IndexStatus') is not None:
            self.index_status = m.get('IndexStatus')
        if m.get('IndexType') is not None:
            self.index_type = m.get('IndexType')
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class CreateSearchIndexResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSearchIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSearchIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSearchIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSearchLibRequest(TeaModel):
    def __init__(
        self,
        search_lib_name: str = None,
    ):
        # The name of the search library. The name can contain letters and digits and must start with a letter.
        # 
        # This parameter is required.
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class CreateSearchLibResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
        search_lib_name: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the request.
        self.request_id = request_id
        # The name of the search library.
        self.search_lib_name = search_lib_name
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSearchLibResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSearchLibResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSearchLibResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSourceRequest(TeaModel):
    def __init__(
        self,
        http_package_configurations: str = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
    ):
        # The source configurations.
        # 
        # This parameter is required.
        self.http_package_configurations = http_package_configurations
        # The name of the source location.
        # 
        # This parameter is required.
        self.source_location_name = source_location_name
        # The name of the source.
        # 
        # This parameter is required.
        self.source_name = source_name
        # The source type. Valid values: vodSource and liveSource.
        # 
        # This parameter is required.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_package_configurations is not None:
            result['HttpPackageConfigurations'] = self.http_package_configurations
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpPackageConfigurations') is not None:
            self.http_package_configurations = m.get('HttpPackageConfigurations')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class CreateSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        source: ChannelAssemblySource = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # The source information.
        self.source = source

    def validate(self):
        if self.source:
            self.source.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            temp_model = ChannelAssemblySource()
            self.source = temp_model.from_map(m['Source'])
        return self


class CreateSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSourceLocationRequest(TeaModel):
    def __init__(
        self,
        base_url: str = None,
        enable_segment_delivery: bool = None,
        segment_delivery_url: str = None,
        source_location_name: str = None,
    ):
        # The protocol and hostname of the source location.
        # 
        # This parameter is required.
        self.base_url = base_url
        # Specifies whether to use an independent domain name to access the segments.
        self.enable_segment_delivery = enable_segment_delivery
        # The domain name used to access the segments.
        self.segment_delivery_url = segment_delivery_url
        # The name of the source location.
        # 
        # This parameter is required.
        self.source_location_name = source_location_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_url is not None:
            result['BaseUrl'] = self.base_url
        if self.enable_segment_delivery is not None:
            result['EnableSegmentDelivery'] = self.enable_segment_delivery
        if self.segment_delivery_url is not None:
            result['SegmentDeliveryUrl'] = self.segment_delivery_url
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseUrl') is not None:
            self.base_url = m.get('BaseUrl')
        if m.get('EnableSegmentDelivery') is not None:
            self.enable_segment_delivery = m.get('EnableSegmentDelivery')
        if m.get('SegmentDeliveryUrl') is not None:
            self.segment_delivery_url = m.get('SegmentDeliveryUrl')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        return self


class CreateSourceLocationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        source_location: ChannelAssemblySourceLocation = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # The source location information.
        self.source_location = source_location

    def validate(self):
        if self.source_location:
            self.source_location.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SourceLocation') is not None:
            temp_model = ChannelAssemblySourceLocation()
            self.source_location = temp_model.from_map(m['SourceLocation'])
        return self


class CreateSourceLocationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSourceLocationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSourceLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadMediaRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        entity_id: str = None,
        file_info: str = None,
        media_meta_data: str = None,
        post_process_config: str = None,
        upload_target_config: str = None,
        user_data: str = None,
    ):
        # The application ID. Default value: app-1000000.
        self.app_id = app_id
        # The entity ID. You can call the CreateEntity operation to create an entity and specify a dynamic metadata structure.
        self.entity_id = entity_id
        # The file information, which is in the JSON format and contains the following fields:
        # 
        # *   Type: required. The file type. Valid values: video, image, audio, text, and other.
        # *   Name: required. The file name without the extension.
        # *   Size: optional. The file size.
        # *   Ext: required. The file name extension.
        self.file_info = file_info
        # The metadata of the media asset, which is a JSON string that contains the following fields:
        # 
        # Title: required.
        # 
        # *   The value can be up to 128 characters in length.
        # *   The value must be encoded in UTF-8.
        # 
        # Description: optional.
        # 
        # *   The value can be up to 1,024 characters in length.
        # *   The value must be encoded in UTF-8.
        # 
        # CateId: optional.
        # 
        # Tags: optional.
        # 
        # BusinessType: required. Valid values:
        # 
        # *   opening or ending if Type is set to video
        # *   default or cover if Type is set to image
        # *   subtitles or font if Type is set to text
        # *   watermark if Type is set to material
        # *   general CoverURL: optional.
        # 
        # DynamicMetaData: The value is a string.
        self.media_meta_data = media_meta_data
        # The postprocessing configurations. You can specify this parameter if Type is set to video or audio.
        # 
        # Set ProcessType to Workflow.
        self.post_process_config = post_process_config
        # The destination storage address.
        # 
        # Set StorageType to oss.
        # 
        # Set StorageLocation to an address in ApsaraVideo VOD. You cannot set this field to an OSS URL.
        self.upload_target_config = upload_target_config
        # The user data. The value must be a JSON string. You can configure settings such as message callbacks.
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.file_info is not None:
            result['FileInfo'] = self.file_info
        if self.media_meta_data is not None:
            result['MediaMetaData'] = self.media_meta_data
        if self.post_process_config is not None:
            result['PostProcessConfig'] = self.post_process_config
        if self.upload_target_config is not None:
            result['UploadTargetConfig'] = self.upload_target_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('FileInfo') is not None:
            self.file_info = m.get('FileInfo')
        if m.get('MediaMetaData') is not None:
            self.media_meta_data = m.get('MediaMetaData')
        if m.get('PostProcessConfig') is not None:
            self.post_process_config = m.get('PostProcessConfig')
        if m.get('UploadTargetConfig') is not None:
            self.upload_target_config = m.get('UploadTargetConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadMediaResponseBody(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_url: str = None,
        request_id: str = None,
        upload_address: str = None,
        upload_auth: str = None,
    ):
        # The OSS URL of the file. The URL does not contain the information used for authentication.
        self.file_url = file_url
        # The ID of the media asset.
        self.media_id = media_id
        # The URL of the media asset.
        # 
        # >  If a domain name for Alibaba Cloud CDN (CDN) is specified, a CDN URL is returned. Otherwise, an OSS URL is returned. If the HTTP status code 403 is returned when you access the URL from your browser, the URL authentication feature of ApsaraVideo VOD is enabled. To resolve this issue, disable URL authentication or generate an authentication signature.
        self.media_url = media_url
        # The request ID.
        self.request_id = request_id
        # The upload URL.
        # 
        # >  The returned upload URL is a Base64-encoded URL. You must decode the Base64-encoded upload URL before you use an SDK or call an API operation to upload media files. You need to parse UploadAddress only if you use OSS SDK or call an OSS API operation to upload media files.
        self.upload_address = upload_address
        # The upload credential.
        # 
        # >  The returned upload credential is a Base64-encoded value. You must decode the Base64-encoded upload URL before you use an SDK or call an API operation to upload media files. You need to parse UploadAuth only if you use OSS SDK or call an OSS API operation to upload media files.
        self.upload_auth = upload_auth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUploadMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadStreamRequest(TeaModel):
    def __init__(
        self,
        definition: str = None,
        file_extension: str = None,
        hdrtype: str = None,
        media_id: str = None,
        user_data: str = None,
    ):
        # The quality of the media stream. Valid values:
        # 
        # *   FD: low definition.
        # *   LD: standard definition.
        # *   SD: high definition.
        # *   HD: ultra-high definition.
        # *   OD: original quality.
        # *   2K: 2K resolution.
        # *   4K: 4K resolution.
        # *   SQ: standard sound quality.
        # *   HQ: high sound quality.
        self.definition = definition
        # The file name extension of the media stream.
        self.file_extension = file_extension
        # The high dynamic range (HDR) format of the transcoded stream. Valid values:
        # 
        # *   HDR
        # *   HDR10
        # *   HLG
        # *   DolbyVision
        # *   HDRVivid
        # *   SDR+\
        # 
        # > 
        # 
        # *   The value is not case-sensitive,
        # 
        # *   You can leave this parameter empty for non-HDR streams.
        self.hdrtype = hdrtype
        # The ID of the media asset.
        self.media_id = media_id
        # The user data.
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.file_extension is not None:
            result['FileExtension'] = self.file_extension
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('FileExtension') is not None:
            self.file_extension = m.get('FileExtension')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadStreamResponseBody(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        request_id: str = None,
        upload_address: str = None,
        upload_auth: str = None,
    ):
        # The Object Storage Service (OSS) URL of the file. The URL does not contain the information used for authentication.
        self.file_url = file_url
        # The ID of the media asset.
        self.media_id = media_id
        # The request ID.
        self.request_id = request_id
        # The upload URL.
        # 
        # >  The returned upload URL is a Base64-encoded URL. You must decode the Base64-encoded upload URL before you use an SDK or call an API operation to upload media files. You need to parse UploadAddress only if you use OSS SDK or call an OSS API operation to upload media files.
        self.upload_address = upload_address
        # The upload credential.
        # 
        # >  The returned upload credential is a Base64-encoded value. You must decode the Base64-encoded upload URL before you use an SDK or call an API operation to upload media files. You need to parse UploadAuth only if you use OSS SDK or call an OSS API operation to upload media files.
        self.upload_auth = upload_auth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUploadStreamResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVodPackagingAssetRequestInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # The URL of the media file. Only M3U8 files stored in OSS are supported.
        self.media = media
        # The input type. Only Object Storage Service (OSS) is supported.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateVodPackagingAssetRequest(TeaModel):
    def __init__(
        self,
        asset_name: str = None,
        content_id: str = None,
        description: str = None,
        group_name: str = None,
        input: CreateVodPackagingAssetRequestInput = None,
    ):
        # The name of the asset. The name must be unique and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.asset_name = asset_name
        # The content ID in the digital rights management (DRM) system. The maximum length is 256 characters. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.content_id = content_id
        # The asset description.
        self.description = description
        # The name of the packaging group.
        self.group_name = group_name
        # The asset input configurations.
        self.input = input

    def validate(self):
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_name is not None:
            result['AssetName'] = self.asset_name
        if self.content_id is not None:
            result['ContentId'] = self.content_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetName') is not None:
            self.asset_name = m.get('AssetName')
        if m.get('ContentId') is not None:
            self.content_id = m.get('ContentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Input') is not None:
            temp_model = CreateVodPackagingAssetRequestInput()
            self.input = temp_model.from_map(m['Input'])
        return self


class CreateVodPackagingAssetShrinkRequest(TeaModel):
    def __init__(
        self,
        asset_name: str = None,
        content_id: str = None,
        description: str = None,
        group_name: str = None,
        input_shrink: str = None,
    ):
        # The name of the asset. The name must be unique and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.asset_name = asset_name
        # The content ID in the digital rights management (DRM) system. The maximum length is 256 characters. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.content_id = content_id
        # The asset description.
        self.description = description
        # The name of the packaging group.
        self.group_name = group_name
        # The asset input configurations.
        self.input_shrink = input_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_name is not None:
            result['AssetName'] = self.asset_name
        if self.content_id is not None:
            result['ContentId'] = self.content_id
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.input_shrink is not None:
            result['Input'] = self.input_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetName') is not None:
            self.asset_name = m.get('AssetName')
        if m.get('ContentId') is not None:
            self.content_id = m.get('ContentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Input') is not None:
            self.input_shrink = m.get('Input')
        return self


class CreateVodPackagingAssetResponseBody(TeaModel):
    def __init__(
        self,
        asset: VodPackagingAsset = None,
        request_id: str = None,
    ):
        # The information about the asset.
        self.asset = asset
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.asset:
            self.asset.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset is not None:
            result['Asset'] = self.asset.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asset') is not None:
            temp_model = VodPackagingAsset()
            self.asset = temp_model.from_map(m['Asset'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVodPackagingAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVodPackagingAssetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVodPackagingAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVodPackagingConfigurationRequestPackageConfigDrmProvider(TeaModel):
    def __init__(
        self,
        encryption_method: str = None,
        iv: str = None,
        system_ids: List[str] = None,
        url: str = None,
    ):
        # The encryption method. Valid values:
        # 
        # *   AES_128: Advanced Encryption Standard (AES) with 128-bit key length.
        # *   SAMPLE_AES: an encryption method that encrypts individual media samples.
        self.encryption_method = encryption_method
        # A 128-bit, 16-byte hex value represented by a 32-character string that is used with the key for encrypting data blocks. If you leave this parameter empty, MediaPackage creates a constant initialization vector (IV). If it is specified, the value is passed to the DRM service.
        self.iv = iv
        # The ID of the DRM system. The maximum number of system IDs allowed is determined by the protocol type. Limits:
        # 
        # *   DASH: 2
        # *   HLS: 1
        # *   HLS_CMAF: 2
        # 
        # Apple FairPlay, Google Widevine, and Microsoft PlayReady are supported. Their system IDs are as follows:
        # 
        # *   Apple FairPlay: 94ce86fb-07ff-4f43-adb8-93d2fa968ca2
        # *   Google Widevine: edef8ba9-79d6-4ace-a3c8-27dcd51d21e
        # *   Microsoft PlayReady: 9a04f079-9840-4286-ab92-e65be0885f95
        self.system_ids = system_ids
        # The URL of the DRM key provider.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.encryption_method is not None:
            result['EncryptionMethod'] = self.encryption_method
        if self.iv is not None:
            result['IV'] = self.iv
        if self.system_ids is not None:
            result['SystemIds'] = self.system_ids
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EncryptionMethod') is not None:
            self.encryption_method = m.get('EncryptionMethod')
        if m.get('IV') is not None:
            self.iv = m.get('IV')
        if m.get('SystemIds') is not None:
            self.system_ids = m.get('SystemIds')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateVodPackagingConfigurationRequestPackageConfigStreamSelection(TeaModel):
    def __init__(
        self,
        max_video_bits_per_second: int = None,
        min_video_bits_per_second: int = None,
        stream_order: str = None,
    ):
        # The maximum bitrate of the video stream. Unit: bit/s.
        self.max_video_bits_per_second = max_video_bits_per_second
        # The minimum bitrate of the video stream. Unit: bit/s.
        self.min_video_bits_per_second = min_video_bits_per_second
        # The order of manifest files in the master playlist. Valid values:
        # 
        # *   ORIGINAL: sorts the manifest files in the same order as the source.
        # *   VIDEO_BITRATE_ASCENDING: sorts the manifest files in ascending order of bitrates, from lowest to highest.
        # *   VIDEO_BITRATE_DESCENDING: sorts the manifest files in descending order of bitrates, from highest to lowest.
        self.stream_order = stream_order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_video_bits_per_second is not None:
            result['MaxVideoBitsPerSecond'] = self.max_video_bits_per_second
        if self.min_video_bits_per_second is not None:
            result['MinVideoBitsPerSecond'] = self.min_video_bits_per_second
        if self.stream_order is not None:
            result['StreamOrder'] = self.stream_order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxVideoBitsPerSecond') is not None:
            self.max_video_bits_per_second = m.get('MaxVideoBitsPerSecond')
        if m.get('MinVideoBitsPerSecond') is not None:
            self.min_video_bits_per_second = m.get('MinVideoBitsPerSecond')
        if m.get('StreamOrder') is not None:
            self.stream_order = m.get('StreamOrder')
        return self


class CreateVodPackagingConfigurationRequestPackageConfig(TeaModel):
    def __init__(
        self,
        drm_provider: CreateVodPackagingConfigurationRequestPackageConfigDrmProvider = None,
        manifest_name: str = None,
        segment_duration: int = None,
        stream_selection: CreateVodPackagingConfigurationRequestPackageConfigStreamSelection = None,
    ):
        # The settings of digital rights management (DRM) encryption.
        self.drm_provider = drm_provider
        # The manifest name. The name can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.manifest_name = manifest_name
        # The duration of each segment in a packaged stream. Unit: seconds. MediaPackage rounds segments to the nearest multiple of the input segment duration. Valid values: 1 to 30.
        self.segment_duration = segment_duration
        # The settings of stream selection.
        self.stream_selection = stream_selection

    def validate(self):
        if self.drm_provider:
            self.drm_provider.validate()
        if self.stream_selection:
            self.stream_selection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drm_provider is not None:
            result['DrmProvider'] = self.drm_provider.to_map()
        if self.manifest_name is not None:
            result['ManifestName'] = self.manifest_name
        if self.segment_duration is not None:
            result['SegmentDuration'] = self.segment_duration
        if self.stream_selection is not None:
            result['StreamSelection'] = self.stream_selection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DrmProvider') is not None:
            temp_model = CreateVodPackagingConfigurationRequestPackageConfigDrmProvider()
            self.drm_provider = temp_model.from_map(m['DrmProvider'])
        if m.get('ManifestName') is not None:
            self.manifest_name = m.get('ManifestName')
        if m.get('SegmentDuration') is not None:
            self.segment_duration = m.get('SegmentDuration')
        if m.get('StreamSelection') is not None:
            temp_model = CreateVodPackagingConfigurationRequestPackageConfigStreamSelection()
            self.stream_selection = temp_model.from_map(m['StreamSelection'])
        return self


class CreateVodPackagingConfigurationRequest(TeaModel):
    def __init__(
        self,
        configuration_name: str = None,
        description: str = None,
        group_name: str = None,
        package_config: CreateVodPackagingConfigurationRequestPackageConfig = None,
        protocol: str = None,
    ):
        # The name of the packaging configuration. The name must be unique in an account and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.configuration_name = configuration_name
        # The description of the packaging configuration.
        self.description = description
        # The name of the packaging group. The name can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.group_name = group_name
        # The packaging configuration.
        self.package_config = package_config
        # The package type.
        # 
        # *   HLS: packages content into TS segments for delivery over the HLS protocol.
        # *   HLS_CMAF: packages content into CMAF segments for delivery over the HLS protocol.
        # *   DASH: packages content for delivery over the DASH protocol.
        self.protocol = protocol

    def validate(self):
        if self.package_config:
            self.package_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_name is not None:
            result['ConfigurationName'] = self.configuration_name
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.package_config is not None:
            result['PackageConfig'] = self.package_config.to_map()
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationName') is not None:
            self.configuration_name = m.get('ConfigurationName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('PackageConfig') is not None:
            temp_model = CreateVodPackagingConfigurationRequestPackageConfig()
            self.package_config = temp_model.from_map(m['PackageConfig'])
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateVodPackagingConfigurationShrinkRequest(TeaModel):
    def __init__(
        self,
        configuration_name: str = None,
        description: str = None,
        group_name: str = None,
        package_config_shrink: str = None,
        protocol: str = None,
    ):
        # The name of the packaging configuration. The name must be unique in an account and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.configuration_name = configuration_name
        # The description of the packaging configuration.
        self.description = description
        # The name of the packaging group. The name can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.group_name = group_name
        # The packaging configuration.
        self.package_config_shrink = package_config_shrink
        # The package type.
        # 
        # *   HLS: packages content into TS segments for delivery over the HLS protocol.
        # *   HLS_CMAF: packages content into CMAF segments for delivery over the HLS protocol.
        # *   DASH: packages content for delivery over the DASH protocol.
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_name is not None:
            result['ConfigurationName'] = self.configuration_name
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.package_config_shrink is not None:
            result['PackageConfig'] = self.package_config_shrink
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationName') is not None:
            self.configuration_name = m.get('ConfigurationName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('PackageConfig') is not None:
            self.package_config_shrink = m.get('PackageConfig')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateVodPackagingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        packaging_configuration: VodPackagingConfiguration = None,
        request_id: str = None,
    ):
        # The packaging configuration.
        self.packaging_configuration = packaging_configuration
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.packaging_configuration:
            self.packaging_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.packaging_configuration is not None:
            result['PackagingConfiguration'] = self.packaging_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackagingConfiguration') is not None:
            temp_model = VodPackagingConfiguration()
            self.packaging_configuration = temp_model.from_map(m['PackagingConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVodPackagingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVodPackagingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVodPackagingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVodPackagingGroupRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        group_name: str = None,
    ):
        # The packaging group description.
        self.description = description
        # The name of the packaging group. The name must be unique in an account and can be up to 128 characters in length. Letters, digits, underscores (_), and hyphens (-) are supported.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateVodPackagingGroupResponseBody(TeaModel):
    def __init__(
        self,
        packaging_group: VodPackagingGroup = None,
        request_id: str = None,
    ):
        # The packaging group information.
        self.packaging_group = packaging_group
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.packaging_group:
            self.packaging_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.packaging_group is not None:
            result['PackagingGroup'] = self.packaging_group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackagingGroup') is not None:
            temp_model = VodPackagingGroup()
            self.packaging_group = temp_model.from_map(m['PackagingGroup'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVodPackagingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVodPackagingGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVodPackagingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecryptKMSDataKeyRequest(TeaModel):
    def __init__(
        self,
        ciphertext_blob: str = None,
    ):
        # The ciphertext that you want to decrypt.
        # 
        # This parameter is required.
        self.ciphertext_blob = ciphertext_blob

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphertext_blob is not None:
            result['CiphertextBlob'] = self.ciphertext_blob
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CiphertextBlob') is not None:
            self.ciphertext_blob = m.get('CiphertextBlob')
        return self


class DecryptKMSDataKeyResponseBodyDataKey(TeaModel):
    def __init__(
        self,
        key_id: str = None,
        plaintext: str = None,
    ):
        # The ID of the customer master key (CMK) that was used to decrypt the ciphertext.
        self.key_id = key_id
        # The plaintext that is generated after decryption.
        self.plaintext = plaintext

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        return self


class DecryptKMSDataKeyResponseBody(TeaModel):
    def __init__(
        self,
        data_key: DecryptKMSDataKeyResponseBodyDataKey = None,
        request_id: str = None,
    ):
        # The information about the decryption result.
        self.data_key = data_key
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data_key:
            self.data_key.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_key is not None:
            result['DataKey'] = self.data_key.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataKey') is not None:
            temp_model = DecryptKMSDataKeyResponseBodyDataKey()
            self.data_key = temp_model.from_map(m['DataKey'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DecryptKMSDataKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DecryptKMSDataKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DecryptKMSDataKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAIAgentDialogueRequest(TeaModel):
    def __init__(
        self,
        dialogue_id: str = None,
        node_id: str = None,
        session_id: str = None,
    ):
        # This parameter is required.
        self.dialogue_id = dialogue_id
        self.node_id = node_id
        # This parameter is required.
        self.session_id = session_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dialogue_id is not None:
            result['DialogueId'] = self.dialogue_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DialogueId') is not None:
            self.dialogue_id = m.get('DialogueId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        return self


class DeleteAIAgentDialogueResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAIAgentDialogueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAIAgentDialogueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAIAgentDialogueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAdInsertionRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the configuration that you want to delete.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteAdInsertionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAdInsertionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAdInsertionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAdInsertionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAvatarTrainingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the digital human training job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteAvatarTrainingJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the digital human training job.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteAvatarTrainingJobResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteAvatarTrainingJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteAvatarTrainingJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAvatarTrainingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAvatarTrainingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAvatarTrainingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
    ):
        # The category ID. You can use one of the following methods to obtain the ID:
        # 
        # *   Log on to the [Intelligent Media Services (IMS) console](https://ims.console.aliyun.com) and choose **Media Asset Management** > **Category Management** to view the category ID.
        # *   View the value of CateId returned by the AddCategory operation that you called to create a category.
        # *   View the value of CateId returned by the GetCategories operation that you called to query a category.
        # 
        # This parameter is required.
        self.cate_id = cate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        return self


class DeleteCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteChannelRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
    ):
        # The name of the channel.
        # 
        # This parameter is required.
        self.channel_name = channel_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        return self


class DeleteChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # The ID of the custom template.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomizedVoiceJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the human voice cloning job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteCustomizedVoiceJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomizedVoiceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomizedVoiceJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomizedVoiceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDNADBRequest(TeaModel):
    def __init__(
        self,
        dbid: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The ID of the media fingerprint library that you want to delete.
        # 
        # This parameter is required.
        self.dbid = dbid
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbid is not None:
            result['DBId'] = self.dbid
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBId') is not None:
            self.dbid = m.get('DBId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDNADBResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDNADBResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDNADBResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDNADBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDNAFilesRequest(TeaModel):
    def __init__(
        self,
        dbid: str = None,
        owner_account: str = None,
        owner_id: int = None,
        primary_keys: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The ID of the media fingerprint library from which you want to delete files.
        # 
        # This parameter is required.
        self.dbid = dbid
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The primary key values of the files that you want to delete. Separate multiple values with commas (,). You can delete up to 50 files at a time.
        # 
        # This parameter is required.
        self.primary_keys = primary_keys
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbid is not None:
            result['DBId'] = self.dbid
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBId') is not None:
            self.dbid = m.get('DBId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDNAFilesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDNAFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDNAFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDNAFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        material_ids: str = None,
        material_type: str = None,
        project_id: str = None,
    ):
        # The material ID. Separate multiple material IDs with commas (,). You can specify up to 10 IDs.
        # 
        # This parameter is required.
        self.material_ids = material_ids
        # The material type. Valid values:
        # 
        # \\- video
        # 
        # \\- image
        # 
        # \\- audio
        # 
        # \\- subtitle
        # 
        # \\- text
        # 
        # This parameter is required.
        self.material_type = material_type
        # The ID of the online editing project.
        # 
        # This parameter is required.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_ids is not None:
            result['MaterialIds'] = self.material_ids
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialIds') is not None:
            self.material_ids = m.get('MaterialIds')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectsRequest(TeaModel):
    def __init__(
        self,
        project_ids: str = None,
    ):
        # The ID of the online editing project. You can specify multiple IDs separated with commas (,).
        self.project_ids = project_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        return self


class DeleteEditingProjectsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEditingProjectsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHotwordLibraryRequest(TeaModel):
    def __init__(
        self,
        hotword_library_id: str = None,
    ):
        self.hotword_library_id = hotword_library_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotword_library_id is not None:
            result['HotwordLibraryId'] = self.hotword_library_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HotwordLibraryId') is not None:
            self.hotword_library_id = m.get('HotwordLibraryId')
        return self


class DeleteHotwordLibraryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHotwordLibraryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHotwordLibraryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHotwordLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePackageChannelRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        group_name: str = None,
    ):
        # The channel name.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The channel group name.
        # 
        # This parameter is required.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteLivePackageChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePackageChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePackageChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePackageChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePackageChannelGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
    ):
        # The channel group name.
        # 
        # This parameter is required.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteLivePackageChannelGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePackageChannelGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePackageChannelGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePackageChannelGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePackageOriginEndpointRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        endpoint_name: str = None,
        group_name: str = None,
    ):
        # The channel name.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The endpoint name.
        # 
        # This parameter is required.
        self.endpoint_name = endpoint_name
        # The channel group name.
        # 
        # This parameter is required.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.endpoint_name is not None:
            result['EndpointName'] = self.endpoint_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('EndpointName') is not None:
            self.endpoint_name = m.get('EndpointName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteLivePackageOriginEndpointResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePackageOriginEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLivePackageOriginEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePackageOriginEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordFilesRequest(TeaModel):
    def __init__(
        self,
        record_ids: List[str] = None,
        remove_file: bool = None,
    ):
        # The collection of IDs of recording files.
        # 
        # This parameter is required.
        self.record_ids = record_ids
        # Specifies whether to delete the original files in OSS.
        self.remove_file = remove_file

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_ids is not None:
            result['RecordIds'] = self.record_ids
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordIds') is not None:
            self.record_ids = m.get('RecordIds')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        return self


class DeleteLiveRecordFilesResponseBodyDeleteFileInfoList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        record_id: str = None,
    ):
        # The code that identifies the result of the deletion.
        self.code = code
        # The result of deletion.
        self.message = message
        # The ID of the deleted recording file.
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DeleteLiveRecordFilesResponseBody(TeaModel):
    def __init__(
        self,
        delete_file_info_list: List[DeleteLiveRecordFilesResponseBodyDeleteFileInfoList] = None,
        message: str = None,
        request_id: str = None,
    ):
        # The list of files deleted.
        self.delete_file_info_list = delete_file_info_list
        # The description of the state returned.
        self.message = message
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.delete_file_info_list:
            for k in self.delete_file_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeleteFileInfoList'] = []
        if self.delete_file_info_list is not None:
            for k in self.delete_file_info_list:
                result['DeleteFileInfoList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.delete_file_info_list = []
        if m.get('DeleteFileInfoList') is not None:
            for k in m.get('DeleteFileInfoList'):
                temp_model = DeleteLiveRecordFilesResponseBodyDeleteFileInfoList()
                self.delete_file_info_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRecordFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # The ID of the template to be deleted. To obtain the template ID, log on to the [Intelligent Media Services (IMS) console](https://ice.console.aliyun.com/live-processing/template/list/record), choose Real-time Media Processing > Template Management, and then click the Recording tab. Alternatively, find the ID from the response parameters of the [CreateLiveRecordTemplate](https://help.aliyun.com/document_detail/448213.html) operation.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveRecordTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveRecordTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotFilesRequest(TeaModel):
    def __init__(
        self,
        create_timestamp_list: List[int] = None,
        delete_original_file: bool = None,
        job_id: str = None,
    ):
        # The list of timestamps when the jobs were created. The values are UNIX timestamps representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. A maximum of 200 jobs can be deleted at a time.
        # 
        # This parameter is required.
        self.create_timestamp_list = create_timestamp_list
        # Specifies whether to delete the original files at the same time. Default value: false.
        self.delete_original_file = delete_original_file
        # The ID of the snapshot job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp_list is not None:
            result['CreateTimestampList'] = self.create_timestamp_list
        if self.delete_original_file is not None:
            result['DeleteOriginalFile'] = self.delete_original_file
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list = m.get('CreateTimestampList')
        if m.get('DeleteOriginalFile') is not None:
            self.delete_original_file = m.get('DeleteOriginalFile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveSnapshotFilesShrinkRequest(TeaModel):
    def __init__(
        self,
        create_timestamp_list_shrink: str = None,
        delete_original_file: bool = None,
        job_id: str = None,
    ):
        # The list of timestamps when the jobs were created. The values are UNIX timestamps representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC. A maximum of 200 jobs can be deleted at a time.
        # 
        # This parameter is required.
        self.create_timestamp_list_shrink = create_timestamp_list_shrink
        # Specifies whether to delete the original files at the same time. Default value: false.
        self.delete_original_file = delete_original_file
        # The ID of the snapshot job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp_list_shrink is not None:
            result['CreateTimestampList'] = self.create_timestamp_list_shrink
        if self.delete_original_file is not None:
            result['DeleteOriginalFile'] = self.delete_original_file
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list_shrink = m.get('CreateTimestampList')
        if m.get('DeleteOriginalFile') is not None:
            self.delete_original_file = m.get('DeleteOriginalFile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList(TeaModel):
    def __init__(
        self,
        create_timestamp: int = None,
        result: str = None,
    ):
        # The time when the file was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_timestamp = create_timestamp
        # The result of deletion. A value of OK indicates that the file is deleted. Other values indicate that the file failed to be deleted.
        # 
        # Valid values:
        # 
        # *   OK: The file was deleted.
        # *   NotFound: The file was not found.
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteLiveSnapshotFilesResponseBody(TeaModel):
    def __init__(
        self,
        delete_file_result_list: List[DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList] = None,
        request_id: str = None,
    ):
        # The list of deleted files.
        self.delete_file_result_list = delete_file_result_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.delete_file_result_list:
            for k in self.delete_file_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeleteFileResultList'] = []
        if self.delete_file_result_list is not None:
            for k in self.delete_file_result_list:
                result['DeleteFileResultList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.delete_file_result_list = []
        if m.get('DeleteFileResultList') is not None:
            for k in m.get('DeleteFileResultList'):
                temp_model = DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList()
                self.delete_file_result_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveSnapshotFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # The template ID.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveSnapshotTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveSnapshotTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the transcoding job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # The template ID. To obtain the template ID, log on to the [Intelligent Media Services (IMS) console](https://ice.console.aliyun.com/summary), choose Real-time Media Processing > Template Management, and then click the Transcoding tab. Alternatively, find the ID from the response parameters of the [CreateLiveTranscodeTemplate](https://help.aliyun.com/document_detail/449217.html) operation.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveTranscodeTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaConnectFlowRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        # The flow ID.
        # 
        # This parameter is required.
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class DeleteMediaConnectFlowResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The call description.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of `0` indicates the call is successful.
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DeleteMediaConnectFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaConnectFlowResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaConnectFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaConnectFlowInputRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        input_name: str = None,
    ):
        # The flow ID.
        # 
        # This parameter is required.
        self.flow_id = flow_id
        self.input_name = input_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.input_name is not None:
            result['InputName'] = self.input_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('InputName') is not None:
            self.input_name = m.get('InputName')
        return self


class DeleteMediaConnectFlowInputResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The call description.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of 0 indicates the call is successful.
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DeleteMediaConnectFlowInputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaConnectFlowInputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaConnectFlowInputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaConnectFlowOutputRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        output_name: str = None,
    ):
        # The flow ID.
        # 
        # This parameter is required.
        self.flow_id = flow_id
        # The name of the output that you want to delete.
        # 
        # This parameter is required.
        self.output_name = output_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.output_name is not None:
            result['OutputName'] = self.output_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('OutputName') is not None:
            self.output_name = m.get('OutputName')
        return self


class DeleteMediaConnectFlowOutputResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        # The response body.
        self.content = content
        # The call description.
        self.description = description
        # The ID of the request.
        self.request_id = request_id
        # The returned error code. A value of 0 indicates the call is successful.
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class DeleteMediaConnectFlowOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaConnectFlowOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaConnectFlowOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaFromSearchLibRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        msg_body: str = None,
        namespace: str = None,
        search_lib_name: str = None,
    ):
        # The ID of the media asset.
        # 
        # This parameter is required.
        self.media_id = media_id
        # The message body.
        self.msg_body = msg_body
        self.namespace = namespace
        # The name of the search library. Default value: ims-default-search-lib.
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.msg_body is not None:
            result['MsgBody'] = self.msg_body
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MsgBody') is not None:
            self.msg_body = m.get('MsgBody')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class DeleteMediaFromSearchLibResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        media_id: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the media asset.
        self.media_id = media_id
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMediaFromSearchLibResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaFromSearchLibResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaFromSearchLibResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaInfosRequest(TeaModel):
    def __init__(
        self,
        delete_physical_files: bool = None,
        input_urls: str = None,
        media_ids: str = None,
    ):
        # Specifies whether to delete the physical file of the media asset.
        # 
        # If the media asset is stored in your own OSS bucket, you must authorize the service role AliyunICEDefaultRole in advance. For more information<props="china">, see [Authorize IMS to delete recording files in OSS](https://help.aliyun.com/zh/ims/user-guide/record?spm=a2c4g.11186623.0.i8#0737d9c437bmn).
        self.delete_physical_files = delete_physical_files
        # The URL of the media asset that you want to delete. The file corresponding to the URL must be registered with IMS. Separate multiple URLs with commas (,). The following two formats are supported:
        # 
        # 1.  http(s)://example-bucket.oss-cn-shanghai.aliyuncs.com/example.mp4?
        # 2.  OSS://example-bucket/example.mp4?\\
        #     In this format, it is considered by default that the region of the OSS bucket in which the media asset resides is the same as the region in which IMS is activated.
        self.input_urls = input_urls
        # The ID of the media asset that you want to delete from Intelligent Media Services (IMS).
        # 
        # *   Separate multiple IDs with commas (,).
        # 
        # If you leave MediaIds empty, you must specify InputURLs.
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_physical_files is not None:
            result['DeletePhysicalFiles'] = self.delete_physical_files
        if self.input_urls is not None:
            result['InputURLs'] = self.input_urls
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeletePhysicalFiles') is not None:
            self.delete_physical_files = m.get('DeletePhysicalFiles')
        if m.get('InputURLs') is not None:
            self.input_urls = m.get('InputURLs')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class DeleteMediaInfosResponseBody(TeaModel):
    def __init__(
        self,
        forbidden_list: List[str] = None,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        # The IDs or URLs of media assets that cannot be deleted. Generally, media assets cannot be deleted if you do not have the required permissions.
        self.forbidden_list = forbidden_list
        # The IDs or URLs of ignored media assets. An error occurred while obtaining such media assets.
        self.ignored_list = ignored_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_list is not None:
            result['ForbiddenList'] = self.forbidden_list
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForbiddenList') is not None:
            self.forbidden_list = m.get('ForbiddenList')
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaLiveChannelRequest(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
    ):
        # The ID of the channel.
        # 
        # This parameter is required.
        self.channel_id = channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        return self


class DeleteMediaLiveChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaLiveChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaLiveChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaLiveChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaLiveInputRequest(TeaModel):
    def __init__(
        self,
        input_id: str = None,
    ):
        # The ID of the input.
        # 
        # This parameter is required.
        self.input_id = input_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_id is not None:
            result['InputId'] = self.input_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputId') is not None:
            self.input_id = m.get('InputId')
        return self


class DeleteMediaLiveInputResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaLiveInputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaLiveInputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaLiveInputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaLiveInputSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        security_group_id: str = None,
    ):
        # The ID of the security group.
        # 
        # This parameter is required.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DeleteMediaLiveInputSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaLiveInputSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaLiveInputSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaLiveInputSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaMarksRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        media_mark_ids: str = None,
    ):
        # The ID of the media asset.
        self.media_id = media_id
        # The mark ID. You can specify multiple mark IDs separated with commas (,).
        # 
        # If you do not specify MediaMarkIds, all the marks of the media asset are deleted.
        self.media_mark_ids = media_mark_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_mark_ids is not None:
            result['MediaMarkIds'] = self.media_mark_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaMarkIds') is not None:
            self.media_mark_ids = m.get('MediaMarkIds')
        return self


class DeleteMediaMarksResponseBody(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        media_mark_ids: str = None,
        request_id: str = None,
    ):
        # The ID of the media asset.
        self.media_id = media_id
        # The IDs of the deleted marks separated with commas (,).
        self.media_mark_ids = media_mark_ids
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_mark_ids is not None:
            result['MediaMarkIds'] = self.media_mark_ids
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaMarkIds') is not None:
            self.media_mark_ids = m.get('MediaMarkIds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaMarksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaMarksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaMarksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
    ):
        # The ID of the MPS queue.
        # 
        # This parameter is required.
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlayInfoRequest(TeaModel):
    def __init__(
        self,
        delete_physical_files: bool = None,
        file_urls: str = None,
        media_id: str = None,
    ):
        # Specifies whether to delete the physical file of the media stream.
        # 
        # If the media asset is stored in your own Object Storage Service (OSS) bucket, you must authorize the service role AliyunICEDefaultRole in advance. <props="china">For more information, see [Authorize IMS to delete recording files in OSS](https://help.aliyun.com/document_detail/449331.html#p-ko2-wc7-iad).
        # 
        # You can delete only the physical files of transcoded streams, but not the physical files of source files.
        self.delete_physical_files = delete_physical_files
        # The URL of the media stream file that you want to delete. Separate multiple URLs with commas (,).
        self.file_urls = file_urls
        # The ID of the media asset.
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_physical_files is not None:
            result['DeletePhysicalFiles'] = self.delete_physical_files
        if self.file_urls is not None:
            result['FileURLs'] = self.file_urls
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeletePhysicalFiles') is not None:
            self.delete_physical_files = m.get('DeletePhysicalFiles')
        if m.get('FileURLs') is not None:
            self.file_urls = m.get('FileURLs')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class DeletePlayInfoResponseBody(TeaModel):
    def __init__(
        self,
        forbidden_list: List[str] = None,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        # The URLs of the media streams that cannot be deleted. Generally, media streams cannot be deleted if you do not have the required permissions.
        self.forbidden_list = forbidden_list
        # The URLs of ignored media streams. An error occurred while obtaining such media assets because the IDs or URLs of the media assets do not exist.
        self.ignored_list = ignored_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_list is not None:
            result['ForbiddenList'] = self.forbidden_list
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForbiddenList') is not None:
            self.forbidden_list = m.get('ForbiddenList')
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlayInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePlayInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProgramRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        program_name: str = None,
    ):
        # The name of the channel.
        # 
        # This parameter is required.
        self.channel_name = channel_name
        # The name of the program.
        # 
        # This parameter is required.
        self.program_name = program_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        return self


class DeleteProgramResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProgramResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteProgramResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRecognitionEntityRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        entity_id: str = None,
        lib_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        # This parameter is required.
        self.entity_id = entity_id
        # This parameter is required.
        self.lib_id = lib_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteRecognitionEntityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRecognitionEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRecognitionEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRecognitionEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRecognitionLibRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        lib_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        # This parameter is required.
        self.lib_id = lib_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteRecognitionLibResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRecognitionLibResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRecognitionLibResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRecognitionLibResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRecognitionSampleRequest(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        entity_id: str = None,
        lib_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sample_id: str = None,
    ):
        # This parameter is required.
        self.algorithm = algorithm
        # This parameter is required.
        self.entity_id = entity_id
        # This parameter is required.
        self.lib_id = lib_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # This parameter is required.
        self.sample_id = sample_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.lib_id is not None:
            result['LibId'] = self.lib_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sample_id is not None:
            result['SampleId'] = self.sample_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('LibId') is not None:
            self.lib_id = m.get('LibId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SampleId') is not None:
            self.sample_id = m.get('SampleId')
        return self


class DeleteRecognitionSampleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRecognitionSampleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRecognitionSampleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRecognitionSampleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmartJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The IDs of the jobs to delete. Separate multiple IDs with commas (,).
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteSmartJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmartJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSmartJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSmartJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSourceRequest(TeaModel):
    def __init__(
        self,
        soft_delete: bool = None,
        source_location_name: str = None,
        source_name: str = None,
        source_type: str = None,
    ):
        # Specifies whether to use delete markers.
        self.soft_delete = soft_delete
        # The name of the source location.
        # 
        # This parameter is required.
        self.source_location_name = source_location_name
        # The name of the source.
        # 
        # This parameter is required.
        self.source_name = source_name
        # The source type. Valid values: vodSource and liveSource.
        # 
        # This parameter is required.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.soft_delete is not None:
            result['SoftDelete'] = self.soft_delete
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        if self.source_name is not None:
            result['SourceName'] = self.source_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftDelete') is not None:
            self.soft_delete = m.get('SoftDelete')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        if m.get('SourceName') is not None:
            self.source_name = m.get('SourceName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DeleteSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSourceLocationRequest(TeaModel):
    def __init__(
        self,
        soft_delete: bool = None,
        source_location_name: str = None,
    ):
        # Specifies whether to use delete markers.
        self.soft_delete = soft_delete
        # The name of the source location.
        # 
        # This parameter is required.
        self.source_location_name = source_location_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.soft_delete is not None:
            result['SoftDelete'] = self.soft_delete
        if self.source_location_name is not None:
            result['SourceLocationName'] = self.source_location_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftDelete') is not None:
            self.soft_delete = m.get('SoftDelete')
        if m.get('SourceLocationName') is not None:
            self.source_location_name = m.get('SourceLocationName')
        return self


class DeleteSourceLocationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # **Request ID**\
        self.request_id = request_id
        # Indicates whether the request was successful. Valid value:
        # 
        # *   true: The request succeeded.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSourceLocationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSourceLocationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSourceLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(
        self,
        template_ids: str = None,
    ):
        # The IDs of the templates that you want to delete. Separate multiple IDs with commas (,).
        self.template_ids = template_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodPackagingAssetRequest(TeaModel):
    def __init__(
        self,
        asset_name: str = None,
    ):
        # The name of the VOD packaging asset.
        self.asset_name = asset_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_name is not None:
            result['AssetName'] = self.asset_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetName') is not None:
            self.asset_name = m.get('AssetName')
        return self


class DeleteVodPackagingAssetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVodPackagingAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVodPackagingAssetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodPackagingAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodPackagingConfigurationRequest(TeaModel):
    def __init__(
        self,
        configuration_name: str = None,
    ):
        # The name of the packaging configuration.
        self.configuration_name = configuration_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_name is not None:
            result['ConfigurationName'] = self.configuration_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationName') is not None:
            self.configuration_name = m.get('ConfigurationName')
        return self


class DeleteVodPackagingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVodPackagingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVodPackagingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodPackagingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVodPackagingGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
    ):
        # The name of the packaging group.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteVodPackagingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVodPackagingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVodPackagingGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVodPackagingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAIAgentInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the AI agent that you want to query.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeAIAgentInstanceResponseBodyInstance(TeaModel):
    def __init__(
        self,
        agent_config: AIAgentConfig = None,
        call_log_url: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        runtime_config: AIAgentRuntimeConfig = None,
        session_id: str = None,
        status: str = None,
        template_config: AIAgentTemplateConfig = None,
        user_data: str = None,
    ):
        self.agent_config = agent_config
        # The URL of the call log file.
        self.call_log_url = call_log_url
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        # The runtime configurations of the AI agent.
        self.runtime_config = runtime_config
        self.session_id = session_id
        # The state of the AI agent. Valid values: Finished and Executing.
        self.status = status
        # The template configurations of the AI agent.
        self.template_config = template_config
        # The custom information.
        self.user_data = user_data

    def validate(self):
        if self.agent_config:
            self.agent_config.validate()
        if self.runtime_config:
            self.runtime_config.validate()
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_config is not None:
            result['AgentConfig'] = self.agent_config.to_map()
        if self.call_log_url is not None:
            result['CallLogUrl'] = self.call_log_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.runtime_config is not None:
            result['RuntimeConfig'] = self.runtime_config.to_map()
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentConfig') is not None:
            temp_model = AIAgentConfig()
            self.agent_config = temp_model.from_map(m['AgentConfig'])
        if m.get('CallLogUrl') is not None:
            self.call_log_url = m.get('CallLogUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuntimeConfig') is not None:
            temp_model = AIAgentRuntimeConfig()
            self.runtime_config = temp_model.from_map(m['RuntimeConfig'])
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateConfig') is not None:
            temp_model = AIAgentTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class DescribeAIAgentInstanceResponseBody(TeaModel):
    def __init__(
        self,
        instance: DescribeAIAgentInstanceResponseBodyInstance = None,
        request_id: str = None,
    ):
        # The information about the AI agent.
        self.instance = instance
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            temp_model = DescribeAIAgentInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAIAgentInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAIAgentInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAIAgentInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsEditUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        # The end of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.end_ts = end_ts
        # The time granularity of the query. Valid values: 3600 (hour) and 86400 (day).
        # 
        # This parameter is required.
        self.interval = interval
        # This parameter does not take effect. By default, the usage data of all regions is returned.
        self.region = region
        # The beginning of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsEditUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        profile: str = None,
        time: int = None,
    ):
        # The usage duration, in minutes.
        self.duration = duration
        # The video profile.
        self.profile = profile
        # The beginning time of usage. The value is a 10-digit timestamp.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsEditUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterImsEditUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        # The usage statistics of IMS on VOD editing.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsEditUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsEditUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterImsEditUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsEditUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMediaConvertUHDUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: str = None,
        region_id: str = None,
        start_ts: int = None,
    ):
        # The end of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.end_ts = end_ts
        # The time granularity of the query. Valid values: 3600 (hour) and 86400 (day).
        # 
        # This parameter is required.
        self.interval = interval
        # This parameter does not take effect. By default, the usage data of all regions is returned.
        self.region_id = region_id
        # The beginning of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        specification: str = None,
        time: int = None,
    ):
        # The usage duration, in minutes.
        self.duration = duration
        # The transcoding specifications.
        self.specification = specification
        # The beginning time of usage. The value is a 10-digit timestamp.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterImsMediaConvertUHDUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        # The usage statistics of IMS on UHD transcoding of MPS.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMediaConvertUHDUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterImsMediaConvertUHDUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMediaConvertUHDUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMediaConvertUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        # The end of the time range to query. The value is a 10-digit timestamp. The maximum query range is 31 days. The duration between StartTs and EndTs cannot exceed 31 days.
        # 
        # This parameter is required.
        self.end_ts = end_ts
        # The time granularity of the query. Valid values: 3600 (hour) and 86400 (day).
        # 
        # This parameter is required.
        self.interval = interval
        # This parameter does not take effect. By default, the usage data of all regions is returned.
        self.region = region
        # The beginning of the time range to query. The value is a 10-digit timestamp. You can query data within the last 90 days.
        # 
        # This parameter is required.
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        specification: str = None,
        time: int = None,
    ):
        # The usage duration, in minutes.
        self.duration = duration
        # The transcoding specifications.
        self.specification = specification
        # The beginning time of usage. The value is a 10-digit timestamp.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsMediaConvertUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterImsMediaConvertUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        # The usage statistics of IMS on VOD transcoding.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMediaConvertUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterImsMediaConvertUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMpsAiUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        # The end of the time range to query. The value is a 10-digit timestamp. The maximum query range is 31 days. The duration between StartTs and EndTs cannot exceed 31 days.
        # 
        # This parameter is required.
        self.end_ts = end_ts
        # The time granularity of the query. Valid values: 3600 (hour) and 86400 (day).
        # 
        # This parameter is required.
        self.interval = interval
        # This parameter does not take effect. By default, the usage data of all regions is returned.
        self.region = region
        # The beginning of the time range to query. The value is a 10-digit timestamp. You can query data within the last 90 days.
        # 
        # This parameter is required.
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMpsAiUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        time: int = None,
        type: str = None,
    ):
        # The usage duration, in minutes.
        self.duration = duration
        # The beginning time of usage. The value is a 10-digit timestamp.
        self.time = time
        # The AI type. Valid values:
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMeterImsMpsAiUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterImsMpsAiUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        # The usage statistics of IMS on AI processing of MPS.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMpsAiUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMpsAiUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterImsMpsAiUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMpsAiUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsSummaryRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        # The end of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.end_ts = end_ts
        # This parameter does not take effect. By default, the usage data of all regions is returned.
        self.region = region
        # The beginning of the time range to query. The value is a 10-digit timestamp.
        # 
        # This parameter is required.
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        editing_duration: str = None,
        live_edit_duration: str = None,
        live_record_duration: str = None,
        live_snapshot_count: str = None,
        live_transcode_duration: int = None,
        mps_ai_duration: int = None,
        mps_transcode_duration: int = None,
        mps_transcode_uhdduration: int = None,
    ):
        # The duration of video editing.
        self.editing_duration = editing_duration
        # The duration of live editing.
        self.live_edit_duration = live_edit_duration
        # The duration of live stream recording.
        self.live_record_duration = live_record_duration
        # The number of live stream snapshots.
        self.live_snapshot_count = live_snapshot_count
        # The duration of live stream transcoding.
        self.live_transcode_duration = live_transcode_duration
        # The duration of AI processing.
        self.mps_ai_duration = mps_ai_duration
        # The duration of video-on-demand (VOD) transcoding.
        self.mps_transcode_duration = mps_transcode_duration
        # The duration of audio and video enhancement.
        self.mps_transcode_uhdduration = mps_transcode_uhdduration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_duration is not None:
            result['EditingDuration'] = self.editing_duration
        if self.live_edit_duration is not None:
            result['LiveEditDuration'] = self.live_edit_duration
        if self.live_record_duration is not None:
            result['LiveRecordDuration'] = self.live_record_duration
        if self.live_snapshot_count is not None:
            result['LiveSnapshotCount'] = self.live_snapshot_count
        if self.live_transcode_duration is not None:
            result['LiveTranscodeDuration'] = self.live_transcode_duration
        if self.mps_ai_duration is not None:
            result['MpsAiDuration'] = self.mps_ai_duration
        if self.mps_transcode_duration is not None:
            result['MpsTranscodeDuration'] = self.mps_transcode_duration
        if self.mps_transcode_uhdduration is not None:
            result['MpsTranscodeUHDDuration'] = self.mps_transcode_uhdduration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditingDuration') is not None:
            self.editing_duration = m.get('EditingDuration')
        if m.get('LiveEditDuration') is not None:
            self.live_edit_duration = m.get('LiveEditDuration')
        if m.get('LiveRecordDuration') is not None:
            self.live_record_duration = m.get('LiveRecordDuration')
        if m.get('LiveSnapshotCount') is not None:
            self.live_snapshot_count = m.get('LiveSnapshotCount')
        if m.get('LiveTranscodeDuration') is not None:
            self.live_transcode_duration = m.get('LiveTranscodeDuration')
        if m.get('MpsAiDuration') is not None:
            self.mps_ai_duration = m.get('MpsAiDuration')
        if m.get('MpsTranscodeDuration') is not None:
            self.mps_transcode_duration = m.get('MpsTranscodeDuration')
        if m.get('MpsTranscodeUHDDuration') is not None:
            self.mps_transcode_uhdduration = m.get('MpsTranscodeUHDDuration')
        return self


class DescribeMeterImsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterImsSummaryResponseBodyData] = None,
        request_id: str = None,
    ):
        # The usage statistics of IMS.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsSummaryResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterImsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNotifyConfigRequest(TeaModel):
    def __init__(
        self,
        aiagent_id: str = None,
    ):
        # This parameter is required.
        self.aiagent_id = aiagent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiagent_id is not None:
            result['AIAgentId'] = self.aiagent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AIAgentId') is not None:
            self.aiagent_id = m.get('AIAgentId')
        return self


class DescribeNotifyConfigResponseBody(TeaModel):
    def __init__(
        self,
        audio_oss_path: str = None,
        callback_url: str = None,
        enable_audio_recording: bool = None,
        enable_notify: bool = None,
        event_types: str = None,
        request_id: str = None,
        token: str = None,
    ):
        self.audio_oss_path = audio_oss_path
        self.callback_url = callback_url
        self.enable_audio_recording = enable_audio_recording
        self.enable_notify = enable_notify
        # The event types. If this parameter is empty, all event types are selected.
        # 
        # *   agent_start: The agent is started.
        # *   agent_stop: The agent is stopped.
        # *   error: An error occurred.
        self.event_types = event_types
        self.request_id = request_id
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_oss_path is not None:
            result['AudioOssPath'] = self.audio_oss_path
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.enable_audio_recording is not None:
            result['EnableAudioRecording'] = self.enable_audio_recording
        if self.enable_notify is not None:
            result['EnableNotify'] = self.enable_notify
        if self.event_types is not None:
            result['EventTypes'] = self.event_types
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioOssPath') is not None:
            self.audio_oss_path = m.get('AudioOssPath')
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('EnableAudioRecording') is not None:
            self.enable_audio_recording = m.get('EnableAudioRecording')
        if m.get('EnableNotify') is not None:
            self.enable_notify = m.get('EnableNotify')
        if m.get('EventTypes') is not None:
            self.event_types = m.get('EventTypes')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class DescribeNotifyConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNotifyConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayListRequest(TeaModel):
    def __init__(
        self,
        begin_ts: str = None,
        end_ts: str = None,
        order_name: str = None,
        order_type: str = None,
        page_no: int = None,
        page_size: int = None,
        play_type: str = None,
        status: str = None,
        trace_id: str = None,
    ):
        # This parameter is required.
        self.begin_ts = begin_ts
        # This parameter is required.
        self.end_ts = end_ts
        self.order_name = order_name
        self.order_type = order_type
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.play_type = play_type
        self.status = status
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.status is not None:
            result['Status'] = self.status
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayListResponseBodyPlayList(TeaModel):
    def __init__(
        self,
        first_frame_duration: str = None,
        play_duration: str = None,
        play_ts: str = None,
        play_type: str = None,
        session_id: str = None,
        status: str = None,
        stuck_duration: str = None,
        trace_id: str = None,
        video_duration: str = None,
        video_id: str = None,
    ):
        self.first_frame_duration = first_frame_duration
        self.play_duration = play_duration
        self.play_ts = play_ts
        self.play_type = play_type
        self.session_id = session_id
        self.status = status
        self.stuck_duration = stuck_duration
        self.trace_id = trace_id
        self.video_duration = video_duration
        self.video_id = video_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.play_ts is not None:
            result['PlayTs'] = self.play_ts
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.stuck_duration is not None:
            result['StuckDuration'] = self.stuck_duration
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.video_duration is not None:
            result['VideoDuration'] = self.video_duration
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('PlayTs') is not None:
            self.play_ts = m.get('PlayTs')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StuckDuration') is not None:
            self.stuck_duration = m.get('StuckDuration')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('VideoDuration') is not None:
            self.video_duration = m.get('VideoDuration')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DescribePlayListResponseBody(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        play_list: List[DescribePlayListResponseBodyPlayList] = None,
        request_id: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.play_list = play_list
        # Id
        self.request_id = request_id
        self.total_num = total_num

    def validate(self):
        if self.play_list:
            for k in self.play_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PlayList'] = []
        if self.play_list is not None:
            for k in self.play_list:
                result['PlayList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.play_list = []
        if m.get('PlayList') is not None:
            for k in m.get('PlayList'):
                temp_model = DescribePlayListResponseBodyPlayList()
                self.play_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribePlayListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRtcRobotInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeRtcRobotInstanceResponseBodyConfig(TeaModel):
    def __init__(
        self,
        enable_voice_interrupt: bool = None,
        greeting: str = None,
        voice_id: str = None,
    ):
        self.enable_voice_interrupt = enable_voice_interrupt
        self.greeting = greeting
        self.voice_id = voice_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_voice_interrupt is not None:
            result['EnableVoiceInterrupt'] = self.enable_voice_interrupt
        if self.greeting is not None:
            result['Greeting'] = self.greeting
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableVoiceInterrupt') is not None:
            self.enable_voice_interrupt = m.get('EnableVoiceInterrupt')
        if m.get('Greeting') is not None:
            self.greeting = m.get('Greeting')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        return self


class DescribeRtcRobotInstanceResponseBody(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        channel_id: str = None,
        config: DescribeRtcRobotInstanceResponseBodyConfig = None,
        request_id: str = None,
        status: str = None,
        user_data: str = None,
        user_id: str = None,
    ):
        self.auth_token = auth_token
        self.channel_id = channel_id
        self.config = config
        # Id of the request
        self.request_id = request_id
        self.status = status
        self.user_data = user_data
        self.user_id = user_id

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Config') is not None:
            temp_model = DescribeRtcRobotInstanceResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DescribeRtcRobotInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRtcRobotInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRtcRobotInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetectAudioForCustomizedVoiceJobRequest(TeaModel):
    def __init__(
        self,
        audio_record_id: int = None,
        record_url: str = None,
        voice_id: str = None,
    ):
        # The sequence number of the recording file.
        # 
        # This parameter is required.
        self.audio_record_id = audio_record_id
        # The URL of the recording file.
        # 
        # > : The URL must be an Object Storage Service (OSS) URL within your Alibaba Cloud account. The OSS bucket must be in the same region in which IMS is activated.
        # 
        # > : The audio file must be in the WAV or PCM format and must be a 16-bit mono audio file at 48000 Hz.
        # 
        # This parameter is required.
        self.record_url = record_url
        # The voice ID.
        # 
        # This parameter is required.
        self.voice_id = voice_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_record_id is not None:
            result['AudioRecordId'] = self.audio_record_id
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioRecordId') is not None:
            self.audio_record_id = m.get('AudioRecordId')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        return self


class DetectAudioForCustomizedVoiceJobResponseBodyData(TeaModel):
    def __init__(
        self,
        pass_: bool = None,
        reason: str = None,
    ):
        # Indicates whether the audio file passes the check. Valid values:
        # 
        # *   true
        # *   false
        self.pass_ = pass_
        # The reason returned if the audio file failed to pass the check.
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pass_ is not None:
            result['Pass'] = self.pass_
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pass') is not None:
            self.pass_ = m.get('Pass')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DetectAudioForCustomizedVoiceJobResponseBody(TeaModel):
    def __init__(
        self,
        data: DetectAudioForCustomizedVoiceJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DetectAudioForCustomizedVoiceJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetectAudioForCustomizedVoiceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetectAudioForCustomizedVoiceJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetectAudioForCustomizedVoiceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DropSearchIndexRequest(TeaModel):
    def __init__(
        self,
        index_type: str = None,
        search_lib_name: str = None,
    ):
        # The category of the index. Valid values:
        # 
        # *   mm: large visual model.
        # *   face: face recognition.
        # *   aiLabel: smart tagging.
        # 
        # This parameter is required.
        self.index_type = index_type
        # The name of the search library.
        # 
        # *   If you leave this parameter empty, the search index is created in the default search library of Intelligent Media Service (IMS). Default value: ims-default-search-lib.
        # *   To query information about an existing search library, call the [QuerySearchLib](https://help.aliyun.com/document_detail/2584455.html) API operation.
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_type is not None:
            result['IndexType'] = self.index_type
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IndexType') is not None:
            self.index_type = m.get('IndexType')
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class DropSearchIndexResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DropSearchIndexResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DropSearchIndexResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DropSearchIndexResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DropSearchLibRequest(TeaModel):
    def __init__(
        self,
        search_lib_name: str = None,
    ):
        # The name of the search library.
        # 
        # This parameter is required.
        self.search_lib_name = search_lib_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_lib_name is not None:
            result['SearchLibName'] = self.search_lib_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SearchLibName') is not None:
            self.search_lib_name = m.get('SearchLibName')
        return self


class DropSearchLibResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DropSearchLibResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DropSearchLibResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DropSearchLibResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ForbidMediaConnectFlowOutputRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        output_name: str = None,
    ):
        self.flow_id = flow_id
        self.output_name = output_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.output_name is not None:
            result['OutputName'] = self.output_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('OutputName') is not None:
            self.output_name = m.get('OutputName')
        return self


class ForbidMediaConnectFlowOutputResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        description: str = None,
        request_id: str = None,
        ret_code: int = None,
    ):
        self.content = content
        self.description = description
        self.request_id = request_id
        self.ret_code = ret_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ret_code is not None:
            result['RetCode'] = self.ret_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetCode') is not None:
            self.ret_code = m.get('RetCode')
        return self


class ForbidMediaConnectFlowOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ForbidMediaConnectFlowOutputResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ForbidMediaConnectFlowOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ForwardAIAgentCallRequest(TeaModel):
    def __init__(
        self,
        called_number: str = None,
        instance_id: str = None,
    ):
        self.called_number = called_number
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ForwardAIAgentCallResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ForwardAIAgentCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ForwardAIAgentCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ForwardAIAgentCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateAIAgentCallRequestChatSyncConfig(TeaModel):
    def __init__(
        self,
        imaiagent_id: str = None,
        receiver_id: str = None,
    ):
        self.imaiagent_id = imaiagent_id
        self.receiver_id = receiver_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.imaiagent_id is not None:
            result['IMAIAgentId'] = self.imaiagent_id
        if self.receiver_id is not None:
            result['ReceiverId'] = self.receiver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IMAIAgentId') is not None:
            self.imaiagent_id = m.get('IMAIAgentId')
        if m.get('ReceiverId') is not None:
            self.receiver_id = m.get('ReceiverId')
        return self


class GenerateAIAgentCallRequest(TeaModel):
    def __init__(
        self,
        aiagent_id: str = None,
        agent_config: AIAgentConfig = None,
        chat_sync_config: GenerateAIAgentCallRequestChatSyncConfig = None,
        expire: int = None,
        session_id: str = None,
        template_config: AIAgentTemplateConfig = None,
        user_data: str = None,
        user_id: str = None,
    ):
        # The ID of the AI agent.
        # 
        # This parameter is required.
        self.aiagent_id = aiagent_id
        self.agent_config = agent_config
        self.chat_sync_config = chat_sync_config
        # The time when the token expires. Unit: seconds. Default value: 3600. Valid values: 0 to 604800.
        self.expire = expire
        self.session_id = session_id
        # The template configurations of the AI agent. The specified configurations are merged with the template configurations that are specified in the console. If you do not specify this parameter, the system uses the default configurations for an AI agent created in the console.
        self.template_config = template_config
        self.user_data = user_data
        # The username of the AI agent in the channel. If you do not specify this parameter, the system automatically generates a username. The value can be up to 64 characters in length.
        self.user_id = user_id

    def validate(self):
        if self.agent_config:
            self.agent_config.validate()
        if self.chat_sync_config:
            self.chat_sync_config.validate()
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiagent_id is not None:
            result['AIAgentId'] = self.aiagent_id
        if self.agent_config is not None:
            result['AgentConfig'] = self.agent_config.to_map()
        if self.chat_sync_config is not None:
            result['ChatSyncConfig'] = self.chat_sync_config.to_map()
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AIAgentId') is not None:
            self.aiagent_id = m.get('AIAgentId')
        if m.get('AgentConfig') is not None:
            temp_model = AIAgentConfig()
            self.agent_config = temp_model.from_map(m['AgentConfig'])
        if m.get('ChatSyncConfig') is not None:
            temp_model = GenerateAIAgentCallRequestChatSyncConfig()
            self.chat_sync_config = temp_model.from_map(m['ChatSyncConfig'])
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('TemplateConfig') is not None:
            temp_model = AIAgentTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GenerateAIAgentCallShrinkRequest(TeaModel):
    def __init__(
        self,
        aiagent_id: str = None,
        agent_config_shrink: str = None,
        chat_sync_config_shrink: str = None,
        expire: int = None,
        session_id: str = None,
        template_config_shrink: str = None,
        user_data: str = None,
        user_id: str = None,
    ):
        # The ID of the AI agent.
        # 
        # This parameter is required.
        self.aiagent_id = aiagent_id
        self.agent_config_shrink = agent_config_shrink
        self.chat_sync_config_shrink = chat_sync_config_shrink
        # The time when the token expires. Unit: seconds. Default value: 3600. Valid values: 0 to 604800.
        self.expire = expire
        self.session_id = session_id
        # The template configurations of the AI agent. The specified configurations are merged with the template configurations that are specified in the console. If you do not specify this parameter, the system uses the default configurations for an AI agent created in the console.
        self.template_config_shrink = template_config_shrink
        self.user_data = user_data
        # The username of the AI agent in the channel. If you do not specify this parameter, the system automatically generates a username. The value can be up to 64 characters in length.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiagent_id is not None:
            result['AIAgentId'] = self.aiagent_id
        if self.agent_config_shrink is not None:
            result['AgentConfig'] = self.agent_config_shrink
        if self.chat_sync_config_shrink is not None:
            result['ChatSyncConfig'] = self.chat_sync_config_shrink
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.template_config_shrink is not None:
            result['TemplateConfig'] = self.template_config_shrink
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AIAgentId') is not None:
            self.aiagent_id = m.get('AIAgentId')
        if m.get('AgentConfig') is not None:
            self.agent_config_shrink = m.get('AgentConfig')
        if m.get('ChatSyncConfig') is not None:
            self.chat_sync_config_shrink = m.get('ChatSyncConfig')
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('TemplateConfig') is not None:
            self.template_config_shrink = m.get('TemplateConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GenerateAIAgentCallResponseBody(TeaModel):
    def __init__(
        self,
        aiagent_user_id: str = None,
        channel_id: str = None,
        instance_id: str = None,
        request_id: str = None,
        token: str = None,
        user_id: str = None,
    ):
        # The username of the AI agent in the Alibaba Real-Time Communication (ARTC) channel.
        self.aiagent_user_id = aiagent_user_id
        # The ARTC channel ID.
        self.channel_id = channel_id
        # The ID of the AI agent.
        self.instance_id = instance_id
        # The request ID.
        self.request_id = request_id
        # The ARTC token of the client.
        self.token = token
        # The username in the ARTC channel.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiagent_user_id is not None:
            result['AIAgentUserId'] = self.aiagent_user_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.token is not None:
            result['Token'] = self.token
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AIAgentUserId') is not None:
            self.aiagent_user_id = m.get('AIAgentUserId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GenerateAIAgentCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateAIAgentCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateAIAgentCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateKMSDataKeyResponseBodyDataKey(TeaModel):
    def __init__(
        self,
        ciphertext_blob: str = None,
        key_id: str = None,
        plaintext: str = None,
    ):
        # The ciphertext of the encrypted data key. This parameter is used as CipherText when you create a transcoding job.
        self.ciphertext_blob = ciphertext_blob
        # The ID of the customer master key (CMK). The ID must be globally unique.
        self.key_id = key_id
        # The Base64-encoded plaintext of the data key.
        self.plaintext = plaintext

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphertext_blob is not None:
            result['CiphertextBlob'] = self.ciphertext_blob
        if self.key_id is not None:
            result['KeyId'] = self.key_id
        if self.plaintext is not None:
            result['Plaintext'] = self.plaintext
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CiphertextBlob') is not None:
            self.ciphertext_blob = m.get('CiphertextBlob')
        if m.get('KeyId') is not None:
            self.key_id = m.get('KeyId')
        if m.get('Plaintext') is not None:
            self.plaintext = m.get('Plaintext')
        return self


class GenerateKMSDataKeyResponseBody(TeaModel):
    def __init__(
        self,
        data_key: GenerateKMSDataKeyResponseBodyDataKey = None,
        request_id: str = None,
    ):
        # The information about the data key.
        self.data_key = data_key
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data_key:
            self.data_key.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_key is not None:
            result['DataKey'] = self.data_key.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataKey') is not None:
            temp_model = GenerateKMSDataKeyResponseBodyDataKey()
            self.data_key = temp_model.from_map(m['DataKey'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateKMSDataKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateKMSDataKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateKMSDataKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateMessageChatTokenRequest(TeaModel):
    def __init__(
        self,
        aiagent_id: str = None,
        expire: int = None,
        role: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.aiagent_id = aiagent_id
        self.expire = expire
        self.role = role
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aiagent_id is not None:
            result['AIAgentId'] = self.aiagent_id
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.role is not None:
            result['Role'] = self.role
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AIAgentId') is not None:
            self.aiagent_id = m.get('AIAgentId')
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GenerateMessageChatTokenResponseBody(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_sign: str = None,
        nonce: str = None,
        request_id: str = None,
        role: str = None,
        time_stamp: int = None,
        token: str = None,
        user_id: str = None,
    ):
        self.app_id = app_id
        self.app_sign = app_sign
        self.nonce = nonce
        self.request_id = request_id
        self.role = role
        self.time_stamp = time_stamp
        self.token = token
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_sign is not None:
            result['AppSign'] = self.app_sign
        if self.nonce is not None:
            result['Nonce'] = self.nonce
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role is not None:
            result['Role'] = self.role
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.token is not None:
            result['Token'] = self.token
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppSign') is not None:
            self.app_sign = m.get('AppSign')
        if m.get('Nonce') is not None:
            self.nonce = m.get('Nonce')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GenerateMessageChatTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateMessageChatTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateMessageChatTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAdInsertionRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The name of the ad insertion configuration that you want to query.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetAdInsertionResponseBodyConfigCdnConfig(TeaModel):
    def __init__(
        self,
        ad_segment_url_prefix: str = None,
        content_segment_url_prefix: str = None,
    ):
        # The CDN prefix for accessing ad segments.
        self.ad_segment_url_prefix = ad_segment_url_prefix
        # The CDN prefix for accessing content segments.
        self.content_segment_url_prefix = content_segment_url_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_segment_url_prefix is not None:
            result['AdSegmentUrlPrefix'] = self.ad_segment_url_prefix
        if self.content_segment_url_prefix is not None:
            result['ContentSegmentUrlPrefix'] = self.content_segment_url_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdSegmentUrlPrefix') is not None:
            self.ad_segment_url_prefix = m.get('AdSegmentUrlPrefix')
        if m.get('ContentSegmentUrlPrefix') is not None:
            self.content_segment_url_prefix = m.get('ContentSegmentUrlPrefix')
        return self


class GetAdInsertionResponseBodyConfigManifestEndpointConfig(TeaModel):
    def __init__(
        self,
        dash_prefix: str = None,
        hls_prefix: str = None,
    ):
        # DASH清单播放端点前缀
        self.dash_prefix = dash_prefix
        # The playback endpoint prefix for accessing HLS manifests.
        self.hls_prefix = hls_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dash_prefix is not None:
            result['DashPrefix'] = self.dash_prefix
        if self.hls_prefix is not None:
            result['HlsPrefix'] = self.hls_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DashPrefix') is not None:
            self.dash_prefix = m.get('DashPrefix')
        if m.get('HlsPrefix') is not None:
            self.hls_prefix = m.get('HlsPrefix')
        return self


class GetAdInsertionResponseBodyConfig(TeaModel):
    def __init__(
        self,
        ad_marker_passthrough: str = None,
        ads_url: str = None,
        cdn_config: GetAdInsertionResponseBodyConfigCdnConfig = None,
        config_aliases: str = None,
        content_url_prefix: str = None,
        create_time: str = None,
        last_modified: str = None,
        manifest_endpoint_config: GetAdInsertionResponseBodyConfigManifestEndpointConfig = None,
        name: str = None,
        personalization_threshold: int = None,
        slate_ad_url: str = None,
    ):
        # Indicates whether ad marker passthrough is enabled.
        self.ad_marker_passthrough = ad_marker_passthrough
        # The URL of the ad decision server (ADS).
        self.ads_url = ads_url
        # The CDN configurations.
        self.cdn_config = cdn_config
        # The aliases for dynamic variable replacement.
        self.config_aliases = config_aliases
        # The prefix of the source URL.
        self.content_url_prefix = content_url_prefix
        # The time when the configuration was created.
        self.create_time = create_time
        # The time when the configuration was last modified.
        self.last_modified = last_modified
        # The playback endpoint prefix for accessing manifests.
        self.manifest_endpoint_config = manifest_endpoint_config
        # The name of the configuration.
        self.name = name
        # The personalization threshold.
        self.personalization_threshold = personalization_threshold
        # The URL of the slate ad.
        self.slate_ad_url = slate_ad_url

    def validate(self):
        if self.cdn_config:
            self.cdn_config.validate()
        if self.manifest_endpoint_config:
            self.manifest_endpoint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_marker_passthrough is not None:
            result['AdMarkerPassthrough'] = self.ad_marker_passthrough
        if self.ads_url is not None:
            result['AdsUrl'] = self.ads_url
        if self.cdn_config is not None:
            result['CdnConfig'] = self.cdn_config.to_map()
        if self.config_aliases is not None:
            result['ConfigAliases'] = self.config_aliases
        if self.content_url_prefix is not None:
            result['ContentUrlPrefix'] = self.content_url_prefix
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.manifest_endpoint_config is not None:
            result['ManifestEndpointConfig'] = self.manifest_endpoint_config.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.personalization_threshold is not None:
            result['PersonalizationThreshold'] = self.personalization_threshold
        if self.slate_ad_url is not None:
            result['SlateAdUrl'] = self.slate_ad_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdMarkerPassthrough') is not None:
            self.ad_marker_passthrough = m.get('AdMarkerPassthrough')
        if m.get('AdsUrl') is not None:
            self.ads_url = m.get('AdsUrl')
        if m.get('CdnConfig') is not None:
            temp_model = GetAdInsertionResponseBodyConfigCdnConfig()
            self.cdn_config = temp_model.from_map(m['CdnConfig'])
        if m.get('ConfigAliases') is not None:
            self.config_aliases = m.get('ConfigAliases')
        if m.get('ContentUrlPrefix') is not None:
            self.content_url_prefix = m.get('ContentUrlPrefix')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('ManifestEndpointConfig') is not None:
            temp_model = GetAdInsertionResponseBodyConfigManifestEndpointConfig()
            self.manifest_endpoint_config = temp_model.from_map(m['ManifestEndpointConfig'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PersonalizationThreshold') is not None:
            self.personalization_threshold = m.get('PersonalizationThreshold')
        if m.get('SlateAdUrl') is not None:
            self.slate_ad_url = m.get('SlateAdUrl')
        return self


class GetAdInsertionResponseBody(TeaModel):
    def __init__(
        self,
        config: GetAdInsertionResponseBodyConfig = None,
        request_id: str = None,
    ):
        # The ad insertion configuration.
        self.config = config
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = GetAdInsertionResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAdInsertionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAdInsertionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAdInsertionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAvatarRequest(TeaModel):
    def __init__(
        self,
        avatar_id: str = None,
    ):
        # *   The ID of the digital human.
        # 
        # This parameter is required.
        self.avatar_id = avatar_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_id is not None:
            result['AvatarId'] = self.avatar_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarId') is not None:
            self.avatar_id = m.get('AvatarId')
        return self


class GetAvatarResponseBodyDataAvatar(TeaModel):
    def __init__(
        self,
        avatar_description: str = None,
        avatar_id: str = None,
        avatar_name: str = None,
        avatar_type: str = None,
        height: int = None,
        portrait: str = None,
        thumbnail: str = None,
        transparent: bool = None,
        width: int = None,
    ):
        # The description of the digital human.
        self.avatar_description = avatar_description
        # The ID of the digital human.
        self.avatar_id = avatar_id
        # The name of the digital human.
        self.avatar_name = avatar_name
        # The type of the digital human.
        self.avatar_type = avatar_type
        # The height of the digital human image in pixels.
        self.height = height
        # The media asset ID of the portrait image.
        self.portrait = portrait
        # The thumbnail URL.
        self.thumbnail = thumbnail
        # Indicates whether the digital human supports alpha channels.
        self.transparent = transparent
        # The width of the digital human image in pixels.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_description is not None:
            result['AvatarDescription'] = self.avatar_description
        if self.avatar_id is not None:
            result['AvatarId'] = self.avatar_id
        if self.avatar_name is not None:
            result['AvatarName'] = self.avatar_name
        if self.avatar_type is not None:
            result['AvatarType'] = self.avatar_type
        if self.height is not None:
            result['Height'] = self.height
        if self.portrait is not None:
            result['Portrait'] = self.portrait
        if self.thumbnail is not None:
            result['Thumbnail'] = self.thumbnail
        if self.transparent is not None:
            result['Transparent'] = self.transparent
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarDescription') is not None:
            self.avatar_description = m.get('AvatarDescription')
        if m.get('AvatarId') is not None:
            self.avatar_id = m.get('AvatarId')
        if m.get('AvatarName') is not None:
            self.avatar_name = m.get('AvatarName')
        if m.get('AvatarType') is not None:
            self.avatar_type = m.get('AvatarType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Portrait') is not None:
            self.portrait = m.get('Portrait')
        if m.get('Thumbnail') is not None:
            self.thumbnail = m.get('Thumbnail')
        if m.get('Transparent') is not None:
            self.transparent = m.get('Transparent')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetAvatarResponseBodyData(TeaModel):
    def __init__(
        self,
        avatar: GetAvatarResponseBodyDataAvatar = None,
    ):
        # The information about the digital human.
        self.avatar = avatar

    def validate(self):
        if self.avatar:
            self.avatar.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['Avatar'] = self.avatar.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avatar') is not None:
            temp_model = GetAvatarResponseBodyDataAvatar()
            self.avatar = temp_model.from_map(m['Avatar'])
        return self


class GetAvatarResponseBody(TeaModel):
    def __init__(
        self,
        data: GetAvatarResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetAvatarResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAvatarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAvatarResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAvatarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAvatarTrainingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the digital human training job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetAvatarTrainingJobResponseBodyDataAvatarTrainingJob(TeaModel):
    def __init__(
        self,
        avatar_description: str = None,
        avatar_id: str = None,
        avatar_name: str = None,
        avatar_type: str = None,
        first_training_time: str = None,
        job_id: str = None,
        last_training_time: str = None,
        message: str = None,
        portrait: str = None,
        status: str = None,
        thumbnail: str = None,
        transparent: bool = None,
        video: str = None,
    ):
        # The description of the digital human.
        self.avatar_description = avatar_description
        # The ID of the digital human.
        self.avatar_id = avatar_id
        # The name of the digital human.
        self.avatar_name = avatar_name
        # The type of the digital human.
        self.avatar_type = avatar_type
        # *   The time when the first training was initiated.
        # *   The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.first_training_time = first_training_time
        # The ID of the digital human training job.
        self.job_id = job_id
        # *   The time when the last training was initiated.
        # *   The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.last_training_time = last_training_time
        # The status description.
        self.message = message
        # The media asset ID of the portrait image.
        self.portrait = portrait
        # *   The state of the digital human training job.
        # *   Valid values: Init, Queuing, Training, Success, and Fail.
        self.status = status
        # The thumbnail URL.
        self.thumbnail = thumbnail
        # Indicates whether the input video supports alpha channels.
        self.transparent = transparent
        # The ID of the video used for training.
        self.video = video

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_description is not None:
            result['AvatarDescription'] = self.avatar_description
        if self.avatar_id is not None:
            result['AvatarId'] = self.avatar_id
        if self.avatar_name is not None:
            result['AvatarName'] = self.avatar_name
        if self.avatar_type is not None:
            result['AvatarType'] = self.avatar_type
        if self.first_training_time is not None:
            result['FirstTrainingTime'] = self.first_training_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.last_training_time is not None:
            result['LastTrainingTime'] = self.last_training_time
        if self.message is not None:
            result['Message'] = self.message
        if self.portrait is not None:
            result['Portrait'] = self.portrait
        if self.status is not None:
            result['Status'] = self.status
        if self.thumbnail is not None:
            result['Thumbnail'] = self.thumbnail
        if self.transparent is not None:
            result['Transparent'] = self.transparent
        if self.video is not None:
            result['Video'] = self.video
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarDescription') is not None:
            self.avatar_description = m.get('AvatarDescription')
        if m.get('AvatarId') is not None:
            self.avatar_id = m.get('AvatarId')
        if m.get('AvatarName') is not None:
            self.avatar_name = m.get('AvatarName')
        if m.get('AvatarType') is not None:
            self.avatar_type = m.get('AvatarType')
        if m.get('FirstTrainingTime') is not None:
            self.first_training_time = m.get('FirstTrainingTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('LastTrainingTime') is not None:
            self.last_training_time = m.get('LastTrainingTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Portrait') is not None:
            self.portrait = m.get('Portrait')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Thumbnail') is not None:
            self.thumbnail = m.get('Thumbnail')
        if m.get('Transparent') is not None:
            self.transparent = m.get('Transparent')
        if m.get('Video') is not None:
            self.video = m.get('Video')
        return self


class GetAvatarTrainingJobResponseBodyData(TeaModel):
    def __init__(
        self,
        avatar_training_job: GetAvatarTrainingJobResponseBodyDataAvatarTrainingJob = None,
    ):
        # The information about the digital human training job.
        self.avatar_training_job = avatar_training_job

    def validate(self):
        if self.avatar_training_job:
            self.avatar_training_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_training_job is not None:
            result['AvatarTrainingJob'] = self.avatar_training_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarTrainingJob') is not None:
            temp_model = GetAvatarTrainingJobResponseBodyDataAvatarTrainingJob()
            self.avatar_training_job = temp_model.from_map(m['AvatarTrainingJob'])
        return self


class GetAvatarTrainingJobResponseBody(TeaModel):
    def __init__(
        self,
        data: GetAvatarTrainingJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned if the request was successful.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetAvatarTrainingJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAvatarTrainingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAvatarTrainingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAvatarTrainingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBatchMediaProducingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the quick video production job.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetBatchMediaProducingJobResponseBodyEditingBatchJobSubJobList(TeaModel):
    def __init__(
        self,
        duration: float = None,
        error_code: str = None,
        error_message: str = None,
        job_id: str = None,
        media_id: str = None,
        media_url: str = None,
        project_id: str = None,
        status: str = None,
    ):
        self.duration = duration
        # The error code that is returned if the subjob failed. This parameter is not returned if the subjob is successful.
        self.error_code = error_code
        # The error message that is returned if the subjob failed. This parameter is not returned if the subjob is successful.
        self.error_message = error_message
        # The subjob ID.
        self.job_id = job_id
        # The ID of the output media asset.
        self.media_id = media_id
        # The URL of the output file.
        self.media_url = media_url
        # The ID of the online editing project.
        self.project_id = project_id
        # The subjob state. Valid values:
        # 
        # Init: The subjob is initialized.
        # 
        # Processing: The subjob is in progress.
        # 
        # Success: The subjob is successful.
        # 
        # Failed: The subjob failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetBatchMediaProducingJobResponseBodyEditingBatchJob(TeaModel):
    def __init__(
        self,
        complete_time: str = None,
        create_time: str = None,
        editing_config: str = None,
        extend: str = None,
        input_config: str = None,
        job_id: str = None,
        job_type: str = None,
        modified_time: str = None,
        output_config: str = None,
        status: str = None,
        sub_job_list: List[GetBatchMediaProducingJobResponseBodyEditingBatchJobSubJobList] = None,
        user_data: str = None,
    ):
        # The time when the job was complete.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.complete_time = complete_time
        # The time when the job was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The editing configurations. For more information, see [EditingConfig](~~2692547#1be9bba03b7qu~~).
        self.editing_config = editing_config
        # The extended information. This parameter contains the following fields:
        # 
        # ErrorCode: the error code of the main job.
        # 
        # ErrorMessage: the error message of the main job.
        self.extend = extend
        # The input configurations. For more information, see [InputConfig](~~2692547#2faed1559549n~~).
        self.input_config = input_config
        # The job ID.
        self.job_id = job_id
        self.job_type = job_type
        # The time when the job was last modified.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.modified_time = modified_time
        # The output configurations. For more information, see [OutputConfig](~~2692547#447b928fcbuoa~~).
        self.output_config = output_config
        # The job state. Valid values:
        # 
        # Init: The job is initialized.
        # 
        # Processing: The job is in progress.
        # 
        # Finished: The job is complete.
        self.status = status
        # The quick video production subjobs.
        self.sub_job_list = sub_job_list
        # The user-defined data, including the business and callback configurations. For more information, see [UserData](https://help.aliyun.com/document_detail/357745.html).
        self.user_data = user_data

    def validate(self):
        if self.sub_job_list:
            for k in self.sub_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.input_config is not None:
            result['InputConfig'] = self.input_config
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config
        if self.status is not None:
            result['Status'] = self.status
        result['SubJobList'] = []
        if self.sub_job_list is not None:
            for k in self.sub_job_list:
                result['SubJobList'].append(k.to_map() if k else None)
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EditingConfig') is not None:
            self.editing_config = m.get('EditingConfig')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('InputConfig') is not None:
            self.input_config = m.get('InputConfig')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputConfig') is not None:
            self.output_config = m.get('OutputConfig')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.sub_job_list = []
        if m.get('SubJobList') is not None:
            for k in m.get('SubJobList'):
                temp_model = GetBatchMediaProducingJobResponseBodyEditingBatchJobSubJobList()
                self.sub_job_list.append(temp_model.from_map(k))
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetBatchMediaProducingJobResponseBody(TeaModel):
    def __init__(
        self,
        editing_batch_job: GetBatchMediaProducingJobResponseBodyEditingBatchJob = None,
        request_id: str = None,
    ):
        # The information about the quick video production job.
        self.editing_batch_job = editing_batch_job
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.editing_batch_job:
            self.editing_batch_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_batch_job is not None:
            result['EditingBatchJob'] = self.editing_batch_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditingBatchJob') is not None:
            temp_model = GetBatchMediaProducingJobResponseBodyEditingBatchJob()
            self.editing_batch_job = temp_model.from_map(m['EditingBatchJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetBatchMediaProducingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBatchMediaProducingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBatchMediaProducingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCategoriesRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
        type: str = None,
    ):
        # The category ID. You can use one of the following methods to obtain the ID:
        # 
        # *   Log on to the [Intelligent Media Services (IMS) console](https://ims.console.aliyun.com) and choose **Media Asset Management** > **Category Management** to view the category ID.
        # *   View the value of CateId returned by the AddCategory operation that you called to create a category.
        # *   View the value of CateId returned by the GetCategories operation that you called to query a category.
        self.cate_id = cate_id
        # The page number. Default value: 1
        self.page_no = page_no
        # The number of entries per page. Valid values: 10 to 100.
        self.page_size = page_size
        # The sorting rule of results. Valid values:
        # 
        # \\- CreationTime:Desc (default): The results are sorted in reverse chronological order based on the creation time.
        # 
        # \\- CreationTime:Asc: The results are sorted in chronological order based on the creation time.
        self.sort_by = sort_by
        # The type of the category. Valid values: default and material. A value of default indicates audio, video, and image files. This is the default value. A value of material indicates short video materials.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodyCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        type: str = None,
    ):
        # The category ID.
        self.cate_id = cate_id
        # The category name.
        self.cate_name = cate_name
        # The level of the category. A value of **0** indicates a level-1 category, a value of **1** indicates a level-2 category, and a value of **2** indicates a level-3 category.
        self.level = level
        # The ID of the parent category.
        self.parent_id = parent_id
        # The type of the category. Valid values:
        # 
        # *   **default**: audio, video, and image files. This is the default value.
        # *   **material**: short video materials.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategoriesCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        sub_total: int = None,
        type: str = None,
    ):
        # The category ID.
        self.cate_id = cate_id
        # The category name.
        # 
        # *   The value can be up to 64 bytes in length.
        # *   The value is encoded in UTF-8.
        self.cate_name = cate_name
        # The level of the category. A value of **0** indicates a level-1 category, a value of **1** indicates a level-2 category, and a value of **2** indicates a level-3 category.
        self.level = level
        # The ID of the parent category.
        self.parent_id = parent_id
        # The total number of subcategories.
        self.sub_total = sub_total
        # The type of the category. Valid values:
        # 
        # *   **default**: audio, video, and image files. This is the default value.
        # *   **material**: short video materials.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategories(TeaModel):
    def __init__(
        self,
        category: List[GetCategoriesResponseBodySubCategoriesCategory] = None,
    ):
        self.category = category

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = GetCategoriesResponseBodySubCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class GetCategoriesResponseBody(TeaModel):
    def __init__(
        self,
        category: GetCategoriesResponseBodyCategory = None,
        request_id: str = None,
        sub_categories: GetCategoriesResponseBodySubCategories = None,
        sub_total: int = None,
    ):
        # The information about the category.
        self.category = category
        # The request ID.
        self.request_id = request_id
        # The subcategories in the category.
        self.sub_categories = sub_categories
        # The total number of subcategories.
        self.sub_total = sub_total

    def validate(self):
        if self.category:
            self.category.validate()
        if self.sub_categories:
            self.sub_categories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_categories is not None:
            result['SubCategories'] = self.sub_categories.to_map()
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = GetCategoriesResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubCategories') is not None:
            temp_model = GetCategoriesResponseBodySubCategories()
            self.sub_categories = temp_model.from_map(m['SubCategories'])
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        return self


class GetCategoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCategoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetChannelRequest(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
    ):
        # The name of the channel.
        # 
        # This parameter is required.
        self.channel_name = channel_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        return self


class GetChannelResponseBody(TeaModel):
    def __init__(
        self,
        channel: ChannelAssemblyChannel = None,
        request_id: str = None,
    ):
        # The channel information.
        self.channel = channel
        # **Request ID**\
        self.request_id = request_id

    def validate(self):
        if self.channel:
            self.channel.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            temp_model = ChannelAssemblyChannel()
            self.channel = temp_model.from_map(m['Channel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetContentAnalyzeConfigResponseBodyContentAnalyzeConfig(TeaModel):
    def __init__(
        self,
        auto: bool = None,
        save_type: str = None,
        template_id: str = None,
    ):
        self.auto = auto
        self.save_type = save_type
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto is not None:
            result['Auto'] = self.auto
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Auto') is not None:
            self.auto = m.get('Auto')
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetContentAnalyzeConfigResponseBody(TeaModel):
    def __init__(
        self,
        content_analyze_config: GetContentAnalyzeConfigResponseBodyContentAnalyzeConfig = None,
        request_id: str = None,
    ):
        self.content_analyze_config = content_analyze_config
        self.request_id = request_id

    def validate(self):
        if self.content_analyze_config:
            self.content_analyze_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_analyze_config is not None:
            result['ContentAnalyzeConfig'] = self.content_analyze_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentAnalyzeConfig') is not None:
            temp_model = GetContentAnalyzeConfigResponseBodyContentAnalyzeConfig()
            self.content_analyze_config = temp_model.from_map(m['ContentAnalyzeConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetContentAnalyzeConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetContentAnalyzeConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetContentAnalyzeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        subtype: int = None,
        template_id: str = None,
        type: int = None,
    ):
        # The template subtype.
        self.subtype = subtype
        # The template ID.
        self.template_id = template_id
        # The ID of the template type that is used to query the default template. This parameter is required if TemplateId is not specified.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCustomTemplateResponseBodyCustomTemplateFrontendHintTranscodeTemplateHint(TeaModel):
    def __init__(
        self,
        bitrate_control_type: str = None,
    ):
        self.bitrate_control_type = bitrate_control_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate_control_type is not None:
            result['BitrateControlType'] = self.bitrate_control_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BitrateControlType') is not None:
            self.bitrate_control_type = m.get('BitrateControlType')
        return self


class GetCustomTemplateResponseBodyCustomTemplateFrontendHint(TeaModel):
    def __init__(
        self,
        transcode_template_hint: GetCustomTemplateResponseBodyCustomTemplateFrontendHintTranscodeTemplateHint = None,
    ):
        self.transcode_template_hint = transcode_template_hint

    def validate(self):
        if self.transcode_template_hint:
            self.transcode_template_hint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.transcode_template_hint is not None:
            result['TranscodeTemplateHint'] = self.transcode_template_hint.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TranscodeTemplateHint') is not None:
            temp_model = GetCustomTemplateResponseBodyCustomTemplateFrontendHintTranscodeTemplateHint()
            self.transcode_template_hint = temp_model.from_map(m['TranscodeTemplateHint'])
        return self


class GetCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        frontend_hint: GetCustomTemplateResponseBodyCustomTemplateFrontendHint = None,
        is_default: bool = None,
        modified_time: str = None,
        status: str = None,
        subtype: int = None,
        subtype_name: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # The time when the template was created.
        self.create_time = create_time
        self.frontend_hint = frontend_hint
        # Indicates whether the template is the default template.
        self.is_default = is_default
        # The time when the template was last modified.
        self.modified_time = modified_time
        # The template state.
        self.status = status
        # The subtype ID of the template.
        self.subtype = subtype
        # The subtype name of the template.
        self.subtype_name = subtype_name
        # The template parameters.
        self.template_config = template_config
        # The template ID.
        self.template_id = template_id
        # The template name.
        self.template_name = template_name
        # The type ID of the template.
        self.type = type
        # The type name of the template.
        self.type_name = type_name

    def validate(self):
        if self.frontend_hint:
            self.frontend_hint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.frontend_hint is not None:
            result['FrontendHint'] = self.frontend_hint.to_map()
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FrontendHint') is not None:
            temp_model = GetCustomTemplateResponseBodyCustomTemplateFrontendHint()
            self.frontend_hint = temp_model.from_map(m['FrontendHint'])
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class GetCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        custom_template: GetCustomTemplateResponseBodyCustomTemplate = None,
        request_id: str = None,
    ):
        # The template information.
        self.custom_template = custom_template
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = GetCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomizedVoiceRequest(TeaModel):
    def __init__(
        self,
        voice_id: str = None,
    ):
        # The voice ID.
        self.voice_id = voice_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        return self


class GetCustomizedVoiceResponseBodyDataCustomizedVoice(TeaModel):
    def __init__(
        self,
        demo_audio_media_id: str = None,
        gender: str = None,
        scenario: str = None,
        voice_desc: str = None,
        voice_id: str = None,
        voice_name: str = None,
    ):
        # The media asset ID of the sample audio file.
        self.demo_audio_media_id = demo_audio_media_id
        # The gender. Valid values:
        # 
        # *   female
        # *   male
        self.gender = gender
        # The demonstration scenario.
        # 
        # Valid values:
        # 
        # *   **story**\
        # *   **interaction**\
        # *   **navigation**\
        self.scenario = scenario
        # The voice description.
        self.voice_desc = voice_desc
        # The voice ID.
        self.voice_id = voice_id
        # The voice name.
        self.voice_name = voice_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demo_audio_media_id is not None:
            result['DemoAudioMediaId'] = self.demo_audio_media_id
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.voice_desc is not None:
            result['VoiceDesc'] = self.voice_desc
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_name is not None:
            result['VoiceName'] = self.voice_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DemoAudioMediaId') is not None:
            self.demo_audio_media_id = m.get('DemoAudioMediaId')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('VoiceDesc') is not None:
            self.voice_desc = m.get('VoiceDesc')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceName') is not None:
            self.voice_name = m.get('VoiceName')
        return self


class GetCustomizedVoiceResponseBodyData(TeaModel):
    def __init__(
        self,
        customized_voice: GetCustomizedVoiceResponseBodyDataCustomizedVoice = None,
    ):
        # The personalized human voice.
        self.customized_voice = customized_voice

    def validate(self):
        if self.customized_voice:
            self.customized_voice.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customized_voice is not None:
            result['CustomizedVoice'] = self.customized_voice.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomizedVoice') is not None:
            temp_model = GetCustomizedVoiceResponseBodyDataCustomizedVoice()
            self.customized_voice = temp_model.from_map(m['CustomizedVoice'])
        return self


class GetCustomizedVoiceResponseBody(TeaModel):
    def __init__(
        self,
        data: GetCustomizedVoiceResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetCustomizedVoiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomizedVoiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomizedVoiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomizedVoiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomizedVoiceJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the human voice cloning job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetCustomizedVoiceJobResponseBodyDataCustomizedVoiceJob(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        gender: str = None,
        job_id: str = None,
        message: str = None,
        scenario: str = None,
        status: str = None,
        type: str = None,
        voice_desc: str = None,
        voice_id: str = None,
        voice_name: str = None,
    ):
        # The time when the job was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The gender. Valid values:
        # 
        # *   female
        # *   male
        self.gender = gender
        # The ID of the human voice cloning job.
        self.job_id = job_id
        # The status description.
        self.message = message
        # The scenario. Valid values:
        # 
        # *   story
        # *   interaction
        # *   navigation
        self.scenario = scenario
        # The job state. Valid values:
        # 
        # *   Initialization
        # *   AudioDetecting
        # *   PreTraining
        # *   Training
        # *   Success
        # *   Fail
        self.status = status
        # The type of the human voice cloning job. Valid values:
        # 
        # *   Basic
        # *   Standard
        self.type = type
        # The voice description.
        self.voice_desc = voice_desc
        # The voice ID.
        self.voice_id = voice_id
        # The voice name.
        self.voice_name = voice_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.gender is not None:
            result['Gender'] = self.gender
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.voice_desc is not None:
            result['VoiceDesc'] = self.voice_desc
        if self.voice_id is not None:
            result['VoiceId'] = self.voice_id
        if self.voice_name is not None:
            result['VoiceName'] = self.voice_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Gender') is not None:
            self.gender = m.get('Gender')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VoiceDesc') is not None:
            self.voice_desc = m.get('VoiceDesc')
        if m.get('VoiceId') is not None:
            self.voice_id = m.get('VoiceId')
        if m.get('VoiceName') is not None:
            self.voice_name = m.get('VoiceName')
        return self


class GetCustomizedVoiceJobResponseBodyData(TeaModel):
    def __init__(
        self,
        customized_voice_job: GetCustomizedVoiceJobResponseBodyDataCustomizedVoiceJob = None,
    ):
        # The information about the human voice cloning job.
        self.customized_voice_job = customized_voice_job

    def validate(self):
        if self.customized_voice_job:
            self.customized_voice_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customized_voice_job is not None:
            result['CustomizedVoiceJob'] = self.customized_voice_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomizedVoiceJob') is not None:
            temp_model = GetCustomizedVoiceJobResponseBodyDataCustomizedVoiceJob()
            self.customized_voice_job = temp_model.from_map(m['CustomizedVoiceJob'])
        return self


class GetCustomizedVoiceJobResponseBody(TeaModel):
    def __init__(
        self,
        data: GetCustomizedVoiceJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned if the request was successful.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetCustomizedVoiceJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomizedVoiceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomizedVoiceJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomizedVoiceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDefaultStorageLocationResponseBody(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        path: str = None,
        request_id: str = None,
        status: str = None,
        storage_type: str = None,
    ):
        self.bucket = bucket
        self.path = path
        self.request_id = request_id
        self.status = status
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.path is not None:
            result['Path'] = self.path
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetDefaultStorageLocationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDefaultStorageLocationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDefaultStorageLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDemonstrationForCustomizedVoiceJobRequest(TeaModel):
    def __init__(
        self,
        scenario: str = None,
    ):
        # The demonstration scenario.
        # 
        # Valid values:
        # 
        # *   **story**\
        # *   **interaction**\
        # *   **navigation**\
        # 
        # This parameter is required.
        self.scenario = scenario

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        return self


class GetDemonstrationForCustomizedVoiceJobResponseBodyDataDemonstrationList(TeaModel):
    def __init__(
        self,
        audio_id: int = None,
        demo_audio: str = None,
        text: str = None,
    ):
        # The sequence number of the text, which corresponds to the AduioRecordId parameter to be passed during audio check.
        self.audio_id = audio_id
        # The URL of the sample audio.
        # 
        # *   The value is an Object Storage Service (OSS) URL.
        # 
        #     **\
        # 
        #     **Note**: The URL expires in 12 hours.
        self.demo_audio = demo_audio
        # The text content to be read.
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_id is not None:
            result['AudioId'] = self.audio_id
        if self.demo_audio is not None:
            result['DemoAudio'] = self.demo_audio
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioId') is not None:
            self.audio_id = m.get('AudioId')
        if m.get('DemoAudio') is not None:
            self.demo_audio = m.get('DemoAudio')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class GetDemonstrationForCustomizedVoiceJobResponseBodyData(TeaModel):
    def __init__(
        self,
        demonstration_list: List[GetDemonstrationForCustomizedVoiceJobResponseBodyDataDemonstrationList] = None,
    ):
        # A list of 20 text entries to be read and the corresponding sample audio.
        self.demonstration_list = demonstration_list

    def validate(self):
        if self.demonstration_list:
            for k in self.demonstration_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DemonstrationList'] = []
        if self.demonstration_list is not None:
            for k in self.demonstration_list:
                result['DemonstrationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.demonstration_list = []
        if m.get('DemonstrationList') is not None:
            for k in m.get('DemonstrationList'):
                temp_model = GetDemonstrationForCustomizedVoiceJobResponseBodyDataDemonstrationList()
                self.demonstration_list.append(temp_model.from_map(k))
        return self


class GetDemonstrationForCustomizedVoiceJobResponseBody(TeaModel):
    def __init__(
        self,
        data: GetDemonstrationForCustomizedVoiceJobResponseBodyData = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The data returned.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetDemonstrationForCustomizedVoiceJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDemonstrationForCustomizedVoiceJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDemonstrationForCustomizedVoiceJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDemonstrationForCustomizedVoiceJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDynamicImageJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The job ID.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        # The OSS bucket.
        self.bucket = bucket
        # The OSS location.
        self.location = location
        # The OSS object.
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile = None,
        type: str = None,
    ):
        # The input file. If Type is set to OSS, the URL of an OSS object is returned. If Type is set to Media, the ID of a media asset is returned. The URL of an OSS object can be in one of the following formats:
        # 
        # 1.  OSS://bucket/object
        # 2.  http(s)://bucket.oss-[RegionId].aliyuncs.com/object
        # 
        # In the URL, bucket specifies an OSS bucket that resides in the same region as the job, and object specifies the object URL in OSS.
        self.media = media
        # The three key elements of OSS.
        self.oss_file = oss_file
        # The type of the input file. Valid values:
        # 
        # 1.  OSS: an Object Storage Service (OSS) object.
        # 2.  Media: a media asset.
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        # The OSS bucket.
        self.bucket = bucket
        # The OSS location.
        self.location = location
        # The OSS object.
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile = None,
        type: str = None,
    ):
        # The input file. If Type is set to OSS, the URL of an OSS object is returned. If Type is set to Media, the ID of a media asset is returned. The URL of an OSS object can be in one of the following formats:
        # 
        # 1.  OSS://bucket/object
        # 2.  http(s)://bucket.oss-[RegionId].aliyuncs.com/object In the URL, bucket specifies an OSS bucket that resides in the same region as the job, and object specifies the object URL in OSS.
        self.media = media
        # The three key elements of OSS.
        self.oss_file = oss_file
        # The type of the input file. Valid values: OSS: an OSS object. Media: a media asset.
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_time: str = None,
        finish_time: str = None,
        input: GetDynamicImageJobResponseBodyDynamicImageJobInput = None,
        job_id: str = None,
        message: str = None,
        modified_time: str = None,
        name: str = None,
        output: GetDynamicImageJobResponseBodyDynamicImageJobOutput = None,
        output_url: str = None,
        pipeline_id: str = None,
        status: str = None,
        submit_time: str = None,
        template_config: str = None,
        template_id: str = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        # Error codes
        self.code = code
        # The time when the job was created.
        self.create_time = create_time
        # The time when the job was complete.
        self.finish_time = finish_time
        # The input of the job.
        self.input = input
        # The job ID.
        self.job_id = job_id
        # The error message that is returned.
        self.message = message
        # The time when the job was last modified.
        self.modified_time = modified_time
        # The name of the job.
        self.name = name
        # The output of the job.
        self.output = output
        # The URL of the output animated image.
        self.output_url = output_url
        # The ID of the MPS queue to which the job was submitted.
        self.pipeline_id = pipeline_id
        # The state of the job.
        # 
        # Valid values:
        # 
        # *   Init: The job is submitted.
        # *   Success: The job is successful.
        # *   Fail: The job failed.
        self.status = status
        # The time when the job was submitted.
        self.submit_time = submit_time
        # The animation template configuration.
        self.template_config = template_config
        # The template ID.
        self.template_id = template_id
        # The request trigger source.
        # 
        # Valid values:
        # 
        # *   Console
        # *   Workflow
        # *   API
        self.trigger_source = trigger_source
        # The user-defined data.
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetDynamicImageJobResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_image_job: GetDynamicImageJobResponseBodyDynamicImageJob = None,
        request_id: str = None,
    ):
        # The information about the snapshot job.
        self.dynamic_image_job = dynamic_image_job
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.dynamic_image_job:
            self.dynamic_image_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_image_job is not None:
            result['DynamicImageJob'] = self.dynamic_image_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicImageJob') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJob()
            self.dynamic_image_job = temp_model.from_map(m['DynamicImageJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDynamicImageJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDynamicImageJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDynamicImageJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        request_source: str = None,
    ):
        # The ID of the online editing project.
        # 
        # This parameter is required.
        self.project_id = project_id
        # The ID of the request source. Valid values:
        # 
        # \\- OpenAPI (default): Timeline conversion is not performed.
        # 
        # \\- WebSDK: If you specify this value, the project timeline is automatically converted into the frontend style, and the materials in the timeline are associated with the project to enable preview by using frontend web SDKs.
        self.request_source = request_source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.request_source is not None:
            result['RequestSource'] = self.request_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RequestSource') is not None:
            self.request_source = m.get('RequestSource')
        return self


class GetEditingProjectResponseBodyProject(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        business_status: str = None,
        clips_param: str = None,
        cover_url: str = None,
        create_source: str = None,
        create_time: str = None,
        description: str = None,
        duration: int = None,
        modified_source: str = None,
        modified_time: str = None,
        project_id: str = None,
        project_type: str = None,
        status: str = None,
        template_id: str = None,
        template_type: str = None,
        timeline: str = None,
        timeline_convert_error_message: str = None,
        timeline_convert_status: str = None,
        title: str = None,
    ):
        # The business configuration of the project. This parameter can be ignored for general editing projects.
        self.business_config = business_config
        # The business status of the project. This parameter can be ignored for general editing projects. Valid values:
        # 
        # Reserving
        # 
        # ReservationCanceled
        # 
        # BroadCasting
        # 
        # LoadingFailed
        # 
        # LiveFinished
        self.business_status = business_status
        # The material parameter corresponding to the template, in the JSON format. If TemplateId is specified, ClipsParam must also be specified. For more information<props="china">, see [Create and use a regular template](https://help.aliyun.com/document_detail/328557.html) and [Create and use an advanced template](https://help.aliyun.com/document_detail/291418.html).
        self.clips_param = clips_param
        # The thumbnail URL of the online editing project.
        self.cover_url = cover_url
        # The method for creating the online editing project. Valid values:
        # 
        # \\- OpenAPI
        # 
        # \\- AliyunConsole
        # 
        # \\- WebSDK
        # 
        # \\- LiveEditingOpenAPI
        # 
        # \\- LiveEditingConsole
        self.create_source = create_source
        # The time when the online editing project was created.
        self.create_time = create_time
        # The description of the online editing project.
        self.description = description
        # The total duration of the online editing project.
        self.duration = duration
        # The method for editing the online editing project. Valid values:
        # 
        # \\- OpenAPI
        # 
        # \\- AliyunConsole
        # 
        # \\- WebSDK
        # 
        # \\- LiveEditingOpenAPI
        # 
        # \\- LiveEditingConsole
        self.modified_source = modified_source
        # The time when the online editing project was last modified.
        self.modified_time = modified_time
        # The ID of the online editing project.
        self.project_id = project_id
        # The type of the editing project. Default value: EditingProject. Valid values:
        # 
        # \\- EditingProject: a regular editing project.
        # 
        # \\- LiveEditingProject: a live stream editing project.
        self.project_type = project_type
        # The status of the online editing project. Valid values:
        # 
        # \\- Draft
        # 
        # \\- Editing
        # 
        # \\- Producing
        # 
        # \\- Produced
        # 
        # \\- ProduceFailed
        # 
        # \\- Deleted
        self.status = status
        # The template ID.
        self.template_id = template_id
        # The template type of the online editing project. Valid values:
        # 
        # \\- Timeline
        # 
        # \\- VETemplate
        self.template_type = template_type
        # The timeline of the online editing project.
        self.timeline = timeline
        # The error message returned if the project conversion failed. The error message displays the detailed information about the failure, and is returned only if the value of TimelineConvertStatus is ConvertFailed.
        self.timeline_convert_error_message = timeline_convert_error_message
        # The project conversion status. Conversion of an API-style timeline into a frontend-style timeline is an asynchronous process and takes effect only if RequestSource:WebSDK is specified.
        # 
        # \\- Unconverted
        # 
        # \\- Converting
        # 
        # \\- Converted
        # 
        # \\- ConvertFailed
        self.timeline_convert_status = timeline_convert_status
        # The title of the online editing project.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.timeline_convert_error_message is not None:
            result['TimelineConvertErrorMessage'] = self.timeline_convert_error_message
        if self.timeline_convert_status is not None:
            result['TimelineConvertStatus'] = self.timeline_convert_status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('TimelineConvertErrorMessage') is not None:
            self.timeline_convert_error_message = m.get('TimelineConvertErrorMessage')
        if m.get('TimelineConvertStatus') is not None:
            self.timeline_convert_status = m.get('TimelineConvertStatus')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetEditingProjectResponseBody(TeaModel):
    def __init__(
        self,
        project: GetEditingProjectResponseBodyProject = None,
        request_id: str = None,
    ):
        # The information about the online editing project.
        self.project = project
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = GetEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEditingProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
    ):
        # The ID of the online editing project.
        # 
        # This parameter is required.
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        live_url: str = None,
        stream_name: str = None,
    ):
        # The application name of the live stream.
        self.app_name = app_name
        # The domain name of the live stream.
        self.domain_name = domain_name
        # The URL of the live stream.
        self.live_url = live_url
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # The bitrate.
        self.bitrate = bitrate
        # The duration.
        self.duration = duration
        # The file name.
        self.file_name = file_name
        # The file size. Unit: bytes.
        self.file_size = file_size
        # The file status.
        self.file_status = file_status
        # The file type.
        self.file_type = file_type
        # The Object Storage Service (OSS) URL of the file.
        self.file_url = file_url
        # The container format.
        self.format_name = format_name
        # The height.
        self.height = height
        # The region in which the file resides.
        self.region = region
        # The width.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # The basic information of the file, such as the duration and size.
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # The business type of the media asset.
        self.business_type = business_type
        # The category of the media asset.
        self.category = category
        # The thumbnail URL of the media asset.
        self.cover_url = cover_url
        # The time when the media asset was created.
        self.create_time = create_time
        # The time when the media asset was deleted.
        self.deleted_time = deleted_time
        # The description of the media asset.
        self.description = description
        # The URL of the media asset in another service.
        self.input_url = input_url
        # The ID of the media asset.
        self.media_id = media_id
        # The tags of the media asset.
        self.media_tags = media_tags
        # The type of the media asset.
        self.media_type = media_type
        # The time when the media asset was last modified.
        self.modified_time = modified_time
        # The snapshots of the media asset.
        self.snapshots = snapshots
        # The source of the media asset.
        self.source = source
        # The sprite of the media asset
        self.sprite_images = sprite_images
        # The status of the media asset.
        self.status = status
        # The title of the media asset.
        self.title = title
        # The transcoding status of the media asset.
        # 
        # Valid values:
        # 
        # *   TranscodeSuccess: transcoding completed.
        # *   TranscodeFailed: transcoding failed.
        # *   Init: initializing.
        # *   Transcoding: transcoding in progress.
        self.transcode_status = transcode_status
        # The user data.
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # The information about the file.
        self.file_info_list = file_info_list
        # The basic information of the media asset.
        self.media_basic_info = media_basic_info
        # The ID of the media asset.
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        live_materials: List[GetEditingProjectMaterialsResponseBodyLiveMaterials] = None,
        media_infos: List[GetEditingProjectMaterialsResponseBodyMediaInfos] = None,
        project_id: str = None,
        project_materials: List[str] = None,
        request_id: str = None,
    ):
        # The materials associated with the live stream.
        self.live_materials = live_materials
        # The media assets that meet the specified conditions.
        self.media_infos = media_infos
        # The project ID.
        self.project_id = project_id
        # The materials associated with the editing project. A live stream editing project will be associated with a regular editing project after the live streaming ends.
        self.project_materials = project_materials
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = GetEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEventCallbackResponseBody(TeaModel):
    def __init__(
        self,
        auth_key: str = None,
        auth_switch: str = None,
        callback_queue_name: str = None,
        callback_type: str = None,
        callback_url: str = None,
        event_type_list: str = None,
        request_id: str = None,
    ):
        # The authentication key. This parameter is returned only for HTTP callbacks.
        self.auth_key = auth_key
        # Specifies whether callback authentication is enabled. This parameter is returned only for **HTTP** callbacks. Valid values:
        # 
        # *   **on**\
        # *   **off**\
        self.auth_switch = auth_switch
        # The name of the Simple Message Queue (SMQ) queue to which callback messages are sent.
        self.callback_queue_name = callback_queue_name
        # The callback method. Valid values:
        # 
        # *   **HTTP**\
        # *   **MNS**\
        self.callback_type = callback_type
        # The callback URL to which event notifications are sent.
        self.callback_url = callback_url
        # The type of the callback event. Multiple values are separated with commas (,). For more information about callback event types, see [Event notification content](https://help.aliyun.com/document_detail/610204.html).
        self.event_type_list = event_type_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auth_switch is not None:
            result['AuthSwitch'] = self.auth_switch
        if self.callback_queue_name is not None:
            result['CallbackQueueName'] = self.callback_queue_name
        if self.callback_type is not None:
            result['CallbackType'] = self.callback_type
        if self.callback_url is not None:
            result['CallbackURL'] = self.callback_url
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AuthSwitch') is not None:
            self.auth_switch = m.get('AuthSwitch')
        if m.get('CallbackQueueName') is not None:
            self.callback_queue_name = m.get('CallbackQueueName')
        if m.get('CallbackType') is not None:
            self.callback_type = m.get('CallbackType')
        if m.get('CallbackURL') is not None:
            self.callback_url = m.get('CallbackURL')
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEventCallbackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEventCallbackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEventCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotwordLibraryRequest(TeaModel):
    def __init__(
        self,
        hotword_library_id: str = None,
    ):
        # This parameter is required.
        self.hotword_library_id = hotword_library_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotword_library_id is not None:
            result['HotwordLibraryId'] = self.hotword_library_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HotwordLibraryId') is not None:
            self.hotword_library_id = m.get('HotwordLibraryId')
        return self


class GetHotwordLibraryResponseBody(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        description: str = None,
        hotword_library_id: str = None,
        hotwords: List[Hotword] = None,
        name: str = None,
        request_id: str = None,
        usage_scenario: str = None,
    ):
        self.creation_time = creation_time
        self.description = description
        self.hotword_library_id = hotword_library_id
        self.hotwords = hotwords
        self.name = name
        # Id of the request
        self.request_id = request_id
        self.usage_scenario = usage_scenario

    def validate(self):
        if self.hotwords:
            for k in self.hotwords:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.hotword_library_id is not None:
            result['HotwordLibraryId'] = self.hotword_library_id
        result['Hotwords'] = []
        if self.hotwords is not None:
            for k in self.hotwords:
                result['Hotwords'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.usage_scenario is not None:
            result['UsageScenario'] = self.usage_scenario
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HotwordLibraryId') is not None:
            self.hotword_library_id = m.get('HotwordLibraryId')
        self.hotwords = []
        if m.get('Hotwords') is not None:
            for k in m.get('Hotwords'):
                temp_model = Hotword()
                self.hotwords.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UsageScenario') is not None:
            self.usage_scenario = m.get('UsageScenario')
        return self


class GetHotwordLibraryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotwordLibraryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotwordLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingIndexFileRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        project_id: str = None,
        stream_name: str = None,
    ):
        # The application name of the live stream.
        self.app_name = app_name
        # The domain name of the live stream.
        self.domain_name = domain_name
        # The ID of the live stream editing project.
        self.project_id = project_id
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingIndexFileResponseBody(TeaModel):
    def __init__(
        self,
        index_file: str = None,
        request_id: str = None,
    ):
        # The URL of the index file.
        self.index_file = index_file
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_file is not None:
            result['IndexFile'] = self.index_file
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IndexFile') is not None:
            self.index_file = m.get('IndexFile')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveEditingIndexFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetLiveEditingIndexFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveEditingIndexFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # The ID of the live editing job.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        stream_name: str = None,
    ):
        # The name of the application to which the live stream belongs.
        self.app_name = app_name
        # The domain name of the live stream.
        self.domain_name = domain_name
        # The name of the live stream.
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
    ):
        # The editing mode. Default value: Accurate.
        self.mode = mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        file_name: str = None,
        height: int = None,
        media_url: str = None,
        storage_location: str = None,
        vod_template_group_id: str = None,
        width: int = None,
    ):
        # The bitrate of the output file. Unit: Kbit/s. You can leave this parameter empty. The default value is the maximum bitrate of the input materials.
        self.bitrate = bitrate
        # If OutputMediaTarget is set to vod-media, this parameter indicates the file name of the output file. The value contains the file name extension but not the path.
        self.file_name = file_name
        # The height of the output file. You can leave this parameter empty. The default value is the maximum height of the input materials.
        self.height = height
        # The URL of the output file.
        self.media_url = media_url
        # If OutputMediaTarget is set to vod-media, this parameter indicates the storage location of the media asset in ApsaraVideo VOD. The storage location is the path of the file in ApsaraVideo VOD, excluding the prefix http://. Example: outin-xxxxxx.oss-cn-shanghai.aliyuncs.com.
        self.storage_location = storage_location
        # The ID of the VOD transcoding template group. If VOD transcoding is not required, set the value to VOD_NO_TRANSCODE.
        self.vod_template_group_id = vod_template_group_id
        # The width of the output file. You can leave this parameter empty. The default value is the maximum width of the input materials.
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.vod_template_group_id is not None:
            result['VodTemplateGroupId'] = self.vod_template_group_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('VodTemplateGroupId') is not None:
            self.vod_template_group_id = m.get('VodTemplateGroupId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJob(TeaModel):
    def __init__(
        self,
        clips: str = None,
        code: str = None,
        complete_time: str = None,
        creation_time: str = None,
        job_id: str = None,
        live_stream_config: GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig = None,
        media_id: str = None,
        media_produce_config: GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig = None,
        media_url: str = None,
        message: str = None,
        modified_time: str = None,
        output_media_config: GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig = None,
        project_id: str = None,
        status: str = None,
        user_data: str = None,
    ):
        # The clips.
        self.clips = clips
        # The response code. Note: Pay attention to this parameter if the job failed.
        self.code = code
        # The time when the live editing job was completed. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.complete_time = complete_time
        # The time when the live editing job was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time
        # The ID of the live editing job.
        self.job_id = job_id
        # The live editing configurations.
        self.live_stream_config = live_stream_config
        # The media asset ID of the output file.
        self.media_id = media_id
        # The production configurations.
        self.media_produce_config = media_produce_config
        # The URL of the output file.
        self.media_url = media_url
        # The returned message. Note: Pay attention to this parameter if the job failed.
        self.message = message
        # The time when the live editing job was last modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.modified_time = modified_time
        # The storage configurations of the output file.
        self.output_media_config = output_media_config
        # The ID of the live editing project.
        self.project_id = project_id
        # The state of the live editing job. Valid values: Init, Queuing, Processing, Success, and Failed.
        self.status = status
        # The user-defined data.
        self.user_data = user_data

    def validate(self):
        if self.live_stream_config:
            self.live_stream_config.validate()
        if self.media_produce_config:
            self.media_produce_config.validate()
        if self.output_media_config:
            self.output_media_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips is not None:
            result['Clips'] = self.clips
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.live_stream_config is not None:
            result['LiveStreamConfig'] = self.live_stream_config.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_produce_config is not None:
            result['MediaProduceConfig'] = self.media_produce_config.to_map()
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_media_config is not None:
            result['OutputMediaConfig'] = self.output_media_config.to_map()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clips') is not None:
            self.clips = m.get('Clips')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('LiveStreamConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig()
            self.live_stream_config = temp_model.from_map(m['LiveStreamConfig'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaProduceConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig()
            self.media_produce_config = temp_model.from_map(m['MediaProduceConfig'])
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputMediaConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig()
            self.output_media_config = temp_model.from_map(m['OutputMediaConfig'])
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetLiveEditingJobResponseBody(TeaModel):
    def __init__(
        self,
        live_editing_job: GetLiveEditingJobResponseBodyLiveEditingJob = None,
        request_id: str = None,
    ):
        # The information about the live editing job.
        self.live_editing_job = live_editing_job
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.live_editing_job:
            self.live_editing_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_editing_job is not None:
            result['LiveEditingJob'] = self.live_editing_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveEditingJob') is not None:
   