import React, { memo } from 'react'

interface PropsLogoTobiko extends React.SVGAttributes<SVGAElement> {}

function LogoTobiko({ style, className }: PropsLogoTobiko): JSX.Element {
  return (
    <svg
      style={style}
      className={className}
      role="img"
      aria-labelledby="tobikoDataTitle"
      viewBox="0 0 194 56"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title id="tobikoDataTitle">Tobiko Data logo</title>
      <path
        d="M99.6773 18.8812H90.4835V43H85.3891V18.8812H76.1953V14.4236H99.6773V18.8812ZM116.433 32.5724C116.433 39.0598 112.254 43.4378 106.364 43.4378C100.473 43.4378 96.2943 39.0598 96.2943 32.5724C96.2943 26.085 100.473 21.707 106.364 21.707C112.254 21.707 116.433 26.085 116.433 32.5724ZM101.11 32.5724C101.11 36.831 103.14 39.418 106.364 39.418C109.587 39.418 111.617 36.831 111.617 32.5724C111.617 28.3138 109.587 25.7268 106.364 25.7268C103.14 25.7268 101.11 28.3138 101.11 32.5724ZM130.538 43.4378C127.832 43.4378 125.842 42.3632 124.529 40.811V43H119.753V14.4236H124.529V24.3338C125.842 22.7816 127.832 21.707 130.538 21.707C136.389 21.707 139.732 26.6422 139.732 32.5724C139.732 38.5026 136.389 43.4378 130.538 43.4378ZM124.409 31.9754V33.2092C124.409 37.0698 126.638 39.2588 129.583 39.2588C133.046 39.2588 134.916 36.5524 134.916 32.5724C134.916 28.5924 133.046 25.886 129.583 25.886C126.638 25.886 124.409 28.0352 124.409 31.9754ZM142.945 19.319V14.4236H147.88V19.319H142.945ZM147.801 22.105V43H143.025V22.105H147.801ZM157.197 14.4236V30.9008L165.237 22.105H171.088L163.207 30.2242L171.724 43H166.192L159.944 33.5674L157.197 36.3534V43H152.421V14.4236H157.197ZM191.565 32.5724C191.565 39.0598 187.386 43.4378 181.496 43.4378C175.605 43.4378 171.426 39.0598 171.426 32.5724C171.426 26.085 175.605 21.707 181.496 21.707C187.386 21.707 191.565 26.085 191.565 32.5724ZM176.242 32.5724C176.242 36.831 178.272 39.418 181.496 39.418C184.719 39.418 186.749 36.831 186.749 32.5724C186.749 28.3138 184.719 25.7268 181.496 25.7268C178.272 25.7268 176.242 28.3138 176.242 32.5724Z"
        fill="#0D0D0D"
        className="fill-prose"
      />
      <path
        d="M7.59874 35.2C11.5752 35.2 14.7987 31.9765 14.7987 28C14.7987 24.0236 11.5752 20.8 7.59874 20.8C3.62229 20.8 0.398743 24.0236 0.398743 28C0.398743 31.9765 3.62229 35.2 7.59874 35.2Z"
        fill="#F74808"
      />
      <path
        d="M10.7992 15.2928C14.378 15.2928 17.2792 12.3916 17.2792 8.81276C17.2792 5.23397 14.378 2.33276 10.7992 2.33276C7.22041 2.33276 4.31921 5.23397 4.31921 8.81276C4.31921 12.3916 7.22041 15.2928 10.7992 15.2928Z"
        fill="#F74808"
      />
      <path
        d="M10.7992 53.6929C14.378 53.6929 17.2792 50.7917 17.2792 47.2129C17.2792 43.6341 14.378 40.7329 10.7992 40.7329C7.22041 40.7329 4.31921 43.6341 4.31921 47.2129C4.31921 50.7917 7.22041 53.6929 10.7992 53.6929Z"
        fill="#F74808"
      />
      <path
        d="M36.2016 28C36.2016 31.9765 32.978 35.2 29.0016 35.2C25.0251 35.2 21.8016 31.9765 21.8016 28C21.8016 24.0236 25.0251 20.8 29.0016 20.8C32.978 20.8 36.2016 24.0236 36.2016 28Z"
        fill="#F74808"
      />
      <path
        d="M36.2016 7.2C36.2016 11.1764 32.978 14.4 29.0016 14.4C25.0251 14.4 21.8016 11.1764 21.8016 7.2C21.8016 3.22356 25.0251 0 29.0016 0C32.978 0 36.2016 3.22356 36.2016 7.2Z"
        fill="#F74808"
      />
      <path
        d="M36.2016 48.7999C36.2016 52.7763 32.978 55.9999 29.0016 55.9999C25.0251 55.9999 21.8016 52.7763 21.8016 48.7999C21.8016 44.8234 25.0251 41.5999 29.0016 41.5999C32.978 41.5999 36.2016 44.8234 36.2016 48.7999Z"
        fill="#F74808"
      />
      <path
        d="M50.4054 35.2C54.3818 35.2 57.6054 31.9765 57.6054 28C57.6054 24.0236 54.3818 20.8 50.4054 20.8C46.4289 20.8 43.2054 24.0236 43.2054 28C43.2054 31.9765 46.4289 35.2 50.4054 35.2Z"
        fill="#F74808"
      />
      <path
        d="M47.2053 15.2928C50.7841 15.2928 53.6853 12.3916 53.6853 8.81276C53.6853 5.23397 50.7841 2.33276 47.2053 2.33276C43.6265 2.33276 40.7253 5.23397 40.7253 8.81276C40.7253 12.3916 43.6265 15.2928 47.2053 15.2928Z"
        fill="#F74808"
      />
      <path
        d="M47.2053 53.6929C50.7841 53.6929 53.6853 50.7917 53.6853 47.2129C53.6853 43.6341 50.7841 40.7329 47.2053 40.7329C43.6265 40.7329 40.7253 43.6341 40.7253 47.2129C40.7253 50.7917 43.6265 53.6929 47.2053 53.6929Z"
        fill="#F74808"
      />
    </svg>
  )
}

export default memo(LogoTobiko)
