/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.ZeroCopyInput;

public class BufferedStreamZeroCopyInput
implements ZeroCopyInput {
    final InputStream underlying;
    final byte[] buffer;

    public BufferedStreamZeroCopyInput(InputStream input, int bufferSize) {
        this(input, new byte[bufferSize]);
    }

    BufferedStreamZeroCopyInput(InputStream input, byte[] buffer) {
        if (buffer.length == 0) {
            throw new IllegalArgumentException("Buffer must be nonempty");
        }
        this.underlying = input;
        this.buffer = buffer;
    }

    @Override
    public boolean next(BufferReference out) {
        try {
            int totalRead;
            int read;
            for (totalRead = 0; totalRead < this.buffer.length && (read = this.underlying.read(this.buffer, totalRead, this.buffer.length - totalRead)) != -1; totalRead += read) {
            }
            if (totalRead == 0) {
                return false;
            }
            out.setBuffer(this.buffer);
            out.setOffset(0);
            out.setLength(totalRead);
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

