/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.VarintUtils;

public class YsonBinaryWriter
implements ClosableYsonConsumer {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final OutputStream output;
    private final byte[] buffer;
    final int limit;
    private int position = 0;
    private boolean firstItem = true;

    public YsonBinaryWriter(OutputStream output) {
        this(output, 4096);
    }

    public YsonBinaryWriter(OutputStream output, int bufferSize) {
        this.output = output;
        this.limit = Math.max(bufferSize, 16);
        this.buffer = new byte[this.limit];
    }

    @Override
    public void close() {
        try {
            this.doFlush();
            this.output.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onString(byte[] value, int offset, int length) {
        try {
            this.flushIfNotAvailable(6);
            this.buffer[this.position++] = 1;
            this.writeSInt32Unchecked(length);
            this.writeRawBytesChecked(Arrays.copyOfRange(value, offset, offset + length));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onInteger(long value) {
        try {
            this.flushIfNotAvailable(11);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.buffer[this.position++] = 2;
        this.writeSInt64Unchecked(value);
    }

    @Override
    public void onUnsignedInteger(long value) {
        try {
            this.flushIfNotAvailable(11);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.buffer[this.position++] = 6;
        this.writeUInt64Unchecked(value);
    }

    @Override
    public void onDouble(double value) {
        try {
            this.flushIfNotAvailable(9);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.buffer[this.position++] = 3;
        this.writeDoubleUnchecked(value);
    }

    @Override
    public void onBoolean(boolean value) {
        try {
            this.writeByteChecked(value ? (byte)5 : 4);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onEntity() {
        try {
            this.writeByteChecked((byte)35);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onBeginList() {
        try {
            this.writeByteChecked((byte)91);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = true;
    }

    @Override
    public void onListItem() {
        try {
            this.writeItemSeparator();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onEndList() {
        try {
            this.writeByteChecked((byte)93);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = false;
    }

    @Override
    public void onBeginMap() {
        try {
            this.writeByteChecked((byte)123);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = true;
    }

    @Override
    public void onKeyedItem(byte[] key, int offset, int length) {
        try {
            this.writeItemSeparator();
            this.onString(key, offset, length);
            this.writeByteChecked((byte)61);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void onEndMap() {
        try {
            this.writeByteChecked((byte)125);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = false;
    }

    @Override
    public void onBeginAttributes() {
        try {
            this.writeByteChecked((byte)60);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = true;
    }

    @Override
    public void onEndAttributes() {
        try {
            this.writeByteChecked((byte)62);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.firstItem = false;
    }

    public void flush() {
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeItemSeparator() throws IOException {
        if (this.firstItem) {
            this.firstItem = false;
        } else {
            this.writeByteChecked((byte)59);
        }
    }

    private void doFlush() throws IOException {
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    private void flushIfNotAvailable(int requiredSize) throws IOException {
        if (this.limit - this.position < requiredSize) {
            this.doFlush();
        }
    }

    private void writeSInt32Unchecked(int value) {
        this.writeUInt32Unchecked(VarintUtils.encodeZigZag32(value));
    }

    private void writeUInt32Unchecked(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.buffer[this.position++] = (byte)value;
                return;
            }
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    private void writeSInt64Unchecked(long value) {
        this.writeUInt64Unchecked(VarintUtils.encodeZigZag64(value));
    }

    private void writeUInt64Unchecked(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.buffer[this.position++] = (byte)value;
                return;
            }
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
    }

    private void writeDoubleUnchecked(double value) {
        long bits = Double.doubleToLongBits(value);
        this.buffer[this.position++] = (byte)(bits & 0xFFL);
        this.buffer[this.position++] = (byte)(bits >> 8 & 0xFFL);
        this.buffer[this.position++] = (byte)(bits >> 16 & 0xFFL);
        this.buffer[this.position++] = (byte)(bits >> 24 & 0xFFL);
        this.buffer[this.position++] = (byte)((int)(bits >> 32) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(bits >> 40) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(bits >> 48) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(bits >> 56) & 0xFF);
    }

    private void writeRawBytesChecked(byte[] value) throws IOException {
        int length = value.length;
        int offset = 0;
        if (this.limit - this.position >= length) {
            System.arraycopy(value, offset, this.buffer, this.position, length);
            this.position += length;
        } else {
            int bytesWritten = this.limit - this.position;
            System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
            offset += bytesWritten;
            this.position = this.limit;
            this.doFlush();
            if ((length -= bytesWritten) <= this.limit) {
                System.arraycopy(value, offset, this.buffer, 0, length);
                this.position = length;
            } else {
                this.output.write(value, offset, length);
            }
        }
    }

    private void writeByteChecked(byte b) throws IOException {
        if (this.position == this.limit) {
            this.doFlush();
        }
        this.buffer[this.position++] = b;
    }
}

