/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.StreamReader;
import tech.ytsaurus.yson.VarintUtils;
import tech.ytsaurus.yson.YsonError;
import tech.ytsaurus.yson.YsonToken;

class YsonLexer {
    static final char[] NAN_LITERAL = "%nan".toCharArray();
    static final char[] FALSE_LITERAL = "%false".toCharArray();
    static final char[] TRUE_LITERAL = "%true".toCharArray();
    static final char[] INF_LITERAL = "%inf".toCharArray();
    static final char[] PLUS_INF_LITERAL = "%+inf".toCharArray();
    static final char[] MINUS_INF_LITERAL = "%-inf".toCharArray();
    private final StreamReader reader;
    @Nullable
    private Byte lookahead = null;

    YsonLexer(byte[] buffer) {
        this.reader = new StreamReader(buffer);
    }

    public YsonToken getNextToken() {
        Byte ch = this.peekNextByte();
        while (ch != null) {
            switch (ch) {
                case 1: {
                    this.readNextByte();
                    return YsonToken.stringValue(this.readBinaryString());
                }
                case 2: {
                    this.readNextByte();
                    long v = this.parseInt64();
                    return YsonToken.int64Value(v);
                }
                case 6: {
                    this.readNextByte();
                    return YsonToken.uint64Value(this.parseUint64());
                }
                case 3: {
                    this.readNextByte();
                    return YsonToken.doubleValue(this.parseDouble());
                }
                case 4: {
                    this.readNextByte();
                    return YsonToken.booleanValue(false);
                }
                case 5: {
                    this.readNextByte();
                    return YsonToken.booleanValue(true);
                }
                case 37: {
                    return this.parsePercentToken();
                }
                case 35: {
                    this.readNextByte();
                    return YsonToken.entityValue();
                }
            }
            if (ch == 95 || ch == 34 || Character.isAlphabetic(ch.byteValue())) {
                return YsonToken.stringValue(this.parseString());
            }
            if (ch == 43 || ch == 45 || Character.isDigit(ch.byteValue())) {
                return this.parseNumericToken(ch);
            }
            if (Character.isWhitespace(ch.byteValue())) {
                this.readNextByte();
                ch = this.peekNextByte();
                continue;
            }
            this.readNextByte();
            return YsonToken.fromSymbol(ch);
        }
        return YsonToken.endOfStream();
    }

    private YsonToken parseNumericToken(byte firstByte) {
        Byte maybeByte;
        int numberType;
        this.readNextByte();
        boolean int64Type = false;
        boolean uint64Type = true;
        int doubleType = 2;
        if (48 <= firstByte && firstByte <= 57 || firstByte == 45 || firstByte == 43) {
            numberType = 0;
        } else if (firstByte == 46) {
            numberType = 2;
        } else {
            throw new YsonError("Numeric byte was expected, but got: " + firstByte);
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)firstByte);
        while ((maybeByte = this.peekNextByte()) != null) {
            byte b = maybeByte;
            if (b >= 48 && b <= 57 || b == 45 || b == 43) {
                sb.append((char)b);
                this.readNextByte();
                continue;
            }
            if (b == 46 || b == 101 || b == 69) {
                sb.append((char)b);
                numberType = 2;
                this.readNextByte();
                continue;
            }
            if (b != 117) break;
            sb.append((char)b);
            numberType = 1;
            this.readNextByte();
        }
        switch (numberType) {
            case 0: {
                long value;
                String text = sb.toString();
                try {
                    value = Long.parseLong(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing int64 literal: " + text, e);
                }
                return YsonToken.int64Value(value);
            }
            case 1: {
                long value;
                sb.deleteCharAt(sb.length() - 1);
                String text = sb.toString();
                try {
                    value = Long.parseUnsignedLong(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing uint64 literal " + text, e);
                }
                return YsonToken.uint64Value(value);
            }
            case 2: {
                double value;
                String text = sb.toString();
                try {
                    value = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing double literal " + text, e);
                }
                return YsonToken.doubleValue(value);
            }
        }
        throw new YsonError("Unexpected number type " + numberType);
    }

    private YsonToken parsePercentToken() {
        byte ch = this.reader.readByte();
        switch (ch) {
            case 110: {
                this.verifyLiteral(2, NAN_LITERAL);
                return YsonToken.doubleValue(Double.NaN);
            }
            case 116: {
                this.verifyLiteral(2, TRUE_LITERAL);
                return YsonToken.booleanValue(true);
            }
            case 102: {
                this.verifyLiteral(2, FALSE_LITERAL);
                return YsonToken.booleanValue(false);
            }
            case 105: {
                this.verifyLiteral(2, INF_LITERAL);
                return YsonToken.doubleValue(Double.POSITIVE_INFINITY);
            }
            case 43: {
                this.verifyLiteral(2, PLUS_INF_LITERAL);
                return YsonToken.doubleValue(Double.POSITIVE_INFINITY);
            }
            case 45: {
                this.verifyLiteral(2, MINUS_INF_LITERAL);
                return YsonToken.doubleValue(Double.NEGATIVE_INFINITY);
            }
        }
        throw new YsonError("Unknown percent literal");
    }

    private void verifyLiteral(int startIndex, char[] literal) {
        for (int i = startIndex; i < literal.length; ++i) {
            byte c = this.reader.readByte();
            if (literal[i] == c) continue;
            throw new YsonError(String.format("Bad yson literal: %s", String.copyValueOf(literal, 0, i) + (char)c));
        }
    }

    private long parseInt64() {
        long uint = this.reader.readVarUint64();
        return VarintUtils.decodeZigZag64(uint);
    }

    private long parseUint64() {
        return this.reader.readVarUint64();
    }

    private double parseDouble() {
        long bits = this.reader.readFixed64();
        return Double.longBitsToDouble(bits);
    }

    private String parseString() {
        Byte ch = this.peekNextByte();
        if (ch == null) {
            throw new YsonError("Premature end-of-stream while expecting string literal in Yson");
        }
        if (ch == 1) {
            return this.readBinaryString();
        }
        if (ch == 34) {
            return this.readQuotedString();
        }
        if (ch != 95 && ch != 37 && !Character.isAlphabetic(ch.byteValue())) {
            throw new YsonError(String.format("Expecting string literal but found %s in Yson", ch));
        }
        return this.readUnquotedString();
    }

    private String readBinaryString() {
        BufferReference ref = new BufferReference();
        this.readBinaryString(ref);
        return new String(Arrays.copyOfRange(ref.getBuffer(), ref.getOffset(), ref.getOffset() + ref.getLength()), StandardCharsets.UTF_8);
    }

    private void readBinaryString(BufferReference bufferReference) {
        long stringLength = this.readSInt64();
        if (stringLength < 0L) {
            throw new YsonError(String.format("Yson string length is negative: %d", stringLength));
        }
        if (stringLength > Integer.MAX_VALUE) {
            throw new YsonError(String.format("Yson string length exceeds limit: %d > %d", stringLength, Integer.MAX_VALUE));
        }
        this.reader.readBytes((int)stringLength, bufferReference);
    }

    private long readSInt64() {
        long uint = this.reader.readVarUint64();
        return VarintUtils.decodeZigZag64(uint);
    }

    private String readQuotedString() {
        this.expectByte((byte)34);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        boolean pendingNextByte = false;
        while (true) {
            Byte ch;
            if ((ch = this.readNextByte()) == null) {
                throw new YsonError("Premature end-of-stream while reading string literal in Yson");
            }
            if (ch == 34 && !pendingNextByte) break;
            result.write(ch.byteValue());
            if (pendingNextByte) {
                pendingNextByte = false;
                continue;
            }
            if (ch != 92) continue;
            pendingNextByte = true;
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    private String readUnquotedString() {
        Byte ch;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((ch = this.peekNextByte()) != null && (Character.isAlphabetic(ch.byteValue()) || Character.isDigit(ch.byteValue()) || List.of(Byte.valueOf((byte)95), Byte.valueOf((byte)37), Byte.valueOf((byte)45), Byte.valueOf((byte)46)).contains(ch))) {
            this.readNextByte();
            result.write(ch.byteValue());
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    private void expectByte(byte expected) {
        Byte ch = this.readNextByte();
        if (ch == null) {
            throw new YsonError(String.format("Premature end-of-stream expecting %s in Yson", ch));
        }
        if (ch != expected) {
            throw new YsonError(String.format("Found '%s' while expecting '%s' in Yson", ch, expected));
        }
    }

    @Nullable
    private Byte peekNextByte() {
        if (this.lookahead != null) {
            return this.lookahead;
        }
        int ch = this.reader.tryReadByte();
        if (ch == Integer.MAX_VALUE) {
            return null;
        }
        this.lookahead = (byte)ch;
        return this.lookahead;
    }

    @Nullable
    private Byte readNextByte() {
        int ch;
        Object result = this.lookahead == null ? ((ch = this.reader.tryReadByte()) == Integer.MAX_VALUE ? null : Byte.valueOf((byte)ch)) : this.lookahead;
        this.lookahead = null;
        return result;
    }
}

