/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.YsonTextUtils;

public class YsonTextWriter
implements ClosableYsonConsumer {
    private static final int BUFFER_SIZE = 256;
    private final Writer writer;
    private boolean firstItem = false;
    private int depth = 0;
    private final char[] buffer = new char[256];

    public YsonTextWriter(StringBuilder builder) {
        this(new StringBuilderWriterAdapter(builder));
    }

    public YsonTextWriter(Writer writer) {
        this.writer = writer;
    }

    public YsonTextWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void endNode() {
        if (this.depth > 0) {
            this.write(59);
        }
    }

    @Override
    public void onInteger(long value) {
        this.write(Long.toString(value));
        this.endNode();
    }

    @Override
    public void onUnsignedInteger(long value) {
        this.write(Long.toUnsignedString(value));
        this.write("u");
        this.endNode();
    }

    @Override
    public void onBoolean(boolean value) {
        this.write(value ? "%true" : "%false");
        this.endNode();
    }

    @Override
    public void onDouble(double value) {
        if (Double.isFinite(value)) {
            this.write(Double.toString(value));
        } else if (Double.isNaN(value)) {
            this.write("%nan");
        } else if (value == Double.POSITIVE_INFINITY) {
            this.write("%+inf");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.write("%-inf");
        } else {
            throw new IllegalStateException("Unexpected double: " + value);
        }
        this.endNode();
    }

    private void writeStringScalar(byte[] bytes, int offset, int length) {
        this.write(34);
        this.appendQuotedBytes(Arrays.copyOfRange(bytes, offset, offset + length));
        this.write(34);
    }

    @Override
    public void onString(byte[] bytes, int offset, int length) {
        this.writeStringScalar(bytes, offset, length);
        this.endNode();
    }

    @Override
    public void onString(String str) {
        this.write(34);
        this.appendQuotedBytes(str.getBytes(StandardCharsets.UTF_8));
        this.write(34);
        this.endNode();
    }

    @Override
    public void onEntity() {
        this.write(35);
        this.endNode();
    }

    @Override
    public void onListItem() {
        this.firstItem = false;
    }

    @Override
    public void onBeginList() {
        ++this.depth;
        this.firstItem = true;
        this.write(91);
    }

    @Override
    public void onEndList() {
        --this.depth;
        this.firstItem = false;
        this.write(93);
        this.endNode();
    }

    @Override
    public void onBeginAttributes() {
        ++this.depth;
        this.firstItem = true;
        this.write(60);
    }

    @Override
    public void onEndAttributes() {
        --this.depth;
        this.firstItem = false;
        this.write(62);
    }

    @Override
    public void onBeginMap() {
        ++this.depth;
        this.firstItem = true;
        this.write(123);
    }

    @Override
    public void onEndMap() {
        --this.depth;
        this.firstItem = false;
        this.write(125);
        this.endNode();
    }

    @Override
    public void onKeyedItem(byte[] key, int offset, int length) {
        this.firstItem = false;
        this.writeStringScalar(key, offset, length);
        this.write(61);
    }

    private void appendQuotedByte(byte b) {
        YsonTextUtils.writeQuotedByte(b, this.writer);
    }

    private void appendQuotedBytes(byte[] bytes) {
        int offset = 0;
        for (byte b : bytes) {
            if (b > 31 && b < 127 && b != 34 && b != 92 && offset < 256) {
                this.buffer[offset++] = (char)b;
                continue;
            }
            if (offset > 0) {
                this.writeBuff(offset);
            }
            offset = 0;
            this.appendQuotedByte(b);
        }
        if (offset > 0) {
            this.writeBuff(offset);
        }
    }

    private void writeBuff(int offset) {
        try {
            this.writer.write(this.buffer, 0, offset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void write(int b) {
        try {
            this.writer.write(b);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class StringBuilderWriterAdapter
    extends Writer {
        private final StringBuilder builder;

        StringBuilderWriterAdapter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void write(char[] chars, int i, int i1) {
            this.builder.append(chars, i, i1);
        }

        @Override
        public void write(String str) throws IOException {
            this.builder.append(str);
        }

        @Override
        public Writer append(char c) throws IOException {
            this.builder.append(c);
            return this;
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.builder.append(csq);
            return this;
        }

        @Override
        public void write(int c) throws IOException {
            this.builder.append((char)c);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

