/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.util.List;
import javax.annotation.Nullable;
import tech.ytsaurus.yson.YsonTokenType;

public class YsonToken {
    @Nullable
    private final Object value;
    private final YsonTokenType type;

    private YsonToken(@Nullable Object value, YsonTokenType type) {
        this.value = value;
        this.type = type;
    }

    public static YsonToken stringValue(String value) {
        return new YsonToken(value, YsonTokenType.String);
    }

    public static YsonToken int64Value(Long value) {
        return new YsonToken(value, YsonTokenType.Int64);
    }

    public static YsonToken uint64Value(Long value) {
        return new YsonToken(value, YsonTokenType.Uint64);
    }

    public static YsonToken doubleValue(Double value) {
        return new YsonToken(value, YsonTokenType.Double);
    }

    public static YsonToken booleanValue(Boolean value) {
        return new YsonToken(value, YsonTokenType.Boolean);
    }

    public static YsonToken entityValue() {
        return new YsonToken(null, YsonTokenType.Hash);
    }

    public static YsonToken endOfStream() {
        return new YsonToken(null, YsonTokenType.EndOfStream);
    }

    public static YsonToken startOfStream() {
        return new YsonToken(null, YsonTokenType.StartOfStream);
    }

    public static YsonToken fromSymbol(byte ch) {
        return new YsonToken(Character.valueOf((char)ch), YsonTokenType.fromSymbol(ch));
    }

    public String asStringValue() {
        this.expectType(YsonTokenType.String);
        return (String)this.value;
    }

    public Long asInt64Value() {
        this.expectType(YsonTokenType.Int64);
        return (Long)this.value;
    }

    public Long asUint64Value() {
        this.expectType(YsonTokenType.Uint64);
        return (Long)this.value;
    }

    public Double asDoubleValue() {
        this.expectType(YsonTokenType.Double);
        return (Double)this.value;
    }

    public Boolean asBooleanValue() {
        this.expectType(YsonTokenType.Boolean);
        return (Boolean)this.value;
    }

    public YsonTokenType getType() {
        return this.type;
    }

    public void expectType(YsonTokenType expectedType) {
        if (this.type != expectedType) {
            throw new IllegalStateException("Unexpected token type: " + this.type + ", expected: " + expectedType);
        }
    }

    public void expectTypes(List<YsonTokenType> expectedTypes) {
        if (!expectedTypes.contains((Object)this.type)) {
            throw new IllegalStateException("Expected one of: " + expectedTypes + " types, but actual type is " + this.type);
        }
    }

    public String toString() {
        return "YsonToken[ " + this.type + " | " + this.value + " ]";
    }
}

