/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import tech.ytsaurus.core.DataSizeUnit;

public class DataSize {
    public static final DataSize ZERO = new DataSize(0L);
    public static final DataSize MEGABYTE = DataSize.fromMegaBytes(1L);
    private final long bytes;

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public static DataSize fromBytes(long bytes) {
        return new DataSize(bytes);
    }

    public static DataSize fromKiloBytes(long kiloBytes) {
        return DataSizeUnit.KILOBYTES.dataSize(kiloBytes);
    }

    public static DataSize fromMegaBytes(long megaBytes) {
        return DataSizeUnit.MEGABYTES.dataSize(megaBytes);
    }

    public static DataSize fromGigaBytes(long gigaBytes) {
        return DataSizeUnit.GIGABYTES.dataSize(gigaBytes);
    }

    public static DataSize fromTeraBytes(long teraBytes) {
        return DataSizeUnit.TERABYTES.dataSize(teraBytes);
    }

    public static DataSize fromPetaBytes(long petaBytes) {
        return DataSizeUnit.PETABYTES.dataSize(petaBytes);
    }

    public static DataSize fromExaBytes(long exaBytes) {
        if (exaBytes > 7L || exaBytes <= -8L) {
            throw new IllegalArgumentException("Invalid exaBytes");
        }
        return DataSizeUnit.EXABYTES.dataSize(exaBytes);
    }

    public long toBytes() {
        return this.bytes;
    }

    public long toKiloBytes() {
        return this.to(DataSizeUnit.KILOBYTES);
    }

    public long toMegaBytes() {
        return this.to(DataSizeUnit.MEGABYTES);
    }

    public long toGigaBytes() {
        return this.to(DataSizeUnit.GIGABYTES);
    }

    public long toTeraBytes() {
        return this.to(DataSizeUnit.TERABYTES);
    }

    public long toPetaBytes() {
        return this.to(DataSizeUnit.PETABYTES);
    }

    public long toExaBytes() {
        return this.to(DataSizeUnit.EXABYTES);
    }

    public long to(DataSizeUnit u) {
        return DataSize.to(this.bytes, u);
    }

    public static long to(long bytes, DataSizeUnit u) {
        if (bytes == Long.MIN_VALUE) {
            return bytes >> u.getBits();
        }
        long absResult = (bytes < 0L ? -bytes : bytes) >> u.getBits();
        return bytes < 0L ? -absResult : absResult;
    }

    public String toString(DataSizeUnit unit) {
        return DataSize.string(this.bytes, unit);
    }

    public String toString() {
        return String.valueOf(this.toBytes());
    }

    public String toStringShort() {
        return DataSize.shortString(this.bytes);
    }

    public static String shortString(long bytes) {
        return DataSize.shortString(bytes, DataSizeUnit.unitFor(bytes));
    }

    public static String shortString(long bytes, DataSizeUnit unit) {
        return bytes == 0L ? "0" : DataSize.string(bytes, unit);
    }

    private static String string(long bytes, DataSizeUnit unit) {
        return DataSize.to(bytes, unit) + unit.getShortName();
    }

    public String toPrettyString() {
        return DataSize.prettyString(this.bytes);
    }

    public static String prettyString(long bytes) {
        return DataSize.prettyString(bytes, 10);
    }

    public String toPrettyString(int roundingThreshold) {
        return DataSize.prettyString(this.bytes, roundingThreshold);
    }

    public static String prettyString(long bytes, int roundingThreshold) {
        if (bytes == Long.MIN_VALUE) {
            return DataSize.prettyStringInternal(bytes, roundingThreshold);
        }
        return bytes < 0L ? "-" + DataSize.prettyStringInternal(-bytes, roundingThreshold) : DataSize.prettyStringInternal(bytes, roundingThreshold);
    }

    private static String prettyStringInternal(long bytes, int roundingThreshold) {
        long tenthMultiplier;
        long tenths;
        if (bytes == 0L) {
            return "0";
        }
        DataSizeUnit unit = DataSizeUnit.unitFor(bytes);
        if (unit == DataSizeUnit.BYTES) {
            return Long.toString(bytes) + " bytes";
        }
        long sizeInUnits = DataSize.to(bytes, unit);
        long diff = bytes - (sizeInUnits << unit.getBits());
        if (diff - (tenths = 10L * diff >> unit.getBits()) * (tenthMultiplier = unit.getMultiplier() / 10L) > tenthMultiplier >> 1 && ++tenths == 10L) {
            tenths = 0L;
            ++sizeInUnits;
        }
        if (tenths > 0L && sizeInUnits < (long)roundingThreshold) {
            return sizeInUnits + "." + tenths + " " + unit.getName();
        }
        return (tenths < 5L ? sizeInUnits : sizeInUnits + 1L) + " " + unit.getName();
    }

    public String toStringKiloBytes() {
        return this.toKiloBytes() + DataSizeUnit.KILOBYTES.getShortName();
    }

    public String toStringMegaBytes() {
        return this.toMegaBytes() + DataSizeUnit.MEGABYTES.getShortName();
    }

    public String toStringGigaBytes() {
        return this.toGigaBytes() + DataSizeUnit.GIGABYTES.getShortName();
    }

    public String toStringTeraBytes() {
        return this.toTeraBytes() + DataSizeUnit.TERABYTES.getShortName();
    }

    public String toStringPetaBytes() {
        return this.toPetaBytes() + DataSizeUnit.PETABYTES.getShortName();
    }

    public String toStringExaBytes() {
        return this.toExaBytes() + DataSizeUnit.EXABYTES.getShortName();
    }

    public DataSize max(DataSize that) {
        if (this.bytes > that.bytes) {
            return this;
        }
        return that;
    }

    public DataSize min(DataSize that) {
        if (this.bytes > that.bytes) {
            return that;
        }
        return this;
    }

    public DataSize div(float d) {
        return DataSize.fromBytes((long)((float)this.bytes / d));
    }

    public DataSize mul(float d) {
        return DataSize.fromBytes((long)((float)this.bytes * d));
    }

    public DataSize plus(DataSize that) {
        return DataSize.fromBytes(this.toBytes() + that.toBytes());
    }

    public DataSize minus(DataSize that) {
        return DataSize.fromBytes(this.toBytes() - that.toBytes());
    }
}

