/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import tech.ytsaurus.core.DataSize;

public enum DataSizeUnit {
    BYTES(0, "", ""),
    KILOBYTES(10, "K", "KB"),
    MEGABYTES(20, "M", "MB"),
    GIGABYTES(30, "G", "GB"),
    TERABYTES(40, "T", "TB"),
    PETABYTES(50, "P", "PB"),
    EXABYTES(60, "E", "EB");

    private final long multiplier;
    private final int bits;
    private final String shortName;
    private final String name;

    private DataSizeUnit(int bits, String shortName, String name) {
        this.bits = bits;
        this.multiplier = 1L << bits;
        this.shortName = shortName;
        this.name = name;
    }

    public int getBits() {
        return this.bits;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public DataSize dataSize(long count) {
        return DataSize.fromBytes(count << this.bits);
    }

    public static DataSizeUnit parseShortName(String name0) {
        String name = name0.replaceFirst("[bB]$", "");
        for (DataSizeUnit u : DataSizeUnit.values()) {
            if (!u.shortName.equalsIgnoreCase(name)) continue;
            return u;
        }
        throw new IllegalArgumentException("cannot parse '" + name0 + "' as DataSizeUnit");
    }

    public static DataSizeUnit largest() {
        return DataSizeUnit.values()[DataSizeUnit.values().length - 1];
    }

    public static DataSizeUnit unitFor(long count) {
        if (count == Long.MIN_VALUE) {
            return EXABYTES;
        }
        if (count < 0L) {
            count = -count;
        }
        int bits = 64 - Long.numberOfLeadingZeros(count);
        DataSizeUnit result = BYTES;
        for (DataSizeUnit u : DataSizeUnit.values()) {
            if (u.bits >= bits) break;
            result = u;
        }
        return result;
    }

    static {
        for (int i = 1; i < DataSizeUnit.values().length; ++i) {
            DataSizeUnit prev = DataSizeUnit.values()[i - 1];
            DataSizeUnit curr = DataSizeUnit.values()[i];
            if (prev.getMultiplier() >= curr.getMultiplier()) {
                throw new AssertionError((Object)"must be sorted");
            }
        }
    }
}

