/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class GUID {
    private static final Pattern PATTERN = Pattern.compile("([0-9A-Fa-f]+)-([0-9A-Fa-f]+)-([0-9A-Fa-f]+)-([0-9A-Fa-f]+)");
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final long first;
    private final long second;

    public GUID(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public GUID(long a, long b, long c, long d) {
        this.first = c << 32 | d & 0xFFFFFFFFL;
        this.second = a << 32 | b & 0xFFFFFFFFL;
    }

    public long getFirst() {
        return this.first;
    }

    public long getSecond() {
        return this.second;
    }

    public boolean isEmpty() {
        return this.first == 0L && this.second == 0L;
    }

    public static boolean isEmpty(@Nullable GUID id) {
        return id == null || id.isEmpty();
    }

    public static GUID create() {
        return GUID.create(ThreadLocalRandom.current());
    }

    public static GUID create(Random random) {
        long first = random.nextLong();
        long second = (long)COUNTER.incrementAndGet() << 32 | (long)random.nextInt() & 0xFFFFFFFFL;
        return new GUID(first, second);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof GUID)) {
            return false;
        }
        GUID guid = (GUID)another;
        return this.first == guid.first && this.second == guid.second;
    }

    public int hashCode() {
        int result = (int)(this.first ^ this.first >>> 32);
        result = 31 * result + (int)(this.second ^ this.second >>> 32);
        return result;
    }

    public String toString() {
        return Integer.toUnsignedString((int)(this.second >>> 32), 16) + "-" + Integer.toUnsignedString((int)this.second, 16) + "-" + Integer.toUnsignedString((int)(this.first >>> 32), 16) + "-" + Integer.toUnsignedString((int)this.first, 16);
    }

    public static boolean isValid(String s) {
        try {
            GUID.valueOf(s);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static GUID valueOf(String s) {
        return GUID.valueOfO(s).orElseThrow(() -> new IllegalArgumentException(s));
    }

    public static Optional<GUID> valueOfO(String s) {
        Matcher m = PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("String '" + s + "' is not a valid yt guid");
        }
        int a = Integer.parseUnsignedInt(m.group(1), 16);
        int b = Integer.parseUnsignedInt(m.group(2), 16);
        int c = Integer.parseUnsignedInt(m.group(3), 16);
        int d = Integer.parseUnsignedInt(m.group(4), 16);
        if (a == 0 && b == 0 && c == 0 && d == 0) {
            return Optional.empty();
        }
        return Optional.of(new GUID(a, b, c, d));
    }
}

