/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import tech.ytsaurus.core.DataSize;

public final class JavaOptions {
    private static final List<String> CURRENT = ManagementFactory.getRuntimeMXBean().getInputArguments();
    private final List<String> options;

    private JavaOptions(List<String> options) {
        this.options = options;
    }

    public static JavaOptions empty() {
        return new JavaOptions(new ArrayList<String>());
    }

    public static JavaOptions current() {
        return new JavaOptions(CURRENT);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public JavaOptions withOption(String value) {
        int index;
        int eqSignIndex = value.startsWith("--add-") ? -1 : value.indexOf(61);
        int n = index = eqSignIndex < 0 ? this.options.indexOf(value) : this.findOptionIndexStartsWith(value.substring(0, eqSignIndex));
        if (index < 0) {
            ArrayList<String> resultOptions = new ArrayList<String>(this.options);
            resultOptions.add(value);
            return new JavaOptions(resultOptions);
        }
        ArrayList<String> mutable = new ArrayList<String>(this.options);
        mutable.set(index, value);
        return new JavaOptions(mutable);
    }

    public JavaOptions withoutOption(String value) {
        int eqSignIndex;
        int n = eqSignIndex = value.startsWith("--add-") ? -1 : value.indexOf(61);
        if (eqSignIndex < 0) {
            int index = this.options.indexOf(value);
            if (index < 0) {
                return this;
            }
            ArrayList<String> mutable = new ArrayList<String>(this.options);
            mutable.remove(index);
            return new JavaOptions(mutable);
        }
        return this.withoutOptionStartsWith(value.substring(0, eqSignIndex));
    }

    public JavaOptions withoutOptionStartsWith(String value) {
        int index = this.findOptionIndexStartsWith(value);
        if (index < 0) {
            return this;
        }
        ArrayList<String> mutable = new ArrayList<String>(this.options);
        mutable.remove(index);
        return new JavaOptions(mutable);
    }

    public JavaOptions withMemory(DataSize size) {
        return this.withMemory(size, size);
    }

    public JavaOptions withMemory(DataSize minSize, DataSize maxSize) {
        return this.withoutOptionStartsWith("-Xms").withoutOptionStartsWith("-Xmx").withOption("-Xms" + JavaOptions.formatMemory(minSize)).withOption("-Xmx" + JavaOptions.formatMemory(maxSize));
    }

    public JavaOptions withXmx(DataSize xmx) {
        return this.withoutOptionStartsWith("-Xmx").withOption("-Xmx" + JavaOptions.formatMemory(xmx));
    }

    private int findOptionIndexStartsWith(String value) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.options.get(i).startsWith(value)) continue;
            return i;
        }
        return -1;
    }

    private static String formatMemory(DataSize requiredMemory) {
        return requiredMemory.toMegaBytes() + "m";
    }
}

