/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import java.util.HashMap;
import java.util.Map;
import tech.ytsaurus.core.StringValueEnum;

public class StringValueEnumResolver<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final Map<String, T> valuesByName = new HashMap<String, T>();

    public StringValueEnumResolver(Class<T> enumClass) {
        this.enumClass = enumClass;
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            this.valuesByName.put(((StringValueEnum)((Object)value)).value(), value);
        }
    }

    public T fromName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("value must not be null; for enum of type " + this.enumClass.getName());
        }
        if (this.valuesByName.containsKey(name)) {
            return (T)((Enum)this.valuesByName.get(name));
        }
        throw new IllegalArgumentException("no enum of type " + this.enumClass.getName() + " found with name " + name);
    }

    public static <T extends Enum<T>> StringValueEnumResolver<T> of(Class<T> enumClass) {
        return new StringValueEnumResolver<T>(enumClass);
    }
}

