/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core;

import java.time.Instant;
import javax.annotation.Nonnull;

public class YtTimestamp {
    public static final int COUNTER_BITS = 30;
    public static final long COUNTER_MASK = 0x3FFFFFFFL;
    public static final YtTimestamp MIN = new YtTimestamp(1L);
    public static final YtTimestamp MAX = new YtTimestamp(0x3FFFFFFFFFFFFF00L);
    public static final YtTimestamp NULL = new YtTimestamp(0L);
    public static final YtTimestamp SYNC_LAST_COMMITTED = new YtTimestamp(4611686018427387649L);
    public static final YtTimestamp ASYNC_LAST_COMMITTED = new YtTimestamp(4611686018427387652L);
    private final long value;

    protected YtTimestamp(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public Instant getInstant() {
        return Instant.ofEpochSecond(this.value >>> 30);
    }

    public long getCounter() {
        return this.value & 0x3FFFFFFFL;
    }

    public String toString() {
        return this.getInstant() + "/" + this.getCounter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YtTimestamp)) {
            return false;
        }
        YtTimestamp that = (YtTimestamp)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public static YtTimestamp valueOf(long value) {
        return new YtTimestamp(value);
    }

    public static YtTimestamp fromInstant(@Nonnull Instant instant) {
        return new YtTimestamp(instant.getEpochSecond() << 30);
    }
}

