/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.common;

import NYT.Extension;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeStringNode;

public class YTsaurusProtobufFormat {
    private final List<Descriptors.Descriptor> messageDescriptors;

    public YTsaurusProtobufFormat(List<Message.Builder> messageBuilders) {
        this.messageDescriptors = messageBuilders.stream().map(Message.Builder::getDescriptorForType).collect(Collectors.toList());
    }

    public YTreeStringNode spec() {
        FileDescriptorSetBuilder fileDescriptorSetBuilder = new FileDescriptorSetBuilder();
        for (Descriptors.Descriptor descriptor : this.messageDescriptors) {
            fileDescriptorSetBuilder.addDescriptor(descriptor);
        }
        String shortText = TextFormat.shortDebugString((MessageOrBuilder)fileDescriptorSetBuilder.build());
        return YTree.builder().beginAttributes().key("file_descriptor_set_text").value(shortText).key("type_names").value((Collection)this.messageDescriptors.stream().map(Descriptors.Descriptor::getFullName).collect(Collectors.toList())).endAttributes().value("protobuf").build().stringNode();
    }

    @NonNullApi
    @NonNullFields
    static class FileDescriptorSetBuilder {
        private static final Descriptors.FileDescriptor SYSTEM_EXTENSION_FILE = Extension.EWrapperFieldFlag.getDescriptor().getFile();
        private final Set<Descriptors.Descriptor> allDescriptors = new HashSet<Descriptors.Descriptor>();
        private final Set<Descriptors.EnumDescriptor> allEnumDescriptors = new HashSet<Descriptors.EnumDescriptor>();

        FileDescriptorSetBuilder() {
        }

        public void addDescriptor(Descriptors.Descriptor descriptor) {
            if (!this.allDescriptors.add(descriptor)) {
                return;
            }
            this.addAllContainingTypes(descriptor.getContainingType());
            for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                this.addField(field);
            }
        }

        public DescriptorProtos.FileDescriptorSet build() {
            HashSet<Descriptors.FileDescriptor> visitedFiles = new HashSet<Descriptors.FileDescriptor>();
            ArrayList<Descriptors.FileDescriptor> fileTopologicalOrder = new ArrayList<Descriptors.FileDescriptor>();
            for (Descriptors.Descriptor descriptor : this.allDescriptors) {
                this.traverseDependencies(descriptor.getFile(), visitedFiles, fileTopologicalOrder);
            }
            for (Descriptors.EnumDescriptor enumDescriptor : this.allEnumDescriptors) {
                this.traverseDependencies(enumDescriptor.getFile(), visitedFiles, fileTopologicalOrder);
            }
            Set<String> messageNames = this.allDescriptors.stream().map(Descriptors.Descriptor::getFullName).collect(Collectors.toSet());
            Set<String> enumNames = this.allEnumDescriptors.stream().map(Descriptors.EnumDescriptor::getFullName).collect(Collectors.toSet());
            DescriptorProtos.FileDescriptorSet.Builder protoBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
            for (Descriptors.FileDescriptor file : fileTopologicalOrder) {
                protoBuilder.addFile(this.strip(file, messageNames, enumNames));
            }
            return protoBuilder.build();
        }

        private DescriptorProtos.FileDescriptorProto strip(Descriptors.FileDescriptor file, Set<String> requiredMessageNames, Set<String> requiredEnumNames) {
            DescriptorProtos.FileDescriptorProto.Builder fileProto = file.toProto().toBuilder();
            fileProto.clearService();
            fileProto.clearExtension();
            String packagePrefix = fileProto.getPackage().isEmpty() ? "" : fileProto.getPackage() + ".";
            List messageTypeList = fileProto.getMessageTypeList();
            fileProto.clearMessageType();
            fileProto.addAllMessageType((Iterable)messageTypeList.stream().filter(m -> requiredMessageNames.contains(packagePrefix + m.getName())).map(this::stripUnknownExtensions).collect(Collectors.toList()));
            List enumTypeList = fileProto.getEnumTypeBuilderList();
            fileProto.clearEnumType();
            fileProto.addAllEnumType((Iterable)enumTypeList.stream().filter(e -> requiredEnumNames.contains(packagePrefix + e.getName())).map(DescriptorProtos.EnumDescriptorProto.Builder::build).collect(Collectors.toList()));
            return fileProto.build();
        }

        private DescriptorProtos.DescriptorProto stripUnknownExtensions(DescriptorProtos.DescriptorProto messageDescriptor) {
            DescriptorProtos.DescriptorProto.Builder builder = messageDescriptor.toBuilder();
            this.stripUnknownExtensions(builder);
            return builder.build();
        }

        private void stripUnknownExtensions(DescriptorProtos.DescriptorProto.Builder builder) {
            this.stripUnknownExtensionsFromOptions((Message.Builder)builder.getOptionsBuilder());
            for (DescriptorProtos.FieldDescriptorProto.Builder field : builder.getFieldBuilderList()) {
                if (!field.hasOptions()) continue;
                this.stripUnknownExtensionsFromOptions((Message.Builder)field.getOptionsBuilder());
            }
            for (DescriptorProtos.OneofDescriptorProto.Builder oneof : builder.getOneofDeclBuilderList()) {
                if (!oneof.hasOptions()) continue;
                this.stripUnknownExtensionsFromOptions((Message.Builder)oneof.getOptionsBuilder());
            }
            for (DescriptorProtos.DescriptorProto.Builder nestedTypeProto : builder.getNestedTypeBuilderList()) {
                this.stripUnknownExtensions(nestedTypeProto);
            }
            for (DescriptorProtos.EnumDescriptorProto.Builder enumProto : builder.getEnumTypeBuilderList()) {
                if (enumProto.hasOptions()) {
                    this.stripUnknownExtensionsFromOptions((Message.Builder)enumProto.getOptionsBuilder());
                }
                for (DescriptorProtos.EnumValueDescriptorProto.Builder enumValue : enumProto.getValueBuilderList()) {
                    if (!enumValue.hasOptions()) continue;
                    this.stripUnknownExtensionsFromOptions((Message.Builder)enumValue.getOptionsBuilder());
                }
            }
        }

        private void stripUnknownExtensionsFromOptions(Message.Builder options) {
            for (Descriptors.FieldDescriptor field : options.getAllFields().keySet()) {
                if (!field.isExtension() || field.getFile() == SYSTEM_EXTENSION_FILE) continue;
                options.clearField(field);
            }
        }

        private void traverseDependencies(Descriptors.FileDescriptor file, Set<Descriptors.FileDescriptor> visitedFiles, List<Descriptors.FileDescriptor> fileTopologicalOrder) {
            if (!visitedFiles.add(file)) {
                return;
            }
            for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
                this.traverseDependencies(dependency, visitedFiles, fileTopologicalOrder);
            }
            fileTopologicalOrder.add(file);
        }

        private void addField(Descriptors.FieldDescriptor field) {
            if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.addDescriptor(field.getMessageType());
            }
            if (field.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                this.addEnumDescriptor(field.getEnumType());
            }
        }

        private void addEnumDescriptor(Descriptors.EnumDescriptor enumType) {
            if (!this.allEnumDescriptors.add(enumType)) {
                return;
            }
            this.addAllContainingTypes(enumType.getContainingType());
        }

        private void addAllContainingTypes(@Nullable Descriptors.Descriptor descriptor) {
            while (descriptor != null) {
                this.addDescriptor(descriptor);
                descriptor = descriptor.getContainingType();
            }
        }
    }
}

