/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.core.cypress.RangeCriteria;
import tech.ytsaurus.core.cypress.RangeLimit;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;

@NonNullApi
@NonNullFields
public class Range
extends RangeCriteria {
    @Nullable
    public final RangeLimit lower;
    @Nullable
    public final RangeLimit upper;

    public Range(@Nullable RangeLimit lower, @Nullable RangeLimit upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public static Range lower(RangeLimit lowerLimit) {
        return new Range(lowerLimit, null);
    }

    public static Range upper(RangeLimit upperLimit) {
        return new Range(null, upperLimit);
    }

    public static Range of(RangeLimit lowerLimit, RangeLimit upperLimit) {
        return new Range(lowerLimit, upperLimit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.lower, range.lower) && Objects.equals(this.upper, range.upper);
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper);
    }

    @Override
    public YTreeBuilder addRangeCriteria(YTreeBuilder builder) {
        if (this.lower != null) {
            this.addReadLimit(builder, this.lower, "lower_limit");
        }
        if (this.upper != null) {
            this.addReadLimit(builder, this.upper, "upper_limit");
        }
        return builder;
    }

    @Override
    @Nonnull
    public RangeCriteria forRetry(long nextRowIndex) {
        return new Range(this.lower.toBuilder().setRowIndex(nextRowIndex).build(), this.upper);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static class Builder {
        @Nullable
        RangeLimit lowerLimit;
        @Nullable
        RangeLimit upperLimit;

        public Builder setLowerLimit(RangeLimit lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        public Builder setUpperLimit(RangeLimit upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        public Range build() {
            return new Range(this.lowerLimit, this.upperLimit);
        }
    }
}

