/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.core.cypress.KeyBound;
import tech.ytsaurus.core.cypress.Relation;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class RangeLimit {
    public final List<YTreeNode> key;
    @Nullable
    private final KeyBound keyBound;
    public final long rowIndex;
    public final long offset;
    public final long tabletIndex;

    RangeLimit(List<YTreeNode> key, @Nullable KeyBound keyBound, long rowIndex, long offset) {
        this(key, keyBound, rowIndex, offset, -1L);
    }

    RangeLimit(List<YTreeNode> key, @Nullable KeyBound keyBound, long rowIndex, long offset, long tabletIndex) {
        this.key = key;
        this.keyBound = keyBound;
        this.rowIndex = rowIndex;
        this.offset = offset;
        this.tabletIndex = tabletIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeLimit that = (RangeLimit)o;
        return this.rowIndex == that.rowIndex && this.offset == that.offset && this.tabletIndex == that.tabletIndex && Objects.equals(this.key, that.key) && Objects.equals(this.keyBound, that.keyBound);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.keyBound, this.rowIndex, this.offset, this.tabletIndex);
    }

    public static RangeLimit row(long rowIndex) {
        return new RangeLimit(Collections.emptyList(), null, rowIndex, -1L);
    }

    public static RangeLimit offset(long offset) {
        return new RangeLimit(Collections.emptyList(), null, -1L, offset);
    }

    public static RangeLimit key(List<YTreeNode> key) {
        return new RangeLimit(key, null, -1L, -1L);
    }

    public static RangeLimit key(YTreeNode ... key) {
        return RangeLimit.key(Arrays.asList(key));
    }

    public static RangeLimit key(Relation relation, YTreeNode ... key) {
        return new RangeLimit(Collections.emptyList(), KeyBound.of(relation, key), -1L, -1L);
    }

    public static RangeLimit fromTree(YTreeNode node) {
        YTreeMapNode mapNode = node.mapNode();
        ArrayList<YTreeNode> limitKey = new ArrayList();
        if (mapNode.containsKey("key")) {
            limitKey = mapNode.getOrThrow("key").asList();
        }
        KeyBound keyBound = null;
        if (mapNode.containsKey("key_bound")) {
            keyBound = KeyBound.fromTree(mapNode.getOrThrow("key_bound"));
        }
        long rowIndex = -1L;
        if (mapNode.containsKey("row_index")) {
            rowIndex = mapNode.getOrThrow("row_index").longValue();
        }
        long offset = -1L;
        if (mapNode.containsKey("offset")) {
            offset = mapNode.getOrThrow("offset").longValue();
        }
        long tabletIndex = -1L;
        if (mapNode.containsKey("tablet_index")) {
            tabletIndex = mapNode.getOrThrow("tablet_index").longValue();
        }
        return RangeLimit.builder().setKey(limitKey).setKeyBound(keyBound).setRowIndex(rowIndex).setOffset(offset).setTabletIndex(tabletIndex).build();
    }

    public YTreeBuilder toTree(YTreeBuilder builder) {
        return builder.beginMap().when(!this.key.isEmpty(), b -> b.key("key").value(this.key)).when(this.keyBound != null, b -> {
            assert (this.keyBound != null);
            return b.key("key_bound").apply(this.keyBound::toTree);
        }).when(this.rowIndex != -1L, b -> b.key("row_index").value(this.rowIndex)).when(this.offset != -1L, b -> b.key("offset").value(this.offset)).when(this.tabletIndex != -1L, b -> b.key("tablet_index").value(this.tabletIndex)).endMap();
    }

    public Builder toBuilder() {
        return RangeLimit.builder().setKeyBound(this.keyBound).setKey(this.key).setRowIndex(this.rowIndex).setOffset(this.offset).setTabletIndex(this.tabletIndex);
    }

    @NonNullApi
    @NonNullFields
    public static class Builder {
        private List<YTreeNode> key = Collections.emptyList();
        @Nullable
        private KeyBound keyBound = null;
        private long rowIndex = -1L;
        private long offset = -1L;
        private long tabletIndex = -1L;

        public Builder setKey(YTreeNode ... key) {
            return this.setKey(Arrays.asList(key));
        }

        public Builder setKey(List<YTreeNode> key) {
            this.key = key;
            return this;
        }

        public Builder setKeyBound(@Nullable KeyBound keyBound) {
            this.keyBound = keyBound;
            return this;
        }

        public Builder setRowIndex(long rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public Builder setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder setTabletIndex(long tabletIndex) {
            this.tabletIndex = tabletIndex;
            return this;
        }

        public RangeLimit build() {
            return new RangeLimit(new ArrayList<YTreeNode>(this.key), this.keyBound, this.rowIndex, this.offset, this.tabletIndex);
        }
    }
}

