/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.cypress;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import tech.ytsaurus.core.cypress.RichYPathTags;
import tech.ytsaurus.core.cypress.TokenType;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.yson.YsonTokenType;

@NonNullApi
@NonNullFields
class YPathTokenizer {
    private final byte[] input;
    private TokenType type = TokenType.StartOfStream;
    private TokenType previousType = TokenType.StartOfStream;
    private int tokenLength = 0;
    private int inputShift = 0;
    private ByteArrayOutputStream literalValue = new ByteArrayOutputStream();

    YPathTokenizer(byte[] path) {
        this.input = path;
    }

    TokenType advance() {
        this.inputShift += this.tokenLength;
        this.literalValue = new ByteArrayOutputStream();
        if (this.inputShift == this.input.length) {
            this.setType(TokenType.EndOfStream);
            this.tokenLength = 0;
            return this.type;
        }
        this.setType(TokenType.Literal);
        boolean proceed = true;
        int currentIndex = 0;
        block4: while (proceed && this.inputShift + currentIndex < this.input.length) {
            byte currentSymbol = this.input[this.inputShift + currentIndex];
            YsonTokenType currentToken = YsonTokenType.fromSymbol((byte)currentSymbol);
            if (currentToken == RichYPathTags.BEGIN_COLUMN_SELECTOR_TOKEN || currentToken == RichYPathTags.BEGIN_ROW_SELECTOR_TOKEN) {
                if (currentIndex == 0) {
                    this.setType(TokenType.Range);
                    currentIndex = this.input.length - this.inputShift;
                }
                proceed = false;
                continue;
            }
            switch (currentSymbol) {
                case 38: 
                case 42: 
                case 47: 
                case 64: {
                    if (currentIndex == 0) {
                        this.tokenLength = 1;
                        this.setType(TokenType.fromByte(currentSymbol));
                        return this.type;
                    }
                    proceed = false;
                    continue block4;
                }
                case 92: {
                    currentIndex = this.advanceEscaped(currentIndex);
                    continue block4;
                }
            }
            this.literalValue.write(this.input[this.inputShift + currentIndex]);
            ++currentIndex;
        }
        this.tokenLength = currentIndex;
        return this.type;
    }

    private int advanceEscaped(int currentIndex) {
        if (this.input[this.inputShift + currentIndex] != 92) {
            throw new IllegalStateException("'\\' was expected in advanceEscaped");
        }
        if (this.inputShift + ++currentIndex == this.input.length) {
            throw new IllegalArgumentException("Unexpected end-of-string in YPath while parsing escape sequence");
        }
        if (this.isSpecialCharacter(this.input[this.inputShift + currentIndex])) {
            this.literalValue.write(this.input[this.inputShift + currentIndex]);
            ++currentIndex;
        } else if (this.input[this.inputShift + currentIndex] == 120) {
            if (currentIndex + 2 >= this.input.length) {
                this.throwMalformedEscapeSequence(ByteBuffer.wrap(this.input, this.inputShift + currentIndex - 1, this.input.length));
            }
            ByteBuffer context = ByteBuffer.wrap(this.input, this.inputShift + currentIndex - 1, this.inputShift + currentIndex + 3);
            int hi = this.parseHexDigit(this.input[this.inputShift + currentIndex + 1], context);
            int lo = this.parseHexDigit(this.input[this.inputShift + currentIndex + 2], context);
            this.literalValue.write((hi << 4) + lo);
            currentIndex += 3;
        } else {
            this.throwMalformedEscapeSequence(ByteBuffer.wrap(this.input, this.inputShift + currentIndex - 1, this.inputShift + currentIndex + 1));
        }
        return currentIndex;
    }

    private void throwMalformedEscapeSequence(ByteBuffer context) {
        throw new RuntimeException(String.format("Malformed escape sequence %s in YPath", context));
    }

    private int parseHexDigit(byte ch, ByteBuffer context) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        this.throwMalformedEscapeSequence(context);
        return 0;
    }

    private boolean isSpecialCharacter(byte ch) {
        return ch == 92 || ch == 47 || ch == 64 || ch == 42 || ch == 38 || ch == 91 || ch == 123;
    }

    void setType(TokenType type) {
        this.previousType = this.type;
        this.type = type;
    }

    TokenType getType() {
        return this.type;
    }

    @Nullable
    byte[] getToken() {
        return this.tokenLength > 0 ? Arrays.copyOfRange(this.input, this.inputShift, this.inputShift + this.tokenLength) : null;
    }

    byte[] getPrefix() {
        return Arrays.copyOfRange(this.input, 0, this.inputShift);
    }
}

