/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.operations;

import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    default public Stream<T> stream() {
        Iterable iterable = () -> this;
        return (Stream)StreamSupport.stream(iterable.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        });
    }

    default public <R> CloseableIterator<R> map(final Function<? super T, ? extends R> mapper) {
        return new CloseableIterator<R>(){

            @Override
            public boolean hasNext() {
                return CloseableIterator.this.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(CloseableIterator.this.next());
            }

            @Override
            public void close() throws Exception {
                CloseableIterator.this.close();
            }
        };
    }

    public static <T> CloseableIterator<T> wrap(Iterable<T> delegate) {
        return CloseableIterator.wrap(delegate.iterator());
    }

    public static <T> CloseableIterator<T> wrap(final Iterator<T> delegate) {
        return new CloseableIterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                return delegate.next();
            }

            @Override
            public void close() throws Exception {
                if (delegate instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)delegate)).close();
                }
            }
        };
    }
}

