/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.tables;

import java.util.HashMap;
import java.util.Map;

public enum ColumnValueType {
    MIN(0, "min"),
    THE_BOTTOM(1, "the_bottom"),
    NULL(2, "null"),
    INT64(3, "int64"),
    UINT64(4, "uint64"),
    DOUBLE(5, "double"),
    BOOLEAN(6, "boolean"),
    STRING(16, "string"),
    ANY(17, "any"),
    COMPOSITE(18, "composite"),
    MAX(239, "max");

    private static final Map<Integer, ColumnValueType> MAP_FROM_VALUE;
    private static final Map<String, ColumnValueType> MAP_FROM_NAME;
    private final int value;
    private final String name;

    private ColumnValueType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValueType() {
        switch (this) {
            case INT64: 
            case UINT64: 
            case DOUBLE: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public boolean isStringLikeType() {
        switch (this) {
            case STRING: 
            case ANY: 
            case COMPOSITE: {
                return true;
            }
        }
        return false;
    }

    public static ColumnValueType fromValue(int value) {
        ColumnValueType type = MAP_FROM_VALUE.get(value);
        if (type == null) {
            throw new IllegalArgumentException("Unsupported value type 0x" + Integer.toHexString(value));
        }
        return type;
    }

    public static ColumnValueType fromName(String name) {
        ColumnValueType type = MAP_FROM_NAME.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unsupported value type " + name);
        }
        return type;
    }

    static {
        MAP_FROM_VALUE = new HashMap<Integer, ColumnValueType>();
        MAP_FROM_NAME = new HashMap<String, ColumnValueType>();
        for (ColumnValueType type : ColumnValueType.values()) {
            MAP_FROM_VALUE.put(type.getValue(), type);
            MAP_FROM_NAME.put(type.getName(), type);
        }
    }
}

