/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.core.tables;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import tech.ytsaurus.core.tables.ColumnSortOrder;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;

@NonNullFields
@NonNullApi
public class SortColumn {
    final String name;
    final ColumnSortOrder sortOrder;

    public SortColumn(String name) {
        this(name, ColumnSortOrder.ASCENDING);
    }

    public SortColumn(String name, ColumnSortOrder sortOrder) {
        this.name = name;
        this.sortOrder = sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public ColumnSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static List<SortColumn> convert(Collection<String> names) {
        return names.stream().map(name -> new SortColumn((String)name, ColumnSortOrder.ASCENDING)).collect(Collectors.toList());
    }

    public YTreeBuilder toTree(YTreeBuilder builder) {
        return builder.beginMap().key("name").value(this.name).key("sort_order").value(this.sortOrder.getName()).endMap();
    }
}

