/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.spyt.types;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.spyt.types.Date32;
import org.apache.spark.sql.spyt.types.Date32$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114AAC\u0006\u00011!)!\u0005\u0001C\u0001G!)Q\u0005\u0001C!M!)A\u0007\u0001C!k!)\u0011\b\u0001C!u!)\u0011\t\u0001C!\u0005\")Q\t\u0001C\u0005\r\")q\n\u0001C!!\"1A\u000b\u0001C!\u001fUCQa\u0019\u0001\u0005B\u0019\u0012!\u0002R1uKN\u0012D+\u001f9f\u0015\taQ\"A\u0003usB,7O\u0003\u0002\u000f\u001f\u0005!1\u000f]=u\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004E\u0002\u001b9yi\u0011a\u0007\u0006\u0003\u0019=I!!H\u000e\u0003\u001fU\u001bXM\u001d#fM&tW\r\u001a+za\u0016\u0004\"a\b\u0011\u000e\u0003-I!!I\u0006\u0003\r\u0011\u000bG/Z\u001a3\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002 \u0001\u0005)\u0001/_+E)V\tq\u0005\u0005\u0002)c9\u0011\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0003Y]\ta\u0001\u0010:p_Rt$\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0017\u0002\u000fM\fH\u000eV=qKV\ta\u0007\u0005\u0002\u001bo%\u0011\u0001h\u0007\u0002\t\t\u0006$\u0018\rV=qK\u0006I1/\u001a:jC2L'0\u001a\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u00035J!AP\u0017\u0003\u0007\u0005s\u0017\u0010C\u0003A\t\u0001\u0007a$A\u0001e\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0005y\u0019\u0005\"\u0002#\u0006\u0001\u0004Y\u0014!\u00023biVl\u0017aB5t-\u0006d\u0017\u000e\u001a\u000b\u0003\u000f*\u0003\"\u0001\u0010%\n\u0005%k#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0017\u001a\u0001\r\u0001T\u0001\u0006m\u0006dW/\u001a\t\u0003y5K!AT\u0017\u0003\u0007%sG/A\u0005vg\u0016\u00148\t\\1tgV\t\u0011\u000bE\u0002)%zI!aU\u001a\u0003\u000b\rc\u0017m]:\u0002\u0013)\u001cxN\u001c,bYV,W#\u0001,\u0011\u0005]\u0003gB\u0001-^\u001d\tI6L\u0004\u0002+5&\ta#\u0003\u0002]+\u00051!n]8oiML!AX0\u0002\u000f)\u001bxN\\!T)*\u0011A,F\u0005\u0003C\n\u0014aA\u0013,bYV,'B\u00010`\u00035\u0019\u0017\r^1m_\u001e\u001cFO]5oO\u0002")
public class Date32Type
extends UserDefinedType<Date32> {
    public String pyUDT() {
        return "spyt.types.Date32Type";
    }

    public DataType sqlType() {
        return IntegerType$.MODULE$;
    }

    public Object serialize(Date32 d) {
        return BoxesRunTime.boxToInteger((int)d.days());
    }

    public Date32 deserialize(Object datum) {
        Integer n;
        Object object = datum;
        if (object instanceof Integer) {
            n = (Integer)object;
            if (!this.isValid(Predef$.MODULE$.Integer2int(n))) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Number ").append(n).append(" is out of range [").append(Date32$.MODULE$.MIN_DATE32()).append(" to ").append(Date32$.MODULE$.MAX_DATE32()).append("]").toString());
            }
        } else {
            throw new AnalysisException(new StringBuilder(79).append("Date32 deserialization error: Expected java.lang.Integer but got datum of type ").append(datum.getClass()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        Date32 date32 = new Date32(Predef$.MODULE$.Integer2int(n));
        return date32;
    }

    private boolean isValid(int value) {
        return Date32$.MODULE$.MIN_DATE32() <= value && value <= Date32$.MODULE$.MAX_DATE32();
    }

    public Class<Date32> userClass() {
        return Date32.class;
    }

    public JsonAST.JValue jsonValue() {
        return JsonListAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"udt"), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pyClass"), (Object)this.pyUDT()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serializedClass"), (Object)this.serializedPyClass()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)this.sqlType().jsonValue()));
    }

    public String catalogString() {
        return "date32";
    }
}

