/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.v2;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.request.MultiTablePartition;
import tech.ytsaurus.client.rows.WireRowDeserializer;
import tech.ytsaurus.core.cypress.RangeCriteria;
import tech.ytsaurus.core.cypress.RangeLimit;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.spyt.SparkAdapter$;
import tech.ytsaurus.spyt.common.utils.ExpressionTransformer$;
import tech.ytsaurus.spyt.common.utils.MInfinity;
import tech.ytsaurus.spyt.common.utils.PInfinity;
import tech.ytsaurus.spyt.common.utils.Point;
import tech.ytsaurus.spyt.common.utils.TuplePoint;
import tech.ytsaurus.spyt.format.YtInputSplit$;
import tech.ytsaurus.spyt.format.YtPartitionedFileDelegate;
import tech.ytsaurus.spyt.format.YtPartitionedFileDelegate$;
import tech.ytsaurus.spyt.format.YtPartitioningSupport;
import tech.ytsaurus.spyt.format.conf.KeyPartitioningConfig;
import tech.ytsaurus.spyt.format.conf.SparkYtConfiguration$Read$YtPartitioningEnabled$;
import tech.ytsaurus.spyt.fs.YtHadoopPath;
import tech.ytsaurus.spyt.fs.YtHadoopPath$;
import tech.ytsaurus.spyt.fs.path.YPathEnriched$;
import tech.ytsaurus.spyt.serializers.InternalRowDeserializer;
import tech.ytsaurus.spyt.serializers.InternalRowDeserializer$;
import tech.ytsaurus.spyt.serializers.PivotKeysConverter$;
import tech.ytsaurus.spyt.serializers.SchemaConverter$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.client.YtClientConfigurationConverter$;
import tech.ytsaurus.spyt.wrapper.client.YtClientProvider$;
import tech.ytsaurus.spyt.wrapper.config.ConfigEntry;
import tech.ytsaurus.spyt.wrapper.config.package$;
import tech.ytsaurus.spyt.wrapper.table.OptimizeMode;
import tech.ytsaurus.spyt.wrapper.table.TableIterator;
import tech.ytsaurus.ysontree.YTreeNode;

public final class YtFilePartition$ {
    public static YtFilePartition$ MODULE$;
    private final transient Logger log;
    private final Ordering<PartitionedFile> partitionedFilesOrdering;

    static {
        new YtFilePartition$();
    }

    private Logger log() {
        return this.log;
    }

    public long maxSplitBytes(SparkSession sparkSession, Seq<PartitionDirectory> selectedPartitions, Option<Object> maybeReadParallelism) {
        long defaultMaxSplitBytes = sparkSession.sessionState().conf().filesMaxPartitionBytes();
        long minSplitBytes = JavaUtils.byteStringAs((String)sparkSession.sessionState().conf().getConfString(package$.MODULE$.YT_MIN_PARTITION_BYTES(), "1G"), (ByteUnit)ByteUnit.BYTE);
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        int defaultParallelism = sparkSession.sparkContext().defaultParallelism();
        long totalBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)selectedPartitions.flatMap((Function1 & Serializable & scala.Serializable)pd -> (Seq)SparkAdapter$.MODULE$.instance().getPartitionFileStatuses(pd).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)YtFilePartition$.$anonfun$maxSplitBytes$2(openCostInBytes, x$1)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long bytesPerCore = totalBytes / (long)defaultParallelism;
        long maxSplitBytes = BoxesRunTime.unboxToLong((Object)maybeReadParallelism.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)readParallelism -> totalBytes / (long)readParallelism + 1L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Math.max(minSplitBytes, Math.min(defaultMaxSplitBytes, Math.max(openCostInBytes, bytesPerCore)))));
        String paths = ((TraversableOnce)selectedPartitions.flatMap((Function1 & Serializable & scala.Serializable)pd -> (Seq)SparkAdapter$.MODULE$.instance().getPartitionFileStatuses(pd).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        this.log().info(new StringBuilder(126).append("Planning scan with bin packing, max size: ").append(maxSplitBytes).append(" bytes, ").append("open cost is considered as scanning ").append(openCostInBytes).append(" bytes, ").append("default parallelism is ").append(defaultParallelism).append(", ").append("paths: ").append(paths).toString());
        return maxSplitBytes;
    }

    /*
     * Unable to fully structure code
     */
    private Seq<PartitionedFile> splitTableYtPartitioning(YtHadoopPath path, long maxSplitBytes, InternalRow partitionValues, Option<StructType> readDataSchema, CompoundClient yt) {
        var9_6 = readDataSchema;
        if (!(var9_6 instanceof Some) || !(st = (StructType)(var10_7 = (Some)var9_6).value()).nonEmpty()) ** GOTO lbl-1000
        v0 = path.meta().optimizeMode();
        var12_9 = OptimizeMode.Scan$.MODULE$;
        if (!(v0 != null ? v0.equals(var12_9) == false : var12_9 != null)) {
            var7_10 = YtInputSplit$.MODULE$.addColumnsList(path.toYPath(), st);
        } else lbl-1000:
        // 2 sources

        {
            var7_10 = path.toYPath();
        }
        richYPath = var7_10;
        multiTablePartitions = YtWrapper$.MODULE$.splitTables(richYPath, maxSplitBytes, yt);
        return (Seq)multiTablePartitions.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$splitTableYtPartitioning$1(long org.apache.spark.sql.catalyst.InternalRow tech.ytsaurus.spyt.fs.YtHadoopPath tech.ytsaurus.client.request.MultiTablePartition ), (Ltech/ytsaurus/client/request/MultiTablePartition;)Lscala/collection/mutable/Buffer;)((long)maxSplitBytes, (InternalRow)partitionValues, (YtHadoopPath)path), Seq$.MODULE$.canBuildFrom());
    }

    private Option<StructType> splitTableYtPartitioning$default$4() {
        return None$.MODULE$;
    }

    private Seq<PartitionedFile> splitStaticTableManual(YtHadoopPath path, long maxSplitBytes, InternalRow partitionValues) {
        Nil$ nil$;
        if (path.meta().rowCount() != 0L) {
            long partitionCount = path.meta().size() / maxSplitBytes + 1L;
            long partitionRowCount = (path.meta().rowCount() + partitionCount - 1L) / partitionCount;
            long nonEmptyPartitionCount = (path.meta().rowCount() + partitionRowCount - 1L) / partitionRowCount;
            nil$ = (Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nonEmptyPartitionCount)).map((Function1 & Serializable & scala.Serializable)partitionIndex -> YtFilePartition$.$anonfun$splitStaticTableManual$1(partitionRowCount, path, partitionValues, BoxesRunTime.unboxToLong((Object)partitionIndex)), IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private Seq<PartitionedFile> splitDynamicTableManual(YtHadoopPath path, Seq<String> keyColumns, InternalRow partitionValues, CompoundClient yt) {
        Seq seq;
        if (keyColumns.isEmpty()) {
            long tabletCount = YtWrapper$.MODULE$.tabletCount(path.toYPath().justPath().toStableString(), yt);
            seq = (Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)tabletCount)).map((Function1 & Serializable & scala.Serializable)tabletIndex -> YtFilePartition$.$anonfun$splitDynamicTableManual$1(BoxesRunTime.unboxToLong((Object)tabletIndex)), IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            Seq pivotKeys = YtWrapper$.MODULE$.pivotKeysYson(path.toYPath().justPath(), yt);
            seq = (Seq)pivotKeys.map((Function1 & Serializable & scala.Serializable)key -> RangeLimit.key((java.util.List)key.asList()), Seq$.MODULE$.canBuildFrom());
        }
        Seq limits = seq;
        Seq allLimits = (Seq)limits.$colon$plus((Object)RangeLimit.builder().build(), Seq$.MODULE$.canBuildFrom());
        long approximatePartitionLength = limits.nonEmpty() ? path.meta().size() / (long)limits.length() : 0L;
        return allLimits.sliding(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            RangeLimit lowerLimit = (RangeLimit)((SeqLike)some.get()).apply(0);
            RangeLimit upperLimit = (RangeLimit)((SeqLike)some.get()).apply(1);
            YPath yPath = path.toYPath().withRange(lowerLimit, upperLimit);
            PartitionedFile partitionedFile = YtPartitionedFileDelegate$.MODULE$.apply(yPath, approximatePartitionLength, partitionValues, path);
            return partitionedFile;
        }).toSeq();
    }

    public Seq<PartitionedFile> splitFiles(SparkSession sparkSession, FileStatus file, Path filePath, long maxSplitBytes, InternalRow partitionValues, Option<StructType> readDataSchema) {
        Seq<PartitionedFile> seq;
        Path path = YtHadoopPath$.MODULE$.fromPath(file.getPath());
        if (path instanceof YtHadoopPath) {
            YtHadoopPath ytHadoopPath = (YtHadoopPath)path;
            CompoundClient yt = YtClientProvider$.MODULE$.ytClientWithProxy((Function0 & Serializable & scala.Serializable)() -> YtClientConfigurationConverter$.MODULE$.ytClientConfiguration(sparkSession.sessionState().conf()), ytHadoopPath.ypath().cluster());
            Seq keyColumns = YtWrapper$.MODULE$.keyColumns(ytHadoopPath.toYPath(), ytHadoopPath.ypath().transaction(), yt);
            seq = BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.SparkYtSparkSession(sparkSession).ytConf((ConfigEntry)SparkYtConfiguration$Read$YtPartitioningEnabled$.MODULE$)) && (!ytHadoopPath.meta().isDynamic() || !keyColumns.isEmpty()) ? this.splitTableYtPartitioning(ytHadoopPath, maxSplitBytes, partitionValues, readDataSchema, yt) : (ytHadoopPath.meta().isDynamic() ? this.splitDynamicTableManual(ytHadoopPath, (Seq<String>)keyColumns, partitionValues, yt) : this.splitStaticTableManual(ytHadoopPath, maxSplitBytes, partitionValues));
        } else {
            seq = (Seq<PartitionedFile>)new .colon.colon((Object)SparkAdapter$.MODULE$.instance().createPartitionedFile(partitionValues, filePath.toUri().toString(), 0L, file.getLen()), (List)Nil$.MODULE$);
        }
        return seq;
    }

    public Option<StructType> splitFiles$default$6() {
        return None$.MODULE$;
    }

    public Ordering<PartitionedFile> partitionedFilesOrdering() {
        return this.partitionedFilesOrdering;
    }

    public Option<Seq<FilePartition>> tryGetKeyPartitions(SparkSession sparkSession, Seq<PartitionedFile> splitFiles, StructType schema, KeyPartitioningConfig keyPartitioningConfig, Option<Seq<String>> requiredKeysO) {
        None$ none$;
        Seq<String> keys = SchemaConverter$.MODULE$.prefixKeys(schema);
        this.log().info(new StringBuilder(44).append("Partitioned table has keys ").append(keys.toString()).append(". ").append("Required keys: ").append(requiredKeysO.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).toString());
        if (keys.nonEmpty() && keyPartitioningConfig.enabled() && requiredKeysO.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)keys.startsWith((GenSeq)x$4)))) {
            boolean isSupportedFiles = splitFiles.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YtFilePartition$.$anonfun$tryGetKeyPartitions$4(x0$1)));
            if (isSupportedFiles) {
                this.log().info("Key partitioning supports all files");
                Seq<PartitionedFile> ytSplitFiles = splitFiles;
                if (ytSplitFiles.isEmpty()) {
                    this.log().warn("Empty file list");
                    none$ = new Some((Object)Nil$.MODULE$);
                } else {
                    PartitionedFile headFile = (PartitionedFile)ytSplitFiles.head();
                    boolean tryToUseKeyPartitioning = ytSplitFiles.forall((Function1 & Serializable & scala.Serializable)splitFile -> BoxesRunTime.boxToBoolean((boolean)YtFilePartition$.$anonfun$tryGetKeyPartitions$5(headFile, splitFile)));
                    if (tryToUseKeyPartitioning) {
                        None$ none$2;
                        Option<Seq<PartitionedFile>> keyPartitioning;
                        Option<Seq<PartitionedFile>> option;
                        CompoundClient yt = YtClientProvider$.MODULE$.ytClientWithProxy((Function0 & Serializable & scala.Serializable)() -> YtClientConfigurationConverter$.MODULE$.ytClientConfiguration(sparkSession.sessionState().conf()), ((YtPartitionedFileDelegate)((YtPartitioningSupport)headFile).delegate()).cluster());
                        Option<Seq<String>> option2 = requiredKeysO;
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            Seq requiredKeys = (Seq)some.value();
                            option = this.getKeyPartitions(schema, (Seq<String>)requiredKeys, ytSplitFiles, keyPartitioningConfig, yt);
                        } else if (None$.MODULE$.equals(option2)) {
                            option = this.collectFirstKeyPartitions(schema, keys, ytSplitFiles, keyPartitioningConfig, yt);
                        } else {
                            throw new MatchError(option2);
                        }
                        Option<Seq<PartitionedFile>> option3 = keyPartitioning = option;
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            Seq partitions = (Seq)some.value();
                            this.log().info(new StringBuilder(34).append("Used key partitioning for key set ").append(keys.toString()).toString());
                            none$2 = new Some(this.getFilePartitions((Seq<PartitionedFile>)partitions));
                        } else if (None$.MODULE$.equals(option3)) {
                            this.log().info("Unsuccessful using of key partitioning");
                            none$2 = None$.MODULE$;
                        } else {
                            throw new MatchError(option3);
                        }
                        none$ = none$2;
                    } else {
                        this.log().info("Reading few tables try");
                        none$ = None$.MODULE$;
                    }
                }
            } else {
                this.log().info("Unsupported files found");
                none$ = None$.MODULE$;
            }
        } else {
            this.log().info("Key partitioning hasn't been tried");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<String>> tryGetKeyPartitions$default$5() {
        return None$.MODULE$;
    }

    public Seq<FilePartition> getFilePartitions(Seq<PartitionedFile> partitionedFiles) {
        return (Seq)((TraversableLike)partitionedFiles.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PartitionedFile x = (PartitionedFile)tuple2._1();
            int i = tuple2._2$mcI$sp();
            FilePartition filePartition = new FilePartition(i, (PartitionedFile[])((Object[])new PartitionedFile[]{x}));
            return filePartition;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Seq<PartitionedFile>> collectFirstKeyPartitions(StructType schema, Seq<String> keys, Seq<PartitionedFile> splitFiles, KeyPartitioningConfig keyPartitioningConfig, CompoundClient yt) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), keys.size()).collectFirst(Function$.MODULE$.unlift((Function1 & Serializable & scala.Serializable)colCount -> YtFilePartition$.MODULE$.getKeyPartitions(schema, (Seq<String>)((Seq)keys.take(BoxesRunTime.unboxToInt((Object)colCount))), (Seq<PartitionedFile>)splitFiles, keyPartitioningConfig, yt)));
    }

    private boolean checkAllFilesType(Seq<PartitionedFile> splitFiles, boolean isDynamic) {
        return splitFiles.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YtFilePartition$.$anonfun$checkAllFilesType$1(isDynamic, x0$1)));
    }

    private Option<Seq<PartitionedFile>> getKeyPartitions(StructType schema, Seq<String> currentKeys, Seq<PartitionedFile> splitFiles, KeyPartitioningConfig keyPartitioningConfig, CompoundClient yt) {
        None$ none$;
        this.log().info(new StringBuilder(44).append(currentKeys.length()).append(" columns try for key partitioning. Key set: ").append(currentKeys).toString());
        StructType keySchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)currentKeys.contains((Object)f.name()))));
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keySchema.fields())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        Seq<String> seq2 = currentKeys;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            this.log().error(new StringBuilder(55).append("Key partitioning schema is ").append(keySchema).append(", but other keys (").append(currentKeys).append(") required").toString());
            none$ = None$.MODULE$;
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keySchema.fields())).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ExpressionTransformer$.MODULE$.isSupportedDataType(f.dataType())))) {
            this.log().info("All columns are supported for key partitioning");
            boolean isStatic = this.checkAllFilesType(splitFiles, false);
            boolean isDynamic = this.checkAllFilesType(splitFiles, true);
            if (isStatic || isDynamic) {
                Seq seq3;
                if (isStatic) {
                    this.log().info("Retrieving pivot keys from static tables");
                    seq3 = this.getPivotKeys(keySchema, currentKeys, splitFiles, yt);
                } else {
                    this.log().info("Using keys of dynamic tables");
                    seq3 = (Seq)splitFiles.map((Function1 & Serializable & scala.Serializable)ypf -> {
                        TuplePoint beginPoint = (TuplePoint)((YtPartitionedFileDelegate)((YtPartitioningSupport)ypf).delegate()).beginPoint().get();
                        return new TuplePoint((Seq<Point>)((Seq)beginPoint.points().take(currentKeys.length())));
                    }, Seq$.MODULE$.canBuildFrom());
                }
                Seq pivotKeys = seq3;
                this.log().info(new StringBuilder(12).append("Pivot keys: ").append(pivotKeys.mkString(", ")).toString());
                Seq filesGroupedByKey = this.seqGroupBy((Seq)pivotKeys.zip(splitFiles, Seq$.MODULE$.canBuildFrom()));
                if (filesGroupedByKey.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YtFilePartition$.$anonfun$getKeyPartitions$5(keyPartitioningConfig, x0$1)))) {
                    this.log().info("Coalesced partitions satisfy union limit");
                    none$ = new Some(this.getFilesWithUniquePivots(currentKeys, filesGroupedByKey));
                } else {
                    this.log().info("Coalesced partitions don't satisfy union limit");
                    none$ = None$.MODULE$;
                }
            } else {
                this.log().info("Selected files have different types");
                none$ = None$.MODULE$;
            }
        } else {
            this.log().info("Not all columns are supported for key partitioning");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Seq<PartitionedFile> getFilesWithUniquePivots(Seq<String> keys, Seq<Tuple2<TuplePoint, Seq<PartitionedFile>>> filesGroupedByPoint) {
        Seq res;
        TuplePoint maxPoint = new TuplePoint((Seq<Point>)((Seq)new .colon.colon((Object)new PInfinity(), (List)Nil$.MODULE$)));
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)filesGroupedByPoint.reverse()).foldLeft((Object)new Tuple2((Object)maxPoint, (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Seq res;
            TuplePoint nextPoint;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    nextPoint = (TuplePoint)tuple23._1();
                    res = (Seq)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            TuplePoint curPoint = (TuplePoint)tuple2._1();
            Seq curFiles = (Seq)tuple2._2();
            PartitionedFile partitionedFile = MODULE$.putPivotKeysToFile((PartitionedFile)curFiles.head(), keys, curPoint, nextPoint);
            Tuple2 tuple24 = new Tuple2((Object)curPoint, res.$plus$colon((Object)partitionedFile, Seq$.MODULE$.canBuildFrom()));
            return tuple24;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq seq = res = (Seq)tuple2._2();
        Seq res2 = seq;
        return res2;
    }

    public Seq<TuplePoint> getPivotKeys(StructType schema, Seq<String> keys, Seq<PartitionedFile> files, CompoundClient yt) {
        Seq seq;
        YPath pathWithRanges;
        Path hadoopPath = SparkAdapter$.MODULE$.instance().getHadoopFilePath((PartitionedFile)files.head());
        YPath basePath = YPathEnriched$.MODULE$.fromPath(hadoopPath, YPathEnriched$.MODULE$.fromPath$default$2()).toYPath().withColumns((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        YPath x$1 = pathWithRanges = (YPath)((TraversableOnce)((TraversableLike)files.tail()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)YtFilePartition$.$anonfun$getPivotKeys$1(x$7)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)basePath, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> YtFilePartition$.$anonfun$getPivotKeys$2(x0$1, BoxesRunTime.unboxToLong((Object)x1$1)));
        InternalRowDeserializer x$2 = InternalRowDeserializer$.MODULE$.getOrCreate(schema, InternalRowDeserializer$.MODULE$.getOrCreate$default$2());
        JFunction1.mcVJ.sp & Serializable & scala.Serializable x$3 = (JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$8 -> {};
        Duration x$4 = YtWrapper$.MODULE$.readTable$default$3();
        Option x$5 = YtWrapper$.MODULE$.readTable$default$4();
        try (TableIterator tableIterator = YtWrapper$.MODULE$.readTable(x$1, (WireRowDeserializer)x$2, x$4, x$5, (Function1)x$3, yt);){
            TuplePoint tuplePoint = new TuplePoint((Seq<Point>)((Seq)new .colon.colon((Object)new MInfinity(), (List)Nil$.MODULE$)));
            seq = (Seq)((SeqLike)this.getParsedRows((Iterator<InternalRow>)tableIterator, schema).$plus$colon((Object)tuplePoint, Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        }
        return seq;
    }

    private Seq<TuplePoint> getParsedRows(Iterator<InternalRow> iterator, StructType schema) {
        return iterator.map((Function1 & Serializable & scala.Serializable)row -> new TuplePoint((Seq<Point>)((Seq)row.toSeq(schema).map((Function1 & Serializable & scala.Serializable)x$10 -> (Point)ExpressionTransformer$.MODULE$.parseOrderedLiteral(x$10).get(), Seq$.MODULE$.canBuildFrom())))).toSeq();
    }

    private PartitionedFile putPivotKeysToFile(PartitionedFile file, Seq<String> keys, TuplePoint start, TuplePoint end) {
        return ((YtPartitionedFileDelegate)((YtPartitioningSupport)file).delegate()).copy(this.getByteKey(keys, start), this.getByteKey(keys, end));
    }

    private byte[] getByteKey(Seq<String> columns, TuplePoint key) {
        return PivotKeysConverter$.MODULE$.toByteArray((Seq<YTreeNode>)((TraversableOnce)((TraversableLike)key.points().take(columns.length())).map((Function1 & Serializable & scala.Serializable)point -> PivotKeysConverter$.MODULE$.prepareKey((Point)point), Seq$.MODULE$.canBuildFrom())).toList());
    }

    public Seq<TuplePoint> getPivotFromHintFiles(Seq<String> keys, Seq<FilePartition> files) {
        return (Seq)((TraversableLike)files.drop(1)).map((Function1 & Serializable & scala.Serializable)file -> MODULE$.getTuplePoint(keys, ((YtPartitionedFileDelegate)((YtPartitioningSupport)file.files()[0]).delegate()).beginKey()), Seq$.MODULE$.canBuildFrom());
    }

    private TuplePoint getTuplePoint(Seq<String> columns, Seq<YTreeNode> key) {
        return (TuplePoint)PivotKeysConverter$.MODULE$.toPoint((Seq<YTreeNode>)((Seq)key.take(columns.length()))).get();
    }

    public <K, V> Seq<Tuple2<K, Seq<V>>> seqGroupBy(Seq<Tuple2<K, V>> valuesWithKeys) {
        return (Seq)((TraversableOnce)valuesWithKeys.reverse()).foldLeft((Object)Nil$.MODULE$, YtFilePartition$::$anonfun$seqGroupBy$1);
    }

    public Seq<FilePartition> addPivots(Seq<FilePartition> partitioning, Seq<String> keys, Seq<TuplePoint> pivots) {
        Seq res = (Seq)partitioning.flatMap((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionedFile file = partition.files()[0];
            TuplePoint fileStart = MODULE$.getTuplePoint(keys, ((YtPartitionedFileDelegate)((YtPartitioningSupport)file).delegate()).beginKey());
            TuplePoint fileEnd = MODULE$.getTuplePoint(keys, ((YtPartitionedFileDelegate)((YtPartitioningSupport)file).delegate()).endKey());
            Seq pivotsInSegment = (Seq)pivots.filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)YtFilePartition$.$anonfun$addPivots$2(fileStart, fileEnd, tp)));
            TuplePoint tuplePoint = fileStart;
            Seq starts = (Seq)pivotsInSegment.$plus$colon((Object)tuplePoint, Seq$.MODULE$.canBuildFrom());
            Seq ends = (Seq)pivotsInSegment.$colon$plus((Object)fileEnd, Seq$.MODULE$.canBuildFrom());
            return (Seq)((TraversableLike)starts.zip((GenIterable)ends, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TuplePoint start = (TuplePoint)tuple2._1();
                TuplePoint end = (TuplePoint)tuple2._2();
                PartitionedFile partitionedFile = MODULE$.putPivotKeysToFile(file, keys, start, end);
                return partitionedFile;
            }, Seq$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom());
        return this.getFilePartitions((Seq<PartitionedFile>)res);
    }

    public static final /* synthetic */ long $anonfun$maxSplitBytes$2(long openCostInBytes$1, FileStatus x$1) {
        return x$1.getLen() + openCostInBytes$1;
    }

    public static final /* synthetic */ Buffer $anonfun$splitTableYtPartitioning$1(long maxSplitBytes$1, InternalRow partitionValues$1, YtHadoopPath path$1, MultiTablePartition multiTablePartition) {
        Buffer tableRanges = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(multiTablePartition.getTableRanges()).asScala();
        return (Buffer)tableRanges.flatMap((Function1 & Serializable & scala.Serializable)tableRange -> {
            Buffer ranges = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tableRange.getRanges()).asScala();
            return (Buffer)ranges.map((Function1 & Serializable & scala.Serializable)range -> {
                YPath ypathWithSingleRange = tableRange.ranges(new RangeCriteria[]{range});
                return YtPartitionedFileDelegate$.MODULE$.apply(ypathWithSingleRange, maxSplitBytes$1, partitionValues$1, path$1);
            }, Buffer$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ PartitionedFile $anonfun$splitStaticTableManual$1(long partitionRowCount$1, YtHadoopPath path$2, InternalRow partitionValues$2, long partitionIndex) {
        long partitionStart = partitionIndex * partitionRowCount$1;
        long partitionEnd = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((partitionIndex + 1L) * partitionRowCount$1), path$2.meta().rowCount());
        Predef$.MODULE$.require(partitionEnd > partitionStart);
        long approximatePartitionLength = (partitionEnd - partitionStart) * path$2.meta().approximateRowSize();
        YPath yPath = path$2.toYPath().withRange(partitionStart, partitionEnd);
        return YtPartitionedFileDelegate$.MODULE$.apply(yPath, approximatePartitionLength, partitionValues$2, path$2);
    }

    public static final /* synthetic */ RangeLimit $anonfun$splitDynamicTableManual$1(long tabletIndex) {
        return RangeLimit.builder().setTabletIndex(tabletIndex).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int org$apache$spark$sql$v2$YtFilePartition$$$anonfun$partitionedFilesOrdering$1(PartitionedFile x, PartitionedFile y) {
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            PartitionedFile xYt = (PartitionedFile)tuple2._1();
            PartitionedFile yYt = (PartitionedFile)tuple2._2();
            if (xYt instanceof YtPartitioningSupport) {
                PartitionedFile partitionedFile = xYt;
                if (yYt instanceof YtPartitioningSupport) {
                    PartitionedFile partitionedFile2 = yYt;
                    String string = ((YtPartitioningSupport)partitionedFile).path();
                    String string2 = ((YtPartitioningSupport)partitionedFile2).path();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        if (!((YtPartitionedFileDelegate)((YtPartitioningSupport)partitionedFile).delegate()).isDynamic() && !((YtPartitionedFileDelegate)((YtPartitioningSupport)partitionedFile2).delegate()).isDynamic()) {
                            return new RichLong(Predef$.MODULE$.longWrapper(((YtPartitionedFileDelegate)((YtPartitioningSupport)partitionedFile).delegate()).beginRow())).compare((Object)BoxesRunTime.boxToLong((long)((YtPartitionedFileDelegate)((YtPartitioningSupport)partitionedFile2).delegate()).beginRow()));
                        }
                    }
                }
            }
        }
        if (tuple2 != null) {
            PartitionedFile xYt = (PartitionedFile)tuple2._1();
            PartitionedFile yYt = (PartitionedFile)tuple2._2();
            if (xYt instanceof YtPartitioningSupport) {
                PartitionedFile partitionedFile = xYt;
                if (yYt instanceof YtPartitioningSupport) {
                    PartitionedFile partitionedFile3 = yYt;
                    return new StringOps(Predef$.MODULE$.augmentString(((YtPartitioningSupport)partitionedFile).path())).compare(((YtPartitioningSupport)partitionedFile3).path());
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof YtPartitioningSupport) {
            return -1;
        }
        if (tuple2 != null && tuple2._2() instanceof YtPartitioningSupport) {
            return 1;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return new RichLong(Predef$.MODULE$.longWrapper(y.length())).compare((Object)BoxesRunTime.boxToLong((long)x.length()));
    }

    public static final /* synthetic */ boolean $anonfun$tryGetKeyPartitions$4(PartitionedFile x0$1) {
        PartitionedFile partitionedFile = x0$1;
        boolean bl = partitionedFile instanceof YtPartitioningSupport;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$tryGetKeyPartitions$5(PartitionedFile headFile$1, PartitionedFile splitFile) {
        String string = SparkAdapter$.MODULE$.instance().getStringFilePath(headFile$1);
        String string2 = SparkAdapter$.MODULE$.instance().getStringFilePath(splitFile);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkAllFilesType$1(boolean isDynamic$1, PartitionedFile x0$1) {
        PartitionedFile partitionedFile;
        PartitionedFile partitionedFile2 = x0$1;
        boolean bl = partitionedFile2 != null ? ((YtPartitionedFileDelegate)((YtPartitioningSupport)(partitionedFile = partitionedFile2)).delegate()).isDynamic() == isDynamic$1 : false;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getKeyPartitions$5(KeyPartitioningConfig keyPartitioningConfig$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq files = (Seq)tuple2._2();
        boolean bl = files.length() <= keyPartitioningConfig$2.unionLimit();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$getPivotKeys$1(PartitionedFile x$7) {
        return ((YtPartitionedFileDelegate)((YtPartitioningSupport)x$7).delegate()).beginRow();
    }

    public static final /* synthetic */ YPath $anonfun$getPivotKeys$2(YPath x0$1, long x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToLong((long)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        YPath path = (YPath)tuple2._1();
        long br = tuple2._2$mcJ$sp();
        YPath yPath = path.withRange(br, br + 1L);
        return yPath;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Seq $anonfun$seqGroupBy$1(Seq x0$1, Tuple2 x1$1) {
        block3: {
            block2: {
                var4_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (var4_2 == null) break block2;
                acc = (Seq)var4_2._1();
                var6_4 = (Tuple2)var4_2._2();
                if (var6_4 == null) break block2;
                curKey = var6_4._1();
                curValue = var6_4._2();
                var9_7 = acc;
                if (!(var9_7 instanceof .colon.colon)) ** GOTO lbl-1000
                var10_8 = (.colon.colon)var9_7;
                var11_9 = (Tuple2)var10_8.head();
                tail = var10_8.tl$access$1();
                if (var11_9 == null) ** GOTO lbl-1000
                prevKey = var11_9._1();
                prevValues = (Seq)var11_9._2();
                if (BoxesRunTime.equals((Object)prevKey, (Object)curKey)) {
                    var16_13 = curValue;
                    var15_14 = new Tuple2(prevKey, prevValues.$plus$colon(var16_13, Seq$.MODULE$.canBuildFrom()));
                    var3_15 = (Seq)tail.$plus$colon((Object)var15_14, List$.MODULE$.canBuildFrom());
                } else lbl-1000:
                // 3 sources

                {
                    var17_16 = new Tuple2(curKey, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{curValue})));
                    var3_15 = (Seq)acc.$plus$colon((Object)var17_16, Seq$.MODULE$.canBuildFrom());
                }
                break block3;
            }
            throw new MatchError((Object)var4_2);
        }
        var2_17 = var3_15;
        return var2_17;
    }

    public static final /* synthetic */ boolean $anonfun$addPivots$2(TuplePoint fileStart$1, TuplePoint fileEnd$1, TuplePoint tp) {
        return fileStart$1.$less(tp) && tp.$less(fileEnd$1);
    }

    private YtFilePartition$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.partitionedFilesOrdering = new Ordering<PartitionedFile>(){
            public static final long serialVersionUID = 0L;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<PartitionedFile> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, PartitionedFile> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public final int compare(PartitionedFile x, PartitionedFile y) {
                return YtFilePartition$.org$apache$spark$sql$v2$YtFilePartition$$$anonfun$partitionedFilesOrdering$1(x, y);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }
}

