/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.v2;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.v2.YtUtils;
import org.apache.spark.sql.v2.YtUtils$Options$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.spyt.fs.YtFileSystemBase;
import tech.ytsaurus.spyt.fs.YtHadoopPath;
import tech.ytsaurus.spyt.fs.path.YPathEnriched;
import tech.ytsaurus.spyt.fs.path.YPathEnriched$;
import tech.ytsaurus.spyt.serializers.SchemaConverter$;
import tech.ytsaurus.spyt.serializers.SchemaConverter$MetadataFields$;
import tech.ytsaurus.spyt.serializers.SchemaConverterConfig;
import tech.ytsaurus.spyt.serializers.SchemaConverterConfig$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.client.YtClientConfigurationConverter$;
import tech.ytsaurus.spyt.wrapper.client.YtClientProvider$;
import tech.ytsaurus.ysontree.YTreeNode;

public final class YtUtils$ {
    public static YtUtils$ MODULE$;
    private final Logger org$apache$spark$sql$v2$YtUtils$$log;
    private final Method structMergeMethod;
    private final int structMergeMethodArgCount;

    static {
        new YtUtils$();
    }

    public Logger org$apache$spark$sql$v2$YtUtils$$log() {
        return this.org$apache$spark$sql$v2$YtUtils$$log;
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        boolean enableMerge = parameters.get((Object)YtUtils$Options$.MODULE$.MERGE_SCHEMA()).orElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.conf().getOption("spark.sql.yt.mergeSchema")).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$inferSchema$2(x$1)));
        Seq<YtUtils.FileWithSchema> allSchemas = this.getFilesSchemas(sparkSession, parameters, files);
        return this.mergeFileSchemas(allSchemas, enableMerge);
    }

    private YPathEnriched getTablePath(FileStatus fileStatus) {
        YPathEnriched yPathEnriched;
        Path path = fileStatus.getPath();
        if (path instanceof YtHadoopPath) {
            YtHadoopPath ytHadoopPath = (YtHadoopPath)path;
            yPathEnriched = ytHadoopPath.ypath();
        } else {
            yPathEnriched = YPathEnriched$.MODULE$.fromPath(path.getParent(), YPathEnriched$.MODULE$.fromPath$default$2());
        }
        return yPathEnriched;
    }

    private StructType getSchema(SparkSession sparkSession, YPathEnriched path, Map<String, String> parameters) {
        return this.getSchema(sparkSession, path.toYPath(), (Option<String>)path.transaction(), (Option<String>)path.cluster(), parameters);
    }

    public StructType getSchema(SparkSession sparkSession, YPath path, Option<String> transaction, Option<String> proxy, Map<String, String> parameters) {
        CompoundClient yt = YtClientProvider$.MODULE$.ytClientWithProxy((Function0 & Serializable & scala.Serializable)() -> YtClientConfigurationConverter$.MODULE$.ytClientConfiguration(sparkSession), proxy);
        SchemaConverterConfig config = SchemaConverterConfig$.MODULE$.apply(sparkSession);
        boolean parsingTypeV3 = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)YtUtils$Options$.MODULE$.PARSING_TYPE_V3()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$getSchema$2(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> config.parsingTypeV3()));
        Option<StructType> schemaHint = SchemaConverter$.MODULE$.schemaHint(parameters);
        YTreeNode schemaTree = YtWrapper$.MODULE$.attribute(path, "schema", transaction, yt);
        return SchemaConverter$.MODULE$.sparkSchema(schemaTree, schemaHint, parsingTypeV3);
    }

    public Either<YtUtils.SchemaDiscrepancy, Option<StructType>> checkAllEquals(Seq<YtUtils.FileWithSchema> schemas) {
        return (Either)schemas.headOption().map((Function1 & Serializable & scala.Serializable)headSchema -> {
            Right right;
            Set headSchemaColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headSchema.schema().fields())).toSet();
            Option option = schemas.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$checkAllEquals$2(headSchemaColumns, x$3)));
            if (option instanceof Some) {
                Some some = (Some)option;
                YtUtils.FileWithSchema schemaNotEqual = (YtUtils.FileWithSchema)some.value();
                right = package$.MODULE$.Left().apply((Object)new YtUtils.SchemaDiscrepancy((YtUtils.FileWithSchema)headSchema, schemaNotEqual));
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Right().apply((Object)new Some((Object)headSchema.schema()));
            } else {
                throw new MatchError((Object)option);
            }
            return right;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)None$.MODULE$));
    }

    public StructType dropKeyFieldsMetadata(StructType schema) {
        return schema.copy((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.RichStructField((StructField)x$4).withKeyId(-1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public Seq<YtUtils.FileWithSchema> getFilesSchemas(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        List allSchemas;
        Tuple2 tuple2 = (Tuple2)files.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            FileStatus fileStatus = (FileStatus)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            Set curSet = (Set)tuple23._1();
            List schemas = (List)tuple23._2();
            YPathEnriched path = MODULE$.getTablePath(fileStatus);
            if (curSet.contains((Object)path)) {
                tuple2 = new Tuple2((Object)curSet, (Object)schemas);
                return tuple2;
            } else {
                YtUtils.FileWithSchema fileWithSchema = new YtUtils.FileWithSchema(fileStatus, MODULE$.getSchema(sparkSession, path, parameters));
                Tuple2 tuple24 = new Tuple2((Object)curSet.$plus((Object)path), schemas.$plus$colon((Object)fileWithSchema, List$.MODULE$.canBuildFrom()));
                tuple2 = tuple24;
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List list = allSchemas = (List)tuple2._2();
        List allSchemas2 = list;
        return allSchemas2;
    }

    private Seq<StructField> getKeys(YtUtils.FileWithSchema fileSchema) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSchema.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$getKeys$1(x$6))))).sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)YtUtils$.$anonfun$getKeys$2(x$7)), (Ordering)Ordering.Long$.MODULE$));
    }

    public Option<StructType> mergeFileSchemas(Seq<YtUtils.FileWithSchema> fileSchemas, boolean enableMerge) {
        Option option;
        if (enableMerge) {
            option = fileSchemas.headOption().map((Function1 & Serializable & scala.Serializable)head -> {
                Seq<StructField> keys = MODULE$.getKeys((YtUtils.FileWithSchema)head);
                StructType res = (StructType)((TraversableOnce)fileSchemas.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.schema(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.mergeStructTypes((StructType)x, (StructType)y));
                return fileSchemas.forall((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$mergeFileSchemas$4(keys, fs))) ? res : MODULE$.dropKeyFieldsMetadata(res);
            });
        } else {
            Option option2;
            Either<YtUtils.SchemaDiscrepancy, Option<StructType>> either = this.checkAllEquals(fileSchemas);
            if (either instanceof Left) {
                Option schema;
                Left left = (Left)either;
                YtUtils.SchemaDiscrepancy discrepancy = (YtUtils.SchemaDiscrepancy)left.value();
                discrepancy.logWarning();
                Seq schemasWithoutKeys = (Seq)fileSchemas.map((Function1 & Serializable & scala.Serializable)fileSchema -> {
                    StructType x$1 = MODULE$.dropKeyFieldsMetadata(fileSchema.schema());
                    FileStatus x$2 = fileSchema.copy$default$1();
                    return fileSchema.copy(x$2, x$1);
                }, Seq$.MODULE$.canBuildFrom());
                Either<YtUtils.SchemaDiscrepancy, Option<StructType>> either2 = this.checkAllEquals((Seq<YtUtils.FileWithSchema>)schemasWithoutKeys);
                if (either2 instanceof Left) {
                    Left left2 = (Left)either2;
                    YtUtils.SchemaDiscrepancy discrepancy2 = (YtUtils.SchemaDiscrepancy)left2.value();
                    throw discrepancy2.exception();
                }
                if (!(either2 instanceof Right)) {
                    throw new MatchError(either2);
                }
                Right right = (Right)either2;
                Option option3 = schema = (Option)right.value();
                option2 = option3;
            } else if (either instanceof Right) {
                Option schema;
                Right right = (Right)either;
                option2 = schema = (Option)right.value();
            } else {
                throw new MatchError(either);
            }
            option = option2;
        }
        return option;
    }

    private Method structMergeMethod() {
        return this.structMergeMethod;
    }

    private int structMergeMethodArgCount() {
        return this.structMergeMethodArgCount;
    }

    private StructType mergeStructTypes(StructType x, StructType y) {
        StructType structType;
        try {
            int n = this.structMergeMethodArgCount();
            switch (n) {
                case 1: {
                    structType = (StructType)this.structMergeMethod().invoke((Object)x, y);
                    break;
                }
                case 2: {
                    structType = x.merge(y, x.merge$default$2());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("More than 2 arguments is not supported for StructType.merge method");
                }
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return structType;
    }

    public YtUtils.RichStructField RichStructField(StructField field) {
        return new YtUtils.RichStructField(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Object, BoxedUnit> bytesReadReporter(Broadcast<SerializableConfiguration> conf) {
        String fsScheme;
        String string;
        String string2 = string = (fsScheme = FileSystem.getDefaultUri((Configuration)((SerializableConfiguration)conf.value()).value()).getScheme());
        String string3 = "yt";
        if (string2 == null) {
            if (string3 == null) return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)bytesRead -> {
                YtFileSystemBase ytFS = (YtFileSystemBase)FileSystem.get((Configuration)((SerializableConfiguration)conf.value()).value());
                ytFS.internalStatistics().incrementBytesRead(bytesRead);
                ytFS.close();
            };
        } else if (string2.equals(string3)) return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)bytesRead -> {
            YtFileSystemBase ytFS = (YtFileSystemBase)FileSystem.get((Configuration)((SerializableConfiguration)conf.value()).value());
            ytFS.internalStatistics().incrementBytesRead(bytesRead);
            ytFS.close();
        };
        String string4 = string;
        String string5 = "ytTable";
        if (string4 == null) {
            if (string5 == null) return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)bytesRead -> {
                YtFileSystemBase ytFS = (YtFileSystemBase)FileSystem.get((Configuration)((SerializableConfiguration)conf.value()).value());
                ytFS.internalStatistics().incrementBytesRead(bytesRead);
                ytFS.close();
            };
        } else if (string4.equals(string5)) {
            return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)bytesRead -> {
                YtFileSystemBase ytFS = (YtFileSystemBase)FileSystem.get((Configuration)((SerializableConfiguration)conf.value()).value());
                ytFS.internalStatistics().incrementBytesRead(bytesRead);
                ytFS.close();
            };
        }
        this.org$apache$spark$sql$v2$YtUtils$$log().warn(new StringBuilder(17).append("Unsupported uri: ").append(string).toString());
        return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$9 -> {};
    }

    public static final /* synthetic */ boolean $anonfun$inferSchema$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getSchema$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$checkAllEquals$2(Set headSchemaColumns$1, YtUtils.FileWithSchema x$3) {
        Set set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.schema().fields())).toSet();
        Set set2 = headSchemaColumns$1;
        return set == null ? set2 != null : !set.equals(set2);
    }

    public static final /* synthetic */ boolean $anonfun$getKeys$1(StructField x$6) {
        return x$6.metadata().getLong(SchemaConverter$MetadataFields$.MODULE$.KEY_ID()) >= 0L;
    }

    public static final /* synthetic */ long $anonfun$getKeys$2(StructField x$7) {
        return x$7.metadata().getLong(SchemaConverter$MetadataFields$.MODULE$.KEY_ID());
    }

    public static final /* synthetic */ boolean $anonfun$mergeFileSchemas$4(Seq keys$1, YtUtils.FileWithSchema fs) {
        Seq<StructField> seq = MODULE$.getKeys(fs);
        Seq seq2 = keys$1;
        return !(seq != null ? !seq.equals((Object)seq2) : seq2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$structMergeMethod$1(Method m) {
        String string = m.getName();
        String string2 = "merge";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private YtUtils$() {
        MODULE$ = this;
        this.org$apache$spark$sql$v2$YtUtils$$log = LoggerFactory.getLogger(this.getClass());
        this.structMergeMethod = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StructType.class.getMethods())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)YtUtils$.$anonfun$structMergeMethod$1(m))).get();
        this.structMergeMethodArgCount = this.structMergeMethod().getParameterTypes().length;
    }
}

