/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.fs.YtFileStatus$;
import tech.ytsaurus.spyt.fs.YtFileSystemBase;
import tech.ytsaurus.spyt.fs.YtHadoopPath;
import tech.ytsaurus.spyt.fs.YtTableMeta;
import tech.ytsaurus.spyt.fs.path.YPathEnriched;
import tech.ytsaurus.spyt.fs.path.YPathEnriched$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.cypress.PathType;
import tech.ytsaurus.spyt.wrapper.cypress.PathType$;
import tech.ytsaurus.spyt.wrapper.table.OptimizeMode;
import tech.ytsaurus.spyt.wrapper.table.TableType;
import tech.ytsaurus.ysontree.YTreeNode;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\t\u0012\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\u0006[\u0001!\tE\f\u0005\u0006[\u0001!Ia\u0011\u0005\b3\u0002\t\n\u0011\"\u0003[\u0011\u00159\u0007\u0001\"\u0003i\u0011\u0015a\u0007\u0001\"\u0003n\u0011)\ty\u0001\u0001EC\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002(\u0001!I!!\f\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u00026!I\u0011q\b\u0001\u0012\u0002\u0013%\u0011\u0011\t\u0002\u00123R$\u0016M\u00197f\r&dWmU=ti\u0016l'B\u0001\n\u0014\u0003\t17O\u0003\u0002\u0015+\u0005!1\u000f]=u\u0015\t1r#\u0001\u0005ziN\fWO];t\u0015\u0005A\u0012\u0001\u0002;fG\"\u001c\u0001a\u0005\u0002\u00017A\u0011A$H\u0007\u0002#%\u0011a$\u0005\u0002\u00113R4\u0015\u000e\\3TsN$X-\u001c\"bg\u0016\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011a\u00017pOV\tA\u0005\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)1\u000f\u001c45U*\t\u0011&A\u0002pe\u001eL!a\u000b\u0014\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u00151L7\u000f^*uCR,8\u000f\u0006\u00020}A\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012Q!\u0011:sCf\u0004\"A\u000e\u001f\u000e\u0003]R!A\u0005\u001d\u000b\u0005eR\u0014A\u00025bI>|\u0007O\u0003\u0002<Q\u00051\u0011\r]1dQ\u0016L!!P\u001c\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003@\t\u0001\u0007\u0001)A\u0001g!\t1\u0014)\u0003\u0002Co\t!\u0001+\u0019;i)\r!U\n\u0016\u000b\u0003_\u0015CqAR\u0003\u0011\u0002\u0003\u000fq)\u0001\u0002ziB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*F\u0001\u0007G2LWM\u001c;\n\u00051K%AD\"p[B|WO\u001c3DY&,g\u000e\u001e\u0005\u0006\u001d\u0016\u0001\raT\u0001\u0005a\u0006$\b\u000e\u0005\u0002Q%6\t\u0011K\u0003\u0002O#%\u00111+\u0015\u0002\u000e3B\u000bG\u000f[#oe&\u001c\u0007.\u001a3\t\u000bU+\u0001\u0019\u0001,\u0002\u001f\u0015D\b/\u00198e\t&\u0014Xm\u0019;pef\u0004\"\u0001M,\n\u0005a\u000b$a\u0002\"p_2,\u0017M\\\u0001\u0015Y&\u001cHo\u0015;biV\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0015\u0007m+gM\u000b\u0002H9.\nQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003EF\n!\"\u00198o_R\fG/[8o\u0013\t!wLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQA\u0014\u0004A\u0002=CQ!\u0016\u0004A\u0002Y\u000bq\u0002\\5tif#H)\u001b:fGR|'/\u001f\u000b\u0003S.$\"a\f6\t\u000b\u0019;\u00019A$\t\u000b9;\u0001\u0019A(\u0002\u00131|7m\u001b+bE2,Gc\u00018qcR\u0011Qg\u001c\u0005\u0006\r\"\u0001\u001da\u0012\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u0006e\"\u0001\ra]\u0001\u000bCR$(/\u001b2vi\u0016\u001c\b#\u0002;|}\u0006\raBA;z!\t1\u0018'D\u0001x\u0015\tA\u0018$\u0001\u0004=e>|GOP\u0005\u0003uF\na\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\ri\u0015\r\u001d\u0006\u0003uF\u0002\"\u0001^@\n\u0007\u0005\u0005QP\u0001\u0004TiJLgn\u001a\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u000b\u0002\u0011e\u001cxN\u001c;sK\u0016LA!!\u0004\u0002\b\tI\u0011\f\u0016:fK:{G-Z\u0001\tSN$%/\u001b<feV\ta+A\bm_\u000e\\7\u000b^1uS\u000e$\u0016M\u00197f)\u0011\t9\"a\u0007\u0015\u0007U\nI\u0002C\u0003G\u0015\u0001\u000fq\tC\u0003O\u0015\u0001\u0007q*\u0001\tm_\u000e\\G)\u001f8b[&\u001cG+\u00192mKR!\u0011\u0011EA\u0013)\r)\u00141\u0005\u0005\u0006\r.\u0001\u001da\u0012\u0005\u0006\u001d.\u0001\raT\u0001\u000eO\u0016$h)\u001b7f'R\fG/^:\u0015\u0007U\nY\u0003C\u0003@\u0019\u0001\u0007\u0001\t\u0006\u0003\u00020\u0005MBcA\u001b\u00022!)a)\u0004a\u0002\u000f\")a*\u0004a\u0001\u001fR1\u0011qGA\u001e\u0003{!2!NA\u001d\u0011\u001d1e\u0002%AA\u0004\u001dCQa\u0010\bA\u0002\u0001CQA\u0014\bA\u0002=\u000bqcZ3u\r&dWm\u0015;biV\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0015\u000bm\u000b\u0019%!\u0012\t\u000b}z\u0001\u0019\u0001!\t\u000b9{\u0001\u0019A()\u000f\u0001\tI%a\u0014\u0002RA\u0019\u0001'a\u0013\n\u0007\u00055\u0013G\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0011\u0001")
public class YtTableFileSystem
extends YtFileSystemBase {
    public static final long serialVersionUID = 1L;
    private boolean isDriver;
    private final Logger log = LoggerFactory.getLogger((Class)this.getClass());
    private volatile boolean bitmap$0;

    private Logger log() {
        return this.log;
    }

    public FileStatus[] listStatus(Path f) {
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("List status ").append(f).toString());
        YPathEnriched x$1 = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        boolean x$2 = true;
        CompoundClient x$3 = this.listStatus$default$3(x$1, x$2);
        return this.listStatus(x$1, x$2, x$3);
    }

    private FileStatus[] listStatus(YPathEnriched path, boolean expandDirectory, CompoundClient yt) {
        FileStatus[] fileStatusArray;
        if (!YtWrapper$.MODULE$.exists(path.toYPath(), path.transaction(), yt)) {
            throw new FileNotFoundException(path.toStringPath());
        }
        Map attributes = YtWrapper$.MODULE$.attributes(path.toYPath(), path.transaction(), YtWrapper$.MODULE$.attributes$default$3(), yt);
        PathType pathType = PathType$.MODULE$.fromAttributes(attributes);
        if (PathType.File$.MODULE$.equals(pathType)) {
            fileStatusArray = (FileStatus[])((Object[])new FileStatus[]{this.getFileStatus(path.lock(yt), yt)});
        } else if (PathType.Table$.MODULE$.equals(pathType)) {
            fileStatusArray = (FileStatus[])((Object[])new FileStatus[]{this.lockTable(path, (Map<String, YTreeNode>)attributes, yt)});
        } else if (PathType.Directory$.MODULE$.equals(pathType)) {
            fileStatusArray = expandDirectory ? this.listYtDirectory(path, yt) : (FileStatus[])((Object[])new FileStatus[]{this.getFileStatus(path, yt)});
        } else {
            throw new IllegalArgumentException(new StringBuilder(11).append("Can't list ").append(pathType).toString());
        }
        return fileStatusArray;
    }

    private CompoundClient listStatus$default$3(YPathEnriched path, boolean expandDirectory) {
        return this.ytClient(path);
    }

    private FileStatus[] listYtDirectory(YPathEnriched path, CompoundClient yt) {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])YtWrapper$.MODULE$.listDir(path.toYPath(), path.transaction(), yt))).flatMap((Function1 & Serializable & scala.Serializable)name -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listStatus(path.child(name), false, yt))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
    }

    private FileStatus lockTable(YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        FileStatus fileStatus;
        TableType tableType = YtWrapper$.MODULE$.tableType(attributes);
        if (TableType.Static$.MODULE$.equals(tableType)) {
            fileStatus = this.lockStaticTable(path, yt);
        } else if (TableType.Dynamic$.MODULE$.equals(tableType)) {
            fileStatus = this.lockDynamicTable(path, yt);
        } else {
            throw new MatchError((Object)tableType);
        }
        return fileStatus;
    }

    private boolean isDriver$lzycompute() {
        YtTableFileSystem ytTableFileSystem = this;
        synchronized (ytTableFileSystem) {
            if (!this.bitmap$0) {
                this.isDriver = SparkSession$.MODULE$.getDefaultSession().nonEmpty();
                this.bitmap$0 = true;
            }
        }
        return this.isDriver;
    }

    private boolean isDriver() {
        return !this.bitmap$0 ? this.isDriver$lzycompute() : this.isDriver;
    }

    private FileStatus lockStaticTable(YPathEnriched path, CompoundClient yt) {
        return this.getFileStatus(path.dropTimestamp().lock(yt), yt);
    }

    private FileStatus lockDynamicTable(YPathEnriched path, CompoundClient yt) {
        FileStatus fileStatus;
        if (path.timestamp().isDefined() || path.transaction().isDefined()) {
            fileStatus = this.getFileStatus(path.lock(yt), yt);
        } else {
            if (!this.isDriver()) {
                this.log().warn("Generating timestamps of dynamic tables on executors causes reading files with different timestamps");
            }
            long ts = YtWrapper$.MODULE$.maxAvailableTimestamp(path.toYPath(), YtWrapper$.MODULE$.maxAvailableTimestamp$default$2(), yt);
            fileStatus = this.getFileStatus(path.withTimestamp(ts), yt);
        }
        return fileStatus;
    }

    public FileStatus getFileStatus(Path f) {
        Path x$1 = f;
        YPathEnriched x$2 = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        CompoundClient x$3 = this.getFileStatus$default$3(x$1, x$2);
        return this.getFileStatus(x$1, x$2, x$3);
    }

    private FileStatus getFileStatus(YPathEnriched path, CompoundClient yt) {
        return this.getFileStatus(path.toPath(), path, yt);
    }

    private FileStatus getFileStatus(Path f, YPathEnriched path, CompoundClient yt) {
        FileStatus fileStatus;
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Get file status ").append(f).toString());
        if (!YtWrapper$.MODULE$.exists(path.toYPath(), path.transaction(), yt)) {
            throw new FileNotFoundException(new StringBuilder(18).append("File ").append(f).append(" is not found").toString());
        }
        Map attributes = YtWrapper$.MODULE$.attributes(path.toYPath(), path.transaction(), YtWrapper$.MODULE$.attributes$default$3(), yt);
        long modificationTime = YtWrapper$.MODULE$.modificationTimeTs(attributes);
        PathType pathType = YtWrapper$.MODULE$.pathType(attributes);
        if (PathType.File$.MODULE$.equals(pathType)) {
            long size = YtWrapper$.MODULE$.fileSize(attributes);
            fileStatus = new FileStatus(size, false, 1, size, modificationTime, f);
        } else if (PathType.Table$.MODULE$.equals(pathType)) {
            Tuple2.mcJZ.sp sp2;
            long size = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(YtWrapper$.MODULE$.fileSize(attributes)), 1L);
            OptimizeMode optimizeMode = YtWrapper$.MODULE$.optimizeMode(attributes);
            TableType tableType = YtWrapper$.MODULE$.tableType(attributes);
            if (TableType.Static$.MODULE$.equals(tableType)) {
                sp2 = new Tuple2.mcJZ.sp(YtWrapper$.MODULE$.rowCount(attributes), false);
            } else if (TableType.Dynamic$.MODULE$.equals(tableType)) {
                sp2 = new Tuple2.mcJZ.sp(YtWrapper$.MODULE$.chunkRowCount(attributes), true);
            } else {
                throw new MatchError((Object)tableType);
            }
            Tuple2.mcJZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            long rowCount = sp3._1$mcJ$sp();
            boolean isDynamic = sp3._2$mcZ$sp();
            Tuple2.mcJZ.sp sp4 = new Tuple2.mcJZ.sp(rowCount, isDynamic);
            Tuple2.mcJZ.sp sp5 = sp4;
            long rowCount2 = sp5._1$mcJ$sp();
            boolean isDynamic2 = sp5._2$mcZ$sp();
            YtHadoopPath richPath = new YtHadoopPath(path, new YtTableMeta(rowCount2, size, modificationTime, optimizeMode, isDynamic2));
            fileStatus = YtFileStatus$.MODULE$.toFileStatus(richPath);
        } else if (PathType.Directory$.MODULE$.equals(pathType)) {
            fileStatus = new FileStatus(0L, true, 1, 0L, modificationTime, f);
        } else if (PathType.None$.MODULE$.equals(pathType)) {
            fileStatus = null;
        } else {
            throw new MatchError((Object)pathType);
        }
        return fileStatus;
    }

    private CompoundClient getFileStatus$default$3(Path f, YPathEnriched path) {
        return this.ytClient(path);
    }
}

