/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.serializers;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import tech.ytsaurus.spyt.serializers.AtomicYtLogicalType;
import tech.ytsaurus.spyt.serializers.CompositeYtLogicalType;
import tech.ytsaurus.spyt.serializers.YtLogicalType;
import tech.ytsaurus.spyt.serializers.YtLogicalType$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Array$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Decimal$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Dict$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Optional$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Struct$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Tagged$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Tuple$;
import tech.ytsaurus.spyt.serializers.YtLogicalType$Variant$;
import tech.ytsaurus.spyt.serializers.YtLogicalTypeAlias;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeStringNode;

public final class YtLogicalTypeSerializer$ {
    public static YtLogicalTypeSerializer$ MODULE$;

    static {
        new YtLogicalTypeSerializer$();
    }

    private YTreeNode serializeTupleField(YtLogicalType ytType, Metadata meta, boolean innerForm) {
        YTreeBuilder builder = YTree.builder().beginMap();
        builder.key("metadata").value(meta.json());
        return builder.key("type").value(this.serializeTypeV3(ytType, innerForm)).buildMap();
    }

    private YTreeNode serializeStructField(String name, YtLogicalType ytType, Metadata meta, boolean innerForm) {
        YTreeBuilder builder = YTree.builder().beginMap().key("name").value(name);
        builder.key("metadata").value(meta.json());
        return builder.key("type").value(this.serializeTypeV3(ytType, innerForm)).buildMap();
    }

    private void serializeElements(YTreeBuilder builder, Seq<Tuple2<YtLogicalType, Metadata>> elements, boolean innerForm) {
        builder.key("elements").beginList();
        elements.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            YtLogicalType e = (YtLogicalType)tuple2._1();
            Metadata meta = (Metadata)tuple2._2();
            builder.onListItem();
            YTreeBuilder yTreeBuilder = builder.value(MODULE$.serializeTupleField(e, meta, innerForm));
            return yTreeBuilder;
        });
        builder.endList();
    }

    private void serializeMembers(YTreeBuilder builder, Seq<Tuple3<String, YtLogicalType, Metadata>> members, boolean innerForm) {
        builder.key("members").beginList();
        members.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String name = (String)tuple3._1();
            YtLogicalType ytType = (YtLogicalType)tuple3._2();
            Metadata meta = (Metadata)tuple3._3();
            builder.onListItem();
            YTreeBuilder yTreeBuilder = builder.value(MODULE$.serializeStructField(name, ytType, meta, innerForm));
            return yTreeBuilder;
        });
        builder.endList();
    }

    public YTreeNode serializeTypeV3(YtLogicalType ytType, boolean innerForm) {
        YTreeNode yTreeNode;
        YtLogicalType ytLogicalType = ytType;
        if (ytLogicalType instanceof AtomicYtLogicalType) {
            AtomicYtLogicalType atomicYtLogicalType = (AtomicYtLogicalType)ytLogicalType;
            yTreeNode = YTree.builder().value(atomicYtLogicalType.getNameV3(innerForm)).build();
        } else if (ytLogicalType instanceof CompositeYtLogicalType) {
            YTreeBuilder yTreeBuilder;
            CompositeYtLogicalType compositeYtLogicalType = (CompositeYtLogicalType)ytLogicalType;
            YTreeBuilder builder = YTree.builder().beginMap().key("type_name").value(compositeYtLogicalType.getNameV3(innerForm));
            CompositeYtLogicalType compositeYtLogicalType2 = compositeYtLogicalType;
            if (compositeYtLogicalType2 instanceof YtLogicalType.Optional) {
                YtLogicalType.Optional optional = (YtLogicalType.Optional)compositeYtLogicalType2;
                yTreeBuilder = builder.key("item").value(this.serializeTypeV3(optional.inner(), innerForm));
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Decimal) {
                YtLogicalType.Decimal decimal = (YtLogicalType.Decimal)compositeYtLogicalType2;
                yTreeBuilder = builder.key("precision").value(decimal.precision()).key("scale").value(decimal.scale());
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Array) {
                YtLogicalType.Array array = (YtLogicalType.Array)compositeYtLogicalType2;
                yTreeBuilder = builder.key("item").value(this.serializeTypeV3(array.inner(), innerForm));
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Dict) {
                YtLogicalType.Dict dict = (YtLogicalType.Dict)compositeYtLogicalType2;
                yTreeBuilder = builder.key("key").value(this.serializeTypeV3(dict.dictKey(), innerForm)).key("value").value(this.serializeTypeV3(dict.dictValue(), innerForm));
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Struct) {
                YtLogicalType.Struct struct = (YtLogicalType.Struct)compositeYtLogicalType2;
                this.serializeMembers(builder, struct.fields(), innerForm);
                yTreeBuilder = BoxedUnit.UNIT;
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Tuple) {
                YtLogicalType.Tuple tuple = (YtLogicalType.Tuple)compositeYtLogicalType2;
                this.serializeElements(builder, tuple.elements(), innerForm);
                yTreeBuilder = BoxedUnit.UNIT;
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.Tagged) {
                YtLogicalType.Tagged tagged = (YtLogicalType.Tagged)compositeYtLogicalType2;
                yTreeBuilder = builder.key("item").value(this.serializeTypeV3(tagged.inner(), innerForm)).key("tag").value(tagged.tag());
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.VariantOverTuple) {
                YtLogicalType.VariantOverTuple variantOverTuple = (YtLogicalType.VariantOverTuple)compositeYtLogicalType2;
                this.serializeElements(builder, variantOverTuple.fields(), innerForm);
                yTreeBuilder = BoxedUnit.UNIT;
            } else if (compositeYtLogicalType2 instanceof YtLogicalType.VariantOverStruct) {
                YtLogicalType.VariantOverStruct variantOverStruct = (YtLogicalType.VariantOverStruct)compositeYtLogicalType2;
                this.serializeMembers(builder, variantOverStruct.fields(), innerForm);
                yTreeBuilder = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)compositeYtLogicalType2);
            }
            yTreeNode = builder.buildMap();
        } else {
            throw new MatchError((Object)ytLogicalType);
        }
        return yTreeNode;
    }

    public YTreeNode serializeType(YtLogicalType ytType, boolean isColumnType) {
        return YTree.builder().value(ytType.getName(isColumnType)).build();
    }

    public boolean serializeTypeV3$default$2() {
        return false;
    }

    public boolean serializeType$default$2() {
        return false;
    }

    private Seq<Tuple3<String, YtLogicalType, Metadata>> deserializeMembers(YTreeMapNode m2) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(m2.getOrThrow("members").asList()).asScala()).map((Function1 & Serializable & scala.Serializable)m -> {
            YTreeMapNode member = m.mapNode();
            return new Tuple3((Object)member.getOrThrow("name").stringValue(), (Object)MODULE$.deserializeTypeV3(member.getOrThrow("type")), (Object)member.getStringO("metadata").map(json -> Metadata$.MODULE$.fromJson(json)).orElse(Metadata$.MODULE$.empty()));
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<YtLogicalType, Metadata>> deserializeElements(YTreeMapNode m) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(m.getOrThrow("elements").asList()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
            YTreeMapNode element = e.mapNode();
            return new Tuple2((Object)MODULE$.deserializeTypeV3(element.mapNode().getOrThrow("type")), (Object)element.getStringO("metadata").map(json -> Metadata$.MODULE$.fromJson(json)).orElse(Metadata$.MODULE$.empty()));
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public YtLogicalType deserializeTypeV3(YTreeNode node) {
        YtLogicalType ytLogicalType;
        YTreeNode yTreeNode = node;
        if (yTreeNode instanceof YTreeMapNode) {
            Product product;
            YTreeMapNode yTreeMapNode = (YTreeMapNode)yTreeNode;
            YtLogicalTypeAlias alias = YtLogicalType$.MODULE$.fromCompositeName(yTreeMapNode.getOrThrow("type_name").stringValue());
            YtLogicalTypeAlias ytLogicalTypeAlias = alias;
            if (YtLogicalType$Optional$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Optional(this.deserializeTypeV3(yTreeMapNode.getOrThrow("item")));
            } else if (YtLogicalType$Decimal$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Decimal(yTreeMapNode.getOrThrow("precision").intValue(), yTreeMapNode.getOrThrow("scale").intValue());
            } else if (YtLogicalType$Dict$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Dict(this.deserializeTypeV3(yTreeMapNode.getOrThrow("key")), this.deserializeTypeV3(yTreeMapNode.getOrThrow("value")));
            } else if (YtLogicalType$Array$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Array(this.deserializeTypeV3(yTreeMapNode.getOrThrow("item")));
            } else if (YtLogicalType$Struct$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Struct(this.deserializeMembers(yTreeMapNode));
            } else if (YtLogicalType$Tuple$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Tuple(this.deserializeElements(yTreeMapNode));
            } else if (YtLogicalType$Tagged$.MODULE$.equals(ytLogicalTypeAlias)) {
                product = new YtLogicalType.Tagged(this.deserializeTypeV3(yTreeMapNode.getOrThrow("item")), yTreeMapNode.getOrThrow("tag").stringValue());
            } else if (YtLogicalType$Variant$.MODULE$.equals(ytLogicalTypeAlias)) {
                Product product2;
                if (yTreeMapNode.containsKey("members")) {
                    product2 = new YtLogicalType.VariantOverStruct(this.deserializeMembers(yTreeMapNode));
                } else if (yTreeMapNode.containsKey("elements")) {
                    product2 = new YtLogicalType.VariantOverTuple(this.deserializeElements(yTreeMapNode));
                } else {
                    throw new NoSuchElementException("Incorrect variant format");
                }
                product = product2;
            } else {
                throw new NoSuchElementException(new StringBuilder(25).append("Unknown YTLogicalType: '").append(ytLogicalTypeAlias).append("'").toString());
            }
            ytLogicalType = product;
        } else if (yTreeNode instanceof YTreeStringNode) {
            YTreeStringNode yTreeStringNode = (YTreeStringNode)yTreeNode;
            ytLogicalType = YtLogicalType$.MODULE$.fromName(yTreeStringNode.stringValue());
        } else {
            throw new MatchError((Object)yTreeNode);
        }
        return ytLogicalType;
    }

    private YtLogicalTypeSerializer$() {
        MODULE$ = this;
    }
}

