/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.streaming;

import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Error;
import io.circe.HCursor;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.KeyDecoder$;
import io.circe.KeyEncoder$;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.generic.encoding.DerivedAsObjectEncoder;
import io.circe.generic.encoding.DerivedAsObjectEncoder$;
import io.circe.generic.encoding.ReprAsObjectEncoder;
import io.circe.generic.semiauto$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import shapeless.;
import shapeless.DefaultSymbolicLabelling$;
import shapeless.Generic$;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.spyt.streaming.YtQueueOffset;
import tech.ytsaurus.spyt.streaming.YtQueueRange;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.dyntable.ConsumerUtils;
import tech.ytsaurus.spyt.wrapper.dyntable.ConsumerUtils$;
import tech.ytsaurus.ysontree.YTreeNode;

public final class YtQueueOffset$
implements scala.Serializable {
    public static YtQueueOffset$ MODULE$;
    private final Encoder<YtQueueOffset> offsetEncoder;
    private final Decoder<YtQueueOffset> offsetDecoder;

    static {
        new YtQueueOffset$();
    }

    private Encoder<YtQueueOffset> offsetEncoder() {
        return this.offsetEncoder;
    }

    private Decoder<YtQueueOffset> offsetDecoder() {
        return this.offsetDecoder;
    }

    public YtQueueOffset apply(Offset offset) {
        YtQueueOffset ytQueueOffset;
        Offset offset2 = offset;
        if (offset2 instanceof YtQueueOffset) {
            YtQueueOffset ytQueueOffset2;
            ytQueueOffset = ytQueueOffset2 = (YtQueueOffset)offset2;
        } else if (offset2 instanceof SerializedOffset) {
            YtQueueOffset value;
            SerializedOffset serializedOffset = (SerializedOffset)offset2;
            Either either = package$.MODULE$.decode(serializedOffset.json(), this.offsetDecoder());
            if (either instanceof Left) {
                Left left = (Left)either;
                Error error = (Error)left.value();
                throw error;
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            YtQueueOffset ytQueueOffset3 = value = (YtQueueOffset)((Object)right.value());
            ytQueueOffset = ytQueueOffset3;
        } else {
            throw new IllegalArgumentException("Unsupported offset format");
        }
        return ytQueueOffset;
    }

    public String tech$ytsaurus$spyt$streaming$YtQueueOffset$$toJsonString(YtQueueOffset offset) {
        return package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)offset), this.offsetEncoder()).noSpaces();
    }

    public <T> Option<T> getSafeMax(Iterable<T> values, Ordering<T> ordering) {
        return values.nonEmpty() ? new Some(values.max(ordering)) : None$.MODULE$;
    }

    public Try<YtQueueOffset> getMaxOffset(String cluster, String queuePath, CompoundClient client) {
        YTreeNode partitionsAttribute = YtWrapper$.MODULE$.attribute(queuePath, "queue_partitions", YtWrapper$.MODULE$.attribute$default$3(), client);
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Buffer partitionSeq = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionsAttribute.asList()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Map map;
                int index;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    YTreeNode node = (YTreeNode)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    map = node.asMap();
                    if (!map.containsKey("upper_row_index")) {
                        if (map.containsKey("error")) {
                            Object arg$macro$1 = map.get("error");
                            throw new IllegalStateException(new StringOps("Error while parsing partition info: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
                        }
                        throw new IllegalStateException("Unknown error while parsing partition info");
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(index, ((YTreeNode)map.get("upper_row_index")).longValue() - 1L);
                return sp2;
            }, Buffer$.MODULE$.canBuildFrom());
            return new YtQueueOffset(cluster, queuePath, (SortedMap<Object, Object>)SortedMap$.MODULE$.apply((Seq)partitionSeq, (Ordering)Ordering.Int$.MODULE$));
        });
    }

    public YtQueueOffset getCurrentOffset(String cluster, String consumerPath, String queuePath, CompoundClient client) {
        Seq rows = (Seq)YtWrapper$.MODULE$.selectRows(consumerPath, (Option)new Some((Object)new StringBuilder(15).append(ConsumerUtils.Columns$.MODULE$.QUEUE_CLUSTER()).append(" = \"").append(cluster).append("\" and ").append(ConsumerUtils.Columns$.MODULE$.QUEUE_PATH()).append(" = \"").append(queuePath).append("\"").toString()), YtWrapper$.MODULE$.selectRows$default$3(), YtWrapper$.MODULE$.selectRows$default$4(), client).map((Function1 & Serializable & scala.Serializable)node -> ConsumerUtils$.MODULE$.fromYTree(node), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map sparsePartitions = ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> new Tuple2.mcIJ.sp(row.partitionIndex(), row.offset()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.require(rows.length() == sparsePartitions.size(), (Function0 & Serializable & scala.Serializable)() -> "Corrupted partition list. Probably the consumer table has different queues with the same name");
        int partitionCount = 1 + BoxesRunTime.unboxToInt((Object)this.getSafeMax((Iterable)sparsePartitions.keys(), (Ordering)Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        IndexedSeq partitionSeq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable & scala.Serializable)index -> YtQueueOffset$.$anonfun$getCurrentOffset$5(sparsePartitions, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        return new YtQueueOffset(cluster, queuePath, (SortedMap<Object, Object>)SortedMap$.MODULE$.apply((Seq)partitionSeq, (Ordering)Ordering.Int$.MODULE$));
    }

    public Seq<YtQueueRange> getRanges(YtQueueOffset start, YtQueueOffset end) {
        return (Seq)end.partitions().toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long lowerIndex;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._1$mcI$sp();
            long rawUpperIndex = tuple2._2$mcJ$sp();
            long upperIndex = rawUpperIndex + 1L;
            Predef$.MODULE$.require(upperIndex >= (lowerIndex = BoxesRunTime.unboxToLong((Object)start.partitions().getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) + 1L), (Function0 & Serializable & scala.Serializable)() -> {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)index);
                Long arg$macro$2 = BoxesRunTime.boxToLong((long)lowerIndex);
                Long arg$macro$3 = BoxesRunTime.boxToLong((long)upperIndex);
                return new StringOps("Partition %s has corrupted read segment [%s;%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
            });
            YtQueueRange ytQueueRange = new YtQueueRange(index, lowerIndex, upperIndex);
            return ytQueueRange;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void advance(String consumerPath, YtQueueOffset newOffset, CompoundClient client) {
        ApiServiceTransaction transaction = YtWrapper$.MODULE$.createTransaction((Option)None$.MODULE$, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute(), true, YtWrapper$.MODULE$.createTransaction$default$4(), YtWrapper$.MODULE$.createTransaction$default$5(), client);
        try {
            newOffset.partitions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                YtQueueOffset$.$anonfun$advance$1(consumerPath, newOffset, transaction, x0$1);
                return BoxedUnit.UNIT;
            });
            transaction.commit().join();
        }
        catch (Throwable e) {
            transaction.abort().join();
            throw e;
        }
    }

    public YtQueueOffset apply(String cluster, String path, SortedMap<Object, Object> partitions) {
        return new YtQueueOffset(cluster, path, partitions);
    }

    public Option<Tuple3<String, String, SortedMap<Object, Object>>> unapply(YtQueueOffset x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.cluster(), (Object)x$0.path(), x$0.partitions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getCurrentOffset$5(scala.collection.immutable.Map sparsePartitions$1, int index) {
        return new Tuple2.mcIJ.sp(index, BoxesRunTime.unboxToLong((Object)sparsePartitions$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - 1L);
    }

    public static final /* synthetic */ void $anonfun$advance$1(String consumerPath$1, YtQueueOffset newOffset$1, ApiServiceTransaction transaction$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int index = tuple2._1$mcI$sp();
            long offset = tuple2._2$mcJ$sp();
            if (offset >= 0L) {
                YtWrapper$.MODULE$.advanceConsumer(YPath.simple((String)consumerPath$1), YPath.simple((String)newOffset$1.path()), index, offset + 1L, transaction$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private YtQueueOffset$() {
        MODULE$ = this;
        public final class Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$9$1
        implements scala.Serializable {
            private ReprAsObjectEncoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$8;
            private DerivedAsObjectEncoder<YtQueueOffset> inst$macro$1;
            private volatile byte bitmap$0;

            private ReprAsObjectEncoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$8$lzycompute() {
                Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$9$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$8 = new ReprAsObjectEncoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>>(null){
                            private final Encoder<String> circeGenericEncoderForpath;
                            private final Encoder.AsObject<SortedMap<Object, Object>> circeGenericEncoderForpartitions;

                            public final JsonObject encodeObject(.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>> a) {
                                SortedMap circeGenericHListBindingForpartitions;
                                String circeGenericHListBindingForpath;
                                String circeGenericHListBindingForcluster;
                                block3: {
                                    .colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>> colon2;
                                    block2: {
                                        colon2 = a;
                                        if (colon2 == null) break block2;
                                        circeGenericHListBindingForcluster = (String)colon2.head();
                                        .colon.colon colon3 = (.colon.colon)colon2.tail();
                                        if (colon3 == null) break block2;
                                        circeGenericHListBindingForpath = (String)colon3.head();
                                        .colon.colon colon4 = (.colon.colon)colon3.tail();
                                        if (colon4 == null) break block2;
                                        circeGenericHListBindingForpartitions = (SortedMap)colon4.head();
                                        HNil hNil = (HNil)colon4.tail();
                                        if (HNil$.MODULE$.equals(hNil)) break block3;
                                    }
                                    throw new MatchError(colon2);
                                }
                                JsonObject jsonObject = JsonObject$.MODULE$.fromIterable((Iterable)Vector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"cluster", (Object)this.circeGenericEncoderForpath.apply((Object)circeGenericHListBindingForcluster)), new Tuple2((Object)"path", (Object)this.circeGenericEncoderForpath.apply((Object)circeGenericHListBindingForpath)), new Tuple2((Object)"partitions", (Object)this.circeGenericEncoderForpartitions.apply((Object)circeGenericHListBindingForpartitions))})));
                                return jsonObject;
                            }
                            {
                                this.circeGenericEncoderForpath = Encoder$.MODULE$.encodeString();
                                this.circeGenericEncoderForpartitions = Encoder$.MODULE$.encodeMapLike(KeyEncoder$.MODULE$.encodeKeyInt(), Encoder$.MODULE$.encodeLong(), (Function1)Predef$.MODULE$.$conforms());
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$8;
            }

            public ReprAsObjectEncoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$8() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$8$lzycompute() : this.inst$macro$8;
            }

            private DerivedAsObjectEncoder<YtQueueOffset> inst$macro$1$lzycompute() {
                Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$9$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.inst$macro$1 = DerivedAsObjectEncoder$.MODULE$.deriveEncoder(LabelledGeneric$.MODULE$.materializeProduct(DefaultSymbolicLabelling$.MODULE$.instance((HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "cluster"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "path"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "partitions"), (HList)HNil$.MODULE$)))), Generic$.MODULE$.instance((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            YtQueueOffset ytQueueOffset = x0$3;
                            if (ytQueueOffset == null) {
                                throw new MatchError((Object)((Object)ytQueueOffset));
                            }
                            String pat$macro$5 = ytQueueOffset.cluster();
                            String pat$macro$6 = ytQueueOffset.path();
                            SortedMap<Object, Object> pat$macro$7 = ytQueueOffset.partitions();
                            .colon.colon colon2 = new .colon.colon((Object)pat$macro$5, (HList)new .colon.colon((Object)pat$macro$6, (HList)new .colon.colon(pat$macro$7, (HList)HNil$.MODULE$)));
                            return colon2;
                        }, (Function1 & Serializable & scala.Serializable)x0$4 -> {
                            SortedMap pat$macro$7;
                            String pat$macro$6;
                            String pat$macro$5;
                            block3: {
                                .colon.colon colon2;
                                block2: {
                                    colon2 = x0$4;
                                    if (colon2 == null) break block2;
                                    pat$macro$5 = (String)colon2.head();
                                    .colon.colon colon3 = (.colon.colon)colon2.tail();
                                    if (colon3 == null) break block2;
                                    pat$macro$6 = (String)colon3.head();
                                    .colon.colon colon4 = (.colon.colon)colon3.tail();
                                    if (colon4 == null) break block2;
                                    pat$macro$7 = (SortedMap)colon4.head();
                                    HNil hNil = (HNil)colon4.tail();
                                    if (HNil$.MODULE$.equals(hNil)) break block3;
                                }
                                throw new MatchError((Object)colon2);
                            }
                            YtQueueOffset ytQueueOffset = new YtQueueOffset(pat$macro$5, pat$macro$6, (SortedMap<Object, Object>)pat$macro$7);
                            return ytQueueOffset;
                        }), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "partitions"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "path"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "cluster"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$8()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$1;
            }

            public DerivedAsObjectEncoder<YtQueueOffset> inst$macro$1() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$1$lzycompute() : this.inst$macro$1;
            }

            public Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$9$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(tech.ytsaurus.spyt.streaming.YtQueueOffset ), $anonfun$inst$macro$1$2(shapeless.$colon$colon ), $anonfun$inst$macro$1$3(tech.ytsaurus.spyt.streaming.YtQueueOffset$anon$lazy$macro$9$1 )}, serializedLambda);
            }
        }
        DerivedAsObjectEncoder<YtQueueOffset> inst$macro$10 = new Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$9$1().inst$macro$1();
        this.offsetEncoder = semiauto$.MODULE$.deriveEncoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$10));
        public final class Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$19$1
        implements scala.Serializable {
            private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$18;
            private DerivedDecoder<YtQueueOffset> inst$macro$11;
            private volatile byte bitmap$0;

            private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$18$lzycompute() {
                Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$19$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$18 = new ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>>(null){
                            private final Decoder<String> circeGenericDecoderForpath;
                            private final Decoder<SortedMap<Object, Object>> circeGenericDecoderForpartitions;

                            public final Either<DecodingFailure, .colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> apply(HCursor c) {
                                return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpath.tryDecode(c.downField("cluster")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpath.tryDecode(c.downField("path")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpartitions.tryDecode(c.downField("partitions")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> decodeAccumulating(HCursor c) {
                                return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpath.tryDecodeAccumulating(c.downField("cluster")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpath.tryDecodeAccumulating(c.downField("path")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForpartitions.tryDecodeAccumulating(c.downField("partitions")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderForpath = Decoder$.MODULE$.decodeString();
                                this.circeGenericDecoderForpartitions = Decoder$.MODULE$.decodeMapLike(KeyDecoder$.MODULE$.decodeKeyInt(), Decoder$.MODULE$.decodeLong(), SortedMap$.MODULE$.canBuildFrom((Ordering)Ordering.Int$.MODULE$));
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$18;
            }

            public ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<SortedMap<Object, Object>, HNil>>>> inst$macro$18() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$18$lzycompute() : this.inst$macro$18;
            }

            private DerivedDecoder<YtQueueOffset> inst$macro$11$lzycompute() {
                Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$19$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.inst$macro$11 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct(DefaultSymbolicLabelling$.MODULE$.instance((HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "cluster"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "path"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "partitions"), (HList)HNil$.MODULE$)))), Generic$.MODULE$.instance((Function1 & Serializable & scala.Serializable)x0$7 -> {
                            YtQueueOffset ytQueueOffset = x0$7;
                            if (ytQueueOffset == null) {
                                throw new MatchError((Object)((Object)ytQueueOffset));
                            }
                            String pat$macro$15 = ytQueueOffset.cluster();
                            String pat$macro$16 = ytQueueOffset.path();
                            SortedMap<Object, Object> pat$macro$17 = ytQueueOffset.partitions();
                            .colon.colon colon2 = new .colon.colon((Object)pat$macro$15, (HList)new .colon.colon((Object)pat$macro$16, (HList)new .colon.colon(pat$macro$17, (HList)HNil$.MODULE$)));
                            return colon2;
                        }, (Function1 & Serializable & scala.Serializable)x0$8 -> {
                            SortedMap pat$macro$17;
                            String pat$macro$16;
                            String pat$macro$15;
                            block3: {
                                .colon.colon colon2;
                                block2: {
                                    colon2 = x0$8;
                                    if (colon2 == null) break block2;
                                    pat$macro$15 = (String)colon2.head();
                                    .colon.colon colon3 = (.colon.colon)colon2.tail();
                                    if (colon3 == null) break block2;
                                    pat$macro$16 = (String)colon3.head();
                                    .colon.colon colon4 = (.colon.colon)colon3.tail();
                                    if (colon4 == null) break block2;
                                    pat$macro$17 = (SortedMap)colon4.head();
                                    HNil hNil = (HNil)colon4.tail();
                                    if (HNil$.MODULE$.equals(hNil)) break block3;
                                }
                                throw new MatchError((Object)colon2);
                            }
                            YtQueueOffset ytQueueOffset = new YtQueueOffset(pat$macro$15, pat$macro$16, (SortedMap<Object, Object>)pat$macro$17);
                            return ytQueueOffset;
                        }), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "partitions"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "path"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "cluster"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$18()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$11;
            }

            public DerivedDecoder<YtQueueOffset> inst$macro$11() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$11$lzycompute() : this.inst$macro$11;
            }

            public Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$19$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$11$1(tech.ytsaurus.spyt.streaming.YtQueueOffset ), $anonfun$inst$macro$11$2(shapeless.$colon$colon ), $anonfun$inst$macro$11$3(tech.ytsaurus.spyt.streaming.YtQueueOffset$anon$lazy$macro$19$1 )}, serializedLambda);
            }
        }
        DerivedDecoder<YtQueueOffset> inst$macro$20 = new Tech_ytsaurus_spyt_streaming_YtQueueOffset$anon$lazy$macro$19$1().inst$macro$11();
        this.offsetDecoder = semiauto$.MODULE$.deriveDecoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$20));
    }
}

