/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.ApiServiceTransactionOptions;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.request.AbortJob;
import tech.ytsaurus.client.request.AbortOperation;
import tech.ytsaurus.client.request.AbortQuery;
import tech.ytsaurus.client.request.AbortTransaction;
import tech.ytsaurus.client.request.AbstractLookupRowsRequest;
import tech.ytsaurus.client.request.AbstractModifyRowsRequest;
import tech.ytsaurus.client.request.AlterQuery;
import tech.ytsaurus.client.request.AlterTable;
import tech.ytsaurus.client.request.AlterTableReplica;
import tech.ytsaurus.client.request.BuildSnapshot;
import tech.ytsaurus.client.request.CheckClusterLiveness;
import tech.ytsaurus.client.request.CommitTransaction;
import tech.ytsaurus.client.request.CompleteOperation;
import tech.ytsaurus.client.request.CreateObject;
import tech.ytsaurus.client.request.CreateShuffleReader;
import tech.ytsaurus.client.request.CreateShuffleWriter;
import tech.ytsaurus.client.request.FreezeTable;
import tech.ytsaurus.client.request.GcCollect;
import tech.ytsaurus.client.request.GenerateTimestamps;
import tech.ytsaurus.client.request.GetInSyncReplicas;
import tech.ytsaurus.client.request.GetJob;
import tech.ytsaurus.client.request.GetJobStderr;
import tech.ytsaurus.client.request.GetJobStderrResult;
import tech.ytsaurus.client.request.GetOperation;
import tech.ytsaurus.client.request.GetQuery;
import tech.ytsaurus.client.request.GetQueryResult;
import tech.ytsaurus.client.request.GetTablePivotKeys;
import tech.ytsaurus.client.request.GetTabletInfos;
import tech.ytsaurus.client.request.ListJobs;
import tech.ytsaurus.client.request.ListJobsResult;
import tech.ytsaurus.client.request.ListQueries;
import tech.ytsaurus.client.request.ListQueriesResult;
import tech.ytsaurus.client.request.ListQueueConsumerRegistrations;
import tech.ytsaurus.client.request.ListQueueConsumerRegistrationsResult;
import tech.ytsaurus.client.request.LookupRowsRequest;
import tech.ytsaurus.client.request.MountTable;
import tech.ytsaurus.client.request.PingTransaction;
import tech.ytsaurus.client.request.PullConsumer;
import tech.ytsaurus.client.request.Query;
import tech.ytsaurus.client.request.QueryResult;
import tech.ytsaurus.client.request.ReadQueryResult;
import tech.ytsaurus.client.request.RegisterQueueConsumer;
import tech.ytsaurus.client.request.RemountTable;
import tech.ytsaurus.client.request.ReshardTable;
import tech.ytsaurus.client.request.ResumeOperation;
import tech.ytsaurus.client.request.ShuffleHandle;
import tech.ytsaurus.client.request.StartQuery;
import tech.ytsaurus.client.request.StartShuffle;
import tech.ytsaurus.client.request.StartTransaction;
import tech.ytsaurus.client.request.SuspendOperation;
import tech.ytsaurus.client.request.TabletInfo;
import tech.ytsaurus.client.request.TrimTable;
import tech.ytsaurus.client.request.UnfreezeTable;
import tech.ytsaurus.client.request.UnmountTable;
import tech.ytsaurus.client.request.UpdateOperationParameters;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.QueueRowset;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rows.VersionedRowset;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.EAtomicity;
import tech.ytsaurus.rpcproxy.ETableReplicaMode;
import tech.ytsaurus.ysontree.YTreeNode;

public interface ApiServiceClient
extends TransactionalClient {
    public CompletableFuture<ApiServiceTransaction> startTransaction(StartTransaction var1);

    @Deprecated
    default public CompletableFuture<ApiServiceTransaction> startTransaction(StartTransaction.BuilderBase<?> startTransaction) {
        return this.startTransaction(startTransaction.build());
    }

    @Deprecated
    default public CompletableFuture<ApiServiceTransaction> startTransaction(ApiServiceTransactionOptions options) {
        return this.startTransaction(options.toStartTransaction());
    }

    public CompletableFuture<Void> pingTransaction(PingTransaction var1);

    default public CompletableFuture<Void> pingTransaction(GUID id) {
        return this.pingTransaction(new PingTransaction(id));
    }

    public CompletableFuture<Void> commitTransaction(CommitTransaction var1);

    default public CompletableFuture<Void> commitTransaction(GUID id) {
        return this.commitTransaction(new CommitTransaction(id));
    }

    public CompletableFuture<Void> abortTransaction(AbortTransaction var1);

    default public CompletableFuture<Void> abortTransaction(GUID id) {
        return this.abortTransaction(new AbortTransaction(id));
    }

    public CompletableFuture<List<YTreeNode>> getTablePivotKeys(GetTablePivotKeys var1);

    public CompletableFuture<GUID> createObject(CreateObject var1);

    public CompletableFuture<Void> checkClusterLiveness(CheckClusterLiveness var1);

    public <T> CompletableFuture<Void> lookupRows(AbstractLookupRowsRequest<?, ?> var1, YTreeRowSerializer<T> var2, ConsumerSource<T> var3);

    default public <T> CompletableFuture<Void> lookupRows(AbstractLookupRowsRequest.Builder<?, ?> request, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.lookupRows((AbstractLookupRowsRequest)request.build(), serializer, consumer);
    }

    @Deprecated
    default public CompletableFuture<UnversionedRowset> lookupRows(LookupRowsRequest.BuilderBase<?> request, YtTimestamp timestamp) {
        return this.lookupRows((AbstractLookupRowsRequest.Builder<?, ?>)request.setTimestamp(timestamp));
    }

    @Deprecated
    default public CompletableFuture<VersionedRowset> versionedLookupRows(LookupRowsRequest.BuilderBase<?> request, YtTimestamp timestamp) {
        return this.versionedLookupRows((AbstractLookupRowsRequest.Builder<?, ?>)request.setTimestamp(timestamp));
    }

    public CompletableFuture<Void> modifyRows(GUID var1, AbstractModifyRowsRequest<?, ?> var2);

    default public CompletableFuture<Void> modifyRows(GUID transactionId, AbstractModifyRowsRequest.Builder<?, ?> request) {
        return this.modifyRows(transactionId, (AbstractModifyRowsRequest)request.build());
    }

    public CompletableFuture<Long> buildSnapshot(BuildSnapshot var1);

    public CompletableFuture<Void> gcCollect(GcCollect var1);

    default public CompletableFuture<Void> gcCollect(GUID cellId) {
        return this.gcCollect(new GcCollect(cellId));
    }

    public CompletableFuture<Void> mountTable(MountTable var1);

    @Deprecated
    default public CompletableFuture<Void> mountTable(MountTable.BuilderBase<?> req) {
        return this.mountTable(req.build());
    }

    public CompletableFuture<Void> unmountTable(UnmountTable var1);

    @Deprecated
    default public CompletableFuture<Void> unmountTable(UnmountTable.BuilderBase<?> req) {
        return this.unmountTable(req.build());
    }

    default public CompletableFuture<Void> remountTable(String path) {
        return this.remountTable(((RemountTable.Builder)RemountTable.builder().setPath(path)).build());
    }

    public CompletableFuture<Void> remountTable(RemountTable var1);

    @Deprecated
    default public CompletableFuture<Void> remountTable(RemountTable.BuilderBase<?> req) {
        return this.remountTable(req.build());
    }

    default public CompletableFuture<Void> freezeTable(String path) {
        return this.freezeTable(path, null);
    }

    default public CompletableFuture<Void> freezeTable(String path, @Nullable Duration requestTimeout) {
        return this.freezeTable(((FreezeTable.Builder)((FreezeTable.Builder)FreezeTable.builder().setPath(path)).setTimeout(requestTimeout)).build());
    }

    public CompletableFuture<Void> freezeTable(FreezeTable var1);

    @Deprecated
    default public CompletableFuture<Void> freezeTable(FreezeTable.BuilderBase<?> req) {
        return this.freezeTable(req.build());
    }

    default public CompletableFuture<Void> unfreezeTable(String path) {
        return this.unfreezeTable(path, null);
    }

    default public CompletableFuture<Void> unfreezeTable(String path, @Nullable Duration requestTimeout) {
        return this.unfreezeTable(((UnfreezeTable.Builder)((UnfreezeTable.Builder)UnfreezeTable.builder().setPath(path)).setTimeout(requestTimeout)).build());
    }

    default public CompletableFuture<Void> unfreezeTable(FreezeTable req) {
        UnfreezeTable.Builder unfreezeReqBuilder = (UnfreezeTable.Builder)UnfreezeTable.builder().setPath(req.getPath());
        if (req.getTimeout().isPresent()) {
            unfreezeReqBuilder.setTimeout(req.getTimeout().get());
        }
        return this.unfreezeTable(unfreezeReqBuilder.build());
    }

    @Deprecated
    default public CompletableFuture<Void> unfreezeTable(FreezeTable.BuilderBase<?> req) {
        return this.unfreezeTable(req.build());
    }

    public CompletableFuture<Void> unfreezeTable(UnfreezeTable var1);

    @Deprecated
    default public CompletableFuture<Void> unfreezeTable(UnfreezeTable.BuilderBase<?> req) {
        return this.unfreezeTable(req.build());
    }

    public CompletableFuture<List<GUID>> getInSyncReplicas(GetInSyncReplicas var1, YtTimestamp var2);

    default public CompletableFuture<List<GUID>> getInSyncReplicas(String path, YtTimestamp timestamp, TableSchema schema, Iterable<? extends List<?>> keys) {
        return this.getInSyncReplicas(new GetInSyncReplicas(path, schema, keys), timestamp);
    }

    public CompletableFuture<List<TabletInfo>> getTabletInfos(GetTabletInfos var1);

    default public CompletableFuture<List<TabletInfo>> getTabletInfos(String path, List<Integer> tabletIndices) {
        return this.getTabletInfos(GetTabletInfos.builder().setPath(path).setTabletIndexes(tabletIndices).build());
    }

    public CompletableFuture<YtTimestamp> generateTimestamps(GenerateTimestamps var1);

    default public CompletableFuture<YtTimestamp> generateTimestamps(int count) {
        GenerateTimestamps req = new GenerateTimestamps(count);
        return this.generateTimestamps(req);
    }

    default public CompletableFuture<YtTimestamp> generateTimestamps() {
        return this.generateTimestamps(1);
    }

    public CompletableFuture<Void> reshardTable(ReshardTable var1);

    @Deprecated
    default public CompletableFuture<Void> reshardTable(ReshardTable.BuilderBase<?> req) {
        return this.reshardTable(req.build());
    }

    default public CompletableFuture<Void> trimTable(String path, int tableIndex, long trimmedRowCount) {
        TrimTable req = new TrimTable(path, tableIndex, trimmedRowCount);
        return this.trimTable(req);
    }

    public CompletableFuture<Void> trimTable(TrimTable var1);

    public CompletableFuture<Void> alterTable(AlterTable var1);

    @Deprecated
    default public CompletableFuture<Void> alterTable(AlterTable.BuilderBase<?> req) {
        return this.alterTable(req.build());
    }

    public CompletableFuture<Void> alterTableReplica(GUID var1, boolean var2, ETableReplicaMode var3, boolean var4, EAtomicity var5);

    public CompletableFuture<Void> alterTableReplica(AlterTableReplica var1);

    public CompletableFuture<QueueRowset> pullConsumer(PullConsumer var1);

    public CompletableFuture<Void> registerQueueConsumer(RegisterQueueConsumer var1);

    public CompletableFuture<ListQueueConsumerRegistrationsResult> listQueueConsumerRegistrations(ListQueueConsumerRegistrations var1);

    public CompletableFuture<GUID> startQuery(StartQuery var1);

    public CompletableFuture<Void> abortQuery(AbortQuery var1);

    public CompletableFuture<QueryResult> getQueryResult(GetQueryResult var1);

    public CompletableFuture<UnversionedRowset> readQueryResult(ReadQueryResult var1);

    public CompletableFuture<Query> getQuery(GetQuery var1);

    public CompletableFuture<ListQueriesResult> listQueries(ListQueries var1);

    public CompletableFuture<Void> alterQuery(AlterQuery var1);

    public CompletableFuture<YTreeNode> getOperation(GetOperation var1);

    @Deprecated
    default public CompletableFuture<YTreeNode> getOperation(GetOperation.BuilderBase<?> req) {
        return this.getOperation(req.build());
    }

    public CompletableFuture<Void> abortOperation(AbortOperation var1);

    public CompletableFuture<Void> completeOperation(CompleteOperation var1);

    public CompletableFuture<Void> suspendOperation(SuspendOperation var1);

    public CompletableFuture<Void> resumeOperation(ResumeOperation var1);

    public CompletableFuture<ShuffleHandle> startShuffle(StartShuffle var1);

    public CompletableFuture<AsyncWriter<UnversionedRow>> createShuffleWriter(CreateShuffleWriter var1);

    public CompletableFuture<AsyncReader<UnversionedRow>> createShuffleReader(CreateShuffleReader var1);

    @Deprecated
    default public CompletableFuture<Void> resumeOperation(ResumeOperation.BuilderBase<?> req) {
        return this.resumeOperation(req.build());
    }

    public CompletableFuture<YTreeNode> getJob(GetJob var1);

    @Deprecated
    default public CompletableFuture<YTreeNode> getJob(GetJob.BuilderBase<?> req) {
        return this.getJob(req.build());
    }

    public CompletableFuture<Void> abortJob(AbortJob var1);

    public CompletableFuture<ListJobsResult> listJobs(ListJobs var1);

    public CompletableFuture<GetJobStderrResult> getJobStderr(GetJobStderr var1);

    public CompletableFuture<Void> updateOperationParameters(UpdateOperationParameters var1);

    @Deprecated
    default public CompletableFuture<Void> updateOperationParameters(UpdateOperationParameters.BuilderBase<?> req) {
        return this.updateOperationParameters(req.build());
    }
}

