/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceMethodTable;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.AsyncTableReaderImpl;
import tech.ytsaurus.client.AsyncTableWriterImpl;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.FileReader;
import tech.ytsaurus.client.FileReaderImpl;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.FileWriterImpl;
import tech.ytsaurus.client.GetInSyncReplicasWrapper;
import tech.ytsaurus.client.ModifyRowsWrapper;
import tech.ytsaurus.client.OutageController;
import tech.ytsaurus.client.OutageRpcClient;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.SelectRowsResult;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.ShuffleDataReaderImpl;
import tech.ytsaurus.client.ShuffleDataWriterImpl;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.client.TableAttachmentWireProtocolReader;
import tech.ytsaurus.client.TableReader;
import tech.ytsaurus.client.TableReaderImpl;
import tech.ytsaurus.client.TableWriter;
import tech.ytsaurus.client.TableWriterImpl;
import tech.ytsaurus.client.TransactionRetrier;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.YTsaurusClientConfig;
import tech.ytsaurus.client.operations.Operation;
import tech.ytsaurus.client.operations.OperationImpl;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.request.AbortJob;
import tech.ytsaurus.client.request.AbortOperation;
import tech.ytsaurus.client.request.AbortQuery;
import tech.ytsaurus.client.request.AbortTransaction;
import tech.ytsaurus.client.request.AbstractLookupRowsRequest;
import tech.ytsaurus.client.request.AbstractModifyRowsRequest;
import tech.ytsaurus.client.request.AdvanceConsumer;
import tech.ytsaurus.client.request.AlterQuery;
import tech.ytsaurus.client.request.AlterTable;
import tech.ytsaurus.client.request.AlterTableReplica;
import tech.ytsaurus.client.request.Atomicity;
import tech.ytsaurus.client.request.BaseOperation;
import tech.ytsaurus.client.request.BuildSnapshot;
import tech.ytsaurus.client.request.CheckClusterLiveness;
import tech.ytsaurus.client.request.CheckPermission;
import tech.ytsaurus.client.request.CommitTransaction;
import tech.ytsaurus.client.request.CompleteOperation;
import tech.ytsaurus.client.request.ConcatenateNodes;
import tech.ytsaurus.client.request.CopyNode;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.CreateObject;
import tech.ytsaurus.client.request.CreateShuffleReader;
import tech.ytsaurus.client.request.CreateShuffleWriter;
import tech.ytsaurus.client.request.ExistsNode;
import tech.ytsaurus.client.request.FreezeTable;
import tech.ytsaurus.client.request.GcCollect;
import tech.ytsaurus.client.request.GenerateTimestamps;
import tech.ytsaurus.client.request.GetFileFromCache;
import tech.ytsaurus.client.request.GetFileFromCacheResult;
import tech.ytsaurus.client.request.GetInSyncReplicas;
import tech.ytsaurus.client.request.GetJob;
import tech.ytsaurus.client.request.GetJobStderr;
import tech.ytsaurus.client.request.GetJobStderrResult;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.GetOperation;
import tech.ytsaurus.client.request.GetQuery;
import tech.ytsaurus.client.request.GetQueryResult;
import tech.ytsaurus.client.request.GetTablePivotKeys;
import tech.ytsaurus.client.request.GetTabletInfos;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.LinkNode;
import tech.ytsaurus.client.request.ListJobs;
import tech.ytsaurus.client.request.ListJobsResult;
import tech.ytsaurus.client.request.ListNode;
import tech.ytsaurus.client.request.ListQueries;
import tech.ytsaurus.client.request.ListQueriesResult;
import tech.ytsaurus.client.request.ListQueueConsumerRegistrations;
import tech.ytsaurus.client.request.ListQueueConsumerRegistrationsResult;
import tech.ytsaurus.client.request.LockNode;
import tech.ytsaurus.client.request.LockNodeResult;
import tech.ytsaurus.client.request.MapOperation;
import tech.ytsaurus.client.request.MapReduceOperation;
import tech.ytsaurus.client.request.MergeOperation;
import tech.ytsaurus.client.request.MountTable;
import tech.ytsaurus.client.request.MoveNode;
import tech.ytsaurus.client.request.MultiLookupRowsRequest;
import tech.ytsaurus.client.request.MultiLookupRowsSubrequest;
import tech.ytsaurus.client.request.MultiTablePartition;
import tech.ytsaurus.client.request.MutateNode;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PartitionTables;
import tech.ytsaurus.client.request.PingTransaction;
import tech.ytsaurus.client.request.PullConsumer;
import tech.ytsaurus.client.request.PutFileToCache;
import tech.ytsaurus.client.request.PutFileToCacheResult;
import tech.ytsaurus.client.request.Query;
import tech.ytsaurus.client.request.QueryResult;
import tech.ytsaurus.client.request.ReadFile;
import tech.ytsaurus.client.request.ReadQueryResult;
import tech.ytsaurus.client.request.ReadTable;
import tech.ytsaurus.client.request.ReduceOperation;
import tech.ytsaurus.client.request.RegisterQueueConsumer;
import tech.ytsaurus.client.request.RemoteCopyOperation;
import tech.ytsaurus.client.request.RemountTable;
import tech.ytsaurus.client.request.RemoveNode;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.RequestMiddleware;
import tech.ytsaurus.client.request.ReshardTable;
import tech.ytsaurus.client.request.ResumeOperation;
import tech.ytsaurus.client.request.SelectRowsRequest;
import tech.ytsaurus.client.request.SetNode;
import tech.ytsaurus.client.request.ShuffleHandle;
import tech.ytsaurus.client.request.SortOperation;
import tech.ytsaurus.client.request.StartOperation;
import tech.ytsaurus.client.request.StartQuery;
import tech.ytsaurus.client.request.StartShuffle;
import tech.ytsaurus.client.request.StartTransaction;
import tech.ytsaurus.client.request.SuspendOperation;
import tech.ytsaurus.client.request.TableReplicaMode;
import tech.ytsaurus.client.request.TableReq;
import tech.ytsaurus.client.request.TabletInfo;
import tech.ytsaurus.client.request.TabletInfoReplica;
import tech.ytsaurus.client.request.TransactionType;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.request.TrimTable;
import tech.ytsaurus.client.request.UnfreezeTable;
import tech.ytsaurus.client.request.UnmountTable;
import tech.ytsaurus.client.request.UpdateOperationParameters;
import tech.ytsaurus.client.request.VanillaOperation;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.ConsumerSourceRet;
import tech.ytsaurus.client.rows.EntitySkiffSerializer;
import tech.ytsaurus.client.rows.QueueRowset;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rows.VersionedRowset;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequestsTestingController;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.core.cypress.RichYPathParser;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.request.LockMode;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.EAtomicity;
import tech.ytsaurus.rpcproxy.EOperationType;
import tech.ytsaurus.rpcproxy.ETableReplicaMode;
import tech.ytsaurus.rpcproxy.TCheckPermissionResult;
import tech.ytsaurus.rpcproxy.TReqReadFile;
import tech.ytsaurus.rpcproxy.TReqReadShuffleData;
import tech.ytsaurus.rpcproxy.TReqReadTable;
import tech.ytsaurus.rpcproxy.TReqStartTransaction;
import tech.ytsaurus.rpcproxy.TReqWriteFile;
import tech.ytsaurus.rpcproxy.TReqWriteShuffleData;
import tech.ytsaurus.rpcproxy.TReqWriteTable;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;
import tech.ytsaurus.rpcproxy.TRspBuildSnapshot;
import tech.ytsaurus.rpcproxy.TRspCheckPermission;
import tech.ytsaurus.rpcproxy.TRspCopyNode;
import tech.ytsaurus.rpcproxy.TRspCreateNode;
import tech.ytsaurus.rpcproxy.TRspCreateObject;
import tech.ytsaurus.rpcproxy.TRspExistsNode;
import tech.ytsaurus.rpcproxy.TRspGenerateTimestamps;
import tech.ytsaurus.rpcproxy.TRspGetFileFromCache;
import tech.ytsaurus.rpcproxy.TRspGetInSyncReplicas;
import tech.ytsaurus.rpcproxy.TRspGetJob;
import tech.ytsaurus.rpcproxy.TRspGetNode;
import tech.ytsaurus.rpcproxy.TRspGetOperation;
import tech.ytsaurus.rpcproxy.TRspGetQuery;
import tech.ytsaurus.rpcproxy.TRspGetQueryResult;
import tech.ytsaurus.rpcproxy.TRspGetTablePivotKeys;
import tech.ytsaurus.rpcproxy.TRspGetTabletInfos;
import tech.ytsaurus.rpcproxy.TRspLinkNode;
import tech.ytsaurus.rpcproxy.TRspListJobs;
import tech.ytsaurus.rpcproxy.TRspListNode;
import tech.ytsaurus.rpcproxy.TRspListQueries;
import tech.ytsaurus.rpcproxy.TRspListQueueConsumerRegistrations;
import tech.ytsaurus.rpcproxy.TRspLockNode;
import tech.ytsaurus.rpcproxy.TRspLookupRows;
import tech.ytsaurus.rpcproxy.TRspMoveNode;
import tech.ytsaurus.rpcproxy.TRspMultiLookup;
import tech.ytsaurus.rpcproxy.TRspPartitionTables;
import tech.ytsaurus.rpcproxy.TRspPullQueueConsumer;
import tech.ytsaurus.rpcproxy.TRspPutFileToCache;
import tech.ytsaurus.rpcproxy.TRspReadFile;
import tech.ytsaurus.rpcproxy.TRspReadQueryResult;
import tech.ytsaurus.rpcproxy.TRspReadShuffleData;
import tech.ytsaurus.rpcproxy.TRspReadTable;
import tech.ytsaurus.rpcproxy.TRspSelectRows;
import tech.ytsaurus.rpcproxy.TRspStartOperation;
import tech.ytsaurus.rpcproxy.TRspStartQuery;
import tech.ytsaurus.rpcproxy.TRspStartShuffle;
import tech.ytsaurus.rpcproxy.TRspStartTransaction;
import tech.ytsaurus.rpcproxy.TRspVersionedLookupRows;
import tech.ytsaurus.rpcproxy.TRspWriteFile;
import tech.ytsaurus.rpcproxy.TRspWriteShuffleData;
import tech.ytsaurus.rpcproxy.TRspWriteTable;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

@NonNullFields
public class ApiServiceClientImpl
implements ApiServiceClient,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ApiServiceClientImpl.class);
    private static final List<String> JOB_TYPES = Arrays.asList("mapper", "reducer", "reduce_combiner");
    private final ScheduledExecutorService executorService;
    private final Executor heavyExecutor;
    private final ExecutorService prepareSpecExecutor = Executors.newSingleThreadExecutor();
    @Nullable
    private final RpcClient rpcClient;
    private final YTsaurusClientConfig config;
    protected final RpcOptions rpcOptions;
    protected final SerializationResolver serializationResolver;

    public ApiServiceClientImpl(@Nullable RpcClient client, @Nonnull YTsaurusClientConfig config, @Nonnull Executor heavyExecutor, @Nonnull ScheduledExecutorService executorService, SerializationResolver serializationResolver) {
        OutageController outageController = config.getRpcOptions().getTestingOptions().getOutageController();
        this.rpcClient = client != null && outageController != null ? new OutageRpcClient(client, outageController) : client;
        this.heavyExecutor = Objects.requireNonNull(heavyExecutor);
        this.config = config;
        this.rpcOptions = config.getRpcOptions();
        this.executorService = executorService;
        this.serializationResolver = serializationResolver;
    }

    public ApiServiceClientImpl(@Nullable RpcClient client, @Nonnull RpcOptions options, @Nonnull Executor heavyExecutor, @Nonnull ScheduledExecutorService executorService, SerializationResolver serializationResolver) {
        this(client, YTsaurusClientConfig.builder().withPorto().setRpcOptions(options).build(), heavyExecutor, executorService, serializationResolver);
    }

    @Override
    public void close() {
        this.prepareSpecExecutor.shutdown();
    }

    @Override
    public TransactionalClient getRootClient() {
        return this;
    }

    public YTsaurusClientConfig getConfig() {
        return this.config;
    }

    ExecutorService getPrepareSpecExecutor() {
        return this.prepareSpecExecutor;
    }

    @Override
    public CompletableFuture<ApiServiceTransaction> startTransaction(StartTransaction startTransaction) {
        RpcClientRequestBuilder<TReqStartTransaction.Builder, TRspStartTransaction> builder = ApiServiceMethodTable.START_TRANSACTION.createRequestBuilder(this.rpcOptions);
        return this.onStarted(startTransaction, RpcUtil.apply(this.sendRequest(startTransaction, builder), response -> {
            ApiServiceTransaction result;
            GUID id = RpcUtil.fromProto((TGuidOrBuilder)((TRspStartTransaction)response.body()).getId());
            YtTimestamp startTimestamp = YtTimestamp.valueOf((long)((TRspStartTransaction)response.body()).getStartTimestamp());
            RpcClient sender = response.sender();
            if (startTransaction.getSticky() && (this.rpcClient == null || !this.rpcClient.equals(sender))) {
                logger.trace("Create sticky transaction with new client to proxy {}", (Object)sender.getAddressString());
                result = new ApiServiceTransaction(new ApiServiceClientImpl(Objects.requireNonNull(sender), this.config, this.heavyExecutor, this.executorService, this.serializationResolver), id, startTimestamp, startTransaction.getPing(), startTransaction.getPingAncestors(), startTransaction.getSticky(), startTransaction.getPingPeriod().orElse(null), startTransaction.getFailedPingRetryPeriod().orElse(null), sender.executor(), startTransaction.getOnPingFailed().orElse(null));
            } else {
                if (startTransaction.getSticky()) {
                    logger.trace("Create sticky transaction with client {} to proxy {}", (Object)this, (Object)sender.getAddressString());
                } else {
                    logger.trace("Create non-sticky transaction with client {}", (Object)this);
                }
                result = new ApiServiceTransaction(this, id, startTimestamp, startTransaction.getPing(), startTransaction.getPingAncestors(), startTransaction.getSticky(), startTransaction.getPingPeriod().orElse(null), startTransaction.getFailedPingRetryPeriod().orElse(null), sender.executor(), startTransaction.getOnPingFailed().orElse(null));
            }
            sender.ref();
            result.getTransactionCompleteFuture().whenComplete((ignored, ex) -> sender.unref());
            RpcRequestsTestingController rpcRequestsTestingController = this.rpcOptions.getTestingOptions().getRpcRequestsTestingController();
            if (rpcRequestsTestingController != null) {
                rpcRequestsTestingController.addStartedTransaction(id);
            }
            logger.debug("New transaction {} has started by {}", (Object)id, (Object)builder);
            return result;
        }));
    }

    @Override
    public CompletableFuture<Void> pingTransaction(PingTransaction req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.PING_TRANSACTION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> commitTransaction(CommitTransaction req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.COMMIT_TRANSACTION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> abortTransaction(AbortTransaction req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ABORT_TRANSACTION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<YTreeNode> getNode(GetNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_NODE.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.parseByteString(((TRspGetNode)response.body()).getValue())));
    }

    @Override
    public CompletableFuture<YTreeNode> listNode(ListNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LIST_NODE.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.parseByteString(((TRspListNode)response.body()).getValue())));
    }

    @Override
    public CompletableFuture<Void> setNode(SetNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.SET_NODE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Boolean> existsNode(ExistsNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.EXISTS_NODE.createRequestBuilder(this.rpcOptions)), response -> ((TRspExistsNode)response.body()).getExists()));
    }

    @Override
    public CompletableFuture<List<YTreeNode>> getTablePivotKeys(GetTablePivotKeys req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_TABLE_PIVOT_KEYS.createRequestBuilder(this.rpcOptions)), response -> YTreeBinarySerializer.deserialize((InputStream)new ByteArrayInputStream(((TRspGetTablePivotKeys)response.body()).getValue().toByteArray())).asList()));
    }

    @Override
    public CompletableFuture<GUID> createObject(CreateObject req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.CREATE_OBJECT.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspCreateObject)response.body()).getObjectId())));
    }

    @Override
    public CompletableFuture<Void> checkClusterLiveness(CheckClusterLiveness req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.CHECK_CLUSTER_LIVENESS.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<GUID> createNode(CreateNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.CREATE_NODE.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspCreateNode)response.body()).getNodeId())));
    }

    @Override
    public CompletableFuture<Void> removeNode(RemoveNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.REMOVE_NODE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<LockNodeResult> lockNode(LockNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LOCK_NODE.createRequestBuilder(this.rpcOptions)), response -> new LockNodeResult(RpcUtil.fromProto((TGuidOrBuilder)((TRspLockNode)response.body()).getNodeId()), RpcUtil.fromProto((TGuidOrBuilder)((TRspLockNode)response.body()).getLockId()))));
    }

    @Override
    public CompletableFuture<GUID> copyNode(CopyNode req) {
        return this.onStarted(req, this.copyMoveNode(() -> this.copyNode(((CopyNode.Builder)req.toBuilder().setEnableCrossCellCopying(false)).build(), false), tx -> this.copyNode(((CopyNode.Builder)((CopyNode.Builder)req.toBuilder().setEnableCrossCellCopying(true)).setTransactionalOptions(tx.getTransactionalOptions())).build(), true)));
    }

    private CompletableFuture<GUID> copyNode(CopyNode req, boolean disableRetries) {
        RpcOptions reqRpcOptions = this.rpcOptions;
        if (disableRetries) {
            reqRpcOptions = new RpcOptions(reqRpcOptions).setRetryPolicyFactory(RetryPolicy::noRetries);
        }
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.COPY_NODE.createRequestBuilder(reqRpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspCopyNode)response.body()).getNodeId())));
    }

    @Override
    public CompletableFuture<GUID> moveNode(MoveNode req) {
        return this.onStarted(req, this.copyMoveNode(() -> this.moveNode(((MoveNode.Builder)req.toBuilder().setEnableCrossCellCopying(false)).build(), false), tx -> this.moveNode(((MoveNode.Builder)((MoveNode.Builder)req.toBuilder().setEnableCrossCellCopying(true)).setTransactionalOptions(tx.getTransactionalOptions())).build(), true)));
    }

    private CompletableFuture<GUID> moveNode(MoveNode req, boolean disableRetries) {
        RpcOptions reqRpcOptions = this.rpcOptions;
        if (disableRetries) {
            reqRpcOptions = new RpcOptions(reqRpcOptions).setRetryPolicyFactory(RetryPolicy::noRetries);
        }
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.MOVE_NODE.createRequestBuilder(reqRpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspMoveNode)response.body()).getNodeId())));
    }

    private CompletableFuture<GUID> copyMoveNode(Supplier<CompletableFuture<GUID>> sendReqWithDisabledCrossCellCopying, Function<ApiServiceTransaction, CompletableFuture<GUID>> sendReqWithEnabledCrossCellCopying) {
        return ((CompletableFuture)sendReqWithDisabledCrossCellCopying.get().handle((guid, error) -> {
            if (error == null) {
                return CompletableFuture.completedFuture(guid);
            }
            if (error instanceof YTsaurusError && ((YTsaurusError)error).matches(YTsaurusErrorCode.CrossCellAdditionalPath.getCode())) {
                return new TransactionRetrier(TransactionType.Master, this, this.executorService, sendReqWithEnabledCrossCellCopying, this.executorService, this.rpcOptions.getRetryPolicyFactory().get(), this.rpcOptions).run();
            }
            throw new RuntimeException((Throwable)error);
        })).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<GUID> linkNode(LinkNode req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LINK_NODE.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspLinkNode)response.body()).getNodeId())));
    }

    @Override
    public CompletableFuture<Void> concatenateNodes(ConcatenateNodes req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.CONCATENATE_NODES.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<List<MultiTablePartition>> partitionTables(PartitionTables req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.PARTITION_TABLES.createRequestBuilder(this.rpcOptions)), response -> ((TRspPartitionTables)response.body()).getPartitionsList().stream().map((? super T p) -> {
            List<YPath> tableRanges = p.getTableRangesList().stream().map(ByteString::toStringUtf8).map(RichYPathParser::parse).collect(Collectors.toList());
            MultiTablePartition.AggregateStatistics statistics = new MultiTablePartition.AggregateStatistics(p.getAggregateStatistics().getChunkCount(), p.getAggregateStatistics().getDataWeight(), p.getAggregateStatistics().getRowCount());
            return new MultiTablePartition(tableRanges, statistics);
        }).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<UnversionedRowset> lookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.onStarted(request, this.lookupRowsImpl(request, response -> ApiServiceUtil.deserializeUnversionedRowset(((TRspLookupRows)response.body()).getRowsetDescriptor(), response.attachments())));
    }

    @Override
    public <T> CompletableFuture<List<T>> lookupRows(AbstractLookupRowsRequest<?, ?> request, YTreeRowSerializer<T> serializer) {
        return this.onStarted(request, this.lookupRowsImpl(request, response -> {
            ConsumerSourceRet result = ConsumerSource.list();
            ApiServiceUtil.deserializeUnversionedRowset(((TRspLookupRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, result, this.serializationResolver);
            return result.get();
        }));
    }

    @Override
    public <T> CompletableFuture<Void> lookupRows(AbstractLookupRowsRequest<?, ?> request, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.onStarted(request, this.lookupRowsImpl(request, response -> {
            ApiServiceUtil.deserializeUnversionedRowset(((TRspLookupRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, consumer, this.serializationResolver);
            return null;
        }));
    }

    private <T> CompletableFuture<T> lookupRowsImpl(AbstractLookupRowsRequest<?, ?> request, Function<RpcClientResponse<TRspLookupRows>, T> responseReader) {
        request.convertValues(this.serializationResolver);
        return this.onStarted(request, this.handleHeavyResponse(this.sendRequest(request.asLookupRowsWritable(), ApiServiceMethodTable.LOOKUP_ROWS.createRequestBuilder(this.rpcOptions)), response -> {
            logger.trace("LookupRows incoming rowset descriptor: {}", (Object)((TRspLookupRows)response.body()).getRowsetDescriptor());
            return responseReader.apply((RpcClientResponse<TRspLookupRows>)response);
        }));
    }

    @Override
    public CompletableFuture<List<UnversionedRowset>> multiLookupRows(MultiLookupRowsRequest request) {
        return this.onStarted(request, this.multiLookupImpl(request, response -> this.multiLookupResponseReader((RpcClientResponse<TRspMultiLookup>)response, ApiServiceUtil::deserializeUnversionedRowset)));
    }

    @Override
    public <T> CompletableFuture<List<List<T>>> multiLookupRows(MultiLookupRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.onStarted(request, this.multiLookupImpl(request, response -> this.multiLookupResponseReader((RpcClientResponse<TRspMultiLookup>)response, (rowsetDescriptor, attachments) -> {
            ConsumerSourceRet result = ConsumerSource.list();
            ApiServiceUtil.deserializeUnversionedRowset(rowsetDescriptor, attachments, serializer, result, this.serializationResolver);
            return result.get();
        })));
    }

    private <T> CompletableFuture<T> multiLookupImpl(MultiLookupRowsRequest request, Function<RpcClientResponse<TRspMultiLookup>, T> responseReader) {
        for (MultiLookupRowsSubrequest subrequest : request.getSubrequests()) {
            subrequest.convertValues(this.serializationResolver);
        }
        return this.handleHeavyResponse(this.sendRequest(request.asMultiLookupWritable(), ApiServiceMethodTable.MULTI_LOOKUP.createRequestBuilder(this.rpcOptions)), response -> {
            logger.trace("MultiLookupRows incoming \u2013 number of rowset descriptors: {}", (Object)((TRspMultiLookup)response.body()).getSubresponsesCount());
            return responseReader.apply((RpcClientResponse<TRspMultiLookup>)response);
        });
    }

    private <T> List<T> multiLookupResponseReader(RpcClientResponse<TRspMultiLookup> response, BiFunction<TRowsetDescriptor, List<byte[]>, T> rowsetDeserializer) {
        ArrayList<T> result = new ArrayList<T>(response.body().getSubresponsesCount());
        int beginAttachmentIndex = 0;
        for (TRspMultiLookup.TSubresponse subresponse : response.body().getSubresponsesList()) {
            int endAttachmentIndex = beginAttachmentIndex + subresponse.getAttachmentCount();
            result.add(rowsetDeserializer.apply(subresponse.getRowsetDescriptor(), response.attachments().subList(beginAttachmentIndex, endAttachmentIndex)));
            beginAttachmentIndex = endAttachmentIndex;
        }
        return result;
    }

    @Override
    public CompletableFuture<VersionedRowset> versionedLookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.onStarted(request, this.versionedLookupRowsImpl(request, response -> ApiServiceUtil.deserializeVersionedRowset(((TRspVersionedLookupRows)response.body()).getRowsetDescriptor(), response.attachments())));
    }

    private <T> CompletableFuture<T> versionedLookupRowsImpl(AbstractLookupRowsRequest<?, ?> request, Function<RpcClientResponse<TRspVersionedLookupRows>, T> responseReader) {
        request.convertValues(this.serializationResolver);
        return this.handleHeavyResponse(this.sendRequest(request.asVersionedLookupRowsWritable(), ApiServiceMethodTable.VERSIONED_LOOKUP_ROWS.createRequestBuilder(this.rpcOptions)), response -> {
            logger.trace("VersionedLookupRows incoming rowset descriptor: {}", (Object)((TRspVersionedLookupRows)response.body()).getRowsetDescriptor());
            return responseReader.apply((RpcClientResponse<TRspVersionedLookupRows>)response);
        });
    }

    @Override
    public CompletableFuture<SelectRowsResult> selectRowsV2(SelectRowsRequest request) {
        return this.onStarted(request, (CompletableFuture)this.sendRequest(request, ApiServiceMethodTable.SELECT_ROWS.createRequestBuilder(this.rpcOptions)).thenApply(response -> new SelectRowsResult((RpcClientResponse<TRspSelectRows>)response, this.heavyExecutor, this.serializationResolver)));
    }

    @Override
    public CompletableFuture<UnversionedRowset> selectRows(SelectRowsRequest request) {
        return this.onStarted(request, this.selectRowsImpl(request, response -> ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments())));
    }

    @Override
    public <T> CompletableFuture<List<T>> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.onStarted(request, this.selectRowsImpl(request, response -> {
            ConsumerSourceRet result = ConsumerSource.list();
            ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, result, this.serializationResolver);
            return result.get();
        }));
    }

    @Override
    public <T> CompletableFuture<Void> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.onStarted(request, this.selectRowsImpl(request, response -> {
            ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, consumer, this.serializationResolver);
            return null;
        }));
    }

    private <T> CompletableFuture<T> selectRowsImpl(SelectRowsRequest request, Function<RpcClientResponse<TRspSelectRows>, T> responseReader) {
        return this.handleHeavyResponse(this.sendRequest(request, ApiServiceMethodTable.SELECT_ROWS.createRequestBuilder(this.rpcOptions)), response -> {
            logger.trace("SelectRows incoming rowset descriptor: {}", (Object)((TRspSelectRows)response.body()).getRowsetDescriptor());
            return responseReader.apply((RpcClientResponse<TRspSelectRows>)response);
        });
    }

    @Override
    public CompletableFuture<Void> modifyRows(GUID transactionId, AbstractModifyRowsRequest<?, ?> request) {
        request.convertValues(this.serializationResolver);
        return this.onStarted(request, RpcUtil.apply(this.sendRequest(new ModifyRowsWrapper(transactionId, request), ApiServiceMethodTable.MODIFY_ROWS.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Long> buildSnapshot(BuildSnapshot req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.BUILD_SNAPSHOT.createRequestBuilder(this.rpcOptions)), response -> ((TRspBuildSnapshot)response.body()).getSnapshotId()));
    }

    @Override
    public CompletableFuture<Void> gcCollect(GcCollect req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GC_COLLECT.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> mountTable(MountTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.MOUNT_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> unmountTable(UnmountTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.UNMOUNT_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> remountTable(RemountTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.REMOUNT_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> freezeTable(FreezeTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.FREEZE_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> unfreezeTable(UnfreezeTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.UNFREEZE_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<List<GUID>> getInSyncReplicas(GetInSyncReplicas request, YtTimestamp timestamp) {
        request.convertValues(this.serializationResolver);
        return this.onStarted(request, RpcUtil.apply(this.sendRequest(new GetInSyncReplicasWrapper(timestamp, request), ApiServiceMethodTable.GET_IN_SYNC_REPLICAS.createRequestBuilder(this.rpcOptions)), response -> ((TRspGetInSyncReplicas)response.body()).getReplicaIdsList().stream().map(RpcUtil::fromProto).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<List<TabletInfo>> getTabletInfos(GetTabletInfos req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_TABLET_INFOS.createRequestBuilder(this.rpcOptions)), response -> ((TRspGetTabletInfos)response.body()).getTabletsList().stream().map((? super T x) -> {
            List<TabletInfoReplica> replicas = x.getReplicasList().stream().map((? super T o) -> new TabletInfoReplica(RpcUtil.fromProto((TGuidOrBuilder)o.getReplicaId()), o.getLastReplicationTimestamp(), ETableReplicaMode.forNumber((int)o.getMode()))).collect(Collectors.toList());
            return new TabletInfo(x.getTotalRowCount(), x.getTrimmedRowCount(), x.getLastWriteTimestamp(), replicas);
        }).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<YtTimestamp> generateTimestamps(GenerateTimestamps req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GENERATE_TIMESTAMPS.createRequestBuilder(this.rpcOptions)), response -> YtTimestamp.valueOf((long)((TRspGenerateTimestamps)response.body()).getTimestamp())));
    }

    @Override
    public CompletableFuture<Void> reshardTable(ReshardTable req) {
        req.convertValues(this.serializationResolver);
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.RESHARD_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> trimTable(TrimTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.TRIM_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> alterTable(AlterTable req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ALTER_TABLE.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> alterTableReplica(GUID replicaId, boolean enabled, ETableReplicaMode mode, boolean preserveTimestamp, EAtomicity atomicity) {
        Atomicity convertedAtomicity;
        TableReplicaMode convertedMode;
        switch (mode) {
            case TRM_ASYNC: {
                convertedMode = TableReplicaMode.Async;
                break;
            }
            case TRM_SYNC: {
                convertedMode = TableReplicaMode.Sync;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (atomicity) {
            case A_FULL: {
                convertedAtomicity = Atomicity.Full;
                break;
            }
            case A_NONE: {
                convertedAtomicity = Atomicity.None;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.alterTableReplica(AlterTableReplica.builder().setReplicaId(replicaId).setEnabled(enabled).setMode(convertedMode).setPreserveTimestamps(preserveTimestamp).setAtomicity(convertedAtomicity).build());
    }

    @Override
    public CompletableFuture<Void> alterTableReplica(AlterTableReplica req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ALTER_TABLE_REPLICA.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<GUID> startOperation(StartOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.START_OPERATION.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspStartOperation)response.body()).getOperationId())));
    }

    @Override
    public CompletableFuture<ShuffleHandle> startShuffle(StartShuffle req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.START_SHUFFLE.createRequestBuilder(this.rpcOptions)), response -> new ShuffleHandle(((TRspStartShuffle)response.body()).getShuffleHandle())));
    }

    @Override
    public CompletableFuture<AsyncWriter<UnversionedRow>> createShuffleWriter(CreateShuffleWriter req) {
        RpcClientRequestBuilder<TReqWriteShuffleData.Builder, TRspWriteShuffleData> builder = ApiServiceMethodTable.WRITE_SHUFFLE_DATA.createRequestBuilder(this.rpcOptions);
        req.writeHeaderTo(builder.header());
        req.writeTo(builder.body());
        ShuffleDataWriterImpl shuffleDataWriter = new ShuffleDataWriterImpl(req.getWindowSize(), req.getPacketSize(), req.getPartitionColumn());
        CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, shuffleDataWriter);
        CompletionStage result = streamControlFuture.thenCompose(control -> shuffleDataWriter.startUpload());
        RpcUtil.relayCancel(result, streamControlFuture);
        return result;
    }

    @Override
    public CompletableFuture<AsyncReader<UnversionedRow>> createShuffleReader(CreateShuffleReader req) {
        RpcClientRequestBuilder<TReqReadShuffleData.Builder, TRspReadShuffleData> builder = ApiServiceMethodTable.READ_SHUFFLE_DATA.createRequestBuilder(this.rpcOptions);
        req.writeHeaderTo(builder.header());
        req.writeTo(builder.body());
        ShuffleDataReaderImpl shuffleDataReader = new ShuffleDataReaderImpl();
        CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, shuffleDataReader);
        CompletionStage result = streamControlFuture.thenCompose(control -> shuffleDataReader.startRead());
        RpcUtil.relayCancel(result, streamControlFuture);
        return result;
    }

    YTreeMapNode patchSpec(YTreeMapNode spec) {
        YTreeBuilder b;
        YTreeNode patch;
        YTreeMapNode resultingSpec = spec;
        for (String string : JOB_TYPES) {
            if (!resultingSpec.containsKey(string) || !this.config.getJobSpecPatch().isPresent()) continue;
            patch = YTree.builder().beginMap().key(string).value(this.config.getJobSpecPatch().get()).endMap().build();
            b = YTree.builder();
            YTreeNodeUtils.merge((YTreeNode)resultingSpec, (YTreeNode)patch, (YsonConsumer)b, (boolean)true);
            resultingSpec = b.build().mapNode();
        }
        if (resultingSpec.containsKey("tasks") && this.config.getJobSpecPatch().isPresent()) {
            for (Map.Entry entry : resultingSpec.getOrThrow("tasks").asMap().entrySet()) {
                patch = YTree.builder().beginMap().key("tasks").beginMap().key((String)entry.getKey()).value(this.config.getJobSpecPatch().get()).endMap().endMap().build();
                b = YTree.builder();
                YTreeNodeUtils.merge((YTreeNode)resultingSpec, (YTreeNode)patch, (YsonConsumer)b, (boolean)true);
                resultingSpec = b.build().mapNode();
            }
        }
        if (this.config.getSpecPatch().isPresent()) {
            YTreeBuilder b2 = YTree.builder();
            YTreeNodeUtils.merge((YTreeNode)resultingSpec, (YTreeNode)this.config.getSpecPatch().get(), (YsonConsumer)b2, (boolean)true);
            resultingSpec = b2.build().mapNode();
        }
        return resultingSpec;
    }

    private CompletableFuture<YTreeNode> prepareSpec(Spec spec, @Nullable TransactionalOptions transactionalOptions) {
        return CompletableFuture.supplyAsync(() -> {
            YTreeBuilder builder = YTree.builder();
            spec.prepare(builder, this, new SpecPreparationContext(this.config, transactionalOptions));
            return this.patchSpec(builder.build().mapNode());
        }, this.prepareSpecExecutor);
    }

    <T extends Spec> CompletableFuture<Operation> startPreparedOperation(YTreeNode preparedSpec, BaseOperation<T> req, EOperationType type) {
        return this.startOperation(((StartOperation.Builder)((StartOperation.Builder)((StartOperation.Builder)((StartOperation.Builder)StartOperation.builder().setType(type)).setSpec(preparedSpec)).setTransactionalOptions(req.getTransactionalOptions().orElse(null))).setMutatingOptions(req.getMutatingOptions())).build()).thenApply(operationId -> new OperationImpl((GUID)operationId, this, this.executorService, this.config.getOperationPingPeriod()));
    }

    private <T extends Spec> CompletableFuture<Operation> startOperationImpl(BaseOperation<T> req, EOperationType type) {
        return this.prepareSpec((Spec)req.getSpec(), req.getTransactionalOptions().orElse(null)).thenCompose(preparedSpec -> this.startPreparedOperation((YTreeNode)preparedSpec, req, type));
    }

    @Override
    public CompletableFuture<Operation> startMap(MapOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_MAP);
    }

    @Override
    public CompletableFuture<Operation> startReduce(ReduceOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_REDUCE);
    }

    @Override
    public CompletableFuture<Operation> startSort(SortOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_SORT);
    }

    @Override
    public CompletableFuture<Operation> startMapReduce(MapReduceOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_MAP_REDUCE);
    }

    @Override
    public CompletableFuture<Operation> startMerge(MergeOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_MERGE);
    }

    @Override
    public CompletableFuture<Operation> startRemoteCopy(RemoteCopyOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_REMOTE_COPY);
    }

    @Override
    public CompletableFuture<Operation> startVanilla(VanillaOperation req) {
        return this.startOperationImpl(req, EOperationType.OT_VANILLA);
    }

    @Override
    public CompletableFuture<YTreeNode> getOperation(GetOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_OPERATION.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.parseByteString(((TRspGetOperation)response.body()).getMeta())));
    }

    @Override
    public Operation attachOperation(GUID operationId) {
        return new OperationImpl(operationId, this, this.executorService, this.config.getOperationPingPeriod());
    }

    @Override
    public CompletableFuture<Void> abortOperation(AbortOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ABORT_OPERATION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> completeOperation(CompleteOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.COMPLETE_OPERATION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> suspendOperation(SuspendOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.SUSPEND_OPERATION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> resumeOperation(ResumeOperation req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.RESUME_OPERATION.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<YTreeNode> getJob(GetJob req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_JOB.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.parseByteString(((TRspGetJob)response.body()).getInfo())));
    }

    @Override
    public CompletableFuture<ListJobsResult> listJobs(ListJobs req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LIST_JOBS.createRequestBuilder(this.rpcOptions)), response -> new ListJobsResult((TRspListJobs)response.body())));
    }

    @Override
    public CompletableFuture<GetJobStderrResult> getJobStderr(GetJobStderr req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_JOB_STDERR.createRequestBuilder(this.rpcOptions)), response -> new GetJobStderrResult(response.attachments())));
    }

    @Override
    public CompletableFuture<Void> abortJob(AbortJob req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ABORT_JOB.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> updateOperationParameters(UpdateOperationParameters req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.UPDATE_OPERATION_PARAMETERS.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<TCheckPermissionResult> checkPermission(CheckPermission req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.CHECK_PERMISSION.createRequestBuilder(this.rpcOptions)), response -> ((TRspCheckPermission)response.body()).getResult()));
    }

    @Override
    public CompletableFuture<GetFileFromCacheResult> getFileFromCache(GetFileFromCache req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_FILE_FROM_CACHE.createRequestBuilder(this.rpcOptions)), response -> {
            if (!((TRspGetFileFromCache)response.body()).getResult().getPath().isEmpty()) {
                return new GetFileFromCacheResult(YPath.simple((String)((TRspGetFileFromCache)response.body()).getResult().getPath().toStringUtf8()));
            }
            return new GetFileFromCacheResult(null);
        }));
    }

    @Override
    public CompletableFuture<PutFileToCacheResult> putFileToCache(PutFileToCache req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.PUT_FILE_TO_CACHE.createRequestBuilder(this.rpcOptions)), response -> new PutFileToCacheResult(YPath.simple((String)((TRspPutFileToCache)response.body()).getResult().getPath().toStringUtf8()))));
    }

    @Override
    public CompletableFuture<QueueRowset> pullConsumer(PullConsumer req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.PULL_CONSUMER.createRequestBuilder(this.rpcOptions)), response -> new QueueRowset(ApiServiceUtil.deserializeUnversionedRowset(((TRspPullQueueConsumer)response.body()).getRowsetDescriptor(), response.attachments()), ((TRspPullQueueConsumer)response.body()).getStartOffset())));
    }

    @Override
    public CompletableFuture<Void> advanceConsumer(AdvanceConsumer req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ADVANCE_CONSUMER.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<Void> registerQueueConsumer(RegisterQueueConsumer req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.REGISTER_QUEUE_CONSUMER.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<GUID> startQuery(StartQuery req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.START_QUERY.createRequestBuilder(this.rpcOptions)), response -> RpcUtil.fromProto((TGuidOrBuilder)((TRspStartQuery)response.body()).getQueryId())));
    }

    @Override
    public CompletableFuture<ListQueueConsumerRegistrationsResult> listQueueConsumerRegistrations(ListQueueConsumerRegistrations req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LIST_QUEUE_CONSUMER_REGISTRATIONS.createRequestBuilder(this.rpcOptions)), response -> new ListQueueConsumerRegistrationsResult((TRspListQueueConsumerRegistrations)response.body())));
    }

    @Override
    public CompletableFuture<Void> abortQuery(AbortQuery req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ABORT_QUERY.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public CompletableFuture<QueryResult> getQueryResult(GetQueryResult req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_QUERY_RESULT.createRequestBuilder(this.rpcOptions)), response -> new QueryResult((TRspGetQueryResult)response.body())));
    }

    @Override
    public CompletableFuture<UnversionedRowset> readQueryResult(ReadQueryResult req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.READ_QUERY_RESULT.createRequestBuilder(this.rpcOptions)), response -> ApiServiceUtil.deserializeUnversionedRowset(((TRspReadQueryResult)response.body()).getRowsetDescriptor(), response.attachments())));
    }

    @Override
    public CompletableFuture<Query> getQuery(GetQuery req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.GET_QUERY.createRequestBuilder(this.rpcOptions)), response -> new Query(((TRspGetQuery)response.body()).getQuery())));
    }

    @Override
    public CompletableFuture<ListQueriesResult> listQueries(ListQueries req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.LIST_QUERIES.createRequestBuilder(this.rpcOptions)), response -> new ListQueriesResult((TRspListQueries)response.body())));
    }

    @Override
    public CompletableFuture<Void> alterQuery(AlterQuery req) {
        return this.onStarted(req, RpcUtil.apply(this.sendRequest(req, ApiServiceMethodTable.ALTER_QUERY.createRequestBuilder(this.rpcOptions)), response -> null));
    }

    @Override
    public <T> CompletableFuture<TableReader<T>> readTable(ReadTable<T> req) {
        TableReaderImpl tableReader;
        Optional<YTreeSerializer<T>> serializer;
        Optional<TableAttachmentReader<T>> attachmentReader = req.getSerializationContext().getAttachmentReader();
        if (attachmentReader.isEmpty() && (serializer = req.getSerializationContext().getYtreeSerializer()).isPresent()) {
            attachmentReader = Optional.of(new TableAttachmentWireProtocolReader<T>(this.serializationResolver.createWireRowDeserializer(serializer.get())));
        }
        if (attachmentReader.isPresent()) {
            tableReader = new TableReaderImpl(attachmentReader.get());
        } else {
            if (req.getSerializationContext().getObjectClass().isEmpty()) {
                throw new IllegalArgumentException("No object clazz");
            }
            tableReader = new TableReaderImpl<T>(req, req.getSerializationContext().getObjectClass().get());
        }
        return this.setTableSchemaInSerializer(req).thenCompose(transactionAndLockResult -> {
            ReadTable readReq = ApiServiceClientImpl.getConfiguredReadReq(req, transactionAndLockResult);
            if (transactionAndLockResult != null) {
                tableReader.setTransaction((ApiServiceTransaction)transactionAndLockResult.getKey());
            }
            RpcClientRequestBuilder<TReqReadTable.Builder, TRspReadTable> builder = ApiServiceMethodTable.READ_TABLE.createRequestBuilder(this.rpcOptions);
            readReq.writeHeaderTo(builder.header());
            readReq.writeTo(builder.body());
            CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, tableReader);
            CompletionStage result = streamControlFuture.thenCompose(control -> tableReader.waitMetadata(this.serializationResolver));
            RpcUtil.relayCancel(result, streamControlFuture);
            return result;
        });
    }

    @Override
    public <T> CompletableFuture<AsyncReader<T>> readTableV2(ReadTable<T> req) {
        AsyncTableReaderImpl tableReader;
        Optional<YTreeSerializer<T>> serializer;
        Optional<TableAttachmentReader<T>> attachmentReader = req.getSerializationContext().getAttachmentReader();
        if (attachmentReader.isEmpty() && (serializer = req.getSerializationContext().getYtreeSerializer()).isPresent()) {
            attachmentReader = Optional.of(new TableAttachmentWireProtocolReader<T>(this.serializationResolver.createWireRowDeserializer(serializer.get())));
        }
        if (attachmentReader.isPresent()) {
            tableReader = new AsyncTableReaderImpl(attachmentReader.get());
        } else {
            if (req.getSerializationContext().getObjectClass().isEmpty()) {
                throw new IllegalArgumentException("No object clazz");
            }
            tableReader = new AsyncTableReaderImpl<T>(req, req.getSerializationContext().getObjectClass().get());
        }
        return this.setTableSchemaInSerializer(req).thenCompose(transactionAndLockResult -> {
            ReadTable readReq = ApiServiceClientImpl.getConfiguredReadReq(req, transactionAndLockResult);
            if (transactionAndLockResult != null) {
                tableReader.setTransaction((ApiServiceTransaction)transactionAndLockResult.getKey());
            }
            RpcClientRequestBuilder<TReqReadTable.Builder, TRspReadTable> builder = ApiServiceMethodTable.READ_TABLE.createRequestBuilder(this.rpcOptions);
            readReq.writeHeaderTo(builder.header());
            readReq.writeTo(builder.body());
            CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, tableReader);
            CompletionStage result = streamControlFuture.thenCompose(control -> tableReader.waitMetadata(this.serializationResolver));
            RpcUtil.relayCancel(result, streamControlFuture);
            return result;
        });
    }

    @Override
    public <T> CompletableFuture<TableWriter<T>> writeTable(WriteTable<T> req) {
        if (req.getNeedRetries()) {
            throw new IllegalStateException("Cannot write table with retries in ApiServiceClient");
        }
        return this.setTableSchemaInSerializer(req).thenCompose(transactionAndLockResult -> {
            WriteTable writeReq = ApiServiceClientImpl.getWriteReqByTransactionAndLockResult(req, transactionAndLockResult);
            TableWriterImpl tableWriter = new TableWriterImpl(writeReq, this.serializationResolver);
            if (transactionAndLockResult != null) {
                tableWriter.setTransaction((ApiServiceTransaction)transactionAndLockResult.getKey());
            }
            RpcClientRequestBuilder<TReqWriteTable.Builder, TRspWriteTable> builder = ApiServiceMethodTable.WRITE_TABLE.createRequestBuilder(this.rpcOptions);
            writeReq.writeHeaderTo(builder.header());
            writeReq.writeTo(builder.body());
            CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, tableWriter);
            CompletionStage result = streamControlFuture.thenCompose(control -> tableWriter.startUpload());
            RpcUtil.relayCancel(result, streamControlFuture);
            return result;
        });
    }

    @Override
    public <T> CompletableFuture<AsyncWriter<T>> writeTableV2(WriteTable<T> req) {
        if (req.getNeedRetries()) {
            throw new IllegalStateException("Cannot write table with retries in ApiServiceClient");
        }
        return this.setTableSchemaInSerializer(req).thenCompose(transactionAndLockResult -> {
            WriteTable writeReq = ApiServiceClientImpl.getWriteReqByTransactionAndLockResult(req, transactionAndLockResult);
            AsyncTableWriterImpl tableWriter = new AsyncTableWriterImpl(writeReq, this.serializationResolver);
            if (transactionAndLockResult != null) {
                tableWriter.setTransaction((ApiServiceTransaction)transactionAndLockResult.getKey());
            }
            RpcClientRequestBuilder<TReqWriteTable.Builder, TRspWriteTable> builder = ApiServiceMethodTable.WRITE_TABLE.createRequestBuilder(this.rpcOptions);
            writeReq.writeHeaderTo(builder.header());
            writeReq.writeTo(builder.body());
            CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, tableWriter);
            CompletionStage result = streamControlFuture.thenCompose(control -> tableWriter.startUpload());
            RpcUtil.relayCancel(result, streamControlFuture);
            return result;
        });
    }

    @Override
    public CompletableFuture<FileReader> readFile(ReadFile req) {
        RpcClientRequestBuilder<TReqReadFile.Builder, TRspReadFile> builder = ApiServiceMethodTable.READ_FILE.createRequestBuilder(this.rpcOptions);
        req.writeHeaderTo(builder.header());
        req.writeTo(builder.body());
        FileReaderImpl fileReader = new FileReaderImpl();
        CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, fileReader);
        CompletionStage result = streamControlFuture.thenCompose(control -> fileReader.waitMetadata());
        RpcUtil.relayCancel(result, streamControlFuture);
        return result;
    }

    @Override
    public CompletableFuture<FileWriter> writeFile(WriteFile req) {
        RpcClientRequestBuilder<TReqWriteFile.Builder, TRspWriteFile> builder = ApiServiceMethodTable.WRITE_FILE.createRequestBuilder(this.rpcOptions);
        req.writeHeaderTo(builder.header());
        req.writeTo(builder.body());
        FileWriterImpl fileWriter = new FileWriterImpl(req.getWindowSize(), req.getPacketSize());
        CompletableFuture<RpcClientStreamControl> streamControlFuture = this.startStream(builder, fileWriter);
        CompletionStage result = streamControlFuture.thenCompose(control -> fileWriter.startUpload());
        RpcUtil.relayCancel(result, streamControlFuture);
        return result;
    }

    private <T> CompletableFuture<T> onStarted(RequestBase<?, ?> request, CompletableFuture<T> response) {
        RequestMiddleware requestMiddleware = this.config.getRequestMiddleware();
        if (requestMiddleware == null) {
            return response;
        }
        requestMiddleware.onStarted(request, response);
        return response;
    }

    private <T> CompletableFuture<Map.Entry<ApiServiceTransaction, LockNodeResult>> setTableSchemaInSerializer(WriteTable<T> req) {
        Optional<EntitySkiffSerializer<T>> skiffSerializer = req.getSerializationContext().getSkiffSerializer();
        if (skiffSerializer.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (req.getTableSchema().isPresent()) {
            skiffSerializer.get().setTableSchema(req.getTableSchema().get());
            return CompletableFuture.completedFuture(null);
        }
        return this.startTransactionAndSetSchema(req.getTransactionId().orElse(null), req.getYPath(), skiffSerializer.get(), req.getYPath().getAppend().orElse(false) != false ? LockMode.Shared : LockMode.Exclusive);
    }

    private <T> CompletableFuture<Map.Entry<ApiServiceTransaction, LockNodeResult>> setTableSchemaInSerializer(ReadTable<T> req) {
        Optional<EntitySkiffSerializer<T>> skiffSerializer = req.getSerializationContext().getSkiffSerializer();
        if (skiffSerializer.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (req.getTableSchema().isPresent()) {
            skiffSerializer.get().setTableSchema(req.getTableSchema().get());
            return CompletableFuture.completedFuture(null);
        }
        return this.startTransactionAndSetSchema(req.getTransactionId().orElse(null), req.getYPath(), skiffSerializer.get(), LockMode.Snapshot);
    }

    private <T> CompletableFuture<Map.Entry<ApiServiceTransaction, LockNodeResult>> startTransactionAndSetSchema(GUID transactionId, YPath path, EntitySkiffSerializer<T> serializer, LockMode lockMode) {
        return this.startTransaction(((StartTransaction.Builder)StartTransaction.master().toBuilder().setParentId(transactionId)).build()).thenCompose(transaction -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)transaction.lockNode(new LockNode(path, lockMode)).thenCompose(lockNodeResult -> ((CompletableFuture)((CompletableFuture)transaction.getNode(((GetNode.Builder)((GetNode.Builder)GetNode.builder().setPath(YPath.objectRoot((GUID)lockNodeResult.nodeId))).setAttributes(List.of("schema"))).build()).thenApply(node -> TableSchema.fromYTree((YTreeNode)node.getAttributeOrThrow("schema")))).thenAccept(serializer::setTableSchema)).thenApply(unused -> lockNodeResult))).handle((lockNodeResult, ex) -> {
            if (ex == null) {
                return CompletableFuture.completedFuture(lockNodeResult);
            }
            return ((CompletableFuture)((CompletableFuture)transaction.abort()).thenAccept(voidRes -> {
                throw new RuntimeException((Throwable)ex);
            })).thenApply(unused -> lockNodeResult);
        })).thenCompose(future -> future)).thenApply(lockNodeResult -> new AbstractMap.SimpleEntry<ApiServiceTransaction, LockNodeResult>((ApiServiceTransaction)transaction, (LockNodeResult)lockNodeResult)));
    }

    private static <T> ReadTable<T> getConfiguredReadReq(ReadTable<T> req, Map.Entry<ApiServiceTransaction, LockNodeResult> transactionAndLockResult) {
        ReadTable<T> readReq;
        ReadTable<T> readTable = readReq = transactionAndLockResult != null ? ((ReadTable.Builder)((ReadTable.Builder)((ReadTable.BuilderBase)req.toBuilder()).setTransactionalOptions(transactionAndLockResult.getKey().getTransactionalOptions())).setPath(req.getYPath().withObjectRoot(transactionAndLockResult.getValue().nodeId))).build() : req;
        if (readReq.getSerializationContext().getSkiffSerializer().isEmpty()) {
            return readReq;
        }
        return ((ReadTable.Builder)((ReadTable.BuilderBase)readReq.toBuilder()).setPath(readReq.getYPath().withColumns((Collection)readReq.getSerializationContext().getSkiffSerializer().get().getEntityTableSchema().orElseThrow(IllegalStateException::new).getColumnNames()))).build();
    }

    private static <T> WriteTable<T> getWriteReqByTransactionAndLockResult(WriteTable<T> req, Map.Entry<ApiServiceTransaction, LockNodeResult> transactionAndLockResult) {
        return transactionAndLockResult != null ? ((WriteTable.Builder)((WriteTable.Builder)((WriteTable.BuilderBase)req.toBuilder()).setTransactionalOptions(transactionAndLockResult.getKey().getTransactionalOptions())).setPath(req.getYPath().withObjectRoot(transactionAndLockResult.getValue().nodeId))).build() : req;
    }

    private <T, Response> CompletableFuture<T> handleHeavyResponse(CompletableFuture<Response> future, Function<Response, T> fn) {
        return RpcUtil.applyAsync(future, fn, this.heavyExecutor);
    }

    protected <RequestType extends MessageLite.Builder, ResponseType extends MessageLite> CompletableFuture<RpcClientResponse<ResponseType>> invoke(RpcClientRequestBuilder<RequestType, ResponseType> builder) {
        return builder.invoke(this.rpcClient);
    }

    protected <RequestType extends MessageLite.Builder, ResponseType extends MessageLite> CompletableFuture<RpcClientStreamControl> startStream(RpcClientRequestBuilder<RequestType, ResponseType> builder, RpcStreamConsumer consumer) {
        RpcClientStreamControl control = this.rpcClient.startStream(this.rpcClient, builder.getRpcRequest(), consumer, builder.getOptions());
        return CompletableFuture.completedFuture(control);
    }

    private <RequestMsgBuilder extends MessageLite.Builder, ResponseMsg extends MessageLite, RequestType extends HighLevelRequest<RequestMsgBuilder>> CompletableFuture<RpcClientResponse<ResponseMsg>> sendRequest(RequestType req, RpcClientRequestBuilder<RequestMsgBuilder, ResponseMsg> builder) {
        if (req instanceof TableReq) {
            req = (HighLevelRequest)((RequestBase.Builder)((TableReq.Builder)((TableReq)req).toBuilder()).setMutatingOptions(new MutatingOptions().setMutationId(GUID.create()))).build();
        } else if (req instanceof MutateNode) {
            req = (HighLevelRequest)((RequestBase.Builder)((MutateNode.Builder)((MutateNode)req).toBuilder()).setMutatingOptions(new MutatingOptions().setMutationId(GUID.create()))).build();
        } else if (req instanceof MutateNode.Builder) {
            ((MutateNode.Builder)req).setMutatingOptions(new MutatingOptions().setMutationId(GUID.create()));
        }
        if (req instanceof RequestBase) {
            req = (HighLevelRequest)((RequestBase.Builder)((RequestBase.Builder)((RequestBase)req).toBuilder()).setUserAgent(this.config.getVersion())).build();
        }
        logger.debug("Starting request {}; {}; User-Agent: {}", new Object[]{builder, req.getArgumentsLogString(), this.config.getVersion()});
        req.writeHeaderTo(builder.header());
        req.writeTo(builder);
        return this.invoke(builder);
    }

    public String toString() {
        return this.rpcClient != null ? this.rpcClient.toString() : super.toString();
    }

    @Nullable
    String getRpcProxyAddress() {
        if (this.rpcClient == null) {
            return null;
        }
        return this.rpcClient.getAddressString();
    }
}

