/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.Abortable;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceClientImpl;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.FileReader;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.SelectRowsResult;
import tech.ytsaurus.client.TableReader;
import tech.ytsaurus.client.TableWriter;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.Operation;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.request.AbstractLookupRowsRequest;
import tech.ytsaurus.client.request.AbstractModifyRowsRequest;
import tech.ytsaurus.client.request.AdvanceConsumer;
import tech.ytsaurus.client.request.CheckPermission;
import tech.ytsaurus.client.request.ConcatenateNodes;
import tech.ytsaurus.client.request.CopyNode;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.ExistsNode;
import tech.ytsaurus.client.request.GetFileFromCache;
import tech.ytsaurus.client.request.GetFileFromCacheResult;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.LinkNode;
import tech.ytsaurus.client.request.ListNode;
import tech.ytsaurus.client.request.LockNode;
import tech.ytsaurus.client.request.LockNodeResult;
import tech.ytsaurus.client.request.MapOperation;
import tech.ytsaurus.client.request.MapReduceOperation;
import tech.ytsaurus.client.request.MergeOperation;
import tech.ytsaurus.client.request.MoveNode;
import tech.ytsaurus.client.request.MultiLookupRowsRequest;
import tech.ytsaurus.client.request.MultiTablePartition;
import tech.ytsaurus.client.request.PartitionTables;
import tech.ytsaurus.client.request.PutFileToCache;
import tech.ytsaurus.client.request.PutFileToCacheResult;
import tech.ytsaurus.client.request.ReadFile;
import tech.ytsaurus.client.request.ReadTable;
import tech.ytsaurus.client.request.ReduceOperation;
import tech.ytsaurus.client.request.RemoteCopyOperation;
import tech.ytsaurus.client.request.RemoveNode;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.SelectRowsRequest;
import tech.ytsaurus.client.request.SetNode;
import tech.ytsaurus.client.request.SortOperation;
import tech.ytsaurus.client.request.StartOperation;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.request.VanillaOperation;
import tech.ytsaurus.client.request.WriteFile;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rows.VersionedRowset;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.rpcproxy.EOperationType;
import tech.ytsaurus.rpcproxy.TCheckPermissionResult;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

public class ApiServiceTransaction
implements TransactionalClient,
AutoCloseable,
Abortable {
    private static final Logger logger = LoggerFactory.getLogger(ApiServiceTransaction.class);
    private final ApiServiceClientImpl client;
    private final GUID id;
    private final YtTimestamp startTimestamp;
    private final boolean ping;
    private final boolean sticky;
    private final TransactionalOptions transactionalOptions;
    private final Duration pingPeriod;
    private final Duration failedPingRetryPeriod;
    private final ScheduledExecutorService executor;
    private final CompletableFuture<Void> transactionCompleteFuture = new CompletableFuture();
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACTIVE);
    private final AtomicReference<Boolean> forcedPingStop = new AtomicReference<Boolean>(false);
    private final AbstractQueue<CompletableFuture<Void>> modifyRowsResults = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
    private final Consumer<Exception> onPingFailed;

    ApiServiceTransaction(ApiServiceClientImpl client, GUID id, YtTimestamp startTimestamp, boolean ping, boolean pingAncestors, boolean sticky, Duration pingPeriod, ScheduledExecutorService executor) {
        this(client, id, startTimestamp, ping, pingAncestors, sticky, pingPeriod, null, executor, null);
    }

    ApiServiceTransaction(ApiServiceClientImpl client, GUID id, YtTimestamp startTimestamp, boolean ping, boolean pingAncestors, boolean sticky, Duration pingPeriod, Duration failedPingRetryPeriod, ScheduledExecutorService executor, Consumer<Exception> onPingFailed) {
        this.client = client;
        this.id = Objects.requireNonNull(id);
        this.startTimestamp = Objects.requireNonNull(startTimestamp);
        this.ping = ping;
        this.sticky = sticky;
        this.transactionalOptions = new TransactionalOptions(id, sticky);
        this.pingPeriod = pingPeriod;
        this.failedPingRetryPeriod = ApiServiceTransaction.isValidPingPeriod(failedPingRetryPeriod) ? failedPingRetryPeriod : pingPeriod;
        this.executor = executor;
        this.onPingFailed = onPingFailed;
        if (ApiServiceTransaction.isValidPingPeriod(pingPeriod)) {
            executor.schedule(this::runPeriodicPings, pingPeriod.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public TransactionalClient getRootClient() {
        return this.client;
    }

    public String toString() {
        return "Transaction(" + this.client + ")@" + this.id;
    }

    public ApiServiceClient getClient() {
        return this.client;
    }

    public GUID getId() {
        return this.id;
    }

    public TransactionalOptions getTransactionalOptions() {
        return this.transactionalOptions;
    }

    public YtTimestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public boolean isPing() {
        return this.ping;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    CompletableFuture<Void> getTransactionCompleteFuture() {
        return this.transactionCompleteFuture;
    }

    boolean isActive() {
        return this.state.get() == State.ACTIVE;
    }

    private boolean isPingableState() {
        State currentState = this.state.get();
        return (currentState == State.ACTIVE || currentState == State.COMMITTING) && this.forcedPingStop.get() == false;
    }

    public void stopPing() {
        this.forcedPingStop.set(true);
    }

    private void runPeriodicPings() {
        if (!this.isPingableState()) {
            return;
        }
        this.ping().whenComplete((unused, ex) -> {
            long nextPingDelayMs;
            if (ex == null) {
                nextPingDelayMs = this.pingPeriod.toMillis();
            } else {
                nextPingDelayMs = this.failedPingRetryPeriod.toMillis();
                if (this.onPingFailed != null) {
                    this.onPingFailed.accept(ex instanceof Exception ? (Exception)ex : new RuntimeException((Throwable)ex));
                }
                if (ex instanceof YTsaurusError && ((YTsaurusError)ex).matches(YTsaurusErrorCode.NoSuchTransaction.getCode())) {
                    return;
                }
            }
            if (!this.isPingableState()) {
                return;
            }
            this.executor.schedule(this::runPeriodicPings, nextPingDelayMs, TimeUnit.MILLISECONDS);
        });
    }

    public CompletableFuture<Void> ping() {
        return this.client.pingTransaction(this.id);
    }

    private void throwWrongState(State expectedOldState, State newState) {
        State currentState = this.state.get();
        throw new IllegalStateException(String.format("Failed to set transaction into '%s' state; expected state: '%s'; current state (maybe outdated): '%s'", new Object[]{newState, expectedOldState, currentState}));
    }

    private void updateState(State expectedOldState, State newState) {
        boolean set = this.state.compareAndSet(expectedOldState, newState);
        if (!set) {
            this.throwWrongState(expectedOldState, newState);
        }
    }

    public CompletableFuture<Void> commit() {
        CompletableFuture current;
        this.updateState(State.ACTIVE, State.COMMITTING);
        ArrayList<CompletableFuture> allModifyRowsResults = new ArrayList<CompletableFuture>();
        while ((current = (CompletableFuture)this.modifyRowsResults.poll()) != null) {
            allModifyRowsResults.add(current);
        }
        CompletableFuture<Void> allModifiesCompleted = CompletableFuture.allOf(allModifyRowsResults.toArray(new CompletableFuture[0]));
        return ((CompletableFuture)allModifiesCompleted.whenComplete((unused, error) -> {
            if (error != null) {
                logger.warn("Cannot commit transaction since modify rows failed:", error);
                this.abortImpl(false);
            }
        })).thenCompose(unused -> this.client.commitTransaction(this.id).whenComplete((result, error) -> {
            if (error == null) {
                this.updateState(State.COMMITTING, State.COMMITTED);
            } else {
                this.state.set(State.CLOSED);
            }
            this.transactionCompleteFuture.complete(null);
        }));
    }

    public CompletableFuture<Void> abort() {
        return this.abortImpl(true);
    }

    private CompletableFuture<Void> abortImpl(boolean complainWrongState) {
        State oldState = this.state.getAndSet(State.CLOSED);
        if (oldState == State.ACTIVE || oldState == State.COMMITTING && !complainWrongState) {
            return this.client.abortTransaction(this.id).whenComplete((result, error) -> this.transactionCompleteFuture.complete(null));
        }
        if (complainWrongState) {
            this.throwWrongState(State.ACTIVE, State.CLOSED);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
        this.abortImpl(false);
    }

    @Override
    public CompletableFuture<UnversionedRowset> lookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.client.lookupRows((AbstractLookupRowsRequest)((RequestBase.Builder)((AbstractLookupRowsRequest.Builder)request.toBuilder()).setTimestamp(this.startTimestamp)).build());
    }

    @Override
    public <T> CompletableFuture<List<T>> lookupRows(AbstractLookupRowsRequest<?, ?> request, YTreeRowSerializer<T> serializer) {
        return this.client.lookupRows((AbstractLookupRowsRequest)((RequestBase.Builder)((AbstractLookupRowsRequest.Builder)request.toBuilder()).setTimestamp(this.startTimestamp)).build(), serializer);
    }

    @Override
    public CompletableFuture<List<UnversionedRowset>> multiLookupRows(MultiLookupRowsRequest request) {
        return this.client.multiLookupRows(((MultiLookupRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build());
    }

    @Override
    public <T> CompletableFuture<List<List<T>>> multiLookupRows(MultiLookupRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.client.multiLookupRows(((MultiLookupRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build(), serializer);
    }

    @Override
    public CompletableFuture<VersionedRowset> versionedLookupRows(AbstractLookupRowsRequest<?, ?> request) {
        return this.client.versionedLookupRows((AbstractLookupRowsRequest)((RequestBase.Builder)((AbstractLookupRowsRequest.Builder)request.toBuilder()).setTimestamp(this.startTimestamp)).build());
    }

    @Override
    public CompletableFuture<UnversionedRowset> selectRows(String query) {
        return this.selectRows(SelectRowsRequest.of(query));
    }

    @Override
    public CompletableFuture<SelectRowsResult> selectRowsV2(SelectRowsRequest request) {
        return this.client.selectRowsV2(((SelectRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build());
    }

    @Override
    public CompletableFuture<UnversionedRowset> selectRows(SelectRowsRequest request) {
        return this.client.selectRows(((SelectRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build());
    }

    @Override
    public <T> CompletableFuture<List<T>> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer) {
        return this.client.selectRows(((SelectRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build(), serializer);
    }

    @Override
    public <T> CompletableFuture<Void> selectRows(SelectRowsRequest request, YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.client.selectRows(((SelectRowsRequest.Builder)request.toBuilder().setTimestamp(this.startTimestamp)).build(), serializer, consumer);
    }

    public CompletableFuture<Void> modifyRows(AbstractModifyRowsRequest<?, ?> request) {
        CompletableFuture<Void> result = this.client.modifyRows(this.id, request);
        this.modifyRowsResults.add(result);
        return result;
    }

    public CompletableFuture<Void> modifyRows(AbstractModifyRowsRequest.Builder<?, ?> request) {
        CompletableFuture<Void> result = this.client.modifyRows(this.id, request);
        this.modifyRowsResults.add(result);
        return result;
    }

    @Override
    public CompletableFuture<Void> advanceConsumer(AdvanceConsumer req) {
        return this.client.advanceConsumer(req.toBuilder().setTransactionId(this.id).build());
    }

    @Override
    public CompletableFuture<GUID> createNode(CreateNode req) {
        return this.client.createNode(((CreateNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<Boolean> existsNode(ExistsNode req) {
        return this.client.existsNode(((ExistsNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<YTreeNode> getNode(GetNode req) {
        return this.client.getNode(((GetNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<YTreeNode> listNode(ListNode req) {
        return this.client.listNode(((ListNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<Void> removeNode(RemoveNode req) {
        return this.client.removeNode(((RemoveNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<Void> setNode(SetNode req) {
        return this.client.setNode(((SetNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<LockNodeResult> lockNode(LockNode req) {
        return this.client.lockNode(((LockNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<GUID> copyNode(CopyNode req) {
        return this.client.copyNode(((CopyNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<GUID> moveNode(MoveNode req) {
        return this.client.moveNode(((MoveNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<GUID> linkNode(LinkNode req) {
        return this.client.linkNode(((LinkNode.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<Void> concatenateNodes(ConcatenateNodes req) {
        return this.client.concatenateNodes(((ConcatenateNodes.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<List<MultiTablePartition>> partitionTables(PartitionTables req) {
        return this.client.partitionTables(req.toBuilder().setTransactionalOptions(this.transactionalOptions).build());
    }

    @Override
    public <T> CompletableFuture<TableReader<T>> readTable(ReadTable<T> req) {
        return this.client.readTable(((ReadTable.Builder)((ReadTable.BuilderBase)req.toBuilder()).setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public <T> CompletableFuture<AsyncReader<T>> readTableV2(ReadTable<T> req) {
        return this.client.readTableV2(((ReadTable.Builder)((ReadTable.BuilderBase)req.toBuilder()).setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public <T> CompletableFuture<TableWriter<T>> writeTable(WriteTable<T> req) {
        return this.client.writeTable(((WriteTable.Builder)((WriteTable.BuilderBase)req.toBuilder()).setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public <T> CompletableFuture<AsyncWriter<T>> writeTableV2(WriteTable<T> req) {
        return this.client.writeTableV2(((WriteTable.Builder)((WriteTable.BuilderBase)req.toBuilder()).setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<FileReader> readFile(ReadFile req) {
        return this.client.readFile(((ReadFile.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<FileWriter> writeFile(WriteFile req) {
        return this.client.writeFile(((WriteFile.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<GUID> startOperation(StartOperation req) {
        return this.client.startOperation(((StartOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    private CompletableFuture<YTreeNode> prepareSpec(Spec spec) {
        return CompletableFuture.supplyAsync(() -> {
            YTreeBuilder builder = YTree.builder();
            spec.prepare(builder, this, new SpecPreparationContext(this.client.getConfig()));
            return this.client.patchSpec(builder.build().mapNode());
        }, this.client.getPrepareSpecExecutor());
    }

    @Override
    public CompletableFuture<Operation> startMap(MapOperation req) {
        MapOperation transactionalReq = ((MapOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_MAP));
    }

    @Override
    public CompletableFuture<Operation> startReduce(ReduceOperation req) {
        ReduceOperation transactionalReq = ((ReduceOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_REDUCE));
    }

    @Override
    public CompletableFuture<Operation> startSort(SortOperation req) {
        SortOperation transactionalReq = ((SortOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_SORT));
    }

    @Override
    public CompletableFuture<Operation> startMapReduce(MapReduceOperation req) {
        MapReduceOperation transactionalReq = ((MapReduceOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_MAP_REDUCE));
    }

    @Override
    public CompletableFuture<Operation> startMerge(MergeOperation req) {
        MergeOperation transactionalReq = ((MergeOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_MERGE));
    }

    @Override
    public CompletableFuture<Operation> startRemoteCopy(RemoteCopyOperation req) {
        RemoteCopyOperation transactionalReq = ((RemoteCopyOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_REMOTE_COPY));
    }

    @Override
    public CompletableFuture<Operation> startVanilla(VanillaOperation req) {
        VanillaOperation transactionalReq = ((VanillaOperation.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build();
        return this.prepareSpec((Spec)transactionalReq.getSpec()).thenCompose(preparedSpec -> this.client.startPreparedOperation((YTreeNode)preparedSpec, transactionalReq, EOperationType.OT_VANILLA));
    }

    @Override
    public Operation attachOperation(GUID operationId) {
        return this.client.attachOperation(operationId);
    }

    @Override
    public CompletableFuture<TCheckPermissionResult> checkPermission(CheckPermission req) {
        return this.client.checkPermission(((CheckPermission.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<GetFileFromCacheResult> getFileFromCache(GetFileFromCache req) {
        return this.client.getFileFromCache(((GetFileFromCache.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Override
    public CompletableFuture<PutFileToCacheResult> putFileToCache(PutFileToCache req) {
        return this.client.putFileToCache(((PutFileToCache.Builder)req.toBuilder().setTransactionalOptions(this.transactionalOptions)).build());
    }

    @Nullable
    String getRpcProxyAddress() {
        return this.client.getRpcProxyAddress();
    }

    private static boolean isValidPingPeriod(Duration pingPeriod) {
        return pingPeriod != null && !pingPeriod.isZero() && !pingPeriod.isNegative();
    }

    static enum State {
        ACTIVE,
        COMMITTING,
        COMMITTED,
        CLOSED;

    }
}

