/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.RetryingTableWriterBaseImpl;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class AsyncRetryingTableWriterImpl<T>
extends RetryingTableWriterBaseImpl<T>
implements AsyncWriter<T> {
    AsyncRetryingTableWriterImpl(ApiServiceClient apiServiceClient, ScheduledExecutorService executor, WriteTable<T> req, RpcOptions rpcOptions, SerializationResolver serializationResolver) {
        super(apiServiceClient, executor, req, rpcOptions, serializationResolver);
    }

    @Override
    public CompletableFuture<Void> write(List<T> rows) {
        return this.init.thenCompose(initResult -> {
            Objects.requireNonNull(this.tableRowsSerializer);
            TableSchema schema = this.req.getTableSchema().isPresent() ? this.req.getTableSchema().get() : (this.tableRowsSerializer instanceof TableRowsWireSerializer && ((TableRowsWireSerializer)this.tableRowsSerializer).getSchema().getColumnsCount() > 0 ? ((TableRowsWireSerializer)this.tableRowsSerializer).getSchema() : initResult.schema);
            return this.writeImpl(rows, schema);
        });
    }

    private CompletableFuture<Void> writeImpl(List<T> rows, TableSchema schema) {
        if (this.write(rows, schema)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.readyEvent().thenCompose(unused -> this.writeImpl(rows, schema));
    }

    @Override
    public CompletableFuture<?> finish() {
        return super.close();
    }
}

