/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class BackoffProvider {
    @Nullable
    private Duration currentExponentialBackoff = null;

    BackoffProvider() {
    }

    Duration getBackoffTime(YTsaurusError error, RpcOptions options) {
        Set errorCodes = error.getErrorCodes();
        if (errorCodes.stream().anyMatch(BackoffProvider::isExponentialBackoffError)) {
            if (this.currentExponentialBackoff == null) {
                this.currentExponentialBackoff = options.getMinBackoffTime();
                return this.currentExponentialBackoff;
            }
            this.currentExponentialBackoff = Collections.max(Arrays.asList(this.currentExponentialBackoff.plus(Duration.ofSeconds(1L)), this.currentExponentialBackoff.multipliedBy(2L)));
            assert (this.currentExponentialBackoff != null);
            Duration maxBackoffTime = options.getMaxBackoffTime();
            if (this.currentExponentialBackoff.compareTo(maxBackoffTime) > 0) {
                this.currentExponentialBackoff = options.getMaxBackoffTime();
            }
            return this.currentExponentialBackoff;
        }
        return options.getMinBackoffTime();
    }

    private static boolean isExponentialBackoffError(int errorCode) {
        return errorCode == YTsaurusErrorCode.RequestQueueSizeLimitExceeded.code || errorCode == 904;
    }
}

