/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ClientPool;
import tech.ytsaurus.client.FailureDetectingRpcClient;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class ErrorHandlingClient
extends FailureDetectingRpcClient
implements RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(ClientPool.class);
    final CompletableFuture<Void> statusFuture;

    ErrorHandlingClient(RpcClient innerClient, CompletableFuture<Void> statusFuture) {
        super(innerClient);
        this.statusFuture = statusFuture;
        this.setHandlers(e -> {
            if (e instanceof YTsaurusError && ((YTsaurusError)e).matches(YTsaurusErrorCode.TableMountInfoNotReady.code)) {
                return false;
            }
            return YTsaurusError.isUnrecoverable((Throwable)e);
        }, e -> {
            logger.debug("Error handling client {} detected fatal error:", (Object)this, e);
            statusFuture.completeExceptionally((Throwable)e);
        });
    }
}

