/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ClientPoolService;
import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.ProxyGetter;
import tech.ytsaurus.core.YtFormat;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeTextSerializer;

@NonNullApi
@NonNullFields
class HttpProxyGetter
implements ProxyGetter {
    private static final int HTTP_PROXY_PORT = 80;
    private static final int HTTPS_PROXY_PORT = 443;
    private static final int TVM_ONLY_HTTP_PROXY_PORT = 9026;
    private static final int TVM_ONLY_HTTPS_PROXY_PORT = 9443;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private final HttpClient httpClient;
    private final String balancerFqdn;
    private final Duration discoverProxiesTimeout;
    @Nullable
    private final Integer balancerPort;
    @Nullable
    private final String role;
    private final boolean useTLS;
    private final boolean tvmOnly;
    private final boolean ignoreBalancers;
    @Nullable
    private final String token;
    @Nullable
    String proxyNetworkName;

    HttpProxyGetter(HttpClient httpClient, ClientPoolService.HttpBuilder httpBuilder) {
        this.httpClient = httpClient;
        this.balancerFqdn = Objects.requireNonNull(httpBuilder.balancerFqdn);
        this.balancerPort = httpBuilder.balancerPort;
        this.discoverProxiesTimeout = Objects.requireNonNull(httpBuilder.options).getProxyUpdateTimeout();
        this.role = httpBuilder.role;
        this.useTLS = httpBuilder.useTLS;
        this.tvmOnly = httpBuilder.tvmOnly;
        this.ignoreBalancers = httpBuilder.ignoreBalancers;
        this.token = httpBuilder.token;
        this.proxyNetworkName = httpBuilder.proxyNetworkName;
    }

    @Override
    public CompletableFuture<List<HostPort>> getProxies() {
        Object discoverProxiesUrl = String.format("%s://%s/api/v4/discover_proxies?type=rpc", this.createScheme(), this.createFqdnWithPort());
        if (this.role != null) {
            discoverProxiesUrl = (String)discoverProxiesUrl + "&role=" + this.role;
        }
        if (this.proxyNetworkName != null) {
            discoverProxiesUrl = (String)discoverProxiesUrl + "&network_name=" + this.proxyNetworkName;
        }
        if (this.tvmOnly) {
            discoverProxiesUrl = (String)discoverProxiesUrl + "&address_type=tvm_only_internal_rpc";
        }
        if (this.ignoreBalancers) {
            discoverProxiesUrl = (String)discoverProxiesUrl + "&ignore_balancers=true";
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create((String)discoverProxiesUrl)).setHeader("X-YT-Header-Format", YTreeTextSerializer.serialize((YTreeNode)YtFormat.YSON_TEXT)).setHeader("X-YT-Output-Format", YTreeTextSerializer.serialize((YTreeNode)YtFormat.YSON_TEXT)).timeout(this.discoverProxiesTimeout);
        if (this.token != null) {
            requestBuilder.setHeader("Authorization", String.format("OAuth %s", this.token));
        }
        CompletableFuture<HttpResponse<InputStream>> responseFuture = this.httpClient.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        CompletionStage resultFuture = responseFuture.thenApply(response -> {
            YTreeNode node;
            if (response.statusCode() != 200) {
                StringBuilder builder = new StringBuilder();
                builder.append("Error: ");
                builder.append(response.statusCode());
                builder.append("\n");
                for (Map.Entry<String, List<String>> entry : response.headers().map().entrySet()) {
                    builder.append(entry.getKey());
                    builder.append("=");
                    builder.append(entry.getValue());
                    builder.append("\n");
                }
                try (InputStream responseBody2 = (InputStream)response.body();){
                    builder.append(new String(responseBody2.readAllBytes()));
                    builder.append("\n");
                }
                catch (IOException responseBody2) {
                    // empty catch block
                }
                throw new RuntimeException(builder.toString());
            }
            try (InputStream responseBody = (InputStream)response.body();){
                node = YTreeTextSerializer.deserialize((InputStream)responseBody);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return node.mapNode().getOrThrow("proxies").asList().stream().map(YTreeNode::stringValue).map(HostPort::parse).collect(Collectors.toList());
        });
        Object finalDiscoverProxiesUrl = discoverProxiesUrl;
        return ((CompletableFuture)resultFuture).handle((arg_0, arg_1) -> HttpProxyGetter.lambda$getProxies$1((String)finalDiscoverProxiesUrl, arg_0, arg_1));
    }

    private String createScheme() {
        if (this.useTLS) {
            return HTTPS_SCHEME;
        }
        return HTTP_SCHEME;
    }

    private String createFqdnWithPort() {
        if (this.balancerPort != null) {
            return this.balancerFqdn + ":" + this.balancerPort;
        }
        int port = this.tvmOnly ? (this.useTLS ? 9443 : 9026) : (this.useTLS ? 443 : 80);
        return String.format("%s:%s", this.balancerFqdn, port);
    }

    private static /* synthetic */ List lambda$getProxies$1(String finalDiscoverProxiesUrl, List result, Throwable error) {
        if (error != null) {
            if (error.getCause() instanceof HttpTimeoutException) {
                error = new TimeoutException("Discover proxies request has timed out").initCause(error);
            }
            throw new RuntimeException("Failed to get proxies from " + finalDiscoverProxiesUrl, error);
        }
        return result;
    }
}

