/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.DataCenterRpcClientPool;
import tech.ytsaurus.client.FilteringRpcClientPool;
import tech.ytsaurus.client.YTsaurusCluster;
import tech.ytsaurus.client.rpc.DataCenterMetricsHolder;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullFields
@NonNullApi
class MultiDcClientPool
implements FilteringRpcClientPool {
    static final Logger logger = LoggerFactory.getLogger(MultiDcClientPool.class);
    final DataCenterRpcClientPool[] clientPools;
    @Nullable
    final DataCenterRpcClientPool localDcPool;
    final DataCenterMetricsHolder dcMetricHolder;

    private MultiDcClientPool(Builder builder) {
        this.clientPools = builder.clientPools.toArray(new DataCenterRpcClientPool[0]);
        if (builder.localDc != null) {
            this.localDcPool = builder.clientPools.stream().filter(pool -> builder.localDc.equals(YTsaurusCluster.normalizeName(pool.getDataCenterName()))).findFirst().orElse(null);
            if (this.localDcPool == null) {
                logger.error("Cannot find local datacenter: {} among: {}", (Object)builder.localDc, builder.clientPools.stream().map(DataCenterRpcClientPool::getDataCenterName).collect(Collectors.toList()));
            }
        } else {
            this.localDcPool = null;
        }
        this.dcMetricHolder = Objects.requireNonNull(builder.dcMetricHolder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public CompletableFuture<RpcClient> peekClient(CompletableFuture<?> releaseFuture, Predicate<RpcClient> filter) {
        if (this.localDcPool != null) {
            CompletableFuture<RpcClient> localClientFuture = this.localDcPool.peekClient(releaseFuture, filter);
            RpcClient localClient = MultiDcClientPool.getImmediateResult(localClientFuture);
            if (localClient != null) {
                return localClientFuture;
            }
            localClientFuture.cancel(true);
        }
        ArrayList<CompletableFuture<RpcClient>> futures = new ArrayList<CompletableFuture<RpcClient>>(this.clientPools.length);
        RpcClient resultClient = null;
        double resultPing = Double.MAX_VALUE;
        for (DataCenterRpcClientPool dc : this.clientPools) {
            CompletableFuture<RpcClient> completableFuture = dc.peekClient(releaseFuture, filter);
            RpcClient client2 = MultiDcClientPool.getImmediateResult(completableFuture);
            if (client2 != null) {
                double currentPing = this.dcMetricHolder.getDc99thPercentile(dc.getDataCenterName());
                if (!(currentPing < resultPing)) continue;
                resultClient = client2;
                resultPing = currentPing;
                continue;
            }
            futures.add(completableFuture);
        }
        if (resultClient != null) {
            for (CompletableFuture completableFuture : futures) {
                completableFuture.cancel(true);
            }
            return CompletableFuture.completedFuture(resultClient);
        }
        CompletableFuture<RpcClient> resultFuture = new CompletableFuture<RpcClient>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        int errorCountLimit = futures.size();
        for (CompletableFuture completableFuture : futures) {
            completableFuture.whenComplete((client, error) -> {
                if (error == null) {
                    resultFuture.complete((RpcClient)client);
                } else if (errorCount.incrementAndGet() == errorCountLimit) {
                    resultFuture.completeExceptionally((Throwable)error);
                }
            });
            resultFuture.whenComplete((client, error) -> future.cancel(true));
        }
        return resultFuture;
    }

    /*
     * WARNING - void declaration
     */
    CompletableFuture<Integer> banClient(String address) {
        void var6_8;
        AtomicInteger total = new AtomicInteger(0);
        ArrayList<CompletableFuture<Integer>> bannedCountList = new ArrayList<CompletableFuture<Integer>>(this.clientPools.length);
        DataCenterRpcClientPool[] dataCenterRpcClientPoolArray = this.clientPools;
        int n = dataCenterRpcClientPoolArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            DataCenterRpcClientPool pool = dataCenterRpcClientPoolArray[var6_8];
            bannedCountList.add(pool.banClient(address));
            ++var6_8;
        }
        CompletableFuture<Object> accumulator = CompletableFuture.completedFuture(null);
        for (CompletableFuture completableFuture : bannedCountList) {
            CompletableFuture[] completableFutureArray = new CompletableFuture[2];
            completableFutureArray[0] = accumulator;
            completableFutureArray[1] = completableFuture.thenApply(total::addAndGet);
            accumulator = CompletableFuture.allOf(completableFutureArray);
        }
        return accumulator.thenApply(ignored -> total.get());
    }

    @Nullable
    private static RpcClient getImmediateResult(CompletableFuture<RpcClient> future) {
        try {
            return future.getNow(null);
        }
        catch (Throwable error) {
            return null;
        }
    }

    @NonNullApi
    @NonNullFields
    static class Builder {
        @Nullable
        String localDc;
        List<DataCenterRpcClientPool> clientPools = new ArrayList<DataCenterRpcClientPool>();
        @Nullable
        DataCenterMetricsHolder dcMetricHolder = null;

        Builder() {
        }

        Builder setLocalDc(@Nullable String localDcName) {
            this.localDc = localDcName;
            return this;
        }

        Builder addClientPool(DataCenterRpcClientPool clientPool) {
            this.clientPools.add(clientPool);
            return this;
        }

        <T extends DataCenterRpcClientPool> Builder addClientPools(Collection<T> pools) {
            this.clientPools.addAll(pools);
            return this;
        }

        Builder setDcMetricHolder(DataCenterMetricsHolder dcMetricHolder) {
            this.dcMetricHolder = dcMetricHolder;
            return this;
        }

        MultiDcClientPool build() {
            return new MultiDcClientPool(this);
        }
    }
}

