/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.BaseYTsaurusClient;
import tech.ytsaurus.client.MultiExecutorMonitoring;
import tech.ytsaurus.client.MultiExecutorRequestTask;
import tech.ytsaurus.client.MultiYTsaurusClient;

class MultiExecutorRequestTask<R> {
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.IN_PROGRESS);
    private final AtomicInteger finishedClientsCount = new AtomicInteger(0);
    private final int clientsCount;
    private final Function<BaseYTsaurusClient, CompletableFuture<R>> callback;
    private final MultiExecutorMonitoring executorMonitoring;
    private final CompletableFuture<R> requestFuture = new CompletableFuture();
    private final List<DelayedSubrequestTask> delayedSubrequestTasks;
    private final Instant requestStartTime = Instant.now();
    private final AtomicBoolean terminateFlag = new AtomicBoolean(false);

    MultiExecutorRequestTask(List<ClientEntry> clients, Function<BaseYTsaurusClient, CompletableFuture<R>> callback, MultiExecutorMonitoring executorMonitoring) {
        this.callback = callback;
        this.executorMonitoring = executorMonitoring;
        this.clientsCount = clients.size();
        this.delayedSubrequestTasks = clients.stream().map(clientEntry -> new DelayedSubrequestTask((ClientEntry)clientEntry)).collect(Collectors.toUnmodifiableList());
        this.requestFuture.whenComplete((value, error) -> {
            this.terminateFlag.set(true);
            if (error != null && this.status.compareAndSet(Status.IN_PROGRESS, Status.CANCELED)) {
                for (DelayedSubrequestTask subrequestTask : this.delayedSubrequestTasks) {
                    subrequestTask.cancel((Throwable)error);
                }
                executorMonitoring.onRequestFailure(Duration.between(this.requestStartTime, Instant.now()), (Throwable)error);
            }
            if (this.status.get().equals((Object)Status.COMPLETED)) {
                for (DelayedSubrequestTask subrequestTask : this.delayedSubrequestTasks) {
                    subrequestTask.suppress();
                }
            }
        });
    }

    CompletableFuture<R> getFuture() {
        return this.requestFuture;
    }

    private synchronized CompletableFuture<R> executeRequest(BaseYTsaurusClient client) {
        return this.callback.apply(client);
    }

    private class DelayedSubrequestTask {
        private final ClientEntry clientEntry;
        @Nullable
        private volatile tech.ytsaurus.client.MultiExecutorRequestTask$DelayedSubrequestTask.SubrequestDescriptor subrequestDescriptor = null;
        private final ScheduledFuture<CompletableFuture<?>> scheduledFuture;

        DelayedSubrequestTask(ClientEntry clientEntry) {
            this.clientEntry = clientEntry;
            this.scheduledFuture = clientEntry.clientOptions.client.getExecutor().schedule(() -> {
                if (MultiExecutorRequestTask.this.terminateFlag.get()) {
                    return CompletableFuture.completedFuture(CompletableFuture.completedFuture(null));
                }
                SubrequestDescriptor localSubrequestDescriptor = new SubrequestDescriptor(Instant.now(), MultiExecutorRequestTask.this.executeRequest(clientEntry.clientOptions.client));
                this.subrequestDescriptor = localSubrequestDescriptor;
                MultiExecutorRequestTask.this.executorMonitoring.onSubrequestStart(clientEntry.clientOptions.getClusterName());
                return localSubrequestDescriptor.callbackFuture.handle((value, error) -> {
                    boolean isLastTask;
                    Instant now = Instant.now();
                    Duration requestCompletionTime = Duration.between(MultiExecutorRequestTask.this.requestStartTime, now);
                    Duration subrequestCompletionTime = Duration.between(localSubrequestDescriptor.startTime, now);
                    boolean bl = isLastTask = MultiExecutorRequestTask.this.finishedClientsCount.incrementAndGet() == MultiExecutorRequestTask.this.clientsCount;
                    if (MultiExecutorRequestTask.this.terminateFlag.get()) {
                        return null;
                    }
                    if (localSubrequestDescriptor.reportedToMonitoring.compareAndSet(false, true)) {
                        if (error == null) {
                            MultiExecutorRequestTask.this.executorMonitoring.onSubrequestSuccess(clientEntry.clientOptions.getClusterName(), subrequestCompletionTime);
                        } else {
                            MultiExecutorRequestTask.this.executorMonitoring.onSubrequestFailure(clientEntry.clientOptions.getClusterName(), subrequestCompletionTime, (Throwable)error);
                        }
                    }
                    if ((error == null || isLastTask) && MultiExecutorRequestTask.this.status.compareAndSet(Status.IN_PROGRESS, Status.COMPLETED)) {
                        if (error == null) {
                            MultiExecutorRequestTask.this.requestFuture.complete(value);
                            MultiExecutorRequestTask.this.executorMonitoring.onRequestSuccess(clientEntry.clientOptions.getClusterName(), requestCompletionTime);
                        } else {
                            MultiExecutorRequestTask.this.requestFuture.completeExceptionally((Throwable)error);
                            MultiExecutorRequestTask.this.executorMonitoring.onRequestFailure(requestCompletionTime, (Throwable)error);
                        }
                    }
                    if (!MultiExecutorRequestTask.this.status.get().equals((Object)Status.CANCELED)) {
                        clientEntry.onFinishRequest(error == null);
                    }
                    return null;
                });
            }, clientEntry.effectivePenalty.toMillis(), TimeUnit.MILLISECONDS);
        }

        void suppress() {
            this.cancel(null);
        }

        void cancel(@Nullable Throwable throwable) {
            tech.ytsaurus.client.MultiExecutorRequestTask$DelayedSubrequestTask.SubrequestDescriptor localSubrequestDescriptor = this.subrequestDescriptor;
            if (localSubrequestDescriptor == null) {
                this.scheduledFuture.cancel(false);
                return;
            }
            localSubrequestDescriptor.callbackFuture.cancel(false);
            if (localSubrequestDescriptor.reportedToMonitoring.compareAndSet(false, true)) {
                Duration completionTime = Duration.between(localSubrequestDescriptor.startTime, Instant.now());
                if (throwable == null) {
                    MultiExecutorRequestTask.this.executorMonitoring.onSubrequestCancelation(this.clientEntry.clientOptions.getClusterName(), completionTime);
                } else {
                    MultiExecutorRequestTask.this.executorMonitoring.onSubrequestFailure(this.clientEntry.clientOptions.getClusterName(), completionTime, throwable);
                }
            }
        }

        private class SubrequestDescriptor {
            Instant startTime;
            CompletableFuture<R> callbackFuture;
            AtomicBoolean reportedToMonitoring = new AtomicBoolean(false);

            SubrequestDescriptor(Instant startTime, CompletableFuture<R> callbackFuture) {
                this.startTime = startTime;
                this.callbackFuture = callbackFuture;
            }
        }
    }

    static class ClientEntry {
        private final MultiYTsaurusClient.YTsaurusClientOptions clientOptions;
        private final Duration effectivePenalty;
        private final Consumer<Boolean> finishRequestConsumer;

        ClientEntry(MultiYTsaurusClient.YTsaurusClientOptions clientOptions, Duration effectivePenalty, Consumer<Boolean> finishRequestConsumer) {
            this.clientOptions = clientOptions;
            this.effectivePenalty = effectivePenalty;
            this.finishRequestConsumer = finishRequestConsumer;
        }

        public void onFinishRequest(Boolean success) {
            this.finishRequestConsumer.accept(success);
        }
    }

    static enum Status {
        IN_PROGRESS,
        COMPLETED,
        CANCELED;

    }
}

