/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class OutageController {
    private final Map<String, Queue<Optional<Throwable>>> requestTypeToErrors = new HashMap<String, Queue<Optional<Throwable>>>();
    private final Map<String, Queue<Duration>> requestTypeToDelays = new HashMap<String, Queue<Duration>>();
    private final Map<GUID, Optional<Throwable>> requestToError = new HashMap<GUID, Optional<Throwable>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageController addFails(String requestType, int count, Throwable exception) {
        OutageController outageController = this;
        synchronized (outageController) {
            for (int idx = 0; idx < count; ++idx) {
                if (!this.requestTypeToErrors.containsKey(requestType)) {
                    this.requestTypeToErrors.put(requestType, new LinkedList());
                }
                this.requestTypeToErrors.get(requestType).add(Optional.of(Objects.requireNonNull(exception)));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageController addOk(String requestType, int count) {
        OutageController outageController = this;
        synchronized (outageController) {
            for (int idx = 0; idx < count; ++idx) {
                if (!this.requestTypeToErrors.containsKey(requestType)) {
                    this.requestTypeToErrors.put(requestType, new LinkedList());
                }
                this.requestTypeToErrors.get(requestType).add(Optional.empty());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageController addDelays(String requestType, int count, Duration delay) {
        OutageController outageController = this;
        synchronized (outageController) {
            for (int idx = 0; idx < count; ++idx) {
                if (!this.requestTypeToDelays.containsKey(requestType)) {
                    this.requestTypeToDelays.put(requestType, new LinkedList());
                }
                this.requestTypeToDelays.get(requestType).add(Objects.requireNonNull(delay));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutageController clear() {
        OutageController outageController = this;
        synchronized (outageController) {
            this.requestTypeToErrors.clear();
            this.requestTypeToDelays.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Duration> pollDelay(String requestType) {
        Duration delay = null;
        OutageController outageController = this;
        synchronized (outageController) {
            if (this.requestTypeToDelays.containsKey(requestType)) {
                delay = this.requestTypeToDelays.get(requestType).poll();
            }
        }
        return delay != null ? Optional.of(delay) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Throwable> pollError(String requestType, GUID requestId) {
        Optional<Throwable> error = Optional.empty();
        OutageController outageController = this;
        synchronized (outageController) {
            if (this.requestToError.containsKey(requestId)) {
                error = this.requestToError.get(requestId);
            } else {
                Optional<Throwable> maybeError;
                if (this.requestTypeToErrors.containsKey(requestType) && (maybeError = this.requestTypeToErrors.get(requestType).poll()) != null) {
                    error = maybeError;
                }
                this.requestToError.put(requestId, error);
            }
        }
        return error;
    }
}

