/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.OutageController;
import tech.ytsaurus.client.OutageRpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcClientWrapper;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpc.TResponseHeader;
import tech.ytsaurus.rpc.TStreamingFeedbackHeader;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;

@NonNullApi
@NonNullFields
class OutageRpcClient
extends RpcClientWrapper {
    final OutageController controller;

    OutageRpcClient(RpcClient innerClient, OutageController controller) {
        super(innerClient);
        this.controller = controller;
    }

    private RpcClientResponseHandler wrapHandler(final RpcClientResponseHandler handler, final String method, final GUID requestId) {
        return new RpcClientResponseHandler(){

            @Override
            public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
                Optional<Throwable> error = Objects.requireNonNull(OutageRpcClient.this.controller.pollError(method, requestId));
                if (error.isEmpty()) {
                    handler.onResponse(sender, header, attachments);
                    return;
                }
                handler.onError(error.get());
            }

            @Override
            public void onError(Throwable error) {
                handler.onError(error);
            }

            @Override
            public void onCancel(CancellationException cancel) {
                handler.onCancel(cancel);
            }
        };
    }

    private RpcStreamConsumer wrapConsumer(final RpcStreamConsumer consumer, final String method, final GUID requestId) {
        return new RpcStreamConsumer(){

            @Override
            public void onStartStream(RpcClientStreamControl control) {
                consumer.onStartStream(control);
            }

            @Override
            public void onFeedback(RpcClient sender, TStreamingFeedbackHeader header, List<byte[]> attachments) {
                Optional<Throwable> error = Objects.requireNonNull(OutageRpcClient.this.controller.pollError(method, requestId));
                if (error.isEmpty()) {
                    consumer.onFeedback(sender, header, attachments);
                    return;
                }
                consumer.onError(error.get());
            }

            @Override
            public void onPayload(RpcClient sender, TStreamingPayloadHeader header, List<byte[]> attachments) {
                Optional<Throwable> error = Objects.requireNonNull(OutageRpcClient.this.controller.pollError(method, requestId));
                if (error.isEmpty()) {
                    consumer.onPayload(sender, header, attachments);
                    return;
                }
                consumer.onError(error.get());
            }

            @Override
            public void onWakeup() {
                consumer.onWakeup();
            }

            @Override
            public void onResponse(RpcClient sender, TResponseHeader header, List<byte[]> attachments) {
                Optional<Throwable> error = Objects.requireNonNull(OutageRpcClient.this.controller.pollError(method, requestId));
                if (error.isEmpty()) {
                    consumer.onResponse(sender, header, attachments);
                    return;
                }
                consumer.onError(error.get());
            }

            @Override
            public void onError(Throwable error) {
                consumer.onError(error);
            }

            @Override
            public void onCancel(CancellationException cancel) {
                consumer.onCancel(cancel);
            }
        };
    }

    @Override
    public RpcClientRequestControl send(RpcClient sender, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        String method = request.header.getMethod();
        Optional<Duration> delay = this.controller.pollDelay(method);
        if (delay.isPresent()) {
            ScheduledFuture<RpcClientRequestControl> task = this.executor().schedule(() -> super.send(sender, request, this.wrapHandler(handler, method, RpcUtil.fromProto((TGuidOrBuilder)request.header.getRequestId())), options), delay.get().toNanos(), TimeUnit.NANOSECONDS);
            return new OutageRpcClientRequestControl(task);
        }
        return super.send(sender, request, this.wrapHandler(handler, method, RpcUtil.fromProto((TGuidOrBuilder)request.header.getRequestId())), options);
    }

    @Override
    public RpcClientStreamControl startStream(RpcClient sender, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options) {
        return super.startStream(sender, request, this.wrapConsumer(consumer, request.header.getMethod(), RpcUtil.fromProto((TGuidOrBuilder)request.header.getRequestId())), options);
    }
}

