/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.BaseYTsaurusClient;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.GetTabletInfos;
import tech.ytsaurus.client.request.MasterReadKind;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.TableReplicaMode;
import tech.ytsaurus.client.request.TabletInfo;
import tech.ytsaurus.client.request.TabletInfoReplica;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public abstract class PenaltyProvider
implements Closeable {
    abstract Duration getPenalty(String var1);

    public static DummyPenaltyProvider.Builder dummyPenaltyProviderBuilder() {
        return new DummyPenaltyProvider.Builder();
    }

    public static LagPenaltyProvider.Builder lagPenaltyProviderBuilder() {
        return new LagPenaltyProvider.Builder();
    }

    @NonNullApi
    @NonNullFields
    public static class LagPenaltyProvider
    extends PenaltyProvider {
        private static final Logger logger = LoggerFactory.getLogger(LagPenaltyProvider.class);
        private final Map<String, ReplicaInfo> replicaClusters;
        private final YPath tablePath;
        private final BaseYTsaurusClient client;
        private final Duration maxTabletLag;
        private final Duration lagPenalty;
        private final double maxTabletsWithLagFraction;
        private final boolean clearPenaltiesOnErrors;
        private final Duration checkPeriod;
        private final CompletableFuture<Void> closed = new CompletableFuture();

        LagPenaltyProvider(Builder builder) {
            Objects.requireNonNull(builder.replicaClusters);
            Objects.requireNonNull(builder.tablePath);
            Objects.requireNonNull(builder.client);
            this.replicaClusters = new HashMap<String, ReplicaInfo>();
            builder.replicaClusters.forEach(cluster -> this.replicaClusters.put((String)cluster, (ReplicaInfo)null));
            this.tablePath = builder.tablePath;
            this.client = builder.client;
            this.maxTabletLag = builder.maxTabletLag;
            this.lagPenalty = builder.lagPenalty;
            this.maxTabletsWithLagFraction = builder.maxTabletsWithLagFraction;
            this.clearPenaltiesOnErrors = builder.clearPenaltiesOnErrors;
            this.checkPeriod = builder.checkPeriod;
            this.client.getExecutor().schedule(this::updateCurrentLagPenalty, 0L, TimeUnit.MILLISECONDS);
        }

        private void updateCurrentLagPenalty() {
            ((CompletableFuture)((CompletableFuture)this.updateReplicaIdsIfNeeded().thenCompose(unused -> this.getTabletsInfo())).thenApply(tabletsInfo -> {
                long totalTabletsCount = tabletsInfo.getTotalNumberOfTablets();
                for (Map.Entry<String, ReplicaInfo> entry : this.replicaClusters.entrySet()) {
                    String cluster = entry.getKey();
                    GUID replicaId = entry.getValue().getReplicaId();
                    long tabletsWithLagCount = tabletsInfo.getNumbersOfTabletsWithLag().getOrDefault(replicaId, 0L);
                    Duration newLagPenalty = this.calculateLagPenalty(totalTabletsCount, tabletsWithLagCount);
                    entry.getValue().setCurrentLagPenalty(newLagPenalty);
                    logger.info("Finish penalty updater check ({}: {}/{} tablets lagging => penalty {} ms) for: {}", new Object[]{cluster, tabletsWithLagCount, totalTabletsCount, newLagPenalty, this.tablePath});
                }
                return null;
            })).handle((unused, ex) -> {
                if (ex != null) {
                    logger.info("Lag penalty updater for {} failed: {}", (Object)this.tablePath, ex);
                    if (this.clearPenaltiesOnErrors) {
                        for (Map.Entry<String, ReplicaInfo> entry : this.replicaClusters.entrySet()) {
                            logger.info("Clearing penalty for cluster {} and table {}", (Object)entry.getValue(), (Object)this.tablePath);
                            entry.getValue().setCurrentLagPenalty(Duration.ZERO);
                        }
                    }
                }
                if (!this.closed.isDone()) {
                    this.client.getExecutor().schedule(this::updateCurrentLagPenalty, this.checkPeriod.toMillis(), TimeUnit.MILLISECONDS);
                }
                return null;
            });
        }

        private Duration calculateLagPenalty(long totalTabletsCount, long tabletsWithLagCount) {
            if ((double)tabletsWithLagCount >= (double)totalTabletsCount * this.maxTabletsWithLagFraction) {
                return this.lagPenalty;
            }
            return Duration.ZERO;
        }

        private CompletableFuture<Void> updateReplicaIdsIfNeeded() {
            try {
                this.checkAllReplicaIdsPresent();
                return CompletableFuture.completedFuture(null);
            }
            catch (UnknownReplicaIdException ex) {
                return this.client.getNode(((GetNode.Builder)((GetNode.Builder)((GetNode.Builder)((GetNode.Builder)GetNode.builder().setPath(this.tablePath)).setAttributes(List.of("replicas"))).setTimeout(Duration.ofSeconds(5L))).setMasterReadOptions(new MasterReadOptions().setReadFrom(MasterReadKind.Cache))).build()).thenApply(node -> {
                    for (Map.Entry row : node.getAttributeOrThrow("replicas").asMap().entrySet()) {
                        String cluster = ((YTreeNode)((YTreeNode)row.getValue()).asMap().get("cluster_name")).stringValue();
                        if (!this.replicaClusters.containsKey(cluster)) continue;
                        this.replicaClusters.put(cluster, new ReplicaInfo(GUID.valueOf((String)((String)row.getKey()))));
                    }
                    this.checkAllReplicaIdsPresent();
                    return null;
                });
            }
        }

        private void checkAllReplicaIdsPresent() {
            for (Map.Entry<String, ReplicaInfo> replica : this.replicaClusters.entrySet()) {
                if (replica.getValue() != null) continue;
                throw new UnknownReplicaIdException("Replica id wasn't found for " + replica.getKey());
            }
        }

        private CompletableFuture<TabletsInfo> getTabletsInfo() {
            return this.client.getNode(((GetNode.Builder)((GetNode.Builder)((GetNode.Builder)((GetNode.Builder)GetNode.builder().setPath(this.tablePath)).setAttributes(List.of("tablet_count"))).setTimeout(Duration.ofSeconds(5L))).setMasterReadOptions(new MasterReadOptions().setReadFrom(MasterReadKind.Cache))).build()).thenCompose(tabletsCountNode -> {
                int tabletsCount = tabletsCountNode.getAttributeOrThrow("tablet_count").intValue();
                return this.client.getTabletInfos(GetTabletInfos.builder().setPath(this.tablePath.toString()).setTabletIndexes(IntStream.range(0, tabletsCount).boxed().collect(Collectors.toList())).build()).thenApply(tabletInfos -> {
                    HashMap<GUID, Long> tabletsWithLag = new HashMap<GUID, Long>();
                    Instant now = Instant.now();
                    for (TabletInfo tabletInfo : tabletInfos) {
                        for (TabletInfoReplica tabletInfoReplica : tabletInfo.getTabletInfoReplicas()) {
                            Instant lastReplicationTimestamp = YtTimestamp.valueOf((long)tabletInfoReplica.getLastReplicationTimestamp()).getInstant();
                            if (!TableReplicaMode.Async.equals((Object)tabletInfoReplica.getMode()) || now.minus(this.maxTabletLag).compareTo(lastReplicationTimestamp) <= 0) continue;
                            tabletsWithLag.merge(tabletInfoReplica.getReplicaId(), 1L, Long::sum);
                        }
                    }
                    return new TabletsInfo(tabletsCount, tabletsWithLag);
                });
            });
        }

        @Override
        Duration getPenalty(String clusterName) {
            if (this.replicaClusters.containsKey(clusterName)) {
                return this.replicaClusters.get(clusterName).getCurrentLagPenalty();
            }
            return Duration.ZERO;
        }

        @Override
        public void close() {
            this.closed.complete(null);
        }

        static class ReplicaInfo {
            private final GUID replicaId;
            private final AtomicLong currentLagPenaltyMillis = new AtomicLong();

            ReplicaInfo(GUID replicaId) {
                this.replicaId = replicaId;
            }

            void setCurrentLagPenalty(Duration currentLagPenalty) {
                this.currentLagPenaltyMillis.set(currentLagPenalty.toMillis());
            }

            public GUID getReplicaId() {
                return this.replicaId;
            }

            public Duration getCurrentLagPenalty() {
                return Duration.ofMillis(this.currentLagPenaltyMillis.get());
            }
        }

        static class TabletsInfo {
            private final long totalNumberOfTablets;
            private final Map<GUID, Long> numbersOfTabletsWithLag;

            TabletsInfo(long totalNumberOfTablets, Map<GUID, Long> numbersOfTabletsWithLag) {
                this.totalNumberOfTablets = totalNumberOfTablets;
                this.numbersOfTabletsWithLag = numbersOfTabletsWithLag;
            }

            long getTotalNumberOfTablets() {
                return this.totalNumberOfTablets;
            }

            Map<GUID, Long> getNumbersOfTabletsWithLag() {
                return this.numbersOfTabletsWithLag;
            }
        }

        @NonNullApi
        @NonNullFields
        public static class Builder {
            @Nullable
            private List<String> replicaClusters;
            @Nullable
            private YPath tablePath;
            @Nullable
            private BaseYTsaurusClient client;
            private Duration maxTabletLag = Duration.ofSeconds(300L);
            private Duration lagPenalty = Duration.ofMillis(10L);
            private double maxTabletsWithLagFraction = 0.05;
            private boolean clearPenaltiesOnErrors = false;
            private Duration checkPeriod = Duration.ofSeconds(60L);

            public Builder setReplicaClusters(List<String> replicaClusters) {
                if (replicaClusters.isEmpty()) {
                    throw new IllegalArgumentException("Got empty list of clusters");
                }
                this.replicaClusters = replicaClusters;
                return this;
            }

            public Builder setTablePath(YPath tablePath) {
                this.tablePath = tablePath;
                return this;
            }

            public Builder setClient(BaseYTsaurusClient client) {
                this.client = client;
                return this;
            }

            public Builder setMaxTabletLag(Duration maxTabletLag) {
                this.maxTabletLag = maxTabletLag;
                return this;
            }

            public Builder setLagPenalty(Duration lagPenalty) {
                this.lagPenalty = lagPenalty;
                return this;
            }

            public Builder setMaxTabletsWithLagFraction(double maxTabletsWithLagFraction) {
                this.maxTabletsWithLagFraction = maxTabletsWithLagFraction;
                return this;
            }

            public Builder setClearPenaltiesOnErrors(boolean clearPenaltiesOnErrors) {
                this.clearPenaltiesOnErrors = clearPenaltiesOnErrors;
                return this;
            }

            public Builder setCheckPeriod(Duration checkPeriod) {
                this.checkPeriod = checkPeriod;
                return this;
            }

            public PenaltyProvider build() {
                return new LagPenaltyProvider(this);
            }
        }

        static class UnknownReplicaIdException
        extends RuntimeException {
            UnknownReplicaIdException(String message) {
                super(message);
            }
        }
    }

    @NonNullApi
    @NonNullFields
    public static class DummyPenaltyProvider
    extends PenaltyProvider {
        DummyPenaltyProvider(Builder builder) {
        }

        @Override
        Duration getPenalty(String clusterName) {
            return Duration.ZERO;
        }

        @Override
        public void close() {
        }

        public static class Builder {
            public PenaltyProvider build() {
                return new DummyPenaltyProvider(this);
            }
        }
    }
}

