/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import tech.ytsaurus.client.BackoffProvider;
import tech.ytsaurus.client.rpc.RpcFailoverPolicy;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.common.YTsaurusErrorCode;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
public abstract class RetryPolicy {
    private RetryPolicy() {
    }

    public static RetryPolicy noRetries() {
        return new NoRetryPolicy();
    }

    public static RetryPolicy defaultPolicy() {
        return new DefaultRetryPolicy();
    }

    public static RetryPolicy retryAll(int attemptLimit) {
        return RetryPolicy.attemptLimited(attemptLimit, new RetryAllPolicy());
    }

    public static RetryPolicy forCodes(Collection<Integer> errorCodes) {
        return new YtErrorRetryPolicy(errorCodes);
    }

    public static RetryPolicy forCodes(Integer ... errorCodes) {
        return RetryPolicy.forCodes(Arrays.asList(errorCodes));
    }

    public static RetryPolicy forCodes(Predicate<Integer> isCodeForRetry) {
        return new YtErrorRetryPolicy(isCodeForRetry);
    }

    public static RetryPolicy fromRpcFailoverPolicy(RpcFailoverPolicy oldPolicy) {
        return new OldFailoverRetryPolicy(oldPolicy);
    }

    public static RetryPolicy attemptLimited(int attemptLimit, RetryPolicy inner) {
        return new AttemptLimitedRetryPolicy(attemptLimit, inner);
    }

    public static RetryPolicy either(RetryPolicy ... retryPolicies) {
        return new EitherRetryPolicy(Arrays.asList(retryPolicies));
    }

    public abstract Optional<Duration> getBackoffDuration(Throwable var1, RpcOptions var2);

    public void onNewAttempt() {
    }

    String getTotalRetryCountDescription() {
        return "<unknown>";
    }

    static class EitherRetryPolicy
    extends RetryPolicy {
        private final List<RetryPolicy> retryPolicies;

        EitherRetryPolicy(List<RetryPolicy> retryPolicies) {
            this.retryPolicies = retryPolicies;
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            for (RetryPolicy retryPolicy : this.retryPolicies) {
                Optional<Duration> backoff = retryPolicy.getBackoffDuration(error, options);
                if (!backoff.isPresent()) continue;
                return backoff;
            }
            return Optional.empty();
        }

        @Override
        public void onNewAttempt() {
            for (RetryPolicy retryPolicy : this.retryPolicies) {
                retryPolicy.onNewAttempt();
            }
        }
    }

    static class RetryAllPolicy
    extends RetryPolicy {
        RetryAllPolicy() {
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            return Optional.of(Duration.ZERO);
        }
    }

    static class NoRetryPolicy
    extends RetryPolicy {
        NoRetryPolicy() {
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            return Optional.empty();
        }
    }

    @NonNullApi
    static class AttemptLimitedRetryPolicy
    extends RetryPolicy {
        private final int attemptLimit;
        private final RetryPolicy inner;
        private int currentAttempt = 0;

        AttemptLimitedRetryPolicy(int attemptLimit, RetryPolicy inner) {
            this.attemptLimit = attemptLimit;
            this.inner = inner;
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            if (this.currentAttempt < this.attemptLimit) {
                return this.inner.getBackoffDuration(error, options);
            }
            return Optional.empty();
        }

        @Override
        public void onNewAttempt() {
            ++this.currentAttempt;
            this.inner.onNewAttempt();
        }

        @Override
        public String getTotalRetryCountDescription() {
            return Integer.toString(this.attemptLimit);
        }
    }

    @NonNullApi
    @NonNullFields
    static class YtErrorRetryPolicy
    extends RetryPolicy {
        private final Predicate<Integer> isCodeForRetry;
        private final BackoffProvider backoffProvider = new BackoffProvider();

        YtErrorRetryPolicy(Collection<Integer> codesToRetry) {
            HashSet<Integer> errorCodesToRetry = new HashSet<Integer>(codesToRetry);
            this.isCodeForRetry = errorCodesToRetry::contains;
        }

        YtErrorRetryPolicy(Predicate<Integer> isCodeForRetry) {
            this.isCodeForRetry = isCodeForRetry;
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            TimeoutException timeoutException = null;
            IOException ioException = null;
            YTsaurusError rpcError = null;
            while (error != null) {
                if (error instanceof TimeoutException) {
                    timeoutException = (TimeoutException)error;
                } else if (error instanceof IOException) {
                    ioException = (IOException)error;
                } else if (error instanceof YTsaurusError) {
                    rpcError = (YTsaurusError)error;
                }
                error = error.getCause();
            }
            if (rpcError != null) {
                if (rpcError.matches(this.isCodeForRetry)) {
                    return Optional.of(this.backoffProvider.getBackoffTime(rpcError, options));
                }
                return Optional.empty();
            }
            if (timeoutException != null) {
                return Optional.of(Duration.ZERO);
            }
            if (ioException != null) {
                return Optional.of(Duration.ZERO);
            }
            return Optional.empty();
        }
    }

    @NonNullApi
    @NonNullFields
    static class DefaultRetryPolicy
    extends RetryPolicy {
        private static final HashSet CODES_FOR_RETRY = new HashSet<Integer>(Arrays.asList(YTsaurusErrorCode.TransactionLockConflict.getCode(), YTsaurusErrorCode.AllWritesDisabled.getCode(), YTsaurusErrorCode.TableMountInfoNotReady.getCode(), YTsaurusErrorCode.TooManyRequests.getCode(), YTsaurusErrorCode.RequestQueueSizeLimitExceeded.getCode(), YTsaurusErrorCode.RpcRequestQueueSizeLimitExceeded.getCode(), YTsaurusErrorCode.TooManyOperations.getCode(), YTsaurusErrorCode.TransportError.getCode(), YTsaurusErrorCode.OperationProgressOutdated.getCode(), YTsaurusErrorCode.Canceled.getCode(), YTsaurusErrorCode.Timeout.getCode()));
        private static final HashSet CHUNK_NOT_RETRIABLE_CODES = new HashSet<Integer>(Arrays.asList(YTsaurusErrorCode.SessionAlreadyExists.getCode(), YTsaurusErrorCode.ChunkAlreadyExists.getCode(), YTsaurusErrorCode.WindowError.getCode(), YTsaurusErrorCode.BlockContentMismatch.getCode(), YTsaurusErrorCode.InvalidBlockChecksum.getCode(), YTsaurusErrorCode.BlockOutOfRange.getCode(), YTsaurusErrorCode.MissingExtension.getCode(), YTsaurusErrorCode.NoSuchBlock.getCode(), YTsaurusErrorCode.NoSuchChunk.getCode(), YTsaurusErrorCode.NoSuchChunkList.getCode(), YTsaurusErrorCode.NoSuchChunkTree.getCode(), YTsaurusErrorCode.NoSuchChunkView.getCode(), YTsaurusErrorCode.NoSuchMedium.getCode()));
        private final RetryPolicy inner = DefaultRetryPolicy.attemptLimited(3, RetryPolicy.forCodes((Integer code) -> CODES_FOR_RETRY.contains(code) || this.isChunkRetriableError((Integer)code)));

        DefaultRetryPolicy() {
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            return this.inner.getBackoffDuration(error, options);
        }

        @Override
        public void onNewAttempt() {
            this.inner.onNewAttempt();
        }

        @Override
        public String getTotalRetryCountDescription() {
            return this.inner.getTotalRetryCountDescription();
        }

        private boolean isChunkRetriableError(Integer code) {
            if (CHUNK_NOT_RETRIABLE_CODES.contains(code)) {
                return false;
            }
            return code / 100 == 7;
        }
    }

    @NonNullApi
    @NonNullFields
    static class OldFailoverRetryPolicy
    extends RetryPolicy {
        private final RpcFailoverPolicy oldPolicy;

        OldFailoverRetryPolicy(RpcFailoverPolicy oldPolicy) {
            this.oldPolicy = oldPolicy;
        }

        @Override
        public Optional<Duration> getBackoffDuration(Throwable error, RpcOptions options) {
            boolean isRetriable = error instanceof TimeoutException || error instanceof YTsaurusError && ((YTsaurusError)error).matches(YTsaurusErrorCode.Timeout.getCode()) ? this.oldPolicy.onTimeout() : this.oldPolicy.onError(error);
            if (isRetriable) {
                return Optional.of(Duration.ZERO);
            }
            return Optional.empty();
        }
    }
}

