/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.Abortable;
import tech.ytsaurus.client.ApiServiceClient;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.Buffer;
import tech.ytsaurus.client.InitResult;
import tech.ytsaurus.client.RawTableWriter;
import tech.ytsaurus.client.RetryingTableWriterImpl;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.client.TableRowsSerializerUtil;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.WriteTask;
import tech.ytsaurus.client.request.CreateNode;
import tech.ytsaurus.client.request.GetNode;
import tech.ytsaurus.client.request.LockNode;
import tech.ytsaurus.client.request.StartTransaction;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.client.rows.EntityTableSchemaCreator;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.request.LockMode;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
class RetryingTableWriterBaseImpl<T> {
    static final Logger logger = LoggerFactory.getLogger(RetryingTableWriterImpl.class);
    final ApiServiceClient apiServiceClient;
    final ScheduledExecutorService executor;
    WriteTable<T> secondaryReq;
    final RpcOptions rpcOptions;
    @Nullable
    TableRowsSerializer<T> tableRowsSerializer;
    final Queue<WriteTask<T>> writeTasks = new ConcurrentLinkedQueue<WriteTask<T>>();
    final Set<Abortable<?>> processing = new HashSet();
    final Queue<CompletableFuture<Void>> handledEvents = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
    final Semaphore semaphore;
    final CompletableFuture<InitResult> init;
    final CompletableFuture<Void> result = new CompletableFuture();
    final CompletableFuture<Void> firstBufferHandled = new CompletableFuture();
    volatile WriteTable<T> req;
    @Nullable
    private volatile Buffer<T> buffer;
    volatile boolean canceled = false;
    volatile boolean closed = false;
    int nextWriteTaskIndex = 0;
    volatile CompletableFuture<Void> readyEvent = CompletableFuture.completedFuture(null);

    RetryingTableWriterBaseImpl(ApiServiceClient apiServiceClient, ScheduledExecutorService executor, WriteTable<T> req, RpcOptions rpcOptions, SerializationResolver serializationResolver) {
        req = this.needSetTableSchema(req) ? this.getRequestWithTableSchema(req) : req;
        this.apiServiceClient = apiServiceClient;
        this.executor = executor;
        this.rpcOptions = rpcOptions;
        this.req = ((WriteTable.Builder)((WriteTable.BuilderBase)req.toBuilder()).setNeedRetries(false)).build();
        this.secondaryReq = ((WriteTable.Builder)((WriteTable.BuilderBase)this.req.toBuilder()).setPath(req.getYPath().append(true))).build();
        YPath path = this.req.getYPath();
        boolean append = path.getAppend().orElse(false);
        LockMode lockMode = append ? LockMode.Shared : LockMode.Exclusive;
        this.semaphore = new Semaphore(this.req.getMaxWritesInFlight());
        StartTransaction.Builder transactionRequestBuilder = StartTransaction.master().toBuilder();
        req.getTransactionId().ifPresent(transactionRequestBuilder::setParentId);
        this.init = apiServiceClient.startTransaction(transactionRequestBuilder.build()).thenCompose(transaction -> {
            CompletableFuture<ApiServiceTransaction> createNodeFuture;
            if (!append) {
                HashMap<String, YTreeNode> attributes = new HashMap<String, YTreeNode>();
                this.req.getTableSchema().ifPresent(schema -> attributes.put("schema", schema.toYTree()));
                createNodeFuture = transaction.createNode(((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)((CreateNode.Builder)CreateNode.builder().setPath(path)).setType(CypressNodeType.TABLE)).setAttributes(attributes)).setIgnoreExisting(true)).build());
            } else {
                createNodeFuture = CompletableFuture.completedFuture(transaction);
            }
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)createNodeFuture.thenCompose(unused -> transaction.lockNode(new LockNode(path, lockMode)))).thenCompose(unused -> transaction.getNode(((GetNode.Builder)((GetNode.Builder)GetNode.builder().setPath(path.justPath())).setAttributes(List.of("schema"))).build()))).thenApply(node -> new InitResult((ApiServiceTransaction)transaction, TableSchema.fromYTree((YTreeNode)node.getAttributeOrThrow("schema"))))).thenApply(result -> {
                this.req.getSerializationContext().getSkiffSerializer().ifPresent(serializer -> serializer.setTableSchema(result.schema));
                if (this.req.getTableSchema().isEmpty() && this.req.getSerializationContext().getSkiffSerializer().isPresent()) {
                    this.req = ((WriteTable.Builder)((WriteTable.BuilderBase)this.req.toBuilder()).setTableSchema(result.schema)).build();
                    this.secondaryReq = ((WriteTable.Builder)((WriteTable.BuilderBase)this.secondaryReq.toBuilder()).setTableSchema(result.schema)).build();
                }
                this.tableRowsSerializer = TableRowsSerializerUtil.createTableRowsSerializer(this.req.getSerializationContext(), serializationResolver).orElse(null);
                if (this.tableRowsSerializer == null) {
                    if (this.req.getSerializationContext().getObjectClass().isEmpty()) {
                        throw new IllegalStateException("No object clazz");
                    }
                    Class<T> objectClazz = this.req.getSerializationContext().getObjectClass().get();
                    this.tableRowsSerializer = UnversionedRow.class.equals(objectClazz) ? new TableRowsWireSerializer<UnversionedRow>(new UnversionedRowSerializer()) : new TableRowsWireSerializer<T>(serializationResolver.createWireRowSerializer(serializationResolver.forClass(objectClazz, result.schema)));
                }
                Buffer<T> firstBuffer = new Buffer<T>(this.tableRowsSerializer);
                firstBuffer.handled.thenRun(() -> this.firstBufferHandled.complete(null));
                this.buffer = firstBuffer;
                return result;
            });
        });
        this.init.handle((initResult, ex) -> {
            if (ex != null) {
                this.cancel();
            }
            return null;
        });
    }

    public TableSchema getSchema() {
        if (this.tableRowsSerializer == null) {
            throw new RuntimeException("No tableRowsSerializer in TableWriter");
        }
        if (this.tableRowsSerializer instanceof TableRowsWireSerializer) {
            return ((TableRowsWireSerializer)this.tableRowsSerializer).getSchema();
        }
        return TableSchema.builder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAbortable(Abortable<?> abortable) {
        boolean wantAbort = false;
        RetryingTableWriterBaseImpl retryingTableWriterBaseImpl = this;
        synchronized (retryingTableWriterBaseImpl) {
            if (this.canceled) {
                wantAbort = true;
            }
            this.processing.add(abortable);
        }
        if (wantAbort) {
            abortable.abort();
            return true;
        }
        return false;
    }

    private synchronized void removeAbortable(Abortable<?> abortable) {
        this.processing.remove(abortable);
    }

    private <R extends Abortable<?>, U> CompletableFuture<U> tryWith(CompletableFuture<R> abortableFuture, Function<R, CompletableFuture<U>> function) {
        return abortableFuture.thenCompose(abortable -> {
            if (this.addAbortable((Abortable<?>)abortable)) {
                return RpcUtil.failedFuture(new IllegalStateException("Already canceled"));
            }
            CompletableFuture functionResult = (CompletableFuture)function.apply(abortable);
            functionResult.whenComplete((res, ex) -> {
                if (ex != null) {
                    abortable.abort();
                }
                this.removeAbortable((Abortable<?>)abortable);
            });
            return functionResult;
        });
    }

    private boolean needSetTableSchema(WriteTable<T> req) {
        return req.getSerializationContext().getSkiffSerializer().isPresent() && req.getYPath().getAppend().orElse(false) == false && req.getTableSchema().isEmpty();
    }

    private WriteTable<T> getRequestWithTableSchema(WriteTable<T> req) {
        return ((WriteTable.Builder)((WriteTable.BuilderBase)req.toBuilder()).setTableSchema(EntityTableSchemaCreator.create(req.getSerializationContext().getObjectClass().orElseThrow(IllegalStateException::new), null))).build();
    }

    private <U> U checkedGet(CompletableFuture<U> future) {
        if (!future.isDone() && future.isCompletedExceptionally()) {
            throw new IllegalArgumentException("internal error");
        }
        return future.join();
    }

    private void processWriteTask(WriteTask<T> writeTask) {
        if (this.canceled) {
            return;
        }
        writeTask.retryPolicy.onNewAttempt();
        GUID parentTxId = this.checkedGet(this.init).transaction.getId();
        CompletableFuture<ApiServiceTransaction> localTransactionFuture = this.apiServiceClient.startTransaction(((StartTransaction.Builder)StartTransaction.master().toBuilder().setParentId(parentTxId)).build());
        this.tryWith(localTransactionFuture, localTransaction -> {
            CompletionStage writerFuture = localTransaction.writeTable(this.req).thenApply(writer -> (RawTableWriter)((Object)writer));
            return this.tryWith((CompletableFuture)writerFuture, (Function)writer -> ((CompletableFuture)((CompletableFuture)writer.readyEvent().thenCompose(unused -> {
                boolean writeResult = writer.write(writeTask.data);
                if (!writeResult) {
                    throw new IllegalStateException("internal error");
                }
                return writer.finish();
            })).thenCompose(unused -> localTransaction.commit())).thenApply(unused -> {
                this.req = this.secondaryReq;
                writeTask.handled.complete(null);
                this.semaphore.release();
                if (!this.writeTasks.isEmpty()) {
                    this.tryStartProcessWriteTask();
                }
                return null;
            }));
        }).handle((unused, ex) -> {
            if (ex == null) {
                return null;
            }
            Optional<Duration> backoff = writeTask.retryPolicy.getBackoffDuration((Throwable)ex, this.rpcOptions);
            if (backoff.isEmpty()) {
                writeTask.handled.completeExceptionally((Throwable)ex);
                this.result.completeExceptionally((Throwable)ex);
                return null;
            }
            logger.debug("Got error, we will retry it in {} seconds, message='{}'", (Object)(backoff.get().toNanos() / 1000000000L), (Object)ex.getMessage());
            this.executor.schedule(() -> this.processWriteTask(writeTask), backoff.get().toNanos(), TimeUnit.NANOSECONDS);
            return null;
        });
    }

    private void tryStartProcessWriteTask() {
        if (!this.semaphore.tryAcquire()) {
            return;
        }
        this.executor.execute(() -> {
            WriteTask<T> writeTask = this.writeTasks.peek();
            if (writeTask == null) {
                this.semaphore.release();
                return;
            }
            if (!this.firstBufferHandled.isDone() && writeTask.index > 0) {
                this.semaphore.release();
                return;
            }
            writeTask = this.writeTasks.poll();
            if (writeTask == null) {
                this.semaphore.release();
                return;
            }
            RetryingTableWriterBaseImpl retryingTableWriterBaseImpl = this;
            synchronized (retryingTableWriterBaseImpl) {
                if (this.canceled) {
                    return;
                }
                if (this.buffer == null && !this.closed) {
                    if (this.tableRowsSerializer == null) {
                        throw new RuntimeException("No tableRowsSerializer in TableWriter");
                    }
                    this.buffer = new Buffer<T>(this.tableRowsSerializer);
                    this.readyEvent.complete(null);
                }
            }
            this.processWriteTask(writeTask);
        });
    }

    private void flushBuffer(boolean lastBuffer) {
        Buffer<T> currentBuffer = this.buffer;
        if (currentBuffer == null) {
            return;
        }
        if (lastBuffer && currentBuffer.size() == 0) {
            this.buffer = null;
            return;
        }
        WriteTask<T> writeTask = new WriteTask<T>(currentBuffer, this.rpcOptions.getRetryPolicyFactory().get(), this.nextWriteTaskIndex++);
        this.writeTasks.add(writeTask);
        this.handledEvents.add(currentBuffer.handled);
        if (!lastBuffer && this.writeTasks.size() <= this.req.getMaxWritesInFlight()) {
            if (this.tableRowsSerializer == null) {
                throw new RuntimeException("No tableRowsSerializer in TableWriter");
            }
            this.buffer = new Buffer<T>(this.tableRowsSerializer);
        } else {
            this.buffer = null;
            this.readyEvent = new CompletableFuture();
        }
        this.tryStartProcessWriteTask();
    }

    public boolean write(List<T> rows, TableSchema schema) {
        if (!this.init.isDone() || this.result.isCompletedExceptionally()) {
            return false;
        }
        if (this.closed || this.canceled) {
            return false;
        }
        Buffer<T> currentBuffer = this.buffer;
        if (currentBuffer == null) {
            return false;
        }
        currentBuffer.write(rows, schema);
        if (currentBuffer.size() >= this.req.getChunkSize()) {
            this.flushBuffer(false);
        }
        return true;
    }

    public CompletableFuture<Void> readyEvent() {
        if (this.result.isCompletedExceptionally()) {
            return this.result;
        }
        return CompletableFuture.anyOf(this.result, CompletableFuture.allOf(this.init, this.readyEvent)).thenCompose(unused -> CompletableFuture.completedFuture(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> close() {
        RetryingTableWriterBaseImpl retryingTableWriterBaseImpl = this;
        synchronized (retryingTableWriterBaseImpl) {
            this.closed = true;
            this.flushBuffer(true);
        }
        return ((CompletableFuture)((CompletableFuture)this.init.thenCompose(initResult -> CompletableFuture.anyOf(this.result, CompletableFuture.allOf(this.handledEvents.toArray(new CompletableFuture[0]))).thenApply(unused -> initResult))).thenCompose(initResult -> initResult.transaction.commit())).whenComplete((unused, ex) -> {
            if (ex != null) {
                this.cancel();
            }
        });
    }

    public CompletableFuture<TableSchema> getTableSchema() {
        return this.init.thenApply(initResult -> initResult.schema);
    }

    public synchronized void cancel() {
        this.canceled = true;
        this.buffer = null;
        this.readyEvent = new CompletableFuture();
        for (Abortable<?> abortable : this.processing) {
            abortable.abort();
        }
        this.init.join().transaction.abort();
    }
}

