/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.request.QueryStatistics;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.ConsumerSourceRet;
import tech.ytsaurus.client.rows.UnversionedRowset;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpcproxy.TRspSelectRows;

@NonNullApi
@NonNullFields
public class SelectRowsResult {
    private static final Logger logger = LoggerFactory.getLogger(SelectRowsResult.class);
    private final RpcClientResponse<TRspSelectRows> response;
    private final Executor heavyExecutor;
    private final SerializationResolver serializationResolver;

    public SelectRowsResult(RpcClientResponse<TRspSelectRows> response, Executor heavyExecutor, SerializationResolver serializationResolver) {
        this.response = response;
        this.heavyExecutor = heavyExecutor;
        this.serializationResolver = serializationResolver;
    }

    public CompletableFuture<UnversionedRowset> getUnversionedRowset() {
        return this.handleResponse(response -> ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments()));
    }

    public <T> CompletableFuture<List<T>> getRowsList(YTreeRowSerializer<T> serializer) {
        return this.handleResponse(response -> {
            ConsumerSourceRet result = ConsumerSource.list();
            ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, result, this.serializationResolver);
            return result.get();
        });
    }

    public <T> CompletableFuture<Void> handleWithConsumer(YTreeRowSerializer<T> serializer, ConsumerSource<T> consumer) {
        return this.handleResponse(response -> {
            ApiServiceUtil.deserializeUnversionedRowset(((TRspSelectRows)response.body()).getRowsetDescriptor(), response.attachments(), serializer, consumer, this.serializationResolver);
            return null;
        });
    }

    public QueryStatistics getQueryStatistics() {
        return new QueryStatistics(this.response.body().getStatistics());
    }

    public boolean isIncompleteOutput() {
        return this.response.body().getStatistics().getIncompleteOutput();
    }

    public boolean isIncompleteInput() {
        return this.response.body().getStatistics().getIncompleteInput();
    }

    private <T> CompletableFuture<T> handleResponse(Function<RpcClientResponse<TRspSelectRows>, T> fn) {
        return RpcUtil.applyAsync(CompletableFuture.completedFuture(this.response), response -> {
            logger.trace("SelectRows incoming rowset descriptor: {}", (Object)((TRspSelectRows)response.body()).getRowsetDescriptor());
            return fn.apply((RpcClientResponse<TRspSelectRows>)response);
        }, this.heavyExecutor);
    }
}

